PROGRAM WG2RA202;

{ this program exports all JAM areas defined in WaterGate's areabase.tdb }
{ to Remote Access 2.02 message.ra file.                                 }

{ RemoteAccess 2.02 is                                                      }
{ Copyrighted 1989-1993 Wantree Development & Andrew Milner                 }

USES Dos,
     Strings;

{$I STRUCTS.PAS}

{ Remote Access message board structure }
TYPE MsgKindsType = (mkBoth, mkPrivate, mkPublic, mkROnly, mkNoReply);
     FlagType     = ARRAY[1..4] OF BYTE;

     MessageRecord = RECORD
                           Unused    : FlagType;
                           Name      : STRING[40];
                           Typ       : BYTE;  { 0=local, 1=net, 2=echo }
                           MsgKinds  : MsgKindsType;
                           Attribute : BYTE;
                           { Bit 0 : Enable EchoInfo
                                 1 : Combined access
                                 2 : File attaches
                                 3 : Allow aliases
                                 4 : Use SoftCRs as characters
                                 5 : Force handle
                                 6 : Allow deletes
                                 7 : Is a JAM area }

                           DaysKill  : BYTE; { Kill older than 'x' days }
                           RecvKill  : BYTE; { Kill recv msgs, recv for more than 'x' days }
                           CountKill : WORD;

                           ReadSecurity   : WORD;
                           ReadFlags,
                           ReadNotFlags   : FlagType;

                           WriteSecurity  : WORD;
                           WriteFlags,
                           WriteNotFlags  : FlagType;

                           SysopSecurity  : WORD;
                           SysopFlags,
                           SysopNotFlags  : FlagType;

                           OriginLine     : STRING[60];
                           AkaAddress     : BYTE;

                           Age            : BYTE;

                           JAMbase        : STRING[60];
                           Group          : WORD;
                           AltGroup       : ARRAY[1..3] OF WORD;

                           Attribute2     : BYTE;
                           { Bit 0 : Include in all groups }

                           FreeSpace2     : ARRAY[1..9] OF BYTE;
                     END;

{--------------------------------------------------------------------------}
{ Convert                                                                  }
{                                                                          }
PROCEDURE Convert (TargetFilename : STRING);

    PROCEDURE ClearFlag (Flag : FlagType);
    BEGIN
         Flag[1]:=0;
         Flag[2]:=0;
         Flag[3]:=0;
         Flag[4]:=0;
    END;

VAR AreaFile  : FILE;
    IORes     : BYTE;
    Header    : STRING;
    OutFile   : FILE;
    AreaRec   : AreaBaseRecord;
    MsgRec    : MessageRecord;
    Found     : BOOLEAN;
    AddCount  : WORD;
    BytesRead : WORD;

BEGIN
     Assign (AreaFile,'AREABASE.TDB');
     {$I-} Reset (AreaFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (#7'  Cannot open AREABASE.TDB (error ',IORes,')');
          Exit;
     END;

     BlockRead (AreaFile,Header,26);
     IF (Header <> AreaBaseHeader) THEN
     BEGIN
          WriteLn (#7,'  Unsupported format of AREABASE.TDB');
          Close (AreaFile);
          Exit;
     END;

     Assign (OutFile,TargetFilename);
     {$I-} Reset (OutFile,1); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (OutFile,1); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (#7'  Cannot access/create ',TargetFilename,' (error ',IORes,')');
          Close (AreaFile);
          Exit;
     END;

     WriteLn ('Output to '+TargetFilename);

     Found:=FALSE;
     WHILE (FilePos (OutFile) < FileSize (OutFile)) DO
     BEGIN
          BlockRead (OutFile,MsgRec,SizeOf (MessageRecord));

          IF (MsgRec.Typ = 1{echo}) AND
             (MsgRec.Attribute >= 128) THEN
          BEGIN
               WriteLn ('Using defaults from record found in output file');
               Found:=TRUE;
               Break;
          END;
     END;

     IF (NOT Found) THEN
     BEGIN
          WriteLn ('Using built-in defaults for new records');

          { initialise the Message Record fields that will always default }
          { to some hard-coded values, unless an other record is found in }
          { the file we are going to append to.                           }
          ClearFlag (MsgRec.Unused);
          MsgRec.Typ:=1; { echo only }
          MsgRec.MsgKinds:=mkPublic;
          MsgRec.Attribute:=1{EchoInfo}+64+{Allow Delete}+128{IsJAM};
          MsgRec.ReadSecurity:=20;
          MsgRec.WriteSecurity:=20;
          MsgRec.SysopSecurity:=65535;
          ClearFlag (MsgRec.ReadFlags);
          ClearFlag (MsgRec.ReadNotFlags);
          ClearFlag (MsgRec.WriteFlags);
          ClearFlag (MsgRec.WriteNotFlags);
          ClearFlag (MsgRec.SysopFlags);
          ClearFlag (MsgRec.SysopNotFlags);
          MsgRec.AkaAddress:=0; { Main Aka }
          MsgRec.Age:=0;
          MsgRec.Group:=1;
          MsgRec.AltGroup[1]:=0;
          MsgRec.AltGroup[2]:=0;
          MsgRec.AltGroup[3]:=0;
          MsgRec.Attribute2:=0;
     END;

     Seek (Outfile,FileSize (OutFile)); { for appending }

     AddCount:=0;
     WHILE (FilePos (AreaFile) < FileSize (AreaFile)) DO
     BEGIN
          BlockRead (AreaFile,AreaRec,SizeOf (AreaBaseRecord),BytesRead);

          IF (BytesRead <> SizeOf (AreaBaseRecord)) THEN
             Break; { uit de while }

          WITH AreaRec DO
          BEGIN
               IF (NOT Deleted) AND
                  (AreaType = 0{echo}) AND
                  (FidoMsgStyle = 3{jam}) THEN
               BEGIN
                    MsgRec.Name:=AreaName_F;

                    IF (FidoMsgAge > 255) THEN
                       FidoMsgAge:=255;

                    MsgRec.DaysKill:=FidoMsgAge;
                    MsgRec.RecvKill:=FidoMsgAge;
                    MsgRec.CountKill:=FidoMsgLimit;

                    IF (OriginNr = 0{custom}) THEN
                       MsgRec.OriginLine:=Origin
                    ELSE
                        MsgRec.OriginLine:='This system uses WaterGate';

                    MsgRec.JamBase:=FidoMsgPath;

                    BlockWrite (OutFile,MsgRec,SizeOf (MessageRecord));
                    Inc (AddCount);

               END; { if }
          END; { with }
     END;

     Close (OutFile);
     Close (AreaFile);

     WriteLn ('Done. Added ',AddCount,' records');
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }
BEGIN
     WriteLn ('WaterGate v0.93(+?) to Remote Access 2.02 convertor');
     WriteLn ('Copyright (c) 1996 Waterline Software Development V.O.F.');
     WriteLn;
     IF (ParamCount <> 1) THEN
     BEGIN
          WriteLn ('This program exports all the JAM bases defined in WaterGate''s');
          WriteLn ('AREABASE.TDB file to a MESSAGES.RA file for Remote Access 2.02');
          WriteLn;
          WriteLn ('Usage:   WG2RA202 <output file>');
          WriteLn ('Example: WG2RA202 MESSAGES.RA');
          WriteLn;
          WriteLn ('The AREABASE.TDB file must be present in the current directory.');
          WriteLn ('If a given output file is already present then the records');
          WriteLn ('will be appended. All JAM records are always exported.');
          WriteLn;
          Halt;
     END;

     Convert (FExpand (ParamStr (1)));
END.
