/*****************************************************************************/
/* FEEDREQ.CMD : Feed Request (v0.5)                                         */
/*                                                                           */
/* This script read the file UUCPREQ.LST WaterGate/2 makes when it needs to  */
/* send a new feedrequest to your uucp-uplink. If your uplink needs a        */
/* feedrequest with a list of all newsgroups you want in your feed, you can  */
/* use this script to make such a list. Xs4All's autofeed works that way,    */
/* but there are more.                                                       */
/*                                                                           */
/* First of all make a list of all newsgroups you are connected to (this is  */
/* only needed for the first time). Give this file the name UUxxxxxx.LST     */
/* where 'xxxxxx' are the first 6 characters of the name of your uucp-uplink */
/* you use in the configs of WaterGate/2. Edit your toss-batches/command     */
/* in a way that they will trigger (if exist ....... call .....) the file    */
/* UUCPREQ.LST. If that file exist, start this script.                       */
/*                                                                           */
/* FEEDREQ.CMD will then read the information in UUCPREQ.LST and update your */
/* UUxxxxxx.LST file by removing/adding newsgroups. The name used on 'xxxxxx'*/
/* is also gathered from UUCPREQ.LST, so this script wil also work if you    */
/* more uucp-uplinks (just do the step for making the UUxxxxxx.LST for the   */
/* first time for every uplink then).                                        */
/*                                                                           */
/* Last but not least the script will make a semaphore in your semaphore dir */
/* named FEEDREQ.FLG. From within the batch/command file for calling your    */
/* uplink, first check if the file FEEDREQ.FLG exists (if exist ....). If so */
/* start a utility which will post an e-mail or netmail and import the file  */
/* UUxxxxxx.LST into the body of that message. Remember, you have to take    */
/* of the posting, this script will only make a list to import into that     */
/* message. Also remember that if you post it as a netmail, you also have to */
/* run WaterGate/2 again to gate the netmail to e-mail, before you really    */
/* start calling your uplink.                                                */
/*                                                                           */
/* Author: Jos Huijnen                     E-Mail : jos@snake.xs4all.nl      */
/*                                                  the_snake@compuserve.com */
/*                                CompuServe Mail : 101350,1074              */
/*                              Fidonet (Netmail) : 2:284/312                */
/*****************************************************************************/

arg x
parse upper var x wgdir semadir

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

'@echo off'

if wgdir='' | semadir='' then
do
   say ''
   say ''
   say 'You didn''t specify the drive/path to WaterGate or the drive/path'
   say 'to your semaphore dir.'
   say ''
   say '     Usage   : FEEDREQ [drive]:\[wgdir] [drive]:\[semaphoredir]'
   say '     Example : FEEDREQ C:\WTRGATE C:\TEMP\SEMAPHOR'
   say ''
   exit
end
if substr(wgdir,length(wgdir))<>'\' then wgdir=wgdir || '\'
if substr(semadir,length(semadir))<>'\' then semadir=semadir || '\'
eof=lines(wgdir || 'UUCPREQ.LST')
do while (eof<>0)
   tmptext=linein(wgdir || 'UUCPREQ.LST')
   text=translate(tmptext,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
   uplink=delstr(text,pos(',',text))
   if length(uplink)>6 then filename='UU' || delstr(uplink,7)
   else filename='UU' || uplink
   tmpecho=substr(text,pos(',',text)+1)
   doecho=delstr(tmpecho,2)
   echoname=substr(tmpecho,2)
   wgfile=wgdir || filename
   if doecho='-' then
   do
      eof1=lines(wgfile || '.LST')
      do while (eof1<>0)
         tmpfeed=linein(wgfile || '.LST')
         feed=translate(tmpfeed,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
         if feed<>echoname then rc=lineout(wgfile || '.NEW',feed)
         eof1=lines(wgfile || '.LST')
      end
      call lineout(wgfile || '.LST')
      call lineout(wgfile || '.NEW')
      'DEL ' || wgfile || '.LST'
      'REN ' || wgfile || '.NEW ' || filename || '.LST'
   end
   if doecho='+' then rc=lineout(wgfile || '.ADD',echoname)
   eof=lines(wgdir || 'UUCPREQ.LST')
end
call lineout(wgdir || 'UUCPREQ.LST')
'DEL ' || wgdir || 'UUCPREQ.LST'
call lineout(wgfile || '.ADD')
if lines(wgfile || '.ADD')<>0 then
do
   eof=lines(wgfile || '.LST')
   do while (eof<>0)
      feedin=linein(wgfile || '.LST')
      rc=lineout(wgfile || '.NEW',feedin)
      eof=lines(wgfile || '.LST')
   end
   eof=lines(wgfile || '.ADD')
   do while (eof<>0)
      feedin=linein(wgfile || '.ADD')
      rc=lineout(wgfile || '.NEW',feedin)
      eof=lines(wgfile || '.ADD')
   end
   call lineout(wgfile || '.ADD')
   call lineout(wgfile || '.LST')
   call lineout(wgfile || '.NEW')
   'DEL ' || wgfile || '.ADD'
   'DEL ' || wgfile || '.LST'
   'SORT <' || wgfile || '.NEW >' || wgfile || '.LST'
   'DEL ' || wgfile || '.NEW'
end
rc=lineout(semadir || 'FEEDREQ.FLG','')
call SysDropFuncs
