<?php
/*
 * ----------------------------------------------------------------------------
 * Todays_Callers.php                                                02/15/2006
 * Display todays callers of the BBS to the mobile device.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Mobile: Viewing Today\'s Callers';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php');
require_once($includeDir . 'va-main.inc.php');
require_once($includeDir . 'va-misc.inc.php');

$todaysCallers = GetTodaysCallers();

include_once('wml_header.php');
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="Today's Callers">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Today's Callers</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?><br />
            <small><?php print UserDate("m/d/y g:ia"); ?></small>
        </p>
        <p mode="nowrap">

            <?php
            if ($todaysCallers[0] == 0) {
                print "No callers today.<br />\n";
            } else {
                for ($x = 1; $x <= $todaysCallers[0]; $x++) {
                    $todaysCallers[$x]['channel'] = (integer) substr($todaysCallers[$x]['channel'], 2);
                    if ($todaysCallers[$x]['channel'] == 0) {
                        $todaysCallers[$x]['channel'] = '--';
                    }
                    print '[' . $todaysCallers[$x]['time'] . '][' . str_pad($todaysCallers[$x]['channel'], 2, '0', STR_PAD_LEFT) . '] <b>' . WMLSpecialChars($todaysCallers[$x]['handle']) . '</b> (#' . $todaysCallers[$x]['userno'] . ")<br />\n";
                }
            }
            ?>

        </p>
        <?php
        if ($todaysCallers[0] > 0) {
        ?>
        <p mode="nowrap">
            <small><b>Total: <?php print $todaysCallers[0]; ?></b></small>
            <br />
        </p>
        <?php
        }
        ?>
        <p mode="nowrap">
            <anchor>Back<go href="index.php" /></anchor>
        </p>
        <?php include('mobile_footer.php'); ?>
    </card>

</wml>