<?php
/*
 * ----------------------------------------------------------------------------
 * TopTen.php                                                        10/14/2006
 * This script will display the top ten users in a variety of categories.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing Top Ten List';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-stats.inc.php');     // Include statistics.

$topten = UserStats(254);                   // Get the user stats (not the sysops).

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Top Ten List] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  2004, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .footer            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
    .header            { font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #FFFF00; font-weight: bold; font-style: italic }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .subHeader         { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000">

<p class="title" align="right">Virtual Advanced Top Ten List
<hr color="#525552">
<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a> </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Callers</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Calls</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['totalcalls'][0] < 10) {
    $max = $topten['totalcalls'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['totalcalls'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['totalcalls'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['totalcalls'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['totalcalls'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Time Users</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Minutes</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['totaltime'][0] < 10) {
    $max = $topten['totaltime'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['totaltime'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['totaltime'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['totaltime'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['totaltime'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Message Posters</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Messages</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['totalposts'][0] < 10) {
    $max = $topten['totalposts'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['totalposts'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['totalposts'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['totalposts'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['totalposts'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Emailers</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Emails</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['totalemail'][0] < 10) {
    $max = $topten['totalemail'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['totalemail'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['totalemail'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['totalemail'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['totalemail'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Downloaders</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Files</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['dlfiles'][0] < 10) {
    $max = $topten['dlfiles'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['dlfiles'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['dlfiles'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['dlfiles'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['dlfiles'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Downloaders by KB</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                KB</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['dlkb'][0] < 10) {
    $max = $topten['dlkb'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['dlkb'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['dlkb'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['dlkb'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['dlkb'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Uploaders</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Files</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['uplfiles'][0] < 10) {
    $max = $topten['uplfiles'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['uplfiles'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['uplfiles'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['uplfiles'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['uplfiles'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<br />

<div align="center">
    <table border="0" cellpadding="0" cellspacing="10">
        <tr class="header">
            <td colspan="4" align="left">Top Uploaders by KB</td>
        </tr>
        <tr class="subHeader">
            <td width="40" align="right" valign="top" style="border-bottom: 1px solid #525552">
                #</td>
            <td width="60" align="right" valign="top" style="border-bottom: 1px solid #525552">
                User #</td>
            <td width="230" align="left" valign="top" style="border-bottom: 1px solid #525552">
                Handle</td>
            <td width="120" align="left" valign="top" style="border-bottom: 1px solid #525552">
                KB</td>
        </tr>
        <tr class="body">
            <td align="right" valign="top">
<?php
if ($topten['uplkb'][0] < 10) {
    $max = $topten['uplkb'][0];
} else {
    $max = 10;
}
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FF5552">' . $x . '</span><br />' . "\n";
}
?>
            </td>
            <td align="right" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #5255FF">' . $topten['uplkb'][$x]['userno'] . '</span><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<a href="userinfo.php?u=' . $topten['uplkb'][$x]['userno'] . '"><span style="color: #FFFFFF">' . HtmlSpace($topten['uplkb'][$x]['handle']) . '</span></a><br />' . "\n";
}
?>
            </td>
            <td align="left" valign="top">
<?php
for ($x = 1; $x <= $max; $x++) {
    print '<span style="color: #FFFF52">' . $topten['uplkb'][$x]['value'] . '</span><br />' . "\n";
}
?>
            </td>
        </tr>
    </table>
</div>
<?php GlobalFooter(1); ?>

</body>

</html>