<?php
/*
 * ----------------------------------------------------------------------------
 * System_News.php                                                   10/14/2006
 * This script contains functions that work with AT2k scripts and programs.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Reading System News';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'at2k.inc.php');         // Include AT2k functions.

if (!$CONFIG['sysnews']) {
    die('<br /><h4>This script has been disabled. Press the BACK button on your browser.</h4>');
}

if (isset($_GET['m'])) {
    $m = (integer) $_GET['m'];
} else {
    $m = FALSE;
}

$sysnews = GetSysNewsConfig();              // Get the Sysnews configuration.

if (!$sysnews) {
    die('<br /><h4>The System News script is not installed. Press the BACK button on your browser.</h4>');
}

$db = GetDbInfo($sysnews['topicno'], $sysnews['db']);
$msgPointer = GetMessagePointer($db, $USER['userno']);

$file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
$fileString = ReadCfgFile($file);

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[System News] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.body:link        { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
    a.body:visited     { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.show:link        { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; }
    a.show:visited     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .date              { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #666666; }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .msgHead           { font-family: Courier New;               font-size: 10pt; color: #5255FF; font-weight: bold }
    .msgHead2          { font-family: Courier New;               font-size: 10pt; color: #FFFFFF; font-weight: bold }
    .time              { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #ADAAAD; }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight: bold; font-style: italic }
-->
</style>
</head>

<body bgcolor="#000000">


<p class="title" align="right">Aspect Technologies System News
<hr color="#525552">

<?php
if ($m != FALSE) {
    $msgInfo = GetMessageInfo($db, $m, $fileString);    // Get message information.
    $message = FixHeartColors(StripRouting(chr(3) . '0' . GetMessage($db, $m, 0, '', $msgInfo)));   // Get the message.
    $dateTime = ConvertDateTime($msgInfo['creation'], 'F j, Y');

    // Update message pointer if needed.
    if ($msgPointer < $m) {
        WriteMessagePointer($db, $USER['userno'], $m);
    }
?>
<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="system_news.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <table border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td class="msgHead2" width="750" height="30" align="left">
                <span class="msgHead">From: </span><?php print $msgInfo['fromhandle']; ?><br />
                <span class="msgHead">Subject: </span><?php print $msgInfo['subject']; ?><br />
                <?php print $dateTime['date'] . '&nbsp;&nbsp;' . $dateTime['time']; ?>
            </td>
        </tr>
        <tr>
            <td class="body" width="750" align="left">
            <br />
            <pre><?php print $message; ?></pre>
            </td>
        </tr>
    </table>
</div>
<?php
} else {
?>
<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <table cellpadding="0" cellspacing="0">
        <?php
        if ($db['msgno'] == 0) {
            print '<tr><td><span class="body">There are no notices at this time.</span></td></tr>' . "\n";
        } else {
            for ($x = 1; $x <= $db['msgno']; $x++) {
                $msgInfo = GetMessageInfo($db, $x, $fileString);    // Get message information.
                $dateTime = ConvertDateTime($msgInfo['creation'], 'F j, Y');
                if ($msgInfo['deleted'] == 0) {                     // If not deleted..
        ?>
        <tr>
            <td class="body" width="30" align="center" height="30" nowrap>
                <?php
                if ($msgPointer < $x) {
                    print '<img border="0" src="' . $rootDir . 'images/votebox.gif" width="15" height="15" alt="Unread Notice">' . "\n";
                } else {
                    print '<img border="0" src="' . $rootDir . 'images/votebox-filled.gif" width="15" height="15" alt="Read Notice">' . "\n";
                }
                ?>
            </td>
            <td class="boldBody" width="540" height="30" align="left">
                <?php print $msgInfo['subject']; ?>
            </td>
            <td class="date" width="130" height="30" align="center" nowrap>
                <?php print '&nbsp;' . $dateTime['date'] . '<br />&nbsp;<span class="time">' . $dateTime['time'] . '</span>'; ?>
            </td>
            <td width="50" height="30" align="right">
                <a class="body" href="system_news.php?m=<?php print $x; ?>"><img border=0" src="<?php print $rootDir; ?>images/view.gif" width="45" height="25" alt="View System Notice"></a>
            </td>
        </tr>
        <?php
                }
            }
        }
        ?>
    </table>
</div>

<?php
}
GlobalFooter(1);
?>

</body>

</html>