<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Misc.inc.php                                                   07/16/2006
 * This script contains miscellaneous functions.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-stats.inc.php');     // BBS stats.


/**
* Va-Misc.inc.php :: GetNetworkCallers()
*
* This function will read the netcalls.lst file and break it down and store its
* information into an array.
*
* @return array
*/
function GetNetworkCallers() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the default variable.
    $netcalls[0] = 0;

    // Set the filename.
    $file = $VA_SYSPATHS['data'] . '/NETCALLS.LST';
    if (!is_file($file)) {
        return $netcalls;
    }
    $file = file($file);                    // Read the file into an array.

    for ($x = 0; $x < count($file); $x++) {
        $netcalls[$x + 1]['callno']   = trim(substr($file[$x], 2, 7));
        $netcalls[$x + 1]['nodeno']   = trim(substr($file[$x], 16, 8));
        $netcalls[$x + 1]['network']  = trim(substr($file[$x], 28, 30));
        $netcalls[$x + 1]['channel']  = trim(substr($file[$x], 60, 5));
        $netcalls[$x + 1]['time']     = trim(substr($file[$x], 68, 5));
        $netcalls[$x + 1]['baudrate'] = trim(StripBBSCodes(substr($file[$x], 77, 8)));
        if ($netcalls[$x + 1]['baudrate'] == '0') {
            $netcalls[$x + 1]['baudrate'] = 'Local';
        }
        if ($netcalls[$x + 1]['baudrate'] == '11520') {
            $netcalls[$x + 1]['baudrate'] = '115200';
        }
    }

    $netcalls[0] = $x;                       // Put the number of callers in position 0.

    return $netcalls;                        // Return the network callers.
}


/**
* Va-Misc.inc.php :: GetTodaysCallers()
*
* This function will read the callers.lst file and break it down and store its
* information into an array.
*
* @return array
*/
function GetTodaysCallers() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the default variable.
    $callers[0] = 0;

    // Set the filename.
    $file = $VA_SYSPATHS['data'] . '/CALLERS.LST';
    if (!is_file($file)) {
        return $callers;
    }
    $file = file($file);                    // Read the file into an array.

    for ($x = 0; $x < count($file); $x++) {
        $callers[$x + 1]['callno']   = trim(substr($file[$x], 2, 7));
        $callers[$x + 1]['userno']   = trim(substr($file[$x], 16, 8));
        $callers[$x + 1]['handle']   = trim(substr($file[$x], 28, 30));
        $callers[$x + 1]['channel']  = trim(substr($file[$x], 60, 5));
        $callers[$x + 1]['time']     = trim(substr($file[$x], 68, 5));
        $callers[$x + 1]['baudrate'] = trim(StripBBSCodes(substr($file[$x], 77)));
        if ($callers[$x + 1]['baudrate'] == '0') {
            $callers[$x + 1]['baudrate'] = 'Local';
        }
        if ($callers[$x + 1]['baudrate'] == '11520') {
            $callers[$x + 1]['baudrate'] = '115200';
        }
    }

    $callers[0] = $x;                       // Put the number of callers in position 0.

    return $callers;                        // Return today's callers.
}


/**
* Va-Misc.inc.php :: WriteTodaysCallers()
*
* This function will write a new entry to the callers.lst file using the current
* user's information. This function is used only for adding web users entries,
* and NOT to add a BBS user's entry (which is done by the BBS anyway).
*
* The id can be set to a one character identifier to seperate different login
* methods.
*
* @return mixed
*/
function WriteTodaysCallers($id = '') {
    if (!is_string($id)) {
        $id = (string) $id;
    }

    $id = trim($id);
    if (strlen($id) > 1) {
        $id = substr($id, 0, 1);
    }

    global $VA_SYSPATHS;                    // Include the system paths.
    global $USER;                           // Include the user's information.

    $stats        = GetStats();
    $callerNumber = str_pad($stats['webcallstotal'], 7, ' ', STR_PAD_LEFT);
    $userNo       = str_pad($USER['userno'], 9);
    $handle       = str_pad($USER['handle'], 30);
    $channel      = str_pad('Web', 6);
    $time         = date('H') . ':' . date('i') . ' ';
    $baud         = str_pad('VADV-PHP' . $id, 9);

    $line = chr(3) . '2'  . $callerNumber    // Create the line.
          . chr(3) . '5: '
          . chr(3) . '7#' . $userNo
          . chr(3) . '5 ' . $handle
          . chr(3) . '1'  . $channel
          . chr(3) . '6'  . $time
          . chr(3) . '5 ' . $baud
          . chr(3) . '0'
          . "\r\n";

    $file = $VA_SYSPATHS['data'] . '/CALLERS.LST';
    $fp = fopen($file, 'a');                // Open the file.
    flock($fp, 2);                          // Lock the file.
    
    $status = fwrite($fp, $line);           // Write the new line.

    flock($fp, 3);                          // Unlock the file.
    fclose($fp);                            // Close the file.

    return $status;                         // Return the write status.
}

?>