<?php
/*
 * ----------------------------------------------------------------------------
 * Va-LoginAuth.inc.php                                              07/30/2006
 * This script will check the user's session data and determine if he is logged
 * in already. If not, then the user is given guest values.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-userfile.inc.php');  // Get user information.
require_once($includeDir . 'va-stats.inc.php');     // BBS stats.
require_once($includeDir . 'va-misc.inc.php');
require_once($includeDir . 'vadv-php_dat.inc.php');

$_SESSION['auth']  = FALSE;
$_SESSION['error'] = FALSE;

// Default Guest Account Settings
$USER['userno']        = 0;
$USER['handle']        = 'Guest';
$USER['realname']      = 'Guest User';
$USER['address']       = '';
$USER['city']          = '';
$USER['state']         = '';
$USER['zipcode']       = '';
$USER['phone1']        = '';
$USER['phone2']        = '';
$USER['password']      = '';
$USER['mailfwdflag']   = 0;
$USER['mailfwdhandle'] = '';
$USER['mailfwduserno'] = 0;
$USER['mailfwdnode']   = 0;
$USER['mailfwdnetno']  = 0;
$USER['lngdistcost']   = 0;
$USER['lngdistacc']    = 0;
$USER['sortfilelst']   = 0;
$USER['pagebreak']     = 24;
$USER['bdaymonth']     = 0;
$USER['bdayday']       = 0;
$USER['bdayyear']      = 0;
$USER['age']           = $CONFIG['userage'];
$USER['accflags']      = $CONFIG['useraccflags'];
$USER['flags']         = '';
$USER['securitylevel'] = $CONFIG['usersl'];
$USER['laston']        = date("ymd");
$USER['maxtime']       = 60;
$USER['timecounter']   = 0;
$USER['totalcalls']    = 0;
$USER['totaltime']     = 0;
$USER['videomode']     = 1;
$USER['ratioexempt']   = 0;
$USER['verifybday']    = 0;
$USER['textcolor']     = chr(7);
$USER['basecolor']     = chr(0);
$USER['prmptcolor']    = chr(2);
$USER['inputcolor']    = chr(5);
$USER['boxcolor']      = chr(5);
$USER['mnuselcolor']   = chr(1);
$USER['headercolor']   = chr(2);
$USER['extra1']        = '';
$USER['extra2']        = '';
$USER['extra3']        = '';
$USER['extra4']        = '';
$USER['extra5']        = '';
$USER['extra6']        = '';
$USER['extra7']        = '';
$USER['extra8']        = '';
$USER['macro1']        = '';
$USER['macro2']        = '';
$USER['uplfiles']      = 0;
$USER['uplkb']         = 0;
$USER['dlfiles']       = 0;
$USER['dlkb']          = 0;
$USER['totalposts']    = 0;
$USER['totalemail']    = 0;
$USER['postsread']     = 0;
$USER['timebank']      = 0;
$USER['credits']       = 0;
$USER['comment']       = '';
$USER['protocol']      = 'Z';
$USER['testid1']       = '';
$USER['testid2']       = '';
$USER['offsym']        = '';
$USER['expdate']       = '';
$USER['reserved']      = '';
$USER['lastcalltime']  = time();
$USER['liststyle']     = 2;
$USER['extra']         = '';

// If the guest account is set, then make that the guest settings. It cannot be user 1!
if ((($CONFIG['guestacct'] != '') ||
     ($CONFIG['guestacct'] > 0)) &&
    ($CONFIG['guestacct'] != 1)) {
    $USER = GetUser($CONFIG['guestacct']);
}

// If the session does not exist, check for the VADVPHP cookie and create the session variables.
if ((!isset($_SESSION['userno'])) &&
    (isset($_COOKIE['vadvphp'])) &&
    (trim($_COOKIE['vadvphp']) != '')) {
    list($cookie['userno'], $cookie['username'], $cookie['password']) = explode(' , ', $_COOKIE['vadvphp']);
    $_SESSION['userno']   = $cookie['userno'];
    $_SESSION['username'] = $cookie['username'];
    $_SESSION['password'] = $cookie['password'];
}

// If the session exists, then get the user's information.
if (isset($_SESSION['userno'])) {
    $userno   = (integer) base64_decode($_SESSION['userno']);     // Decode user number.
    $username = (string)  base64_decode($_SESSION['username']);   // Decode user name.
    $password = (string)  base64_decode($_SESSION['password']);   // Decode password.
    if ($userno > 0) {
        if ($CONFIG['banned'] != '') {                  // Check for banned accounts.
            $banned = explode(',', $CONFIG['banned']);
            if (count($banned) > 0) {
                for ($x = 0; $x < count($banned); $x++) {
                    if ($userno == trim($banned[$x])) {
                        $_SESSION['error'] = TRUE;
                        break;
                    }
                }
            }
        }
        if (!$_SESSION['error']) {                      // If no error so far...
            $userchk = GetUser($userno);                // Get user information.
            $userdat = GetUserSettings($userno);        // Get user setttings.
            if ($userdat['password'] == '') {
                $userpw = $userchk['password'];
            } else {
                $userpw = $userdat['password'];
            }
            if (($password === $userpw) && // Compare user passwords - they must be IDENTICAL.
                ($userchk['securitylevel'] > 0)) {      // Security level must be greater than zero.
                $USER = $userchk;
                $_SESSION['auth'] = TRUE;
            } else {
                $_SESSION['error'] = TRUE;
            }
        }
    } else {
        $_SESSION['error'] = TRUE;
    }
}

// Log the attempted login.
if ((isset($_SESSION['login'])) && ($_SESSION['login'])) {
    if (!$_SESSION['error']) {                      // Successful...
        if ($USER['securitylevel'] < 255) {
            $stats = GetStats();                    // Get the current stats.
            if (!$stats['webcallstotal']) {
                $stats['webcallstotal'] = 0;
            }
            $stats['webcallstotal']++;              // Increase the web calls.
            $stats['callstoday']++;                 // Increase today's calls.
            $fileString = ReadStats();              // Read the stats.
            $fileString = PutStats($fileString, $stats);
            WriteStats($fileString);                // Write the new file.
            if ((isset($_SESSION['mobile'])) && ($_SESSION['mobile'] == TRUE)) {
                WriteTodaysCallers('m');            // Update the today's callers file for mobile users.
            } else {
                WriteTodaysCallers();               // Update the today's callers file for normal users.
            }
        } else {
            $stats = GetStats();
            if (!$stats['webcallstotal']) {
                $stats['webcallstotal'] = 0;
            }
        }
        $USER['laston'] = date("ymd");              // Set last on to current date.
        $USER['totalcalls']++;                      // Increase the user's total calls.
        $USER['lastcalltime'] = time();             // Set to current date/ time in UNIX time.
        $fileString = ReadUserfile();               // Read the userfile.
        $fileString = PutUser($fileString, $USER['userno'], $USER);
        WriteUserfile($fileString);                 // Write the userfile.
        if ((isset($_SESSION['mobile'])) && ($_SESSION['mobile'] == TRUE)) {
            $log = 'Mobile Login    "' . $username . '" - SUCCESSFUL! (' . $stats['webcallstotal'] . ')';
        } else {
            $log = 'Attempted Login "' . $username . '" - SUCCESSFUL! (' . $stats['webcallstotal'] . ')';
        }
        WriteLog('VADV-PHP.LOG', $log, 102400);     // Log the login attempt.
        $_SESSION['login'] = FALSE;
    } else {                                        // Failed...
        if ((isset($_SESSION['mobile'])) && ($_SESSION['mobile'] == TRUE)) {
            $log = 'Mobile Login    "' . $username . '" - FAILED!';
        } else {
            $log = 'Attempted Login "' . $username . '" - FAILED!';
        }
        WriteLog('VADV-PHP.LOG', $log, 102400);     // Log the login attempt.
        $_SESSION['login'] = FALSE;
    }
}

if (($USER['userno'] > 0) && ($USER['laston'] != date("ymd"))) {
    $USER['laston'] = date("ymd");
    $USER['timecounter'] = 0;
    $USER['lastcalltime'] = time();
    $fileString = ReadUserfile();
    $fileString = PutUser($fileString, $USER['userno'], $USER);
    WriteUserfile($fileString);
}
?>