<?php
/*
 * ----------------------------------------------------------------------------
 * Common.inc.php                                                    04/29/2006
 * This script contains various settings that are initiated for every VADV-PHP
 * script. You should include va-functions.inc.php instead of including this
 * file directly.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

ob_start();                                     // Turn on buffering.
//ob_start('ob_handler');                       // Turn on buffering with error handling.

ini_set('session.name', 'vadvphp_session');     // A VADV-PHP session.
ini_set('session.use_cookies', 1);              // Turn on cookies for sessions.
ini_set('session.cache_limiter', '');           // Set the cache limiter to nothing.

if (!isset($TIMEOUT)) {
    $TIMEOUT = 900;
}
ini_set('session.cookie_lifetime', $TIMEOUT);   // Set cookie lifetime.

session_start();                                // Start the session.
setcookie(session_name(), session_id(),
          time() + $TIMEOUT, '/', '', 0);       // This makes sure the cookie is updated.
                                                // It wasn't updating when the session started.

$startTime = ProgramTime();                     // Begin recording the execution time.

if (ini_get('max_execution_time') < 120) {      // Set max execution time.
    ini_set('max_execution_time', 120);
}
ini_set('memory_limit', '8M');                  // Set max memory limit.
ini_set('display_errors', 1);                   // Display errors. They will be handled
                                                // by the two error handling functions.

ini_set('magic_quotes_runtime', 0);             // Fix magic quotes.
if (get_magic_quotes_gpc()) {
    if (isset($_POST)) {
        $_POST = Array_StripSlashes($_POST);
    }
    if (isset($_GET)) {
        $_GET = Array_StripSlashes($_GET);
    }
    if (isset($_COOKIES)) {
        $_COOKIES = Array_StripSlashes($_COOKIES);
    }
}


/**
* Common.inc.php :: ob_handler()
*
* This function handles fatal errors.
*
* @param string $buffer
* @return string
*/
function ob_handler($buffer) {
    if (!is_string($buffer)) {
        $buffer = (string) $buffer;
    }

    global $VERSION;
    global $DEBUG_MAIL;
    global $DEBUG_EMAIL;
    global $DEBUG_SMTP_SERVER;

    $phpVersion  = phpversion();
    $temp_buffer = $buffer;

    if ((preg_match('/<b>Fatal error<\/b>: .+ in <b>.+?<\/b> on line <b>\d+<\/b><br \/>/', $temp_buffer, $matches))) {
        // Send an email to the VADV-PHP bug report address.
        if ($DEBUG_MAIL == TRUE) {
            if (gethostbyname($DEBUG_SMTP_SERVER) != $DEBUG_SMTP_SERVER) {
                ini_set('SMTP', $DEBUG_SMTP_SERVER);
                ini_set('sendmail_from', $DEBUG_EMAIL);
                $headers  = "Date: " . date("r") . "\r\n";
                $headers .= "Reply-To: " . $DEBUG_EMAIL . "\r\n";
                $headers .= "MIME-Version: 1.0\r\n";
                $headers .= "Content-Type: text/plain; charset=us-ascii\r\n";
                $headers .= "Content-Transfer-Encoding: 7bit\r\n";
                $headers .= "X-Sender: Bug Report<" . $DEBUG_EMAIL . ">\r\n";
                $headers .= "X-Mailer: PHP/" . $phpVersion . "\r\n";
                $headers .= "X-Priority: 3\r\n";
                $headers .= "Return-Path: <" . $DEBUG_EMAIL . ">\r\n";

                mail($DEBUG_EMAIL,
                     '[FATAL] VADV-PHP ERROR (' . $VERSION . ')',
                     'http://' . $_SERVER['SERVER_NAME'] . "\n" . strip_tags($matches[0]) . "\n\nPHP Version: " . $phpVersion,
                     $headers);
                ini_restore('SMTP');
                ini_restore('sendmail_from');
            }
        }

        // Replace the buffer.
        $temp_buffer = <<<EOD
<h2>Unable to display page.</h2>
<p>
An error occurred while processing your request. The site administrator has been notified.
</p>
<p>
We apologize for the inconvenience.
</p>
EOD;
    }

    return $temp_buffer;
}

?>