<?php
/*
 * ----------------------------------------------------------------------------
 * UserEditor_Help.php                                               10/14/2006
 * SysOp User Editor Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>User Editor Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="userno" />
<p>
    <span style="color: #FFFFFF"><b>User Number</b></span>
    <br />
    The user's user number. This cannot be changed.
</p>

<a name="delete" />
<p>
    <span style="color: #FFFFFF"><b>Delete this User</b></span>
    <br />
    You may click this link if you wish to delete this user account. This is
    non-reversible! Once you delete the account, then the user's email, voting
    records, and all other statistics will be deleted as well.
</p>

<a name="handle" />
<p>
    <span style="color: #FFFFFF"><b>Handle</b></span>
    <br />
    This is the user's user name. Only the SysOp may change this value. If the
    user wishes to have the handle changed, then he/she would have to inform
    the SysOp.
</p>

<a name="realname" />
<p>
    <span style="color: #FFFFFF"><b>Real Name</b></span>
    <br />
    The user's real name.
</p>

<a name="address" />
<p>
    <span style="color: #FFFFFF"><b>Address</b></span>
    <br />
    The user's street address.
</p>

<a name="city" />
<p>
    <span style="color: #FFFFFF"><b>City</b></span>
    <br />
    The user's city of residence.
</p>

<a name="state" />
<p>
    <span style="color: #FFFFFF"><b>State</b></span>
    <br />
    The user's state of residence.
</p>

<a name="zipcode" />
<p>
    <span style="color: #FFFFFF"><b>Zip Code</b></span>
    <br />
    The user's zip code.
</p>

<a name="phone1" />
<p>
    <span style="color: #FFFFFF"><b>Phone Number</b></span>
    <br />
    The user's telephone number, including the area code.
</p>

<a name="phone2" />
<p>
    <span style="color: #FFFFFF"><b>Data/Fax Number</b></span>
    <br />
    The user's data or fax telephone number, including the area code.
</p>

<a name="bday" />
<p>
    <span style="color: #FFFFFF"><b>Birthday</b></span>
    <br />
    The user's birthdate in the format MM/DD/YYYY.
</p>

<a name="bbspassword" />
<p>
    <span style="color: #FFFFFF"><b>BBS Password</b></span>
    <br />
    You may change the user's password. Be sure to notify the user of the
    change or he/she will not be able to login. The password can be up to
    eight characters long.
</p>

<a name="webpassword" />
<p>
    <span style="color: #FFFFFF"><b>VADV-PHP Password</b></span>
    <br />
    You may change the user's VADV-PHP password. Be sure to notify the user of the
    change or he/she will not be able to login. The password can be up to
    32 characters long.
</p>

<a name="resetwebpassword" />
<p>
    <span style="color: #FFFFFF"><b>Reset VADV-PHP Password</b></span>
    <br />
    This will reset the user's VADV-PHP. The user will have to use their BBS
    password to login to the web front-end.
</p>

<a name="laston" />
<p>
    <span style="color: #FFFFFF"><b>Last Online</b></span>
    <br />
    The date that the user has last logged into the system.
</p>

<a name="securitylevel" />
<p>
    <span style="color: #FFFFFF"><b>Security Level</b></span>
    <br />
    You may increase or decrease the user's security level. By increasing it,
    you would be giving more access priviledges to the user, whereas decreasing
    it would take away access priviledges.
</p>

<a name="maxtime" />
<p>
    <span style="color: #FFFFFF"><b>Time per Day</b></span>
    <br />
    This is the maximum amount of time that the user may spend on the BBS. It is
    represented in minutes. Note that this has no effect on VADV-PHP. This
    setting was created so you could limit the amount of time the user could
    tie up your phone line, but since most BBSs are now online, you could set
    this field to 1440 (24 hours) so there is no limitation.
</p>

<a name="timeleft" />
<p>
    <span style="color: #FFFFFF"><b>Time Left Today</b></span>
    <br />
    This is the amount of time the user has left to spend on the BBS today. It
    is represented in minutes. Note that this has no effect on VADV-PHP.
</p>

<a name="timebank" />
<p>
    <span style="color: #FFFFFF"><b>Time Bank</b></span>
    <br />
    You can edit the amount of time that the user has stored in the built-in
    time bank. This value is represented in minutes.
</p>

<a name="credits" />
<p>
    <span style="color: #FFFFFF"><b>Credits</b></span>
    <br />
    You may add or subtract credits from the user's account. Credits can be
    used so users have to "pay" for access to certain areas. For example if you
    ran a credit based system, you could make users post messages to gain
    credits to use to download files.
</p>

<a name="flags" />
<p>
    <span style="color: #FFFFFF"><b>User Flags</b></span>
    <br />
    The user flags are used to give access to system functions, for example, the
    flag "F" represents the full screen editor in the BBS. If enabled, the user
    can use the full screen editor, if not, then the line editor is used. You
    can use flags to limit which networks the user can access as well.
    <br /><br />
    To add a flag, just type the letter of the flag. There should be no spaces
    between flags.
</p>

<a name="accflags" />
<p>
    <span style="color: #FFFFFF"><b>Access Flags</b></span>
    <br />
    The access flags are used to give access to areas. For example, you could
    set a message area to be accessed by only users with the access flag "A".
    Another example is if you wanted to limit certain doors to certain users.
    <br /><br />
    To add an access flag, just type the letter of the flag. There should be no
    spaces between flags.
</p>

<a name="pagebreak" />
<p>
    <span style="color: #FFFFFF"><b>Page Break Length</b></span>
    <br />
    You may change the number of lines to be displayed before a pause is
    displayed to the user. This is generally up to the user depending on what
    client they are using.
</p>

<a name="videomode" />
<p>
    <span style="color: #FFFFFF"><b>Video Mode</b></span>
    <br />
    This determines what kind of graphics the user is set to view:
    <br />
    0 - ASCII
    <br />
    1 - ANSI
    <br />
    2 - ANSI Enhanced (Pull Down Menus)
    <br />
    3 - RIP Graphics
    <br />
    4 - Virtual Windows Client
</p>

<a name="protocol" />
<p>
    <span style="color: #FFFFFF"><b>Default Xfer Protocol</b></span>
    <br />
    This sets the default transfer protocol to use when uploading and downloading.
    It should be a one character identifier for the protocol as defined in the
    protocol section of VConfig.
</p>

<a name="liststyle" />
<p>
    <span style="color: #FFFFFF"><b>File List Type</b></span>
    <br />
    The user can view the file listing in three different ways: Single Line -
    each file and its information is shown on a single line; Double Line -
    the file information is displayed on one line and short description is on
    a second; Double Line w/ Ext - Same as double line, but it also displays
    the long description.
</p>

<a name="sortfilelst" />
<p>
    <span style="color: #FFFFFF"><b>Sort File Listing</b></span>
    <br />
    If this is enabled, then the user will view the file listing in
    alphabetical order, otherwise the listing will be in the order in which
    they were uploaded to the system.
</p>

<a name="ratioexempt" />
<p>
    <span style="color: #FFFFFF"><b>Ratio Exempt</b></span>
    <br />
    If this is enabled, then the user does not have to obey any file upload/
    download ratio defined in the main configuration of VConfig.
</p>

<a name="verifybday" />
<p>
    <span style="color: #FFFFFF"><b>Verify Birthday</b></span>
    <br />
    If this is enabled, then the next time the user logs into the BBS, he/she
    will be asked to re-enter their birthdate.
</p>

<a name="mailfwd" />
<p>
    <span style="color: #FFFFFF"><b>Forward Email Address</b></span>
    <br />
    This can be set to forward any local email to another email address, which
    could be another local account or a network email address. To do so, enter
    an email address in the format of username@system, which could look like
    an Internet email address (someone@domain.com) or a FidoNet email address
    (someone@1:18/15) or any other network. Then select the network in which
    to use to deliver the message.
</p>

<a name="extra" />
<p>
    <span style="color: #FFFFFF"><b>Extra Values</b></span>
    <br />
    You can edit the user's extra values. These values can be used for anything
    and are generally used to store additional information about the user, or
    used to store information for scripts to access.
</p>

<a name="comment" />
<p>
    <span style="color: #FFFFFF"><b>Optional User Comment</b></span>
    <br />
    This user comment can be anything you desire. It has no effect on the BBS,
    and appears to not be used for anything. VADV-PHP will enter a value in
    this field if the user registered online instead of the BBS.
</p>

<a name="totalcalls" />
<p>
    <span style="color: #FFFFFF"><b>Total Number of Calls</b></span>
    <br />
    This value stores the number of times the user has logged into the system.
</p>

<a name="totaltime" />
<p>
    <span style="color: #FFFFFF"><b>Total Time Online</b></span>
    <br />
    This value stores the total number of minutes the user has spent online the
    BBS.
</p>

<a name="uplfiles" />
<p>
    <span style="color: #FFFFFF"><b>Uploaded Files</b></span>
    <br />
    This value stores the number of files that the user has uploaded to the
    system.
</p>

<a name="uplkb" />
<p>
    <span style="color: #FFFFFF"><b>Uploaded KB</b></span>
    <br />
    This value stores the number of kilobytes that the user has uploaded to the
    system.
</p>

<a name="dlfiles" />
<p>
    <span style="color: #FFFFFF"><b>Downloaded Files</b></span>
    <br />
    This value stores the number of files that the user has downloaded from the
    system.
</p>

<a name="dlkb" />
<p>
    <span style="color: #FFFFFF"><b>Downloaded KB</b></span>
    <br />
    This value stores the number of kilobytes that the user has downloaded from
    the system.
</p>

<a name="totalposts" />
<p>
    <span style="color: #FFFFFF"><b>Number of Posts</b></span>
    <br />
    This value stores the number of messages that the user has posted to the
    system.
</p>

<a name="totalemail" />
<p>
    <span style="color: #FFFFFF"><b>Number of Emails</b></span>
    <br />
    This value stores the number of emails that the user has sent from the
    system.
</p>
</body>

</html>