<?php
/*
 * ----------------------------------------------------------------------------
 * EditUser_Help.php                                                 10/14/2006
 * Edit User Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Editing User Profile';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>Edit User Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="userno" />
<p>
    <span style="color: #FFFFFF"><b>User Number</b></span>
    <br />
    This is the user number that was assigned to you when you registered. It
    cannot be changed.
</p>

<a name="handle" />
<p>
    <span style="color: #FFFFFF"><b>Handle</b></span>
    <br />
    This is the user name that you chose when you registered. You cannot change
    it, but if you would like it to be changed, then email the SysOp.
</p>

<a name="realname" />
<p>
    <span style="color: #FFFFFF"><b>Real Name</b></span>
    <br />
    This should be your real name. You may change it for purposes such as
    marriage. Note that if you enter invalid or false information, that your
    account could be suspended or deleted.
</p>

<a name="address" />
<p>
    <span style="color: #FFFFFF"><b>Address</b></span>
    <br />
    This is your street address. You may change it in case you move to a new
    location.
</p>

<a name="city" />
<p>
    <span style="color: #FFFFFF"><b>City</b></span>
    <br />
    The city name of which you live. You may change it in case you move to a
    new location.
</p>

<a name="state" />
<p>
    <span style="color: #FFFFFF"><b>State</b></span>
    <br />
    The state or province name of which you live. You may change it in case you
    move to a new location.
</p>

<a name="zipcode" />
<p>
    <span style="color: #FFFFFF"><b>Zip Code</b></span>
    <br />
    Your zip code. You may change it in case you move to a new location.
</p>

<a name="phone1" />
<p>
    <span style="color: #FFFFFF"><b>Phone Number</b></span>
    <br />
    Your telephone number including area code. You may change it in case you
    change your number.
</p>

<a name="phone2" />
<p>
    <span style="color: #FFFFFF"><b>Data/Fax Number</b></span>
    <br />
    Your data or fax telephone number. You may change it in case you change
    your number.
</p>

<a name="bbspassword" />
<p>
    <span style="color: #FFFFFF"><b>BBS Password</b></span>
    <br />
    You may change your account password. It can be up to eight characters in
    length. Make your password something that is not guessable that contains
    both numbers and letters. You will have to enter the password twice in order
    to verify that it is what you want.
</p>

<a name="webpassword" />
<p>
    <span style="color: #FFFFFF"><b>VADV-PHP Password</b></span>
    <br />
    You can create or change your VADV-PHP password. It can be up to 32
    characters in length. Make your password something that is not guessable
    that contains both numbers and letters. You will have to enter the password
    twice in order to verify that it is what you want. If you have no VADV-PHP
    password, then your VADV-PHP password is your BBS password.
</p>

<a name="resetwebpassword" />
<p>
    <span style="color: #FFFFFF"><b>Reset VADV-PHP Password</b></span>
    <br />
    If you wish to use the same password for both the BBS and the web front-end,
    then you can enable this option and it will erase your VADV-PHP password.
</p>

<a name="timezone" />
<p>
    <span style="color: #FFFFFF"><b>User Time Zone</b></span>
    <br />
    You may set your timezone here in relation to GMT. The times that are
    displayed will be altered to reflect your local time.
</p>

<a name="htmlencode" />
<p>
    <span style="color: #FFFFFF"><b>HTML Encoding</b></span>
    <br />
    The HTML encoding feature automatically creates links in message text in
    certain areas (e.g. email messages, file descriptions). You may choose
    between basic encoding or enhanced encoding. Basic encoding will only
    create links for common URL types, such as HTTP, FTP and TELNET. Enhanced
    encoding will create links for various other URL types that may or may not
    work properly due to your operating system, system configuration and
    programs installed. Examples of enhanced encoding are NNTP and AIM.
</p>

<a name="tagline" />
<p>
    <span style="color: #FFFFFF"><b>Auto-Signature</b></span>
    <br />
    You can select which user macro to use as your automated signature for any
    emails or messages you post.
</p>

<a name="mailfwd" />
<p>
    <span style="color: #FFFFFF"><b>Forward Mail Address</b></span>
    <br />
    You are able to forward your BBS email to another email address. The
    address you want to forward to can be to a local account, or you can
    specify a network address to send it to.
    <br /><br />
    To forward email, first enter the address you would like to send it to.
    This is in the format of username@system. For example, you could send it
    to an Internet address like someone@domain.com, or a FidoNet address like
    someone@1:18/15.
    <br /><br />
    After you have entered the address to send it to, then select the network
    appropriate for the address. It will use that network to attempt to deliver
    the email.
    <br /><br />
    Note: ONLY email sent to you locally is forwarded. Any email you receive
    to this account through a network will not be forwarded, but will remain
    on this system for you to read.
</p>
</body>

</html>