<?php
/*
 * ----------------------------------------------------------------------------
 * Subscribe.php                                                     08/02/2006
 * This script will allow the user to join or ignore subs in the new message
 * scans.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Changing Subscription';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include the main configuration variable.
require_once('layout_subscribe.inc.php');           // Webpage header and footer.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = (integer) $_GET['t'];
} else {
    $t = 1;
}

if ($t < 1) {
    $t = 1;
}

// Check for cancel button.
if ((isset($_POST['submit'])) && ($_POST['submit'] == 'Cancel')) {
    RedirectUser('forum-dispdb.php?t=' . $t);
}

$topic = GetTopicInfo($t, 'M');             // Get the topic information.
// If this is an invalid section, display an error message.
if (!$topic) {
    die('<br /><h4>Invalid topic. Please press the BACK button on your browser.</h4>');
}
// Determine if the user has access to this section.
if ($topic['dbno'] == 0) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

// Set the fileString variable.
$file = $VA_SYSPATHS['main'] . '/DATABASE.CFG';
if (!is_file($file)) {
    die('<br /><h4>Requested configuration file is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.

if ((isset($_POST['subscribeform'])) && (($_POST['subscribeform'] == 1))) {
    if (isset($_POST['markedsubs'])) {
        $marked = $_POST['markedsubs'];
    } else {
        $marked = array('');
    }

    for ($x = 1; $x <= $topic['dbno']; $x++) {
        $found = FALSE;
        for ($y = 0; $y < count($marked); $y++) {
            if ($marked[$y] == $x) {
                $found = TRUE;
                break;
            }
        }

        $db = GetDbInfo($t, $x, $fileString);
        $ptr = GetMessagePointer($db, $USER['userno']);

        if ($found) {
            if ($ptr >= 32760) {
                WriteMessagePointer($db, $USER['userno'], 1);
            }
        } else {
            if ($ptr < 32760) {
                WriteMessagePointer($db, $USER['userno'], 32760);
            }
        }
    }
}

if (trim($topic['desc']) != '') {
    $topicDesc = htmlspecialchars($topic['desc']);
} else {
    $topicDesc = '(No Topic Description)';
}

SubscribeHeader();

?>

<script language="JavaScript" type="text/javascript">
<!--
    var status = "false";
    function CheckBox(name) {
        if (status == "false") {
            for (i = 0; i < document.subscribe.elements.length; i++) {
                if (document.subscribe.elements[i].name == name) {
                    document.subscribe.elements[i].checked = true;
                    status = "true";
                }
            }
        } else {
            for (i = 0; i < document.subscribe.elements.length; i++) {
                if (document.subscribe.elements[i].name == name) {
                    document.subscribe.elements[i].checked = false;
                    status = "false";
                }
            }
        }
    }
//-->
</script>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="forum-dispdb.php?t=<?php print $topic['topicno']; ?>">Back to <?php print $topicDesc; ?></a>&nbsp;
            <a class="msgBack" title="Back to Topics" href="forum-disptopics.php">&lt;--</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="4" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;<?php print HtmlSpace($topicDesc); ?></span></td>
                </tr>
            </table>
        </td>
    </tr>
    <form name="subscribe" method="post" action="subscribe.php?t=<?php print $t; ?>">
    <input type="hidden" name="subscribeform" value="1">
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080" align="center">
            <input name="allbox" type="checkbox" onclick="CheckBox('markedsubs[]');" title="Select or De-select All Subs"></td>
        <td class="msgHeader" width="525" height="15" bgcolor="#000080" align="left">&nbsp;Forum&nbsp;</td>
        <td class="msgHeader" width="50" height="15" bgcolor="#000080" align="center">&nbsp;Posts&nbsp;</td>
        <td class="msgHeader" width="145" height="15" bgcolor="#000080" align="center">&nbsp;Moderator&nbsp;</td>
    </tr>

<?php
$flag = 1;
for ($x = 1; $flag <= $topic['dbno']; $x++) {
    $db = GetDbInfo($t, $x, $fileString);   // Retrieve the database information.
    $last = GetLastPostInfo($db);           // Retrieve the last post information of the database.
    $dateTime = ConvertDateTime($last['creation']);

    if (strlen($db['desc']) >= 31) {
        $db['desc'] = $db['desc'] . '...';
    }

    $moderator = '';
    if ($db['moderator'] != 0) {            // If there is a moderator, get the handle.
        $user = GetUser($db['moderator']);
        $moderator = htmlspecialchars($user['handle']);
    }

    $msgno = $db['msgno'];                  // Get the number of messages in the database.
    if (!$msgno) {
        $msgno = 0;                         // If there is no file, then there is no messages.
    }

    if (DbAccess($db)) {
        $flag++;

        if (trim($db['desc']) != '') {
            $dbDesc = htmlspecialchars($db['desc']);
        } else {
            $dbDesc = '(No Description)';
        }
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center">
        <input type="checkbox" name="markedsubs[]" value="<?php print $x; ?>" <?php
                                                                              if (GetMessagePointer($db, $USER['userno']) < 32760) {
                                                                                  print 'checked';
                                                                              }
                                                                              ?>></td>
        <td width="525" height="30" align="left">
            <span class="heading">&nbsp;<?php
                                        if ($db['networked']) {
                                            print '<img src="' . $rootDir . 'images/networked.gif" alt="Networked Database" width="12" height="11">&nbsp;';
                                        } else {
                                            print '<img src="' . $rootDir . 'images/local.gif" alt="Local Database" width="12" height="11">&nbsp;';
                                        }
                                        if ($msgno > 0) {
                                            print '<a href="forum-dispmsg.php?t=' . $t . '&d=' . $x . '">';
                                        }
                                        print HtmlSpace($dbDesc);
                                        if ($msgno > 0) {
                                            print '</a>';
                                        }
                                        ?>&nbsp;</span></td>
        <td width="50" height="30" bgcolor="#E2E2E2" align="center">
            <span class="msgBody">&nbsp;<?php print $msgno; ?>&nbsp;</span></td>
        <td width="145" height="30" align="center">
            <span class="body"><?php print HtmlSpace($moderator); ?></span></td>
    </tr>

<?php
    }
}
?>

    <tr>
        <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="4" height="25" width="750">&nbsp;</td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse">
    <tr>
        <td class="msgBack" align="left">
            <a class="msgBack" href="forum-dispdb.php?t=<?php print $topic['topicno']; ?>">Back to <?php print $topicDesc; ?></a>&nbsp;
            <a class="msgBack" title="Back to Topics" href="forum-disptopics.php">&lt;--</a></td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="4" width="100%" style="border-collapse: collapse">
    <tr>
        <td align="right" width="50%">
            <input type="submit" value="Submit" name="submit">
        </td>
</form>
<form name="cancel" method="POST" action="subscribe.php?t=<?php print $t; ?>">
        <td align="left" width="50%">
            <input type="submit" value="Cancel" name="submit">
        </td>
</form>
    </tr>
</table>

<?php

SubscribeFooter();

?>