<?php
/*
 * ----------------------------------------------------------------------------
 * Layout_Search.inc.php                                             10/14/2006
 * This script contains the headers and footers used with the search script.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include the main BBS configuration.


/**
* Layout_Forum.inc.php :: SearchHeader()
*
* This is the header part of the webpage.
*
*/
function SearchHeader() {
    global $CONFIG;                         // Include the global variable.
    global $VA_MAIN;                        // Include the global variable.
    global $USER;                           // Include current user information.
    global $db;
    global $rootDir;
    global $includeDir;

    require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Search] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active            { color: #FF0000 }
    a:link              { color: #0000D0 }
    a:visited           { color: #0000D0 }
    a:hover             { color: #FF0000 }
    a.msgBack:link      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited   { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgHeader:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgHeader:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .body               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #000000; }
    .boldBody           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #000000; font-weight: bold }
    .filename           { font-family: Courier New;               font-size: 10pt; color: #000080; font-weight: bold }
    .filesize           { font-family: Courier New;               font-size: 10pt; color: #000080; }
    .heading            { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; font-weight: bold }
    .msgBack            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .msgBody            { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; }
    .msgHeader          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .msgTime            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #666666; }
    .msgTitle           { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight: bold }
    .title              { font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #000000; font-weight: bold }
-->
</style>
</head>

<body bgcolor="#FFFFFF">

<div align="center">
<center>
<table cellspacing="0" cellpadding="0" width="750" border="0" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td align="left">
            <span class="title"><a href="http://www.vadvphp.com"><img border="0" src="<?php print $rootDir; ?>images/vadv-php.gif" alt="VADV-PHP" width="50" height="30" align="absbottom"></a>&nbsp;&nbsp;&nbsp;<?php print HtmlSpace($VA_MAIN['bbsname']); ?> Search</span>
            <hr color="#525552">
            <p><span class="heading">Search: <?php print $db['desc']; ?> - </span>
            <span class="body">Search the message and file databases for specific information.</span></p>

<?php
    if (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct'])) {
?>
            <p class="body"><span class="boldBody">You are logged in as: <?php print HtmlSpace($USER['handle']); ?></span> (#<?php print $USER['userno']; ?>)</p>
<?php
    } else {
?>
            <p><span class="boldBody">You are not logged in. Login <a href="<?php print $rootDir; ?>bbslogin.php?url=<?php print urlencode(GetCurrentURL()); ?>">here</a> for full access priviledges.</span></p>
<?php
    }
}


/**
* Layout_Forum.inc.php :: SearchFooter()
*
* This is the footer part of the webpage.
*
*/
function SearchFooter() {
    global $CONFIG;                      // Include the global variable.
?>
        </td>
    </tr>
</table>
</center>
</div>

<?php GlobalFooter(0, 1); ?>

</body>

</html>

<?php
}
?>