<?php
/*
 * ----------------------------------------------------------------------------
 * Forum-ViewMsg.php                                                 08/02/2006
 * This script will display the selected message to the user.
 * The variable $t is passed to the script to set the topic number.
 * The variable $d is passed to the script to set the database number.
 * The variable $m is passed to the script to set the message number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Reading Messages';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-userfile.inc.php');  // Include user functions.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.
require_once('layout_forum.inc.php');               // Webpage header and footer.

$VA_NETWORKS = GetNetworkInfo();

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = (integer) $_GET['t'];
} else {
    $t = 1;
}

if (isset($_GET['d'])) {                    // Set the passed variables.
    $d = (integer) $_GET['d'];
} else {
    $d = 1;
}

if (isset($_GET['ansi'])) {                 // Set the passed variables.
    $ansi = (integer) $_GET['ansi'];
} else {
    $ansi = 0;
}

if (isset($_GET['color'])) {                // Set the passed variables.
    $color = (integer) $_GET['color'];
} else {
    $color = 0;
}

if (isset($_GET['html'])) {                 // Set the passed variables.
    $html = (integer) $_GET['html'];
} else {
    $html = 0;
}

if (isset($_GET['routing'])) {              // Set the passed variables.
    $routing = (integer) $_GET['routing'];
} else {
    $routing = 0;
}

if ($t < 1) {
    $t = 1;
}
if ($d < 1) {
    $d = 1;
}

$topic = GetTopicInfo($t, 'M');             // Retrieve the topic information.
// If this is an invalid section, display an error message.
if ($topic == '') {
    die('<br /><h4>Invalid topic. Please press the BACK button on your browser.</h4>');
}

$db = GetDbInfo($t, $d);                    // Retrieve the database information.

$msgno = $db['msgno'];                      // Retrieve the number of messages.
if ($msgno == 0) {
    die('<br /><h4>Invalid message. Please press the BACK button on your browser.</h4>');
}

// Determine if the user has access to this section.
if (!DbAccess($db)) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

if (trim($topic['desc']) != '') {
    $topicDesc = htmlspecialchars($topic['desc']);
} else {
    $topicDesc = '(No Topic Description)';
}

if (trim($db['desc']) != '') {
    $dbDesc = htmlspecialchars($db['desc']);
} else {
    $dbDesc = '(No Description)';
}

if (strlen($dbDesc) >= 31) {
    $dbDesc = $dbDesc . '...';
}

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    $m = $msgno;
}
if ($m > $msgno) {
    $m = $msgno;
}
if ($m <= 0) {
    $m = 1;
}

$msgInfo = GetMessageInfo($db, $m);         // Get the message information.

// Determine if the message is deleted and give proper access.
if (($msgInfo['deleted'] == 1) &&
    (($USER['securitylevel'] < 255) &&
     (($db['moderator'] != $USER['userno']) ||
      ($db['moderator'] == 0)))) {
    die('<br /><h4>This message has been deleted. Please press the BACK button on your browser.</h4>');
}

// Check for delete message flag.
if (isset($_GET['delete'])) {
    if ($_GET['delete'] == 1) {
        // If an attached file, then delete it. Non-reversible!
        if ($msgInfo['attfilename'] != '') {
            if ($CONFIG['filehost'] != '') {
                $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
            } else {
                $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
            }
            if ($msgInfo['attfilepath'] == '') {
                unlink($file);
            }
            $msgInfo['attfilesize'] = 0;
            $msgInfo['attfilename'] = '';
            $msgInfo['attfilepath'] = '';
        }
        $msgInfo['deleted'] = 1;
        WriteMessageInfo($db, $m, $msgInfo);
        RedirectUser('forum-dispmsg.php?t=' . $t . '&d=' . $d);
    } else if ($_GET['delete'] == 0) {
        $msgInfo['deleted'] = 0;
        WriteMessageInfo($db, $m, $msgInfo);
    }
}

ForumHeader();                              // Display the webpage header.
?>

<script language="JavaScript" type="text/javascript">
<!--
    function MessageInfo(t, d, m) {
        var url = "msginfo.php?t=" + t + "&d=" + d + "&m=" + m;
        var newwindow = window.open(url, "messageinfo", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, width=620, height=210");
        newwindow.focus();
    }
//-->
</script>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 1) {
    $num = $m - 1;
    print '<a class="msgBack" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Previous Message</a> |' . "\n";
}

if ($m < $msgno) {
    $num = $m + 1;
    print '<a class="msgBack" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Next Message</a> |' . "\n";
}

if ($m >= $msgno - 25) {
    print '<a class="msgBack" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else if ($m <= 25) {
    print '<a class="msgBack" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '&m=25">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else {
    print '<a class="msgBack" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
}

print '&nbsp;<a class="msgBack" title="Back to Databases" href="forum-dispdb.php?t=' . $t . '">&lt;--</a>' . "\n";
print '&nbsp;<a class="msgBack" title="Back to Topics" href="forum-disptopics.php">&lt;---</a>' . "\n";
?>

        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;<?php
                                                           if ($db['networked']) {
                                                               print '<img src="' . $rootDir . 'images/networked.gif" alt="Networked Database" width="12" height="11">&nbsp;';
                                                           } else {
                                                               print '<img src="' . $rootDir . 'images/local.gif" alt="Local Database" width="12" height="11">&nbsp;';
                                                           }
                                                           print HtmlSpace($dbDesc) . '&nbsp;&nbsp;-&nbsp;&nbsp;[' . $m . ' / ' . $db['msgno'] . ']';
                                                           ?></span></td>
                    <?php if (($USER['userno'] > 0) && ($USER['securitylevel'] >= $db['minwritesl'])) { ?>
                    <form action="post-message.php" name="post" method="POST">
                        <td align="right">
                            <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                            <input type="hidden" name="t" value="<?php print $t; ?>">
                            <input type="hidden" name="d" value="<?php print $d; ?>">
                            <input type="hidden" name="reply" value="0">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/post.gif" border="0" alt="Post a New Message" width="80" height="25">
                        </td>
                    </form>
                    <form action="post-message.php" name="reply" method="POST">
                        <td align="right">
                            <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                            <input type="hidden" name="t" value="<?php print $t; ?>">
                            <input type="hidden" name="d" value="<?php print $d; ?>">
                            <input type="hidden" name="reply" value="<?php print $m; ?>">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/reply.gif" border="0" alt="Reply to this Message" width="51" height="25">
                        </td>
                    </form>
                    <?php } ?>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;From&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;To&nbsp;</td>
        <td class="msgHeader" width="370" height="15" bgcolor="#000080" align="left">&nbsp;Subject&nbsp;</td>
        <td class="msgHeader" width="150" height="15" bgcolor="#000080" align="center">&nbsp;Date/Time&nbsp;</td>
    </tr>

<?php
$dateTime = ConvertDateTime($msgInfo['creation'], 'F j, Y');
// Check for any files.
if ($msgInfo['attfilename'] != '') {
    if ($db['filepath'] != '') {
        if ($CONFIG['filehost'] != '') {
            $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
        } else {
            $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
        }
    } else {
        $file = $VA_SYSPATHS['sysop'] . '/' . $msgInfo['attfilename'];
    }
} else {
    $file = '';
}

if ($file != '') {
    if (!is_file($file)) {
        $filesize = '0 bytes';
    } else {
        $filesize = filesize($file);
        if ($filesize >= 1073741824) {
            $filesize = round($filesize / 1073741824, 1) . 'GB';
        } else if ($filesize >= 1048576) {
            $filesize = round($filesize / 1048576, 1) . 'MB';
        } else if ($filesize >= 1024) {
            $filesize = intval($filesize / 1024) . 'KB';
        } else {
            $filesize = $filesize . ' bytes';
        }
    }
}

$from = $msgInfo['fromhandle'];
$pos = strpos($from, '@');                      // Check for email address.
if (is_int($pos)) {
    $from = substr($from, 0, $pos);
}
$char = substr($from, 0, 1);
if ($char == '<') {
    $from = substr($from, 1);
}
if ($char == '"') {
    $pos = strpos($from, '"', 1);
    $from = substr($from, 1, $pos - 1);
}
$from = trim(htmlspecialchars($from));

$to = $msgInfo['tohandle'];
$pos = strpos($to, '@');                        // Check for email address.
if (is_int($pos)) {
    $to = substr($to, 0, $pos);
}
$char = substr($to, 0, 1);
if ($char == '<') {
    $to = substr($to, 1);
}
if ($char == '"') {
    $pos = strpos($to, '"', 1);
    $to = substr($to, 1, $pos - 1);
}
$to = trim(htmlspecialchars($to));

if ($msgInfo['subject'] == '') {
    $subject = '(No Subject)';
} else {
    $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
}

$pos = strpos($to, '@');
if (is_int($pos)) {
    $to = substr($to, 0, $pos);
}
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" <?php
                            if ($msgInfo['deleted'] == 0) {
                                print 'src="' . $rootDir . 'images/message.gif" alt="Message"';
                            } else {
                                print 'src="' . $rootDir . 'images/message-deleted.gif" alt="Message Marked for Deletion"';
                            }
                            ?> width="11" height="11"><?php
                                                      if ($msgInfo['attfilename'] != '') {
                                                          print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
                                                      }
                                                      ?></td>
        <td width="100" height="30" align="left" nowrap>
            <span class="boldBody">&nbsp;<?php
                                         if (($msgInfo['fromnetid'] == 1) &&
                                             ($msgInfo['fromnetnode'] == $VA_NETWORKS[1]['settings']['systemid']) &&
                                             ($msgInfo['fromuserno'] > 0) &&
                                             ($USER['securitylevel'] >= 255)) {
                                             $fromUser = GetUser($msgInfo['fromuserno']);
                                             if (strtolower($fromUser['handle']) == strtolower($msgInfo['fromhandle'])) {
                                                 print '<a href="' . $rootDir . 'misc/usereditor.php?u=' . $msgInfo['fromuserno'] . '">' . HtmlSpace($from) . '</a>';
                                             } else {
                                                 print HtmlSpace($from);
                                             }
                                         } else {
                                             print HtmlSpace($from);
                                         }
                                         ?>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="left" nowrap>
            <span class="body">&nbsp;<?php print HtmlSpace($to); ?>&nbsp;</span></td>
        <td width="370" height="30" align="left">
            <span class="heading">&nbsp;<?php print HtmlSpace($subject); ?>&nbsp;</span></td>
        <td width="150" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime"><br />&nbsp;<?php print $dateTime['time']; ?><?php
                                                                                                                                                if (!$dateTime['tz']) {
                                                                                                                                                    print '*';
                                                                                                                                                }
                                                                                                                                                ?>&nbsp;</span></td>
    </tr>

<?php
if ($html == 0) {
    $h = 0;
} else {
    $h = 1;
}
$message = GetMessage($db, $m, $h, '', $msgInfo);   // Get the message to display.
if ($routing == 0) {
    $message = StripRouting($message);
}
if ($color == 0) {
    $message = StripBBSCodes($message);
}
if ($ansi == 0) {
    $message = StripANSICodes($message);
}
$message = HTMLEncode($message, $USER_SETTINGS['htmlencode']);  // Encode the HTML text.
?>

    <tr>
        <td width="750" align="left" colspan="5" valign="top">

<?php
// Deletion option.
if (($USER['securitylevel'] >= 255) ||
    (($db['moderator'] == $USER['userno']) && ($db['moderator'] > 0))) {
    if ($msgInfo['deleted'] == 1) {
        print '<span class="msgBack">(Message Marked for Deletion)</span><span class="body"> - </span>' . "\n";
        print '<span class="msgBack"><a href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&delete=0">UnMark this Message for Deletion</a></span>' . "\n";
    } else {
        print '<span class="msgBack"><a href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&delete=1">Mark this Message for Deletion</a></span>' . "\n";
    }
}

// If there is an attached file, then display its link.
if ($file != '') {
?>

    <form name="download" action="<?php print $rootDir; ?>download.php" method="POST">
        <input type="hidden" name="t" value="<?php print $t; ?>">
        <input type="hidden" name="d" value="<?php print $d; ?>">
        <input type="hidden" name="m" value="<?php print $m; ?>">
        <input type="image" value="Download" src="<?php print $rootDir; ?>images/download.gif" alt="Download <?php print $msgInfo['attfilename']; ?>" width="80" height="25" align="absmiddle">
        <span class="filename">&nbsp;Attached file: <?php print $msgInfo['attfilename']; ?></span><span class="filesize"> (<?php print $filesize; ?>)</span>
    </form>

<?php
} else {
    print '<br />';
}
?>

            <pre><?php print $message; ?></pre>
        </td>
    <tr>
        <td bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td class="msgHeader" align="left">&nbsp;
                        <?php
                        if (($ansi == '') || ($ansi == 0)) {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=1&color=' . $color . '&html=' . $html . '&routing=' . $routing . '">Show ANSI Codes</a> |' . "\n";
                        } else {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=0&color=' . $color . '&html=' . $html . '&routing=' . $routing . '">Strip ANSI Codes</a> |' . "\n";
                        }
                        if (($color == '') || ($color == 0)) {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=' . $ansi . '&color=1&html=' . $html . '&routing=' . $routing . '">Show Color Codes</a> |' . "\n";
                        } else {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=' . $ansi . '&color=0&html=' . $html . '&routing=' . $routing . '">Strip Color Codes</a> |' . "\n";
                        }
                        if (($html == '') || ($html == 0)) {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=1&routing=' . $routing . '">Strip HTML Tags</a> |' . "\n";
                        } else {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=0&routing=' . $routing . '">Show HTML Tags</a> |' . "\n";
                        }
                        if (($routing == '') || ($routing == 0)) {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=' . $html . '&routing=1">Show Routing</a>' . "\n";
                        } else {
                            print '<a class="msgHeader" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=' . $html . '&routing=0">Strip Routing</a>' . "\n";
                        }
                        ?>
                    </td>
                    <td class="msgHeader" align="right">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a class="msgHeader" href="Javascript:MessageInfo(\'<?php print $t; ?>\', \'<?php print $d; ?>\', \'<?php print $m; ?>\');">Message Info</a>&nbsp;');
                        -->
                        </script>
                        <noscript>
                            <a class="msgHeader" href="msginfo.php?t=<?php print $t; ?>&d=<?php print $d; ?>&m=<?php print $m; ?>" target="messageinfo">Message Info</a>&nbsp;
                        </noscript>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 1) {
    $num = $m - 1;
    print '<a class="msgBack" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Previous Message</a> |' . "\n";
}

if ($m < $msgno) {
    $num = $m + 1;
    print '<a class="msgBack" href="forum-viewmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Next Message</a> |' . "\n";
}

if ($m >= $msgno - 25) {
    print '<a class="msgBack" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else if ($m <= 25) {
    print '<a class="msgBack" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '&m=25">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
} else {
    print '<a class="msgBack" href="forum-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $m . '">Back to ' . HtmlSpace($dbDesc) . "</a>\n";
}

print '&nbsp;<a class="msgBack" title="Back to Databases" href="forum-dispdb.php?t=' . $t . '">&lt;--</a>' . "\n";
print '&nbsp;<a class="msgBack" title="Back to Topics" href="forum-disptopics.php">&lt;---</a>' . "\n";
?>

        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php
// Update message pointer if needed.
if (GetMessagePointer($db, $USER['userno']) < $m) {
    WriteMessagePointer($db, $USER['userno'], $m);
}

ForumFooter();                              // Display the webpage footer.

?>