<?php
/*
 * ----------------------------------------------------------------------------
 * Files-DispMsg.php                                                 08/02/2006
 * This script will display a list of messages that are available in the
 * selected database.
 * The variable $t is passed to the script to set the topic number.
 * The variable $d is passed to the script to set the database number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Listing Files';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once('layout_files.inc.php');               // Webpage footer and header.

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = (integer) $_GET['t'];
} else {
    $t = 10;
}

if (isset($_GET['d'])) {                    // Set the passed variables.
    $d = (integer) $_GET['d'];
} else {
    $d = 1;
}

if ($t < 1) {
    $t = 1;
}
if ($d < 1) {
    $d = 1;
}

$topic = GetTopicInfo($t, 'F');             // Retrieve the topic information.
// If this is an invalid section, display an error message.
if (!$topic) {
    die('<br /><h4>Invalid topic. Please press the BACK button on your browser.</h4>');
}

$db = GetDBInfo($t, $d);                    // Retrieve the database information.
// Determine if the user has access to this section.
if (!DbAccess($db)) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

if (trim($topic['desc']) != '') {
    $topicDesc = htmlspecialchars($topic['desc']);
} else {
    $topicDesc = '(No Topic Description)';
}

if (trim($db['desc']) != '') {
    $dbDesc = htmlspecialchars($db['desc']);
} else {
    $dbDesc = '(No Description)';
}

if (strlen($dbDesc) >= 31) {
    $dbDesc = $dbDesc . '...';
}

$msgno = $db['msgno'];                      // Retrieve the number of messages.

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    $m = $msgno;
}
if ($m > $msgno) {
    $m = $msgno;
}
if ($m <= 0) {
    $m = 1;
}

FilesHeader();                              // Display the webpage header.
?>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 25) {
    $num = $m - 25;
    $cnt = 25;
    if ($num < 25) {
        $cnt = $num;
    }
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Previous ' . $cnt . '</a> |' . "\n";
}

if ($m < $msgno) {
    $num = $m + 25;
    if ($num > $msgno) {
        $num = $msgno;
    }
    $cnt = 25;
    if (($msgno - $m) < 25) {
        $cnt = ($msgno - $m);
    }
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Next ' . $cnt . '</a> |' . "\n";
}
print '<a class="msgBack" href="files-dispdb.php?t=' . $t . '">Back to ' . HtmlSpace($topicDesc) . '</a>' . "\n";
print '&nbsp;<a class="msgBack" title="Back to Topics" href="files-disptopics.php">&lt;--</a>' . "\n";
?>

        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td class="msgTitle" colspan="5" bgcolor="#416DBF" height="33" width="750">
                        &nbsp;&nbsp;<?php
                                    if ($db['networked']) {
                                        print '<img src="' . $rootDir . 'images/networked.gif" alt="Networked Database" width="12" height="11">&nbsp;';
                                    } else {
                                        print '<img src="' . $rootDir . 'images/local.gif" alt="Local Database" width="12" height="11">&nbsp;';
                                    }
                                    if (trim($db['desc']) != '') {
                                        print HtmlSpace(htmlspecialchars($db['desc']));
                                    } else {
                                        print '(No Description)';
                                    }
                                    ?></td>
                    <form action="search.php" name="search" method="GET">
                        <td align="right">
                            <input type="hidden" name="t" value="<?php print $t; ?>">
                            <input type="hidden" name="d" value="<?php print $d; ?>">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/search.gif" border="0" alt="Search Files" width="60" height="25">
                        </td>
                    </form>
                    <?php
                    if (($USER['securitylevel'] >= 255) ||
                        (($CONFIG['fileupload'] == 1) &&
                         (($USER['userno'] > 0) &&
                          ($USER['userno'] != $CONFIG['guestacct']) &&
                          ($USER['securitylevel'] >= $CONFIG['fileuploadsl'])) &&
                         (($VA_MAIN['secuploads'] == 1) ||
                          ($USER['securitylevel'] >= $db['minwritesl'])))) {
                    ?>
                    <form action="<?php print $rootDir; ?>upload.php" name="post" method="POST">
                        <td align="right">
                            <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                            <input type="hidden" name="t" value="<?php print $t; ?>">
                            <input type="hidden" name="d" value="<?php print $d; ?>">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/upload.gif" border="0" alt="Upload a File" width="60" height="25">
                        </td>
                    </form>
                    <?php } ?>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="385" height="15" bgcolor="#000080" align="left">&nbsp;Description&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="center">&nbsp;Filename&nbsp;</td>
        <td class="msgHeader" width="60" height="15" bgcolor="#000080" align="center">&nbsp;Size&nbsp;</td>
        <td class="msgHeader" width="175" height="15" bgcolor="#000080" align="center">&nbsp;Date/Time/Uploader&nbsp;</td>
    </tr>

<?php
// Set the fileString variable.
$file = $VA_SYSPATHS['db'] . '/' . $db['filename'] . '.DAT';
if (!is_file($file)) {
    die('<br /><h4>Requested database is missing. Please press the BACK button on your browser.</h4>');
}
$fileString = ReadCfgFile($file);           // Read the file.

// Run the loop that will display the messages.
for ($x = $m; $x >= ($m - 24); $x--) {
    if ($msgno == 0) {
        print '<tr><td colspan="5"><p align="left"><br /><span class="heading">There are no files in this database.</span><br /><br /></p></td></tr>' . "\n";
        break;
    }

    if ($x <= 0) {
        break;
    }
    $msgInfo = GetMessageInfo($db, $x, $fileString);    // Get the message information.
    $dateTime = ConvertDateTime($msgInfo['creation']);

    $from = $msgInfo['fromhandle'];
    $pos = strpos($from, '@');                          // Check for email address.
    if (is_int($pos)) {
        $from = substr($from, 0, $pos);
    }
    $char = substr($from, 0, 1);
    if ($char == '<') {
        $from = substr($from, 1);
    }
    if ($char == '"') {
        $pos = strpos($from, '"', 1);
        $from = substr($from, 1, $pos - 1);
    }
    $from = trim(htmlspecialchars($from));

    if ($msgInfo['subject'] == '') {
        $subject = '(No Description)';
    } else {
        $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
    }

    if ($msgInfo['attfilename'] != '') {
        if ($CONFIG['filehost'] != '') {
            $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
        } else {
            $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
        }
    } else {
        $file = '';
    }

    if ($file != '') {
        if (!is_file($file)) {
            $filesize = '0 bytes';
        } else {
            $filesize = filesize($file);
            if ($filesize >= 1073741824) {
                $filesize = round($filesize / 1073741824, 1) . 'GB';
            } else if ($filesize >= 1048576) {
                $filesize = round($filesize / 1048576, 1) . 'MB';
            } else if ($filesize >= 1024) {
                $filesize = intval($filesize / 1024) . 'KB';
            } else {
                $filesize = $filesize . ' bytes';
            }
        }
    } else {
        $filesize = '0 bytes';
    }
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" <?php
                            if ($msgInfo['deleted'] == 0) {
                                print 'src="' . $rootDir . 'images/message.gif" alt="File"';
                            } else {
                                print 'src="' . $rootDir . 'images/message-deleted.gif" alt="File Marked for Deletion"';
                            }
                            ?> width="11" height="11"><?php
                                                      if ($msgInfo['attfilename'] != '') {
                                                          print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
                                                      }
                                                      ?></td>
        <td width="385" height="30" align="left">
            <span class="heading">&nbsp;<a href="files-viewmsg.php?t=<?php print $t . '&d=' . $d . '&m=' . $x . '">' . HtmlSpace($subject); ?></a>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="boldBody">&nbsp;<?php print htmlspecialchars($msgInfo['attfilename']); ?>&nbsp;</span></td>
        <td width="60" height="30" align="center" nowrap>
            <span class="body">&nbsp;<?php print $filesize; ?>&nbsp;</span></td>
        <td width="175" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime">&nbsp;<?php print $dateTime['time']; ?><?php
                                                                                                                                          if (!$dateTime['tz']) {
                                                                                                                                              print '*';
                                                                                                                                          }
                                                                                                                                          ?></span><br /><span class="body">by </span><span class="boldBody"><?php print HtmlSpace($from); ?>&nbsp;</span></td>
    </tr>

<?php
}
?>

    <tr>
        <td class="msgHeader" bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">&nbsp;</td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 25) {
    $num = $m - 25;
    $cnt = 25;
    if ($num < 25) {
        $cnt = $num;
    }
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Previous ' . $cnt . '</a> |' . "\n";
}

if ($m < $msgno) {
    $num = $m + 25;
    if ($num > $msgno) {
        $num = $msgno;
    }
    $cnt = 25;
    if (($msgno - $m) < 25) {
        $cnt = ($msgno - $m);
    }
    print '<a class="msgBack" href="files-dispmsg.php?t=' . $t . '&d=' . $d . '&m=' . $num . '">Next ' . $cnt . '</a> |' . "\n";
}
print '<a class="msgBack" href="files-dispdb.php?t=' . $t . '">Back to ' . $topicDesc . '</a>' . "\n";
print '&nbsp;<a class="msgBack" title="Back to Topics" href="files-disptopics.php">&lt;--</a>' . "\n";
?>

        </td>
        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php

FilesFooter();                              // Display the webpage footer.

?>