{$I c:\tp\padi\padi.def}

Unit NA_TPU;

interface

uses
 dos,
 crt,
 objects,
 longarr;


const

CRLF = #13#10 ;

fmReadOnly  = 0 ;   { $0000 ---- ---- ---- -000 }
fmWriteOnly = 1 ;   { $0001 ---- ---- ---- -001 }
fmReadWrite = 2 ;   { $0002 ---- ---- ---- -010 }
fmDenyAll   = 16 ;  { $0010 ---- ---- -001 ---- }
fmDenyWrite = 32 ;  { $0020 ---- ---- -010 ---- }
fmDenyRead  = 48 ;  { $0030 ---- ---- -011 ---- }
fmDenyNone  = 64 ;  { $0040 ---- ---- -100 ---- }

DayAbb:Array[0..6] of Array[0..2] of Char =(
'Sun','Mon','Tue','Wed','Thu','Fri','Sat');

MonthAbb:Array[0..11] of Array[0..2] of char=(
'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

{ Allfix sample

 + 28 Jan 10:35:40 ALLFIX ALLFIX 4.31 26-Feb-95 23:59
 # 28 Jan 10:35:40 ALLFIX Command : File
  28 Jan 10:35:44 ALLFIX Call C:\UTIL\ADDCMT.EXE C:\TEMP\5CAEAB9E.TMP\DRAGON22.ZIP 0
 ! 28 Jan 10:35:47 ALLFIX Msg  Invalid destination directory : 'C:\FILE\OS\'
 % 28 Jan 10:42:26 ALLFIX Nothing to do (00:04)

}

{ PoP sample

# 28 Jan 19:52:14 PORTAL RING
* 28 Jan 19:52:35 PORTAL Colo. Sp. Central Net Node 1 (17:550/1.0)
* 28 Jan 19:52:35 PORTAL Remote uses: FrontDoor Version 2.20
: 28 Jan 19:52:35 PORTAL SysOp: Terry Barlow
: 28 Jan 19:52:35 PORTAL Remote AKA's: 16:719/33.0 1:128/1100.0 77:77/24.0 72:303/2.0 1:128/1110.0 86:8350/308.0 66:750/100.0 1
 :128/187.
0 50:610/4.0 30:719/1.0
+ 28 Jan 19:54:07 PORTAL Searching for files to forward
+ 28 Jan 19:54:07 PORTAL File forward done

}

LogFlav:Array[0..6] of char=('+','#','*',':','','!','%');

logBegin  = 0;
logInfo   = 2;  { ? }
lfShell   = 4;
logError  = 5;
logEnd    = 6;

NAVersionId= '1.00';
Date1      = 'February 01 1998';
Date2      = '98/02/01';
maxtagsize = 60;

{str_warning= ' WARNING:';}

str_1      = {''} '';
str_warning= str_1+' WARNING:';
str_debug  = str_1+' DEBUG:';

err_noshare   = str_warning+' share not installed';
err_noconfig  = 'can not find configuration file "';
err_blankline = 'line #1 can not be left blank';

cfg_line3   = str_1+' line #3 is blank, using default of TRUE';

str_template    = str_1+' style template "';
str_alternative = str_1+' alternative "';
str_no_alt      = str_1+' no alternative template';
str_skipping    = str_1+' skipping long areas';
str_truncating  = str_1+' truncating long areas';
str_alternating = str_1+' alternating long areas';

str_na_file     = str_1+' .NA file "';

str_using       = str_debug+' using ';

str_start1      = str_1+' "';          { ' " }
str_done        = str_1+' done';
str_writing     = str_1+' writing message base data';

log_down        = 'down';

type

ScreenType = array [0..3999] of Byte;
unixtime = longint;
filestr = string[79];
string2 = string[2];
string4 = string[4];

{$I screen.pas}

{$I na_glob.inc}

{ $I c:\tp\psy\consts.pas}


{$IFDEF FASTW}
const
ScreenSeg  : word = $B800;
{$ENDIF}

var
ScreenAddr : ScreenType absolute $B800:$0000;
dirinfo    : searchrec;
Software   : (RA200{,RA250},RG,PB215,TAG27,TG300,SB117,Nx099);
Modified   : boolean;
Msg        : MsgPtr;

 TimeR : Record
         hour,
         Minute,
         second,
         sec100  : word;
         end;

 DateR: Record
        year,
        month,
        day,
        DayOfWeek: word;
        end;

 txt  : text;

 log  : record
        txt   : text;
        on    : boolean;
        where : string;
        end;

 error : byte;

{ ScreenAddr: ScreenType absolute $B800:0000; }

 tag   : record
         arr   : ps2rec;
         entry : record
                 tag   : string[25];
                 desc  : string[56];
                 end;
         end;
        {RemoteAccess's CONFIG.RA'}
{ FConfig  : File Of ConfigRecord;
 Config   : ConfigRecord;}
         {RA's message.ra}
{ Msg     : File of rMessageRecord;
 Msg      : MessageRecord;
 FMsg2    : File of MessageRecord;
 Msg2     : MessageRecord;}



AreaTemp   : string[80]; { add before the area name}
AltTemp    : string[80];
Skip2Long  : (truncate,skip,alt);    {Skip entries that are too long, needed to be shortened}
NAfile     : string[128];
TmpWord    : word;
tmpstr     : string;
configfile : string;  {file to read as config file}
longestarea: byte;
shareinst  : boolean;


MsgArr     : Ps2Rec;


procedure findtag(findme: string);
procedure givehelp;
procedure init_tag;
procedure log_(s:string;flavour:byte);
procedure my_Create_Array(Var ps2:ps2rec;Low,High,Size:LongInt);
procedure CritError(s:string);
procedure UNCRUNCH (var Addr1,Addr2; BlkLen:Integer);
procedure pAddSlash(Var InPath: String);
function exist(filename: filestr): boolean;
function HexW( w: WORD ): String4;
function LTrim( s: STRING; c: CHAR ): STRING;
function IntToStr(Num: longint): String;
function ShareInstalled : boolean;
function PADR( s: STRING; n: BYTE; c: CHAR ): STRING;
function RTrim( Rtrims: STRING; Rtrimc: CHAR ): STRING;

{$IFDEF FASTW}
PROCEDURE FastWrite(Col, Row, Attr : Byte; Str : String);
{$ENDIF}


implementation

{$I na_glob.pas}

FUNCTION RTrim( Rtrims: STRING; Rtrimc: CHAR ): STRING;
BEGIN
WHILE (LENGTH(rtrims) > 0) AND (rtrims[LENGTH(rtrims)] = rtrimc)
 DO DEC(rtrims[0]);
RTrim := rtrims;
END;

{$IFDEF FASTW}
PROCEDURE FastWrite(Col, Row, Attr : Byte; Str : String); {NEAR;} ASSEMBLER;
{.$DEFINE FASTW_FINDADDR}
{ This procedure is the only one which is not mine }
  ASM
    PUSH   DS           {Save DS}
    MOV    DL,CheckSnow {Save CheckSnow Setting}
{$IFDEF FASTW_FINDADDR}
    MOV    ES,SegB800   {ES = Colour Screen Segment}
    MOV    SI,SegB000   {SI = Mono Screen Segment}
    MOV    DS,Seg0040   {DS = ROM Bios Segment}
{$ELSE} { FASTW_FINDADDR }
    MOV    ES,ScreenSeg
{$ENDIF} { FASTW_FINDADDR }
    MOV    BX,[49h]     {BL = CRT Mode, BH = ScreenWidth}
    MOV    AL,Row       {AL = Row No}
    MUL    BH           {AX = Row * ScreenWidth}
    XOR    CH,CH        {CH = 0}
    MOV    CL,Col       {CX = Column No}
    ADD    AX,CX        {(Row*ScreenWidth)+Column}
    ADD    AX,AX        {Multiply by 2 (2 Byte per Position)}
    MOV    DI,AX        {DI = Screen Offset}
{$IFDEF FASTW_FINDADDR}
    CMP    BL,7         {CRT Mode = Mono?}
    JNE    @@DestSet    {No  - Use Colour Screen Segment}
    MOV    ES,SI        {Yes - ES = Mono Screen Segment}
    XOR    DX,DX        {Force jump to FWrite}
  @@DestSet:            {ES:DI = Screen Destination Address}
{$ELSE} {FASTW_FINDADDR}

{$ENDIF} {FASTW_FINDADDR}
    LDS    SI,Str       {DS:SI = Source String}
    CLD                 {Move Forward through String}
    LODSB               {Get Length Byte of String}
    MOV    CL,AL        {CX = Input String Length}
    JCXZ   @@Done       {Exit if Null String}
    MOV    AH,Attr      {AH = Attribute}
    OR     DL,DL        {Test Mono/CheckSnow Flag}
    JZ     @@FWrite     {Snow Checking Disabled or Mono - Use FWrite}
{Output during Screen Retrace's}
    MOV    DX,003DAh    {6845 Status Port}
  @@WaitLoop:           {Output during Retrace's}
    MOV    BL,[SI]      {Load Next Character into BL}
    INC    SI           {Update Source Pointer}
    CLI                 {Interrupts off}
  @@Wait1:              {Wait for End of Retrace}
    IN      AL,DX       {Get 6845 status}
    TEST    AL,8        {Vertical Retrace in Progress?}
    JNZ     @@Write     {Yes - Output Next Char}
    SHR     AL,1        {Horizontal Retrace in Progress?}
    JC      @@Wait1     {Yes - Wait until End of Retrace}
  @@Wait2:              {Wait for Start of Next Retrace}
    IN      AL,DX       {Get 6845 status}
    SHR     AL,1        {Horizontal Retrace in Progress?}
    JNC     @@Wait2     {No - Wait until Retrace Starts}
  @@Write:              {Output Char and Attribute}
    MOV     AL,BL       {Put Char to Write into AL}
    STOSW               {Store Character and Attribute}
    STI                 {Interrupts On}
    LOOP   @@WaitLoop   {Repeat for Each Character}
    JMP    @@Done       {Exit}
{Ignore Screen Retrace's}
  @@FWrite:             {Output Ignoring Retrace's}
    TEST   SI,1         {DS:SI an Even Offset?}
    JZ     @@Words      {Yes - Skip (On Even Boundary)}
    LODSB               {Get 1st Char}
    STOSW               {Write 1st Char and Attrib}
    DEC    CX           {Decrement Count}
    JCXZ   @@Done       {Finished if only 1 Char in Str}
  @@Words:              {DS:SI Now on Word Boundary}
    SHR    CX,1         {CX = Char Pairs, Set CF if Odd Byte Left}
    JZ     @@ChkOdd     {Skip if No Pairs to Store}
  @@Loop:               {Loop Outputing 2 Chars per Loop}
    MOV    BH,AH        {BH = Attrib}
    LODSW               {Load 2 Chars}
    XCHG   AH,BH        {AL = 1st Char, AH = Attrib, BH = 2nd Char}
    STOSW               {Store 1st Char and Attrib}
    MOV    AL,BH        {AL = 2nd Char}
    STOSW               {Store 2nd Char and Attrib}
    LOOP   @@Loop       {Repeat for Each Pair of Chars}
  @@ChkOdd:             {Check for Final Char}
    JNC    @@Done       {Skip if No Odd Char to Display}
    LODSB               {Get Last Char}
    STOSW               {Store Last Char and Attribute}
  @@Done:               {Finished}
    POP    DS           {Restore DS}
END;
{$endif}


Procedure pAddSlash(Var InPath: String);
Begin
If (Length(InPath) > 0) and (InPath[Length(InPath)] <> '\') Then
 Begin
 InPath[0] := Chr(Length(InPath) + 1);
 InPath[Length(InPath)] := '\';
 End;
end;

Function IntToStr(Num: longint): String; {JSDOOR}
{ This function takes an integer value, and creates a string }

{ changed st string[11] instead of 255 length, saves memory }
Var st: string[11];
Begin
  Str(Num,St);
  IntToStr := st;
End;



procedure log_(s:string;flavour:byte);

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

var
logstr:string[50];
begin;
if log.on then
 begin;

 gettime(timer.hour,timer.minute,timer.second,timer.sec100);

 with dateR do getDate(year,month,day,dayofweek);
 with DateR do LogStr:=IntToStr(Day)+' '+DayAbb[DayOfWeek]+' '+LeadingZero(
  TimeR.Hour)+':'+LeadingZero(TimeR.Minute)+':'+LeadingZero(TimeR.Second);

 writeln(log.txt,LogFlav[flavour]+' PADi '+LogStr+' '+s);
 end;
end;



procedure givehelp;
begin;
 clrscr;
 textattr:=9;
 writeln;
 Writeln('PADi v',NAVersionId,' ',Date1);
 Writeln('(K) 1995,1996, 1998 by Andrew Ziem.  All Rites Reserved.');
 writeln;
 Writeln('Fido 1:128/234, Psychosis +1 (719) 532-0053');
 Writeln('http://www.angelfire.com/co/psych0o/psoft.html, psych0o@juno.com');
 Writeln;
 Writeln('Usage   : PADI <configuration> <log file>');
 Writeln('Example : PADI C:\PADI\PADI.CFG C:\LOGS\PADI.LOG');
 Writeln;
 writeln('Log file is optional.');
 halt(0);
 end;

(*procedure Compilehelp;
 begin;
 clrscr;
 textcolor(9);
 Writeln('PADi v',NAVersionId,' ',Date1);
 Writeln('Fido 1:128/234, internet ziem@rmii.com, Psychosis 719.532.0053');
 Writeln('Copyright (C) 1995,1996 by Andrew Ziem.  All rights reserved');
 Writeln;
 Writeln('Make a regular text file with 4 lines:');
 Writeln;
 Writeln('<Name of NA file>');
 Writeln('<Prefix>');
 Writeln('<Suffix>');
 Writeln('<Skip Long Areas>');
 Writeln;
 Writeln('Line #1 must include the path if it is not in the current directory');
 Writeln('Line #2 is a suffix, it goes before the description when making the');
 Writeln('area name.  Pay attention to the spaces before/after the prefix and suffix');
 Writeln('Line #3 is the same as #2 exept this will go after the description.');
 Writeln('Lines #2 and #3 may be blank.');
 Writeln('Line #4 tells PADi to skip areas that will be over 40 characters');
 Writeln('because that is all RemoteAccess can handle.');
 Writeln('Line #4 must be TRUE, FALSE, YES, or NO, it is not case sensitive');
 Writeln('If set to YES/TRUE areas longer than 40 will be skipped, else');
 Writeln('they will be truncated');
 halt;
 end;*)


procedure init_tag;
var
 Curline : string; {Current Line from .NA file}
 x       : word;
 TagTxt  : text;

 D       : DirStr;
 N       : NameStr;
 E       : ExtStr;

const
 size_curline = sizeof(curline);


begin;
{reset(txt);
tag.arr.max:=0;
while not eof(txt) do   begin;
 inc(tag.arr.max);
 readln(txt,curline);  end;}
{writeln(' Creating array for .NA file [',tag.arr.max*sizeof(tag.entry),' bytes of EMS]');}
{if not exist(nafile) then CritError(255,'can not open/find .NA file "'+tmpstr+'"');}

fsplit(nafile,d,n,e);
findfirst(nafile,32,dirinfo);
while doserror=0 do
begin;
 Writeln(str_na_file+D+dirinfo.name+'"');  { .NA file }
 assign(tagtxt,D+dirinfo.name);
 {$I-}reset(tagtxt);{$I+}
 if ioresult>0 then
  CritError('can not open .NA file "'+D+dirinfo.name+'"');
 while not eof(tagtxt) do               { for x:=1 to tag.arr.max do }
  begin;
  readln(tagtxt,curline);
  {$IFDEF BLOCKPOS}
  Tag.Entry.Tag := copy(CurLine,1,BlockPos(Curline,size_curline,' ')-1);
  Tag.Entry.Desc:= ltrim(Rtrim(Copy(Curline,BlockPos(Curline,size_curline,' '), 255),' '),' ');
  {$ELSE}
  Tag.Entry.Tag:=  copy(CurLine,1,Pos(' ',Curline)-1);
  Tag.Entry.Desc:= ltrim(Rtrim(Copy(Curline,Pos(' ',Curline), 255),' '),' ');
  {$ENDIF}
  {write('desc="',tag.entry.desc,'"');
  write('tag="',tag.entry.tag,'"');
  asm int $28 end;}
  append_array(tag.arr,tag.entry);
  end;
 close(tagtxt);
 findnext(dirinfo);
 end;
end;

procedure findtag(findme: string);
var
x:word;

procedure StrTranp( var Source:string; Old, New : STRING ) ;{: STRING;}
var
 p : INTEGER;
const
 size_old    = sizeof(old);
 size_source = 255;

BEGIN
{$IFDEF BLOCKPOS}
     WHILE BlockPos(Source, size_source, old ) <> 0 DO BEGIN
           p := BlockPos(Source, size_source, old );
{$ELSE}
     WHILE POS( Old, Source ) <> 0 DO BEGIN
           p := POS( Old, Source );
{$ENDIF}
           DELETE( Source, p, LENGTH( Old ) );
           INSERT( New, Source, p );
     {W}END;
{     StrTran := Source;}
END; { StrTran }


procedure changearea;
begin;
textattr:=$0B;
log_('area "'+msgAreaName+'" changed to "'+tmpstr+'"',logInfo);
msg^.SetAreaName(tmpstr);
Writeln(CRLF+tmpstr{msg^.getareaname});
modified:=true;
end;

begin;
textattr:=$0F;
{if length(tag) > maxtagsize then exit; {if it is too big to be a
                 tag then quit, saves time}
for x:=1 to tag.arr.elements do
 begin;
 read_array(tag.arr,x,tag.entry);
 if findme=tag.entry.tag then
  begin;
  textattr:=$09;
{  Writeln(Msg^.GetAreaName);}
{  Tmpstr:=Prefix+tag.entry.desc+Suffix;}
  tmpstr:=areatemp;
  strtranp(tmpstr,'~&1',tag.entry.tag);
  strtranp(tmpstr,'~&2',tag.entry.desc);
  if not Length(Tmpstr) > LongestArea then changearea else
   case skip2long of
    skip: begin;
          textattr:=$04;
          Writeln(CRLF+'this area would be too long');
          log_('area "'+msgAreaname+'" would be too long',logError);
          exit;
          end;
    truncate:changearea;
    alt:  begin;
          tmpstr:=alttemp;
          strtranp(tmpstr,'~&1',tag.entry.tag);
          strtranp(tmpstr,'~&2',tag.entry.desc);
          if not Length(Tmpstr) > LongestArea then
           begin;
{           log_('alternative used',5');}
           changearea
           end else log_('area "'+msgAreaname+'" alternative too long',logError);
          end;
   end;
  end;
end;
end;


function exist(filename: filestr): boolean;
var
 dirinfo: searchrec;
begin
findfirst(filename, $20, dirinfo);
exist:=(doserror=0) and (filename<>#0) ;
end;


procedure UNCRUNCH (var Addr1,Addr2; BlkLen:Integer);

begin
  inline (
    $1E/               {       PUSH    DS             ;Save data segment.}
    $C5/$B6/ADDR1/     {       LDS     SI,[BP+Addr1]  ;Source Address}
    $C4/$BE/ADDR2/     {       LES     DI,[BP+Addr2]  ;Destination Addr}
    $8B/$8E/BLKLEN/    {       MOV     CX,[BP+BlkLen] ;Length of block}
    $E3/$5B/           {       JCXZ    Done}
    $8B/$D7/           {       MOV     DX,DI          ;Save X coordinate for later.}
    $33/$C0/           {       XOR     AX,AX          ;Set Current attributes.}
    $FC/               {       CLD}
    $AC/               {LOOPA: LODSB                  ;Get next character.}
    $3C/$20/           {       CMP     AL,32          ;If a control character, jump.}
    $72/$05/           {       JC      ForeGround}
    $AB/               {       STOSW                  ;Save letter on screen.}
    $E2/$F8/           {Next:  LOOP    LOOPA}
    $EB/$4C/           {       JMP     Short Done}
                       {ForeGround:}
    $3C/$10/           {       CMP     AL,16          ;If less than 16, then change the}
    $73/$07/           {       JNC     BackGround     ;foreground color.  Otherwise jump.}
    $80/$E4/$F0/       {       AND     AH,0F0H        ;Strip off old foreground.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$F1/           {       JMP     Next}
                       {BackGround:}
    $3C/$18/           {       CMP     AL,24          ;If less than 24, then change the}
    $74/$13/           {       JZ      NextLine       ;background color.  If exactly 24,}
    $73/$19/           {       JNC     FlashBitToggle ;then jump down to next line.}
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output}
    $02/$C0/           {       ADD     AL,AL          ;routines.}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$DA/           {       JMP     Next}
                       {NextLine:}
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,}
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to}
    $EB/$D2/           {       JMP     Next           ;the next line.}
                       {FlashBitToggle:}
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink}
    $72/$07/           {       JC      MultiOutput    ;attribute?}
    $75/$CC/           {       JNZ     Next}
    $80/$F4/$80/       {       XOR     AH,128         ;Done.}
    $EB/$C7/           {       JMP     Next}
                       {MultiOutput:}
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.}
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.}
    $AC/               {       LODSB                  ;Get count of number of times}
    $8A/$C8/           {       MOV     CL,AL          ;to display character.}
    $B0/$20/           {       MOV     AL,32}
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.}
    $AC/               {       LODSB                  ;Otherwise get character to use.}
    $4B/               {       DEC     BX             ;Adjust main counter.}
                       {StartOutput:}
    $32/$ED/           {       XOR     CH,CH}
    $41/               {       INC     CX}
    $F3/$AB/           {       REP STOSW}
    $8B/$CB/           {       MOV     CX,BX}
    $49/               {       DEC     CX             ;Adjust main counter.}
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...}
    $1F);              {Done:  POP     DS             ;Restore data segment.}
end; {UNCRUNCH}



FUNCTION HexB( b: BYTE ): String2;
CONST
     HexChar : ARRAY[0..15] OF Char = '0123456789ABCDEF';
BEGIN
     Hexb := HexChar[b SHR 4] + HexChar[b AND $F];
END;

FUNCTION HexW( w: WORD ): String4;
BEGIN
     HexW := HexB(HI(w)) + HexB(LO(w));
END;

function shareinstalled : boolean; assembler; asm
  mov ax, 1000h;
  int 02fh;
  xor ah, ah;
  and al, 0ffh;
  end;

  FUNCTION PADR( s: STRING; n: BYTE; c: CHAR ): STRING;
ASSEMBLER;
ASM
      PUSH   DS
      CLD
      LDS    SI, s
      XOR    AX, AX
      LODSB
      MOV    CX, AX

      LES    DI, @Result
      INC    DI
      REP    MOVSB

      MOV    CL, n
      SUB    CL, AL

      CMP    CX, 0
      JNB    @@1
      XOR    CX, CX

@@1:  MOV    AL, c
      REP    STOSB

      MOV    DI, WORD PTR @Result
      MOV    AL, n
      MOV    BYTE PTR ES:[DI], AL

      POP    DS
END;


FUNCTION LTrim( s: STRING; c: CHAR ): STRING; Assembler;
ASM
      PUSH   DS
      LDS    SI, s
      XOR    AX, AX
      LODSB
      XCHG   AX, CX
      LES    DI, @Result
      INC    DI
      JCXZ   @@2

      MOV    BL, c
      CLD
@@1:  LODSB
      CMP    AL, BL
      LOOPE  @@1
      DEC    SI
      INC    CX
      REP    MOVSB

@@2:  XCHG   AX, DI
      MOV    DI, WORD PTR @Result
      SUB    AX, DI
      DEC    AX
      STOSB
      POP    DS
END;



begin;
shareinst:=shareinstalled;

{$IFDEF FASTW}
if GetScreenSeg>0 then
 ScreenSeg:=GetScreenSeg;
{$ENDIF}

end.
