var
 msgF          : file;
 msgTotalAreas : word;
 msgCloseFileW : word;
 msgPos        : word;
 msgAreaname   : string[79];


type MsgObj = Object
 Constructor Init(fname:string);
 procedure ChangeArea(AreaNum:Word); Virtual;
 function  GetAreaName:string; Virtual;
 function  isEchomail:boolean; Virtual;
 function  NameSize:byte; Virtual;
 procedure SetAreaName(s:string); Virtual;
 procedure CloseFile; Virtual;
 Destructor Done; Virtual;
 end;

MsgPtr      = ^MsgObj;

type

   FlagType       = array[1..4] of Byte;

   Ra200MessageRecord= record
                     Unused         : Array[1..4] of Byte;
		     Name           : String[40];
                     Typ            : Byte;
                     MsgKinds       : byte{MsgKindsType};
                     Attribute      : Byte;

                      { Bit 0 : Enable EchoInfo
                            1 : Combined access
                            2 : File attaches
                            3 : Allow aliases
                            4 : Use SoftCRs as characters
                            5 : Force handle     
                            6 : Allow deletes
                            7 : Is a JAM area }

                     DaysKill,    { Kill older than 'x' days }
                     RecvKill       : Byte; { Kill recv msgs, recv for more than 'x' days }
                     CountKill      : Word;

                     ReadSecurity   : Word;
                     ReadFlags,
                     ReadNotFlags   : FlagType;

                     WriteSecurity  : Word;
                     WriteFlags,
                     WriteNotFlags  : FlagType;

                     SysopSecurity  : Word;
                     SysopFlags,
                     SysopNotFlags  : FlagType;

                     OriginLine     : String[60];
                     AkaAddress     : Byte;
  
                     Age            : Byte;

                     JAMbase        : String[60];
                     Group          : Word;
                     AltGroup       : Array[1..3] of Word;

                     Attribute2     : Byte;

                      { Bit 0 : Include in all groups }

                     FreeSpace2     : Array[1..9] of Byte;
                   end;



Ra200MsgObj = Object(MsgObj)
 MsgRec: ^Ra200MessageRecord;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor Done; Virtual;
 procedure ChangeArea(AreaNum:Word); Virtual;
 function  GetAreaName:string; Virtual;
 function  isEchomail:boolean;virtual;
 procedure SetAreaName(s:string); Virtual;
 function  NameSize:byte; Virtual;
 procedure CloseFile; Virtual;
 end;

 Ra200MsgPtr = ^Ra200MsgObj;

{$I c:\tp\bin\bbs\pb.215}


PB215MsgObj = Object(MsgObj)
 MsgRec: ^Messages_Pb;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor Done; Virtual;
 procedure ChangeArea(AreaNum:Word); Virtual;
 function  GetAreaName:string; Virtual;
 function  isEchomail:boolean;virtual;
 procedure SetAreaName(s:string); Virtual;
 function  NameSize:byte; Virtual;
 procedure CloseFile; Virtual;
 end;

  Pb215MsgPtr = ^Pb215MsgObj;



type
  RgACString=string[20];            { Access Condition String }
  anontyp =
   (atno,                         { Anonymous posts not allowed }
    atyes,                        { Anonymous posts are allowed }
    atforced,                     { Force anonymous }
    atdearabby,                   { "Dear Abby" base }
    atanyname);                   { Post under any name }

  mbflags=
   (mbunhidden,                   { whether *VISIBLE* to users w/o access }
    mbrealname,                   { whether real names are forced }
    mbcrap,                       { }
    mbinternet,                   { if internet message base }
    mbfilter,                     { whether to filter ANSI/8-bit ASCII }
    mbskludge,                    { strip IFNA kludge lines }
    mbsseenby,                    { strip SEEN-BY lines }
    mbsorigin,                    { strip origin lines }
    mbprivate,                    { allow private messages }
    mbforceread,                  { force the reading of this base }
    mbScanOut,                    { Needs to be scanned out by renemail }
    mbaddtear,                    { add tear/origin lines }
    mbtopstar);                   { whether Top Star for GroupMail base }


  boardrec=                       { MBASES.DAT : Message base records }
  record
    name:string[40];              { message base description }
    filename:string[8];           { HDR/DAT data filename }
    msgpath:string[40];           { messages pathname   }
    ACS,                          { access requirement }
    postACS,                      { post access requirement }
    mciACS,                       { MCI usage requirement }
    sysopACS:RgACString;            { Message base sysop requirement }
    maxmsgs:word;                 { max message count }
    anonymous:anontyp;            { anonymous type }
    password:string[20];          { base password }
    mbstat:set of mbflags;        { message base status vars }
    mbtype:integer;               { base type (0=Local,1=Echo,2=Group) }
    origin:string[50];            { origin line }
    text_color,                   { color of standard text }
    quote_color,                  { color of quoted text }
    tear_color,                   { color of tear line }
    origin_color:byte;            { color of origin line }
    aka:byte;                     { alternate address }
    QWKIndex:word;                { QWK indexing number }
    res:array[1..11] of byte;      { RESERVED }
  end;


RGMsgObj = Object(MsgObj)
 MsgRec: ^BoardRec;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor Done; Virtual;
 procedure ChangeArea(AreaNum:Word); Virtual;
{.$ifdef shit} function  GetAreaName:string; Virtual;{.$endif}
 function  isEchomail:boolean;virtual;
 function  NameSize:byte; Virtual;
 procedure SetAreaName(s:string); Virtual;
 procedure CloseFile; Virtual;
 end;

 RgMsgPtr = ^RgMsgObj;


type

  SBBSFlagType = Array[1..4] of Byte;

               MsgBoardRecord = Record                (* BOARDS.BBS *)
                                  Name:         String[30];
                                  QwkName:      String[12];

                                  Typ:          Byte; { 0=Standard 1=Net 3=Echo }
                                  Kinds:        Byte; { 0=Private & Public
                                                        1=Private 2=Public 3=Read-Only}
                                  Aliases:      Byte; {0=no aliases,1=yes,2=ask alias,
                                                       3=Alias/name}

                                  ReadSecLvl:   Integer;
                                  ReadFlags:    SbbsFlagType;

                                  WriteSecLvl:  Integer;
                                  WriteFlags:   SbbsFlagType;

                                  SysopSecLvl:  Integer;
                                  SysopFlags:   SbbsFlagType;

                                  Group:        Char;
                                  Replystatus:  byte; {0 = normal, 1 = net/normal
                                                       2 = net only, 3 = no replies}
                                  Age:          Byte;
                                  Attrib:       Byte;
                                  UseAka:       Byte;

                                End;

               (*
                  Attributes :

                  bit 0 : Combined
                  bit 1 : Default combined
                  bit 2 : Allow message deleting
                  bit 3 : Allow taglines
                  bit 4 : Use in template system
                  bit 5 : Convert 8bit -> 7bit
                  bit 6 : forced ON in the mail check
               *)


sb117MsgObj = Object(MsgObj)
 MsgRec: ^MsgBoardRecord;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor Done; Virtual;
 procedure ChangeArea(AreaNum:Word); Virtual;
 function  GetAreaName:string; Virtual;
 function  isEchomail:boolean;virtual;
 function  NameSize:byte; Virtual;
 procedure SetAreaName(s:string); Virtual;
 procedure CloseFile; Virtual;
 end;

 sb117MsgPtr = ^sb117MsgObj;



const
  MaxSubOps = 10;                 {Maximum number of message section SubOps}

TYPE

  AddressType = RECORD            {Fidonet Style Address (24 Bytes)}
    Zone,                         {Zone, 1   = N. America}
    Net,                          {Net,  120 = SE Michigan}
    Node,                         {Node, 116 = CRIMP BBS}
    Point : WORD;                 {Point, 99% of the time = 0}

    Domain : STRING[15];          {As in FIDONET.ORG}
  END;


  ArFlagType = '@'..'Z';          {AR flags}

  NoYesForcedType = (             {Message section type}
    No,                           {Anonymous messages not allowed}
    Yes,                          {Anonymous messages allowed}
    Forced,                       {Messages forced anonymous}
    AtUnused                      {Reserved}
    );

  {*************************************************************************}
  {* Standard Attributes for Messages                                      *}
  {*************************************************************************}
  MessageAttrFlagType = (
    Msg_Private,                  {1  fPrivate,RaPrivate,JamPrivate}
    Msg_Crash,                    {2  fCrash,Crash,JamCrash}
    Msg_Received,                 {3  fReceived,Received,JamRead}
    Msg_Sent,                     {4  fSent,Sent,JamSent}
    Msg_FileAttached,             {5  fFileAttached,FileAttach,
                                      JamFileAttach}
 Msg_KillSent,                 {6  fKillSent,KillSent,JamKillSent}
    Msg_Local,                    {7  fLocal,LocalMessage,JamLocal}
    Msg_ReturnReceiptRequest,     {8  fReportReceiptRequest,RequestReceipt,
                                      JamReceiptReq}
    Msg_IsReturnReceipt,          {9  fIsReturnReceipt,ReturnReceipt}
    Msg_AuditRequest,             {10 fAuditRequest,AuditRequest}

    Msg_InTransit,                {11 fInTransit,JamIntransit}
    Msg_Orphan,                   {12 fOrphan,JamOrphan}
    Msg_HoldForPickup,            {13 fHoldForPickup,JamHold}
    Msg_Fido_UnusedBit10,         {14 fUnusedBit10}
    Msg_FileRequest,              {15 fFileRequest,JamFileRequest}
    Msg_Fido_FileUpdateRequest,   {16 fFileUpdateRequest}

    Msg_Deleted,                  {17 Deleted,JamDeleted}
    Msg_Ra_NetmailPendingExport,  {18 NetmailPendingExport}
    Msg_NetMailMessage,           {19 NetMailMessage,JamTypeNet}
    Msg_Ra_EchomailPendingExport, {20 EchomailPendingExport}
    Msg_Ra_UnusedMsgBit7,         {21 UnusedMsgBit7}
    Msg_Ra_UnusedNetBit7,         {22 UnusedNetBit7}

    Msg_Jam_ArchiveSent,          {23 JamArchiveSent}
    Msg_Jam_Immediate,            {24 JamImmediate}
    Msg_Jam_Direct,               {25 JamDirect}
    Msg_Jam_Gate,                 {26 JamGate}
    Msg_Jam_ConfirmRequest,       {27 JamConfirmReq}
    Msg_Jam_ForcePickUp,          {28 JamFpu}
    Msg_Jam_TypeLocal,            {29 JamTypeLocal}
    Msg_Jam_TypeEcho,             {30 JamTypeEcho}
    Msg_Jam_NoDisplay,            {31 JamNoDisp}
    Msg_Jam_Locked                {32 JamLocked}
  ); {4 Bytes Total}

  MessageAttrFlagSet =            {Set of message attributes}
    Set of MessageAttrFlagType;

  MBstyle = (                     {Message section style flags}
    uumbbstyle,                   {Was For Private Mail Board}
    LocalStyle,                   {Local}
    EchoStyle,                    {Echomail}
    NetmailStyle,                 {Netmail}
    GroupStyle                    {Groupmail}
    );

  MBtype = (                      {Message section type flags}
    uumbtype,                     {Was For Netmail Board}
    FidoFormat,                   {Fido 1.Msg Format}
    RaFormat,                     {Remote Access Format}
    JamFormat);                   {Jam Format}

  MboardType = RECORD             {Message boards - MBOARDS.DAT}
    Name : STRING[64];            {Name of the Board}

    Mstyle : MBstyle;             {Local/Echo/Netmail}

    Mtype : MBtype;               {Message Board Type}

    RaBoard : BYTE;               {Board Number if RA/QBBS type}

    Path : STRING[64];            {Directory PathName}

    OriginLine : STRING[65];      {Origin Line}

    AccessAR,                     {AR flag Required to Access}
    PostAR : ArFlagType;          {AR flag required to Post}

    AccessSL,                     {Security Level Required to Access}
    PostSL : BYTE;                {Security Level Required to Post}

    MsgCount,                     {Count of Msgs on the Board}
    MaxMsgs,                      {Max Number of Messages}
    uuMaxOld : WORD;              {Max Days for Messages}

    Password : STRING[16];        {Password Required}

    Anon : NoYesForcedType;       {Anonymous Type}

    AllowAnsi : BOOLEAN;          {Should we allow ANSI}

    AllowHandle :                 {Should we allow handles}
      NoYesForcedType;            

    {*********************************************************}
    {* Message Board SubOpts List  - Up to 10 - User Numbers *}
    {*********************************************************}
    SubOps :                      {SubOps - Item 0 = How many}
      ARRAY[0..MaxSubOps] OF
      INTEGER;                    

    EchoTag : STRING[32];         {Echo Tag for Writing ECHOMAIL.BBS}

    UseOtherAddress: BOOLEAN;     {Use something other than system}

    JamBoard : STRING[8];         {JAM 8 character file name}

    AskPrivate : Boolean;         {Ask if in area private message (echos)}

    Reserved:                     {Unused}
      ARRAY[1..13] of byte;

    MenuNumber : BYTE;            {Default read message number (if 0, use system default}

    PrePostFile : STRING[8];      {Prepost file name}

    MinMsgs : BYTE;               {Minimum number of messages}

    QuoteStart,                   {Override starting quote}
    QuoteEnd : STRING[70];        {Override ending quote}

    QwkConf : WORD;               {QWK Conference Number}

    GroupNumber : BYTE;           {What group the board belongs}

    OtherAddress : AddressType;   {The Address to use!}

    RestrictPrivate:              {Private mail status}
      NoYesForcedType;

    DefaultAttr :                 {Default message flags}
      MessageAttrFlagSet;

    QwkName : String[10];         {QWK Conference Name}

    Filter7Bit : Boolean;         {Only allow 7 bit characters}
  END;


Tag27MsgObj = Object(MsgObj)
 MsgRec: ^MBoardType;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor Done; Virtual;
 procedure ChangeArea(AreaNum:Word); Virtual;
 function  GetAreaName:string; Virtual;
 function  isEchomail:boolean;virtual;
 function  NameSize:byte; Virtual;
 procedure SetAreaName(s:string); Virtual;
 procedure CloseFile; Virtual;
 end;

 Tag27MsgPtr = ^Tag27MsgObj;



type

  Tg300acstring  = string[40];                     { Access Control System string }

{  unixtime  = longint;                        { unix time stamp - seconds
                                                  since 01/01/70 }


  mareaflags=           { MAREAS.DAT status flags }
  (
     mbrealname_Tg,                              { real names are forced }
     mbvisible,                               { visible to users w/o access }
     mbansi,                                  { filter ANSI }
     mb8bit,                                  { filter 8-bit }
     mbstrip,                                 { strip center/title codes }
     mbaddtear_Tg,                               { add tear/origin lines }
     mbnopubstat,                             { messages not added to user }
                                              {   public post total - i.e. }
                                              {   will not calculate in PCR }
     mbreserved1,                             { RESERVED }
     mbinternet_Tg,                              { Internet (UUCP) handling }
     mbreserved2,                             { RESERVED }
     mbstripcolour                            { strip TG colour codes }
  );

  marearec=             { MAREAS.DAT : Message base records }
  record
     name,                                    { message base description }
     msgpath    : string[40];                 { messages pathname }
     filename,                                { data filenames }
     infofile   : string[8];                  { base info filename }
     readacs,                                 { read access }
     postacs,                                 { post access }
     sysopacs,                                { SysOp access }
     netacs     : Tg300acstring;                   { network access }
     maxmsgs,                                 { max message count }
     maxdays    : word;                       { max days to keep messages }
     mstatus    : set of mareaflags;          { status }
     mbformat,                                { message base format }
     mbtype,                                  { message base type }
     anonymous,                               { anonymous type }
     mbpost     : byte;                       { message base posting type }
     origin     : string[50];                 { origin line }
     kludge_color,                            { color of kludge line }
     quote_color,                             { color of quoted line }
     tear_color,                              { color of tear line }
     origin_color,                            { color of origin line }
     addr,                                    { network addr # }
     scantype   : byte;                       { scan type  0 = Default ON
                                                           1 = Default OFF
                                                           2 = Mandatory }
     createdate : unixtime;                   { base creation date }
     qwkindex   : longint;                    { QWK-permanent index }
     text_color : byte;                       { color of text line }
     reserved   : array[1..40] of byte;       { RESERVED }
  end;



Tg300MsgObj = Object(MsgObj)
 MsgRec: ^MareaRec;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor Done; Virtual;
 procedure ChangeArea(AreaNum:Word); Virtual;
 function  GetAreaName:string; Virtual;
 function  isEchomail:boolean;virtual;
 function  NameSize:byte; Virtual;
 procedure SetAreaName(s:string); Virtual;
 procedure CloseFile; Virtual;
 end;

 Tg300MsgPtr = ^Tg300MsgObj;



nx099_MBFlags=                          { Message Base Flags                       }

   (nxMBUnhidden,                   { whether *VISIBLE* to users w/o access    }
    nxMBRealname,                   { whether real names are forced            }
    nxMBFilter,                     { whether to filter ANSI/8-bit ASCII       }
    nxMBSKludge,                    { strip IFNA kludge lines                  }
    nxMBSSeenby,                    { strip SEEN-BY lines                      }
    nxMBNetmail,                    { whether netmail allowed to be sent       }
                                  { from this base                           }
    nxMBSOrigin);                   { strip origin lines                       }

nx099_MBPrivLvl=                        { MSG Types allowed                        }

   (Private,                      { Private Only                             }
    Public,                       { Public Only                              }
    PubPriv);                     { Public OR Private                        }

nx099_ACString     = STRING[20];     { Access Control String                    }
nx099_JoinedConfs     = 'A'..'Z';       { Conference Set                           }

Nexus099_MsgBaseREC=
RECORD
    Name         : STRING[70];    { Message base description                 }
    Filename     : STRING[8];     { JAM/SQUISH Message Base Filename         }
                                  { *NOT NEEDED for .MSG                     }
    NetTagName   : STRING[50];    { Network Tag Name                         }
    MBType       : INTEGER;       { 0 = Local                                }
                                  { 1 = Echo                                 }
                                  { 2 = Netmail                              }
                                  { 3 = Internet E-Mail                      }
    MSGPath      : STRING[40];    { Messages pathname                        }
                                  { For JAM/Squish this is the path to the   }
                                  { Message Base Files.  For *.MSG, this is  }
                                  { the path to the .MSG files               }
    MBFlag       : SET of
                        nx099_MBFlags;  { Message Base Flags                       }
    MBPriv       : SET of
                        nx099_MBPrivLvl;{ Message Priveledge Level                 }
    Access       : nx099_ACString;      { Access to this Base                      }
    PostAccess   : nx099_ACString;      { Access to Post on this Base              }
    MaxMSGS      : WORD;          { Maximum Messages in this Base            }
    AccessKey    : STRING[20];    { Access Key to this Base                  }

                                  { Following colors are in TEXTATTR form:   }

    TextColor    : BYTE;          { color of standard text                   }
    QuoteColor   : BYTE;          { color of quoted text                     }
    TagColor     : BYTE;          { color of taglines                        }
    OldTearColor : BYTE;          { color of old tear lines (___ or ~~~)     }
    TearColor    : BYTE;          { color of tear line                       }
    OriginColor  : BYTE;          { color of origin line                     }
    Address      : ARRAY[1..30] of
                        BOOLEAN;  { Address (1-30) out of NETWORK.DAT        }
                                  { Only one TRUE for ECHOMAIL bases         }
                                  { Only one TRUE for INTERNET EMAIL bases   }
                                  { Any number TRUE for NETMAIL Bases        }
    Origin       : BYTE;          { Origin Line (1-20) out of NETWORK.DAT    }
    RESERVED1    : BYTE;          { RESERVED - DO NOT MODIFY                 }
    MessageType  : BYTE;          { 1 = Squish                               }
                                  { 2 = JAM(mbp)(tm)                         }
                                  { 3 = .MSG                                 }
    DefTagType   : BYTE;          { 0 = Default Tagged                       }
                                  { 1 = Default Untagged                     }
                                  { 2 = Mandatory                            }
    NameUsage    : BYTE;          { 0 = Real Name                            }
                                  { 1 = Alias                                }
                                  { 2 = Ask                                  }
                                  { Included for FUTURE USE                  }
    InConfs      : SET of
                     nx099_JoinedConfs; { Conferences this Message Base is in      }
    Gateway:BYTE;                 { For INTERNET BASES : GATEWAY NUMBER from }
                                  { INTERNET.DAT.  Ignored on other bases.   }
    RESERVED2    : ARRAY[1..93] of  {changed from 94 to 93!!!!!!}
                        BYTE;     { RESERVED - DO NOT MODIFY                 }
    MBaseID      : LONGINT;       { permanent index #                        }
END;


nx099_MsgObj = Object(MsgObj)
 MsgRec: ^Nexus099_MsgBaseREC;
 areanumber:word;
 Constructor Init(fname:string);
 Destructor  Done; Virtual;
 procedure   ChangeArea(AreaNum:Word); Virtual;
 function    GetAreaName:string; Virtual;
 function    isEchomail:boolean;virtual;
 function    NameSize:byte; Virtual;
 procedure   SetAreaName(s:string); Virtual;
 procedure   CloseFile; Virtual;
 end;

 nx099_MsgPtr = ^nx099_MsgObj;


