{.$DEFINE CRASH}   { if we can't get memory, just quit here, else use the }
                   { standard (?) OOP method }

{.$DEFINE XMS}

(*

Unit originally from SWAG by Holger Daehre@2:248/317.88.
Modifed by Andrew Ziem@1:128/234.0 <psych0o@juno.lcom>

modifications

 * added ps2rec for easier multiple array handling
 * added conventional memory support instead of just EMS
 * halts if it can't get memory
 * added append_array procedure
 * removed existant check for array in write_array - helps in speed?

to do list

 * DPMI support

*)

(* Unit LongArray - large arrays in EMS
   PUBLIC DOMAIN  1993 by Holger Daehre 2:248/317.88
   Running: TP 6.0 or above. *)

{$A+,R-}

Unit LongArr;

Interface

Uses
 Objects{$IFDEF XMS}, TXMSSTR{$ENDIF};

const

 { these corespodn to ps2rec.where }

 ps2wConv = 0; { disk / lower (lower?) }
 ps2wEMS  = 1; { Extended Memory Specification (?) }
 ps2wXMS  = 2; { eXtended Memory Specification (?) }
 ps2wDPMI = 3; { Dos Protected-mode Memory Interface }

 { change this to suite your system }

 Swapname : string[11] = 'c:\swap.psy';

type
 ps2rec= record
         ps           : pstream;
         lo_element,             { bottom element (array[Lo_Elememnt...}
         elementsize  : LongInt; { size of each element }
         where        : byte;    { what piece of memory is it in? }
         elements     : longint; { how many elements there are }
         end;

(* Create_Array creates  Array[Low..High] of Size *)
{$IFDEF CRASH}
Procedure Create_Array(Var ps2:ps2rec;Low,High,Size:LongInt); {$ELSE}
Function Create_Array(Var ps2:ps2rec;Low,High,Size:LongInt): boolean; {$ENDIF}


(* Read_Array loads one element from INDEX into Buf *)
Procedure Read_Array(Var ps2:ps2rec;Index:LongInt;Var Buf);

(* Write_Array stores the information of Buf in Index *)
Procedure Write_Array(Var ps2:ps2rec;Index:LongInt;Var Buf);

(* Dispose_Array releases the allocated memory *)
Procedure Dispose_Array(Var ps:pStream);

(* Appends Buf to the array *)
procedure Append_Array(var ps2:ps2rec;var buf);

Implementation


{$IFDEF CRASH}
Procedure Create_Array(Var ps2:ps2rec;Low,High,Size:LongInt); {$ELSE}
Function Create_Array(Var ps2:ps2rec;Low,High,Size:LongInt): boolean; {$ENDIF}

Var
   ArraySize:LongInt;

Begin
   Create_Array:=true;
   ps2.Lo_element:=Low;
   ps2.elements:=High-Low+1;
   ArraySize:=ps2.elements * Size;
   ps2.ElementSize:=Size;

   {$IFDEF XMS}
   { try XMS memory first }
   ps2.ps := New(pXMSStream, Init(ArraySize{,ArraySize)}));
   ps2.where:=ps2wXMS;

   if ps2.ps^.status <> stOK then
    begin;
    dispose(ps2.ps,done);
    ps2.ps := nil;
    {$ELSE}
    begin;
    {$ENDIF}
    ps2.ps := New(pEMSStream, Init(ArraySize,ArraySize));
    { tries EMS memory second }
    ps2.where:=ps2wEMS;
    if ps2.ps^.status <> stOK then
     begin;
    { try disk last }
     dispose(ps2.ps,done);
     ps2.ps := NIL;
     ps2.ps := New(pDOSStream, Init(Swapname,arraysize));
     ps2.where:=ps2wConv;
     If ps2.ps^.status <> stOK Then
     Begin
      Dispose(ps2.ps, Done);
      ps2.ps := NIL;
      { you could use FAIL here instead of the next two lines }
      {$IFDEF CRASH}
      writeln('critical error, could not get ',arraysize,' bytes of memory');
      halt(255);
      {$ELSE}
      Create_Array:=false;
      {$ENDIF}
      End; { conventional failed }
     end;
    end;
End;


Procedure Read_Array(Var ps2:ps2rec;Index:LongInt;Var Buf);
Begin
{ If ps2.ps<>nil Then
 Begin}
  ps2.ps^.Seek((Index-ps2.Lo_element)*ps2.ElementSize);
  ps2.ps^.Read(Buf,ps2.ElementSize);
{ End;}
End;

Procedure Write_Array(Var ps2:ps2rec;Index:LongInt;Var Buf);
Begin
{ If ps2.ps<>nil Then
 Begin}
  ps2.ps^.Seek((Index-ps2.Lo_element)*ps2.ElementSize);
  ps2.ps^.Write(Buf,ps2.ElementSize);
{ End;}
End;

procedure Append_Array(var ps2:ps2rec;var buf);
begin;
ps2.ps^.seek((ps2.elements*ps2.elementsize));
inc(ps2.elements);
ps2.ps^.write(Buf,ps2.ElementSize);
if ps2.ps^.status <> stOK then
 begin;
 writeln('memory allocation error, need ',ps2.elements*ps2.elementsize,' bytes');
 halt(255);
 end;
end;


procedure Dispose_Array(Var ps:pStream);
Begin
 if ps<>nil then Dispose(ps,Done);
 ps:=NIL;
End;

End.




{Program LongArrayDemo;
Uses Objects,LongArr;
Var MyArr:PStream;
    S:String;
    I:Word;
Begin
{  Create_Array(MyArr,0,4096,SizeOf(String));
  If MyArr=nil Then
  Begin
   WriteLn('Couldn''t create array in EMS');
   Halt;
  End;
  S:='This is a TEST !';
  For I:=0 To 4096 Do  Write_Array(MyArr,I,S);
  s:='';
  Randomize;
  Read_Array(MyArr,Random(4096),S);
  WriteLn(S);
  Dispose_Array(MyArr);}
End.
