****************************
* Werd Nerd 3.04           *
* 		           *
* By Porter Venn III       *
* 04/10/94 - 06/23/96      *	
*		           *
* Copyright 1994,1995,1996 *
* BBsoft Co.	           *
****************************

&& TYPE werd30.txt		&& Take this out later
&& WAIT                    && Me too


ON ERROR DO errortrap
ON DISCONNECT DO hangup

************************** Initial Game Setup Procedures ********************

DO setup_params		&& Setup Initial Parameters (SETS etc...)
DO set_vars		&& Setup Globals and Initial Variable Values
DO checkansi		&& Check that user ANSI/IBM settings are on
DO checksysop	        && Check to see if user has Sysop Access (PRIV 255)
DO getkey		&& Get Security key
DO intro		&& Intro Screen
DO checkmonth		&& Check to see if its a new month
DO getconfig		&& Get game configuation settings
DO getuser		&& Get the user out of players.dbf or create him.
DO show_initial 	&& Paint screen & Show initial values
DO pre_game		&& Ask user pre-game Questions (Scores,Instruct,etc)
DO go_on		&& Check to see if user has games left

*****************************************************************************
**                         Main Program Code Body                          **
***************************************************************************** 
DO WHILE .T.
	DO press_start		&& Press Any Key to Start
	DO get_letters		&& Randomly Get Letters for this game	
	DO show_letters		&& Show the letters
	DO start_timer		&& Start the 60 second timer
	DO WHILE .T.				&& Game Round begins

		DO get_word			&& Get word from user...
		IF game_end = "YES"		&& If game is over, exit loop	
			game_end = "NO"	
			EXIT
		ENDIF 				&& If not over, continue ...
		DO add_word			&& Add the word to big board
	LOOP
	ENDDO
	DO check_spell		&& Check Big Board Spelling
	first = "YES"
LOOP
ENDDO
****************************************************************************	
		
?? "Should never be here...  End of Main Code Core.  Please contact your sysop"
?? "Mention ERORR: OUT OF LOOP. MAIN CODE CORE."
WAIT
QUIT






**************************** Randomly Select Letters ************************

PROCEDURE get_letters
PRIVATE got_it[100]

SET COLOR TO bg/w
beavis = 3
DO WHILE beavis <= 12
	@ beavis,5 SAY SPACE(70)
beavis = beavis + 1
LOOP
ENDDO

zz = 1
DO WHILE zz <= 100
	got_it[zz] = " "
	zz = zz + 1
LOOP
ENDDO

SET COLOR TO GR+*/r
@ 17,3 SAY "                "
@ 18,3 SAY "                "
@ 19,3 SAY "                "
@ 20,3 SAY "                "
@ 21,3 SAY "                "
@ 17,3 SAY "Picking Letters"

RESTORE from random additive
x = 1

DO WHILE x <= 12
	maxnum = 100
	mrec = 0
	DO WHILE .T.
		DO random WITH maxnum,mrec
		IF got_it[mrec] <> "XXX"
			got_it[mrec] = "XXX"
			EXIT
		ENDIF
	LOOP
	ENDDO

	DO CASE
	CASE mrec = 1
		letter[x] = "A"
	CASE mrec = 2
		letter[x] = "A"
	CASE mrec = 3
		letter[x] = "A"
	CASE mrec = 4
		letter[x] = "A"
	CASE mrec = 5
		letter[x] = "A"
	CASE mrec = 6
		letter[x] = "A"
	CASE mrec = 7
		letter[x] = "A"
	CASE mrec = 8
		letter[x] = "A"
	CASE mrec = 9
		letter[x] = "B"
	CASE mrec = 10
		letter[x] = "B"
	CASE mrec = 11
		letter[x] = "C"
	CASE mrec = 12
		letter[x] = "C"
	CASE mrec = 13 
		letter[x] = "C"
	CASE mrec = 14
		letter[x] = "D"
	CASE mrec = 15
		letter[x] = "D"
	CASE mrec = 16
		letter[x] = "D"
	CASE mrec = 17
		letter[x] = "D"
	CASE mrec = 18
		letter[x] = "E"
	CASE mrec = 19
		letter[x] = "E"
	CASE mrec = 20
		letter[x] = "E"
	CASE mrec = 21
		letter[x] = "E"
	CASE mrec = 22
		letter[x] = "E"
	CASE mrec = 23
		letter[x] = "E"
	CASE mrec = 24
		letter[x] = "E"
	CASE mrec = 25
		letter[x] = "E"
	CASE mrec = 26
		letter[x] = "E"
	CASE mrec = 27
		letter[x] = "E"
	CASE mrec = 28
		letter[x] = "E"
	CASE mrec = 29
		letter[x] = "F"
	CASE mrec = 30
		letter[x] = "F"
	CASE mrec = 31
		letter[x] = "F"
	CASE mrec = 32
		letter[x] = "G"
	CASE mrec = 33
		letter[x] = "G"
	CASE mrec = 34
		letter[x] = "G"
	CASE mrec = 35
		letter[x] = "H"
	CASE mrec = 36
		letter[x] = "H"
	CASE mrec = 37
		letter[x] = "I"
	CASE mrec = 38
		letter[x] = "I"
	CASE mrec = 39 
		letter[x] = "I"
	CASE mrec = 40
		letter[x] = "I"
	CASE mrec = 41
		letter[x] = "I"
	CASE mrec = 42
		letter[x] = "I"
	CASE mrec = 43
		letter[x] = "I"
	CASE mrec = 44
		letter[x] = "I"
	CASE mrec = 45
		letter[x] = "I"
	CASE mrec = 46
		letter[x] = "J"
	CASE mrec = 47
		letter[x] = "K"
	CASE mrec = 48
		letter[x] = "L"
	CASE mrec = 49
		letter[x] = "L"
	CASE mrec = 50
		letter[x] = "L"
	CASE mrec = 51
		letter[x] = "L"
	CASE mrec = 52
		letter[x] = "M"
	CASE mrec = 53
		letter[x] = "M"
	CASE mrec = 54
		letter[x] = "N"
	CASE mrec = 55
		letter[x] = "N"
	CASE mrec = 56
		letter[x] = "N"
	CASE mrec = 57
		letter[x] = "N"
	CASE mrec = 58
		letter[x] = "N"
	CASE mrec = 59
		letter[x] = "N"
	CASE mrec = 60
		letter[x] = "O"
	CASE mrec = 61
		letter[x] = "O"
	CASE mrec = 62
		letter[x] = "O"
	CASE mrec = 63
		letter[x] = "O"
	CASE mrec = 64
		letter[x] = "O"
	CASE mrec = 65
		letter[x] = "O"
	CASE mrec = 66
		letter[x] = "O"
	CASE mrec = 67
		letter[x] = "O"
	CASE mrec = 68
		letter[x] = "P"
	CASE mrec = 69
		letter[x] = "P"
	CASE mrec = 70
		letter[x] = "Q"
	CASE mrec = 71
		letter[x] = "R"
	CASE mrec = 72
		letter[x] = "R"
	CASE mrec = 73
		letter[x] = "R"
	CASE mrec = 74
		letter[x] = "R"
	CASE mrec = 75
		letter[x] = "R"
	CASE mrec = 76
		letter[x] = "R"
	CASE mrec = 77
		letter[x] = "S"
	CASE mrec = 78
		letter[x] = "S"
	CASE mrec = 79
		letter[x] = "S"
	CASE mrec = 80
		letter[x] = "S"
	CASE mrec = 81
		letter[x] = "T"
	CASE mrec = 82
		letter[x] = "T"
	CASE mrec = 83
		letter[x] = "T"
	CASE mrec = 84
		letter[x] = "T"
	CASE mrec = 85
		letter[x] = "T"
	CASE mrec = 86
		letter[x] = "T"
	CASE mrec = 87
		letter[x] = "U"
	CASE mrec = 88
		letter[x] = "U"
	CASE mrec = 89 
		letter[x] = "U"
	CASE mrec = 90
		letter[x] = "U"
	CASE mrec = 91
		letter[x] = "V"
	CASE mrec = 92
		letter[x] = "V"
	CASE mrec = 93
		letter[x] = "W"
	CASE mrec = 94
		letter[x] = "W"
	CASE mrec = 95
		letter[x] = "X"
	CASE mrec = 96
		letter[x] = "X"
	CASE mrec = 97
		letter[x] = "Y"
	CASE mrec = 98
		letter[x] = "Y"
	CASE mrec = 99
		letter[x] = "Z"
	CASE mrec = 100
		letter[x] = "Z"
	ENDCASE


x = x + 1
LOOP
ENDDO

SAVE TO random ALL LIKE A?SEED
SET COLOR TO r/r

RETURN
*****************************************************************************




*************************** Show letters on the screen **********************
PROCEDURE show_letters

SET COLOR TO g/g
@ 17,28 SAY SPACE(24)
@ 20,41 SAY SPACE(10)

SET COLOR TO W+/g
x = 1
col = 28
DO WHILE x <= 12
	@ 17,COL SAY letter[x]
	col = col + 2
	x = x + 1
	IF first = "YES"
		delay = .15
		DO pause WITH delay
	ENDIF
LOOP
ENDDO

first = "NO"

SET COLOR TO gr+/g
@ 20,29 SAY t_left PICTURE "##"

RETURN
*****************************************************************************






**************************** Get Word from user *****************************
PROCEDURE get_word
PRIVATE temp_letter[12]

gw_col = 41

SET COLOR TO g/g
@ 20,(gw_col-1) SAY " "
x_let = 0

clearit = 1
DO WHILE clearit <= 10
	get_word[clearit] = " "
	clearit = clearit + 1
LOOP
ENDDO

tankaray = ACOPY(letter,temp_letter)

DO WHILE .T.
	CLEAR TYPEAHEAD
	key = 0
	key = INKEY(1)
	DO timer
	IF game_end = "YES"
		RETURN
	ENDIF
	IF key <> 0	
		IF key = 27
			games_left = games_left - 1
			IF games_left <= 0
				games_left = 0
			ENDIF
			DO save_scores
			SET COLOR TO GR+*/r
			@ 17,3 SAY "                "
			@ 18,3 SAY " Aborting Game.."
			@ 19,3 SAY "                "
			@ 20,3 SAY "                "
			@ 21,3 SAY "                "
			delay = 3
			DO pause WITH delay
			QUIT
		ENDIF

		IF key = 13
			RETURN
		ENDIF

		IF key = 8 .AND. x_let > 0
			counter = 1
			DO WHILE counter <= 12
				zummy = ASCAN(letter,get_word[x_let],counter)
				IF temp_letter[zummy] = CHR(206)
					temp_letter[zummy] = get_word[x_let]
					SET COLOR TO W+/g
					@ 17,(26 + (zummy*2)) SAY get_word[x_let]
					counter = 12
				ENDIF
				counter = counter + 1
			LOOP
			ENDDO

			get_word[x_let] = SPACE(1)
			
			gw_col = gw_col - 1	
			x_let = x_let - 1
			SET COLOR TO g/g
			@ 20,gw_col SAY " "	
		ENDIF

		dummy = ASCAN(temp_letter,UPPER(CHR(key)))
		IF dummy <> 0
			IF key <> 8 .AND. x_let < 10
				SET COLOR TO g/g
				@ 17,(26 + (dummy*2)) SAY " "
				x_let = x_let + 1
				SET COLOR TO n/g
				@ 20,gw_col SAY UPPER(CHR(key))
				gw_col = gw_col + 1
				get_word[x_let] = UPPER(CHR(key))
				temp_letter[dummy] = CHR(206)
			ENDIF
		ENDIF
	ENDIF
LOOP
ENDDO
*****************************************************************************

?? "Out of Procedure Error.   Please mention this problem to your sysop"
?? "Error:  END OF GET WORD"
WAIT
QUIT



**************************** Add Word to Big Board **************************
PROCEDURE add_word

new_word = " "
x = 1

DO WHILE x <= 10
	new_word = new_word + get_word[x]
	x = x + 1
LOOP
ENDDO

new_word = LTRIM(RTRIM(new_word))
IF LEN(new_word) < 3 
	SET COLOR TO GR+*/r
	@ 17,3 SAY " All words must "
	@ 18,3 SAY " have at least  "
	@ 19,3 SAY " 3 letters !    "
	@ 20,3 SAY "                "
	@ 21,3 SAY "                "
	delay = 3
	DO pause WITH delay
	SET COLOR TO GR+/r
	@ 17,3 SAY " Hint: You have "
	@ 18,3 SAY " 60 seconds to  "
	@ 19,3 SAY " type in as many"
	@ 20,3 SAY " words you can. "
	SET COLOR TO W+/r
	@ 21,3 SAY "  [ESC] = ABORT "

	DO show_letters
	RETURN
ENDIF

IF aw_counter > 1
	beavis = 1
	beavis_row = 3
	beavis_col = 5

	DO WHILE beavis <= (aw_counter -1)
		IF pick_words[beavis] = new_word
			SET COLOR TO GR+/r
			@ 17,3 SAY " You already    "
			@ 18,3 SAY " have that word!"
			@ 19,3 SAY "                "
			@ 20,3 SAY "                "
			@ 21,3 SAY "                "
			SET COLOR TO GR+*/w
			@ beavis_row,beavis_col SAY pick_words[beavis]
			delay = 3
			DO pause WITH delay
			SET COLOR TO r/w
			@ beavis_row,beavis_col SAY pick_words[beavis]
			SET COLOR TO GR+/r
			@ 17,3 SAY " Hint: You have "
			@ 18,3 SAY " 60 seconds to  "
			@ 19,3 SAY " type in as many"
			@ 20,3 SAY " words you can. "
			SET COLOR TO W+/r
			@ 21,3 SAY "  [ESC] = ABORT "
			DO show_letters
			RETURN
		ENDIF
	beavis = beavis + 1
	beavis_row = beavis_row + 1
	IF beavis_row = 13
		beavis_col = beavis_col + 18
		beavis_row = 3
	ENDIF
	LOOP
	ENDDO
ENDIF

pick_words[aw_counter] = new_word
aw_counter = aw_counter + 1

IF aw_counter > 40
	t_left = 0
ENDIF

SET COLOR TO r/w
@ top_row,top_col SAY new_word

top_row = top_row + 1

IF top_row = 13
	top_col = top_col + 18
	top_row = 3
ENDIF
DO show_letters

RETURN
*****************************************************************************



************************** Start 60 Second Timer Routine ********************
PROCEDURE start_timer
timer_sec = SECONDS()
SET COLOR TO GR+/r
@ 17,3 SAY " Hint: You have "
@ 18,3 SAY " 60 seconds to  "
@ 19,3 SAY " type in as many"
@ 20,3 SAY " words you can. "
SET COLOR TO W+/r
@ 21,3 SAY "  [ESC] = ABORT "
RETURN
*****************************************************************************



****************************** 60 second Game timer *************************
PROCEDURE timer

IF t_left <= 0
	game_end = "YES"	
	RETURN
ENDIF

now_sec = SECONDS()
t_left = (timer_sec + timer) - now_sec

SET COLOR TO gr+/g
@ 20,29 SAY ABS(t_left) PICTURE "##"

IF t_left <= 5
	SET COLOR TO gr+*/g
	@ 20,29 SAY ABS(t_left) PICTURE "##"
ENDIF

SET COLOR TO g/g
@ 20,gw_col SAY " "	

RETURN
*****************************************************************************




************************** Check Users Spelling on Big Board ****************
PROCEDURE check_spell

temp_word = "Z"
temp_score = 0

SET COLOR TO r/r
@ 17,3 SAY "                "
@ 18,3 SAY "                "
@ 19,3 SAY "                "
@ 20,3 SAY "                "
@ 21,3 SAY "                "

SET COLOR TO gr+/g
@ 20,29 SAY " 0"

SET COLOR TO W+*/r
@ 17,3 SAY "   Game Over   "
delay = 1.5
DO pause WITH delay
SET COLOR TO GR+/r
@ 17,3 SAY " Adding Scores.."

CLEAR TYPEAHEAD

top_col = 16   	
top_row = 3
let_score = 0
word_score = 0

aw_counter = aw_counter - 1
tu_counter = 1
this_word = 1							&& 3.02

USE spell INDEX spell

DO while this_word <= aw_counter
	SEEK pick_words[this_word] 
	IF FOUND()
		word_length = LEN(pick_words[this_word])

		tu[tu_counter] = times_used			&& 3.02
		tu[tu_counter] = tu[tu_counter] + 1		&& 3.02
		REPLACE times_used WITH tu[tu_counter]		&& 3.02
		tu_word[tu_counter] = pick_words[this_word] 	&& 3.02		
		tu_counter = tu_counter + 1			&& 3.02		
		
		beavis = 1
		DO WHILE beavis <= word_length
			z_letter = SUBSTR(pick_words[this_word],beavis,1)
			DO CASE
			case z_letter = "A"
				let_score = let_score +1
			case z_letter = "B"
				let_score = let_score +6
			case z_letter = "C"
				let_score = let_score +6
			case z_letter = "D"
				let_score = let_score +4
			case z_letter = "E"
				let_score = let_score +1
			case z_letter = "F"
				let_score = let_score +8
			case z_letter = "G"
				let_score = let_score +4
			case z_letter = "H"
				let_score = let_score +8
			case z_letter = "I"
				let_score = let_score +2
			case z_letter = "J"
				let_score = let_score +14
			case z_letter = "K"
				let_score = let_score +10
			case z_letter = "L"
				let_score = let_score +3
			case z_letter = "M"
				let_score = let_score +6
			case z_letter = "N"
				let_score = let_score +2
			case z_letter = "O"
				let_score = let_score +2
			case z_letter = "P"
				let_score = let_score +6
			case z_letter = "Q"
				let_score = let_score +20
			case z_letter = "R"
				let_score = let_score +2
			case z_letter = "S"
				let_score = let_score +2
			case z_letter = "T"
				let_score = let_score +3
			case z_letter = "U"
				let_score = let_score +2
			case z_letter = "V"
				let_score = let_score +9
			case z_letter = "W"
				let_score = let_score +8
			case z_letter = "X"
				let_score = let_score +15
			case z_letter = "Y"
				let_score = let_score +7
			case z_letter = "Z"
				let_score = let_score +17
			ENDCASE
		beavis = beavis + 1
		LOOP
		ENDDO

		color_word = "W+/w"
		color_score = "r/w"

		word_score = let_score
		let_score = 0

		IF word_length = 6
			word_score = INT(word_score * 1.75)
			color_word = "b/w"
			color_score = "b/w"
		ENDIF


		IF word_length = 7
			word_score = INT(word_score * 2.00)
			color_word = "b/w"
			color_score = "b/w"
		ENDIF

		IF word_length = 8
			word_score = INT(word_score * 2.25)
			color_word = "b/w"
			color_score = "b/w"
		ENDIF

		IF word_length = 9
			word_score = INT(word_score * 2.75)
			color_word = "b/w"
			color_score = "b/w"
		ENDIF

		IF word_length = 10
			word_score = INT(word_score * 3.50)
			color_word = "b/w"
			color_score = "b/w"
		ENDIF

		game_score = game_score + word_score

		IF word_score > temp_score
			temp_word = pick_words[this_word]
			temp_score = word_score
			temp_row = top_row
			temp_col = top_col
		ENDIF

		SET COLOR TO &color_word
		@ top_row,(top_col-11) SAY pick_words[this_word]
		SET COLOR TO &color_score
		@ top_row,top_col SAY "+"
		@ top_row,(top_col+2) SAY word_score PICTURE "###"
	ELSE
		game_score = game_score - 5
		SET COLOR TO n/w
		@ top_row,(top_col-11) SAY pick_words[this_word]
		SET COLOR TO n/w
		@ top_row,top_col SAY "-   5"
	ENDIF

	top_row = top_row + 1

	IF top_row = 13
		top_col = top_col + 18
		top_row = 3
	ENDIF
	this_word = this_word + 1
	delay = .15
	DO pause WITH delay

LOOP
ENDDO

IF game_score < 0
	game_score = 0
ENDIF

SET COLOR TO GR+/r
@ 17,3 SAY " Game Score:   "
SET COLOR TO W+/r
@ 17,16 SAY game_score PICTURE "@B ###"
delay = 2
DO pause WITH delay

total_score = total_score + game_score
last_game = game_score

SET COLOR TO W+*/r
@ 17,16 SAY game_score PICTURE "0  "
SET COLOR TO W+*/rb
@ 20,70 SAY last_game PICTURE "@B ###,###"
@ 21,70 SAY total_score PICTURE "@B ###,###"

DO check_most_used					&& 3.0

SET COLOR TO W+/r
@ 17,16 SAY game_score PICTURE "0  "

DO check_bg
DO check_bw

SET COLOR TO W+/rb
@ 20,70 SAY last_game PICTURE "@B ###,###"
@ 21,70 SAY total_score PICTURE "@B ###,###"


games_left = games_left -1
game_score = 0

DO save_scores

SET COLOR TO W+/r
@ 17,3 SAY "               "
@ 18,3 SAY "               "

t_left = timer
SET COLOR TO gr+/g
@ 20,29 SAY t_left PICTURE "##"

SET COLOR TO W+/rb
@ 17,72 SAY games_left PICTURE "@B ###"

SET COLOR TO W+/w

top_col = 5
top_row = 3
aw_counter = 1

beavis = 1
DO WHILE beavis <= 40
	pick_words[beavis] = ""
beavis = beavis + 1
LOOP
ENDDO

CLEAR TYPEAHEAD

SET COLOR TO GR+/r
@ 17,3 SAY " [S]cores/Stats "
@ 18,3 SAY " [N]ext Game    "
@ 19,3 SAY " [I]nstructions "
@ 20,3 SAY " [Q]uit [R]edraw"

SET COLOR TO W+/r
@ 17,5 SAY "S"
@ 18,5 SAY "N"
@ 19,5 SAY "I"
@ 20,5 SAY "Q"
@ 20,12 SAY "R"

DO WHILE .T.
	choice = "N"
	SET COLOR TO GR+/r
	@ 21,3 SAY " :";
	GET choice PICTURE "!A"
	READ
	IF choice = "R"
		DO redraw
	ENDIF

	IF choice = "N"
		IF games_left > 0 
			SET COLOR TO r/r
			@ 17,3 SAY SPACE(16)
			@ 18,3 SAY SPACE(16)
			@ 19,3 SAY SPACE(16)
			@ 20,3 SAY SPACE(16)
			@ 21,3 SAY SPACE(16)
			RETURN
		ENDIF
		IF games_left <= 0
			IF sorry > 8
				SET COLOR TO gr+/r
				@ 17,3 SAY "                "
				@ 18,3 SAY "    GO AWAY !   "
				@ 19,3 SAY "                "
				@ 20,3 SAY "                "			                       
				@ 21,3 SAY "                "
				delay = 4
				DO pause WITH delay
				sorry = sorry + 1 
			ENDIF
			IF sorry > 5 .AND. sorry <= 8
				SET COLOR TO gr+/r
				@ 17,3 SAY "You are a loser "
				@ 18,3 SAY "and in need of  "
				@ 19,3 SAY "a life.  Try    "
				@ 20,3 SAY "again tommorow. "			                       
				@ 21,3 SAY "                "
				delay = 4
				DO pause WITH delay
				sorry = sorry + 1 
			ENDIF
			IF sorry > 2 .AND. sorry <= 5
				SET COLOR TO gr+/r
				@ 17,3 SAY "GET A CLUE!!!   "
				@ 18,3 SAY "                "
				@ 19,3 SAY "You have no     "
				@ 20,3 SAY "more games left "			                       
				@ 21,3 SAY "                "
				delay = 4
				DO pause WITH delay
				sorry = sorry + 1 
			ENDIF
			IF sorry <= 2
				SET COLOR TO gr+/r
				@ 17,3 SAY "Sorry, you have "
				@ 18,3 SAY "no more games   "
				@ 19,3 SAY "left for today. "
				@ 20,3 SAY SPACE(16)			                       
				@ 21,3 SAY SPACE(16)
				delay = 4
				DO pause WITH delay
				sorry = sorry + 1 
			ENDIF
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF
	ENDIF
	IF choice = "S" 
		SET COLOR TO GR+/r
		@ 17,3 SAY " [A]ll [L]eaders"
		@ 18,3 SAY " [1] Best Words "
		@ 19,3 SAY " [2] Best Games "
		@ 20,3 SAY " [3] Most Used  "
		SET COLOR TO W+/r
		@ 17,5 SAY "A"
	        @ 17,11 SAY "L"
		@ 18,5 SAY "1"
		@ 19,5 SAY "2"
		@ 20,5 SAY "3"
		choice = "X"
		SET COLOR TO GR+/r
		@ 21,3 SAY " :";
		GET choice PICTURE "!A"
		READ
		IF choice = "X"
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"	
			@ 21,3 SAY "                "
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF
		IF choice = "A"
			SET COLOR TO r/r
			@ 17,3 SAY SPACE(16)
			@ 18,3 SAY SPACE(16)
			@ 19,3 SAY SPACE(16)
			@ 20,3 SAY SPACE(16)
			@ 21,3 SAY SPACE(16)
			DO stat1
			DO stat2
			DO stat3
			DO stat4
			DO stat5
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"	
			@ 21,3 SAY "                "
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF

		IF choice = "1"
			SET COLOR TO r/r
			@ 17,3 SAY SPACE(16)
			@ 18,3 SAY SPACE(16)
			@ 19,3 SAY SPACE(16)
			@ 20,3 SAY SPACE(16)
			@ 21,3 SAY SPACE(16)
			DO stat3
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"	
			@ 21,3 SAY "                "
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF

		IF choice = "2"
			SET COLOR TO r/r
			@ 17,3 SAY SPACE(16)
			@ 18,3 SAY SPACE(16)
			@ 19,3 SAY SPACE(16)
			@ 20,3 SAY SPACE(16)
			@ 21,3 SAY SPACE(16)
			DO stat4
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"	
			@ 21,3 SAY "                "
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF

		IF choice = "3"
			SET COLOR TO r/r
			@ 17,3 SAY SPACE(16)
			@ 18,3 SAY SPACE(16)
			@ 19,3 SAY SPACE(16)
			@ 20,3 SAY SPACE(16)
			@ 21,3 SAY SPACE(16)
			DO stat5
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"	
			@ 21,3 SAY "                "
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF

		IF choice = "L"
			SET COLOR TO r/r
			@ 17,3 SAY SPACE(16)
			@ 18,3 SAY SPACE(16)
			@ 19,3 SAY SPACE(16)
			@ 20,3 SAY SPACE(16)
			@ 21,3 SAY SPACE(16)
			DO stat1
			DO stat2
			SET COLOR TO GR+/r
			@ 17,3 SAY " [S]cores/Stats "
			@ 18,3 SAY " [N]ext Game    "
			@ 19,3 SAY " [I]nstructions "
			@ 20,3 SAY " [Q]uit [R]edraw"	
			@ 21,3 SAY "                "
			SET COLOR TO W+/r
			@ 17,5 SAY "S"
			@ 18,5 SAY "N"
			@ 19,5 SAY "I"
			@ 20,5 SAY "Q"
			@ 20,12 SAY "R"
		ENDIF


	ENDIF
		

	IF choice = "Q"
		SET COLOR TO r/r
		@ 17,3 SAY SPACE(16)
		@ 18,3 SAY SPACE(16)
		@ 19,3 SAY SPACE(16)
		@ 20,3 SAY SPACE(16)
		@ 21,3 SAY SPACE(16)
		DO save_scores	
		SET COLOR TO GR+/r
		@ 18,3 SAY "  Thanks for   "
		@ 19,3 SAY "  Playing !    "
		delay = 3 
		DO pause WITH delay
		QUIT
	ENDIF
	IF choice = "I"
		SET COLOR TO W+/w
		@  3,5 say "                                                                       "
		@  4,5 say "                                                                       "
		@  5,5 say "                                                                       " 
		@  6,5 say "                                                                       "
		@  7,5 say "                                                                       "
		@  8,5 say "                                                                       "
		@  9,5 say "                                                                       "
		@ 10,5 say "                                                                       "
		@ 11,5 say "                                                                       "
		@ 12,5 say "                                                                       "
		SET COLOR TO r/r
		@ 17,3 SAY SPACE(16)
		@ 18,3 SAY SPACE(16)
		@ 19,3 SAY SPACE(16)
		@ 20,3 SAY SPACE(16)
		@ 21,3 SAY SPACE(16)
		DO instructions
		SET COLOR TO GR+/r
		@ 17,3 SAY " [S]cores/Stats "
		@ 18,3 SAY " [N]ext Game    "
		@ 19,3 SAY " [I]nstructions "
		@ 20,3 SAY " [Q]uit [R]edraw"
		SET COLOR TO W+/r
		@ 17,5 SAY "S"
		@ 18,5 SAY "N"
		@ 19,5 SAY "I"
		@ 20,5 SAY "Q"
		@ 20,12 SAY "R"
	ENDIF

LOOP
ENDDO

?? "Error.  Please mention this problem to your sysop"
?? "ERROR: End of CHECK_SPELL"
WAIT
QUIT
****************************************************************************





***************************** Random Number Generator************************

PROCEDURE RANDOM				&& Random Number Generator
						&& MAXNUM = Number to find
PARAMETERS MaxNum, Mrec				&& MREC = Number Received


DO WHILE .T.
	AXSEED = MOD(40014*AXSEED,2147483563)
	AYSEED = MOD(40692*AYSEED,2147483399)
	RAND_RESULT = MOD(AXSEED + AYSEED,2147483563)
	mrec = INT((rand_result / 21474783563) * (maxnum*10)) + 1

	z_sec = SECONDS()
	z_sec_str = STR(z_sec)
	z_num = VAL(RIGHT(z_sec_str,1))

	IF z_num < 5
		EXIT
	ENDIF
LOOP
ENDDO

RETURN
*****************************************************************************





******************************* Program Pause *******************************

PROCEDURE Pause		&& Pauses for amount of seconds in DELAY
PARAMETERS delay

s1 = SECONDS()
today2 = today				&& today should = DATE() before this
					&& routine is run.
DO WHILE .T.
	s2 = SECONDS()
	IF s2 > (s1+delay)
		EXIT
	ENDIF
	IF DATE() <> today2
		s1 = SECONDS()
		today2 = DATE()
	ENDIF
LOOP
ENDDO

RETURN
*****************************************************************************




********************************* Error Trap *********************************
PROCEDURE errortrap

SET COLOR TO W+
? "An Error has occurred in this program.  Please tell your Sysop that the"
? "following Error has occured: "
? " "
? "Error: "+MESSAGE()
? " "
? " "
WAIT

QUIT
******************************************************************************





******************* Check Current Month / Rollover if new month **************
PROCEDURE checkmonth

thismonth = MONTH(DATE())
thisday = DAY(DATE())

USE config EXCLUSIVE
GOTO TOP
configmonth = d_month
configday = d_day

IF configmonth = 0
	REPLACE d_month WITH thismonth
	REPLACE d_day WITH thisday
	CLOSE ALL
	RETURN
ENDIF

IF configmonth <> thismonth
	REPLACE d_month WITH thismonth
	REPLACE d_day WITH thisday
	CLOSE ALL
	USE scores EXCLUSIVE
	GOTO TOP
	temp_player = d_player			&& whats this?
	temp_h_score = d_h_score		&& whats this?
	CLOSE ALL
	COPY FILE scores.dbf TO lastmon.dbf
	COPY FILE scores.org TO scores.dbf
	COPY FILE bestwday.org TO bestwday.dbf
	USE players EXCLUSIVE
	DELETE ALL
	ZAP
ENDIF

IF configday <> thisday
	REPLACE d_day WITH thisday
	COPY FILE bestwday.org TO bestwday.dbf
ENDIF

CLOSE ALL

RETURN
****************************************************************************





******************** Get CONFIG.DBF Configuartion settings ******************
PROCEDURE getconfig

USE config
GOTO TOP
games_day = d_gamesday
allhigh = d_allhigh
allhighn = d_allhighn
allhighd = d_allhighd
CLOSE ALL

RETURN
*****************************************************************************





************************** Get user from PLAYERS.DBF ************************
PROCEDURE getuser

USE players
GOTO TOP

LOCATE FOR d_name = name

IF .NOT. FOUND()
	APPEND BLANK
	REPLACE d_name WITH name
	REPLACE d_score WITH 0
	REPLACE d_lastplay WITH DATE()
	days = DAY(DATE()) * games_day
	REPLACE d_gameleft WITH days
	games_left = days
	total_score = 0
	today = DATE()
	newbie = "YES"
ENDIF

IF FOUND()
	IF DAY(d_lastplay) < DAY(DATE())
		games_left = d_gameleft + ((DAY(DATE()) - DAY(d_lastplay)) * games_day)
		total_score = d_score
		name = d_name
		today = DATE()
	ENDIF

	IF DAY(d_lastplay) = DAY(DATE())
		games_left = d_gameleft
		total_score = d_score
		name = d_name
		today = DATE()
	ENDIF

	newbie = "NO"
ENDIF
CLOSE ALL

RETURN
*****************************************************************************



*************************** Setup Initial Parameters ************************
PROCEDURE setup_params

SET TALK OFF
SET CONFIRM ON
SET BELL OFF
SET EXCLUSIVE OFF
SET EXACT ON
SET ESCAPE OFF

RETURN
*****************************************************************************




*********************** Setup Initial Variables & Globals *******************
PROCEDURE set_vars

PUBLIC name,letter[12],get_word[12],today,pick_words[40],aw_counter
PUBLIC top_col,top_row,timer,timer_sec,t_left,game_end,gw_col,games_left
PUBLIC first,game_score,total_score,games_day,free_game,last_game
PUBLIC thismonth,newbie,allhigh,allhighn,allhighd
PUBLIC temp_word, temp_score, temp_row, temp_col
PUBLIC version,m_bbsname,m_sn,sorry
PUBLIC this_word,tu[40],tu_word[40],tu_counter			&& 3.02

version = "3.04"
name = UNAME()
today = DATE()
games_left = 1
aw_counter = 1
top_col = 5
top_row = 3
timer = 60
t_left = timer
game_end = "NO"
game_score = 0
first = "YES"
sorry = 1

RETURN
*****************************************************************************





********************* Show Initial Screen / Vars / Etc... *******************
PROCEDURE show_initial

TYPE main.ans

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version

SET COLOR TO W+/rb
@ 17,72 SAY games_left PICTURE "@B ###"
@ 21,70 SAY total_score PICTURE "@B ###,###"
@ 20,70 SAY "0"

RETURN
****************************************************************************


**************************** Intro Screen **********************************

PROCEDURE intro

TYPE intro.ans
delay = .14

DO pause WITH delay
SET COLOR TO N+/b
@ 2,29 SAY "BBSoft Presents ..."

DO pause WITH delay
SET COLOR TO w/b
@ 2,29 SAY "BBSoft Presents ..."

DO pause WITH delay
SET COLOR TO W+/b
@ 2,29 SAY "BBSoft Presents ..."

delay = 1
DO pause WITH delay
delay = .14

DO pause WITH delay
SET COLOR TO N+/b
@ 2,23 SAY "Another Game from Porter Venn..."

DO pause WITH delay
SET COLOR TO w/b
@ 2,23 SAY "Another Game from Porter Venn..."

DO pause WITH delay
SET COLOR TO W+/b
@ 2,23 SAY "Another Game from Porter Venn..."

delay = 1.2
DO pause WITH delay
delay = .14

DO pause WITH delay
SET COLOR TO N+/b
@ 2,23 SAY "        Welcome to ...          "

DO pause WITH delay
SET COLOR TO w/b
@ 2,23 SAY "        Welcome to ...          "

DO pause WITH delay
SET COLOR TO W+/b
@ 2,23 SAY "        Welcome to ...          "

delay = .8
DO pause WITH delay

beavis = 1
zcol_counter = 34
word_length = 1
end_word = "WERD NERD"
delay = .003

source_word = "SPRINGISHEREAGAINTENDERAGEINBLOOM!BBSOFT!BBOSFT!BBSOFT!"
word_counter = 1

DO WHILE word_length <= 9
	SET COLOR TO GR+/w
	DO WHILE beavis <= 5
		DO pause WITH delay
		@ 5,zcol_counter SAY SUBSTR(source_word,word_counter,1)
		beavis = beavis + 1
		word_counter = word_counter + 1
	LOOP
	ENDDO
	SET COLOR TO W+/w
	@ 5,zcol_counter SAY SUBSTR(end_word,word_length,1)
	word_length = word_length + 1
	zcol_counter = zcol_counter + 1
	beavis = 1
LOOP
ENDDO

SET COLOR TO W+/b
@ 8,26 SAY "Press Any Key To Continue"
SET COLOR TO w/n
WAIT " "
SET COLOR TO W+/b
@ 8,26 SAY "                         "

SET COLOR TO W+/b
@ 2,20 SAY "           Werd Nerd (3.04)       "
@ 3,20 SAY "      Written By Porter Venn III  "
@ 4,20 SAY "   Copyright 1994,95,96 BBSoft Co."
@ 5,20 SAY "            Registered To ...     "
@ 6,20 SAY "                                  "

SET COLOR TO gr+/b
length = LEN(LTRIM(RTRIM(m_bbsname)))
bbs = LTRIM(RTRIM(m_bbsname))
pos = (21+(INT((36-length)/2)))
@ 6,POS SAY bbs
SET COLOR TO bg+/b
@ 7,19 SAY "          Serial #:   "
SET COLOR TO bg/b
@ 7,39 SAY m_sn
SET COLOR TO w+/b
@ 9,20 SAY "      Press any Key to Continue"

DO keypress
RETURN
****************************************************************************




******************************** Instructions ******************************

PROCEDURE instructions

SET COLOR TO W+/w
@  3,5 say "Welcome to Werd Nerd!                                                 "
@  4,5 say "                                                                      "
@  5,5 say "So how does one play this wacky game?  It's quite easy actually.      "
@  6,5 say "The object of Werd Nerd is to create as many words as you can from a  "
@  7,5 say "random group of letters, within 60 seconds.                           "
@  8,5 say "                                                                      "
@  9,5 say "When play starts, 12 letters will randomly appear in the box at in    "
@ 10,5 say "the middle of the screen on the bottom (The Green Box) Using those 12 "
@ 11,5 say "letters, you must type as many words as you can before time runs out. "
@ 12,5 say "                 ---  Press Any Key To Continue ---                   "
DO keypress
@  3,5 say "When the clock runs out, all the words you typed will be scored and   "
@  4,5 say "added together, giving you a total score for that game.  Each game you"
@  5,5 say "play during the month adds up to a cumulative score for the entire    "
@  6,5 say "month.                                                                "
@  7,5 say "                                                                      "
@  8,5 say "The amount of games you receive per day is determined by the way your "
@  9,5 say "sysop set up the game.  If you miss a few days, don't worry, you will "
@ 10,5 say "be able to play games even for days you missed, up until the end of   "
@ 11,5 say "the month.                                                            "
@ 12,5 say "                 ---  Press Any Key To Continue ---                   "
DO keypress
@  3,5 say "Scoring:  After the clock runs out all your words will be checked for "
@  4,5 say "spelling. If your words are spelled correctly, you will be awarded    "
@  5,5 say "points according to how difficult the word is.  Words that use rare   "
@  6,5 say "and hard to use letters, like the 'X', 'Q' & 'Z' for example, are     "
@  7,5 say "worth more than easier to use letters, such as the 'A', 'S' and 'E'.  "
@  8,5 say "                                                                      "
@  9,5 say "You may also receive a bonus for longer words... Any words with a     "
@ 10,5 say "length of 6 letters or more will receive a bonus. If your able to use "
@ 11,5 say "all 10 letters your bonus will be more than DOUBLE the original score!"
@ 12,5 say "                 ---  Press Any Key To Continue ---                   "
DO keypress
@  3,5 say "Be sure to spell the word correctly if you can, each misspelled word  "
@  4,5 say "will deduct 5 points from your score for that game.                   "
@  5,5 say "                                                                      "
@  6,5 say "When the game adds up your words for scoring, all red words are words "
@  7,5 say "that were spelled correctly.  Black words are incorrect, and the rare "
@  8,5 say "blue words are bonus words (6 or more letters).                       "
@  9,5 say "                                                                      "
@ 10,5 say "WERD NERD keeps track of all stats, your scores, other players scores,"
@ 11,5 say "the highest scoring words of all time, of the day, and the top games. "
@ 12,5 say "                 ---  Press Any Key To Continue ---                   "
DO keypress
@  3,5 say "That pretty much sums it up... Werd Nerd is a very easy game to play. "
@  4,5 say "Remember to spell those werds correctly!   Have Fun!                  "
@  5,5 say "                                                                      " 
@  6,5 say "                                                                      "
@  7,5 say "                                                                      "
@  8,5 say "                                                                      "
@  9,5 say "                                                                      "
@ 10,5 say "                                                                      "
@ 11,5 say "                                                                      "
@ 12,5 say "                 ---  Press Any Key To Continue ---                   "
DO keypress

@  3,5 say "                                                                      "   
@  4,5 say "                                                                      "
@  5,5 say "                                                                      " 
@  6,5 say "                                                                      "
@  7,5 say "                                                                      "
@  8,5 say "                                                                      "
@  9,5 say "                                                                      "
@ 10,5 say "                                                                      "
@ 11,5 say "                                                                      "
@ 12,5 say "                                                                      "
yn = "Y"
SET COLOR TO W+/w
@ 5,20 SAY "Would you like to view the scoring matrix?";
	GET yn PICTURE "Y"
	READ
IF yn = "Y"
	@  3,5 say " Letter Values :                                 Bonus Values:        "
	@  4,5 say "                                                                      "
	@  5,5 say " A =  1   G =  4   M =  6   S =  2   Y =  7      6 Letter Word  50%   " 
	@  6,5 say " B =  6   H =  8   N =  2   T =  3   Z = 17      7 Letter Word  75%   "
	@  7,5 say " C =  6   I =  2   O =  2   U =  2               8 Letter Word 100%   "
	@  8,5 say " D =  4   J = 14   P =  6   V =  9               9 Letter Word 150%   "
	@  9,5 say " E =  1   K = 10   Q = 20   W =  8              10 Letter Word 200%   "
	@ 10,5 say " F =  8   L =  3   R =  2   X = 15                                    "
	@ 11,5 say "                                                                      "
	@ 12,5 say "                 ---  Press Any Key To Continue ---                   "
	DO keypress
ENDIF

@  3,5 say "                                                                       "
@  4,5 say "                                                                      "
@  5,5 say "                                                                      " 
@  6,5 say "                                                                      "
@  7,5 say "                                                                      "
@  8,5 say "                                                                      "
@  9,5 say "                                                                      "
@ 10,5 say "                                                                      "
@ 11,5 say "                                                                      "
@ 12,5 say "                                                                      "

RETURN
****************************************************************************




**************************** Check for Ansi Support ************************

PROCEDURE checkansi

IF UANSI()
	RETURN
ENDIF

CLEAR SCREEN
? "In order to play Werd Nerd, you must have ANSI set to ON"
? " "
WAIT
QUIT
***************************************************************************



************************** User Keypress (Any Key) ************************
PROCEDURE keypress
 
CLEAR TYPEAHEAD
keypress = "N"
DO WHILE keypress = "N"
	I=INKEY(1)
	IF i <> 0
		keypress = "Y"
	ENDIF
LOOP
ENDDO

RETURN
***************************************************************************




******************************** Press Start ******************************

PROCEDURE press_start
SET COLOR TO bg/w
@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       "
SET COLOR TO n/w
@  7,21 SAY "Press Any Key when you're ready to Start"
DO keypress

RETURN
***************************************************************************


****************************** Check Best Word ****************************

PROCEDURE check_bw

IF temp_score = 0
	RETURN
ENDIF

playername = LOWER(LTRIM(RTRIM(UNAME())))
length = LEN(playername)
firstlet = UPPER(LEFT(playername,1))
restname = RIGHT(playername,(length-1))
playername = STUFF(restname,1,0,firstlet)
laststart = AT(" ",playername)
lastlet = UPPER(RIGHT(playername,(length-laststart)))
lastlet = LEFT(lastlet,1)
playername = LTRIM(RTRIM(STUFF(playername,laststart+1,1,lastlet)))


USE bestword
GOTO TOP

DECLARE b_words[20]
DECLARE b_word[20]
DECLARE b_wordn[20]
DECLARE b_wordd[20]

counter = 1

DO WHILE counter <= 20
	GOTO counter
	b_words[counter] = z_b_words
	b_word[counter] = z_b_word
	b_wordn[counter] = z_b_wordn
	b_wordd[counter] = z_b_wordd
	counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	IF temp_score > b_words[counter]
		zz = 20
		DO WHILE zz > counter
			b_words[zz] = b_words[zz-1]
			b_word[zz] = b_word[zz-1]
			b_wordn[zz] = b_wordn[zz-1]
			b_wordd[zz] = b_wordd[zz-1]
			zz = zz - 1
		LOOP
		ENDDO
		b_words[counter] = temp_score
		b_word[counter] = temp_word
		b_wordn[counter] = playername
		b_wordd[counter] = today

		SET COLOR TO W+*/w
		@ temp_row,(temp_col-11) SAY temp_word
		@ temp_row,temp_col SAY "+"
		@ temp_row,(temp_col+2) SAY temp_score PICTURE "###"
		SET COLOR TO W+*/r
		@ 17,3 SAY "                "
		@ 18,3 SAY " You just scored"
		@ 19,3 SAY " an All time Top"
		@ 20,3 SAY " 20 Werd!       "
                delay = .5
		DO pause WITH delay
		SET COLOR TO W+/r
		@ 17,3 SAY "                "
		@ 18,3 SAY " You just scored"
		@ 19,3 SAY " an All time Top"
		@ 20,3 SAY " 20 Werd!       "
                delay = 3
		DO pause WITH delay
		SET COLOR TO r/r
		@ 18,3 SAY "                "
		@ 19,3 SAY "                "
		@ 20,3 SAY "                "
		EXIT
	ENDIF
counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	GOTO counter
	REPLACE z_b_words WITH b_words[counter]
	REPLACE z_b_word WITH b_word[counter]
	REPLACE z_b_wordn WITH b_wordn[counter]	
	REPLACE z_b_wordd WITH b_wordd[counter]

counter = counter + 1
LOOP
ENDDO

CLOSE ALL



num_hour = VAL(LEFT(TIME(),2))
IF num_hour >= 12
	am_pm = "PM"
	IF num_hour > 12
		num_hour = num_hour - 12
	ENDIF
ELSE
	am_pm = "AM"
ENDIF
IF num_hour < 10
	showtime = SPACE(1)+LTRIM(RTRIM(STR(num_hour)+":"+SUBSTR(TIME(),4,2)+SPACE(1)+am_pm))
ENDIF
IF num_hour >= 10
	showtime = LTRIM(RTRIM(STR(num_hour)+":"+SUBSTR(TIME(),4,2)+SPACE(1)+am_pm))
ENDIF


USE bestwday
GOTO TOP
DECLARE b_words[20]
DECLARE b_word[20]
DECLARE b_wordn[20]
DECLARE b_wordt[20]

counter = 1

DO WHILE counter <= 20
	GOTO counter
	b_words[counter] = z_b_words
	b_word[counter] = z_b_word
	b_wordn[counter] = z_b_wordn
	b_wordt[counter] = z_b_wordt
	counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	IF temp_score > b_words[counter]
		zz = 20
		DO WHILE zz > counter
			b_words[zz] = b_words[zz-1]
			b_word[zz] = b_word[zz-1]
			b_wordn[zz] = b_wordn[zz-1]
			b_wordt[zz] = b_wordt[zz-1]
			zz = zz - 1
		LOOP
		ENDDO
		b_words[counter] = temp_score
		b_word[counter] = temp_word
		b_wordn[counter] = playername
		b_wordt[counter] = showtime
		EXIT
	ENDIF
counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	GOTO counter
	REPLACE z_b_words WITH b_words[counter]
	REPLACE z_b_word WITH b_word[counter]
	REPLACE z_b_wordn WITH b_wordn[counter]	
	REPLACE z_b_wordt WITH b_wordt[counter]

counter = counter + 1
LOOP
ENDDO

CLOSE ALL



RETURN
***************************************************************************


****************************** Check Best Game ****************************

PROCEDURE check_bg

IF game_score = 0
	RETURN
ENDIF

playername = LOWER(LTRIM(RTRIM(UNAME())))
length = LEN(playername)
firstlet = UPPER(LEFT(playername,1))
restname = RIGHT(playername,(length-1))
playername = STUFF(restname,1,0,firstlet)
laststart = AT(" ",playername)
lastlet = UPPER(RIGHT(playername,(length-laststart)))
lastlet = LEFT(lastlet,1)
playername = LTRIM(RTRIM(STUFF(playername,laststart+1,1,lastlet)))


USE bestgame
GOTO TOP

DECLARE b_game[20]
DECLARE b_gamen[20]
DECLARE b_gamed[20]

counter = 1

DO WHILE counter <= 20
	GOTO counter
	b_game[counter] = z_b_game
	b_gamen[counter] = z_b_gamen
	b_gamed[counter] = z_b_gamed
	counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	IF game_score > b_game[counter]
		zz = 20
		DO WHILE zz > counter
			b_game[zz] = b_game[zz-1]
			b_gamen[zz] = b_gamen[zz-1]
			b_gamed[zz] = b_gamed[zz-1]
			zz = zz - 1
		LOOP
		ENDDO
		b_game[counter] = game_score
		b_gamen[counter] = playername
		b_gamed[counter] = today
		SET COLOR TO W+*/r
		@ 17,16 SAY game_score PICTURE "@B ###"
		@ 18,3 SAY " You just scored"
		@ 19,3 SAY " an All time Top"
		@ 20,3 SAY " 20 game score! "
                delay = .5
		DO pause WITH delay
		SET COLOR TO W+/r
		@ 18,3 SAY " You just scored"
		@ 19,3 SAY " an All time Top"
		@ 20,3 SAY " 20 game score! "
                delay = 3
		DO pause WITH delay
		@ 17,16 SAY game_score PICTURE "@B ###"
		SET COLOR TO r/r
		@ 18,3 SAY "                "
		@ 19,3 SAY "                "
		@ 20,3 SAY "                "
	EXIT
	ENDIF
counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	GOTO counter
	REPLACE z_b_game WITH b_game[counter]
	REPLACE z_b_gamen WITH b_gamen[counter]	
	REPLACE z_b_gamed WITH b_gamed[counter]

counter = counter + 1
LOOP
ENDDO

CLOSE ALL
RETURN
***************************************************************************




******************************** Save Scores ******************************


PROCEDURE save_scores

set color to W+

nowmonth = MONTH(DATE())

IF nowmonth <> thismonth
	RETURN
ENDIF

USE players
GOTO TOP

LOCATE FOR d_name = name

REPLACE d_score WITH total_score
REPLACE d_lastplay WITH today
REPLACE d_gameleft WITH games_left

CLOSE ALL

playername = LOWER(LTRIM(RTRIM(UNAME())))
length = LEN(playername)
firstlet = UPPER(LEFT(playername,1))
restname = RIGHT(playername,(length-1))
playername = STUFF(restname,1,0,firstlet)
laststart = AT(" ",playername)
lastlet = UPPER(RIGHT(playername,(length-laststart)))
lastlet = LEFT(lastlet,1)
playername = LTRIM(RTRIM(STUFF(playername,laststart+1,1,lastlet)))


USE SCORES  
GOTO TOP

DECLARE player[20]
DECLARE scores[20]

counter = 1

DO WHILE counter <= 20
	GOTO counter
	player[counter] = LTRIM(RTRIM(d_player))
	scores[counter] = d_h_score
	counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	IF total_score >= scores[counter]
		killdupe = 1
		DO WHILE killdupe <= 20
			IF playername = player[killdupe]
				switch = killdupe
				DO WHILE switch <= 19
					player[switch] = player[switch+1]
					scores[switch] = scores[switch+1]
					switch = switch + 1	
				LOOP
				ENDDO
			ENDIF
			killdupe = killdupe + 1
		LOOP
		ENDDO

		count_2 = 20
		DO WHILE count_2 > counter
			scores[count_2] = scores[count_2-1]
			player[count_2] = player[count_2-1]		
			count_2 = count_2 - 1
		LOOP
		ENDDO
		
		scores[counter] = total_score
		player[counter] = playername
		EXIT
	ENDIF
counter = counter + 1
LOOP
ENDDO

counter = 1

DO WHILE counter <= 20
	GOTO counter
	REPLACE d_player WITH player[counter]
	REPLACE d_h_score WITH scores[counter]
	counter = counter + 1
LOOP
ENDDO
CLOSE ALL

&& This checks to see if there is a new All-Time High Score

USE config
GOTO TOP

IF total_score > d_allhigh
	REPLACE d_allhigh with total_score
	REPLACE d_allhighn with playername
	REPLACE d_allhighd with today
ENDIF

CLOSE ALL
RETURN

**************************************************************************


************************ Procedure STAT1 (Leaderboard) *******************
PROCEDURE stat1

SET COLOR TO R/w
@ 1,32 SAY "CURRENT LEADERS"
SET COLOR TO bg/w

@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       "

USE SCORES  
GOTO TOP

counter = 1
temprow = 3

DO WHILE counter <= 10
	GOTO counter
	SET COLOR TO b/w
	IF name = UPPER(d_player)
		SET COLOR TO b*/w
	ENDIF
	@ temprow,5 SAY LTRIM(RTRIM(LEFT(d_player,21)))
	SET COLOR TO rb/w
	IF name = UPPER(d_player)
		SET COLOR TO rb*/w
	ENDIF
	IF d_h_score > 0
		@ temprow,28 SAY d_h_score PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 11
temprow = 3

DO WHILE counter <= 20
	GOTO counter
	SET COLOR TO b/w
	IF name = UPPER(d_player)
		SET COLOR TO b*/w
	ENDIF
	@ temprow,43 SAY LTRIM(RTRIM(LEFT(d_player,21)))
	SET COLOR TO rb/w
	IF name = UPPER(d_player)
		SET COLOR TO rb*/w
	ENDIF
	IF d_h_score > 0
		@ temprow,66 SAY d_h_score PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

CLOSE ALL

SET COLOR TO w+/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY " Press Any Key "
@ 19,3 SAY " to Continue.  "
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)

DO keypress

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version
RETURN
**************************************************************************


************************ Procedure STAT2 (Last Months) *******************
PROCEDURE stat2
SET COLOR TO R/w
@ 1,30 SAY "LAST MONTHS WINNERS"
SET COLOR TO bg/w

@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       "

USE lastmon
GOTO TOP

counter = 1
temprow = 3

DO WHILE counter <= 10
	GOTO counter
	SET COLOR TO b/w
	IF name = UPPER(d_player)
		SET COLOR TO b*/w
	ENDIF
	@ temprow,5 SAY LTRIM(RTRIM(LEFT(d_player,21)))
	SET COLOR TO rb/w
	IF name = UPPER(d_player)
		SET COLOR TO rb*/w
	ENDIF
	IF d_h_score > 0
		@ temprow,28 SAY d_h_score PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 11
temprow = 3

DO WHILE counter <= 20
	GOTO counter
	SET COLOR TO b/w
	IF name = UPPER(d_player)
		SET COLOR TO b*/w
	ENDIF
	@ temprow,43 SAY LTRIM(RTRIM(LEFT(d_player,21)))
	SET COLOR TO rb/w
	IF name = UPPER(d_player)
		SET COLOR TO rb*/w
	ENDIF
	IF d_h_score > 0
		@ temprow,66 SAY d_h_score PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

CLOSE ALL

SET COLOR TO w+/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY " Press Any Key "
@ 19,3 SAY " to Continue.  "
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)

DO keypress

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version

RETURN
**************************************************************************


************************ Procedure STAT3 (Best Words)  *******************
PROCEDURE stat3

SET COLOR TO R/w
@ 1,30 SAY "  BEST WORDS EVER! "
SET COLOR TO bg/w

@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       "

USE bestword
GOTO TOP

counter = 1
temprow = 3

DO WHILE counter <= 10
	GOTO counter
	IF z_b_words > 0
		SET COLOR TO gr+/w
		@ temprow,5 SAY z_b_words PICTURE "###"
		SET COLOR TO r/w
		@ temprow,9 SAY LTRIM(RTRIM(z_b_word))
		SET COLOR TO b/w
		IF name = UPPER(z_b_wordn)
			SET COLOR TO b*/w
		ENDIF
		@ temprow,20 SAY LTRIM(RTRIM(LEFT(z_b_wordn,11)))
		SET COLOR TO n/w
		@ temprow,32 SAY z_b_wordd
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 11
temprow = 3

DO WHILE counter <= 20
	GOTO counter
	IF z_b_words > 0
		SET COLOR TO gr+/w
		@ temprow,41 SAY z_b_words PICTURE "###"
		SET COLOR TO r/w
		@ temprow,45 SAY LTRIM(RTRIM(z_b_word))
		SET COLOR TO b/w
		IF name = UPPER(z_b_wordn)
			SET COLOR TO b*/w
		ENDIF
		@ temprow,56 SAY LTRIM(RTRIM(LEFT(z_b_wordn,11)))
		SET COLOR TO n/w
		@ temprow,68 SAY z_b_wordd
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

CLOSE ALL

SET COLOR TO w+/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY " Press Any Key "
@ 19,3 SAY " to Continue.  "
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)

DO keypress

SET COLOR TO R/w
@ 1,30 SAY " TODAYS BEST WORDS"
SET COLOR TO bg/w

@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       "

USE bestwday
GOTO TOP

counter = 1
temprow = 3

DO WHILE counter <= 10
	GOTO counter
	IF z_b_words > 0
		SET COLOR TO gr+/w
		@ temprow,5 SAY z_b_words PICTURE "###"
		SET COLOR TO r/w
		@ temprow,9 SAY LTRIM(RTRIM(z_b_word))
		SET COLOR TO b/w
		IF name = UPPER(z_b_wordn)
			SET COLOR TO b*/w
		ENDIF
		@ temprow,20 SAY LTRIM(RTRIM(LEFT(z_b_wordn,11)))
		SET COLOR TO n/w
		@ temprow,32 SAY z_b_wordt
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 11
temprow = 3

DO WHILE counter <= 20
	GOTO counter
	IF z_b_words > 0
		SET COLOR TO gr+/w
		@ temprow,41 SAY z_b_words PICTURE "###"
		SET COLOR TO r/w
		@ temprow,45 SAY LTRIM(RTRIM(z_b_word))
		SET COLOR TO b/w
		IF name = UPPER(z_b_wordn)
			SET COLOR TO b*/w
		ENDIF
		@ temprow,56 SAY LTRIM(RTRIM(LEFT(z_b_wordn,11)))
		SET COLOR TO n/w
		@ temprow,68 SAY z_b_wordt
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

CLOSE ALL

SET COLOR TO w+/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY " Press Any Key "
@ 19,3 SAY " to Continue.  "
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)

DO keypress

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version


RETURN
**************************************************************************


************************ Procedure STAT4 (Best Games)  *******************
PROCEDURE stat4

SET COLOR TO R/w
@ 1,30 SAY "  BEST GAMES EVER! "
SET COLOR TO bg/w

@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       " 

USE bestgame
GOTO TOP

counter = 1
temprow = 3

DO WHILE counter <= 10
	GOTO counter
	IF z_b_game > 0
		SET COLOR TO gr+/w
		@ temprow,5 SAY z_b_game PICTURE "####"
		SET COLOR TO b/w
		IF name = UPPER(z_b_gamen)
			SET COLOR TO b*/w
		ENDIF
		@ temprow,11 SAY LTRIM(RTRIM(LEFT(z_b_gamen,20)))
		SET COLOR TO n/w
		@ temprow,32 SAY z_b_gamed
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 11
temprow = 3

DO WHILE counter <= 20
	GOTO counter
	IF z_b_game > 0
		SET COLOR TO gr+/w
		@ temprow,41 SAY z_b_game PICTURE "####"
		SET COLOR TO b/w
		IF name = UPPER(z_b_gamen)
			SET COLOR TO b*/w
		ENDIF
		@ temprow,47 SAY LTRIM(RTRIM(LEFT(z_b_gamen,20)))
		SET COLOR TO n/w
		@ temprow,68 SAY z_b_gamed
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

CLOSE ALL

SET COLOR TO w+/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY " Press Any Key "
@ 19,3 SAY " to Continue.  "
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)

DO keypress

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version

RETURN
**************************************************************************



************************ Procedure STAT5 (Most Used)  ********************
PROCEDURE stat5

SET COLOR TO R/w
@ 1,30 SAY "  MOST USED WORDS  "
SET COLOR TO w+/w
@  3,5 say "Word       Times Used   Word       Times Used   Word       Times Used  "
@  4,5 say "-----------------------------------------------------------------------"
SET COLOR TO bg/w
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       " 

USE mostused
GOTO TOP

counter = 1
temprow = 5

DO WHILE counter <= 8
	GOTO counter
	IF times_used > 0
		SET COLOR TO r/w
		@ temprow,5 SAY word 
		SET COLOR TO gr+/w
		@ temprow,16 SAY times_used PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 9
temprow = 5

DO WHILE counter <= 16
	GOTO counter
	IF times_used > 0
		SET COLOR TO r/w
		@ temprow,29 SAY word
		SET COLOR TO gr+/w
		@ temprow,40 SAY times_used PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO

counter = 17
temprow = 5

DO WHILE counter <= 24
	GOTO counter
	IF times_used > 0
		SET COLOR TO r/w
		@ temprow,53 SAY word
		SET COLOR TO gr+/w
		@ temprow,64 SAY times_used PICTURE "#,###,###"
	ENDIF
	counter = counter + 1
	temprow = temprow + 1
LOOP
ENDDO


CLOSE ALL

SET COLOR TO w+/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY " Press Any Key "
@ 19,3 SAY " to Continue.  "
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)

DO keypress

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version

RETURN
**************************************************************************



******************************** go_on ************************************

PROCEDURE go_on   
SET COLOR TO bg/w
@  3,5 say "                                                                       "
@  4,5 say "                                                                       "
@  5,5 say "                                                                       " 
@  6,5 say "                                                                       "
@  7,5 say "                                                                       "
@  8,5 say "                                                                       "
@  9,5 say "                                                                       "
@ 10,5 say "                                                                       "
@ 11,5 say "                                                                       "
@ 12,5 say "                                                                       "

IF games_left <= 0 
	SET COLOR TO W+/w
	@ 5,6 SAY "      Sorry... you are all out of games.  Try again tommorow.      "
	delay = 3
	DO pause WITH delay
	SET COLOR TO W+*/w
	@ 7,6 SAY "                       Nice Try Wisenheimer !                      "
	delay = 5
	DO pause WITH delay
	QUIT
ENDIF

RETURN
***************************************************************************



********************************* User Hangup *****************************
PROCEDURE hangup

nowmonth = MONTH(DATE())
IF nowmonth = thismonth
	games_left = games_left - 1
	IF games_left <= 0 
		games_left = 0
	ENDIF
		
	USE players
	GOTO TOP

	LOCATE FOR d_name = name

	REPLACE d_score WITH score
	REPLACE d_lastplay WITH today
	REPLACE d_gameleft WITH games_left

	CLOSE ALL
	QUIT
ENDIF
IF nowmonth <> thismonth
	QUIT
ENDIF
QUIT
RETURN
**************************************************************************



****************************** get werdkey.dbf ***************************
PROCEDURE getkey

USE werdkey

STORE bbsname TO bbs
STORE 22 TO localval
B = 0
A = 1
M = LEN(LTRIM(RTRIM(bbsname)))
DO WHILE A < LEN(bbs) + 1
   B = B + ASC(SUBSTR(bbs,A,1))
   A = A + 1
ENDDO
IF B * M * localVal = sncount
	m_bbsname = bbsname
	m_sn = sn
	RETURN
ELSE

CLEAR
SET COLOR TO BG+
? "There appears to be a problem with the WERDKEY.DBF file.  Please report this"
? "error to your System Operator."
? " "
WAIT   
QUIT
ENDIF
******************************************************************************



********************************** Check Sysop *******************************
PROCEDURE checksysop

IF UPRIV() < 255
	RETURN
ENDIF

today = DATE()

CLEAR SCREEN
SET COLOR TO W+
yn = "N"
@ 10,16 SAY "Enter the Sysop Configuration Panel? [Y/N] ";
	GET yn PICTURE "Y"
	READ

IF yn = "N"
	RETURN
ENDIF

TYPE panel.ans
USE config EXCLUSIVE
GOTO TOP
t_games_day = d_gamesday
CLOSE ALL

reset_best = "N"
reset_all = "N"

SET COLOR TO n/w
@ 3,13 SAY t_games_day PICTURE "##"
@ 9,14 SAY reset_best PICTURE "Y"
@ 13,14 SAY reset_all PICTURE "Y"

@ 3,13 GET t_games_day PICTURE "##" RANGE 1,30
	READ

@ 9,14 GET reset_best PICTURE "Y"
	READ
IF reset_best = "Y"
	yn = "N"
	SET COLOR TO W+/w
	@ 10,15 SAY "Are you Sure?"
	@ 10,32	GET yn PICTURE "Y"
		READ
	IF yn = "Y"
		@ 11,15 SAY "Reseting Scores..."
		delay = 1
		DO pause WITH Delay
		COPY FILE bestword.org TO bestword.dbf
		COPY FILE bestgame.org TO bestgame.dbf
		COPY FILE bestwday.org TO bestwday.dbf
		&& zxczxc  Put new file stuff in here later
		CLOSE ALL
		@ 11,15 SAY "Done               "
	ENDIF
ENDIF

@ 13,14 GET reset_all PICTURE "Y"
	READ
IF reset_all = "Y"
	yn = "N"
	SET COLOR TO W+/w
	@ 14,15 SAY "Are you Sure?"
	@ 14,32	GET yn PICTURE "Y"
		READ
	IF yn = "Y"
		@ 15,15 SAY "Reseting Scores..."
		delay = 1
		DO pause WITH Delay
		COPY FILE scores.org TO scores.dbf
		COPY FILE lastmon.org TO lastmon.dbf
		COPY FILE players.org TO players.dbf
		COPY FILE bestword.org TO bestword.dbf
		COPY FILE bestgame.org TO bestgame.dbf
		COPY FILE bestwday.org TO bestwday.dbf

		USE config
		GOTO TOP
		REPLACE d_month WITH 0
		REPLACE d_allhigh WITH 0
		REPLACE d_allhighn WITH ""
		REPLACE d_allhighd WITH DATE()
		CLOSE ALL
		@ 15,15 SAY "Done               "
	ENDIF
ENDIF

delay = 2
DO pause WITH delay

USE config
GOTO TOP
REPLACE d_gamesday WITH t_games_day
CLOSE ALL

SET COLOR TO W+
CLEAR SCREEN
SET COLOR TO W+
? "Information has been saved and updated"
? " "
WAIT
RETURN
**************************************************************************



********************************** Redraw Screen *************************

PROCEDURE redraw

TYPE main.ans

SET COLOR TO GR+/w
@ 1,30 SAY "  WERD NERD        "
@ 1,42 SAY version

SET COLOR TO GR+/r
@ 17,3 SAY " [S]cores/Stats "
@ 18,3 SAY " [N]ext Game    "
@ 19,3 SAY " [I]nstructions "
@ 20,3 SAY " [Q]uit [R]edraw"

SET COLOR TO W+/r
@ 17,5 SAY "S"
@ 18,5 SAY "N"
@ 19,5 SAY "I"
@ 20,5 SAY "Q"
@ 20,12 SAY "R"

SET COLOR TO W+/rb
@ 17,72 SAY games_left PICTURE "@B ###"
@ 20,70 SAY last_game PICTURE "@B ###,###"
@ 21,70 SAY total_score PICTURE "@B ###,###"

RETURN

**************************************************************************




******************************** pre_game ********************************

PROCEDURE pre_game

DO show_pre

CLEAR TYPEAHEAD
keypress = ""

DO WHILE .T.
	keypress = UPPER(CHR(INKEY(1)))

	IF keypress = "W"
		DO gizmo
		DO show_pre
		keypress = ""
	ENDIF
	IF keypress = "P"
		EXIT
	ENDIF
	IF keypress = "H"
		DO stat1
		DO stat2
		DO stat3
		DO stat4
		DO stat5
		DO show_pre		
		keypress = ""
	ENDIF
	IF keypress = "I"
		DO instructions
		DO show_pre
		keypress = ""
	ENDIF
	IF keypress = "Q"
		QUIT
	ENDIF
LOOP
ENDDO

RETURN
***************************************************************************



*********************************** show_pre ******************************
PROCEDURE show_pre

SET COLOR TO W+/w
@  3,5 say "                                                                       "
@  4,5 say "        Ŀ         "
@  5,5 say "               [P]lay Werd Nerd                                      "
@  6,5 say "               [W]erd Nerd Analyzer Gizmo                            " 
@  7,5 say "               [H]igh Scores & All Time Game Statistics              "
@  8,5 say "               [I]nstructions & Scoring Matrix                       "
@  9,5 say "                                                                     "
@ 10,5 say "               [Q]uit / Exit to the BBS                              "
@ 11,5 say "                 "
@ 12,5 say "                                                                       "
SET COLOR TO GR+/w
@ 5,22 SAY "P"
@ 6,22 SAY "W"
@ 7,22 SAY "H"
@ 8,22 SAY "I"
&& @ 9,22 SAY "T"
@ 10,22 SAY "Q"
SET COLOR TO r/r
@ 17,3 SAY SPACE(16)
@ 18,3 SAY SPACE(16)
@ 19,3 SAY SPACE(16)
@ 20,3 SAY SPACE(16)
@ 21,3 SAY SPACE(16)
RETURN
******************************************************************************



******************************************************************************
PROCEDURE check_most_used


DECLARE m_word[24]
DECLARE m_times_used[24]

counter = 1
tu_counter = tu_counter - 1

USE mostused
GOTO TOP

DO WHILE counter <= 24		&& grab .DBF fields, put into memory arrays
	GOTO counter
	m_word[counter] = word
	m_times_used[counter] = times_used
	counter = counter + 1
LOOP
ENDDO

t_count = 1
DO WHILE t_count <= tu_counter
	counter = 1
	DO WHILE counter <= 24
		IF tu[t_count] >= m_times_used[counter]
			killdupe = 1
			DO WHILE killdupe <= 24
				IF tu_word[t_count] = m_word[killdupe]
					switch = killdupe
					DO WHILE switch <= 23
						m_word[switch] = m_word[switch+1]
						m_times_used[switch] = m_times_used[switch+1]
						switch = switch + 1	
					LOOP
					ENDDO
				ENDIF
				killdupe = killdupe + 1
			LOOP
			ENDDO
	
			count_2 = 24
			DO WHILE count_2 > counter
				m_times_used[count_2] = m_times_used[count_2-1]
				m_word[count_2] = m_word[count_2-1]		
				count_2 = count_2 - 1
			LOOP
			ENDDO
			
			m_times_used[counter] = tu[t_count]
			m_word[counter] = tu_word[t_count]
			EXIT
		ENDIF
		counter = counter + 1
	LOOP
	ENDDO
	t_count = t_count + 1
LOOP
ENDDO

counter = 1				&& Save memory data to the .DBF
DO WHILE counter <= 24
	GOTO counter
	REPLACE word WITH m_word[counter]
	REPLACE times_used WITH m_times_used[counter]	
	counter = counter + 1
LOOP
ENDDO
CLOSE ALL

RETURN
**************************************************************************



*********************************** gizmo ********************************
PROCEDURE gizmo

SET COLOR TO W+/w
@  3,5 SAY "                                                                       "
@  4,5 SAY "        Ŀ         "
@  5,5 SAY "          The Werd Nerd Analyzer allows you to type in any           "
@  6,5 SAY "          word and to see how many points that word is               " 
@  7,5 SAY "          worth.     (Press ENTER by itself to Quit)                 "
@  8,5 SAY "                                                                     "
@  9,5 SAY "                                                                     "
@ 10,5 SAY "                                                                     "
@ 11,5 SAY "                 "
@ 12,5 SAY "                                                                       "

DO WHILE .T.
	test_word = SPACE(10)
	@ 9,16 SAY "Enter a Word:";
      	GET test_word PICTURE "!!!!!!!!!!"
	READ

	let_score = 0
	test_word = LTRIM(RTRIM(test_word))

	IF test_word = "" 
		RETURN
	ENDIF

	USE spell INDEX spell
	SEEK test_word
	IF FOUND()
		word_length = LEN(test_word)
		beavis = 1
		DO WHILE beavis <= word_length
			z_letter = SUBSTR(test_word,beavis,1)
			DO CASE
			case z_letter = "A"
				let_score = let_score +1
			case z_letter = "B"
				let_score = let_score +6
			case z_letter = "C"
				let_score = let_score +6
			case z_letter = "D"
				let_score = let_score +4
			case z_letter = "E"
				let_score = let_score +1
			case z_letter = "F"
				let_score = let_score +8
			case z_letter = "G"
				let_score = let_score +4
			case z_letter = "H"
				let_score = let_score +8
			case z_letter = "I"
				let_score = let_score +2
			case z_letter = "J"
				let_score = let_score +14
			case z_letter = "K"
				let_score = let_score +10
			case z_letter = "L"
				let_score = let_score +3
			case z_letter = "M"
				let_score = let_score +6
			case z_letter = "N"
				let_score = let_score +2
			case z_letter = "O"
				let_score = let_score +2
			case z_letter = "P"
				let_score = let_score +6
			case z_letter = "Q"
				let_score = let_score +20
			case z_letter = "R"
				let_score = let_score +2
			case z_letter = "S"
				let_score = let_score +2
			case z_letter = "T"
				let_score = let_score +3
			case z_letter = "U"
				let_score = let_score +2
			case z_letter = "V"
				let_score = let_score +9
			case z_letter = "W"
				let_score = let_score +8
			case z_letter = "X"
				let_score = let_score +15
			case z_letter = "Y"
				let_score = let_score +7
			case z_letter = "Z"
				let_score = let_score +17
			ENDCASE
		beavis = beavis + 1
		LOOP
		ENDDO

		word_score = let_score
		let_score = 0

		IF word_length = 6
			word_score = INT(word_score * 1.50)
		ENDIF

		IF word_length = 7
			word_score = INT(word_score * 1.75)
		ENDIF

		IF word_length = 8
			word_score = INT(word_score * 2.00)
		ENDIF

		IF word_length = 9
			word_score = INT(word_score * 2.50)
		ENDIF

		IF word_length = 10
			word_score = INT(word_score * 3.00)
		ENDIF
		SET COLOR TO r*/w
		@ 9,40 SAY word_score PICTURE "####"
		SET COLOR TO W+/w
		@ 9,45 SAY "Points !"
	ELSE
		SET COLOR TO n*/w
		@ 9,42 SAY "Not in Dictionary (-5)"
	ENDIF

	delay = 4
	DO pause WITH delay

	SET COLOR TO w+/w
	@ 9,41 SAY "                       "
	let_score = 0
	word_score = 0
LOOP
ENDDO

RETURN
******************************************************************************
 