load('sbbsdefs.js');
load('funclib.js');

var settings, lastread;

function main() {
    var f = new File(js.exec_dir + 'ibol.asc');
    var ascfile;
    if (f.open('r')) {
        ascfile = f.readAll();
        f.close();
    } else {
        ascfile = [''];
    }
    console.clear();
    console.putmsg(' hk+----------------------------------------------------------------------------+\r\n');
    console.putmsg(' hk|5   hw>>> yInterBBS Oneliners w<<<                                               0k|\r\n');
    console.putmsg(' hk+----------------------------------------------------------------------------+nk\r\n');

    var start;
    if (ascfile.length > 18) {
        start = ascfile.length -18;
    } else {
        start = 0;
    }

    for (var i = start; i < ascfile.length; i = i + 1) {
        console.putmsg(ascfile[i]);
        console.putmsg('\r\n');
    }

    console.putmsg('hw (yAw) mAdd, w(yVw) mView, w(yQw) mQuit ');

    var userinput = console.getkey(K_NONE);
    console.putmsg('\r\n');
    var lines = [];
    if (userinput == 'a' || userinput == 'A') {
        for (var i=0;i<10;i++) {
            console.putmsg('line ' + (i+1) + ': ');
            var str = console.getstr('', 56);
            if (str.length == 0) {
                if (i == 0) {
                   return;
                } else {
		   break;
                }
            }
            lines.push([str]);
        }

        var header = {
            'to' : 'IBBS1LINE',
            'from' : user.alias,
            'subject' : 'InterBBS Oneliner'
        };
    
        var body = '';
    
        body = body + 'Author: ' + user.alias + '\r\n';
        body = body + 'Source: ' + system.name + '\r\n';
        for (var i=0;i<lines.length;i++) {
            body = body + 'Oneliner: ' + lines[i] + '\r\n';
        }
    
        var msgBase = new MsgBase(settings.messageBase);
        msgBase.open();
        msgBase.save_msg(header, body);
        msgBase.close();        
    } else if (userinput == 'v' || userinput == 'V') {
        console.clear();
        console.putmsg(' hk+----------------------------------------------------------------------------+\r\n');
        console.putmsg(' hk|5   hw>>> yInterBBS Oneliners w<<<                                               0k|\r\n');
        console.putmsg(' hk+----------------------------------------------------------------------------+\r\nnw');
        console.printfile(js.exec_dir + 'ibol.asc');
        console.putmsg(' mPress a key....');
        console.getkey(K_NONE);       
    }
}


function readmsgbase() {
    var msgBase = new MsgBase(settings.messageBase);
    var ascfile = new File(js.exec_dir + 'ibol.asc');
    
    ascfile.open('a+');

    msgBase.open();
    var start;
    if (lastread == 0) {
        start = msgBase.first_msg;
    } else {
        start = lastread + 1;
    }
    for (var m = start; m <= msgBase.last_msg; m = m + 1) {
        var h = msgBase.get_msg_header(m);
        if (h == null) break;
        if (h.subject === 'InterBBS Oneliner' && h.to === 'IBBS1LINE') {
            var body = msgBase.get_msg_body(m);
            var author, fromsys;
            var lines = [];
            var msgbody = '';
            var arrayOfLines = body.match(/[^\r\n]+/g);
            var arrayLen = arrayOfLines.length;
            for (var i = 0; i < arrayLen; i = i + 1) {
                var line = arrayOfLines[i];
                if (line.substr(0, 8) === 'Author: ') {
                    author = truncsp(line.substr(8));
                } else if (line.substr(0,8) === 'Source: ') {
                    fromsys = truncsp(line.substr(8));
                } else if (line.substr(0, 10) === 'Oneliner: ') {
                    msgbody = msgbody + truncsp(line.substr(10)) + ' ';
                }
            }

	    var arrayOfWords = msgbody.split(' ');
	    var spaceleft = 57;
	    var curline = '';
            for (var i = 0; i < arrayOfWords.length; i = i + 1) {
                if (arrayOfWords[i].length > spaceleft) {
                   lines.push([curline]);
                   curline = arrayOfWords[i] + ' '; 
                   spaceleft = 57 - (arrayOfWords[i].length + 1);
		} else {
                   curline = curline + arrayOfWords[i] + ' ';
                   spaceleft = spaceleft - (arrayOfWords[i].length + 1);
                }
            }
	    lines.push([curline]);

            var len;

            if (lines.length > 2) {
                len = lines.length;
            } else {
                len = 2;
            }

            for (var i = 0; i < len; i = i + 1) {
                if (i == 0) {
                    if (lines.length >= 1) {
                        ascfile.printf('hc%20.20sk: nw%s\r\n', author, lines[0]);
                    } else {
                        ascfile.printf('hc%20.20sk: \r\n', author);
                    }
                } else if (i==1) {
                    if (lines.length >= 2) {
                        ascfile.printf('nc%20.20shk: nw%s\r\n', fromsys, lines[1]);
                    } else {
                        ascfile.printf('nc%20.20shk: \r\n', fromsys);
                    }
                } else {
                    ascfile.printf('                    hk: nw%s\r\n', lines[i]);
                }
            }
            ascfile.write(' hk------------------------------------------------------------------------------nk\r\n')
           
        }
        lastread = m;
    }
    msgBase.close();
    ascfile.close();

    var f = new File(js.exec_dir + 'ibol.lr');
    if (!f.open('w')) throw 'Failed to open ibol.lr.';
    f.writeBin(lastread);
    f.close();
}

function loadSettings() {
	var f = new File(js.exec_dir + 'ibol.ini');
	if (!f.open('r')) throw 'Failed to open ibol.ini.';
	settings = f.iniGetObject();

    f.close();

    f = new File(js.exec_dir + 'ibol.lr');
    if (!f.open('r')) {
        lastread = 0;
    } else {
        lastread = f.readBin();
        f.close();
    }
}

function init() {
    loadSettings();
    readmsgbase();
}

try {
    init();
    main();
} catch (err) {
    log(LOG_ERR, err);
}
