PROGRAM FileScan;

{ this program scan for additional, unexpected files on the workdrive }

USES Dos,
     Ramon;

VAR LogFile   : TEXT;
    LogPath   : STRING;
    WorkDrive : STRING[2];
    InFile    : TEXT;

FUNCTION TimeStamp : STRING;

VAR Hour,Min,Sec,SecH  : WordLong;

BEGIN
     GetTime (Hour,Min,Sec,SecH);

     TimeStamp:=AddUpWithPre0s (2,Word2String (Hour))+':'+
                AddUpWithPre0s (2,Word2String (Min))+':'+
                AddUpWithPre0s (2,Word2String (Sec));
END;


PROCEDURE Log (Msg : STRING);
BEGIN
     Msg:=TimeStamp+Spaces (5)+Msg;
     WriteLn (LogFile,Msg);
     WriteLn (Msg);
END;


PROCEDURE LogErr (IORes : BYTE; Msg : STRING);
BEGIN
     Log (Msg+' (error '+Byte2String (IORes)+')');
END;


PROCEDURE FoundFile (Path : STRING);

VAR FilTyp : CHAR;
    Regel  : STRING;
    P      : BYTE;
    Path1  : STRING;

BEGIN
     Close (InFile);
     Reset (InFile);

     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF (Regel = '') THEN
             Continue;

          Regel:=CleanTabs (Regel,1);

          IF (Regel[1] = ';') THEN
             Continue;

          IF (Regel[2] <> ' ') THEN
          BEGIN
               Log ('FileScan: Error in "'+Regel+'"');
               Continue;
          END;

          FilTyp:=UpCase (Regel[1]);

          IF (FilTyp = 'R'{removed}) THEN
             Continue;

          IF (NOT (FilTyp IN ['T','B','-','C'])) THEN
          BEGIN
               Log ('FileScan: Unsupported file type in "'+Regel+'"');
               Continue;
          END;

          Delete (Regel,1,2);

          P:=Pos (' ',Regel);
          IF (P > 0) THEN
             Regel:=Copy (Regel,1,P-1);

          IF (Regel[1] = '$') AND (Regel[2] = ':') THEN
          BEGIN
               Delete (Regel,1,2);
               Regel:=WorkDrive+Regel;
          END;

          IF (UpCaseString (Regel) = UpCaseString (Path)) THEN
             Exit; { found! }
     END; { while }

     Log ('FileScan: Found additional file: '+Path);
END;

{ recursively called }
PROCEDURE ScanPath (Path : STRING);

VAR Search : SearchRec;

BEGIN
     FindFirst (Path+'*.*',$3F,Search);
     WHILE (DosError = 0) DO
     BEGIN
          IF ((Search.Attr AND $10) > 0) THEN
          BEGIN
               IF (Search.Name[1] <> '.') THEN
                  ScanPath (Path+Search.Name+'\');
          END ELSE
              FoundFile (Path+Search.Name);

          FindNext (Search);
     END; { while }
END;


VAR IORes : BYTE;

BEGIN
     WorkDrive:=GetEnv ('WORKDRIVE');
     IF (WorkDrive = '') THEN
     BEGIN
          WriteLn (#7,'WORKDRIVE is not set');
          Halt;
     END;

     LogPath:=GetEnv ('WGTESTLOG');
     IF (LogPath = '') THEN
     BEGIN
          WriteLn (#7,'WGTESTLOG is not set');
          Halt;
     END;

     Assign (LogFile,LogPath);
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (#7,'Error appending to '+LogPath,' (error ',IORes,')');
          Halt;
     END;

     IF (ParamCount <> 1) THEN
     BEGIN
          Log ('Usage: FileScan <path to output.txt>');
          Close (LogFile);
          Halt;
     END;

     Assign (InFile,ParamStr (1));
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogErr (IORes,'FileScan: Error opening '+ParamStr (1))
     END ELSE
     BEGIN
          ScanPath (WorkDrive+'\');
          Close (InFile);
     END;

     Close (LogFile);
END.
