{ -------------------------------------------------- }
{ UserBase.Inc                                       }
{                                                    }
{ This file contains the structure definitions of    }
{ the WaterGate User Database.                       }
{                                                    }
{ (c) 1994 WaterLine Software Development            }

{$IFNDEF Wtr_UserBase}
{$DEFINE Wtr_UserBase}

{$I Globals.Inc}

TYPE SystemType      = (_F,_U);
     SendType        = (NORMAL,HOLD,CRASH,DIRECT);

TYPE  UserBaseRecord = RECORD
                            Deleted      : BOOLEAN;                     { Record is free?            }

                            System       : SystemType;                  { Fido or Usenet user        }
                            Organization : STRING[MaxLenOrganization];  { Organization desciption    }
                            Groups       : GroupFlagType;
                            Passive      : BOOLEAN;                     { Temp. Switched off ?       }

                            AreaFixPwd   : STRING[MaxLenAreaFixPwd];    { Areafix access password    }
                            AllowFrom    : BOOLEAN;                     { Allow %FROM command        }
                            AllowCreate  : BOOLEAN;                     { Allow area create          }

                            NewAreaDefault: GroupFlagType;              { Groups to add auto created }
                                                                        { areas to.                  }
                            AllowForward  : Boolean;                    { Allow AreaFix Request      }
                                                                        { forwarding for this node   }

                            AreaList     : SubscriptBaseRecordNrType;   { Pointer to subscibed areas }

                            UUCPName     : STRING[MaxLenUUCPName];      { Systems UUCP (ID) name     }
                            WorldReg     : BOOLEAN;                     { System is world registerd ?}
                            Domains      : ARRAY[1..MaxDomains] OF      { System Domain Aka's        }
                                           STRING[MaxLenDomain];

                            CASE INTEGER OF
                        { Fido } 0 : (Address      : FidoAddrType;      { Systems Fido Address       }
                                      Sysop        : STRING[MaxLenSysopName];
                                      PacketPwd    : STRING[8];         { Packet security password   }
                                      Compression  : CompressionType;   { Compression program        }
                                      MaxPktLength : LONGINT;           { Maximum PKT size for user  }
                                      SendFormat   : SendType;          { How fast do we send (CRASH)}
                                     );

                      { UseNet } 1 : (
                                      Compress     : BOOLEAN;           { Compress outgoing bundles ?}
                                      CunBatch     : BOOLEAN;           { Add CUNBATCH string        }
                                      BAGbacklink  : STRING[MaxLenUUCPName];
                                     );
                      END;

{$ENDIF}
