PROGRAM WTR2RA;

{$X+}

{ WaterGate to Remote Access 2.02                                           }
{                                                                           }
{ File    : WTR2RA                                                          }
{ Compiler: Turbo Pascal v7.00                                              }
{ Date    : 19/03/1994                                                      }
{ Version : 1.01                                                            }
{                                                                           }
{ This program exports all JAM areas defined in the WaterGate configuration }
{ to a file Remote Access can read. Use this code as a base for your own    }
{ programs, so that the exported information suits your BBS system.         }
{                                                                           }
{                                                                           }
{ Usage:                                                                    }
{                                                                           }
{ WTR2RA <outputfile>                                                       }
{                                                                           }
{ RemoteAccess 2.02 is                                                      }
{ Copyrighted 1989-1993 Wantree Development & Andrew Milner                 }

{ "WtrFunc" contains some basic functions to access the configuration       }

USES WtrFunc,Dos,Strings;

{ Remote Access message board structure                                     }
TYPE  MsgKindsType   = (Both, Private, Public, ROnly, NoReply);
      MsgType        = (LocalMail, NetMail, EchoMail);
      FlagType       = ARRAY[1..4] OF Byte;

      MESSAGErecord  = RECORD
                        Unused         : ARRAY[1..4] of Byte;
                        Name           : STRING[40];
                        Typ            : MsgType;
                        MsgKinds       : MsgKindsType;
                        Attribute      : Byte;

                      { Bit 0 : Enable EchoInfo
                            1 : Combined access
                            2 : File attaches
                            3 : Allow aliases
                            4 : Use SoftCRs as characters
                            5 : Force handle
                            6 : Allow deletes
                            7 : Is a JAM area }

                        DaysKill,    { Kill older than 'x' days }
                        RecvKill       : Byte; { Kill recv msgs, recv for more than 'x' days }
                        CountKill      : Word;

                        ReadSecurity   : Word;
                        ReadFlags,
                        ReadNotFlags   : FlagType;

                        WriteSecurity  : Word;
                        WriteFlags,
                        WriteNotFlags  : FlagType;

                        SysopSecurity  : Word;
                        SysopFlags,
                        SysopNotFlags  : FlagType;

                        OriginLine     : STRING[60];
                        AkaAddress     : Byte;

                        Age            : Byte;

                        JAMbase        : STRING[60];
                        Group          : Word;
                        AltGroup       : ARRAY[1..3] OF Word;

                        Attribute2     : Byte;

                      { Bit 0 : Include in all groups }

                        FreeSpace2     : ARRAY[1..9] OF BYTE;
                   END;

{ -------------------------------------------------------------------------- }
{ ShowInfo                                                                   }
{                                                                            }
{ Show the program startup message                                           }

PROCEDURE ShowInfo;
BEGIN
 Writeln('Wtr2RA');
 Writeln('Waterline Software Dev. 1994');
 Writeln;
END;

{ -------------------------------------------------------------------------- }
{ ShowHelp                                                                   }
{                                                                            }
{ Show a little information on how to use this program                       }

PROCEDURE ShowHelp;
BEGIN
 Writeln('Usage:');
 Writeln;
 Writeln('WTR2RA <Export.File>');
 Writeln;
 Writeln('This program will write a Remote Access JAM compatible message');
 Writeln('board configuration to disk. Run this program from your WaterGate');
 Writeln('system directory or set the WTRGATE enviroment variable.');
 Writeln('The export file is usually "MESSAGES.RA"');
 Writeln;
END;


{ -------------------------------------------------------------------------- }
{ FileExist                                                                  }
{                                                                            }
{ Simple function to check if a given filename exists.                       }

FUNCTION FileExist( Filename : String ) : Boolean;
VAR Search : SearchRec;
BEGIN
 FindFirst( FileName , $3C , Search );
 FileExist := (DosError = 0);
END;

{ -------------------------------------------------------------------------- }
{ ClearFlag                                                                  }
{                                                                            }
{ Resets a given status flag                                                 }

PROCEDURE ClearFlag( VAR Flag : FlagType );
VAR Cnt : 1..4;
BEGIN
 FOR Cnt := 1 TO 4 DO
  Flag[Cnt] := 0;
END;


VAR AreaCounter,
    AreaLimit,
    NumAreas     : Longint;
    AreaData     : AreaBaseRecord;
    AreaBaseFile : FILE;
    Config       : ConfigRecord;
    RARecord     : MessageRecord;
    RAFile       : FILE;
    RAFileName   : String;

BEGIN

  { Show program information         }
  ShowInfo;

  { Look for the output filename     }

  RAFileName := ParamStr(1);

  IF RAFileName = '' THEN
   BEGIN
   ShowHelp;
   Halt(1);
   END;

  { Read the WaterGate configuration }
  IF NOT ReadConfiguration( Config ) THEN
   BEGIN
   Writeln('Fatal: Error opening WaterGate configuration files');
   Halt (1);
   END;

  { Try to open the Areabase         }

  IF NOT OpenAreaBase( AreaBaseFile ) THEN
   BEGIN
   Writeln('Error! Unable to open WaterGate Area Base !');
   Halt(1);
   END;

  { Retrieve the total number of Areabase records                    }

  NumAreas := AreaBaseRecordCount( AreaBaseFile );

  { Open the export file for output, Append if a file with the given }
  { name already exists, Rewrite for a new file.                     }

  IF FileExist( RAFileName ) THEN
   BEGIN
   {$I-} Assign( RAFile , RAFileName );   { Append }
   Reset( RAFile , 1 );
   Seek( RAFile, FileSize( RAFile )); {$I+}

   IF IoResult>0 THEN
    BEGIN
    Writeln( 'Error while appending to : ' + RaFileName );
    Halt(1);
    END;
   Writeln('Appending to existing file..');
   END
  ELSE
   BEGIN
   {$I-} Assign( RAFile , RAFileName);  { Rewrite }
   Rewrite( RAFile , 1 ); {$I+}

   IF IoResult>0 THEN
    BEGIN
    Writeln( 'Error while creating : ' + RaFileName );
    Halt(1);
    END;

   Writeln('Creating new file..');
   END;

  IF IoResult > 0 THEN
   BEGIN
   Writeln('Fatal: Unable to open "',RaFileName,'" for output.');
   Halt(1);
   END;

  { Walk through every record in the configuration file,          }

  FOR AreaCounter := 1 TO NumAreas DO
   BEGIN
   ReadAreaBaseRecord( AreaBaseFile, AreaData , AreaCounter );

   { Show that we are still alive                                 }
   Write( 'Area: ' , AreaCounter , #13 );

   IF (NOT AreaData.Deleted) AND (AreaData.FidoMsgStyle = JAMType) THEN
   BEGIN

    WITH RARecord, AreaData DO
     BEGIN
     { There is no limit to the number of different JAM bases }
     Inc( AreaLimit );

     Name           := AreaName_F;
     Typ            := Echomail;    { WaterGate current only knows this type }
     MsgKinds       := Public;
     Attribute      := 1 {EchoInfo} + 64 + { Allow Delete } + 128 { IsJAM };

     DaysKill       := Byte( FidoMsgAge   );
     RecvKill       := Byte( FidoMsgAge   );
     CountKill      := Word( FidoMsgLimit );

     ReadSecurity   := 20;

     ClearFlag( ReadFlags );       { Remote Access uses a 3 state flag       }
     ClearFlag( ReadNotFlags );    { for access (ignore,set,not_set)         }

     WriteSecurity  := 20;

     ClearFlag( WriteFlags    );
     ClearFlag( WriteNotFlags );

     SysopSecurity  := 65535;

     ClearFlag( SysopFlags    );
     ClearFlag( SysopNotFlags );

     IF OriginNr = 0 THEN
      OriginLine := AreaData.Origin
     ELSE
      OriginLine := Config.Origins[ AreaData.OriginNr ];

     AkaAddress     := 0; { Main Aka }
     Age            := 0;

     JAMbase        := FidoMsgPath;
     Group          := 1;
     AltGroup[1]    := 0;
     AltGroup[2]    := 0;
     AltGroup[3]    := 0;
     Attribute2     := 0;

     { Write Area information to Disk                                  }
     {$I-} BlockWrite( RAFile , RaRecord , Sizeof( RaRecord )); {$I+}

     IF IoResult > 0 THEN
      BEGIN
      Writeln('Error! Export configuration disk write error');
      Halt(1);
      END;

    END; { WITH }
  END; { IF }

 END; { WHILE }

 { Close all open files }

 CloseAreaBase( AreaBaseFile );
 Close( RAFile );

 Writeln;
 Writeln( 'Finished !');

END.
