PROGRAM WtrConv;

{ programma om de databases te converteren tussen alle mogelijke versies }

USES Tdb;

CONST ConfigFilename = 'WTRCFG.TDB';


{--------------------------------------------------------------------------}
{ ConvertConfig01to02                                                      }
{                                                                          }
PROCEDURE ConvertConfig01To02;

VAR TdbNr : TdbNrType;
    Cfg   : ARRAY[1..1651] OF BYTE;
    Lp    : WORD;

BEGIN
     TdbOpen (ConfigFilename,TdbNr);
     TdbSetIO (TdbNr,1650);
     TdbRead (TdbNr,1,Cfg);

     FOR Lp:=1650 DOWNTO 92 DO Cfg[Lp+1]:=Cfg[Lp];
     Boolean (Cfg[91]):=FALSE;

     TdbSetIO (TdbNr,1651);
     TdbWrite (TdbNr,1,Cfg);
     TdbSetHeader (TdbNr,'WtrGate Config 02');
     TdbClose (TdbNr);

     WriteLn ('Updated WTRCFG.TDB from version 01 to 02');
END;


{--------------------------------------------------------------------------}
{ CheckConfig                                                              }
{                                                                          }
{ Deze routine checkt de WTRCFG.TDB database en kan deze upgraden.         }
{                                                                          }
PROCEDURE CheckConfig;

VAR TdbNr  : TdbNrType;
    Header : TdbHeaderString;

BEGIN
     IF (TdbOpen (ConfigFilename,TdbNr) <> _tdbOk) THEN
     BEGIN
          WriteLn (ConfigFilename,' not found');
          Exit;
     END;

     Header:=TdbReadHeader (TdbNr);
     TdbClose (TdbNr);

     IF (Copy (Header,1,14) <> 'WtrGate Config') THEN
     BEGIN
          WriteLn (ConfigFilename,' is not the WaterGate config file!');
          Exit;
     END;

     IF (Copy (Header,16,2) = '01') THEN ConvertConfig01To02;
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }
BEGIN
     WriteLn ('WtrConv v0.01 beta');
     WriteLn ('WtrConv is part of WtrGate, (c) by its authors ''93');
     WriteLn;

     CheckConfig;
END.