UNIT UpgrArea;

{$I platform.inc}

INTERFACE

USES UpgrGlob;

PROCEDURE UpgradeAreaBase (VAR Rec; VAR Version : BYTE);

(* not supported
TYPE AreaBase01Record = RECORD
                              Deleted      : BOOLEAN;
                              AreaName     : AreaNameString;
                              Comment      : STRING[MaxLenComment];
                              IsInGroups   : LONGINT;
                              UserList     : WORD;
                              OriginAka    : BYTE;
                              SeenByAkas   : WORD;
                              OriginNr     : BYTE;
                              Origin       : STRING[MaxLenOrigin];
                              FidoMsgStyle : BYTE;
                              FidoMsgPath  : STRING[79];
                              FidoMsgAge   : INTEGER;
                              FidoMsgLimit : INTEGER;
                              Moderated    : BYTE;
                              Moderator    : STRING[MaxLenModerator];
                        END;

{ AreaBase Record 02                                                       }
{                                                                          }
{ Maart 1994                                                               }
{                                                                          }
{ Kleine aanpassingen op het oorspronkelijke formaat, veranderingen in     }
{ Areaname (aparte Usenet en Fido namen mogenlijk) en Areatype (nu zowel   }
{ echomail, netmail en lokale mail areas mogenlijk) en een bugfix in       }
{ het SeenByAka's veld, die niet aangepast was (16 bits) toen het aantal   }
{ aka's naar 20 ging.                                                      }

TYPE AreaBase02Record = RECORD
                              Deleted      : BOOLEAN;
                              AreaType     : BYTE;
                              AreaName_U   : AreaNameString;
                              AreaName_F   : AreaNameString;
                              Comment      : STRING[MaxLenComment];
                              IsInGroups   : LONGINT;
                              UserList     : WORD;
                              OriginAka    : BYTE;
                              SeenByAkas   : LONGINT;
                              OriginNr     : BYTE;
                              Origin       : STRING[MaxLenOrigin];
                              FidoMsgStyle : BYTE;
                              FidoMsgPath  : STRING[79];
                              FidoMsgAge   : INTEGER;
                              FidoMsgLimit : INTEGER;
                              Moderated    : BYTE;
                              Moderator    : STRING[MaxLenModerator];
                        END;
*)

{ Areabase 03                                                           }
{                                                                       }
{ Juni 1994                                                             }
{                                                                       }
{ Toevoegen van AllowPassive and Passive om Areafix automatische        }
{ automatisch afsluiten mogenlijk te maken.                             }

TYPE AreaBase03Record = RECORD
   { start at byte   0 }      Deleted      : BOOLEAN;
                 {   1 }      AreaType     : BYTE;
                 {   2 }      AreaName_U   : STRING[60];
                 {  63 }      AreaName_F   : STRING[60];
                 { 124 }      Comment      : STRING[60];
                 { 185 }      IsInGroups   : LONGINT;
                 { 189 }      UserList     : WORD;
                 { 191 }      OriginAka    : BYTE;
                 { 192 }      SeenByAkas   : LONGINT;
                 { 196 }      Passive      : BOOLEAN;
                 { 197 }      AlwPassive   : BOOLEAN;
                 { 198 }      OriginNr     : BYTE;
                 { 199 }      Origin       : STRING[61];
                 { 261 }      FidoMsgStyle : BYTE;
                 { 262 }      FidoMsgPath  : STRING[79];
                 { 342 }      FidoMsgAge   : INTEGER;
                 { 344 }      FidoMsgLimit : INTEGER;
                 { 346 }      Moderated    : BYTE;
                 { 347 }      Moderator    : STRING[50];
{ next would be at 398 }END;

TYPE AreaBase04Record = RECORD
   { start at byte   0 }      Deleted      : BOOLEAN;
                 {   1 }      AreaType     : BYTE;
                 {   2 }      AreaName_U   : STRING[60];
                 {  63 }      AreaName_F   : STRING[60];
                 { 124 }      Comment      : STRING[60];
                 { 185 }      IsInGroups   : LONGINT;
                 { 189 }      UserList     : WORD;
                 { 191 }      OriginAKA    : BYTE;
                 { 192 }      SeenByAKAs   : LONGINT;
                 { 196 }      Passive      : BOOLEAN;
                 { 197 }      AlwPassive   : BOOLEAN;
                 { 198 }      OriginNr     : BYTE;
                 { 199 }      Origin       : STRING[61];
                 { 261 }      FidoMsgStyle : BYTE;
                 { 262 }      FidoMsgPath  : STRING[79];
                 { 342 }      FidoMsgAge   : INTEGER;
                 { 344 }      FidoMsgLimit : INTEGER;
                 { 346 }      Moderated    : BYTE;
                 { 347 }      Moderator    : STRING[50];
       { ++ 04 } { 398 }      Decode       : BOOLEAN;
       { ++ 04 } { 399 }      DecodePath   : STRING[79];
{ next would be at 479 }END;

{ 0.92 }
TYPE AreaBase05Record = RECORD
   { start at byte   0 }      Deleted       : BOOLEAN;
                 {   1 }      AreaType      : BYTE;
                 {   2 }      AreaName_U    : STRING[60];
                 {  63 }      AreaName_F    : STRING[60];
                 { 124 }      Comment       : STRING[60];
                 { 185 }      IsInGroups    : LONGINT;
                 { 189 }      UserList      : WORD;
                 { 191 }      OriginAKA     : BYTE;
       {-- 0.92               SeenByAKAs    : LONGINT; }
       {++ 0.92 }{ 192 }      AddSeenByAKAs : ARRAY[0..12] OF BYTE;
                              { @196 +9 L283 }
                 { 205 }      Passive       : BOOLEAN;
                 { 206 }      AlwPassive    : BOOLEAN;
                 { 207 }      OriginNr      : BYTE;
                 { 208 }      Origin        : STRING[61];
                 { 270 }      FidoMsgStyle  : BYTE;
                 { 171 }      FidoMsgPath   : STRING[79];
                 { 351 }      FidoMsgAge    : INTEGER;
                 { 353 }      FidoMsgLimit  : INTEGER;
                 { 355 }      Moderated     : BYTE;
                 { 356 }      Moderator     : STRING[50];
       { ++ 04 } { 407 }      Decode        : BOOLEAN;
       { ++ 04 } { 408 }      DecodePath    : STRING[79];
{ next would be at 488 }END;

{ 0.93.PRE0 }
TYPE AreaBase06Record = RECORD
   { start at byte   0 }      Deleted       : BOOLEAN;
                 {   1 }      AreaType      : BYTE;
                 {   2 }      AreaName_U    : STRING[60];
                 {  63 }      AreaName_F    : STRING[60];
                 { 124 }      Comment       : STRING[60];
                 { 185 }      IsInGroups    : LONGINT;
                 { 189 }      UserList      : WORD;
                 { 191 }      OriginAKA     : BYTE;
                 { 192 }      AddSeenByAKAs : ARRAY[0..12] OF BYTE;
                 { 205 }      Passive       : BOOLEAN;
                 { 206 }      AlwPassive    : BOOLEAN;
                 { 207 }      OriginNr      : BYTE;
                 { 208 }      Origin        : STRING[61];
                 { 270 }      FidoMsgStyle  : BYTE;
                 { 171 }      FidoMsgPath   : STRING[79];
                 { 351 }      FidoMsgAge    : INTEGER;
                 { 353 }      FidoMsgLimit  : INTEGER;
                 { 355 }      Moderated     : BYTE;
                 { 356 }      Moderator     : STRING[50];
                 { 407 }      Decode        : BOOLEAN;
                 { 408 }      DecodePath    : STRING[79];
     {++06/0.93 }{ 488 }      Hidden        : BOOLEAN;
{ next would be at 489 }END;

{ 0.93.PRE3 }
TYPE AreaBase07Record = RECORD
   { start at byte   0 }      Deleted       : BOOLEAN;
                 {   1 }      AreaType      : BYTE;
                 {   2 }      AreaName_U    : STRING[60];
                 {  63 }      AreaName_F    : STRING[60];
                 { 124 }      Comment       : STRING[60];
     { Changed } { 185 }      IsInGroups    : ARRAY[1..16] OF BYTE;
                              { @189 +12 L300 }
                 { 201 }      UserList      : WORD;
                 { 203 }      OriginAKA     : BYTE;
                 { 204 }      AddSeenByAKAs : ARRAY[0..12] OF BYTE;
                 { 217 }      Passive       : BOOLEAN;
                 { 218 }      AlwPassive    : BOOLEAN;
                 { 219 }      OriginNr      : BYTE;
                 { 220 }      Origin        : STRING[61];
                 { 282 }      FidoMsgStyle  : BYTE;
                 { 283 }      FidoMsgPath   : STRING[79];
                 { 363 }      FidoMsgAge    : INTEGER;
                 { 365 }      FidoMsgLimit  : INTEGER;
                 { 367 }      Moderated     : BYTE;
                 { 368 }      Moderator     : STRING[50];
                 { 419 }      Decode        : BOOLEAN;
                 { 420 }      DecodePath    : STRING[79];
                 { 500 }      Hidden        : BOOLEAN;
                              { Hidden renamed to Mandatory in 0.94.PRE1 }
{ next would be at 501 }END;


{ 0.94.PRE4 }
TYPE AreaBase08Record = RECORD
   { start at byte   0 }      Deleted       : BOOLEAN;
                 {   1 }      AreaType      : BYTE;
                 {   2 }      AreaName_U    : STRING[60];
                 {  63 }      AreaName_F    : STRING[60];
                 { 124 }      Comment       : STRING[60];
                 { 185 }      IsInGroups    : ARRAY[1..16] OF BYTE;
                 { 201 }      UserList      : WORD;
                 { 203 }      OriginAKA     : BYTE;
                 { 204 }      AddSeenByAKAs : ARRAY[0..12] OF BYTE;
                 { 217 }      Passive       : BOOLEAN;
                 { 218 }      AlwPassive    : BOOLEAN;
                 { 219 }      OriginNr      : BYTE;
                 { 220 }      Origin        : STRING[61];
                 { 282 }      FidoMsgStyle  : BYTE;
                 { 283 }      FidoMsgPath   : STRING[79];
                 { 363 }      FidoMsgAge    : INTEGER;
                 { 365 }      FidoMsgLimit  : INTEGER;
                 { 367 }      Moderated     : BYTE;
                 { 368 }      Moderator     : STRING[50];
                 { 419 }      Decode        : BOOLEAN;
                 { 420 }      DecodePath    : STRING[79];
                 { 500 }      Hidden        : BOOLEAN;
    {++}         { 501 }      RulesFile     : STRING[79];
    {++}         { 581 }      DupeList      : LONGINT;
    {++}         { 585 }      DupeAge       : BYTE;
{ next would be at 586 }END;


{ 0.94.PRE30 }
TYPE AreaBase09Record = RECORD
   { start at byte   0 }      Deleted       : BOOLEAN;
                 {   1 }      AreaType      : BYTE;
                 {   2 }      AreaName_U    : STRING[60];
                 {  63 }      AreaName_F    : STRING[60];
                 { 124 }      Comment       : STRING[60];
                 { 185 }      IsInGroups    : ARRAY[1..16] OF BYTE;
                 { 201 }      UserList      : WORD;
                 { 203 }      OriginAKA     : BYTE;
                 { 204 }      AddSeenByAKAs : ARRAY[0..12] OF BYTE;
                 { 217 }      Passive       : BOOLEAN;
                 { 218 }      AllowPassive  : BOOLEAN;
                 { 219 }      OriginNr      : BYTE;
                 { 220 }      Origin        : STRING[61];
                 { 282 }      FidoMsgStyle  : BYTE;
                 { 283 }      FidoMsgPath   : STRING[79];
                 { 363 }      FidoMsgAge    : INTEGER;
                 { 365 }      FidoMsgLimit  : INTEGER;
                 { 367 }      Moderated     : BYTE;
                 { 368 }      Moderator     : STRING[50];
                 { 419 }      Decode        : BOOLEAN;
                 { 420 }      DecodePath    : STRING[79];
                 { 500 }      Mandatory     : BOOLEAN;
                 { 501 }      RulesFile     : STRING[79];
                 { 581 }      DupeList      : LONGINT;
                 { 585 }      DupeAge       : BYTE;
       {++}      { 586 }      CharSet_RFC   : STRING[30];
       {++}      { 617 }      Charset_FTN   : STRING[30];
{ next would be at 648 }END;

CONST Database_AreaBase : DatabaseRecord =
       (Filename : 'AREABASE';
        Proc     : UpgradeAreabase;
        Header   : 'WtrGate AreaBase ';
        Oldest   : 3;
        Latest   : 9;
        RecSizes : (0, { 01 }
                    0, { 02 }
                    SizeOf (AreaBase03Record),
                    SizeOf (AreaBase04Record),
                    SizeOf (AreaBase05Record),
                    SizeOf (AreaBase06Record),
                    SizeOf (AreaBase07Record),
                    SizeOf (AreaBase08Record),
                    SizeOf (AreaBase09Record),
                    0, { 10 }
                    0, { 11 }
                    0, { 12 }
                    0, { 13 }
                    0, { 14 }
                    0, { 15 }
                    0, { 16 }
                    0, { 17 }
                    0, { 18 }
                    0, { 19 }
                    0, { 20 }
                    0, { 21 }
                    0, { 22 }
                    0, { 23 }
                    0, { 24 }
                    0, { 25 }
                    0, { 26 }
                    0, { 27 }
                    0, { 28 }
                    0, { 29 }
                    0, { 30 }
                    0, { 31 }
                    0, { 32 }
                    0, { 33 }
                    0, { 34 }
                    0, { 35 }
                    0, { 36 }
                    0, { 37 }
                    0, { 38 }
                    0, { 39 }
                    0  { 40 }
               )
      );

IMPLEMENTATION

USES Ramon;


{--------------------------------------------------------------------------}
{ UpgradeAreaBase                                                          }
{                                                                          }
{ Deze routine upgrade een AreaBase record.                                }
{                                                                          }
PROCEDURE UpgradeAreaBase (VAR Rec; VAR Version : BYTE);

VAR Old : LONGINT;
    Lp  : BYTE;

BEGIN
     IF (Version = 3) THEN
     BEGIN
          { 03 -> 04

            DecodeFiles en DecodePath toegevoegd aan einde record.
            Worden al op 0 gezet, dus geen verdere actie nodig.
          }

          Version:=4;
     END;

     IF (Version = 4) THEN
     BEGIN
          { 04 -> 05

            SeenByAKAs : LONGINT vervangen ivm 100 AKAs nu.
            AddSeenByAKAs toegevoegd. Oude info overnemen!

          }

          { @196 +9 L283 }
          Move (BA(Rec)[196],BA(Rec)[196+9],283);

          Old:=AreaBase04Record (Rec).SeenByAKAs;

          WITH AreaBase05Record (Rec) DO
          BEGIN
               FillChar (AddSeenByAKAs,13,0);

               FOR Lp:=1 TO 20 DO
                   IF ((Old AND (Longint (1) SHL (Lp-1))) > 0) THEN
                      AddSeenByAKAs[(Lp-1) DIV 8]:=AddSeenByAKAs[(Lp-1) DIV 8] OR (1 SHL ((Lp-1) MOD 8));
          END; { with }

          Version:=5;
     END;

     IF (Version = 5) THEN
     BEGIN
          { 05 -> 06

            Hidden veld toegevoegd
            Geen actie nodig; al op 0/FALSE gezet
          }

          Version:=6;
     END;

     IF (Version = 6) THEN
     BEGIN
          { 06 -> 07

            Groups veld gewijzigd
            - volgende velden opschuiven
            - oude niet gebruikte bits wissen
            - nieuwe bits wissen
          }

          { @189 +12 L300 }
          Move (BA(Rec)[189],BA(Rec)[189+12],300);

          { groups 25&26 blijven, rest wissen (zekerheidje) }
          BA(Rec)[185+3]:=BA(Rec)[185+3] AND 3;

          { wis de rest }
          FOR Lp:=4 TO 15 DO
              BA(Rec)[185+Lp]:=0;

          Version:=7;
     END;

     IF (Version = 7) THEN
     BEGIN
          { 07 -> 08

            Added fields:
             - RulesFile
             - DupeList
             - DupeAge
          }

          WITH AreaBase09Record (Rec) DO
          BEGIN
               RulesFile:='';
               DupeList:=0;
               DupeAge:=2; { weeks }
          END; { with }

          Version:=8;
     END;

     IF (Version = 8) THEN
     BEGIN
          { 08 -> 09

            Added CharSet_RFC
            Added CharSet_FTN

            Make sure the RFC Area name is in all lower case
            At the same time, uppercase the FTN name
          }

          WITH AreaBase09Record (Rec) DO
          BEGIN
               AreaName_F:=UpCaseString (AreaName_F);
               AreaName_U:=LoCaseString (AreaName_U);
               CharSet_RFC:='';
               CharSet_FTN:='';
          END;

          Version:=9;
     END;
END;


END.
