UNIT RunCfg;

{$I platform.inc}

{ Run-Time configuration database                                    }
{                                                                    }
{ This routine reads all required information from the Flex Database }
{ and stores it in memory.                                           }
{                                                                    }
{ This unit is used by WtrGate, WtrGateO, WtrGateD and WtrTest.      }
{ It takes care of initialzing and cleaning up FlexCfg as well.      }

INTERFACE

USES FlexCfg;

FUNCTION  RunCfg_Init : BOOLEAN;
PROCEDURE RunCfg_Done;

VAR ArchiversPtr : ^FtnArchivers;


IMPLEMENTATION

{--------------------------------------------------------------------------}
{ RunCfg_Init                                                              }
{                                                                          }
{ This routine reads all run-time required information from the config.tdb }
{ database (flex database) and stores it in memory, allocating memory      }
{ where required to minimize the amount needed.                            }
{                                                                          }
FUNCTION RunCfg_Init : BOOLEAN;
BEGIN
     GetMem (ArchiversPtr,SizeOf (FtnArchivers));

     Flex_Init;

{$IFDEF PLATFORM_OS2}
     { --------- OS2 ------------}
     {$IFNDEF WtrTest}
     Flex_OS2Archivers_Read (ArchiversPtr^);
     {$ENDIF}
{$ELSE}
     { --------- DOS ------------}
     {$IFNDEF WtrTest}
     Flex_DosArchivers_Read (ArchiversPtr^);
     {$ENDIF}
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ RunCfg_Done                                                              }
{                                                                          }
{ This routine cleans up at the end of a run by freeing all memory.        }
{                                                                          }
PROCEDURE RunCfg_Done;
BEGIN
     IF (ArchiversPtr <> NIL) THEN
     BEGIN
          FreeMem (ArchiversPtr,SizeOf (FtnArchivers));
          ArchiversPtr:=NIL;
     END;
     Flex_Done;
END;


BEGIN
     ArchiversPtr:=NIL;
END.
