{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT MsgUtil;

{$i platform.inc}

{ (FIDO) MsgUtil                                                            }
{                                                                           }
{ Deze unit bevat de routines die nodig zijn voor onderhoud van de *.MSG    }
{ berichten base.                                                           }
{                                                                           }
{ Reply linken van berichten                                                }
{ Purgen van berichten op    - aantal                                       }
{                            - leeftijd                                     }
{                                                                           }
{ MD  28-06-93 Major speed upgrade, update nu geen berichten die toch geen  }
{              link hebben.                                                 }
{     03-08-93 Squish Linking hierheen verplaatst                           }
{              Squish Purging toegevoegd                                    }
{     04-08-93 Fido *.MSG purging toegevoegd                                }
{     13-09-93 JAM reindexing toegevoegd                                    }
{     07-10-93 Area,User & Subscription base onderhoud toegevoegt           }
{ RWI 18-10-94 Takeover, re-layout en bug fixing.                           }

INTERFACE

USES Database;

{ progress window coordinates }
CONST SXb  = 5;
      SYb  = 5;
      SXl  = 70;
      SYl  = 8;
      SXb2 = SXb+15;

TYPE LinkStructPtr = ^LinkStruct;
     LinkStruct    = RECORD
                           CRC_Subject : LONGINT;
                           Msg_Number  : LONGINT;
                           Nxt_Struct  : LinkStructPtr;
                     END;

TYPE StatusRecord = RECORD
                          AreaName     : STRING[50];
                          Areas,
                          AreasToDo    : WORD;
                          TotalMsg,
                          DezeArea,
                          DezeToDo,
                          SavedBytes   : LONGINT;
                    END;

VAR Status : StatusRecord;

PROCEDURE LinkOnlySeenAreas;
PROCEDURE UtilLinkAllAreas (Groups : GroupFlagType);
FUNCTION  UtilLinkMsgArea (AreaRecord : AreaBaseRecord) : BOOLEAN; { TRUE = Aborted }

PROCEDURE UtilPurgeAllAreas (Groups : GroupFlagType);

PROCEDURE UtilPackMsgArea (AreaRecord : AreaBaseRecord);

PROCEDURE UtilRenumberAllMSGAreas (Groups : GroupFlagType);
PROCEDURE UtilRenumberAllJAMAreas (Groups : GroupFlagType);
PROCEDURE UtilRenumberMsgArea (DirectoryName : STRING);

PROCEDURE UtilReIDXAllAreas (Groups : GroupFlagType);

PROCEDURE UtilUpdateProgress;
FUNCTION  UtilPercSaved (OldSize,NewSize : LONGINT) : BYTE;

PROCEDURE SelectiveAreaMaintenance;


IMPLEMENTATION

USES Crt,
     Fido,
     ListSrv,
     DOS,
     Logs,
     Globals,
     Ramon,
     NewStats,
     Strings,
     Squish,
     UnixTime,
     Binkley,
     Cfg,
     AreaBase,
     UserBase,
     FidoMsg,
     Slice,
     Jam;

{$I wtrhlp.inc}

VAR LogSavedFirst : BOOLEAN;

{--------------------------------------------------------------------------}
{ LogGroups                                                                }
{                                                                          }
{ Deze routine schrijft een regel in de logfile als het groups filter iets }
{ anders is als GR_ALL.                                                    }
{                                                                          }
PROCEDURE LogGroups (Groups : GroupFlagType);

VAR Result    : STRING[30];

BEGIN
     IF TestGroupListSame (Groups,AllGroups) THEN
        Exit;

     Result:=BuildGroupListDesc (Groups,255);
     WHILE (Result <> '') AND (Pos (' ',Result) > 0) DO
           Delete (Result,Pos (' ',Result),1);

     LogMessage (liGeneral,'Only processing for areas in groups '+Result);
END;


{--------------------------------------------------------------------------}
{ StatusWindow                                                             }
{                                                                          }
{ Creert het link windowtje.                                               }
{                                                                          }
PROCEDURE StatusWindow;

VAR Lines : BYTE;

BEGIN
     IF NOT (StayQuiet OR NoFullScreen) THEN
     BEGIN
          Lines:=Video.Rows-1{keysline}-(SYb+SYl+2{last line & shadow});
          IF (Lines < Log_GetWindowSize) THEN
             Log_SetWindowSize (Lines);

          PushKeysLine;
          WriteKeysLine (' ^Esc Abort');

          WindowPush (SXb,SYb,SXl,SYl);
          BoxDraw (Double,SXb,SYb,SXl,SYl);

          WriteXY (SXb+2,SYb+1,'Area name  :');
          WriteXY (SXb+2,SYb+2,'Area type  :');
          WriteXY (SXb+2,SYb+3,'Area count :');
          WriteXY (SXb+2,SYb+4,'Total Msgs :');
          WriteXY (SXb+2,SYb+5,'This Area  :');
          WriteXY (SXb+2,SYb+6,'Status     :');
     END;

     WITH Status DO
     BEGIN
          AreaName:='';
          Areas:=0;
          AreasToDo:=0;
          TotalMsg:=0;
          DezeArea:=0;
          DezeToDo:=0;
          SavedBytes:=0;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ UtilUpdateProgress                                                       }
{                                                                          }
{ Deze routine moet gebruikt worden om de progress tijdens lange processen }
{ te volgen. Het scherm wordt ook geupdate.                                }
{                                                                          }
PROCEDURE UtilUpdateProgress;

VAR TempStr : STRING[50];
    Perc    : BYTE;

BEGIN
     WITH Status DO
     BEGIN
          TempStr:=Word2String (DezeArea);

          IF (DezeToDo > 0) THEN
          BEGIN
               Perc:=Round ((DezeArea/DezeToDo)*100);
               TempStr:=TempStr+'/'+Word2String (DezeToDo)+' ('+Byte2String (Perc)+'%)';
          END;

          IF (NOT (StayQuiet OR NoFullScreen)) THEN
            WriteXY (SXb2,SYb+5,AddUpWithSpaces (20,TempStr));
     END; { with }
END;


{--------------------------------------------------------------------------}
{ StatusWindowUpdate                                                       }
{                                                                          }
{ Deze routine vult het on screen link window met nieuw gegevens.          }
{                                                                          }
PROCEDURE StatusWindowUpdate;

VAR TempStr : STRING[50];
    Perc    : BYTE;

BEGIN
     { Update van het status windowtje }
     WITH Status DO
     BEGIN
          SetColor (cBoxData);
          IF (NOT (StayQuiet OR NoFullScreen)) THEN
            WriteXY (SXb2,SYb+1,AddUpWithSpaces (SXl-(SXb2-SXb)-2,AreaName));

          TempStr:=Word2String (Areas);
          IF (AreasToDo > 0) THEN
          BEGIN
               Perc:=Round ((Areas/AreasToDo)*100);
               TempStr:=TempStr+'/'+Word2String (AreasToDo)+' ('+Byte2String (Perc)+'%)';
          END;

          IF (NOT (StayQuiet OR NoFullScreen)) THEN
             WriteXY (SXb2,SYb+3,AddUpWithSpaces (20,TempStr));
          IF (NOT (StayQuiet OR NoFullScreen)) THEN
             WriteXY (SXb2,SYb+4,AddUpWithSpaces (5,Word2String (TotalMsg)));

          UtilUpdateProgress; { laten zien }
     END; { with }
END;


{--------------------------------------------------------------------------}
{ LinkOnlySeenAreas                                                        }
{                                                                          }
{ Deze routine ge/misbruikt de Stats informatie om te kijken naar welke    }
{ areas er berichten zijn geschreven. Zo worden alleen die areas gelinkt   }
{ aan het einde van een toss.                                              }
{                                                                          }
{ MD 03-08-93 Squish Linking toegevoegd                                    }
{                                                                          }
PROCEDURE LinkOnlySeenAreas;

VAR {CurrAreaSegPtr : AreaSegmentPtr;}       {### stats}
    Nr             : AreaBaseRecordNrType;
    AreaInfo       : AreaBaseRecord;
    Aborted        : BOOLEAN;
    LinkedAreas    : WORD;

BEGIN
     { Zet het link windowtje op het scherm }
     StatusWindow;
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb+2,SYb,' Link ');
   
     { Schrijf een berichtje voor de log    }
     LogMessage (liTrivial,'Started linking all areas with new messages');

     { RWI 960828 voor de mooie weergave eerst even tellen hoeveel werk er is }
     Status.AreasToDo:=0;

     LinkedAreas := 0;
     Aborted := False;

     FOR Nr := 1 TO AreaBaseRecCount DO
     BEGIN
          IF (NOT GlobalAbort) THEN
          BEGIN
               IF (Stats_HaveSeenArea (Nr)) THEN
               BEGIN
                    Slice_Now;

                    IF KeyPressed AND (ReadKey = kEsc) THEN
                    BEGIN
                         Aborted := TRUE;
                         Break;                   { For }
                    END;

                    Inc (Status.Areas);
                    StatusWindowUpdate;

                    ReadAreaBaseRecord (Nr, AreaInfo);

                    IF (AreaInfo.FidoMsgStyle <> NoneType) AND
                         (AreaInfo.AreaName_F <> '') THEN
                    BEGIN
                         LogExtraMessage ('Linking area#'+Longint2string (Nr)+':'+AreaInfo.AreaName_F);
                         Inc (LinkedAreas);

                         Status.DezeArea:=0;
                         Status.DezeToDo:=0;
                         Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
                         StatusWindowUpdate;
                         IF (StayQuiet) AND (ScreenToo) THEN BEGIN
                              Write (AddUpWithSpaces (79, 'Linking: '+AreaInfo.AreaName_F));
                              GotoXY (1, WhereY);
                         END;
                        
                         CASE AreaInfo.FidoMsgStyle OF
                              SquishType :
                                   Aborted:=Squish_LinkArea (AreaInfo);

                              FidoMsgType :
                                   Aborted:=UtilLinkMsgArea (AreaInfo);

                              JamType :
                                   Aborted:=Jam_LinkArea (AreaInfo);
                         END; { case }

                         Inc (Status.TotalMsg,Status.DezeToDo);
                         StatusWindowUpdate;
                   END;

                   IF Aborted THEN
                      Break; 
               END; { have seen area }
          END; { not globalabort }
     END; { for }

     IF Aborted THEN LogMessage (liGeneral,'Linking aborted')
                ELSE LogMessage (liTrivial,'Linking completed');

     LogExtraMessage ('Linked '+Word2String (LinkedAreas)+
                      ' areas, containing '+Word2String (Status.TotalMsg)+
                      ' messages.');
     
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilLinkAllAreas                                                         }
{                                                                          }
{ Deze routine doorloopt de Areabase en linkt elke area die een fido       }
{ Area heeft. (Squish/Msg/Whatever)                                        }
{                                                                          }
{ MD 03-08-93 Squish linking toegevoegd                                    }
{ RWI 951127: Groups filter toegevoegd.                                    }
{                                                                          }
PROCEDURE UtilLinkAllAreas (Groups : GroupFlagType);

VAR AreaInfo    : AreaBaseRecord;
    LinkedAreas,
    AantalAreas,
    CountAreas  : AreaBaseRecordNrType;
    Aborted     : BOOLEAN;

BEGIN
     { zet het link windowtje op het scherm }
     StatusWindow;
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb+2,SYb,' Link ');

     { schrijf een berichtje voor de log }
     LogMessage (liTrivial,'Started linking messages in areas');
     LogGroups (Groups);

     { haal het totaal aantal gebieden }
     LinkedAreas:=0;
     AantalAreas:=AreaBaseRecCount;
     Status.AreasToDo:=AantalAreas;

     Aborted:=FALSE;

     FOR CountAreas:=1 TO AantalAreas DO
     BEGIN
          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
               Aborted:=TRUE;
               Break; { uit de for/next }
          END;

          Inc (Status.Areas);
          StatusWindowUpdate;

          { wandel door de AreaBase }
          ReadAreaBaseRecord (CountAreas,AreaInfo);

          IF (AreaInfo.FidoMsgStyle <> NoneType) AND
             (NOT AreaInfo.Deleted) AND
             (AreaInfo.AreaName_F <> '') AND
             TestIfGroupCommon (Groups,AreaInfo.IsInGroups) THEN
          BEGIN
               Inc (LinkedAreas);

               Status.DezeArea:=0;
               Status.DezeToDo:=0;
               Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
               StatusWindowUpdate;

               CASE AreaInfo.FidoMsgStyle OF
                    FidoMsgType :
                        Aborted:=UtilLinkMsgArea (AreaInfo);

                    SquishType :
                        Aborted:=Squish_LinkArea (AreaInfo);

                    JamType :
                        Aborted:=Jam_LinkArea (AreaInfo);
               END;

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }

          IF Aborted THEN
             Break; { uit de for }

     END; { for }

     IF Aborted THEN LogMessage (liFatal,'Linking aborted')
                ELSE LogMessage (liTrivial,'Linking completed');

     LogExtraMessage ('Linked '+Word2String (Status.TotalMsg)+
                      ' messages in '+Word2String (LinkedAreas)+
                      ' areas.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{-------------------------------------------------------------------------}
{                       Algemene Link List Routines                       }
{-------------------------------------------------------------------------}

{-------------------------------------------------------------------------}
{ AddLinkItem                                                             }
{                                                                         }
{ Deze routine bewaard alle bericht nummers + onderwerpen, en sorteerd    }
{ op onderwerp.                                                           }
{                                                                         }
PROCEDURE AddLinkItem (VAR Anchor : LinkStructPtr; CRC,Number : LONGINT);

VAR Last,
    Loc_Anchor,
    Local      : LinkStructPtr;

BEGIN
     Last:=NIL;
     Loc_Anchor:=Anchor;

     WHILE (Loc_Anchor <> NIL) DO
     BEGIN
          { Als we een item vinden dat in de lijst geplaatst kan worden  }
          { sorteer op bericht nummer, kleine nummers vooraan. Zo hebben }
          { we alle bericht nummers op volgorde liggen.                  }

          IF (Loc_Anchor^.Msg_Number > Number) THEN
          BEGIN
               GetMem (Local,Sizeof (LinkStruct));
               {$IFDEF LogGetMem} LogGetMem (Local,SizeOf (LinkStruct),'GetMem List Local'); {$ENDIF}
               PeekMem;

               WITH Local^ DO
               BEGIN
                    CRC_Subject:=CRC;
                    Msg_Number:=Number;
                    Nxt_Struct:=Loc_Anchor;
               END; { with }

               IF (Last <> NIL) THEN
                  Last^.Nxt_Struct:=Local
               ELSE
                   Anchor:=Local;

               Exit;
          END;

          Last:=Loc_Anchor;
          Loc_Anchor:=Loc_Anchor^.Nxt_Struct;

     END; { while }

     { We zijn heel door de lijst gekomen, blijkbaar moeten we }
     { aan het einde toevoegen.                                }

     GetMem (Local,SizeOf (LinkStruct));
     {$IFDEF LogGetMem} LogGetMem (Local,SizeOf (LinkStruct),'GetMem List Local (2)'); {$ENDIF}
     PeekMem;

     WITH Local^ DO
     BEGIN
          CRC_Subject:=CRC;
          Msg_Number:=Number;
          Nxt_Struct:=NIL;
     END;

     IF (Anchor <> NIL) THEN
        Last^.Nxt_Struct:=Local
     ELSE
         Anchor:=Local;
END;


{--------------------------------------------------------------------------}
{ Get_Subject                                                              }
{                                                                          }
{ Haalt het eerste record uit de lijst, verwijderd deze en geeft met       }
{ het bijbehorende bericht nummer terug.                                   }
{                                                                          }
PROCEDURE Get_Subject (Anchor : LinkStructPtr; VAR CRC : LONGINT);

VAR Local : LinkStructPtr;

BEGIN
     WHILE (Anchor <> NIL) DO
     BEGIN
          IF (Anchor^.CRC_Subject <> 0) THEN
          BEGIN
               CRC:=Anchor^.CRC_Subject;
               Anchor:=Anchor^.Nxt_Struct;
               Exit;
          END;

          Anchor:=Anchor^.Nxt_Struct;

     END; { while }

     CRC:=0;
END;


{--------------------------------------------------------------------------}
{ Get_Next_Subject                                                         }
{                                                                          }
{ Doorzoekt de lijst op zoek naar het eerst volgende record met hetzelfde  }
{ onderwerp. Geef hiervan het berichtnummer terug.                         }
{                                                                          }
FUNCTION Get_Next_Subject (VAR Anchor : LinkStructPtr; CRC : LONGINT) : LONGINT;
BEGIN
     WHILE (Anchor <> NIL) DO
     BEGIN
          IF (Anchor^.CRC_Subject = CRC) THEN
          BEGIN
               { we hebben een record gevonden met hetzelfde onderwerp }
               Get_Next_Subject:=Anchor^.Msg_Number;
               Anchor^.CRC_Subject:=0;
               Exit;
          END;

          Anchor:=Anchor^.Nxt_Struct;

     END; { while }

     Get_Next_Subject:=0;
END;


{--------------------------------------------------------------------------}
{ DeleteList                                                               }
{                                                                          }
{ Verwijdert de lijst uit het geheugen.                                    }
{                                                                          }
PROCEDURE DeleteList (VAR List : LinkStructPtr);

VAR Erase : LinkStructPtr;

BEGIN
     WHILE (List <> NIL) DO
     BEGIN
          Erase:=List;
          List:=List^.Nxt_Struct;
          {$IFDEF LogGetMem} LogGetMem (Erase,SizeOf (LinkStruct),'Free List'); {$ENDIF}
          FreeMem (Erase,SizeOf (LinkStruct));
     END; { while }
END;


{--------------------------------------------------------------------------}
{ UtilLinkMsgArea                                                          }
{                                                                          }
{ Doorloopt een berichten gebied op, leest headers in, sorteert ze         }
{ verbind headers aan elkaar en schrijft ze weer weg.                      }
{                                                                          }
FUNCTION UtilLinkMsgArea (AreaRecord : AreaBaseRecord) : BOOLEAN;

VAR Search        : SearchRec;
    FidoMsg       : FILE;
    FidoHeader    : FidoStoredHeader;
    Aborted       : BOOLEAN; { RWI 960828 }

    CurrentMessage,
    NextMessage,
    VorigMessage,
    VorigNummer   : Integer;
    IORes,
    BerichtNummer,
    Nop           : ValNop;
    Subject       : String;
    Subject_CRC   : Longint;
    Local,
    List          : LinkStructPtr;

    {---------------------------------------------------------------------}
    { UpdateMessage                                                       }
    {                                                                     }
    { Deze routine update in een *.Msg bericht de link pointers.          }
    {                                                                     }
    PROCEDURE UpdateMessage (FileName : STRING; Vorig,Volgend : INTEGER);

    VAR OutFile : FILE;
        IORes   : BYTE;

    BEGIN
         Slice_Now;

         Assign (OutFile,Filename);
         {$I-} Reset (OutFile,1); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'[Link/UpdateMessage] Unable to open '+FileName);
              Exit;
         END;

         {$IFDEF LogFileIO}PostOpenF (OutFile);{$ENDIF}

         {$I-}
         Seek (Outfile,184);
         BlockWrite (Outfile,Vorig,SizeOf (Vorig));

         Seek (Outfile,188);
         BlockWrite (Outfile,Volgend,SizeOf (Volgend));
         {$I+}

         IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[Link/UpdateMessage] Unable to update '+FileName);

         {$IFDEF LogFileIO}PreCloseF (OutFile);{$ENDIF}
         Close (OutFile);
    END;

{UtilLinkMsgArea}

VAR Path : STRING;

LABEL GaVerder;

BEGIN
     UtilLinkMsgArea:=FALSE; { not aborted }

     { Vul het status window }
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+2,'Fido *.MSG');
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Scanning');

     List:=NIL;

     Status.DezeArea:=0;
     Status.DezeToDo:=0;

     Aborted:=FALSE;

     Path:=DeleteBackSpaces (AreaRecord.FidoMsgPath);
     IF (Path[Length (Path)] <> '\') THEN
        Path:=Path+'\';

     FindFirst (Path+'*.MSG',saJustFiles,Search);
     WHILE (DosError = 0) DO
     BEGIN
          { controleer of het bericht begint met een decimale naam }
          Val (Copy (Search.Name,1,Pos ('.',Search.Name)-1),BerichtNummer,Nop);

          { zo niet, raporteer dit aan de bevoegde instanties }
          IF (Nop <> 0) THEN
          BEGIN
               LogExtraMessage ('Ignoring invalid name '+Search.Name);
               FindNext (Search);
               Continue;
          END;

          { lees nu de header van het bericht maar in }
          Assign (FidoMsg,Path+Search.Name);
          {$I-} Reset (FidoMsg,1);
          {$IFDEF LogFileIO}PostOpenF (FidoMsg);{$ENDIF}

          BlockRead (FidoMsg,FidoHeader,SizeOf (FidoHeader));

          {$IFDEF LogFileIO}PreCloseF (FidoMsg);{$ENDIF}
          Close (FidoMsg);
          {$I+}

          IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[UtilLinkArea] Error reading from '+Search.Name);
               {hangt in een oneindige lus..
               Continue; { RWI 960828, ipv Break.. }
               GOTO GaVerder;
          END;

          { kijk of het subject begint met 'RE:' }
          Subject:=StrPas (FidoHeader.Subject);
          IF (UpCaseString (Copy (Subject,1,4)) = 'RE: ') THEN
             Delete (Subject,1,4);

          { codeer het bericht }
          AddLinkItem (List,UpdateCRC32 (0,Subject[1],Length (Subject)),BerichtNummer);

          { weer een bericht in deze area }
          Inc (Status.DezeTodo);

          IF ((Status.DezeToDo MOD 25) = 1) THEN
          BEGIN
               UtilUpdateProgress;

               Slice_Now;

               IF KeyPressed AND (ReadKey = kEsc) THEN
               BEGIN
                    Aborted:=TRUE;
                    Break; { uit de while }
               END;
          END;

     GaVerder:
          FindNext (Search);
     END; { while }

     FindClose (Search);

     UtilLinkMsgArea:=Aborted; { update result code }

     StatusWindowUpdate;

     { geen berichten in deze area gevonden? }
     IF (List = NIL) THEN
        Exit;

     IF (NOT Aborted) THEN
     BEGIN
          { plaats de huidige status op het scherm }
           IF (NOT (StayQuiet OR NoFullScreen)) THEN
             WriteXY (SXb2,SYb+6,'Linking ');

          Get_Subject (List,Subject_CRC);

          WHILE (NOT Aborted) AND (Subject_CRC <> 0) DO
          BEGIN
               Local:=List;
               VorigMessage:=0;
               CurrentMessage:=Get_Next_Subject (Local,Subject_CRC);
               NextMessage:=0;

               REPEAT
                     NextMessage:=Get_Next_Subject (Local,Subject_CRC);

                     { Update alleen berichten met een link }
                     IF (VorigMessage <> 0) OR (NextMessage <> 0) THEN
                        UpdateMessage (Path+Word2String (CurrentMessage)+'.MSG',
                                       VorigMessage,
                                       NextMessage);

                     VorigMessage:=CurrentMessage;
                     CurrentMessage:=NextMessage;

                     Inc (Status.DezeArea);
                     UtilUpdateProgress;

               UNTIL (Local = NIL);

               Get_Subject (List,Subject_CRC);

               Slice_Now;
               IF KeyPressed AND (ReadKey = kEsc) THEN
               BEGIN
                    Aborted:=TRUE;
                    Break;
               END;

          END; { while }
     END; { if not aborted }

     DeleteList (List);
     UtilLinkMsgArea:=Aborted;
END;


{-------------------------------------------------------------------------}
{ Purge routines                                                          }
{                                                                         }
{ Deze routine verwijdert berichten op datum.                             }
{ Berichten worden verwijderd op de datum waarop een bericht ontvangen    }
{ is.                                                                     }


{--------------------------------------------------------------------------}
{ UtilPurgeAllAreas                                                        }
{                                                                          }
{ Loop alle areas af, en kijkt of er berichten verwijderd kunnen worden    }
{ uit de message bases.                                                    }
{                                                                          }
PROCEDURE UtilPurgeAllAreas (Groups : GroupFlagType);

VAR AreaInfo    : AreaBaseRecord;
    Dummy       : WordLong;
    PurgedAreas,
    CountAreas,
    AantalAreas : WORD;
    Aborted     : BOOLEAN;
    Lp          : BYTE;

BEGIN
     { zet het windowtje op het scherm }
     StatusWindow;
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb+2,SYb,' Purge ');

     { schrijf een berichtje voor de log }
     LogMessage (liTrivial,'Started purging all areas');
     LogGroups (Groups);

     { haal het totaal aantal gebieden }
     AantalAreas:=AreaBaseRecCount;
     Status.AreasToDo:=AantalAreas;
     PurgedAreas:=0;

     GlobalAbort:=FALSE;

     FOR CountAreas:=1 TO AantalAreas DO
     BEGIN
          Slice_Now;

          IF GlobalAbort OR (KeyPressed AND (ReadKey = kEsc)) THEN
          BEGIN
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          { wandel door de AreaBase }
          ReadAreaBaseRecord (CountAreas,AreaInfo);

          Inc (Status.Areas);
          StatusWindowUpdate;

          IF (AreaInfo.AreaName_F <> '') AND
             (AreaInfo.FidoMsgStyle <> NoneType) AND
             (NOT AreaInfo.Deleted) AND
             TestIfGroupCommon (AreaInfo.IsInGroups,Groups) THEN
          BEGIN
               Inc (PurgedAreas);

               Status.DezeArea:=0;
               Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
               StatusWindowUpdate;

               CASE AreaInfo.FidoMsgStyle OF
                    SquishType :
                        Squish_PurgeArea (AreaInfo);

                    FidoMsgType :
                        UtilPackMsgArea (AreaInfo);

                    JamType :
                        Jam_PackArea (AreaInfo);
               END; { case }

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }

     END; { for }

     LogMessage (liTrivial,'Purging finished');

     LogExtraMessage ('Purged '+Longint2String (Status.SavedBytes)+
                      ' bytes in '+Word2String (PurgedAreas)+
                      ' areas.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilPackMsgArea                                                          }
{                                                                          }
{ Deze routine stoomt door een *.MSG area, op zoek naar berichten die      }
{ te oud zijn, en teveel.                                                  }
{ De berichten worden op arrival datum ( bestands stempel in de dos        }
{ directory ) verwijderd.                                                  }
{                                                                          }
PROCEDURE UtilPackMsgArea (AreaRecord : AreaBaseRecord);

CONST MaxFiles = 20000;

TYPE MsgBuf    = ARRAY[1..1] OF WORD;
     MsgBufPtr = ^MsgBuf;

VAR ZoekBestand     : SearchRec;
    ZoekPath        : STRING;
    ZoekLijst       : MsgBufPtr;
    DeleteFile      : FILE;
    DatumTijd       : DateTime;
    TelBerichten,
    SortCounter,
    SortPosCounter  : WORD;
    Error           : ValNop;
    ChangesInSort   : BOOLEAN;
    BestandTijd,
    TotalFiles,
    DeleteFiles,
    KillDate,
    ZoekNummer,
    AantalBerichten : LONGINT;

    {----------------------------------------------------------------------}
    { DeleteMessage                                                        }
    {                                                                      }
    { Routine om *.MSG berichten uit een directory te kunnen verwijderen.  }
    {                                                                      }
    FUNCTION DeleteMessage (BerichtNummer : WORD) : BOOLEAN;

    VAR IORes : BYTE;

    BEGIN
         DeleteMessage:=FALSE;
         Assign (DeleteFile,ZoekPath+Word2String (BerichtNummer)+'.MSG');
         {$I-} Erase (DeleteFile); {$I+} IORes:=IOResult;
         Inc (DeleteFiles);

         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'Error deleting fido '+
                              Word2String (BerichtNummer)+'.MSG message from '+AreaRecord.AreaName_F);
              Exit;
         END;

         DeleteMessage:=TRUE;
     END;


LABEL Verder,
      Einde;

VAR Saved : BYTE;

BEGIN
     { Init }
     TotalFiles:=0;
     DeleteFiles:=0;

     ZoekPath:=DeleteBackSpaces (AreaRecord.FidoMsgPath);
     IF (ZoekPath[Length (ZoekPath)] <> '\') THEN
        ZoekPath:=ZoekPath+'\';

     { Controleer of de directory wel bestaat }
     { RWI 941105: Bugfix. Dit werkt dus niet als het pad al een backslash
                           heeft... laat de search verderop er maar achter
                           komen dat er geen files in staan...
     FindFirst (ZoekPath,$10,ZoekBestand);
     IF (DosError <> 0) THEN
     BEGIN
          LogMessage ('[UtilPackMsgArea] Directory not found: '+ZoekPath);
          Exit;
     END;

     ZoekPath:=ZoekPath+'\';
     }

     { Bereken het tijdstip waarvoor een bericht te oud }
     { word om nog bewaard te worden.                   }
     IF (AreaRecord.FidoMsgAge <> 0) THEN
        KillDate:=GetCurrentUnixTime-SEC_Dag*AreaRecord.FidoMsgAge
     ELSE
         KillDate:=-1;

     { vul het status window }
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+2,'Fido *.MSG ');
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Scanning   ');

     { Reserveer geheugen voor maximaal 20,000 words met adressen. }
     { Een dos directory zal meer toch nooit kunnen adresseren.    }
     { But how about HPFS ????                                     }
     IF (_MaxAvail < (MaxFiles*SizeOf (WORD))) THEN
     BEGIN
          LogMessage (liFatal,'[UtilPurgeArea] Not enough memory, stopping scan');
          Exit;
     END;

     GetMem (ZoekLijst,MaxFiles*SizeOf (WORD));
     PeekMem;

     AantalBerichten:=0;

     { Zoek naar *.MSG bestanden }
     FindFirst (ZoekPath+'*.MSG',saJustFiles,ZoekBestand);
     WHILE (DosError = 0) DO
     BEGIN
          { controleer of het bestand een 99999999.MSG naam heeft }
          Val (Copy (ZoekBestand.Name,1,Pos ('.',ZoekBestand.Name)-1),ZoekNummer,Error);
          IF (Error > 0) THEN
             GOTO Verder;

          { tel de grootte bij het totaal op }
          Inc (TotalFiles);
          Inc (Status.DezeTodo);
          IF ((Status.DezeToDo MOD 25) = 1) THEN
          BEGIN
               UtilUpdateProgress;
               Slice_Now;
          END;

          { controleer of het bericht niet toevallig te oud is }
          UnPackTime (ZoekBestand.Time,DatumTijd);
          BestandTijd:=DosDateTime2UnixDateTime (DatumTijd);

          IF (KillDate <> -1) AND (BestandTijd < KillDate) THEN
          BEGIN
               { verwijder het bericht }
               Status.SavedBytes:=Status.SavedBytes+ZoekBestand.Size; { RWI 960714 }
               DeleteMessage (ZoekNummer);
               GOTO Verder;
          END;

          { Zo niet, voeg het dan toe aan de lijst met te verwerken }
          { berichten.                                              }
          Inc (AantalBerichten);
          ZoekLijst^[AantalBerichten]:=ZoekNummer;

Verder:
          FindNext (ZoekBestand);
     END; { while }

     FindClose (ZoekBestand);

     { Controleer of er wel op aantal gepurged mag worden, }
     { en of er uberhaupt wel berichten zijn.              }
     IF (AreaRecord.FidoMsgLimit <> 0) AND
        (AantalBerichten > AreaRecord.FidoMsgLimit) THEN
     BEGIN
          { Sorteer de lijst met bestanden zodanig dat de laagste nummers }
          { voor komen te liggen.                                         }
        IF (NOT (StayQuiet OR NoFullScreen)) THEN
             WriteXY (SXb2,SYb+6,'Sorting    ');

          FOR SortCounter:=1 TO AantalBerichten DO
          BEGIN
               Status.DezeArea:=SortCounter;
               UtilUpdateProgress;

               ChangesInSort:=FALSE;

               FOR SortPosCounter:=1 TO (AantalBerichten-SortCounter) DO
                   IF (ZoekLijst^[SortPosCounter] > ZoekLijst^[SortPosCounter+1]) THEN
                   BEGIN
                        Slice_Now;
                        ChangesInSort:=TRUE;
                        SwapWords (ZoekLijst^[SortPosCounter],ZoekLijst^[SortPosCounter+1]);
                   END;

               IF (NOT ChangesInSort) THEN
                  Break; { uit de for }
          END;

          { Verwijder nu alle berichten die teveel zijn }
          { Beginnend met de berichten met de laagste   }
          { nummers.                                    }
        IF (NOT (StayQuiet OR NoFullScreen)) THEN
             WriteXY (SXb2,SYb+6,'Purging    ');

          FOR TelBerichten:=1 TO (AantalBerichten-AreaRecord.FidoMsgLimit) DO
              IF (NOT DeleteMessage (ZoekLijst^[TelBerichten])) THEN
                 GOTO Einde;

     END; { if }

     { en laat een regeltje in de log zien }
     IF (TotalFiles <> 0) THEN
        Saved:=Round ((DeleteFiles/TotalFiles)*100)
        {-((DeleteFiles-TotalFiles)*100) DIV TotalFiles}
     ELSE
         Saved:=0;

     LogExtraMessage ('*.MSG  Old:'+AddUpWithPreSpaces (5,Longint2String (TotalFiles))+
                      ' msgs New:'+AddUpWithPreSpaces (5,Longint2String (TotalFiles-DeleteFiles))+
                      ' msgs Saves: '+AddUpWithPreSpaces (3,Byte2String (Saved))+
                      '% in '+AreaRecord.AreaName_F);

     { dit is belangrijk ! }
Einde:
     FreeMem (ZoekLijst,MaxFiles*SizeOf (WORD));
END;


{============================ RENUM =======================================}


{--------------------------------------------------------------------------}
{ UtilRenumberAllMSGAreas                                                  }
{                                                                          }
{ Hoewel voorlopig alleen Fido *.MSG areas van een nieuwe nummering hoeven }
{ voorzien te worden, kan deze routine natuurlijk makkelijk worden         }
{ uitgebreid. (Waffle?)                                                    }
{                                                                          }
PROCEDURE UtilRenumberAllMSGAreas (Groups : GroupFlagType);

VAR AreaInfo : AreaBaseRecord;
    Aborted  : BOOLEAN;
    Lp       : AreaBaseRecordNrType;

BEGIN
     { zet het windowtje op het scherm }
     StatusWindow;
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb+2,SYb,' Renumber *.MSG ');

     { schrijf een berichtje voor de log }
     LogMessage (liTrivial,'Started renumbering all *.MSG areas');
     LogGroups (Groups);

     { kijk of de netmail area een *.MSG Area is }
     IF TestGroupListSame (Groups,AllGroups) AND (Config.FidoNetmailType = FidoMsgType) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='Primary Netmail';
          StatusWindowUpdate;
          UtilRenumberMsgArea (DeleteBackSpaces (Config.FidoNetmailPath));
          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
          END;
     END;

     { kijk of de private mail area een *.MSG Area is }
     (*
     IF (NOT Aborted) AND TestGroupListSame (Groups,AllGroups) AND (Config.PrivmailType = FidoMsgType) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='Private Scan';
          StatusWindowUpdate;
          UtilRenumberMsgArea (DeleteBackSpaces (Config.PrivmailPath));
          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;
     END;
     *)

     Aborted:=FALSE;

     FOR Lp:=1 TO AreaBaseRecCount DO
     BEGIN
          Slice_Now;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          ReadAreaBaseRecord (Lp,AreaInfo);

          IF (NOT AreaInfo.Deleted) AND
             (AreaInfo.FidoMsgStyle = FidoMsgType) AND
             (AreaInfo.AreaName_F <> '') AND
             TestIfGroupCommon (AreaInfo.IsInGroups,Groups) THEN
          BEGIN
               Inc (Status.Areas);
               Status.DezeArea:=0;
               Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
               StatusWindowUpdate;

               UtilRenumberMsgArea (DeleteBackSpaces (AreaInfo.FidoMsgPath));

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }
     END; { for }

     IF Aborted THEN LogMessage (liGeneral,'Renumber aborted')
                ELSE LogMessage (liTrivial,'Renumber completed');

     WITH Status DO
          LogExtraMessage ('Renumbered '+Word2String (Areas)+' areas, containing '+Word2String (TotalMsg)+' messages.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilRenumberMsgArea                                                      }
{                                                                          }
{ Zorgt dat een Fido *.MSG area opnieuw keurig in volgorde wordt geplaatst }
{ Het programma stelt een limiet op 20,000 berichten in een directory      }
{ hoewel dat ver boven de limiet is die Dos aan een directory geeft.       }
{                                                                          }
{ RWI: Deze routine gaat de mist in als de bestandsnamen voorloopnullen    }
{      hebben! (bij het renamen wordt het nummer gereconstrueerd)          }
{                                                                          }
PROCEDURE UtilRenumberMsgArea (DirectoryName : STRING);

CONST MaxFiles = 20000;

TYPE MsgBuf     = ARRAY[1..1] OF WORD;
     MsgBufPtr  = ^MsgBuf;

VAR ZoekBestand     : SearchRec;
    ZoekPath        : STRING;
    ZoekLijst       : MsgBufPtr;
    RenameFile      : FILE;
    Error           : ValNop;
    ZoekNummer,
    SortPosCounter,
    SortCounter,
    AantalBerichten : WORD;
    ChangesInSort   : BOOLEAN;
    IORes           : BYTE;
    LastRead        : WORD;
    IndexIsOpen     : BOOLEAN;
    IndexFile       : FILE;
    IndexCode       : LONGINT;

LABEL CleanUp;

BEGIN
     { controleer of de directory wel bestaat }
     ZoekPath:=DirectoryName;

     { RWI 950121: backslash moet blijven...
     Dec (ZoekPath[0]); { backslash eraf hakken (?) }

     { RWI 941105: Bugfix. Zie purge..
     FindFirst (ZoekPath,$10,ZoekBestand);
     IF (DosError <> 0) THEN
     BEGIN
          LogMessage ('[RenumberMsgArea] Directory not found: '+ZoekPath);
          Exit;
     END;
     ZoekPath:=ZoekPath+'\';
     }

     { probeer geheugen voor de sorteer routine op te vragen }
     IF (_MaxAvail < MaxFiles*SizeOf (WORD)) THEN
     BEGIN
          LogMessage (liFatal,'Not enough free memory for *.MSG renumber');
          Exit;
     END;

     GetMem (ZoekLijst,MaxFiles*SizeOf (WORD));
     PeekMem;

     AantalBerichten:=0;

     { update het status window }
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+2,'Fido *.MSG ');
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Scanning   ');

     FindFirst (Copy (ZoekPath,1,Length (ZoekPath)-1),saDirAndFiles,ZoekBestand);
     IF (DosError <> 0) THEN
     BEGIN
          { directory does not exist }
          FindClose (ZoekBestand);
          GOTO CleanUp;
     END;

     FindClose (ZoekBestand);

     { doorloop de directory en registeer elk bericht }
     FindFirst (ZoekPath+'*.MSG',saJustFiles,ZoekBestand);
     WHILE (DosError = 0) DO
     BEGIN
          { controleer of het bestand een 99999999.MSG naam heeft }
          Val (Copy (ZoekBestand.Name,1,Pos ('.',ZoekBestand.Name)-1),ZoekNummer,Error);

          IF (Error = 0) THEN
          BEGIN
               Inc (AantalBerichten);
               ZoekLijst^[AantalBerichten]:=ZoekNummer;
          END;

          FindNext (ZoekBestand);
     END; { while }

     FindClose (ZoekBestand);

     Slice_Now;

     { Sorteer de lijst met bestanden zodanig dat de laagste nummers }
     { voor komen te liggen.                                         }
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Sorting    ');

     { RWI 960324: Sorteer routine getest en goed gevonden.            }
     {             Werking: pik steeds het hoogste getal op een schuif }
     {             die naar het einde van de array.                    }
     FOR SortCounter:=1 TO AantalBerichten DO
     BEGIN
          ChangesInSort:=FALSE;

          FOR SortPosCounter:=1 TO (AantalBerichten-SortCounter) DO
              IF ZoekLijst^[SortPosCounter] > ZoekLijst^[SortPosCounter+1] THEN
              BEGIN
                   ChangesInSort:=TRUE;
                   SwapWords (ZoekLijst^[SortPosCounter],ZoekLijst^[SortPosCounter+1]);
              END;

          IF (NOT ChangesInSort) THEN
             Break; { uit de for }
     END; { for }

     { RWI 960212: kijk of er een lastread file is en lees die in }
     Assign (RenameFile{misbruik},ZoekPath+'LASTREAD');
     {$I-} Reset (RenameFile,1); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          {$IFDEF LogFileIO}PostOpenF (RenameFile);{$ENDIF}

          { gevonden }
          BlockRead (RenameFile,LastRead,2);

          {$IFDEF LogFileIO}PreCloseF (RenameFile);{$ENDIF}
          Close (RenameFile);
     END;

     { het eigenlijk hernummeren van de berichten }
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Updating');

     { open / create the message index file }
     Assign (IndexFile,DirectoryName+MsgIndexFilename);
     {$I-} Reset (IndexFile,1); {$I+}
     IndexIsOpen:=(IOResult = 0);

     IF IndexIsOpen THEN
     BEGIN
          {$IFDEF LogFileIO}PostOpenF (IndexFile);{$ENDIF}
          PeekFiles;
     END;

     { update de statistieken }
     Status.DezeArea:=AantalBerichten;

     FOR SortCounter:=1 TO AantalBerichten DO
         IF (SortCounter <> ZoekLijst^[SortCounter]) THEN
         BEGIN
              { gat gevonden, rename the file }
              Assign (RenameFile,ZoekPath+Word2String (ZoekLijst^[SortCounter])+'.MSG');
              {$I-} Rename (RenameFile,ZoekPath+Word2String (SortCounter)+'.MSG'); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
              BEGIN
                   LogDiskIOError (IORes,'[RenumberMSGArea] Error renaming '+Word2String (ZoekLijst^[SortCounter]));
                   GOTO CleanUp;
              END;

              { update the index as well - note that we are always  }
              { renaming to a lower number (because of the sort) so }
              { we can overwrite that record without worrying.      }
              { note that not all messages have to be present in the index! }
              IF IndexIsOpen AND (Longint (ZoekLijst^[SortCounter])*4 < FileSize (IndexFile)) THEN
              BEGIN
                   Seek (IndexFile,Longint (ZoekLijst^[SortCounter])*4);
                   BlockRead (IndexFile,IndexCode,4);

                   Seek (IndexFile,Longint (SortCounter)*4);
                   BlockWrite (IndexFile,IndexCode,4);
              END;
         END; { if, for }

     IF IndexIsOpen THEN
     BEGIN
          { truncate the index file at the highest message number }
          IF (FileSize (IndexFile) > Longint (AantalBerichten+1)*4) THEN
          BEGIN
               Seek (IndexFile,Longint (AantalBerichten+1)*4);
               Truncate (IndexFile);
          END;

          Close (IndexFile);
     END;

     { RWI 960331: als er geen berichten in deze area staan, zet LASTREAD }
     {             dan op 1.                                              }
     IF (AantalBerichten = 0) THEN
     BEGIN
          AantalBerichten:=1;
          ZoekLijst^[1]:=LastRead;
     END;

     { zoek de lastread entry op en pak het nieuwe nummer op }
     FOR SortCounter:=1 TO AantalBerichten DO
         IF (ZoekLijst^[SortCounter] = LastRead) AND (LastRead <> SortCounter) THEN
         BEGIN
              { er is een nieuwe lastread }
              LastRead:=SortCounter;

              Assign (RenameFile,ZoekPath+'LASTREAD');
              {$I-} ReWrite (RenameFile,1); {$I+} IORes:=IOResult;
              IF (IORes = 0) THEN
              BEGIN
                   BlockWrite (RenameFile,LastRead,2);
                   {$IFDEF LogFileIO}PreCloseF (RenameFile);{$ENDIF}
                   Close (RenameFile);
                   Slice_Now;
              END;

              Break; { uit de for }
         END; { if,for }

CleanUp:
     { geef geheugen weer terug }
     FreeMem (ZoekLijst,MaxFiles*SizeOf (WORD));
END;


{--------------------------------------------------------------------------}
{ UtilRenumberAllJAMArea                                        RWI 941115 }
{                                                                          }
{ Deze hernummert de berichten van alle JAM gebieden.                      }
{                                                                          }
PROCEDURE UtilRenumberAllJAMAreas (Groups : GroupFlagType);

VAR AreaLp  : AreaBaseRecordNrType;
    AreaRec : AreaBaseRecord;
    Aborted : BOOLEAN;

BEGIN
     { zet het windowtje op het scherm }
     StatusWindow;
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb+2,SYb,' Renumber ');

     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXYC (SXb2,SYb+2,cBoxData,'JAM');
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Renumbering');


     { schrijf een berichtje voor de log }
     LogMessage (liTrivial,'Started renumbering all JAM areas');
     LogGroups (Groups);

     Aborted:=FALSE;

     { netmail }
     IF (Config.FidoNetmailType = JamType) AND TestGroupListSame (Groups,AllGroups) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='NETMAIL';
          StatusWindowUpdate;

          AreaRec.FidoMsgPath:=Config.FidoNetmailPath;
          AreaRec.AreaName_F:='NETMAIL';

          Jam_RenumberArea (AreaRec);

          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
          END;
     END;

     { JAM }
     (*
     IF (NOT Aborted) AND (Config.PrivmailType = JamType) AND TestGroupListSame (Groups,AllGroups) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='NETMAIL';
          StatusWindowUpdate;

          AreaRec.FidoMsgPath:=Config.PrivmailPath;
          AreaRec.AreaName_F:='PRIVATE SCAN';

          JamMsgBase.RenumberArea (AreaRec);

          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;
     END;
     *)

     Status.AreasToDo:=AreaBaseRecCount;

     FOR AreaLp:=1 TO AreaBaseRecCount DO
     BEGIN
          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          Slice_Now;
          ReadAreaBaseRecord (AreaLp,AreaRec);

          IF (NOT AreaRec.Deleted) AND
             (AreaRec.FidoMsgStyle = JamType) AND
             TestIfGroupCommon (AreaRec.IsInGroups,Groups) THEN
          BEGIN
               Inc (Status.Areas);
               Status.DezeArea:=0;
               Status.AreaName:=AreaRec.AreaName_F;
               StatusWindowUpdate;

               Jam_RenumberArea (AreaRec);

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END;

     END; { for }

     IF Aborted THEN LogMessage (liGeneral,'Renumber JAM areas aborted')
                ELSE LogMessage (liTrivial,'Renumber JAM areas completed');

     WITH Status DO
          LogExtraMessage ('Renumbered '+Word2String (Areas)+' JAM areas, containing '+Word2String (TotalMsg)+' messages.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilReIdxAllAreas                                                        }
{                                                                          }
{ Creert nieuwe indexen voor alle gebieden. (Squish + Jam )                }
{                                                                          }
PROCEDURE UtilReIDXAllAreas (Groups : GroupFlagType);

VAR AreaInfo     : AreaBaseRecord;
    IndexedAreas,
    AantalAreas,
    CountAreas   : AreaBaseRecordNrType;

BEGIN
     { zet het link windowtje op het scherm }
     StatusWindow;
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb+2,SYb,' Index ');

     { schrijf een berichtje voor de log }
     LogMessage (liTrivial,'Started indexing all areas');
     LogGroups (Groups);

     IF (NOT (StayQuiet OR NoFullScreen)) THEN
        WriteXY (SXb2,SYb+6,'Rebuilding Index ');

     { Haal het totaal aantal gebieden }
     AantalAreas:=AreaBaseRecCount;
     Status.AreasToDo:=AantalAreas;
     IndexedAreas:=0;

     FOR CountAreas:=1 TO AantalAreas DO
     BEGIN
          Slice_Now;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
              IF (NOT (StayQuiet OR NoFullScreen)) THEN
                  WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          { wandel door de AreaBase }
          ReadAreaBaseRecord (CountAreas,AreaInfo);

          Inc (Status.Areas);
          StatusWindowUpdate;

          IF (AreaInfo.FidoMsgStyle <> NoneType) AND
             (NOT AreaInfo.Deleted) AND
             (AreaInfo.AreaName_F <> '') AND
             TestIfGroupCommon (AreaInfo.IsInGroups,Groups) THEN
          BEGIN
               Inc (IndexedAreas);

               Status.DezeArea:=0;
               Status.AreaName:=AreaInfo.AreaName_F;
               StatusWindowUpdate;

               CASE AreaInfo.FidoMsgStyle OF
                    JamType :
                        BEGIN
                             IF (NOT (StayQuiet OR NoFullScreen)) THEN
                                WriteXY (SXb2,SYb+2,'JAM        ');
                             Jam_ReIndexArea (AreaInfo);
                        END;

                    SquishType :
                        { not needed..
                        BEGIN
                             IF (NOT (StayQuiet OR NoFullScreen)) THEN
                                WriteXY (SXb2,SYb+2,'Squish     ');
                             SquishMsgBase.SquishReIndex (AreaInfo);
                        END;
                        };
               END;

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }

     END; { for }

     LogMessage (liTrivial,'Indexing finished');

     LogExtraMessage ('Indexed '+Word2String (Status.TotalMsg)+
                      ' messages in '+Word2String (IndexedAreas)+
                      ' areas.');

     LogClose;
     WindowPop;
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilPercSaved                                                            }
{                                                                          }
{ Deze routine rekent uit hoeveel procent er bespaard is en geeft dit      }
{ terug in een byte.                                                       }
{                                                                          }
FUNCTION UtilPercSaved (OldSize,NewSize : LONGINT) : BYTE;
BEGIN
     IF (OldSize <> 0) THEN
        UtilPercSaved:=Round ((OldSize-NewSize)/(OldSize/100))
     ELSE
         UtilPercSaved:=0;
END;


VAR ActionAreas : WORD;

{--------------------------------------------------------------------------}
{ SingleMaintenance                                                        }
{                                                                          }
PROCEDURE SingleMaintenance (AreaRecNr : AreaBaseRecordNrType; MOpt : KeyType);
BEGIN
     IF (AreaRecNr < 64000) THEN
        ReadAreaBaseRecord (AreaRecNr,AreaData)
     ELSE BEGIN
          IF (AreaRecNr = 64000) THEN
          BEGIN
               AreaData.AreaName_F:='SYSTEM Primary Netmail Area';
               AreaData.FidoMsgStyle:=Config.FidoNetmailType;
               AreaData.FidoMsgPath:=Config.FidoNetmailPath;
          END;

          IF (AreaRecNr = 64001) THEN
          BEGIN
               AreaData.AreaName_F:='SYSTEM Dupe Area';
               AreaData.FidoMsgStyle:=Config.FidoDupeAreaType;
               AreaData.FidoMsgPath:=Config.FidoDupePath;
          END;

          IF (AreaRecNr = 64002) THEN
          BEGIN
               AreaData.AreaName_F:='SYSTEM Bad Area';
               AreaData.FidoMsgStyle:=Config.FidoBadAreaType;
               AreaData.FidoMsgPath:=Config.FidoBadPath;
          END;
     END;

     Inc (Status.Areas);
     Status.AreaName:=AreaData.AreaName_F;
     Status.DezeArea:=0;

     CASE AreaData.FidoMsgStyle OF
          FidoMsgType : IF (NOT (StayQuiet OR NoFullScreen)) THEN WriteXY (SXb2,SYb+2,'*.MSG ');
          JamType     : IF (NOT (StayQuiet OR NoFullScreen)) THEN WriteXY (SXb2,SYb+2,'JAM   ');
          SquishType  : IF (NOT (StayQuiet OR NoFullScreen)) THEN WriteXY (SXb2,SYb+2,'Squish');
     END; { case }

     StatusWindowUpdate;

     CASE AreaData.FidoMsgStyle OF
          NoneType :
              { doe niets, eventueel loggen };

          FidoMsgType :
              CASE MOpt OF
                   mOpt01: { link }
                       BEGIN
                            IF (NOT (StayQuiet OR NoFullScreen)) THEN
                              WriteXY (SXb2,SYb+6,'Linking    ');
                            LogMessage (liTrivial,'Linking '+AreaData.AreaName_F);
                            UtilLinkMsgArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt02: { purge }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Purging    ');
                            LogMessage (liTrivial,'Purging '+AreaData.AreaName_F);
                            UtilPackMsgArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt03: { renum }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Renumbering');
                            LogMessage (liTrivial,'Renumbering '+AreaData.AreaName_F);
                            UtilRenumberMsgArea (AreaData.FidoMsgPath);
                            Inc (ActionAreas);
                       END;

                   mOpt04: { reindex }
                       { not required }
              END; { case }

          JamType :
              CASE MOpt OF
                   mOpt01: { link }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Linking    ');
                            LogMessage (liTrivial,'Linking '+AreaData.AreaName_F);
                            Jam_LinkArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt02: { purge }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Purging    ');
                            LogMessage (liTrivial,'Purging '+AreaData.AreaName_F);
                            Jam_PackArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt03: { renum }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Renumbering');
                            LogMessage (liTrivial,'Renumbering '+AreaData.AreaName_F);
                            Jam_RenumberArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt04: { reindex }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                              WriteXY (SXb2,SYb+6,'Reindexing ');
                            LogMessage (liTrivial,'Reindexing '+AreaData.AreaName_F);
                            Jam_ReIndexArea (AreaData);
                            Inc (ActionAreas);
                       END;
              END; { case }

          SquishType :
              CASE MOpt OF
                   mOpt01: { link }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Linking    ');
                            LogMessage (liTrivial,'Linking '+AreaData.AreaName_F);
                            Squish_LinkArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt02: { purge }
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Purging    ');
                            LogMessage (liTrivial,'Purging '+AreaData.AreaName_F);
                            Squish_PurgeArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt03: { renum }
                       { not implemented };

                   mOpt04: { reindex }
                       { not needed };
                       {
                       BEGIN
                           IF (NOT (StayQuiet OR NoFullScreen)) THEN
                               WriteXY (SXb2,SYb+6,'Reindexing ');
                            LogMessage (liTrivial,'Reindexing '+AreaData.AreaName_F);
                            SquishMsgBase.SquishReIndex (AreaData);
                            Inc (ActionAreas);
                       END;
                       }
              END; { case }

     END; { msg base style }

     IF (Status.DezeArea > 0) THEN
     BEGIN
          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;
     END;
END;


{--------------------------------------------------------------------------}
{ AreaMaintenanceGroups                                                    }
{                                                                          }
{ Laat de areas zien die in de geselecteerde groepen zitten. Op de daarna  }
{ gekozen groepen kan onderhoud uitgevoerd worden.                         }
{                                                                          }
PROCEDURE AreaMaintenanceGroups (GroupsFilter : GroupFlagType);

    FUNCTION BaseStr (BaseStyle : FidoMsgStyleType) : STRING;
    BEGIN
         CASE BaseStyle OF
              FidoMsgType : BaseStr:=' (*.MSG)';
              JamType     : BaseStr:=' (JAM)';
              SquishType  : BaseStr:=' (Squish)';
         END;
    END;

VAR Quit      : BOOLEAN;
    Keuze     : WORD;
    Lp        : AreaBaseRecordNrType;
    PercDone  : BYTE;
    MOpt      : KeyType;

BEGIN
     Message ('Reading area names  (0%)  ');

     ListTagKeysLine:=' ^F1 Help ^Esc Abort ^Enter Maintenance ^F5~,^F6~,^F7 (Un)Tag';
     ListDefine (2,3,Video.Cols-3,Video.Rows-4,Default,
                 'Areas with message bases for group(s) '+BuildGroupListDesc (GroupsFilter,35),
                 htr_AreaMaintenance_Select);

     ListLowMemLimit:=10000; { dan blijft er nog genoeg voor een group list over }
     FOR Lp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (Lp,AreaData);

          PercDone:=Round ((Lp/AreaBaseRecCount)*100);
          WriteXYC (42,MessageYB,cMessage,
                                   RepChar (PercDone DIV 10,'')+
                                   RepChar (10-(PercDone DIV 10),'')+
                                   ' ('+Byte2String (PercDone)+'%)');

          IF (NOT AreaData.Deleted) AND
             (AreaData.FidoMsgStyle <> NoneType) AND
             (TestIfGroupCommon (AreaData.IsInGroups,GroupsFilter)) THEN
          BEGIN
               ListAddItem (AreaData.AreaName_F+BaseStr (AreaData.FidoMsgStyle),Lp,Bottom{Sorted});
          END;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               ListLowMemLimit:=4096; { restore to default }
               ListErase;
               WindowPop; { message }
               Exit;
          END;
     END; { for }

     ListLowMemLimit:=4096; { restore to default }

     WindowPop; { message }

     ListSortNow;

     { voeg de system areas toe }
     IF (Config.FidoBadAreaType <> NoneType) THEN
        ListAddItem ('SYSTEM Bad Area'+BaseStr (Config.FidoBadAreaType),64002,Top);

     IF (Config.FidoDupeAreaType <> NoneType) THEN
        ListAddItem ('SYSTEM Dupe Area'+BaseStr (Config.FidoDupeAreaType),64001,Top);

     ListAddItem ('SYSTEM Primary Netmail Area'+BaseStr (Config.FidoNetmailType),64000,Top);

     Quit:=FALSE;
     REPEAT
           { als de dummy niet meer nodig is, dan weghalen }
           IF (ListItemCount = 0) THEN { dummy + items }
              ListAddItem ('<no areas configured>',65534,Bottom);

           Keuze:=ListSelect (DoTag,[]);

           ListRemoveItem (65534);

           CASE Key OF

                kRet :
                    BEGIN
                         { menu laten zien }
                         MenuDefine (40,10,'Maintenance options');
                         MenuAddItem ('Link');
                         MenuAddItem ('Purge');
                         MenuAddItem ('Renumber');
                         MenuAddItem ('Reindex');
                         MenuSetHelp (htr_AreaMaintenance_Menu);
                         MenuShow;
                         MOpt:=MenuSelect;
                         MenuErase;

                         { executie }
                         IF (MOpt <> kEsc) THEN
                         BEGIN
                              ListHideWindow;

                              StatusWindow;
                              ActionAreas:=0;

                              CASE MOpt OF
                                   mOpt01 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Link ');
                                            LogExtraMessage ('Starting selective Link');
                                       END;

                                   mOpt02 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Purge ');
                                            LogExtraMessage ('Starting selective Purge');
                                       END;

                                   mOpt03 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Renumber ');
                                            LogExtraMessage ('Starting selective Renumber');
                                       END;

                                   mOpt04 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Reindex ');
                                            LogExtraMessage ('Starting selective Reindex');
                                       END;
                              END; { case }

                              IF (ListTagCount = 0) THEN
                                 SingleMaintenance (Keuze,MOpt)
                              ELSE BEGIN
                                   GlobalAbort:=FALSE;

                                   FOR Lp:=1 TO ListTagCount DO
                                   BEGIN
                                        Slice_Now;

                                        IF GlobalAbort OR (KeyPressed AND (ReadKey = kEsc)) THEN
                                        BEGIN
                                             WriteXY (SXb2,SYb+6,'Aborted  ');
                                             Break; { uit de for/next }
                                        END;

                                        SingleMaintenance (ListGetTaggedItemNr (Lp),MOpt);
                                   END; { for }
                              END;

                              WindowPop; { status window }
                              PopKeysLine;

                              { results logging }
                              CASE MOpt OF
                                   mOpt01 : { link }
                                       LogExtraMessage ('Linked '+Word2String (Status.TotalMsg)+
                                                        ' messages in '+Word2String (ActionAreas)+
                                                        ' areas.');

                                   mOpt02 : { purge }
                                       LogExtraMessage ('Purged '+Longint2String (Status.SavedBytes)+
                                                        ' bytes in '+Word2String (ActionAreas)+
                                                        ' areas.');

                                   mOpt03 : { renumber }
                                       LogExtraMessage ('Renumbered '+Word2String (Status.TotalMsg)+
                                                        ' messages in '+Word2String (ActionAreas)+
                                                        ' areas.');

                                   mOpt04 : { reindexed }
                                       LogExtraMessage ('Reindexed '+Word2String (Status.TotalMsg)+
                                                        ' messages in '+Word2String (ActionAreas)+
                                                        ' areas.');
                              END; { case }

                              LogClose;

                         END; { if not aborted }

                    END; { kRet }

                kEsc :
                    Quit:=TRUE;

           END; { case }

     UNTIL Quit;

     ListErase;
     ListTagKeysLine:=ORG_ListTagKeysLine;
END;


{--------------------------------------------------------------------------}
{ SelectiveAreaMaintenance                                                 }
{                                                                          }
{ Deze routine laat de groepen en dan areas selecteren, waarna onderhoud   }
{ op die area uitgevoerd kan worden: link, purge, renum, re-index.         }
{                                                                          }
PROCEDURE SelectiveAreaMaintenance;

VAR Groups    : GroupFlagType;
    Lp        : AreaBaseRecordNrType;
    Keuze     : WORD;
    GroupData : GroupDescRecord;
    Quit      : BOOLEAN;

BEGIN
     ListDefine (3,3,Video.Cols-10,Video.Rows-4,Default,
                 'Select group(s)',
                 htr_AreaMaintenance_Groups);

     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
     END; { for }

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (DoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : BEGIN
                            ListHideWindow;

                            ResetGroupFlags (Groups);  { no groups selected yet }

                            IF (ListTagCount = 0) THEN
                               AddGroupToGroupList (Groups,Keuze)
                            ELSE BEGIN
                                 Status.AreasTodo:=ListTagCount;

                                 FOR Lp:=1 TO ListTagCount DO
                                     AddGroupToGroupList (Groups,ListGetTaggedItemNr (Lp));
                            END;

                            AreaMaintenanceGroups (Groups);
                       END;
           END; { case }
     UNTIL Quit;

     ListErase;
END;


END.
