{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Copyrigh;

{$I platform.inc}

INTERFACE

PROCEDURE ShowCopyright;
PROCEDURE ShowAboutBox;


IMPLEMENTATION

USES Ramon,
     Globals;

{--------------------------------------------------------------------------}
{ ShowCopyright                                                            }
{                                                                          }
{ This routine shows a window with a copyright message.                    }
{                                                                          }
PROCEDURE ShowCopyright;

CONST Xb = 10;
      Xl = 61;
      Yl = 10;

VAR Yb : XYType;

BEGIN
     Yb:=(Video.Rows DIV 2)-(Yl DIV 2);

     {$IFDEF WtrGate} Yb:=4; {$ENDIF}
     {$IFDEF WtrUtil} Yb:=4; {$ENDIF}
     {$IFDEF WtrTest} Yb:=4; {$ENDIF}

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     WriteXYC (Xb+2,Yb+1,cFieldData,FullProgramName+' v'+FullProgramVersion);

{$IFDEF PRE}
     WriteXY (Xb+2,Yb+4,'This version must be used by Team WaterGate members only!');
     (*
     WriteXY (Xb+2,Yb+3,'This program is a pre release, which means that it might');
     WriteXY (Xb+2,Yb+4,'contain severe problems! No warranties can be given for');
     WriteXY (Xb+2,Yb+5,'proper operation of ANY part of the program. Don''t run');
     WriteXY (Xb+2,Yb+6,'this program unless you send us a bug-report or two.');
     *)
{$ELSE}
{$IFDEF GAMMA}
     WriteXY (Xb+2,Yb+3,'This program is a gamma release, and should be treated');
     WriteXY (Xb+2,Yb+4,'as such. The program should be compatible and stable to');
     WriteXY (Xb+2,Yb+5,'a great extend. You are strongly encouraged to send a');
     WriteXY (Xb+2,Yb+6,'detailed report of any problems to the authors.');
{$ELSE}
     { beta }
     WriteXY (Xb+2,Yb+3,'This program is a beta release, and should be treated');
     WriteXY (Xb+2,Yb+4,'as such. No warranties can be given for proper operation');
     WriteXY (Xb+2,Yb+5,'of some parts of the program. You are strongly encouraged');
     WriteXY (Xb+2,Yb+6,'to send a detailed report of any problems to the authors.');
{$ENDIF (GAMMA) }
{$ENDIF (PRE) }

     WriteXY (Xb+2,Yb+8,'...I should have RTFM stamped on my forehead! =)'); {(Vince)}
     (*
     WriteXY (Xb+2,Yb+8,'...computers can never replace human stupidity');
     WriteXY (Xb+2,Yb+8,'...there is no error like one in your configs');
     WriteXY (Xb+2,Yb+8,'...some functions were built on coffee!');
     WriteXY (Xb+2,Yb+8,'...try typing faster ;)');
     WriteXY (Xb+2,Yb+8,'...another fine OS/2 program');
     WriteXY (Xb+2,Yb+8,'...this program can make coffee');}
     WriteXY (Xb+2,Yb+8,'...as a program evolves, so does its author');}
     WriteXY (Xb+2,Yb+8,'There must be a limit to the number of features..');}
     WriteXY (Xb+2,Yb+8,'...a real program contains errors');}
     WriteXY (Xb+2,Yb+8,'Optimization hinders evolution');}
     WriteXY (Xb+2,Yb+8,'Program: just bugs, organized so the''re no trouble');}
     WriteXY (Xb+2,Yb+8,'B: "Are you threathening me?!!"');}
     WriteXY (Xb+2,Yb+8,'Bugs and undocumented features by BOFH');}
     WriteXY (Xb+2,Yb+8,'Gravity is a habit that is hard to shake off.');}
     *)

     PushKeysLine;
     WriteKeysLine (' Press any key to continue...');

     ReadKey;

     PopKeysLine;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ ShowAboutBox                                                             }
{                                                                          }
{ Deze routine geeft de 'About' message op het scherm en wacht daarna op   }
{ een toetsdruk.                                                           }
{                                                                          }
PROCEDURE ShowAboutBox;

CONST Xb = 24;
      Yl = 12;
      Xl = 34;

VAR Yb : XYType;

BEGIN
     Yb:=(Video.Rows DIV 2)-(Yl DIV 2);

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDrawC (cMessage,Single,Xb,Yb,Xl,Yl);

     WriteXYC (Xb+2,Yb+1,cMessage,FullProgramName);
     WriteXY (Xb+2,Yb+3,'Version: '+FullProgramVersion);
     WriteXY (Xb+2,Yb+4,'Built:   '+CompileDateAndTime);
     WriteXY (Xb+2,Yb+5,'Authors: Ramon van der Winkel');
     WriteXY (Xb+2,Yb+6,'         Anthony Tibbs');
     {
     WriteXY (Xb+2,Yb+6,'         Martijn Dijksterhuis');
     WriteXY (Xb+2,Yb+7,'         Michel van der Laan');
     }

     WriteXY (Xb+2,Yb+7,'Support: support@wsd.wline.se');
     WriteXY (Xb+2,Yb+8,'Web:     www2.sbbs.se/hp/ramon');

     {$IFDEF PLATFORM_WIN32}
     WriteXY (Xb+2,Yb+9,'Mode:    Win-32 VIO');
     {$ENDIF}

     {$IFDEF PLATFORM_OS2}
     WriteXY (Xb+2,Yb+9,'Mode:    OS/2 PM VIO');
     {$ENDIF}

     {$IFDEF PLATFORM_DPMI}
     WriteXY (Xb+2,Yb+9,'Mode:    DPMI');
     {$ENDIF}

     {$IFDEF PLATFORM_OVERLAY}
     WriteXY (Xb+2,Yb+9,'Mode:    Overlay');
     {$ENDIF}

     {$IFDEF PLATFORM_NORMAL}
     WriteXY (Xb+2,Yb+9,'Mode:    Normal');
     {$ENDIF}

     WriteXY (Xb+2,Yb+10,'Memory:  '+Longint2String (_MemAvail DIV 1024)+'Kb free');

     PushKeysLine;
     WriteKeysLine (' Press any key to continue...');
     ReadKey;
     PopKeysLine;
     WindowPop;
END;


END.
