UNIT CleanZ;

{$i platform.inc}

{ this unit holds the code to clean the AreaBase and remove areas  }
{ with unwanted names from group Z. It also deletes message bases, }
{ if any were automatically created.                               }

INTERFACE

PROCEDURE CleanGroupZ (Automagic : BOOLEAN);

VAR ScriptFilename : STRING[79];


IMPLEMENTATION

USES Logs;

TYPE CleanRecord = RECORD
                         AreaNamePtr : ^STRING;
                         RecNr       : WORD;
                   END;

CONST MAXCLEANRECORDS = 65528 DIV SizeOf (CleanRecord); { about 10000 }

TYPE CleanArray = ARRAY[1..MAXCLEANRECORDS] OF CleanRecord;

VAR CAPtr   : ^CleanArray;
    CACount : WORD;

{--------------------------------------------------------------------------}
{ CleanGroupZ                                                              }
{                                                                          }
{ Deze routine leest en verwerkt de opgegeven script file om aan de hand   }
{ daarvan Group Z op te ruimen.                                            }
{                                                                          }
PROCEDURE CleanGroupZ (Automagic : BOOLEAN);

VAR ScriptFile : TEXT;
    IORes      : BYTE;
    Regel      : STRING;
    AreaLp     : AreaBaseRecordNrType;
    AreaRec    : AreaRecord;

BEGIN
     Assign (ScriptFile,ScriptFilename);
     {$I-} Reset (ScriptFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Cannot open the script file: '+ScriptFilename);
          Exit;
     END;

     Message ('Building list of areas that are in group Z...');

     GetMem (CAPtr,SizeOf (CleanArray));
     CACount:=0;

     FOR AreaLp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (AreaLp,AreaRec);

          IF ((AreaRec.IsInGroups AND GROUP_Z) <> 0) THEN
          BEGIN

          END;
     END;


     WindowPop; { message }

     WHILE (NOT Eof (ScriptFile)) DO
     BEGIN
          ReadLn (ScriptFile,Regel);

     END; { while }

     Close (ScriptFile);
END;


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     ScriptFilename:='CLEANZ.TXT';
END.
