{ this file declares the platform compiler directives }
{ based on the defines available in this compiler     }

{ for the user to use:                              }
{                                                   }
{ PLATFORM_DPMI                                     }
{ PLATFORM_OS2                                      }
{ PLATFORM_NORMAL                                   }
{ PLATFORM_OVERLAY                                  }
{ PLATFORM_WIN32                                    }
{                                                   }
{ PLATFORM_OS2_OR_WIN32   - OS/2 or Win32           }
{ PLATFORM_DOS_NOT_DPMI   - Normal or Overlay       }
{ PLATFORM_DOS_ALL        - Normal, Overlay or DPMI }


{ define the main platform defines }

{$IFDEF DPMI}
{$DEFINE PLATFORM_DPMI}
{$ENDIF}

{$IFDEF OS2}
{$DEFINE PLATFORM_OS2}
{$ENDIF}

{$IFDEF WIN32}
{$DEFINE PLATFORM_WIN32}
{$ENDIF}

{$IFDEF MSDOS}
{$IFDEF USEOVR}  { must be set in the conditional defines section }
{$DEFINE PLATFORM_OVERLAY}
{$ELSE}
{$DEFINE PLATFORM_NORMAL}
{$ENDIF}
{$ENDIF}

{ check that at least one platform has been defined }

{$IFNDEF PLATFORM_DPMI}
{$IFNDEF PLATFORM_OS2}
{$IFNDEF PLATFORM_WIN32}
{$IFNDEF PLATFORM_NORMAL}
{$IFNDEF PLATFORM_OVERLAY}
## CHECK PLATFORM DEFINES ##
{$ENDIF}
{$ENDIF}
{$ENDIF}
{$ENDIF}
{$ENDIF}


{ make sure not two platforms are defined at the same time }

{$IFDEF PLATFORM_DPMI}
{$IFDEF PLATFORM_OS2}     ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_WIN32}   ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OVERLAY} ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_NORMAL}  ## PLATFORM ERROR ## {$ENDIF}
{$ENDIF}

{$IFDEF PLATFORM_OS2}
{$IFDEF PLATFORM_DPMI}    ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_WIN32}   ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OVERLAY} ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_NORMAL}  ## PLATFORM ERROR ## {$ENDIF}
{$ENDIF}

{$IFDEF PLATFORM_WIN32}
{$IFDEF PLATFORM_DPMI}    ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OS2}     ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OVERLAY} ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_NORMAL}  ## PLATFORM ERROR ## {$ENDIF}
{$ENDIF}

{$IFDEF PLATFORM_OVERLAY}
{$IFDEF PLATFORM_DPMI}    ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OS2}     ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_WIN32}   ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_NORMAL}  ## PLATFORM ERROR ## {$ENDIF}
{$ENDIF}

{$IFDEF PLATFORM_NORMAL}
{$IFDEF PLATFORM_DPMI}    ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OS2}     ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_WIN32}   ## PLATFORM ERROR ## {$ENDIF}
{$IFDEF PLATFORM_OVERLAY} ## PLATFORM ERROR ## {$ENDIF}
{$ENDIF}


{ some additional defines for stuff common between platforms}

{$IFDEF PLATFORM_WIN32}
{$DEFINE PLATFORM_OS2_OR_WIN32}
{$ENDIF}
{$IFDEF PLATFORM_OS2}
{$DEFINE PLATFORM_OS2_OR_WIN32}
{$ENDIF}

{$IFDEF PLATFORM_OS2_OR_WIN32}
{$DEFINE PLATFORM_OS2_WIN32}
{$ENDIF}

{$IFDEF PLATFORM_NORMAL}
{$DEFINE PLATFORM_DOS_NOT_DPMI}
{$ENDIF}
{$IFDEF PLATFORM_OVERLAY}
{$DEFINE PLATFORM_DOS_NOT_DPMI}
{$ENDIF}

{$IFDEF PLATFORM_NORMAL}
{$DEFINE PLATFORM_DOS_ALL}
{$ENDIF}
{$IFDEF PLATFORM_OVERLAY}
{$DEFINE PLATFORM_DOS_ALL}
{$ENDIF}
{$IFDEF PLATFORM_DPMI}
{$DEFINE PLATFORM_DOS_ALL}
{$ENDIF}

{$IFDEF WtrGate}
{$IFDEF PLATFORM_NORMAL}
## PLATFORM_NORMAL SHOULD NOT BE USED ANYMORE FOR WTRGATE.EXE ##
{$ENDIF}
{$ENDIF}

{$IFDEF FPC}
{$PACKRECORDS 1}
{$PACKENUM 1}
{$ENDIF}

{ end of file platform.inc }
