UNIT SeenBy;

{ deze unit bevat alle code om SEEN-BY en PATH regels te bewerken }

INTERFACE

USES Database;

PROCEDURE AddUsToSeenByAndPath (AreaRecNr : AreaBaseRecordNrType;
                                VAR AreaData : AreaBaseRecord);


IMPLEMENTATION

USES Ramon,
     Msgs,
     Logs,
     Cfg;

CONST MAX_NETNODE_PAIRS  = 1000; { total scanned from SEEN-BY and PATH }
                                 { 1000 = 4Kb = Hopefully always avail.  }
      MAX_PATH_PAIRS     = 100;  { max net/node pairs in *all* PATH lines }

TYPE NetNodePair = RECORD
                         Net,Node : WORD;
                   END;

     NetNodePairList = ARRAY[1..16000] OF NetNodePair;

VAR NetNodeCount : WORD;
    NetNodePtr   : ^NetNodePairList;
    PathCount    : WORD;
    PathPtr      : ^NetNodePairList;

    ParkBuffer   : TopRegelRecordPtr;


{--------------------------------------------------------------------------}
{ AddNetNodePair                                                           }
{                                                                          }
{ Deze routine voegt een net/node pair toe aan de NetNode list. Duplicates }
{ worden verwijderd.                                                       }
{                                                                          }
PROCEDURE AddNetNodePair (Net,Node : WORD);

VAR Lp : WORD;

BEGIN
     { kijken of we het node nummer niet al hebben }
     FOR Lp:=1 TO NetNodeCount DO
         IF (NetNodePtr^[Lp].Net = Net) AND (NetNodePtr^[Lp].Node = Node) THEN
            Exit; { duplicate }

     { kijk of er nog ruimte is }
     IF (NetNodeCount = MAX_NETNODE_PAIRS) THEN
     BEGIN
          LogMessage ('Too many net/node pairs in SEEN-BY/PATH *** PLEASE REPORT ***');
          Exit;
     END;

     Inc (NetNodeCount);
     NetNodePtr^[NetNodeCount].Net:=Net;
     NetNodePtr^[NetNodeCount].Node:=Node;
END;


{--------------------------------------------------------------------------}
{ ScanForOurNodeNumbers                                                    }
{                                                                          }
{ Deze routine scant een SEEN-BY of PATH regel op onze node nummers. Dit   }
{ voorkomt dat we die straks toe gaan zitten voegen en naar die users gaan }
{ exporteren.                                                              }
{ Merk op dat AKAs in de FROM zone voor moeten komen.                      }
{                                                                          }
PROCEDURE ScanForOurNodeNumbers (Regel : STRING; KludgeLen : BYTE; StorePath : BOOLEAN);

VAR FromZone : WORD;
    P,PS     : BYTE;
    Part     : STRING[11];
    Net,Node : WORD;
    Nop      : ValNop;
    Lp       : 1..MaxAkas;

LABEL LogBadSB;

BEGIN
     FromZone:=Msg.FromAddr_F.Zone;

     Delete (Regel,1,KludgeLen);

     IF (Regel[Length (Regel)] = #13) THEN
        Delete (Regel,Length (Regel),1);

     IF (Regel[1] = ' ') THEN
        Delete (Regel,1,1);

     P:=Pos ('/',Regel);
     IF (P = 0) THEN
        GOTO LogBadSB;

     PS:=Pos (' ',Regel);
     IF (PS > 0) AND (PS < P) THEN
        GOTO LogBadSB;

     WHILE (Regel <> '') DO
     BEGIN
          P:=Pos (' ',Regel);

          IF (P > 0) THEN
          BEGIN
               Part:=Copy (Regel,1,P-1);
               Delete (Regel,1,P);
          END ELSE
          BEGIN
               Part:=Regel;
               Regel:='';
          END;

          P:=Pos ('/',Part);
          IF (P > 0) THEN
          BEGIN
               Val (Copy (Part,1,P-1),Net,Nop);
               Delete (Part,1,P);
          END;

          Val (Part,Node,Nop);

          AddNetNodePair (Net,Node);

          IF StorePath THEN
             IF (PathCount = MAX_PATH_PAIRS) THEN
                LogMessage ('Too many net/node pairs in PATH *** PLEASE REPORT ***')
             ELSE BEGIN
                  Inc (PathCount);
                  PathPtr^[PathCount].Net:=Net;
                  PathPtr^[PathCount].Node:=Node;
             END;
     END; { while }

     Exit;

LogBadSB:

     LogMessage ('[NetNodeScan] Bad: "'+Regel+'"');
END;


{--------------------------------------------------------------------------}
{ AddSeenByBlockToMessage                                                  }
{                                                                          }
{ Deze routine voegt het blok met SEEN-BYs oplopend gesorteerd toe aan het }
{ bericht.                                                                 }
{ Sticky-net methode wordt gebruikt, maximum regel lengte is 79 tekens.    }
{                                                                          }
PROCEDURE AddSeenByBlockToMessage;

CONST SEENBY_STR = 'SEEN-BY:';

VAR PairStr   : STRING[12];
    Regel     : STRING;
    Ix,Lp     : WORD;
    Net       : WORD;
    DoNet     : BOOLEAN;
    Node      : WORD;
    FoundIX   : WORD;

BEGIN
     Regel:=SEENBY_STR;

     WHILE (NetNodeCount > 0) DO
     BEGIN
          { zoek het laagste net nummer van allemaal }
          Net:=NetNodePtr^[1].Net;
          FOR Lp:=1 TO NetNodeCount DO
              IF (NetNodePtr^[Lp].Net < Net) THEN
                 Net:=NetNodePtr^[Lp].Net;

          DoNet:=TRUE;

          { nu alle net/node pairs met dit net nummer toevoegen }
          REPEAT
                { zoek de laagste node number bij dit net }
                Node:=65535;
                FoundIX:=0; { non-existing }

                FOR Lp:=1 TO NetNodeCount DO
                    IF (NetNodePtr^[Lp].Net = Net) THEN
                       IF (NetNodePtr^[Lp].Node <= Node) THEN
                       BEGIN
                            FoundIX:=Lp;
                            Node:=NetNodePtr^[Lp].Node;
                       END;

                IF (FoundIX <> 0) THEN
                BEGIN
                     { FoundIX wijst nu naar de index met het laagste node nr }
                     { Voeg die toe.                                          }

                     IF DoNet THEN
                     BEGIN
                          { verschillend net nummers }
                          PairStr:=' '+Word2String (NetNodePtr^[FoundIX].Net)+
                                   '/'+Word2String (NetNodePtr^[FoundIX].Node);
                          DoNet:=FALSE;
                     END ELSE
                     BEGIN
                          { zelfde net }
                          PairStr:=' '+Word2String (NetNodePtr^[FoundIX].Node);
                     END;

                     IF (Length (Regel)+Length (PairStr) > 79) THEN
                     BEGIN
                          MsgsAddLineTo (Footer_F,Regel);
                          Regel:=SEENBY_STR+
                                 ' '+Word2String (NetNodePtr^[FoundIX].Net)+
                                 '/'+Word2String (NetNodePtr^[FoundIX].Node);
                     END ELSE
                         Regel:=Regel+PairStr;

                     { FoundIX nu uit de lijst verwijderen }
                     NetNodePtr^[FoundIX]:=NetNodePtr^[NetNodeCount];
                     Dec (NetNodeCount);
                END;

          UNTIL (FoundIX = 0) OR (NetNodeCount = 0);

     END; { while }

     IF (Regel <> SEENBY_STR) THEN
        MsgsAddLineTo (Footer_F,Regel);
END;


{--------------------------------------------------------------------------}
{ AddPathBlockToMessage                                                    }
{                                                                          }
{ Deze routine voegt alle opgeslagen net/node pairs voor de PATH kludges   }
{ toe aan het bericht. PairPtr wijst naar de pairs en PairCount heeft het  }
{ aantal.                                                                  }
{ Sticky-net methode wordt gebruikt, maximum regel lengte is 79 tekens.    }
{                                                                          }
PROCEDURE AddPathBlockToMessage;

CONST PATH_STR = #1'PATH:';

VAR PairStr : STRING[12];
    Regel   : STRING;
    Lp      : WORD;

BEGIN
     Regel:=PATH_STR;

     FOR Lp:=1 TO PathCount DO
     BEGIN
          IF (PairStr = PATH_STR) OR
             (Lp < 2) OR (PathPtr^[Lp].Net <> PathPtr^[Lp-1].Net) THEN
          BEGIN
               { verschillend net nummers }
               PairStr:=' '+Word2String (PathPtr^[Lp].Net)+
                        '/'+Word2String (PathPtr^[Lp].Node);
          END ELSE
          BEGIN
               { zelfde net }
               PairStr:=' '+Word2String (PathPtr^[Lp].Node);
          END;

          IF (Length (Regel)+Length (PairStr) > 79) THEN
          BEGIN
               MsgsAddLineTo (Footer_F,Regel);
               Regel:=PATH_STR;
          END;

          Regel:=Regel+PairStr;
     END; { for }

     IF (Regel <> PATH_STR) THEN
        MsgsAddLineTo (Footer_F,Regel);
END;


{--------------------------------------------------------------------------}
{ AddOurNetNodePairs                                                       }
{                                                                          }
{ Deze routine voegt onze net/node pairs toe aan het SEEN-BY en PATH blok  }
{                                                                          }
PROCEDURE AddOurNetNodePairs (AreaRecNr    : AreaBaseRecordNrType;
                              VAR AreaData : AreaBaseRecord);

VAR Search   : SubscrSearchRecord;
    UserData : UserBaseRecord;
    Lp       : WORD;

BEGIN
     { add us to the PATH line }
     IF (PathCount < MAX_PATH_PAIRS) THEN
     BEGIN
          { don't add dupes }
          IF (PathCount = 0) OR
             (PathPtr^[PathCount].Net <> Config.NodeNrs[AreaData.OriginAka].Net) OR
             (PathPtr^[PathCount].Node <> Config.NodeNrs[AreaData.OriginAka].Node) THEN
          BEGIN
               Inc (PathCount);
               PathPtr^[PathCount].Net:=Config.NodeNrs[AreaData.OriginAka].Net;
               PathPtr^[PathCount].Node:=Config.NodeNrs[AreaData.OriginAka].Node;
          END;
     END;

     { alle aangesloten users doorlopen en als ze al in de SEEN-BY }
     { voorkomen, dan als Exportered markeren, anders toevoegen    }

     GetFirstUserSubscribedToThisArea (AreaData.UserList,Search);

     WHILE Search.Found DO
     BEGIN
          ReadUserBaseRecord (Search.UserBaseRecordNr,UserData);

          IF (UserData.System = _F) AND
             (UserData.Address.Zone = Msg.FromAddr_F.Zone) AND
             (UserData.Address.Point = 0) THEN
          BEGIN
               FOR Lp:=1 TO NetNodeCount DO
                   IF (NetNodePtr^[Lp].Node = UserData.Address.Node) AND
                      (NetNodePtr^[Lp].Net = UserData.Address.Net) THEN
                   BEGIN
                        Exported^[Search.UserBaseRecordNr]:=5; { in SEEN-BY }
                        Break;
                   END;

               { add this node to the seen-by list }
               AddNetNodePair (UserData.Address.Net,UserData.Address.Node);
          END;

          GetNextUserSubscribedToThisArea (Search);
     END; { while }

     { systeem AKAs aan de SEEN-BY toevoegen }
     FOR Lp:=1 TO MaxAkas DO
         IF HasSeenByBit (AreaData.AddSeenByAkas,Lp) THEN
            AddNetNodePair (Config.NodeNrs[Lp].Net,Config.NodeNrs[Lp].Node);
END;


{--------------------------------------------------------------------------}
{ SBP_ScanALine                                                            }
{                                                                          }
{ Deze routine doorloopt een regel op zoek naar SEEN-BY and PATH lines.    }
{                                                                          }
PROCEDURE SBP_ScanALine (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,8) = 'SEEN-BY:') THEN
     BEGIN
          ScanForOurNodeNumbers (Regel,8,FALSE);
          Exit;
     END;

     IF (Copy (Regel,1,6) = #1'PATH:') THEN
     BEGIN
          ScanForOurNodeNumbers (Regel,6,TRUE);
          Exit;
     END;

     { Tear en Origin toevoegen aan Footer_F, rest parkeren totdat we }
     { het SEEN-BY en PATH blok toegevoegd hebben.                    }
     IF (Copy (Regel,1,10) = ' * Origin:') OR (Copy (Regel,1,3) = '---') THEN
        MsgsAddLineToNoEOL (Footer_F,Regel)
     ELSE
         AddToLineBufferNoEOL (ParkBuffer,Regel);
END;


{--------------------------------------------------------------------------}
{ AddUsToSeenByAndPath                                                     }
{                                                                          }
{ Deze routine doorloopt de Footer_F en interpreteert de SEEN-BY and PATH  }
{ kludges. Net/node pairs worden opgeslagen en bekende node nummers worden }
{ als "exported" gemarkeerd. Onz net/node pairs worden daarna toegevoegd   }
{ aan het SEEN-BY blok. Deze wordt sorteert en opnieuw geformateerd en     }
{ nieuwe block wordt toegevoegd aan de Footer_F.                           }
{ Als er geen SEEN-BY of PATH regels zijn, dan maken we nieuwe regels aan. }
{                                                                          }
{ Deze routine wordt aangeroepen als een echomail bericht gedistribueert   }
{ gaat worden. De gegevens van de area waarin dit gebeurd worden           }
{ meegestuurd.                                                             }
{                                                                          }
PROCEDURE AddUsToSeenByAndPath (AreaRecNr : AreaBaseRecordNrType;
                                VAR AreaData : AreaBaseRecord);

VAR LineBuffer : TopRegelRecordPtr;

BEGIN
     IF (Msg.FromAddr_F.Zone = 0) THEN
     BEGIN
          LogMessage ('Update SEEN-BY & PATH: FTN Zone not known! ** PLEASE REPORT **');
          Exit;
     END;

     { tijdelijk geheugen aanvragen om alle gescande net/node pairs in }
     { op te slaan.                                                    }
     GetMem (NetNodePtr,MAX_NETNODE_PAIRS*SizeOf (NetNodePair));
     NetNodeCount:=0; { nog niets gevonden }

     { meer dynamisch geheugen voor PATH lines }
     GetMem (PathPtr,MAX_PATH_PAIRS*SizeOf (NetNodePair));
     PathCount:=0; { nog niets gevonden }

     { ParkBuffer wordt gebruikt om onbekende kludges te parkeren }
     ParkBuffer:=NIL;

     { doorloop alle regels in de footer }
     LineBuffer:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;
     MsgsForEachKill (LineBuffer,SBP_ScanALine);

     { ## hier kan een PATH controle komen ## }

     { nu ons zelf aan de SEEN-BY en PATH blokken toevoegen }
     AddOurNetNodePairs (AreaRecNr,AreaData);

     { ## hier kunnen we net/node pairs uit de SEEN-BY ## }
     { ## halen als ze in de PATH lijst voorkomen.     ## }

     { SEEN-BY en PATH blokken toevoegen }
     AddSeenByBlockToMessage;
     AddPathBlockToMessage;

     { geparkeerde regels toevoegen }
     IF (ParkBuffer <> NIL) THEN
        MoveRegelsToLineBuffer (ParkBuffer,Msg.FooterTop_F);

     { tijdelijk geheugen weer vrijgeven }
     FreeMem (PathPtr,MAX_PATH_PAIRS*SizeOf (NetNodePair));
     FreeMem (NetNodePtr,MAX_NETNODE_PAIRS*SizeOf (NetNodePair));
END;


END.
