{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Routing;

{ Routines om een routing tabel te creeren, te bewerken en om gegevens }
{ eruit te halen.                                                      }

{ History:

MD   31-03-93 Toevoegen van routines aan de 'real version'
RvdW 04-04-93 Alle routing routines hier naartoe verhuisd.
MD   27-06-93 Flink in de routing zitten sleutelen
     08-09-93 Toevoegen van controle op ROUTE-TO adres
     14-11-93 Link gelegt naar michels UUCP routing routines
     11-03-94 BAG file leveranciers worden niet in de routing table
              opgenomen.

RWI 950625  FILTER commando toegevoegd.
}

INTERFACE

USES Database,
     ReadRout,
     DList,
     Msgs;

FUNCTION  FindRoute (AdresTo : FidoAddrType; VAR ToAddr : FidoAddrType) : BYTE;
FUNCTION  GetFIDO_2_UUCP (VAR Adres : STRING) : BOOLEAN;
PROCEDURE MapFido;
FUNCTION  MapFidoCheck : BOOLEAN;
PROCEDURE MapUUCP;
PROCEDURE AddSignature;
FUNCTION  CheckFilter (Name : STRING; VAR NewPath : STRING) : BOOLEAN;
FUNCTION  UsenetSendFile (ToUser : STRING) : BOOLEAN;
FUNCTION  FidoSendFileCheck : BOOLEAN;
FUNCTION  FidoSendFile : BOOLEAN;
FUNCTION  UsenetBounce : BOOLEAN;
FUNCTION  UsenetSaveMessage : BOOLEAN;
FUNCTION  UsenetMailTunnel : BOOLEAN;
FUNCTION  UsenetMapArea : BOOLEAN;
FUNCTION  GetMailTunnelTo (Addr : FidoAddrType) : MailTunnelPtr;
FUNCTION  CheckForcePack (Addr : FidoAddrType) : BOOLEAN;
FUNCTION  IsCustomSkipName (UpName : STRING) : BOOLEAN;

{$IFDEF WtrTest}
PROCEDURE Routing_ListTables;
{$ENDIF (WtrTest)}

CONST MAX_CUSTOMSKIPUSERNAMES = 5;

VAR TestOrigAddr : BOOLEAN;
    NoLocalFlag  : BOOLEAN;

    FirstRouteRecordPtr : RouteRecordPtr;

    FidoMappingList : List;
    UUCPMappingList : List;
    SignatureList   : List;
    FilterList      : List;
    SendFileList    : List;
    SaveFileList    : List;
    BounceList      : List;
    MapAreaList     : List;
    MailTunnelList  : List;
    ForcePackList   : List;

    CustomSkipCount     : 0..MAX_CUSTOMSKIPUSERNAMES;
    CustomSkipUsernames : ARRAY[1..MAX_CUSTOMSKIPUSERNAMES] OF STRING[MaxLenToUser_F];

    Mail2NewsAddress : STRING[MaxLenDomain];

    BBSEmailAreaRecNr,
    BBSNormalAreaRecNr : AreaBaseRecordNrType;
    BBSViaRecNr        : UserBaseRecordNrType;


IMPLEMENTATION

USES Ramon,
     Fido,
     Cfg,
     Logs,
     UseAdres,
     Translat,
     Globals,
     SwapMem,
     Dos,
     AreaBase,
     Usenet,
     UUCPRout,
     Decode,
     UU,
     Charsets;


{--------------------------------------------------------------------------}
{ IsCustomSkipName                                                         }
{                                                                          }
{ Return TRUE if UpName (uppercased, no back spaces) can be found in the   }
{ CustomSkipUserNames array.                                               }
{                                                                          }
FUNCTION IsCustomSkipName (UpName : STRING) : BOOLEAN;

VAR Lp : BYTE;

BEGIN
     IsCustomSkipName:=TRUE;

     FOR Lp:=1 TO CustomSkipCount DO
         IF (UpName = CustomSkipUserNames[Lp]) THEN
            Exit;

     IsCustomSkipName:=FALSE;
END;


{--------------------------------------------------------------------------}
{ MapFido                                                                  }
{                                                                          }
{ Doorloopt de fido mapping lijst, op zoek naar een bericht dat gemapped   }
{ kan worden. Deze routine moet alleen aangeroepen worden voor NETMAIL     }
{ berichten!                                                               }
{                                                                          }
PROCEDURE MapFido;

VAR Tmp    : MapRecordPtr;
    LocStr : EenRegelRecordPtr;
    X      : BYTE;
    XTo,
    XFrom  : FidoAddrType;
    TmpLine: STRING;

LABEL Verder;

BEGIN
     Tmp:=FidoMappingList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (UpCaseString (Msg.ToUser_F) = UpCaseString (Tmp^.LName)) THEN
          BEGIN
               { We hebben een entry gevonden, nu kijken wat ermee moet }
               { gebeuren                                               }
               { Als er een TO_ADDRESS gespecificeerd is, controleer    }
               { dan of die ook overeenkomen                            }
               IF (Tmp^.LFidoAddr.Zone <> 0) THEN
                  IF (NOT FidoCompare (Tmp^.LFidoAddr,Msg.ToAddr_F)) THEN
                     GOTO Verder;

               CASE Tmp^.RType OF
                    1 : BEGIN
                             { Simpel! ;-) Map fido naam naar nieuwe naam }

                             { Maar het wordt vervelend als het TO adres }
                             { niet overeen komt!                        }
                             IF (Tmp^.RFidoAddr.Zone <> 0) AND
                                (NOT FidoOurAdres (Tmp^.RFidoAddr)) THEN
                             BEGIN
                                  IF Config.LogMapApply THEN
                                     LogMessage ('Mapping: "'+Msg.ToUser_F+'"%'+Fido2Str (Msg.ToAddr_F)+' -> "'+
                                                              Tmp^.RName+'"%'+Fido2Str (Tmp^.RFidoAddr));

                                  Msg.ToUser_F:=Tmp^.RName;

                                  { Dump de complete fido header, en creer een nieuwe }
                                  MsgsReleaseLines (Msg.HeaderTop_F);

                                  { RWI 960223: Changed Header_F into Body }
                                  MsgsAddFirstLineTo (Body,'');
                                  MsgsAddFirstLineTo (Body,'Mapped to    : '+Fido2Str (Tmp^.RFidoAddr));
                                  MsgsAddFirstLineTo (Body,'Originaly to : '+Fido2Str (Msg.ToAddr_F));
                                  MsgsAddFirstLineTo (Body,'This message was rerouted at '+Fido2Str (Config.NodeNrs[1]));

                                  Msg.ToAddr_F:=Tmp^.RFidoAddr;

                                  XTo:=Msg.ToAddr_F;
                                  XTo.Point:=0;

                                  XFrom:=Msg.FromAddr_F;
                                  XFrom.Point:=0;

                                  MsgsAddLineTo (Header_F,#1'INTL: '+Fido2Str (XTo)+' '+Fido2Str (XFrom));

                                  IF (Msg.FromAddr_F.Point > 0) THEN
                                     MsgsAddLineTo (Header_F,#1'FMPT '+Word2String (Msg.FromAddr_F.Point));

                                  IF (Msg.ToAddr_F.Point > 0) THEN
                                     MsgsAddLineTo (Header_F,#1'TOPT '+Word2String (Msg.ToAddr_F.Point));
                             END ELSE
                             BEGIN
                                  IF Config.LogMapApply THEN
                                     LogMessage ('Mapping: "'+Msg.ToUser_F+'" -> "'+Tmp^.RName+'"');

                                  Msg.ToUser_F:=Tmp^.RName;
                             END;

                             Break; { uit de while }
                        END; { 1 }

                    3 : BEGIN
                             { Simpel! Plaats een TO: line in de eerste }
                             { regel van het bericht, en stuur het naar }
                             { de gateway.                              }
                             IF Config.LogMapApply THEN
                                LogMessage ('Mapping: "'+Msg.ToUser_F+'"%'+Fido2Str (Msg.ToAddr_F)+' -> '+Tmp^.RName);

                             Msg.ToAddr_F:=Config.NodeNrs[Config.GatewayAKA];
                             Msg.ToUser_F:=Config.GateWayUser;
                             MsgsAddFirstLineTo (Body,'TO: '+Tmp^.RName);

                             Break; { uit de while }
                        END; { 3 }

               END; { case }
          END;

Verder:
          Tmp:=FidoMappingList.GetNextItem;
     END; { while }
END;


{--------------------------------------------------------------------------}
{ MapFidoCheck                                                             }
{                                                                          }
{ Deze routine kijkt of een MAP-FIDO statement van toepassing kan zijn op  }
{ een bericht. Zoja, dan wordt TRUE terug gegeven, anders FALSE.           }
{                                                                          }
FUNCTION MapFidoCheck : BOOLEAN;

VAR Tmp : MapRecordPtr;

LABEL Verder;

BEGIN
     Tmp:=FidoMappingList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (UpCaseString (Msg.ToUser_F) = UpCaseString (Tmp^.LName)) THEN
             IF (Tmp^.RType = 1) OR (Tmp^.RType = 3) THEN
                IF (Tmp^.LFidoAddr.Zone = 0) OR FidoCompare (Tmp^.LFidoAddr,Msg.ToAddr_F) THEN
                BEGIN
                     MapFidoCheck:=TRUE;
                     Exit;
                END;

          Tmp:=FidoMappingList.GetNextItem;
     END; { while }

     MapFidoCheck:=FALSE;
END;


(*
{--------------------------------------------------------------------------}
{ DumpMapUUCP                                                              }
{                                                                          }
{ Deze routine dumpt de MAP-UUCP table. Hieruit kunnen de prioriteiten     }
{ gehaald worden.                                                          }
{                                                                          }
PROCEDURE DumpMapUUCP;

    FUNCTION Describe (T : BYTE; Name : MapNameField; Addr : FidoAddrType) : STRING;
    BEGIN
         CASE T OF
              1 : Describe:='"'+Name+'"%'+Fido2Str (Addr);
              2 : Describe:=Name;
              3 : Describe:=Name;
         END; { case }
    END;

VAR MapPtr : MapRecordPtr;
    Line   : STRING;

BEGIN
     LogMessage('--- start of mapping table dump ---');

     MapPtr:=UUCPMappingList.GetFirstItem;

     WHILE (MapPtr <> NIL) DO
     BEGIN
          { negeer mapping statements die alleen voor Fido->Usenet zijn }
          CASE MapPtr^.MapType OF
               UUCP_Map_FU :
                   BEGIN
                        Line:='FU ';
                   END;

               UUCP_MAP_UF :
                   BEGIN
                        Line:='UF ';
                   END;

               UUCP_MAP_Both :
                   BEGIN
                        Line:='<> ';
                   END;

          END; { case }


          Line:=Line+' L='+Describe (MapPtr^.LType,MapPtr^.LName,MapPtr^.LFidoAddr);
          Line:=Line+' R='+Describe (MapPtr^.RType,MapPtr^.RName,MapPtr^.RFidoAddr);
          LogExtraMessage (Line);

          MapPtr:=UUCPMappingList.GetNextItem;
     END;

     LogMessage('--- end of mapping table dump ---');
END;
*)


{--------------------------------------------------------------------------}
{ MapUUCP                                                                  }
{                                                                          }
{ Kijk of we het gevonden TO adres van het UUCP bericht kennen, en het     }
{ kunnen mappen voordat het programma het adres zal gaan verwerken.        }
{                                                                          }
PROCEDURE MapUUCP;

VAR Tmp          : MapRecordPtr;
    LocStr       : EenRegelRecordPtr;
    X            : BYTE;
    TDomainAdr,
    TUser,
    DomainAdr,
    User,
    TmpLine      : STRING;
    TVorm,SVorm  : EForm;
    MapIt        : STRING;

BEGIN
     Tmp:=UUCPMappingList.GetFirstItem;

     MapIt:='Mapping: '+Msg.XqtTo_U+' -> ';

     WHILE (Tmp <> NIL) DO
     BEGIN
          { negeer mapping statements die alleen voor Fido->Usenet zijn }
          IF (Tmp^.MapType = UUCP_Map_FU) THEN
          BEGIN
               Tmp:=UUCPMappingList.GetNextItem; { RWI 291094: bugfix! (was endless loop) }
               Continue;
          END;

          SVorm:=UseAdresParse (Msg.XqtTo_U,DomainAdr,User);

          { als er geen domain adres is, maar alleen een user name, }
          { dan mag die usernaam ook als domain naam gezien worden, }
          { zodat de mapping statements er op werken.               }
          IF (DomainAdr = '') THEN
             DomainAdr:=User;

          { Kan de volgende vormen herkennen en omzetten              }
          {                                                           }
          { martijnd@dijkline.wlink.nl  ---> martijnd@super.link.nl   }
          { martijnd@Dijkline.wlink.nl  ---> super.link.nl            }
          { dijkline.wlink.nl           ---> super.link.nl            }
          { dijkline.wlink.nl           ---> sysop@super.link.nl      }
          { martijnd@dijkline.wlink.nl  ---> "Martijn Dijk"@2:280/802 }
          { dijkline.wlink.nl           ---> 2:280/802                }
          IF (Tmp^.LType = 3) AND (Tmp^.RType IN [2,3]){User+Domain!} THEN
          BEGIN
               TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

               IF (SVorm IN [Lokaal,Domain]) AND
                  (UpCaseString (DomainAdr) = UpCaseString (TDomainAdr)) AND
                  (UpCaseString (TUser) = UpCaseString (User)) THEN
               BEGIN
                    IF (Tmp^.RType = 2) THEN
                       Msg.XqtTo_U:=TUser+'@'+Tmp^.RName
                    ELSE
                        Msg.XqtTo_U:=Tmp^.RName;

                    IF Config.LogMapApply THEN
                       LogMessage (MapIt+Msg.XqtTo_U);

                    Exit;
               END;
          END;

          IF (Tmp^.LType = 2) AND (Tmp^.RType = 3){User+Domain!} THEN
          BEGIN
               TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

               IF (SVorm IN [Lokaal,Domain]) AND
                  (UpCaseString (DomainAdr) = UpCaseString (TDomainAdr)) THEN
               BEGIN
                    Msg.XqtTo_U:=Tmp^.RName;

                    IF Config.LogMapApply THEN
                       LogMessage (MapIt+Msg.XqtTo_U);

                    Exit;
               END;

          END;

          IF (Tmp^.LType = 2) AND (Tmp^.RType = 2){User+Domain!} THEN
          BEGIN
               TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

               IF (SVorm IN [Lokaal,Domain]) AND
                  (UpCaseString (DomainAdr) = UpCaseString (TUser)) THEN
               BEGIN
                    Msg.XqtTo_U:=User+'@'+Tmp^.RName;

                    IF Config.LogMapApply THEN
                       LogMessage (MapIt+Msg.XqtTo_U);

                    Exit;
               END;
          END;

          IF (Tmp^.LType = 3) AND (Tmp^.RType = 1){User@FidoAddr} THEN
          BEGIN
               TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

               IF (SVorm IN [Lokaal,Domain]) AND
                  (UpCaseString (DomainAdr) = UpCaseString (TDomainAdr)) AND
                  ((User <> '') AND (UpCaseString (TUser) = UpCaseString (User))) THEN
               BEGIN
                    IF (Tmp^.RFidoAddr.Zone = 0) THEN
                       Tmp^.RFidoAddr:=Config.NodeNrs[Config.GatewayAKA];

                    IF (Tmp^.RName <> '') THEN
                       Msg.XqtTo_U:=CleanFidoName (Tmp^.RName,TRUE)
                    ELSE
                        Msg.XqtTo_U:=CleanFidoName (TUser,TRUE);

                    Msg.XqtTo_U:=Msg.XqtTo_U+'@'+BuildFidonetInternetAdres (Tmp^.RFidoAddr,'.')+Config.Domains[1];

                    IF Config.LogMapApply THEN
                       LogMessage (MapIt+Msg.XqtTo_U);

                    Exit;
               END;
          END;

          IF (Tmp^.LType = 2) AND (Tmp^.RType = 1){Domain->FidoAddr} THEN
          BEGIN
               IF (UpCaseString (DomainAdr) = UpCaseString (Tmp^.LName)) THEN
               BEGIN
                    IF (Tmp^.RFidoAddr.Zone = 0) THEN
                       Tmp^.RFidoAddr:=Config.NodeNrs[Config.GatewayAKA];

                    IF (Tmp^.RName <> '') THEN
                       Msg.XqtTo_U:=CleanFidoName (Tmp^.RName,TRUE)
                    ELSE
                        Msg.XqtTo_U:=User;

                    Msg.XqtTo_U:=Msg.XqtTo_U+'@'+BuildFidonetInternetAdres (Tmp^.RFidoAddr,'.')+Config.Domains[1];

                    IF Config.LogMapApply THEN
                       LogMessage (MapIt+Msg.XqtTo_U);

                    Exit;
               END;
          END;

          Tmp:=UUCPMappingList.GetNextItem;
     END; { while }
END;


{--------------------------------------------------------------------------}
{ GetFIDO_2_UUCP                                                           }
{                                                                          }
{ Kijkt of er in de routing table aparte addressen zijn gedefinieerd       }
{ die niet de 'standaard' routing moeten krijgen.                          }
{                                                                          }
{ User+FidoAddress          ---------> Full Domain Name                    }
{                                      Domain Name                         }
{ FidoAddress               ---------> Full Domain Name                    }
{                                      Domain Name                         }
{                                                                          }
FUNCTION GetFIDO_2_UUCP (VAR Adres : STRING) : BOOLEAN;

VAR Found,
    Tmp    : MapRecordPtr;

BEGIN
     GetFIDO_2_UUCP:=FALSE;

     Found:=NIL;
     Tmp:=UUCPMappingList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          { negeer commando's die alleen voor Usenet -> Fido zijn bedoeld }
          IF (Tmp^.MapType = UUCP_Map_UF) THEN
          BEGIN
               Tmp:=UUCPMappingList.GetNextItem;
               Continue;
          END;

          { Is dit een type 1 aan de rechterkant ? }
          IF (Tmp^.RType = 1) THEN
          BEGIN
               { Als alleen adres overeenkomt zoek dan verder naar een }
               { betere match, als ook de namen overeenkomen hebben we }
               { gevonden wat we zochten.                              }
               IF FidoCompare (Tmp^.RFidoAddr,Msg.FromAddr_F) THEN
               BEGIN
                    IF (Tmp^.RName = '') THEN
                       Found:=Tmp
                    ELSE
                        IF (UpCaseString (Msg.FromUser_F) = UpCaseString (Tmp^.RName)) THEN
                        BEGIN
                             Found:=Tmp;
                             Break; { uit de while }
                        END;
               END;
          END;

          Tmp:=UUCPMappingList.GetNextItem;
     END; { while }

     IF (Found <> NIL) THEN
     BEGIN
          Adres:=Found^.LName;
          GetFIDO_2_UUCP:=TRUE;
          Exit;
     END;

     { RWI 960313 }
     { Als ie niet gevonden is nu en dit adres is een point adres, }
     { dan zoeken we nog een keer maar nu naar een node adres waar }
     { dit point adres bij hoort en zonder naam aan de R-kant. Dan }
     { wordt die genomen en p#. ervoor gezet.                      }
     { We nemen de eerste de beste match.                          }

     IF (Msg.FromAddr_F.Point = 0) THEN
        Exit;  { heeft geen zin }

     Found:=NIL;
     Tmp:=UUCPMappingList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          { negeer commando's die alleen voor Usenet -> Fido zijn bedoeld }
          IF (Tmp^.MapType = UUCP_Map_UF) THEN
          BEGIN
               Tmp:=UUCPMappingList.GetNextItem;
               Continue;
          END;

          { Is dit een type 1 aan de rechterkant ? }
          IF (Tmp^.RType = 1) AND (Tmp^.RName = '') THEN
          BEGIN
               IF (Tmp^.RFidoAddr.Point = 0) AND
                  (Tmp^.RFidoAddr.Zone = Msg.FromAddr_F.Zone) AND
                  (Tmp^.RFidoAddr.Net = Msg.FromAddr_F.Net) AND
                  (Tmp^.RFidoAddr.Node = Msg.FromAddr_F.Node) THEN
               BEGIN
                    Adres:='p'+Word2String (Msg.FromAddr_F.Point)+'.'+Tmp^.LName;
                    GetFIDO_2_UUCP:=TRUE;
                    Exit;
               END;
          END;

          Tmp:=UUCPMappingList.GetNextItem;
     END; { while }

     { return with FALSE: not found }
END;


{--------------------------------------------------------------------------}
{ AddSignature                                                             }
{                                                                          }
{ Voegt een een 'handtekening' aan een bericht toe, dat door de gateway    }
{ gaat. Dit wordt alleen gedaan als er een voor deze persoon of systeem    }
{ gereserveerd is.                                                         }
{                                                                          }
{ RWI 941127: toevoeging van split regel voor de eigenlijke signature.     }
{                                                                          }
{ RWI 970120: added level checking to allow signatures for 51:51/* etc.    }
{                                                                          }
PROCEDURE AddSignature;

VAR Found,
    Tmp       : SignaturePtr;
    CheckMail : STRING[80];
    CheckName : STRING[80];
    Match     : BOOLEAN;
    Signature : TEXT;
    IORes     : BYTE;

BEGIN
     Found:=NIL;
     CheckMail:=UpCaseString (UsenetReplyAdres);
     CheckName:=UpCaseString (DeleteBackSpaces (Msg.FromUser_F));

     { de laatst overeenkomende wordt genomen }
     { de gebruikers moeten maar sorteren in de route.tdb file }

     Tmp:=SignatureList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
           WITH Tmp^ DO
           BEGIN
                IF (Level = 255) THEN
                BEGIN
                     IF (Pos (Tmp^.UserName,CheckMail) > 0) THEN
                        Found:=Tmp;
                END ELSE
                BEGIN
                     { fido }

                     { see if the addresses match }
                     Match:=TRUE;

                     IF (Level >= 1) AND (Address.Zone <> Msg.FromAddr_F.Zone) THEN
                        Match:=FALSE;

                     IF (Level >= 2) AND (Address.Net <> Msg.FromAddr_F.Net) THEN
                        Match:=FALSE;

                     IF (Level >= 3) AND (Address.Node <> Msg.FromAddr_F.Node) THEN
                        Match:=FALSE;

                     IF (Level >= 4) AND (Address.Point <> Msg.FromAddr_F.Point) THEN
                        Match:=FALSE;

                     IF (UserName <> '') AND (UserName <> CheckName) THEN
                        Match:=FALSE;

                     IF Match THEN
                        { new best so far }
                        Found:=Tmp;
                END;

                Tmp:=SignatureList.GetNextItem;
           END; { with, while }

     { Als we een match gevonden hebben plakken we het tekstfiletje aan }
     { het bericht vast.                                                }
     IF (Found <> NIL) THEN
     BEGIN
          Assign (Signature,Found^.Path);
          {$I-} Reset (Signature); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'Unable to open SIGNATURE file '+Found^.Path);
               Exit;
          END;

          IF Config.LogDebug THEN
             LogMessage ('Adding signature '+Found^.Path);

          { voeg een lege regel toe }
          MsgsAddLineTo (Body,'');

          { voeg een signature separator line aan het bericht toe }
          MsgsAddLineTo (Body,'-- '); { spatie hoort erbij! }

          WHILE (NOT Eof (Signature)) DO
          BEGIN
               {$I-} ReadLn (Signature,CheckName); {$I+}
               IF (IOResult <> 0)  THEN
                  Break; { pech }

               MsgsAddLineTo (Body,CheckName);
          END; { while }

          Close (Signature);
     END; { found signature }
END;


{--------------------------------------------------------------------------}
{ CheckFilter                                                              }
{                                                                          }
{ Deze routine controleert of de opgegeven newsgroup naam door de filters  }
{ toegestaan wordt of niet. Zoja, dan wordt TRUE terug gegeven en het pad  }
{ ingevuld.                                                                }
{                                                                          }
FUNCTION CheckFilter (Name : STRING; VAR NewPath : STRING) : BOOLEAN;

VAR Tmp    : FilterPtr;
    Allow  : BOOLEAN;
    LineNr : WORD;
    Hulp   : STRING[6]; { "Allow" / "Reject" }
    Path   : STRING;

LABEL Einde;

BEGIN
     Name:=UpCaseString (Name);

     Allow:=FALSE; { nog geen regels gevonden die em goedkeurden }
     LineNr:=0;
     Path:='';

     Tmp:=FilterList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (Tmp^.NamePtr^ = '') THEN
          BEGIN
               { special cases: * en !* }
               Allow:=Tmp^.Allow;
               LineNr:=Tmp^.LineNr;
               IF (Tmp^.PathPtr = NIL) THEN
                  Path:=''
               ELSE
                   Path:=Tmp^.PathPtr^;
          END ELSE
              IF (Copy (Name,1,Length (Tmp^.NamePtr^)) = Tmp^.NamePtr^) THEN
              BEGIN
                   { we hebben een match }
                   IF (Length (Name) = Length (Tmp^.NamePtr^)) THEN
                   BEGIN
                        { de naam komt precies overeen. Eens kijken }
                        { wat ze hiervan zeggen.                    }
                        IF (Tmp^.Option = foEXACT) THEN
                        BEGIN
                             { beter dan dit vinden we niet. Geef het }
                             { resultaat meteen terug.                }
                             Allow:=Tmp^.Allow;
                             LineNr:=Tmp^.LineNr;
                             IF (Tmp^.PathPtr = NIL) THEN
                                Path:=''
                             ELSE
                                 Path:=Tmp^.PathPtr^;
                             GOTO Einde;
                        END;

                        { nvt, gewoon ignoren alsof het geen match was
                        IF (Tmp^.Option = foBELOWONLY) THEN
                        }

                        IF (Tmp^.Option = foPLUSBELOW) THEN
                        BEGIN
                             Allow:=Tmp^.Allow;
                             LineNr:=Tmp^.LineNr;
                             IF (Tmp^.PathPtr = NIL) THEN
                                Path:=''
                             ELSE
                                 Path:=Tmp^.PathPtr^;
                        END;

                   END ELSE
                       IF (Tmp^.Option <> foEXACT) THEN
                       BEGIN
                            Allow:=Tmp^.Allow;
                            LineNr:=Tmp^.LineNr;
                            IF (Tmp^.PathPtr = NIL) THEN
                               Path:=''
                            ELSE
                                Path:=Tmp^.PathPtr^;
                       END;
              END;

          Tmp:=FilterList.GetNextItem;
     END; { while }

Einde:
     IF Config.LogCheckFilter THEN
     BEGIN
          IF Allow THEN
             Hulp:='Allow'
          ELSE
              Hulp:='Reject';

          LogMessage (Hulp+'ing '+Name+' (line '+Word2String (LineNr)+')')
     END;

     CheckFilter:=Allow;
     NewPath:=Path;
END;


{--------------------------------------------------------------------------}
{ FindRoute                                                                }
{                                                                          }
{ Zoekt de route dat een netmailtje dat niet voor ons bestemd is moet      }
{ aflopen. Als het routen gelukt is, dan wordt TRUE terug gegeven en bevat }
{ ToAddr het adres waar het naartoe moet. Als het niet gelukt is, om welke }
{ reden dan ook, dan wordt FALSE terug gegeven. ToAddr alleen veranderd    }
{ als 2 terug wordt gegeven.                                               }
{                                                                          }
{ RWI 961006: geeft nieuwe waarden terug:                                  }
{   0: Geen route gevonden (was: FALSE)                                    }
{   1: ForceNoRoute of "geef aan FrontDoor"                                }
{   2: Route gevonden of FD mode en Route-fido met ForcePack destination   }
{                                                                          }
FUNCTION FindRoute (AdresTo : FidoAddrType; VAR ToAddr : FidoAddrType) : BYTE;

VAR ZoekRouteRecordPtr : RouteRecordPtr;
    Level_C            : BYTE;
    DestAddr           : FidoAddrType;

BEGIN
     { Als we in frontdoor mode draaien, mogen we geen berichten routen  }
     { en moet alles in de frontdoor netmail directory geplaatst worden! }

     { RAWI 970508: uitzondering: MailTunnels!                             }
     {              Als de destination van een ROUTE-FIDO een FORCEPACK    }
     {              adres is, dan toch routen ook al draaien we in FD mode }

     IF ForceNoRoute THEN
     BEGIN
          FindRoute:=1; { import }
          ToAddr:=Config.NodeNrs[1];
          Exit;
     END;

     Level_C:=0;
     ZoekRouteRecordPtr:=FirstRouteRecordPtr;

     WHILE (ZoekRouteRecordPtr <> NIL) DO
           WITH ZoekRouteRecordPtr^ DO
           BEGIN
                IF (Level >= Level_C) THEN
                BEGIN
                     IF (Level = 4) THEN
                        IF (MaskFidoAddr.Point = AdresTo.Point) AND
                           (MaskFidoAddr.Node = AdresTo.Node) AND
                           (MaskFidoAddr.Net = AdresTo.Net) AND
                           (MaskFidoAddr.Zone = AdresTo.Zone) THEN
                        BEGIN
                             DestAddr:=ViaFidoAddr;
                             Level_C:=4;
                             FindRoute:=2; { Grootst mogelijk match }
                        END;

                     IF (Level = 3) THEN
                        IF (MaskFidoAddr.Node = AdresTo.Node) AND
                           (MaskFidoAddr.Net = AdresTo.Net) AND
                           (MaskFidoAddr.Zone = AdresTo.Zone) THEN
                        BEGIN
                             DestAddr:=ViaFidoAddr;
                             Level_C:=3;
                             { maar nog wel verder zoeken }
                        END;

                     IF (Level = 2) THEN
                        IF (MaskFidoAddr.Net = AdresTo.Net) AND
                           (MaskFidoAddr.Zone = AdresTo.Zone) THEN
                        BEGIN
                             DestAddr:=ViaFidoAddr;
                             Level_C:=2;
                             { maar nog wel verder zoeken }
                        END;

                     IF (Level = 1) THEN
                        IF (MaskFidoAddr.Zone = AdresTo.Zone) THEN
                        BEGIN
                             DestAddr:=ViaFidoAddr;
                             Level_C:=1;
                             { maar nog wel verder zoeken }
                        END;

                END; { dit level is beter }

                ZoekRouteRecordPtr:=NextRouteRecordPtr;
           END; { with, while }

     IF (Level_C > 0) THEN
     BEGIN
          { route gevonden }
          { als we niet in FrontDoor mode zitten, dan toestaan }
          { anders terug vallen op 1, tenzij de destination forcepack is }

          IF (Config.FidoSystem <> stFrontDoor) OR CheckForcePack (DestAddr) THEN
          BEGIN
               ToAddr:=DestAddr;
               FindRoute:=2;
               Exit;
          END;
     END;

     { geen route gevonden of geen routes gedefinieerd maar FrontDoor }
     { en niet forcepacked route-fido destination.                    }

     { In geval FrontDoor een 1 terug gegeven }
     IF (Config.FidoSystem = stFrontDoor) AND (NOT CheckForcePack (AdresTo)) THEN
        FindRoute:=1
     ELSE
         FindRoute:=0;
END;


{--------------------------------------------------------------------------}
{ UsenetSaveMessage                                                        }
{                                                                          }
{ Deze routine kijkt of het adres in Msg.XqtTo_U geconfigureerd is in de   }
{ ROUTE.TDB file met een SAVE statement. In dat geval wordt het bericht    }
{ naar de opgegeven directory weggeschreven en TRUE terug gegeven. Het     }
{ bericht hoeft dan niet verder geprocessed te worden.                     }
{                                                                          }
FUNCTION UsenetSaveMessage : BOOLEAN;

VAR DumpFile : TEXT;

    {----------------------------------------------------------------------}
    { DumpThis                                                             }
    {                                                                      }
    PROCEDURE DumpThis (EenRegelPtr : EenRegelRecordPtr);

    VAR Regel : STRING;

    BEGIN
         WHILE (EenRegelPtr <> NIL) DO
         BEGIN
              CASE EenRegelPtr^.Waar OF
                   wMem :
                       BEGIN
                            Regel:=EenRegelPtr^.RegelPtr^;
                            EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                       END;

                   wSwapped :
                       BEGIN
                            BlockRead (SwapFile,Regel[0],1);
                            IF (Regel[0] = #0) THEN
                            BEGIN
                                 { einde van het swap blok }
                                 EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                 MsgsNewSeek (EenRegelPtr);
                                 Continue;
                            END;

                            BlockRead (SwapFile,Regel[1],Byte (Regel[0]));
                       END;
              END; { case }

              REPEAT
                    IF (Pos (#13,Regel) = 0) THEN
                    BEGIN
                         Write (DumpFile,Regel);
                         Regel:='';
                    END ELSE
                    BEGIN
                         WriteLn (DumpFile,Copy (Regel,1,Pos (#13,Regel)-1));
                         Delete (Regel,1,Pos (#13,Regel));
                    END;
              UNTIL (Regel = '');

         END; { while }
    END; { DumpThis }

{ UsenetSaveMessage }

VAR Tmp          : SaveFilePtr;
    UpTo_U,
    UpSender_U,
    UpReplyTo_U,
    UpFromUser_U,
    Filename     : STRING;
    Search       : SearchRec;
    IORes        : BYTE;

BEGIN
     UpTo_U:=UpCaseString (Msg.XqtTo_U);
     UpFromUser_U:=UpCaseString (Msg.FromUser_U);
     UpSender_U:=UpCaseString (Msg.Sender_U);
     UpReplyTo_U:=UpCaseString (Msg.ReplyTo_U);

     Tmp:=SaveFileList.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (NOT Tmp^.SaveFrom) THEN
          BEGIN
               IF (Tmp^.EmailAddress = UpTo_U) THEN
               BEGIN
                    UpTo_U:=' for '+Msg.XqtTo_U;
                    Break;
               END;
          END ELSE
          BEGIN
               IF (Pos (Tmp^.EmailAddress,UpReplyTo_U) > 0) THEN
               BEGIN
                    UpTo_U:='FROM for '+Msg.ReplyTo_U;
                    Break;
               END;

               IF (Pos (Tmp^.EmailAddress,UpSender_U) > 0) THEN
               BEGIN
                    UpTo_U:='FROM for '+Msg.Sender_U;
                    Break;
               END;

               IF (Pos (Tmp^.EmailAddress,UpFromUser_U) > 0) THEN
               BEGIN
                    UpTo_U:='FROM for '+Msg.FromUser_U;
                    Break;
               END;
          END;

          Tmp:=SaveFileList.GetNextItem;
     END; { while }

     IF (Tmp = NIL) THEN
     BEGIN
          UsenetSaveMessage:=FALSE; { gewoon verder verwerken }
          Exit; { niet gevonden }
     END;

     UsenetSaveMessage:=TRUE; { niet verder versturen }

     {$IFDEF WtrTest}
     LogMessage ('Mail SAVE'+UpTo_U);
     LogMessage ('Target: Save statement');
     Exit;
     {$ENDIF}

     { schrijf dit bericht nu weg naar een nieuw aan te maken file, }
     { met volgnummers. Probeer een naam en als die al bestaat,     }
     { probeer dan gewoon een andere naam, etc. etc.                }
     REPEAT
           Filename:=Tmp^.Directory+GetFidoPktName;
           FindFirst (Filename,$3F,Search);
     UNTIL (DosError <> 0);

     Assign (DumpFile,Filename);
     {$I-} ReWrite (DumpFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Cannot create SAVE file '+Filename);
          Exit;
     END;

     LogMessage ('Mail SAVE'+UpTo_U+' to '+Filename);

     { aangezien dit alleen vanuit UsenetRouteMail aangeroepen wordt, }
     { hoeven we alleen de Header_U en de Body te dumpen.             }

     DumpThis (Msg.HeaderTop_U^.FirstRegelRecordPtr);
     DumpThis (Msg.BodyTop^.FirstRegelRecordPtr);

     Close (DumpFile);
END;


{--------------------------------------------------------------------------}
{ UsenetMailTunnel                                                         }
{                                                                          }
{ Deze routine kijkt of het opgegeven target adres voorkomt in een van de  }
{ TUNNEL-FROM statements. Zoja, dan wordt de file uitgepakt en in de       }
{ opgegeven directory gezet en TRUE terug gegeven. Het bericht zelf gaat   }
{ verloren. Als er geen hit is, dan wordt FALSE terug gegeven.             }
{                                                                          }
FUNCTION UsenetMailTunnel : BOOLEAN;

VAR Tmp         : MailTunnelPtr;
    EenRegelPtr : EenRegelRecordPtr;
    Regel       : STRING;

BEGIN
     Tmp:=MailTunnelList.GetFirstItem;

     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (Tmp^.FromOrTo = mtFrom) AND (UpCaseString (Tmp^.EMailAddress) = UpCaseString (Msg.XqtTo_U)) THEN
          BEGIN
               { gevonden! }
               LogMessage ('Detected MailTunnel traffic for '+Msg.XqtTo_U);

               UsenetMailTunnel:=TRUE;

               {$IFDEF WtrTest}
               LogMessage ('Target: Tunnel-in statement');
               Exit;
               {$ENDIF}

               IF (Msg.BodyTop <> NIL) THEN
               BEGIN
                    EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;

                    IF SwapIsOpen THEN
                       MsgsNewSeek (EenRegelPtr);

                    ExtractInit (TRUE,Tmp^.ExtractPath,'');

                    WHILE (EenRegelPtr <> NIL) DO
                          ExtractFile (EenRegelPtr,Regel);

                    MsgsAddLineTo (Body,''); { breaks old decoder if not there }

               END ELSE
                   LogExtraMessage ('STRANGE: no body!');

               Exit;
          END;

          Tmp:=MailTunnelList.GetNextItem;
     END;

     UsenetMailTunnel:=FALSE; { niets gevonden }
END;


{--------------------------------------------------------------------------}
{ UsenetMapArea                                                            }
{                                                                          }
{ Deze routine kijkt of Msg.XqtTo_U overeen komt met een van de e-mail     }
{ adressen in MAP-AREA statements. Zoja, dan moet het mailtje omgezet      }
{ worden in een newsje en verspreid worden.                                }
{ AreaData wordt dan gevuld en TRUE terug gegeven.                         }
{ Msg.MapAreaReplyAddrPtr bevat een pointer naar een eventueel geforceerd  }
{ REPLYADDR dat gebruikt moet worden. Kan NIL en kan ^ -> '' zijn.         }
{ RWI 960212.                                                              }
{                                                                          }
FUNCTION UsenetMapArea : BOOLEAN;

VAR Tmp      : MapAreaPtr;
    ZoekAddr : STRING;
    RecNr    : AreaBaseRecordNrType;

BEGIN
     ZoekAddr:=UpCaseString (Msg.XqtTo_U);

     Tmp:=MapAreaList.GetFirstItem;
     WHILE (Tmp <> NIL) AND (Tmp^.EmailAddress <> ZoekAddr) DO
           Tmp:=MapAreaList.GetNextItem;

     UsenetMapArea:=(Tmp <> NIL);

     IF (Tmp <> NIL) THEN
     BEGIN
          Msg.MapAreaReplyAddrPtr:=Addr (Tmp^.ReplyAddr);

          RecNr:=GetAreaBaseRecordNrByIndexValue_F (Tmp^.AreaIndex);
          IF (RecNr = NILRecordNr) THEN
             RecNr:=GetAreaBaseRecordNrByIndexValue_U (Tmp^.AreaIndex);

          IF (RecNr = NILRecordNr) THEN
          BEGIN
               LogMessage ('Cannot find area record for MAP-AREA ('+Msg.XqtTo_U+')');
               UsenetMapArea:=FALSE; { toch nog mislukt }
          END ELSE
          BEGIN
               ReadAreaBaseRecord (RecNr,AreaData);
               IF Config.LogMapApply THEN
                  LogMessage ('Mapping: '+Msg.XqtTo_U+' -> '+AreaData.AreaName_U);
          END;
     END;
END;


{--------------------------------------------------------------------------}
{ UsenetBounce                                                             }
{                                                                          }
{ Deze routine kijkt of het adres of domain in Msg.XqtTo_U in de ROUTE.TDB }
{ file geconfigureerd is. Zoja, dan worden alle berichten daar naartoe     }
{ gebounced.                                                               }
{                                                                          }
FUNCTION UsenetBounce : BOOLEAN;

VAR Tmp : BouncePtr;

    FUNCTION IsMatch (Address : STRING) : BOOLEAN;

    VAR P : BYTE;

    BEGIN
         P:=Pos (Tmp^.EMailAddress,Address);

         IsMatch:=(P = 1) OR
                  ((Tmp^.WildMatch) AND (P > 1)) OR
                  ((P > 1) AND (Address[P-1] IN [' ','<']));
    END;

VAR UpTo_U,
    UpFromUser_U,
    UpSender_U,
    UpReplyTo_U  : STRING;

BEGIN
     UpTo_U:=UpCaseString (Msg.XqtTo_U);
     UpFromUser_U:=UpCaseString (Msg.FromUser_U);
     UpSender_U:=UpCaseString (Msg.Sender_U);
     UpReplyTo_U:=UpCaseString (Msg.ReplyTo_U);

     Tmp:=BounceList.GetFirstItem;

     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (NOT Tmp^.FromBounce) THEN
          BEGIN
               IF IsMatch (UpTo_U) THEN
               BEGIN
                    UpTo_U:=' for '+Msg.XqtTo_U;
                    Break;
               END;
          END ELSE
          BEGIN
               IF IsMatch (UpFromUser_U) THEN
               BEGIN
                    UpTo_U:='FROM for '+Msg.FromUser_U;
                    Break;
               END;

               IF IsMatch (UpSender_U) THEN
               BEGIN
                    UpTo_U:='FROM for '+Msg.Sender_U;
                    Break;
               END;

               IF IsMatch (UpReplyTo_U) THEN
               BEGIN
                    UpTo_U:='FROM for '+Msg.ReplyTo_U;
                    Break;
               END;
          END;

          Tmp:=BounceList.GetNextItem;
     END;

     IF (Tmp = NIL) THEN
     BEGIN
          UsenetBounce:=FALSE; { gewoon verder verwerken }
          Exit; { niet gevonden }
     END;

     LogMessage ('Mail BOUNCE'+UpTo_U);

     {$IFDEF WtrTest}
     LogMessage ('Target: Mail bounce ('+Tmp^.Reason+')');
     Exit;
     {$ENDIF}

     UsenetBounceMail (Tmp^.Reason);

     UsenetBounce:=TRUE; { niet verder verwerken }
END;


{--------------------------------------------------------------------------}
{ UsenetSendFile                                                           }
{                                                                          }
{ Deze routine kijkt of het adres in HulpUser geconfigureerd is in de      }
{ ROUTE.TDB file. Zoja, dan wordt een reactie terug gestuurd met daarin    }
{ de inhoud van de file waarnaar verwezen wordt. Dit moet een textfile     }
{ zijn die bijvoorbeeld een UU-encoded file bevat.                         }
{                                                                          }
FUNCTION UsenetSendFile (ToUser : STRING) : BOOLEAN;

VAR Tmp      : SendFilePtr;
    ZoekAddr : STRING;  { wordt ook gebruikt om de file te lezen!! }

BEGIN
     ZoekAddr:=UpCaseString (ToUser);

     Tmp:=SendFileList.GetFirstItem;
     WHILE (Tmp <> NIL) AND (Tmp^.UserName <> ZoekAddr) DO
           Tmp:=SendFileList.GetNextItem;

     IF (Tmp = NIL) THEN
     BEGIN
          UsenetSendFile:=FALSE; { gewoon verwerken }
          Exit;
     END;

     LogMessage ('SEND(TEXT)FILE ('+ToUser+') to '+UsenetReplyAdres);

{$IFDEF WtrTest}
     LogMessage ('Target: Sendfile');
     Exit;
{$ELSE}

     UsenetBuildMail (UsenetReplyAdres,'infoserver','Info Server','Automatic reply: '+ToUser);

     IF (NOT TestIfExist (Tmp^.FilePath)) THEN
     BEGIN
          LogMessage ('SENDFILE: cannot access '+Tmp^.FilePath);
          MsgsAddLineTo (Body,'Cannot access the requested data at this moment');
          MsgsAddLineTo (Body,'Please try again later.');
     END ELSE
         XX_FileToBody (Tmp^.FilePath,TRUE{suppress info},Tmp^.ForceText);

     FtnBodyToMime;
     AddStandardMimeHeaders;

     UsenetRouteMail;

     UsenetSendFile:=TRUE; { bericht verder niet verwerken }
{$ENDIF (!WtrTest)}
END;


{--------------------------------------------------------------------------}
{ FidoSendFileCheck                                                        }
{                                                                          }
{ Deze routine kijkt of de geaddresserde van het in geheugen aanwezige     }
{ netmailtje in een sendfile te vinden is. Zoja, dan wordt TRUE terug      }
{ gegeven.                                                                 }
{                                                                          }
FUNCTION FidoSendFileCheck : BOOLEAN;

VAR Tmp       : SendFilePtr;
    ZoekAddr  : STRING;

BEGIN
     ZoekAddr:=UpCaseString (Msg.ToUser_F);

     Tmp:=SendFileList.GetFirstItem;
     WHILE (Tmp <> NIL) AND (Tmp^.UserName <> ZoekAddr) DO
           Tmp:=SendFileList.GetNextItem;

     FidoSendFileCheck:=(Tmp <> NIL);  { TRUE = gevonden }
END;


{--------------------------------------------------------------------------}
{ FidoSendFile                                                             }
{                                                                          }
{ Deze routine kijkt of de user in Msg.ToUser_F geconfigureerd is in de    }
{ ROUTE.TDB file. Zoja, dan wordt een reactie terug gestuurd met daarin    }
{ de inhoud van de file waarnaar verwezen wordt. Dit moet een textfile     }
{ zijn die bijvoorbeeld een UU-encoded file bevat.                         }
{                                                                          }
{ Merk op dat deze routine alleen aangeroepen mag worden als Msg.ToAddr_F  }
{ een systeem AKA is!!                                                     }
{                                                                          }
FUNCTION FidoSendFile : BOOLEAN;

VAR Tmp       : SendFilePtr;
    ZoekAddr  : STRING; { wordt ook gebruikt om de file te lezen!! }
    MatchAddr : FidoAddrType;

BEGIN
     ZoekAddr:=UpCaseString (Msg.ToUser_F);

     Tmp:=SendFileList.GetFirstItem;
     WHILE (Tmp <> NIL) AND (Tmp^.UserName <> ZoekAddr) DO
           Tmp:=SendFileList.GetNextItem;

     IF (Tmp = NIL) THEN
     BEGIN
          FidoSendFile:=FALSE; { gewoon verwerken }
          Exit;
     END;

{$IFDEF WtrTest}
     LogMessage ('Target: Sendfile');
     FidoSendFile:=TRUE;
     Exit;
{$ELSE}

     FidoMatchAdres (Msg.ToAddr_F,MatchAddr);

     IF (Msg.ReplyEMail <> '') AND (Msg.ReplyUser <> '') THEN
     BEGIN
          LogMessage ('SENDFILE ('+Msg.ToUser_F+') to '+Msg.ReplyEmail+' via "'+Msg.ReplyUser+'"%'+Fido2Str (Msg.ReplyAKA));
          ZoekAddr:=Msg.ReplyEMail; { backup, voordat ie leeg gemaakt wordt }
          FidoBuildNetmail (TRUE,MatchAddr,Msg.ReplyAKA,'InfoServer',Msg.ReplyUser,'Automatic reply: '+Msg.ToUser_F);
          MsgsAddFirstLineTo (Body,'To: '+ZoekAddr);
     END ELSE
     BEGIN
          LogMessage ('SENDFILE ('+Msg.ToUser_F+') to "'+Msg.FromUser_F+'"%'+Fido2Str (Msg.FromAddr_F));
          FidoBuildNetmail (TRUE,MatchAddr,Msg.FromAddr_F,'InfoServer',Msg.FromUser_F,'Automatic reply: '+Msg.ToUser_F);
     END;

     IF (NOT TestIfExist (Tmp^.FilePath)) THEN
     BEGIN
          LogMessage ('SENDFILE: cannot access '+Tmp^.FilePath);
          MsgsAddLineTo (Body,'Cannot access the requested data at this moment');
          MsgsAddLineTo (Body,'Please try again later.');
     END ELSE
         XX_FileToBody (Tmp^.FilePath,TRUE{suppress info},Tmp^.ForceText);

     FidoRouteNetmail;

     FidoSendFile:=TRUE; { bericht verder niet verwerken }
{$ENDIF (WtrTest)}
END;


{--------------------------------------------------------------------------}
{ GetMailTunnelTo                                                          }
{                                                                          }
{ Deze routine doorzoekt de mail tunnel lijst op zoek naar een match voor  }
{ het opgegeven fido adres. Als deze gevonden wordt, dan wordt de pointer  }
{ naar dat record terug gegeven. Anders komt NIL terug.                    }
{                                                                          }
FUNCTION GetMailTunnelTo (Addr : FidoAddrType) : MailTunnelPtr;

VAR Tmp : MailTunnelPtr;

BEGIN
     Tmp:=MailTunnelList.GetFirstItem;

     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (Tmp^.FromOrTo = mtTo) AND (FidoCompare (Addr,Tmp^.FidoAddress)) THEN
             Break; { from the while }

          Tmp:=MailTunnelList.GetNextItem;
     END; { while }

     GetMailTunnelTo:=Tmp;
END;


{--------------------------------------------------------------------------}
{ CheckForcePack                                                           }
{                                                                          }
{ Kijk of het opgegeven adres in de forcepack lijst voorkomt. Zoja, geef   }
{ dan TRUE terug, anders FALSE.                                            }
{                                                                          }
FUNCTION CheckForcePack (Addr : FidoAddrType) : BOOLEAN;

VAR Tmp : ForcePackPtr;

BEGIN
     Tmp:=ForcePackList.GetFirstItem;

     WHILE (Tmp <> NIL) DO
     BEGIN
          IF FidoCompare (Addr,Tmp^.FidoAddr) THEN
          BEGIN
               CheckForcePack:=TRUE;
               Exit;
          END;

          Tmp:=ForcePackList.GetNextItem;
     END; { while }

     CheckForcePack:=FALSE; { niet gevonden }
END;


{$IFDEF WtrTest}
{--------------------------------------------------------------------------}
{ Routing_ListTables                                                       }
{                                                                          }
PROCEDURE Routing_ListTables;

     { list used by FindRoute }
     PROCEDURE Routing_DumpFidoRoutingTable;

     VAR Ptr : RouteRecordPtr;
         Tmp : STRING;

     BEGIN
          ListAddItem ('--- when routing a netmail (best match) ---',0,Bottom);

          Ptr:=FirstRouteRecordPtr;
          WHILE (Ptr <> NIL) DO
          BEGIN
               Tmp:=Word2String (Ptr^.MaskFidoAddr.Zone)+':';

               IF (Ptr^.Level > 1) THEN
                  Tmp:=Tmp+Word2String (Ptr^.MaskFidoAddr.Net)+'/';

               IF (Ptr^.Level > 2) THEN
                  Tmp:=Tmp+Word2String (Ptr^.MaskFidoAddr.Node)+'.';

               IF (Ptr^.Level > 3) THEN
                  Tmp:=Tmp+Word2String (Ptr^.MaskFidoAddr.Point)
               ELSE
                   Tmp:=Tmp+'*';

               ListAddItem ('  Route '+Tmp+' via '+
                               Word2String (Ptr^.ViaFidoAddr.Zone)+
                               ':'+Word2String (Ptr^.ViaFidoAddr.Net)+
                               '/'+Word2String (Ptr^.ViaFidoAddr.Node)+
                               '.'+Word2String (Ptr^.ViaFidoAddr.Point),
                            0,Bottom);

               Ptr:=Ptr^.NextRouteRecordPtr;
          END; { while }

          ListAddItem ('  Exceptions when in FrontDoor mode to do with FORCEPACK',0,Bottom);
          ListAddItem ('--- end ---',0,Bottom);
     END;

     PROCEDURE Routing_DumpMapFidoTable;

     VAR Tmp    : MapRecordPtr;
         LocStr : EenRegelRecordPtr;
         X      : BYTE;
         XTo,
         XFrom  : FidoAddrType;
         TmpLine: STRING;

     LABEL Verder;

     BEGIN
          ListAddItem ('--- before routing a netmail (triggers only one!) ---',0,Bottom);

          Tmp:=FidoMappingList.GetFirstItem;
          WHILE (Tmp <> NIL) DO
          BEGIN
               ListAddItem ('  if ToName = "'+Tmp^.LName+'"',0,Bottom);

               IF (Tmp^.LFidoAddr.Zone <> 0) THEN
                  ListAddItem ('  and ToNode = '+Fido2Str (Tmp^.LFidoAddr),0,Bottom);

               ListAddItem ('  then',0,Bottom);

               CASE Tmp^.RType OF
                    1 : BEGIN
                             ListAddItem ('   change ToName to '+Tmp^.RName,0,Bottom);
                             IF (Tmp^.RFidoAddr.Zone <> 0) THEN
                             BEGIN
                                  ListAddItem ('   if '+Fido2Str (Tmp^.RFidoAddr)+' is not a system AKA then',0,Bottom);
                                  ListAddItem ('      change ToNode to '+Fido2Str (Tmp^.RFidoAddr),0,Bottom);
                                  ListAddItem ('      add re-mapping stuff; redo header',0,Bottom);
                                  ListAddItem ('   endif',0,Bottom);
                             END;
                        END;

                    3 : ListAddItem ('    for gateway, TO: '+Tmp^.RName,0,Bottom);

                    ELSE ListAddItem ('   ignore it',0,Bottom);

               END; { case }

               ListAddItem ('endif',0,Bottom);
               ListAddItem ('',0,Bottom);

               Tmp:=FidoMappingList.GetNextItem;
          END; { while }

          ListAddItem ('--- end ---',0,Bottom);
     END;

     PROCEDURE Routing_DumpMapUucpTable;

     VAR Tmp          : MapRecordPtr;
         LocStr       : EenRegelRecordPtr;
         X            : BYTE;
         TDomainAdr,
         TUser,
         DomainAdr,
         User,
         TmpLine      : STRING;
         TVorm,SVorm  : EForm;

     LABEL Next;

     BEGIN
          ListAddItem ('--- when routing an e-mail (triggers only one!) ---',0,Bottom);

          Tmp:=UUCPMappingList.GetFirstItem;

          WHILE (Tmp <> NIL) DO
          BEGIN
               IF (Tmp^.MapType = UUCP_Map_FU) THEN
               BEGIN
                    Tmp:=UUCPMappingList.GetNextItem;
                    Continue;
               END;

               SVorm:=UseAdresParse (Msg.XqtTo_U,DomainAdr,User);

               IF (DomainAdr = '') THEN
                  DomainAdr:=User;

               IF (Tmp^.LType = 3) AND (Tmp^.RType IN [2,3]) THEN
               BEGIN
                    TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

                    ListAddItem ('  if local or domain style',0,Bottom);
                    ListAddItem ('  and domain='+TDomainAdr,0,Bottom);
                    ListAddItem ('  and user='+TUser,0,Bottom);
                    ListAddItem ('  then',0,Bottom);

                    IF (Tmp^.RType = 2) THEN
                       ListAddItem ('   to='+TUser+'@'+Tmp^.RName,0,Bottom)
                    ELSE
                        ListAddItem ('    to='+Tmp^.RName,0,Bottom);

                    ListAddItem ('  endif',0,Bottom);
                    ListAddItem ('',0,Bottom);
               END;

               IF (Tmp^.LType = 2) AND (Tmp^.RType = 3) THEN
               BEGIN
                    TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

                    ListAddItem ('  if local or domain style',0,Bottom);
                    ListAddItem ('  and domain='+TDomainAdr,0,Bottom);
                    ListAddItem ('  then',0,Bottom);
                    ListAddItem ('      to='+Tmp^.RName,0,Bottom);
                    ListAddItem ('  endif',0,Bottom);
                    ListAddItem ('',0,Bottom);
               END;

               IF (Tmp^.LType = 2) AND (Tmp^.RType = 2) THEN
               BEGIN
                    TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

                    ListAddItem ('  if local or domain style',0,Bottom);
                    ListAddItem ('  and domain='+TUser,0,Bottom);
                    ListAddItem ('  then',0,Bottom);
                    ListAddItem ('      to='+User+'@'+Tmp^.RName,0,Bottom);
                    ListAddItem ('  endif',0,Bottom);
                    ListAddItem ('',0,Bottom);
               END;

               IF (Tmp^.LType = 3) AND (Tmp^.RType = 1) THEN
               BEGIN
                    TVorm:=UseAdresParse (Tmp^.LName,TDomainAdr,TUser);

                    ListAddItem ('  if local or domain style',0,Bottom);
                    ListAddItem ('  and domain='+TDomainAdr,0,Bottom);
                    ListAddItem ('  and user is not empty',0,Bottom);
                    ListAddItem ('  and user='+TUser,0,Bottom);
                    ListAddItem ('  then',0,Bottom);

                    IF (Tmp^.RFidoAddr.Zone = 0) THEN
                       ListAddItem ('    NewToZone=0, so replace ToAddr with '+
                                    Fido2Str (Config.NodeNrs[Config.GatewayAKA]),0,Bottom);

                    IF (Tmp^.RName <> '') THEN
                       ListAddItem ('    to='+CleanFidoName (Tmp^.RName,TRUE)+'@'+
                                    BuildFidonetInternetAdres (Tmp^.RFidoAddr,'.')+Config.Domains[1],0,Bottom)
                    ELSE
                        ListAddItem ('    to='+CleanFidoName (TUser,TRUE)+'@'+
                                     BuildFidonetInternetAdres (Tmp^.RFidoAddr,'.')+Config.Domains[1],0,Bottom);

                    ListAddItem ('  endif',0,Bottom);
                    ListAddItem ('',0,Bottom);
               END;

               IF (Tmp^.LType = 2) AND (Tmp^.RType = 1) THEN
               BEGIN
                    ListAddItem ('  if domain='+Tmp^.LName+' then',0,Bottom);

                    IF (Tmp^.RFidoAddr.Zone = 0) THEN
                       ListAddItem ('    NewToZone=0, so replace with '+Fido2Str (Config.NodeNrs[Config.GatewayAKA]),0,Bottom);

                    IF (Tmp^.RName <> '') THEN
                       ListAddItem ('    '+CleanFidoName (Tmp^.RName,TRUE)+'@'+
                                    BuildFidonetInternetAdres (Tmp^.RFidoAddr,'.')+Config.Domains[1],0,Bottom)
                    ELSE
                        ListAddItem ('    to='+User+'@'+BuildFidonetInternetAdres (Tmp^.RFidoAddr,'.')+Config.Domains[1],
                                     0,Bottom);

                    ListAddItem ('  endif',0,Bottom);
                    ListAddItem ('',0,Bottom);
               END;

               Tmp:=UUCPMappingList.GetNextItem;
          END; { while }

          ListAddItem ('--- end ---',0,Bottom);
     END;

     PROCEDURE Routing_DumpLocalDomainsTable;

     VAR Lp : BYTE;

     BEGIN
          ListAddItem ('--- considered local (when processing an e-mail) ---',0,Bottom);

          FOR Lp:=1 TO MaxDomains DO
              IF (Config.Domains[Lp] <> '') THEN
                 ListAddItem ('   '+Config.Domains[Lp]+' (system domain)',0,Bottom);

          IF (Config.UUCPName <> '') THEN
             ListAddItem ('   '+Config.UUCPName+' (system UUCP name)',0,Bottom);

          ListAddItem ('--- end ---',0,Bottom);
     END;

BEGIN
     Routing_DumpMapFidoTable;
     ListAddItem ('',0,Bottom);

     Routing_DumpFidoRoutingTable;
     ListAddItem ('',0,Bottom);

     Routing_DumpMapUucpTable;
     ListAddItem ('',0,Bottom);

     Routing_DumpLocalDomainsTable;
     ListAddItem ('',0,Bottom);
END;
{$ENDIF (WtrTest)}


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     FirstRouteRecordPtr:=NIL;

     TestOrigAddr:=TRUE;
     NoLocalFlag:=FALSE;
     CustomSkipCount:=0;
     Mail2NewsAddress:='';
     BBSEmailAreaRecNr:=NILRecordNr;
     BBSNormalAreaRecNr:=NILRecordNr;
     BBSViaRecNr:=NILRecordNr;
END.
