{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT ListSrv;

{$IFNDEF SuppressFeatureRequests}
## altijd een confirmatie sturen voordat mensen aangesloten worden ##
{$ENDIF}

{--------------------------------------------------------------------------}
{ ListServer                                                               }
{                                                                          }
{ Nieuwe toevoeging aan de configuratie, een MailList server. Op deze      }
{ manier kunnen mensen op prive newsgroup worden aangesloten zonder dat    }
{ deze meteen landelijk verspreid hoeft te worden.                         }
{ Transport voor fido gaat via netmail, voor UUCP via Mail.                }
{                                                                          }
{ MD 05/01/94 Nog enig verder geknutsel, het programma kan nu ook remote   }
{             user requests afhandelen (aka, een soort Areafix dus)        }
{    07/01/94 Toevoegen van een PackDatabase routine voor WtrUtil          }
{    19/01/94 Toevoegen van support voor List->Area conversie              }
{    12/04/94 Fix linebuffer bug (<> NIL gaf pointer probleem)             }
{                                                                          }
{ RWI 231094 Lijst met aangesloten users: UUCP users kregen hun naam       }
{            afgekapt. Editten van zo'n naam ging niet met FieldEditDirect }
{            en de <enter to edit> entry staat nu helemaal bovenaan.       }
{                                                                          }
{ RWI 950624: grote schoonmaak, nieuwe entrypoints, nieuwe manier van      }
{             distribueren. Nu zou het van alle kanten af en naar alle     }
{             kanten toe (mail,news,netmail,echomail) goed moeten gaan.    }
{             Er wordt nu ook rekening mee gehouden dat als iets in Fido   }
{             formaat aangeleverd wordt, dat het er dan eerst via alle     }
{             Fido kanalen uit moet en daarna pas vertaald moet worden,    }
{             waarbij de body eventueel minder mooi wordt.                 }

INTERFACE

USES Msgs,
     DataBase;

CONST { namen waaronder de listserver bereikbaar is op alle systeem }
      { domain adressen en system aka's.                            }
      ListServer1 = 'LISTSERV';
      ListServer2 = 'LISTSERVER';

TYPE LSType = RECORD
                    ServerNameCRC : LONGINT;
                    AreaNameCRC   : LONGINT;
                    RecNr         : ListServerRecordNrType;
              END;

     LSTypePtr = ^LSType;

VAR ListMainRec   : ListServerRecord;
    ListMainRecNo : ListServerRecordNrType;

{$IFDEF WtrConf}
PROCEDURE EditListServer;
{$ENDIF}
PROCEDURE ListServerTabelInit;
PROCEDURE JunkListServerTable;
FUNCTION  ListServerEchoList : BOOLEAN;
FUNCTION  ListServerSearchName (Name : STRING) : BOOLEAN;
FUNCTION  ListServerSearchNameCorrect (VAR Name : STRING) : BOOLEAN;
FUNCTION  ListServerSearchAreaName (Name : STRING) : BOOLEAN;
PROCEDURE ListServerFidoFix;
PROCEDURE ListServerUsenetFix;
FUNCTION  ListServerIsKnownFidoUser (User : FidoAddrType; Name : STRING) : BOOLEAN;
FUNCTION  ListServerIsKnownGatewayUser (Aka : FidoAddrType; User : STRING; EMail : STRING) : BOOLEAN;
FUNCTION  ListServerIsKnownUsenetUser (User : UsenetUserNameString) : BOOLEAN;

{ distributie routines }
FUNCTION  ListServerDistributeAsNetmailOnly : BOOLEAN;
PROCEDURE ListServerDistributeAsMailOnly;

PROCEDURE ListServerDistributeEchomailToNetMail; { Net(mail) en Mail }
PROCEDURE ListServerDistributeNetMail; { alleen naar de subscribers, echo/news is al gedaan }
PROCEDURE ListServerDistributeMailToAll;
PROCEDURE ListServerDistributeNetmailToAll;

PROCEDURE ListReconfirmCheck;


IMPLEMENTATION

USES Translat,
     Ramon,
     FBuffer,
     UUCPRout,
     Usenet,
     Fido,
     Cfg,
     TextFile,
     Tdb,
     Logs,
     AreaBase,
     Globals,
     SwapMem,
     Language,
     UnixTime,
     DList;

{$IFDEF WtrConf}
CONST AccessEditOptions = 'full|receive-only|post-only';
{$ENDIF}

VAR LSNameTable    : List;
    ListUserRec    : ListServerRecord;
    ListUserRecNo  : ListServerRecordNrType;
    ListUserAccess : ListAccessType;
    {$IFDEF WtrConf}
    ListAKAStr     : STRING[30];
    ListConfirmStr : STRING[3];
    {$ENDIF}

{==========================================================================}
{                      LISTSERVER CONFIG EDIT                              }
{==========================================================================}

{--------------------------------------------------------------------------}
{ DeleteListUserRecord                                                     }
{                                                                          }
{ Zoek een record uit de lijst, en verwijder deze.                         }
{                                                                          }
PROCEDURE DeleteListUserRecord (ListUser : ListServerRecordNrType);

VAR TmpRec2,
    TmpRec   : ListServerRecord;
    TmpPos,
    Position : ListServerRecordNrType;

BEGIN
     { doe alsof we het eerste record van disk lezen }
     Position:=ListMainRecNo;         { We starten op het info record }
     TmpRec:=ListMainRec;             { Copieer info record           }

     { doorloop de lijst met aangesloten users }
     WHILE (TmpRec.NextUser <> NILRecordNr) DO
     BEGIN
          IF (TmpRec.NextUser = ListUser) THEN
          BEGIN
               { de opvolger van dit record is het te verwijderen record }
               TmpPos:=TmpRec.NextUser; { record nummer van te verwijderen record }
               ReadListBaseRecord (TmpPos,TmpRec2); { te deleten record }
               TmpRec.NextUser:=TmpRec2.NextUser; { chain omleggen }
               TmpRec2.NextUser:=NILRecordNr; { alleenstaand maken }
               TmpRec2.Deleted:=TRUE; { en zeggen dat ie gewist is }
               WriteListBaseRecord (TmpPos,TmpRec2); { terugschrijven }

               WriteListbaseRecord (Position,TmpRec); { voorganger updaten }

               { zorgen dat het hoofd record ook op orde is }
               IF (Position = ListMainRecNo) THEN
                  ListMainRec:=TmpRec;

               Exit;
          END;

          Position:=TmpRec.NextUser;
          ReadListBaseRecord (Position,TmpRec);
     END; { while }
END;

{$IFDEF WtrConf}
{--------------------------------------------------------------------------}
{ EditListAKA                                                              }
{                                                                          }
{ Met deze routine kan een van de AKAs uitgekozen worden als List AKA.     }
{                                                                          }
PROCEDURE EditListAKA; FAR;

VAR AkaLp : 1..MaxAkas;
    Line  : STRING[50];
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (3,3,39,Video.Rows-4,Default,'Select a List AKA',1136);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR AkaLp:=1 TO MaxAkas DO
     BEGIN
          Line:=Fido2Str (Config.NodeNrs[AkaLp]);
          IF (Line <> '0') THEN
             ListAddItem (Line,AkaLp,Convert);
     END; { for }

     ListSetCursorOnItem (ListMainRec.ListAka);

     IF (ListItemCount = 0) THEN
        ListAddItem (Line,1,Bottom);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kRet : BEGIN
                            ListMainRec.ListAka:=Keuze;
                            ListAKAStr:=AddUpWithSpaces (30,Fido2Str(Config.NodeNrs[ListMainRec.ListAka]));
                            Quit:=TRUE;
                       END;

                kEsc : Quit:=TRUE;
           END; { case }
     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ AddStandardUserFields                                                    }
{                                                                          }
{ Deze routine definieert de velden die voor alle drie de user types       }
{ hetzelfde zijn.                                                          }
{                                                                          }
PROCEDURE AddStandardUserFields (Xb,Xb2,Yb : XYType);
BEGIN
     WITH ListUserRec DO
     BEGIN
          WriteXY (Xb,Yb,'Access');
          FieldAutoDefineToggles (Xb2,Yb,Access,AccessEditOptions,0);
          FieldSetHelp (0,4014);

          WriteXY (Xb,Yb+1,'Confirm state');
          FieldAutoDefineToggles (Xb2,Yb+1,ConfirmState,'disabled|ok|try1|try2|try3',0);
          FieldSetHelp (0,4018);

          WriteXY (Xb,Yb+3,'Subscribed');
          WriteXY (Xb,Yb+4,'Last confirmed');
          WriteXY (Xb,Yb+5,'Confirm requested');
          WriteXY (Xb,Yb+6,'Last code used');

          WriteXYC (Xb2,Yb+3,cBoxBack,UnixTimeToString (SubscribedDate));
          WriteXY (Xb2,Yb+4,UnixTimeToString (ConfirmedDate));
          WriteXY (Xb2,Yb+5,UnixTimeToString (ConfirmReqDate));
          WriteXY (Xb2,Yb+6,Long2HexString (ConfirmCode));
     END; { with }
END;


{--------------------------------------------------------------------------}
{ EditFidoUser                                                             }
{                                                                          }
{ Edit de velden van een fido user.                                        }
{                                                                          }
PROCEDURE EditFidoUser;

CONST Xb = 5;
      Yb = 10;
      Xl = 72;
      Yl = 11;

VAR TmpAddr : STRING[MaxLenFidoAddrString];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     TmpAddr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (ListUserRec.Address));
     ListUserRec.Name:=AddUpWithSpaces (MaxLenUserName,ListUserRec.Name);

     WriteXY (Xb+2,Yb+1,'Address');
     FieldAutoDefineCheckOne (Xb+20,Yb+1,@TmpAddr,RepChar (MaxLenFidoAddrString,'$'),CheckFidoAddr);
     FieldSetHelp (0,4020);

     WriteXY (Xb+2,Yb+2,'Name');
     FieldAutoDefineOne (Xb+20,Yb+2,@ListUserRec.Name,RepChar (MaxLenUserName,'$'));
     FieldSetHelp (0,4021);

     AddStandardUserFields (Xb+2,Xb+20,Yb+3);

     FieldEdit;

     FidoSplit (DeleteBackSpaces (TmpAddr),ListUserRec.Address);
     ListUserRec.Name:=DeleteFrontAndBackspaces (ListUserRec.Name);

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditUUCPUser                                                             }
{                                                                          }
{ Edit het adres van een usenet user.                                      }
{                                                                          }
PROCEDURE EditUUCPUser;

CONST Xb = 5;
      Yb = 10;
      Xl = 72;
      Yl = 10;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     ListUserRec.Email:=AddUpWithSpaces (MaxLenDomain,ListUserRec.Email);

     WriteXY (Xb+2,Yb+1,'Address');
     FieldAutoDefineOne (Xb+20,Yb+1,@ListUserRec.Email,RepChar (MaxLenDomain,'$'));
     FieldSetHelp (0,4030);

     AddStandardUserFields (Xb+2,Xb+20,Yb+2);

     FieldEdit;

     ListUserRec.Email:=DeleteFrontAndBackSpaces (ListUserRec.Email);

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditGatewayUser                                                          }
{                                                                          }
{ Edit het adres van een gateway user.                                     }
{                                                                          }
PROCEDURE EditGatewayUser;

CONST Xb = 5;
      Yb = 10;
      Xl = 72;
      Yl = 12;

VAR TmpAddr : STRING[MaxLenFidoAddrString];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     TmpAddr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (ListUserRec.GWAddress));
     ListUserRec.GWUser:=AddUpWithSpaces (MaxLenUserName,ListUserRec.GWUser);
     ListUserRec.GWEmail:=AddUpWithSpaces (MaxLenDomain,ListUserRec.GWEmail);

     WriteXY (Xb+2,Yb+1,'E-mail address');
     FieldAutoDefineOne (Xb+20,Yb+1,@ListUserRec.GWEMail,RepChar (MaxLenDomain,'$'));
     FieldSetHelp (0,4250);

     WriteXY (Xb+2,Yb+2,'Gateway user');
     FieldAutoDefineOne (Xb+20,Yb+2,@ListUserRec.GWUser,RepChar (MaxLenUserName,'$'));
     FieldSetHelp (0,4251);

     WriteXY (Xb+2,Yb+3,'Gateway AKA');
     FieldAutoDefineCheckOne (Xb+20,Yb+3,@TmpAddr,RepChar (MaxLenFidoAddrString,'$'),CheckFidoAddr);
     FieldSetHelp (0,4252);

     AddStandardUserFields (Xb+2,Xb+20,Yb+4);

     FieldEdit;

     WITH ListUserRec DO
     BEGIN
          FidoSplit (TmpAddr,GWAddress);
          GWUser:=DeleteFrontAndBackSpaces (GWUser);
          GWEmail:=DeleteFrontAndBackSpaces (GWEmail);
     END;

     FieldPopAll;
     WindowPop;
END;


{ following two functions are used to add items the list of list subscribers }

{----------------------------------------------------------------------}
{ BuildAddOne                                                          }
{                                                                      }
PROCEDURE BuildAddOne (RecNo : ListServerRecordNrType; VAR ListData : ListServerRecord);

VAR AccessStr : STRING[5];

BEGIN
     CASE ListData.Access OF
          laReadWrite :
              AccessStr:=' (rw)';

          laReadOnly :
              AccessStr:=' (ro)';

          laWriteOnly :
              AccessStr:=' (wo)';

          ELSE
              AccessStr:=' (??)';
     END;

     { voeg een entry aan de lijst toe }
     CASE ListData.ListSystem OF
          lstFido :
              ListAddItem (ListData.Name+' at '+Fido2Str (ListData.Address)+AccessStr,
                           RecNo,Sorted);

          lstUUCP :
              ListAddItem (ListData.Email+AccessStr,
                           RecNo,Sorted);

          lstRemoteGateway :
              ListAddItem (ListData.GWEmail+' via '+ListData.GWUser+' at '+Fido2Str (ListData.GWAddress)+AccessStr,
                           RecNo,Sorted);
     END; { case }
END;


{----------------------------------------------------------------------}
{ BuildReadAddOne                                                      }
{                                                                      }
PROCEDURE BuildReadAddOne (RecNo : ListServerRecordNrType);

VAR ListData : ListServerRecord;

BEGIN
     IF (NOT ReadListBaseRecord (RecNo,ListData)) THEN
        Error ('Error reading list server record!')
     ELSE
         BuildAddOne (RecNo,ListData);
END;



{--------------------------------------------------------------------------}
{ ImportFidoList                                                           }
{                                                                          }
{ Haalt een lijst met Fido users van disk om toe te voegen.                }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ ; Rem regel                                                              }
{ 2:280/802.6           Martijn Dijksterhuis                               }
{                                                                          }
PROCEDURE ImportFidoList;

CONST Xb = 9;
      Yb = 17;
      Xl = 64;
      Yl = 6;

VAR Quit    : BOOLEAN;
    Regel   : STRING;
    Path    : STRING[80];
    ImpFile : TEXT;
    FidoStr : FIdoAddrString;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;
     WriteXY (Xb+2,Yb+1,'Path+Filename of the file to import (F3 to pick file)');
     Path:=RepChar (79,' ');

     FieldDefineFileMgr (1,Xb+2,Yb+3,79,60,0,0,@Path,AnyFileMgr);
     FieldSetHelp (1,1503);

     PushKeysLine;
     WriteFieldEditDirectKeysLine;

     Quit:=FALSE;
     REPEAT
           FieldEditDirect;

           Quit:=TRUE;
           IF (Key = kRet) THEN
              IF TestIfExist (Path)  THEN
              BEGIN
                   Assign (ImpFile,Path);
                   {$I-} Reset (ImpFile); {$I+}

                   WHILE (NOT Eof (ImpFile)) DO
                   BEGIN
                        ReadLn (ImpFile,Regel);
                        Regel:=DeleteCTFBS (Regel);

                        IF (Regel = '') THEN
                           Continue;

                        FidoStr:=Copy (Regel,1,Pos (' ',Regel)-1);
                        Delete (Regel,1,Pos (' ',Regel));

                        WITH ListUserRec DO
                        BEGIN
                             Deleted:=FALSE;
                             ListSystem:=lstFido;
                             NextUser:=NILRecordNr;
                             FidoSplit (FidoStr,Address);
                             Name:=DeleteFrontSpaces (Regel);
                             Access:=ListMainRec.DefaultAccess;
                             SubscribedDate:=GetCurrentUnixTime;
                             ConfirmedDate:=SubscribedDate;  { trigger in ConfirmInterval days }
                             ConfirmReqDate:=0;
                             ConfirmState:=lcOk;
                             ConfirmCode:=0;
                        END; { with }

                        AddUserToList (ListMainRecNo,ListMainRec,ListUserRec);
                        BuildReadAddOne (ListMainRec.NextUser);
                   END; { while not eof }

                   Close (ImpFile);
              END ELSE
              BEGIN
                   Error ('File does not exist');
                   Quit:=FALSE;
              END;
     UNTIL Quit;

     FieldPopAll;
     PopKeysLine;
     WindowPop; { path window }
END;


{---------------------------------------------------------------------------}
{ ImportUsenetList                                                          }
{                                                                           }
{ Deze routine importeert een lijst met adresses voor de list server base.  }
{ Format: op iedere regel een compleet user adres, commentaar regels met    }
{ puntkomma beginnen en lege regels toegestaan.                             }
{                                                                           }
PROCEDURE ImportUsenetList;

CONST Xb = 9;
      Yb = 17;
      Xl = 64;
      Yl = 6;

VAR Quit    : BOOLEAN;
    Regel   : STRING;
    Path    : STRING[80];
    ImpFile : TEXT;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WriteXY (Xb+2,Yb+1,'Path+Filename of the file to import (F3 to pick file)');
     Path:=RepChar (79,' ');

     FieldDefineFileMgr (1,Xb+2,Yb+3,79,60,0,0,@Path,AnyFileMgr);
     FieldSetHelp (1,1504);

     PushKeysLine;
     WriteFieldEditDirectKeysLine;

     Quit:=FALSE;
     REPEAT
           FieldEditDirect;

           Quit:=TRUE;
           IF (Key = kRet) THEN
              IF TestIfExist (Path)  THEN
              BEGIN
                   Assign (ImpFile,Path);
                   {$I-} Reset (ImpFile); {$I+}

                   WHILE (NOT Eof (ImpFile)) DO
                   BEGIN
                        ReadLn (ImpFile,Regel);
                        Regel:=DeleteCTFBS (Regel);

                        IF (Regel = '') THEN
                           Continue;

                        WITH ListUserRec DO
                        BEGIN
                             Deleted:=FALSE;
                             ListSystem:=lstUUCP;
                             NextUser:=NILRecordNr;
                             Email:=Regel;
                             Access:=ListMainRec.DefaultAccess;
                             SubscribedDate:=GetCurrentUnixTime;
                             ConfirmedDate:=SubscribedDate;  { trigger in ConfirmInterval days }
                             ConfirmReqDate:=0;
                             ConfirmState:=lcOk;
                             ConfirmCode:=0;
                        END; { with }

                        AddUserToList (ListMainRecNo,ListMainRec,ListUserRec);
                        BuildReadAddOne (ListMainRec.NextUser);

                   END; { while not eof }

                   Close (ImpFile);
              END ELSE
              BEGIN
                   Error ('File does not exist');
                   Quit:=FALSE;
              END;
     UNTIL Quit;

     FieldPopAll;
     PopKeysLine;
     WindowPop; { path window }
END;


{--------------------------------------------------------------------------}
{ EditNewUser                                                              }
{                                                                          }
FUNCTION EditNewUser : WORD;

VAR MenuKeuze : KeyType;

BEGIN
     EditNewUser:=0; { geen }

     MenuDefine (6,15,'Add Subscriber');
     MenuSetHelp (1502);
     MenuAddItem ('Add subscriber with netmail address');
     MenuAddItem ('Add subscriber with e-mail address');
     MenuAddItem ('Add subscriber with e-mail address behind remote FTN<->RFC gateway');
     MenuAddItem ('Import list of netmail addresses');
     MenuAddItem ('Import list of e-mail addresses');
     MenuShow;

     MenuKeuze:=MenuSelect;
     MenuErase;

     WITH ListUserRec DO
     BEGIN
          Deleted:=FALSE;
          NextUser:=NILRecordNr; { einde van de keten }
          Access:=ListMainRec.DefaultAccess;
          SubscribedDate:=GetCurrentUnixTime;
          ConfirmedDate:=SubscribedDate;  { trigger in ConfirmInterval days }
          ConfirmReqDate:=0;
          ConfirmState:=lcOk;
          ConfirmCode:=0;

          CASE Key OF
               kEsc : Exit;

               mOpt01 :
                   BEGIN { fido user }
                         FidoSplit ('0',Address);
                         Name:='';
                         ListSystem:=lstFido;
                   END;

               mOpt02 :
                   BEGIN { uucp users }
                        Email:='';
                        ListSystem:=lstUUCP;
                   END;

               mOpt03 :
                   BEGIN
                        FidoSplit ('0',GWAddress);
                        GWUser:='UUCP';
                        GWEmail:='';
                        ListSystem:=lstRemoteGateway;
                   END;

               mOpt04 :
                   BEGIN
                        ImportFidoList;
                        Exit;
                   END;

               mOpt05 :
                   BEGIN
                        ImportUsenetList;
                        Exit;
                   END;
          END; { case }
     END; { with }

     REPEAT
          CASE MenuKeuze OF
               mOpt01 : EditFidoUser;
               mOpt02 : EditUUCPUser;
               mOpt03 : EditGatewayUser;
          END; { case }

          MenuDefine (6,15,'Save Changes?');
          MenuAddItem ('Yes, create user');
          MenuAddItem ('Continue editing');
          MenuAddItem ('No, trash it');
          MenuShow;

          CASE MenuSelect OF
               mOpt01 :
                   BEGIN
                        AddUserToList (ListMainRecNo,ListMainRec,ListUserRec);
                        EditNewUser:=ListMainRec.NextUser;
                        MenuKeuze:=kEsc; { ga verlaten }
                   END;

               mOpt03 :
                   MenuKeuze:=kEsc; { verlaat loop, niet saven }
          END; { case }

          MenuErase;

     UNTIL (MenuKeuze = kEsc);
END;


{--------------------------------------------------------------------------}
{ EditExistingUser                                                         }
{                                                                          }
{ Edit het record van een node die al bestaat, roep de routines aan voor   }
{ UUCP/Fido nodes.                                                         }
{                                                                          }
PROCEDURE EditExistingUser (TaggedItem : ListServerRecordNrType);
BEGIN
     { laad het gekozen user record }
     IF (NOT ReadListBaseRecord (TaggedItem,ListUserRec)) THEN
     BEGIN
          Error ('Unable to read from Mailing list database!');
          Exit;
     END;

     CASE ListUserRec.ListSystem OF
          lstFido :
              EditFidoUser;

          lstUUCP :
              EditUUCPUser;

          lstRemoteGateway :
              EditGatewayUser;
     END; { case }

     WriteListBaseRecord (TaggedItem,ListUserRec);
END;


{--------------------------------------------------------------------------}
{ EditSubScribedUsers                                                      }
{                                                                          }
{ Edit handmatig een user van een list server.                             }
{                                                                          }
PROCEDURE EditSubScribedUsers; FAR;

CONST Xb = 3;
      Yb = 3;
      Xl = 75;

VAR ListData : ListServerRecord;
    Quit     : BOOLEAN;
    Keuze    : WORD;
    Yl       : XYType;

    {----------------------------------------------------------------------}
    { BuildList                                                            }
    {                                                                      }
    { Deze routine vult de lijst met list users.                           }
    {                                                                      }
    PROCEDURE BuildList;

    VAR LSRecTeller : ListServerRecordNrType;

    BEGIN
         ListDefine (Xb,Yb,Xl,Yl,Default,'Users connected to '+DeleteBackSpaces (ListMainRec.ListName),4011);

         ListData:=ListMainRec;

         WHILE (ListData.NextUser <> NILRecordNr) DO
         BEGIN
              LSRecTeller:=ListData.NextUser;

              IF (NOT ReadListBaseRecord (LSRecTeller,ListData)) THEN
                 Error ('Error reading list server record!');

              { skip alle 'gewone' records en gedelete records }
              IF (ListData.ListSystem = lstName) OR ListData.Deleted THEN
                 Continue;

              BuildAddOne (LSRecTeller,ListData);
         END; { while not end of list }
    END;

    {----------------------------------------------------------------------}
    { GlobalChangeAccess                                                   }
    {                                                                      }
    PROCEDURE GlobalChangeAccess (NewAccess : ListAccessType);

    VAR RecNo : ListServerRecordNrType;

    BEGIN
         ListData:=ListMainRec;

         Message ('Changing access type, please wait...');

         WHILE (ListData.NextUser <> NILRecordNr) DO
         BEGIN
              RecNo:=ListData.NextUser;

              IF (NOT ReadListBaseRecord (ListData.NextUser,ListData)) THEN
                 Error ('Error reading list server record!');

              { skip alle 'gewone' records en gedelete records }
              IF (ListData.ListSystem = lstName) OR ListData.Deleted THEN
                 Continue;

              ListData.Access:=NewAccess;
              WriteListBaseRecord (RecNo,ListData);
         END; { while not end of list }

         WindowPop;
    END;

{ EditSubscribedUsers }
BEGIN
     Yl:=Video.Rows-Yb-1;
     BuildList;

     Quit:=FALSE;

     WHILE (NOT Quit) DO
     BEGIN
          IF (ListItemCount = 0) THEN
             ListAddItem ('<no list users>',65535,Bottom);

          Keuze:=ListSelect (DoTag,[kIns,kDel]);

          ListRemoveItem (65535);

          CASE Key OF
               kEsc :
                   Quit:=TRUE;

               kRet :
                   IF (ListTagCount = 0) THEN
                   BEGIN
                        ListRemoveItem (Keuze);
                        EditExistingUser (Keuze);
                        BuildReadAddOne (Keuze);
                        ListSetCursorOnItem (Keuze);
                   END ELSE
                   BEGIN
                        MenuDefine (40,15,'Global Change Access');
                        MenuAddItem ('Full access');
                        MenuAddItem ('Receive-only');
                        MenuAddItem ('Post-only');
                        MenuAddItem ('Don''t change anything');
                        MenuSetHelp (4015);
                        MenuShow;
                        MenuSelect;
                        MenuErase;

                        IF (Key IN [mOpt01,mOpt02,mOpt03]) THEN
                           GlobalChangeAccess (ListAccessType (Ord (Key)-Ord (mOpt01)));
                   END;

               kIns :
                   BEGIN
                        Keuze:=EditNewUser;
                        IF (Keuze <> 0) THEN
                        BEGIN
                             BuildReadAddOne (Keuze);
                             ListSetCursorOnItem (Keuze);
                        END;
                   END;

               kDel :
                   IF (ListTagCount = 0) THEN
                   BEGIN
                        IF (Keuze < 65000) THEN
                        BEGIN
                             MenuDefine (6,15,'Remove this user?');
                             MenuAddItem ('Yes');
                             MenuAddItem ('No');
                             MenuShow;

                             IF (MenuSelect = mOpt01) THEN
                             BEGIN
                                  DeleteListUserRecord (Keuze);
                                  ListRemoveItem (Keuze);
                             END;

                             MenuErase;
                        END;
                   END ELSE
                   BEGIN
                        MenuDefine (6,15,'Remove all tagged users?');
                        MenuAddItem ('Yes');
                        MenuAddItem ('No');
                        MenuShow;

                        IF (MenuSelect = mOpt01) THEN
                           WHILE (ListTagCount > 0) DO
                           BEGIN
                                Keuze:=ListGetTaggedItemNr (1);
                                DeleteListUserRecord (Keuze);
                                ListRemoveItem (Keuze);
                           END;

                        MenuErase;
                   END;

               (*
               kAltF7 :
                   IF (ListTagCount = 0) THEN
                   BEGIN
                        IF ReadListBaseRecord (Keuze,ListUserRec) AND
                           (ListUserRec.ListSystem = lstUsenet) THEN
                        WITH ListUserRec DO
                        BEGIN
                             { change from Usenet type to RemoteGateway type }
                             ListSystem:=lstRemoteGateway;
                             GWEMail:=EMail;
                             FidoSplit ('2:200/111',GWAddress);
                             GWUser:='UUCP';

                             WriteListBaseRecord (Keuze,ListUserRec);
                        END; { with, if }
                   END ELSE
                       FOR Keuze:=1 TO ListTagCount DO
                           IF ReadListBaseRecord (ListGetTaggedItemNr (Keuze),ListUserRec) AND
                              (ListUserRec.ListSystem = lstUsenet) THEN
                           WITH ListUserRec DO
                           BEGIN
                                { change from Usenet type to RemoteGateway type }
                                ListSystem:=lstRemoteGateway;
                                GWEMail:=EMail;
                                FidoSplit ('2:200/111',GWAddress);
                                GWUser:='UUCP';

                                WriteListBaseRecord (ListGetTaggedItemNr (Keuze),ListUserRec);
                           END; { with,if,for }
               *)

               (*
               kAltF8 :
                   IF (ListTagCount = 0) THEN
                   BEGIN
                        IF ReadListBaseRecord (Keuze,ListUserRec) AND
                           (ListUserRec.ListSystem = lstRemoteGateway) THEN
                        WITH ListUserRec DO
                        BEGIN
                             { change from Usenet type to RemoteGateway type }
                             ListSystem:=lstUUCP;
                             EMail:=GWEMail;
                             WriteListBaseRecord (Keuze,ListUserRec);
                        END; { with, if }
                   END ELSE
                       FOR Keuze:=1 TO ListTagCount DO
                           IF ReadListBaseRecord (ListGetTaggedItemNr (Keuze),ListUserRec) AND
                              (ListUserRec.ListSystem = lstRemoteGateway) THEN
                           WITH ListUserRec DO
                           BEGIN
                                { change from Usenet type to RemoteGateway type }
                                ListSystem:=lstUUCP;
                                EMail:=GWEMail;
                                WriteListBaseRecord (ListGetTaggedItemNr (Keuze),ListUserRec);
                           END; { with,if,for }
               *)
          END; { case }

     END; { while }

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckListName                                                            }
{                                                                          }
{ Deze routine controleert of er een spatie in de mailing list naam zit en }
{ klaagt daar dan over.                                                    }
{                                                                          }
FUNCTION CheckListName (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     CheckListName:=TRUE;   { nooit problemen }

     IF (Pos (' ',DeleteFrontAndBackSpaces (BufferPtr^)) > 0) THEN
        Error2Lines ('It is not advisable to use spaces in a mailing list name.',
                     'Use a dash ("-") or underscore ("_") instead.');
END;


{--------------------------------------------------------------------------}
{ CheckConfirmInterval                                                     }
{                                                                          }
{ Deze routine kijkt of het ingetikte confirm interval tussen 0 en 255     }
{ ligt, formatteert het veld zodat het left-alligned is en stopt de nieuwe }
{ waarde in MainListRec.ConfirmInterval. Als de waarde tussen 1 en 7       }
{ ingesteld wordt, dan wordt een opmerking gemaakt over de gevaren.        }
{                                                                          }
FUNCTION CheckConfirmInterval (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Value : INTEGER;
    Nop   : ValNop;

BEGIN
     CheckConfirmInterval:=TRUE;   { nooit problemen }

     Val (DeleteFrontAndBackSpaces (BufferPtr^),Value,Nop);
     IF (Nop <> 0) THEN
        Value:=0;

     IF (Value > 255) THEN
        Value:=255;

     IF (Value < 0) THEN
        Value:=0;

     IF (Value > 0) AND (Value < 7) THEN
        Error2Lines ('WARNING: Setting the confirmation interval from 1 to 6',
                     'can cause a dangerous amount of confirmation messages!');

     ListMainRec.ConfirmInterval:=Byte (Value);

     BufferPtr^:=AddUpWithSpaces (3,Byte2String (ListMainRec.ConfirmInterval));
END;


{--------------------------------------------------------------------------}
{ EditListServer                                                           }
{                                                                          }
PROCEDURE EditListServerFields;

CONST Xb = 7;
      Yb = 5;
      Xl = 61;
      Yl = 18;

      Xb2 = Xb+19;

VAR EditString : STRING[15];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;
     EditString:='<enter to edit>';

     ListMainRec.ListWelcome:=AddUpWithSpaces (79,ListMainRec.ListWelcome);
     ListMainRec.ListName:=AddUpWithSpaces (MaxLenListNameType,ListMainRec.ListName);
     ListMainRec.ListDescription:=AddUpWithSpaces (40,ListMainRec.ListDescription);
     ListMainRec.AreaName:=AddUpWithSpaces (MaxLenAreaName,ListMainRec.AreaName);

     ListAKAStr:=AddUpWithSpaces (30,Fido2Str (Config.NodeNrs[ListMainRec.ListAka]));
     ListConfirmStr:=AddUpWithSpaces (3,Byte2String (ListMainRec.ConfirmInterval));

     WriteXY (Xb+2,Yb+1,'List name');
     FieldAutoDefineCheckOne (Xb2,Yb+1,@ListMainRec.ListName,RepChar(MaxLenListNameType,'$'),CheckListName);
     FieldSetHelp (0,4001);

     WriteXY (Xb+2,Yb+2,'Description');
     FieldAutoDefineOne (Xb2,Yb+2,@ListMainRec.ListDescription,RepChar (40,'$'));
     FieldSetHelp (0,4002);

     WriteXY (Xb+2,Yb+3,'Welcome file');
     FieldAutoDefineFileMgr (Xb2,Yb+3,40,@ListMainRec.ListWelcome,AnyFileMgr);
     FieldSetHelp (0,4012);

     WriteXY (Xb+2,Yb+4,'Private list');
     FieldAutoDefineToggles (Xb2,Yb+4,ListMainRec.ListPrivate,'no|yes',0);
     FieldSetHelp (0,4003);

     WriteXY (Xb+2,Yb+5,'Only known');
     FieldAutoDefineToggles (Xb2,Yb+5,ListMainRec.OnlyKnown,'no|yes',0);
     FieldSetHelp (0,4004);

     WriteXY (Xb+2,Yb+6,'Active');
     FieldAutoDefineToggles (Xb2,Yb+6,ListMainRec.Active,'no|yes',0);
     FieldSetHelp (0,4005);

     WriteXY (Xb+2,Yb+7,'List AKA');
     FieldAutoDefineList (Xb2,Yb+7,@ListAKAStr,EditListAKA);
     FieldSetHelp (0,4006);

     WriteXY (Xb+2,Yb+8,'Default access');
     FieldAutoDefineToggles (Xb2,Yb+8,ListMainRec.DefaultAccess,AccessEditOptions,0);
     FieldSetHelp (0,4013);

     WriteXY (Xb+2,Yb+9,'List address');
     FieldAutoDefineToggles (Xb2,Yb+9,ListMainRec.MLAddress,'nowhere|from|replyto|sender',0);
     FieldSetHelp (0,4016);

     WriteXY (Xb+2,Yb+10,'Confirm interval     days');
     FieldAutoDefineCheckOne (Xb2,Yb+10,@ListConfirmStr,'%%%',CheckConfirmInterval);
     FieldSetHelp (0,4017);

     WriteXY (Xb+2,Yb+12,'Area name');
     FieldAutoDefineLongOne (Xb2,Yb+12,40,@ListMainRec.AreaName,RepChar (MaxLenAreaName,'@'));
     FieldSetHelp (0,4008);

     WriteXY (Xb+2,Yb+13,'Area to List');
     FieldAutoDefineToggles (Xb2,Yb+13,ListMainRec.EchoList,'no|yes',0);
     FieldSetHelp (0,4009);

     WriteXY (Xb+2,Yb+14,'List to Area');
     FieldAutoDefineToggles (Xb2,Yb+14,ListMainRec.ListEcho,'no|yes',0);
     FieldSetHelp (0,4010);

     WriteXY (Xb+2,Yb+16,'Subscribers');
     FieldAutoDefineList (Xb2,Yb+16,@EditString,EditSubScribedUsers);
     FieldSetHelp (0,4007);

     IF (ListMainRec.NextUser <> NILRecordNr) THEN
        FieldSetFirst (0);

     FieldEdit;

     ListMainRec.ListWelcome:=DeleteBackspaces (ListMainRec.ListWelcome);
     ListMainRec.ListName:=DeleteBackSpaces (ListMainRec.ListName);
     ListMainRec.ListDescription:=DeleteBackSpaces (ListMainRec.ListDescription);
     ListMainRec.AreaName:=DeleteBackSpaces (ListMainRec.AreaName);

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ DeleteListServerRecord                                                   }
{                                                                          }
{ Lees de rij record die aangesloten zijn op een list, en zet bij allemaal }
{ de deleted vlag.                                                         }
{                                                                          }
PROCEDURE DeleteListServerRecord (Start : ListServerRecordNrType);

VAR TmpRec : ListServerRecord;

BEGIN
     { verwijder het naam info record }
     ReadListBaseRecord (Start,ListMainRec);
     ListMainRec.Deleted:=TRUE;
     WriteListBaseRecord (Start,ListMainRec);

     { verwijder alle aangesloten records }
     WHILE (ListMainRec.NextUser <> NILRecordNr) DO
     BEGIN
          TmpRec:=ListMainRec;
          IF (NOT ReadListBaseRecord (ListMainRec.NextUser,ListMainRec)) THEN
             Error ('Integrity error in List Server Database!');
          ListMainRec.Deleted:=TRUE;
          WriteListBaseRecord (TmpRec.NextUser,ListMainRec);
     END; { while }
END;


{--------------------------------------------------------------------------}
{ CreateNewListServer                                                      }
{                                                                          }
{ Maak een nieuw list server record aan.                                   }
{                                                                          }
PROCEDURE CreateNewListServer;

VAR Quit : BOOLEAN;

BEGIN
     { maak een schoon record }
     WITH ListMainRec DO
     BEGIN
          Deleted:=FALSE;
          ListSystem:=lstName;
          NextUser:=NILRecordNr;
          ListAka:=1;
          ListName:='';
          ListDescription:='';
          AreaName:='';
          EchoList:=FALSE;
          ListEcho:=FALSE;
          ListPrivate:=FALSE;
          OnlyKnown:=FALSE;
          Active:=TRUE;
          DefaultAccess:=laReadWrite;
          MLAddress:=laSender;
      END; { with }

      { record moet alvast aangemaakt worden ivm aansluiten van users }
      ListMainRecNo:=WriteNewListBaseRecord (ListMainRec);

      { RWI950604: tuned it a little bit. If you press Escape now, you are }
      {            returned to the edit screen, in stead of losing it all. }
      Quit:=FALSE;
      REPEAT
            EditListServerFields;

            { vraag of de gebruiker het record wil bewaren }
            MenuDefine (6,15,'Save changes?');
            MenuAddItem ('Yes');
            MenuAddItem ('No, continue editing');
            MenuAddItem ('No, abort');
            MenuShow;

            {  controleer de integriteit van het record }
            CASE MenuSelect OF
                 mOpt01 : BEGIN { yes }
                               IF (ListMainRec.ListName = '') THEN
                                  Error ('There is no name defined for this List!')
                               ELSE BEGIN
                                    WriteListBaseRecord (ListMainRecNo,ListMainRec);
                                    Quit:=TRUE;
                               END;
                          END;

                 mOpt03 : BEGIN
                               DeleteListServerRecord (ListMainRecNo);
                               ListMainRecNo:=NILRecordNr;
                               Quit:=TRUE;
                          END;
            END; { case }

            MenuErase;

      UNTIL Quit;
END;


{--------------------------------------------------------------------------}
{ EditExistingServer                                                       }
{                                                                          }
{ ListMainRecNo bevat het record nummer van de te editten list.            }
{                                                                          }
PROCEDURE EditExistingServer;

VAR Quit : BOOLEAN;

BEGIN
     Quit:=FALSE;
     REPEAT
           EditListServerFields;

           IF (ListMainRec.ListName = '') THEN
           BEGIN
                Error ('There is no name defined for this List!');
                Continue;
           END;

           Quit:=TRUE;
     UNTIL Quit;

     WriteListBaseRecord (ListMainRecNo,ListMainRec);
END;


{--------------------------------------------------------------------------}
{ EditListServer                                                           }
{                                                                          }
{ Het GUI menu'tje voor de configuratie.                                   }
{                                                                          }
PROCEDURE EditListServer;

CONST Xb = 3;
      Yb = 3;
      Xl = 75;

VAR Quit        : BOOLEAN;
    ListData    : ListServerRecord;
    Keuze,Lp    : WORD;
    Yl          : XYType;
    Tmp         : LSTypePtr;

BEGIN
     { bouw de lijst met list server entries op }
     Yl:=Video.Rows-4;
     ListDefine (Xb,Yb,Xl,Yl,Default,'Mailing List definitions',4000);

     Tmp:=LSNameTable.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF ReadListBaseRecord (Tmp^.RecNr,ListData) THEN
             ListAddItem (AddUpWithSpaces (MaxLenListNameType,ListData.ListName)+
                          AddUpWithSpaces (40,ListData.ListDescription),
                          Tmp^.RecNr,Sorted);

          Tmp:=LSNameTable.GetNextItem;
     END;

     Quit:=FALSE;
     WHILE (NOT Quit) DO
     BEGIN
         { voeg een melding toe voor het geval de lijst leeg blijkt te zijn }
         IF (ListItemCount = 0) THEN
            ListAddItem ('<no mailing list definitions>',65535,Bottom);

          Keuze:=ListSelect (NoTag,[kDel,kIns]);

          ListRemoveItem (65535);

          CASE Key OF
               kEsc : Quit:=TRUE;

               kRet :
                   BEGIN
                        { record inlezen in globale variabelen }
                        ListMainRecNo:=Keuze;
                        ReadListBaseRecord (ListMainRecNo,ListMainRec);

                        EditExistingServer;

                        { update het item in de lijst }
                        ListRemoveItem (Keuze);
                        ReadListBaseRecord (Keuze,ListData);
                        ListAddItem (AddUpWithSpaces (MaxLenListNameType,ListData.ListName)+
                                     AddUpWithSpaces (40,ListData.ListDescription),
                                     Keuze,Sorted);
                        ListSetCursorOnItem (Keuze);
                   END; { kRet }

               kDel :
                   IF (ListTagCount = 0) THEN
                   BEGIN
                        IF (Keuze < 65000) THEN
                        BEGIN
                             MenuDefine (6,15,'Remove this list definition?');
                             MenuAddItem ('Yes');
                             MenuAddItem ('No');
                             MenuShow;

                             IF (MenuSelect = mOpt01) THEN
                             BEGIN
                                  DeleteListServerRecord (Keuze);
                                  ListRemoveItem (Keuze);
                             END;

                             MenuErase;
                        END;
                    END; { kDel }

               kIns :
                   BEGIN
                        CreateNewListServer;

                        IF (ListMainRecNo <> NILRecordNr) THEN
                        BEGIN
                             ReadListBaseRecord (ListMainRecNo,ListData);

                             { voeg een entry aan de lijst toe }
                             ListAddItem (AddUpWithSpaces (MaxLenListNameType,ListData.ListName)+
                                          AddUpWithSpaces (40,ListData.ListDescription),
                                          ListMainRecNo,Sorted);

                             ListSetCursorOnItem (ListMainRecNo);
                        END;
                   END ELSE
                       Error ('Maximum number of mailing lists has been reached!');
          END; { case }
     END; { while }

     ListErase;
     ListServerTabelInit;
END;
{$ENDIF}


{==========================================================================}
{                     DISTRIBUTION IMPLEMENTATION                          }
{==========================================================================}


{--------------------------------------------------------------------------}
{ ListServerTabelInit                                                      }
{                                                                          }
{ Maak een tabel met de CRC-32 van alle bekende listserver namen in het    }
{ geheugen.                                                                }
{                                                                          }
PROCEDURE ListServerTabelInit;

VAR LSRecTeller : ListServerRecordNrType;
    ListData    : ListServerRecord;
    TmpPtr      : ^LSType;

BEGIN
     LSNameTable.Clear;

     FOR LSRecTeller:=1 TO ListBaseRecCount DO
         IF ReadListBaseRecord (LSRecTeller,ListData) THEN
         BEGIN
              { skip alle 'gewone' record, en gedelete records }
              IF (ListData.ListSystem <> lstName) OR ListData.Deleted THEN
                 Continue;

              { voeg een entry aan de lijst toe }
              WITH LSTypePtr (LSNameTable.Create)^ DO
              BEGIN
                   ListData.ListName:=UpCaseString (ListData.ListName);
                   ServerNameCRC:=UpDateCRC32 ($FFFFFFFF,ListData.ListName[1],Length (ListData.ListName));

                   ListData.AreaName:=UpCaseString (ListData.AreaName);
                   AreaNameCRC:=UpDateCRC32 ($FFFFFFFF,ListData.AreaName[1],Length (ListData.AreaName));

                   RecNr:=LSRecTeller;
              END;
         END; { if/for }
END;


{--------------------------------------------------------------------------}
{ ListServerSendHelp                                                       }
{                                                                          }
{ Stuur informatie over de list server naar een bepaalde node.             }
{                                                                          }
PROCEDURE ListServerSendHelp;
BEGIN
     IF (NOT AddFileToMsg (Msg.BodyTop,'LISTHELP.TXT')) THEN
     BEGIN
          MsgsAddLineTo (Body,'');
          MsgsAddLineTo (Body,'This list server supports the following commands:');
          MsgsAddLineTo (Body,'');
          MsgsAddLineTo (Body,'CONNECT name          Connects you to the mailing list "name"' );
          MsgsAddLineTo (Body,'SUBSCRIBE name        Connects you to the mailing list "name"' );
          MsgsAddLineTo (Body,'DISCONNECT name       Removes you from the mailing list "name"');
          MsgsAddLineTo (Body,'UNSUBSCRIBE name      Removes you from the mailing list "name"');
          MsgsAddLineTo (Body,'HELP                  This information');
          MsgsAddLineTo (Body,'LIST                  Sends a listing of all public mailing lists on this system');
          MsgsAddLineTo (Body,'');
     END;
END;


{--------------------------------------------------------------------------}
{ ListServerSendList                                                       }
{                                                                          }
{ Stuur een lijst met alle lists die aangesloten kunnen worden aan         }
{ de 'klant'.                                                              }
{                                                                          }
PROCEDURE ListServerSendList;

VAR Tmp : LSTypePtr;

BEGIN
     IF (NOT AddFileToMsg (Msg.BodyTop,'LISTHDR.TXT')) THEN
     BEGIN
          MsgsAddLineTo (Body,'An overview of all available lists at this site follows below:');
          MsgsAddLineTo (Body,'');
     END;

     { doorloop de lijst met alle lists }
     IF (LSNameTable.ItemCount = 0) THEN
        MsgsAddLineTo (Body,'There are no mailing lists available at all!')
     ELSE
     BEGIN
          Tmp:=LSNameTable.GetFirstItem;
          WHILE (Tmp <> NIL) DO
          BEGIN
               WITH Tmp^ DO
               BEGIN
                    ListMainRecNo:=RecNr;
                    ReadListBaseRecord (ListMainRecNo,ListMainRec);

                    WITH ListMainRec DO
                         IF (NOT ListPrivate) THEN
                         BEGIN
                              IF (ListDescription <> '') THEN
                                 MsgsAddLineTo (Body,AddUpWithSpaces (35,ListName)+' - '+ListDescription)
                              ELSE
                                  MsgsAddLineTo (Body,ListName);
                         END; { if,while }
               END; { with }

               Tmp:=LSNameTable.GetNextItem;
          END; { while }
     END;

     IF (NOT AddFileToMsg (Msg.BodyTop,'LISTFTR.TXT')) THEN
     BEGIN
          MsgsAddLineTo (Body,'');
          MsgsAddLineTo (Body,'End of listing.');
          MsgsAddLineTo (Body,'');
     END;
END;


{--------------------------------------------------------------------------}
{ ProcessConfirm                                                           }
{                                                                          }
{ Returns: 0=Syntax error in command, report error to user.                }
{          1=Confirmation successful                                       }
{          2=
{                                                                          }
FUNCTION ProcessConfirm (CodeStr : STRING) : BYTE;

VAR Lp      : ListServerRecordNrType;
    ListRec : ListServerRecord;
    Code    : LONGINT;

BEGIN
     { check for valid hex string }
     ProcessConfirm:=0; { assume syntax error }

     IF (Length (CodeStr) <> 8) THEN
        Exit;

     FOR Lp:=1 TO 8 DO
         IF NOT (CodeStr[Lp] IN ['0'..'9','A'..'F','a'..'f']) THEN
            Exit;

     { convert to number }
     Code:=HexString2Long (CodeStr);

     LogMessage ('Received confirm code '+Long2HexString (Code));

     FOR Lp:=1 TO ListBaseRecCount DO
     BEGIN
          ReadListBaseRecord (Lp,ListRec);

          IF (ListRec.ListSystem <> lstName) AND
             (ListRec.ConfirmCode = Code) THEN
          BEGIN
               { todo: add sender address verification (?) }
               LogMessage ('  Confirmation accepted');

               { set confirm date, confirm state=Ok }
               ListRec.ConfirmedDate:=GetCurrentUnixTime;
               ListRec.ConfirmState:=lcOk;

               { write the updated record back to disk }
               WriteListBaseRecord (Lp,ListRec);

               ProcessConfirm:=1; { confirm succesful }
               Exit;
          END;
     END; { for }

     LogMessage ('  Confirmation code not found!');
END;


{--------------------------------------------------------------------------}
{ ListServerUsenetFix                                                      }
{                                                                          }
{ Verwerk de commando's die een Usenet gebruiker geeft.                    }
{ Ondersteund worden:                                                      }
{                                                                          }
{   Subscribe/Connect                                                      }
{   UnSubscribe/Disconnect                                                 }
{   List                                                                   }
{   Help                                                                   }
{                                                                          }
PROCEDURE ListServerUsenetFix;

VAR EenRegelPtr : EenRegelRecordPtr;
    SwapPos     : LONGINT;
    RegelLength : BYTE;
    P           : BYTE;
    TempAdres,
    ReturnAdres : UsenetUserNameString;
    TempInfo    : STRING;
    RequestList,
    RequestHelp : BOOLEAN;
   {WelcomeBuf  : TopRegelRecordPtr; RWI 950723}

BEGIN
     { init }
    {WelcomeBuf:=NIL; RWI 950723}
     ClearLineBuffer (LineBuffer);

     RequestHelp:=FALSE;
     RequestList:=FALSE;
     ReturnAdres:=UsenetReplyAdres;

     IF (Pos ('MAILER-DAEMON',UpCaseString (ReturnAdres)) > 0) THEN
     BEGIN
          LogMessage ('ListServer: Suspected bounced mail (1) from '+ReturnAdres);
          IF TranslateMail2Netmail (Config.NodeNrs[1],'List Server') THEN
             FidoWriteMessageToBad;
          MsgsEmpty; { just to be sure }
          Exit;
     END;

     IF (Msg.BodyTop <> NIL) THEN
        EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr
     ELSE
         EenRegelPtr:=NIL;

     IF SwapIsOpen THEN
     BEGIN
          MsgsNewSeek (EenRegelPtr);
          SwapPos:=FilePos (SwapFile);
     END;

     InitTokens (_U);

     { verwerk bericht }
     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          IF SwapIsOpen THEN
             Seek (SwapFile,SwapPos);

          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        TempInfo:=EenRegelPtr^.RegelPtr^;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,RegelLength,1);

                        IF (RegelLength = 0) THEN
                        BEGIN
                             { einde swapblock }
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             SwapPos:=FilePos (SwapFile); { !!! ivm Seek() na WHILE }
                             Continue;
                        END;

                        BlockRead (SwapFile,TempInfo[1],RegelLength);
                        TempInfo[0]:=Char (RegelLength);
                   END; { wSwapped }
          END; { case }

          IF SwapIsOpen THEN
             SwapPos:=FilePos (SwapFile);

          IF (TempInfo = '-- '#13) THEN
             Break; { from the while }

          TempInfo:=UpCaseString (TempInfo);

          WHILE (TempInfo <> '') AND (TempInfo[Length (TempInfo)] = #13) DO
                Delete (TempInfo,Length (TempInfo),1);

          IF (TempInfo = '') THEN
             Continue;

          AddToLineBuffer (LineBuffer,''); { RWI 960225 }
          AddToLineBuffer (LineBuffer,'--> '+TempInfo);

          {-------------------------------}
          { confirmatie                   }
          P:=Pos ('CONFIRM ',TempInfo);
          IF (P > 0) THEN
             CASE ProcessConfirm (Copy (TempInfo,P+8,8)) OF
                  0 : { syntax error }
                      { let it process all the other options }
                      ;

                  1 : { success }
                      BEGIN
                           { erase other reply lines }
                           { build new, clean reply }
                           ClearLineBuffer (LineBuffer);
                           AddToLineBuffer (LineBuffer,GetLang0 (1042));
                           { ignore rest of message }
                           EenRegelPtr:=NIL; { break the while }
                           { disable possibly triggered messages }
                           RequestHelp:=FALSE;
                           RequestList:=FALSE;
                           Continue;
                      END;
             END; { case }

          {-------------------------------}
          { Het 'subscriben' van een area }

          IF (Pos ('CONNECT',TempInfo) = 1) OR (Pos ('SUBSCRIBE',TempInfo) = 1) THEN
          BEGIN
               { RWI 950531: Kijk of er wel wat achter volgt }
               IF (Pos (' ',TempInfo) = 0) THEN
               BEGIN
                    {AddToLineBuffer (LineBuffer,'Missing name after '+TempInfo+'. Help and a list will follow.');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1000,TempInfo));
                    RequestHelp:=TRUE;
                    RequestList:=TRUE;
                    Continue;
               END;

               TempInfo:=DeleteFrontSpaces (Copy (TempInfo,Pos (' ',TempInfo),255));
               TempInfo:=DeleteBackSpaces (TempInfo);

               IF (NOT ListServerSearchNameCorrect (TempInfo)) THEN
               BEGIN
                    {AddToLineBuffer (LineBuffer,'Cannot connect unknown list name '+TempInfo);}
                    AddToLineBuffer (LineBuffer,GetLang1 (1001,TempInfo));
                    RequestHelp:=TRUE;
                    RequestList:=TRUE;
                    Continue;
               END;

               { sluit een node aan als die nog niet aangesloten is }
               IF ListServerIsKnownUsenetUser (ReturnAdres) THEN
               BEGIN
                    { already connected to }
                    AddToLineBuffer (LineBuffer,GetLang1 (1002,TempInfo));
                    RequestHelp:=TRUE;
                    Continue;
               END;

               IF (ListMainRec.ListPrivate) THEN
               BEGIN
                    {AddToLineBuffer (LineBuffer,'You cannot connect this private mailing lists.');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1003,TempInfo));
                    Continue;
               END;

               { controleer of de node wel aangesloten mag worden }
               TempAdres:=ReturnAdres;
               IF (ListMainRec.OnlyKnown) THEN
                  { we moeten de node dus kennen }
                  IF (GetUucpRoute (STRING (TempAdres){,Config.UUCPName}) = NILRecordNr) THEN
                  BEGIN
                       {AddToLineBuffer (LineBuffer,'You are not allowed to connect to list '+TempInfo);}
                       AddToLineBuffer (LineBuffer,GetLang1 (1004,TempInfo));
                       Continue;
                  END;

               { door onze lijst met excuses heen, sluit 'm dan maar aan }
               WITH ListUserRec DO
               BEGIN
                    Deleted:=FALSE;
                    ListSystem:=lstUUCP;
                    Email:=DeleteBackSpaces (ReturnAdres);
                    Access:=ListMainRec.DefaultAccess;
                    SubscribedDate:=GetCurrentUnixTime;
                    ConfirmedDate:=SubscribedDate;  { trigger in ConfirmInterval days }
                    ConfirmReqDate:=0;
                    ConfirmState:=lcOk;
                    ConfirmCode:=0;
               END; { with }

               AddUserToList (ListMainRecNo,ListMainRec,ListUserRec);

               {AddToLineBuffer (LineBuffer,'Connected '+ReturnAdres+' to mailing list "'+ListMainRec.ListName+'"');}
               AddToLineBuffer (LineBuffer,GetLang2 (1005,ReturnAdres,ListMainRec.ListName));
               LogExtraMessage ('  Connected to mailing-list "'+ListMainRec.ListName+'"');

               IF (ListMainRec.ListWelcome <> '') THEN
                  AddFileToMsg (LineBuffer,ListMainRec.ListWelcome);

               Continue;
          END;

          {------------------------------}
          { Het afkoppelen van een lijst }

          IF (Pos ('DISCONNECT',TempInfo) = 1) OR (Pos ('UNSUBSCRIBE',TempInfo) = 1) THEN
          BEGIN
               { RWI 950531: Kijk of er wel wat achter volgt }
               IF (Pos (' ',TempInfo) = 0) THEN
               BEGIN
                    {'Missing name after '+TempInfo+'. Help and a list will follow.');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1000,TempInfo));
                    RequestHelp:=TRUE;
                    RequestList:=TRUE;
                    Continue;
               END;

               TempInfo:=DeleteFrontSpaces (Copy (TempInfo,Pos (' ',TempInfo),255));
               TempInfo:=DeleteBackSpaces (TempInfo);

               { controleer of de group wel bestaat }
               IF (NOT ListServerSearchNameCorrect (TempInfo)) THEN
               BEGIN
                    {AddToLineBuffer (LineBuffer,'Cannot disconnect you from unknown list '+TempInfo);}
                    AddToLineBuffer (LineBuffer,GetLang1 (1010,TempInfo));
                    RequestHelp:=TRUE;
                    Continue;
               END;

               { controleer of de user op de groep is aangesloten }
               IF (NOT ListServerIsKnownUsenetUser (ReturnAdres)) THEN
               BEGIN
                    {'You are not connected to '+TempInfo+'; no need to disconnect' }
                    AddToLineBuffer (LineBuffer,GetLang1 (1011,TempInfo));
                    RequestHelp:=TRUE;
                    Continue;
               END;

               { dan zijn er geen excuses meer om 'm niet af te sluiten }
               DeleteListUserRecord (ListUserRecNo);

               {AddToLineBuffer (LineBuffer,'Disconnected '+ReturnAdres+' from mailing list "'+ListMainRec.ListName+'"');}
               AddToLineBuffer (LineBuffer,GetLang2 (1012,ReturnAdres,ListMainRec.ListName));
               LogExtraMessage ('  Disconnected from mailing-list "'+ListMainRec.ListName+'"');

               Continue;
         END;

         {---------------------------------------}
         { overzicht geven van beschikbare lists }

         IF (Pos ('LIST',TempInfo) = 1) THEN
         BEGIN
              AddToLineBuffer (LineBuffer,GetLang0 (1040)); { RWI 960225 }
              RequestList:=TRUE;
              Continue;
         END;

         {----------------------------}
         { verzoek om help afhandelen }
         IF (Pos ('HELP',TempInfo) = 1) THEN
         BEGIN
              AddToLineBuffer (LineBuffer,GetLang0 (1040)); { RWI 960225 }
              RequestHelp:=TRUE;
              Continue;
         END;

         {-----------------------------}
         { tear line gevonden?
         IF (Pos ('-- ',TempInfo) = 1) THEN
            Break; { uit de while }

         { 'Unknown command found! ('+TempInfo+')' }
         AddToLineBuffer (LineBuffer,GetLang1 (1030,TempInfo));
         RequestHelp:=TRUE;
     END; { while }

     { verstuur de lijst met antwoorden aan de desbetreffende node }
     { RWI 950723: zit nu IN het bericht zelf
     IF (WelcomeBuf <> NIL) THEN
     BEGIN
          UsenetBuildMail (ReturnAdres,ReturnAdres,'listserver',Config.Domains[1],'List server reply message');
          Msg.BodyTop:=WelcomeBuf;
          LineBuffer:=NIL;
          UsenetRouteMail;
     END;
     }

     IF (LineBuffer <> NIL) THEN
     BEGIN
          UsenetBuildMail (ReturnAdres,'listserver',GetLang0 (1031),GetLang0 (1032));
          MsgsReleaseLines (Msg.BodyTop); { RWI 950723: lekkage opgelost }
          Msg.BodyTop:=LineBuffer;
          LineBuffer:=NIL;
          UsenetRouteMail;
     END;

     IF RequestHelp THEN
     BEGIN
          UsenetBuildMail (ReturnAdres,'listserver',GetLang0 (1031),GetLang0 (1033));
          ListServerSendHelp;
          UsenetRouteMail;
     END;

     IF RequestList THEN
     BEGIN
          UsenetBuildMail (ReturnAdres,'listserver',GetLang0 (1031),GetLang0 (1034));
          ListServerSendList;
          UsenetRouteMail;
     END;
END;


{--------------------------------------------------------------------------}
{ ListServerFidoFix                                                        }
{                                                                          }
{ Verwerk de commando's die een Usenet gebruiker geeft.                    }
{ Ondersteund worden:                                                      }
{                                                                          }
{   Subscribe/Connect                                                      }
{   UnSubscribe/Disconnect                                                 }
{   List                                                                   }
{   Help                                                                   }
{                                                                          }
PROCEDURE ListServerFidoFix;

VAR EenRegelPtr : EenRegelRecordPtr;
    RegelLength : BYTE;
    SwapPos     : LONGINT;
    P           : BYTE;
    TmpRec      : UserBaseRecordNrType;
    OurAdres,
    ReturnAdres : FidoAddrType;
    ReturnUser  : STRING[MaxLenSysopName];
    ReturnEmail : STRING[MaxLenDomain];
    TempInfo    : STRING;
    RequestList,
    RequestHelp : BOOLEAN;
   {WelcomeBuf  : TopRegelRecordPtr; RWI 950723}
    Code        : LONGINT;

BEGIN
     { init }
    {WelcomeBuf:=NIL; RWI 950723}
     ClearLineBuffer (LineBuffer);

     RequestHelp:=FALSE;
     RequestList:=FALSE;

     IF (Msg.ReplyEmail <> '') AND (Msg.ReplyUser <> '') THEN
     BEGIN
          ReturnEmail:=Msg.ReplyEmail;
          ReturnAdres:=Msg.ReplyAKA;
          ReturnUser:=Msg.ReplyUser;
          LogMessage ('Found netmail for the list server from '+ReturnEMail+' via "'+ReturnUser+'"%'+Fido2Str (ReturnAdres));
     END ELSE
     BEGIN
          ReturnAdres:=Msg.FromAddr_F;
          ReturnEmail:='';
          ReturnUser:=DeleteBackSpaces (Msg.FromUser_F);
          LogMessage ('Found netmail for the list server from "'+ReturnUser+'"%'+Fido2Str (ReturnAdres));
     END;

     { find our closest address for writing replies }
     FidoMatch (ReturnAdres,OurAdres);

     IF (Msg.BodyTop <> NIL) THEN
        EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr
     ELSE
         EenRegelPtr:=NIL;

     IF SwapIsOpen THEN
     BEGIN
          MsgsNewSeek (EenRegelPtr);
          SwapPos:=FilePos (SwapFile);
     END;

     InitTokens (_F);

     { verwerk bericht }
     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          IF SwapIsOpen THEN
             Seek (SwapFile,SwapPos);

          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        TempInfo:=EenRegelPtr^.RegelPtr^;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,RegelLength,1);

                        IF (RegelLength = 0) THEN
                        BEGIN
                             { einde van het blok }
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             SwapPos:=FilePos (SwapFile); { !!! ivm Seek() na de WHILE }
                             Continue;
                        END;

                        BlockRead (SwapFile,TempInfo[1],RegelLength);
                        TempInfo[0]:=Char (RegelLength);
                   END; { wSwapped }
          END; { case }

          IF SwapIsOpen THEN
             SwapPos:=FilePos (SwapFile);

          TempInfo:=UpCaseString (TempInfo);

          WHILE (TempInfo <> '') AND (TempInfo[Length (TempInfo)] = #13) DO
                Delete (TempInfo,Length (TempInfo),1);

          IF (TempInfo = '') THEN
             Continue;

          AddToLineBuffer (LineBuffer,''); { RWI 960226 }
          AddToLineBuffer (LineBuffer,'--> '+TempInfo);

          {-------------------------------}
          { confirmatie                   }
          P:=Pos ('CONFIRM ',TempInfo);
          IF (P > 0) THEN
             CASE ProcessConfirm (Copy (TempInfo,P+8,8)) OF
                  0 : { syntax error }
                      { let it process all the other options }
                      ;

                  1 : { success }
                      BEGIN
                           { erase other reply lines }
                           { build new, clean reply }
                           ClearLineBuffer (LineBuffer);
                           AddToLineBuffer (LineBuffer,GetLang0 (1042));
                           { ignore rest of message }
                           EenRegelPtr:=NIL; { break the while }
                           { disable possibly triggered messages }
                           RequestHelp:=FALSE;
                           RequestList:=FALSE;
                           Continue;
                      END;
             END; { case }

          {-------------------------------}
          { Het 'subscriben' van een area }

          IF (Pos ('CONNECT',TempInfo) = 1) OR (Pos ('SUBSCRIBE',TempInfo) = 1) THEN
          BEGIN
               { RWI 950531: Kijk of er wel wat achter volgt }
               IF (Pos (' ',TempInfo) = 0) THEN
               BEGIN
                    {'Missing name after '+TempInfo+'. Help and a list will follow.');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1000,TempInfo));
                    RequestHelp:=TRUE;
                    RequestList:=TRUE;
                    Continue;
               END;

               TempInfo:=DeleteFrontSpaces (Copy (TempInfo,Pos (' ',TempInfo),255));
               TempInfo:=DeleteBackSpaces (TempInfo);

               IF (NOT ListServerSearchNameCorrect (TempInfo)) THEN
               BEGIN
                    {'Cannot connect unknown list name '+TempInfo);}
                    AddToLineBuffer (LineBuffer,GetLang1 (1001,TempInfo));
                    RequestHelp:=TRUE;
                    RequestList:=TRUE;
                    Continue;
               END;

               { sluit een node aan als die nog niet aangesloten is }
               IF ((ReturnEMail <> '') AND ListServerIsKnownGatewayUser (ReturnAdres,ReturnUser,ReturnEMail)) OR
                  ((ReturnEMail = '') AND ListServerIsKnownFidoUser (ReturnAdres,ReturnUser)) THEN
               BEGIN
                    {'You are already connected to '+TempInfo);}
                    AddToLineBuffer (LineBuffer,GetLang1 (1002,TempInfo));
                    RequestHelp:=TRUE;
                    Continue;
               END;

               IF (ListMainRec.ListPrivate) THEN
               BEGIN
                    {'You cannot connect this private mailing lists.');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1003,TempInfo));
                    Continue;
               END;

               { controleer of de node wel aangesloten mag worden }
               IF ListMainRec.OnlyKnown THEN
                  { we moeten de node dus kennen }
                  IF (ReturnEMail <> '') OR (NOT FindUserBaseRecordByFidoAddress (ReturnAdres,TmpRec)) THEN
                  BEGIN
                       {'You are not allowed to connect to list '+TempInfo);}
                       AddToLineBuffer (LineBuffer,GetLang1 (1004,TempInfo));
                       Continue;
                  END;

               { door onze lijst met excuses heen, sluit 'm dan maar aan }
               ListUserRec.Deleted:=FALSE;
               IF (ReturnEMail <> '') THEN
               BEGIN
                    ListUserRec.ListSystem:=lstRemoteGateway;
                    ListUserRec.GWUser:=ReturnUser;
                    ListUserRec.GWAddress:=ReturnAdres;
                    ListUserRec.GWEMail:=ReturnEMail;
                    { let op: reply met alleen het e-mail adres. Zij }
                    { hoeven niet te weten dat het via een gateway   }
                    { loopt!                                         }
                    AddToLineBuffer (LineBuffer,GetLang2 (1005,ReturnEMail,ListMainRec.ListName));
               END ELSE
               BEGIN
                    ListUserRec.ListSystem:=lstFido;
                    ListUserRec.Name:=ReturnUser;
                    ListUserRec.Address:=ReturnAdres;
                    AddToLineBuffer (LineBuffer,GetLang2 (1005,'"'+ReturnUser+'" at '+
                                                               Fido2Str (ReturnAdres),ListMainRec.ListName));
               END;

               WITH ListUserRec DO
               BEGIN
                    Access:=ListMainRec.DefaultAccess;
                    SubscribedDate:=GetCurrentUnixTime;
                    ConfirmedDate:=SubscribedDate;  { trigger in ConfirmInterval days }
                    ConfirmReqDate:=0;
                    ConfirmState:=lcOk;
                    ConfirmCode:=0;
               END; { with }

               AddUserToList (ListMainRecNo,ListMainRec,ListUserRec);
               LogExtraMessage ('  Connected to mailing list "'+ListMainRec.ListName+'"');

               IF (ListMainRec.ListWelcome <> '') THEN
                  AddFileToMsg (LineBuffer,ListMainRec.ListWelcome);

               Continue;
          END;

          {------------------------------}
          { Het afkoppelen van een lijst }

          IF (Pos ('DISCONNECT',TempInfo) = 1) OR (Pos ('UNSUBSCRIBE',TempInfo) = 1) THEN
          BEGIN
               { RWI 950531: Kijk of er wel wat achter volgt }
               IF (Pos (' ',TempInfo) = 0) THEN
               BEGIN
                    {'Missing name after '+TempInfo+'. Help and a list will follow.');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1000,TempInfo));
                    RequestHelp:=TRUE;
                    RequestList:=TRUE;
                    Continue;
               END;

               TempInfo:=DeleteFrontSpaces (Copy (TempInfo,Pos (' ',TempInfo),255));
               TempInfo:=DeleteBackSpaces (TempInfo);

               { controleer of de group wel bestaat }
               IF (NOT ListServerSearchNameCorrect (TempInfo)) THEN
               BEGIN
                    {'Cannot disconnect you from unknown list '+TempInfo);}
                    AddToLineBuffer (LineBuffer,GetLang1 (1010,TempInfo));
                    RequestHelp:=TRUE;
                    Continue;
               END;

               { controleer of de user op de groep is aangesloten }
               IF ((ReturnEMail <> '') AND (NOT ListServerIsKnownGatewayUser (ReturnAdres,ReturnUser,ReturnEmail))) OR
                  ((ReturnEMail = '') AND (NOT ListServerIsKnownFidoUser (ReturnAdres,ReturnUser))) THEN
               BEGIN
                    {'You are not connected to '+TempInfo+'; no need to disconnect');}
                    AddToLineBuffer (LineBuffer,GetLang1 (1011,TempInfo));
                    RequestHelp:=TRUE;
                    Continue;
               END;

               { dan zijn er geen excuses meer om 'm niet af te sluiten }
               DeleteListUserRecord (ListUserRecNo);

               {'Disconnected '+ListMainRec.ListName);}
               AddToLineBuffer (LineBuffer,GetLang1 (1012,TempInfo));
               LogExtraMessage ('  Disconnected from mailing-list "'+ListMainRec.ListName+'"');

               Continue;
          END;

          IF (Pos ('HELP',TempInfo) = 1) THEN
          BEGIN
               AddToLineBuffer (LineBuffer,GetLang0 (1040)); { RWI 960225 }
               RequestHelp:=TRUE;
               Continue;
          END;

          IF (Pos ('LIST',TempInfo) = 1) THEN
          BEGIN
               AddToLineBuffer (LineBuffer,GetLang0 (1041)); { RWI 960225 }
               RequestList:=TRUE;
               Continue;
          END;

          { kijk of er een fido tear-line staat }
          IF (Pos ('---',TempInfo) = 1) THEN
             Break; { uit de while, einde bericht }

          {'Unknown command found! ('+TempInfo+')');}
          AddToLineBuffer (LineBuffer,GetLang1 (1030,TempInfo));
          RequestHelp:=TRUE;
      END; { while }

      IF (LineBuffer <> NIL) THEN
      BEGIN
           LogExtraMessage ('  Sending list server reply');
           FidoBuildNetmail (TRUE,OurAdres,ReturnAdres,'ListServer',ReturnUser,GetLang0 (1032));
           MsgsReleaseLines (Msg.BodyTop); { RWI 950723: lekkage opgelost }
           Msg.BodyTop:=LineBuffer;
           LineBuffer:=NIL;
           IF (ReturnEmail <> '') THEN
              MsgsAddFirstLineTo (Body,'To: '+ReturnEMail);
           FidoRouteNetmail;
      END ELSE
          IF (NOT (RequestHelp OR RequestList)) THEN
             LogExtraMessage ('  Nothing to do');

      IF RequestHelp THEN
      BEGIN
           LogExtraMessage ('  Sending list server help information');
           FidoBuildNetmail (TRUE,OurAdres,ReturnAdres,'ListServer',ReturnUser,GetLang0 (1033));
           ListServerSendHelp;
           IF (ReturnEmail <> '') THEN
              MsgsAddFirstLineTo (Body,'To: '+ReturnEMail);
           FidoRouteNetmail;
      END;

      IF RequestList THEN
      BEGIN
           LogExtraMessage ('  Sending available mailing lists');
           FidoBuildNetmail (TRUE,OurAdres,ReturnAdres,'ListServer',ReturnUser,GetLang0 (1034));
           ListServerSendList;
           IF (ReturnEmail <> '') THEN
              MsgsAddFirstLineTo (Body,'To: '+ReturnEMail);
           FidoRouteNetmail;
      END;
END;


{--------------------------------------------------------------------------}
{ ListServerSearchNameCorrect                                              }
{                                                                          }
{ Doorzoek de tabel om te zien of een gegeven naam er een van onze         }
{ listservers is. Name is correct to real list name when found.            }
{                                                                          }
FUNCTION ListServerSearchNameCorrect (VAR Name : STRING) : BOOLEAN;

VAR Hulp   : STRING;
    TmpCRC : LONGINT;
    Tmp    : LSTypePtr;

BEGIN
     ListServerSearchNameCorrect:=FALSE; { assume not found }

     Hulp:=UpCaseString (Name);
     TmpCrc:=UpDateCRC32 ($FFFFFFFF,Hulp[1],Length (Hulp));

     Tmp:=LSNameTable.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (Tmp^.ServerNameCRC = TmpCRC) THEN
          BEGIN
               { laad alvast de gezochte entry in het geheugen }
               ListMainRecNo:=Tmp^.RecNr;
               ReadListBaseRecord (ListMainRecNo,ListMainRec);

               IF ListMainRec.Active THEN
               BEGIN
                    ListServerSearchNameCorrect:=TRUE;
                    Name:=ListMainRec.ListName; { RWI 960226: was "Name" }
               END;

               Exit;
          END; { if, for }

          Tmp:=LSNameTable.GetNextItem;
     END; { while }
END;


{--------------------------------------------------------------------------}
{ ListServerSearchName                                                     }
{                                                                          }
{ Doorzoek de tabel om te zien of een gegeven naam er een van onze         }
{ listservers is.                                                          }
{                                                                          }
FUNCTION ListServerSearchName (Name : STRING) : BOOLEAN;
BEGIN
     ListServerSearchName:=ListServerSearchNameCorrect (Name);
END;


{--------------------------------------------------------------------------}
{ ListServerSearchAreaName                                                 }
{                                                                          }
{ Doorloop de tabel in het geheugen op zoek naar een areaname, zodat       }
{ we kunnen zien of een area naar een newsgroup geconverteerd moet worden. }
{                                                                          }
FUNCTION ListServerSearchAreaName (Name : STRING) : BOOLEAN;

VAR TmpCRC : LONGINT;
    Tmp    : LSTypePtr;

BEGIN
     ListServerSearchAreaName:=FALSE;

     TmpCrc:=UpDateCRC32 ($FFFFFFFF,Name[1],Length (Name));

     Tmp:=LSNameTable.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          IF (Tmp^.AreaNameCRC = TmpCRC) THEN
          BEGIN
               { laad alvast de gezochte entry in het geheugen }
               ListMainRecNo:=Tmp^.RecNr;
               ReadListBaseRecord (ListMainRecNo,ListMainRec);

               IF ListMainRec.Active THEN
                  ListServerSearchAreaName:=TRUE;

               Exit;
          END; { if, for }

          Tmp:=LSNameTable.GetNextItem;
     END;
END;


{--------------------------------------------------------------------------}
{ ListServerIsKnownFidoUser                                                }
{                                                                          }
{ Kontroleert of een fido gebruiker wel op de huidige mailing list is      }
{ aangesloten.                                                             }
{                                                                          }
FUNCTION ListServerIsKnownFidoUser (User : FidoAddrType; Name : STRING) : BOOLEAN;

VAR LocalRec : ListServerRecord;
    LastRec  : ListServerRecordNrType;

BEGIN
     { doe eerst alle fido nodes }
     LocalRec:=ListMainRec;
     Name:=DeleteBackSpaces (UpCaseString (Name));

     WHILE (LocalRec.NextUser <> NILRecordNr) DO
     BEGIN
          LastRec:=LocalRec.NextUser;
          ReadListBaseRecord (LocalRec.NextUser,LocalRec);

          IF (LocalRec.ListSystem <> lstFido) THEN
             Continue;

          IF (Name = UpCaseString (LocalRec.Name)) AND
             FidoCompare (User,LocalRec.Address) THEN
          BEGIN
               ListServerIsKnownFidoUser:=TRUE;
               ListUserRecNo:=LastRec;
               ListUserAccess:=LocalRec.Access;

               { reset this users re-confirmation counter  }
               { even though the user might not be allowed }
               { to post to the list.                      }

               IF Config.LogDebug THEN
                  LogMessage ('Updated confirmation date');

               LocalRec.ConfirmedDate:=GetCurrentUnixTime;
               LocalRec.ConfirmState:=lcOk;

               { write the updated record back to disk }
               WriteListBaseRecord (ListUserRecNo,LocalRec);

               Exit;
          END;
     END; { while }

     ListServerIsKnownFidoUser:=FALSE;
END;


{--------------------------------------------------------------------------}
{ ListServerIsKnownGatewayUser                                             }
{                                                                          }
{ Kontroleert of een remote gateway gebruiker wel op de huidige mailing    }
{ list is aangesloten.                                                     }
{                                                                          }
FUNCTION ListServerIsKnownGatewayUser (Aka : FidoAddrType; User : STRING; EMail: STRING) : BOOLEAN;

VAR LocalRec : ListServerRecord;
    LastRec  : ListServerRecordNrType;

BEGIN
     { doe eerst alle fido nodes }
     LocalRec:=ListMainRec;
     User:=DeleteBackSpaces (UpCaseString (User));
     EMail:=DeleteBackSpaces (UpCaseString (EMail));

     WHILE (LocalRec.NextUser <> NILRecordNr) DO
     BEGIN
          LastRec:=LocalRec.NextUser;
          ReadListBaseRecord (LocalRec.NextUser,LocalRec);

          IF (LocalRec.ListSystem <> lstRemoteGateway) THEN
             Continue;

          IF (User = UpCaseString (LocalRec.GWUser)) AND
             (EMail = UpCaseString (LocalRec.GWEmail)) AND
             FidoCompare (Aka,LocalRec.GWAddress) THEN
          BEGIN
               ListServerIsKnownGatewayUser:=TRUE;
               ListUserRecNo:=LastRec;
               ListUserAccess:=LocalRec.Access;

               { reset this users re-confirmation counter  }
               { even though the user might not be allowed }
               { to post to the list.                      }

               IF Config.LogDebug THEN
                  LogMessage ('Updated confirmation date');

               LocalRec.ConfirmedDate:=GetCurrentUnixTime;
               LocalRec.ConfirmState:=lcOk;

               { write the updated record back to disk }
               WriteListBaseRecord (ListUserRecNo,LocalRec);

               Exit;
          END;
     END; { while }

     ListServerIsKnownGatewayUser:=FALSE;
END;


{--------------------------------------------------------------------------}
{ ListServerIsKnownUsenetUser                                              }
{                                                                          }
{ Controleert of een usenet user wel op de huidige mailing list is         }
{ aangesloten.                                                             }
{                                                                          }
FUNCTION ListServerIsKnownUsenetUser (User : UsenetUserNameString) : BOOLEAN;

VAR LocalRec  : ListServerRecord;
    LastRec   : ListServerRecordNrType;

    InUser,
    InDomain  : STRING;
    LstUser,
    LstDomain : STRING;

BEGIN
     User:=DeleteBackSpaces (UpCaseString (User));
     UsenetSplit (User,InDomain,InUser);

     LocalRec:=ListMainRec;
     WHILE (LocalRec.NextUser <> NILRecordNr) DO
     BEGIN
          LastRec:=LocalRec.NextUser;
          ReadListBaseRecord (LocalRec.NextUser,LocalRec);

          IF (LocalRec.ListSystem <> lstUUCP) THEN
             Continue;

          UsenetSplit (UpCaseString (LocalRec.EMail),LstDomain,LstUser);

          IF (InUser = LstUser) AND (InDomain = LstDomain) THEN
          BEGIN
               ListServerIsKnownUsenetUser:=TRUE;
               ListUserRecNo:=LastRec;
               ListUserAccess:=LocalRec.Access;

               { reset this users re-confirmation counter  }
               { even though the user might not be allowed }
               { to post to the list.                      }

               IF Config.LogDebug THEN
                  LogMessage ('Updated confirmation date');

               LocalRec.ConfirmedDate:=GetCurrentUnixTime;
               LocalRec.ConfirmState:=lcOk;

               { write the updated record back to disk }
               WriteListBaseRecord (ListUserRecNo,LocalRec);

               Exit;
          END;

     END; { while }

     ListServerIsKnownUsenetUser:=FALSE;
END;


{------------------------------------------------------------------------}
{ ListServerEchoList                                                     }
{                                                                        }
{ Geeft terug of het huidige record ook van Echomail naar Mailinglist    }
{ converteerd.                                                           }
{                                                                        }
FUNCTION ListServerEchoList : BOOLEAN;
BEGIN
     ListServerEchoList:=ListMainRec.EchoList;
END;

(*
{--------------------------------------------------------------------------}
{ UsenetMapListToNews                                                      }
{                                                                          }
{ Verspreid een mail bericht ook onder aangesloten news lezers.            }
{                                                                          }
PROCEDURE UsenetMapListToNews;

VAR FindRecord : AreaBaseRecordNrType;
    OldMode    : SystemModeType;

BEGIN
     { zet de news vlag }
     Msg.Ready_U:=News;

     FindRecord:=GetAreaBaseRecordNrByAreaName_U (UpCaseString (ListMainRec.AreaName));
     IF (FindRecord = NILRecordNr) THEN
     BEGIN
          FindRecord:=GetAreaBaseRecordNrByAreaName_F (UpCaseString(ListMainRec.AreaName));
          IF (FindRecord = NILRecordNr) THEN
          BEGIN
               LogMessage ('Warning! Unknown area "'+ListMainRec.AreaName+
                           '" assigned to mailing-list "'+ListMainRec.ListName+'"');
               Exit;
          END;
     END;

     { MsgsExport is hiervan afhankelijk }
     ReadAreaBaseRecord (FindRecord,AreaData);

     { Gooi de oude bericht header weg, maar zet 'm daarna meteen }
     { gedeeltelijk weer terug.                                   }
     MsgsReleaseLines (Msg.HeaderTop_U);

     { RWI 950530: Header line text toegevoegd: From:, Subject:, Message-ID:, Date:, Organization: }
     MsgsAddLineTo (Header_U,'Path: '+UseGetSystemFromName+'!'+ListMainRec.ListName);
     MsgsAddLineTo (Header_U,'From: '+Msg.FromUser_U);
     MsgsAddLineTo (Header_U,'Newsgroups: '+LoCaseString (AreaData.AreaName_U));
     MsgsAddLineTo (Header_U,'Subject: '+Msg.Subj_U);
     MsgsAddLineTo (Header_U,'Message-ID: '+Msg.MsgID_U);
     MsgsAddLineTo (Header_U,'Date: '+Msg.Date_U);
     MsgsAddLineTo (Header_U,'Organization: '+Msg.Organization_U);
     Msg.NewsGroups_U:=': '+LoCaseString (AreaData.AreaName_U)+#13{RWI950217};

     OldMode:=SystemMode;
     SystemMode:=smDISTRIBUTE; { Zorgt ervoor dat we dit bericht niet nogmaals }
                               { proberen te distribueren.                     }

     MsgsExport;
     SystemMode:=OldMode;
END;
*)

{==========================================================================}
{             AREA (ECHOMAIL, NEWS, MESSAGEBASES) DISTRIBUTIE              }
{==========================================================================}


{--------------------------------------------------------------------------}
{ SendEchomail                                                             }
{                                                                          }
{ Deze routine schrijft het opgegeven bericht naar de area waar deze in    }
{ gepost moet worden, als deze mailing list gelinkt is aan een area. Dit   }
{ is nogal tricky, omdat we het bericht niet weer terug willen hebben van  }
{ "dit bericht is in de mailing list related area gepost, distribueer het" }
{ Hiervoor wordt SystemMode op smDISTRUBUTE gezet.                         }
{ Deze routine wordt nooit aangeroepen als het bericht uit de area zelf    }
{ afkomstig is.                                                            }
{                                                                          }
PROCEDURE SendEchomail (AreaRecNr : AreaBaseRecordNrType);

VAR OldMode : SystemModeType;

BEGIN
     (*
     Msg.Area_F:=UpCaseString (ListMainRec.AreaName);
     Msg.Attr_F:=MSGLOCAL; { verwijder andere verdwaalde flags as well }
     *)

     { MsgsExport is hiervan afhankelijk }
     ReadAreaBaseRecord (AreaRecNr,AreaData);

     { zorg ervoor dat het bericht aan ALL gericht wordt
        RAWI 970611: waarom dat? Niet meer..
     Msg.ToUser_F:='All';
     Msg.ToAddr_F:=Config.NodeNrs[ListMainRec.ListAKA];  dit wordt volgens mij niet gebruikt
     }

     { Voeg Tearline + Origin lijn toe }
     {
     MsgsAddlineTo (Footer_F,#13+FidoTear);
     MsgsAddlineTo (Footer_F,FidoBuildOrigin (Config.Origins[1],Config.NodeNrs[ListMainRec.ListAka]));
     }

     MsgsAddFirstLineTo (Body,'');
     MsgsAddFirstLineTo (Body,GetLang1 (1020,ListMainRec.ListName));
     {
     MsgsAddFirstLineTo (Body,ListMainRec.ListName+' at '+Fido2Str (Config.NodeNrs[ListMainRec.ListAKA]));
     MsgsAddFirstLineTo (Body,'This message was distributed by the mailing list:');
     }

     OldMode:=SystemMode;
     SystemMode:=smDISTRIBUTE;

     MsgsExport;

     SystemMode:=OldMode;

     MsgsDeleteFirstRowFromBody;
     MsgsDeleteFirstRowFromBody;
     {MsgsDeleteFirstRowFromBody;}
END;


{===========================================================================}
{                      FIDONET (NETMAIL) DISTRIBUTIE                        }
{===========================================================================}


{--------------------------------------------------------------------------}
{ CB_PrepareNetmail_Header                                                 }
{                                                                          }
{ Deze routine wordt voor iedere regel uit de oude header aangeroepen.     }
{ Als we deze regel nog willen behouden, dan kopieren we em er weer in en  }
{ anders: <poef!>.                                                         }
{                                                                          }
PROCEDURE CB_PrepareNetmail_Header (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,5) = #1'FMPT') THEN
        Exit;

     IF (Copy (Regel,1,5) = #1'TOPT') THEN
        Exit;

     IF (Copy (Regel,1,5) = #1'INTL') THEN
        Exit;

     { RAWI 980208: toegevoegd }
     IF (Copy (Regel,1,6) = #1'FLAGS') THEN
        Exit;

     {RAWI 981125}
     IF (Copy (Regel,1,4) = 'AREA') THEN
        Exit;

     { flags? pid? }

     IF (Copy (Regel,1,6) = #1'MSGID') AND (Regel[Length (Regel)-9] = ' ') THEN
     BEGIN
          { verbouwen! }
          { oppassen: NIET Regel zelf veranderen!!! }
          MsgsAddLineToNoEOL (Header_F,Copy (Regel,1,Length (Regel)-9)+GetFidoPktName+#13);
     END ELSE
         MsgsAddLineToNoEOL (Header_F,Regel);
END;


{--------------------------------------------------------------------------}
{ CB_PrepareNetmail_Footer                                                 }
{                                                                          }
{ Deze routine wordt voor iedere regel uit de oude footer aangeroepen.     }
{ Als we deze regel nog willen behouden, dan kopieren we em er weer in en  }
{ anders: <poef!>.                                                         }
{ De PATH en SEEN-BY regels hoeven we in ieder geval niet. De
{                                                                          }
PROCEDURE CB_PrepareNetmail_Footer (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,7) = 'SEEN-BY') THEN
        Exit;

     IF (Copy (Regel,1,6) = #1'PATH:') THEN
        Exit;

     {RAWI 981125}
     IF (UpCaseString (Copy (Regel,1,4)) = #1'VIA') THEN
        Exit;

     { tear-line eruit bij unreg? }
     { Origin line AKA, is dat een probleem? }

     MsgsAddLineToNoEOL (Footer_F,Regel);
END;


{--------------------------------------------------------------------------}
{ PrepareNetmail                                                           }
{                                                                          }
{ Deze routine prepareert een Netmail bericht dat gedistribueert wordt. De }
{ header wordt even grof verbouwd zodat alle niet gewenste kludges eruit   }
{ zijn en de rest netjes vervangen is zodat het lijkt alsof het bericht    }
{ door dit system gegenereerd is.                                          }
{                                                                          }
PROCEDURE PrepareNetmail (VAR LocalRec : ListServerRecord);

VAR OldLines : TopRegelRecordPtr;

BEGIN
     { verbouw de header }
     OldLines:=Msg.HeaderTop_F;
     Msg.HeaderTop_F:=NIL;

     { we beginnen met wat eigen regels toe te voegen }
     { bouw een nieuwe op voor elk bericht dat we versturen }
     MsgsAddlineTo (Header_F,#1'INTL '+Fido23DStr (LocalRec.Address)+' '+
                                      +Fido23DStr (Config.NodeNrs[ListMainRec.ListAKA]));

     IF (LocalRec.Address.Point > 0) THEN
        MsgsAddLineTo (Header_F,#1'TOPT '+Word2String (LocalRec.Address.Point));

     IF (Config.NodeNrs[ListMainRec.ListAKA].Point > 0) THEN
        MsgsAddLineTo (Header_F,#1'FMPT '+Word2String (Config.NodeNrs[ListMainRec.ListAKA].Point));

     { en nu de oude regels er achteraan }
     MsgsForEach (OldLines,CB_PrepareNetmail_Header);

     { zo... de oude header kan nu weg }
     MsgsReleaseLines (OldLines);

     { nu de footer ------------}

     { bewaar de oude footer en maak de footer daarna leeg }
     OldLines:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;

     { we gaan zelf niets toevoegen, want de originele }
     { tearline en origin line nemen we gewoon over.   }

     { kijk welke regels we nog leuk vinden }
     MsgsForEach (OldLines,CB_PrepareNetmail_Footer);

     { zoo... de oude footer kan nu weg }
     MsgsReleaseLines (OldLines);

     { de tearline die ook onze (c) melding etc bevat }
     { replace tear and stuff...
     MsgsAddLineTo (Footer_F,FidoTear);
     }

     Msg.Ready_F:=Netmail;
END;


{---------------------------------------------------------------------------}
{ SendAllFidonet                                                            }
{                                                                           }
{ Deze routine distribueert de body naar alle op deze mailing lijst         }
{ aangesloten Fidonet style users, behalve naar de originele zender van het }
{ bericht.                                                                  }
{                                                                           }
{ RWI 960202: geeft nu TRUE terug als er ook een mail receiver op deze      }
{             list is aangesloten, zodat we niet onnodig vertalen.          }
{                                                                           }
FUNCTION SendAllFidonet{(FromUser : STRING; FromAddr : FidoAddrType; FromEMail : STRING)} : BOOLEAN;

VAR LocalRec : ListServerRecord;
    MailAlso : BOOLEAN;

BEGIN
     MailAlso:=FALSE;

     { voeg een fido kop toe aan het bericht }

     { let op: dit moet altijd drie regels zijn, want TranslateEchomail2News gaat daar vanuit! }

     MsgsAddFirstLineTo (Body,'');
     MsgsAddFirstLineTo (Body,GetLang1 (1020,ListMainRec.ListName));
     {
     MsgsAddFirstLineTo (Body,ListMainRec.ListName+' at '+Fido2Str (Config.NodeNrs[ListMainRec.ListAKA]));
     MsgsAddFirstLineTo (Body,'This message was distributed by the mailing list:');
     }

     LocalRec:=ListMainRec;
     WHILE (LocalRec.NextUser <> NILRecordNr) DO
     BEGIN
          IF (NOT ReadListBaseRecord (LocalRec.NextUser,LocalRec)) THEN
          BEGIN
               LogExtraMessage ('[ListServer] Error while reading from the database!');
               Exit;
          END;

          { RWI960924 }
          IF (LocalRec.Access = laWriteOnly) THEN
             Continue;

          { controleer of het een Fido user betreft }
          IF (LocalRec.ListSystem = lstFido) THEN
          BEGIN
               { kijk of dit de zender van het bericht zelf is }
               { RWI961208: niet meer doen...
               IF (FromUser = UpCaseString (LocalRec.Name)) AND
                  FidoCompare (FromAddr,LocalRec.Address)
               THEN
                   Continue;
               }

               { Plug ook nieuwe routing informatie in de header }
               Msg.ToUser_F:=LocalRec.Name;
               Msg.ToAddr_F:=LocalRec.Address;

               PrepareNetmail (LocalRec);

               Msg.Routed_F:=0; { RWI 960819 }
               IF (NOT FidoRouteNetmail) THEN
                  LogExtraMessage ('Recipient: "'+LocalRec.Name+'" at '+Fido2Str (LocalRec.Address));

          END; { if Fido system }

          IF (LocalRec.ListSystem = lstRemoteGateway) THEN
          BEGIN
               { kijk of dit de zender van het bericht is }
               { RWI961208: niet meer doen
               IF (FromUser = UpCaseString (LocalRec.GWUser)) AND
                  (FromEMail = UpCaseString (LocalRec.GWEmail)) AND
                  (FidoCompare (FromAddr,LocalRec.GWAddress))
               THEN
                   Continue;
               }

               Msg.ToUser_F:=LocalRec.GWUser;
               Msg.ToAddr_F:=LocalRec.GWAddress;

               MsgsAddFirstLineTo (Body,'To: '+LocalRec.GWEMail);

               PrepareNetmail (LocalRec);

               Msg.Routed_F:=0; { RWI 960819 }
               IF (NOT FidoRouteNetmail) THEN
                  LogExtraMessage ('Recipient: '+LocalRec.GWEmail+
                                   ' via "'+LocalRec.GWUser+'" at '+Fido2Str (LocalRec.GWAddress));

               MsgsDeleteFirstRowFromBody;
          END;

          IF (LocalRec.ListSystem = lstUUCP) THEN
             MailAlso:=TRUE;

     END; { while }

     { verwijder de fido kop weer, want anders staat ie straks ook in de }
     { msgbase of in het usenet bericht.                                 }
     MsgsDeleteFirstRowFromBody;
     MsgsDeleteFirstRowFromBody;
     {MsgsDeleteFirstRowFromBody;}

     SendAllFidonet:=MailAlso;
END;


{==========================================================================}
{                       USENET (MAIL) DISTRIBUTIE                          }
{==========================================================================}


{--------------------------------------------------------------------------}
{ IsMLAddressHeader                                                        }
{                                                                          }
{ Geeft TRUE terug als de header vervangen moet worden.                    }
{                                                                          }
FUNCTION IsMLAddressHeader (Header : STRING) : BOOLEAN;
BEGIN
     IsMLAddressHeader:=TRUE; { assume it's the one! }

     Header:=UpCaseString (Header);

     CASE ListMainRec.MLAddress OF
          laNowhere:;

          laReplyTo:
              IF (Copy (Header,1,10) = 'REPLY-TO: ') THEN
                 Exit;

          laFrom:
              IF (Copy (Header,1,6) = 'FROM: ') THEN
                 Exit;

          laSender:
              IF (Copy (Header,1,8) = 'SENDER: ') THEN
                 Exit;
     END; { case }

     IsMLAddressHeader:=FALSE; { mag behouden worden }
END;

(*
{-------------------------------------------------------------------------}
{ CleanMailHeader_CopyHeader                                               }
{                                                                          }
PROCEDURE CleanMailHeader_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,10) = 'Received: ') THEN
        Exit;

     { Reply-To: gaan we overriden met het adres van de list server }
     IF IsMLAddressHeader (Regel) THEN
        Exit;

     { als dit het vervolg op de Received: header is, dan begint  }
     { deze regel met een spatie of een tab. Als een header regel }
     { te lang was en deze intern afgebroken is, dan begint deze  }
     { regel MISSCHIEN ook met een spatie en gaat ie verloren.    }
     { Pech hoor...                                               }
     IF (Regel[1] IN [' ',#9,'(']) THEN   { RWI 960212: "(" toegevoegd }
        Exit;

     { RWI 960212: nog grover: vervolg regels hebben geen dubbele punt erin! }
     IF (Pos (':',Regel) = 0) THEN
        Exit;

     MsgsAddLineToNoEOL (Header_U,Regel);
END;


{--------------------------------------------------------------------------}
{ CleanMailHeader                                                          }
{                                                                          }
{ Deze routine wordt aangeroepen als een bericht aan de list server is     }
{ gestuurd in Mail vorm. Hier worden alle troep headers weggegooid, zoals  }
{ de Received: headers. Op deze manier gebeurd het maar e'e'n keer, wordt  }
{ de header kleiner en gaat de distributie sneller en gebeurd het goed.    }
{                                                                          }
PROCEDURE CleanMailHeader;

VAR OldLines : TopRegelRecordPtr;

BEGIN
     OldLines:=Msg.HeaderTop_U;
     Msg.HeaderTop_U:=NIL;
     MsgsForEach (OldLines,CleanMailHeader_CopyHeader);
     MsgsReleaseLines (OldLines);
END;
*)

{--------------------------------------------------------------------------}
{ PrepareUsenetMsg_CopyHeader                                              }
{                                                                          }
PROCEDURE PrepareUsenetMsg_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,5) = 'From ') THEN
        Exit; { dumpen die hap }

     IF (Copy (Regel,1,10) = 'Received: ') THEN
        Exit;

     IF IsMLAddressHeader (Regel) THEN
        Exit;

     IF (UpCaseString (Copy (Regel,1,4)) = 'TO: ') AND (Pos ('@'+Config.Domains[1],Regel) > 0) THEN
     BEGIN
          { replace with new mailing list address }
          MsgsAddLineTo (Header_U,'To: '+ListMainRec.ListName+'@'+Config.Domains[1]+
                                  ' (Mailing list '+ListMainRec.ListName+')');
          Exit;
     END;

     { vervolg op "Received: ". Pech bij afgebroken lange regels die }
     { toevallig nog met een spatie beginnen ook.                    }
     IF (Regel[1] = ' ') OR (Regel[1] = #9) THEN
        Exit;

     MsgsAddLineToNoEOL (Header_U,Regel);
END;


{--------------------------------------------------------------------------}
{ PrepareUsenetMesssage                                                    }
{                                                                          }
{ Deze routine bouwt een Usenet e-mail bericht op aan de hand van de body  }
{ van het bericht.                                                         }
{                                                                          }
PROCEDURE PrepareUsenetMessage;

VAR OldLines  : TopRegelRecordPtr;
    ListEmail : STRING;

BEGIN
     OldLines:=Msg.HeaderTop_U;
     Msg.HeaderTop_U:=NIL;

     MsgsAddLineTo (Header_U,'From '+UseGetSystemFromName+'!'+ListMainRec.ListName+' '+UsenetArpanetDate);

     { kopieer de rest, behalve deze From en eventuele Received: kludges }
     MsgsForEach (OldLines,PrepareUsenetMsg_CopyHeader);

     MsgsReleaseLines (OldLines);

     ListEmail:=ListMainRec.ListName+'@'+Config.Domains[1]+' (Mailing list '+ListMainRec.ListName+')';

     CASE ListMainRec.MLAddress OF
          laReplyTo:
              MsgsAddLineTo (Header_U,'Reply-To: '+ListEmail);

          laSender:
              MsgsAddLineTo (Header_U,'Sender: '+ListEmail);

          laFrom:
              MsgsAddLineTo (Header_U,'From: '+ListEmail);

     END; { case }

     Msg.Ready_U:=Mail;
END;


{--------------------------------------------------------------------------}
{ SendAllUsenet                                                            }
{                                                                          }
{ Deze routine stuurt het mailing list bericht naar alle aangesloten       }
{ Usenet systemen, behalve naar de originele zender van het bericht. De    }
{ aanroeper moet er zeker van zijn dat de body geen illegale tekens meer   }
{ bevat.                                                                   }
{                                                                          }
PROCEDURE SendAllUsenet{(Sender : STRING)};

VAR LocalRec  : ListServerRecord;

BEGIN
     MsgsAddFirstLineTo (Body,'');
     MsgsAddFirstLineTo (Body,GetLang1 (1020,ListMainRec.ListName));
     {
     MsgsAddFirstLineTo (Body,ListMainRec.ListName+'@'+Config.Domains[1]);
     MsgsAddFirstLineTo (Body,'This message was distributed by the mailing list:');
     }

     { RW961213: prepare only once now }
     PrepareUsenetMessage;

     { doe eerst alle fido nodes }
     LocalRec:=ListMainRec;
     WHILE (LocalRec.NextUser <> NILRecordNr) DO
     BEGIN
          IF (NOT ReadListBaseRecord (LocalRec.NextUser,LocalRec)) THEN
          BEGIN
               LogExtraMessage ('[ListServer] Error while reading from database! (1)');
               Exit;
          END;

          { controleer of het een Usenet user betreft, maar niet de zender }
          { van het bericht.                                               }
          { RWI961208: nu wel weer een kopie aan de zender sturen }
          IF (LocalRec.ListSystem = lstUUCP) AND
{ RWI960924 }(LocalRec.Access <> laWriteOnly) {AND
             (UpCaseString (LocalRec.Email) <> Sender)} THEN
          BEGIN
               Msg.XqtTo_U:=LocalRec.Email;
               Msg.Routed_U:=0; { RWI 960819 }
               UsenetRouteMail;
          END;
     END; { while }

     { verwijder de toegevoegde rommel weer, want anders staat het er nog }
     { als we voor Fidonet distribueren.                                  }
     MsgsDeleteFirstRowFromBody;
     MsgsDeleteFirstRowFromBody;
     {MsgsDeleteFirstRowFromBody;}
END;


{==========================================================================}
{                             DISTRIBUTION                                 }
{==========================================================================}

{--------------------------------------------------------------------------}
{ ListServerDistributeAsMailOnly                                           }
{                                                                          }
{ Deze routine distribueert het opgegeven mailtje via de mailing list die  }
{ aan de area gekoppeld is waarvan AreaData nu de gegevens bevat.          }
{ Deze routine wordt gebruikt door de news distributie routines.           }
{                                                                          }
PROCEDURE ListServerDistributeAsMailOnly;
BEGIN
     IF (Msg.Ready_U <> Mail) THEN
     BEGIN
          LogMessage ('[ListServerDistributeAsMailOnly] Not in mail format!');
          Exit;
     END;

     (*
     CleanMailHeader; { take out Reply-To }
       gaat mis... hij komt na de lege regel aan het einde vd header
     MsgsAddLineTo (Header_U,'Reply-To: '+ListMainRec.ListName+'@'+Config.Domains[1]);
     *)

     SendAllUsenet{ ('')};
END;


{--------------------------------------------------------------------------}
{ ListServerDistributeAsNetmailOnly                                        }
{                                                                          }
{ Deze routine distribueert het opgegeven netmailtje via de mailing list   }
{ die aan de area gekoppeld is waarvan AreaData nu de gegevens bevat.      }
{                                                                          }
FUNCTION ListServerDistributeAsNetmailOnly : BOOLEAN;

VAR Addr : FidoAddrType;

BEGIN
     { RWI 960929: now allowing Local_Netmail as well }
     IF NOT (Msg.Ready_F IN [Netmail,Local_Netmail]) THEN
     BEGIN
          LogMessage ('[ListServerDistributeAsNetmailOnly] Not in netmail format!');
          ListServerDistributeAsNetmailOnly:=FALSE; { hoeft niet in mail formaat }
          Exit;
     END;

     FidoSplit ('0',Addr);
     ListServerDistributeAsNetmailOnly:=SendAllFidonet{('',Addr,'')};
END;


{--------------------------------------------------------------------------}
{ ListServerDistributeEchomailToNetMail                                    }
{                                                                          }
{ Deze routine wordt aangeroepen als het zeker is dat het huidige bericht  }
{ in Echomail formaat staat. Dit kan eventueel van een newsje vertaald     }
{ zijn en in dat geval staan de approriate kludges erin voor een goede     }
{ reply.                                                                   }
{                                                                          }
PROCEDURE ListServerDistributeEchomailToNetMail;

{VAR Addr : FidoAddrType; { zender adres }

BEGIN
     { RWI 960313: added Local_Echomail }
     IF NOT (Msg.Ready_F IN [Echomail,Local_Echomail]) THEN
     BEGIN
          LogMessage ('[ListServer] Message not in echomail format');
          Exit;
     END;

     { nu kunnen we het bericht distribueren naar Netmail aangeslotenen }
     Msg.ListServer:=TRUE; { ivm de statistiekjes }

     TranslateEchomail2Netmail;

     { fidonet distributie. Met een fake afzender adres waar het bericht }
     { in ieder geval niet naartoe moet.                                 }
     {FidoSplit ('0',Addr);}
     SendAllFidonet{('',Addr,'')};

     { nu vertalen we de boel naar Mail }
     TranslateNetmail2Mail (ListMainRec.ListName+'@'+Config.Domains[1]);

     SendAllUsenet{('')};

     Msg.ListServer:=FALSE;
END;


{--------------------------------------------------------------------------}
{ ListServerDistributeNetMail                                              }
{                                                                          }
{ Deze routine distribueert een bericht dat uit een area afkomstig is (dit }
{ kan zowel echomail als news zijn) naar alle op de lijst aangesloten      }
{ users in mail en netmail formaat. Het bericht kan op dit moment zowel in }
{ news als in echomail formaat staan.                                      }
{                                                                          }
PROCEDURE ListServerDistributeNetMail;

VAR User,
    Domain   : STRING;
    UserName : STRING[MaxLenUser_U];
   {Addr     : FidoAddrType;}

BEGIN
     { RWI 960313: added Local_Echomail check }
     IF (Msg.Ready_F IN [Echomail,Local_Echomail]) THEN
     BEGIN
          ListServerDistributeEchomailToNetMail;
          Exit;
     END;

     { het bericht staat nu in News formaat }

     Msg.ListServer:=TRUE;

     TranslateNews2Mail;

     SendAllUsenet{('')};

     TranslateMail2Netmail (Config.NodeNrs[ListMainRec.ListAKA],
                            ListMainRec.ListName);

     {FidoSplit ('0',Addr);}
     SendAllFidonet{('',Addr,'')};

     Msg.ListServer:=FALSE;
END;


{--------------------------------------------------------------------------}
{ ListServerDistributeMailToAll                                            }
{                                                                          }
{ Deze routine distribueert een mail bericht dat aan een mailing list is   }
{ gestuurd. Als eerst wordt gecontroleerd of de zender wel aan deze lijst  }
{ mag sturen. Als dat zo is krijgen alle subscribers EN de area het        }
{ bericht.                                                                 }
{                                                                          }
{ Deze routine wordt vanuit UsenetRouteMail aangeroepen.                   }
{                                                                          }
PROCEDURE ListServerDistributeMailToAll;

VAR AreaRecNr   : AreaBaseRecordNrType;
    SendingUser : STRING;

BEGIN
     { controleer of de user aangesloten is }
     SendingUser:=UsenetReplyAdres; { RAWI 970611: removed UpCaseString }

     IF (Pos ('MAILER-DAEMON',UpCaseString (UsenetReplyAdres)) > 0) THEN
     BEGIN
          LogMessage ('ListServer: Suspected bounced mail (3) from '+SendingUser);
          IF TranslateMail2Netmail (Config.NodeNrs[1],'List Server') THEN
             FidoWriteMessageToBad;
          MsgsEmpty; { just to be sure }
          Exit;
     END;

     IF (NOT ListServerIsKnownUsenetUser (SendingUser)) THEN
     BEGIN
          { 'You are not connected to the list "'+ListMainRec.ListName+'"'}
          LogMessage ('ListServer: User "'+SendingUser+'" is not subscribed to "'+ListMainRec.ListName+'"');
          UsenetBounceMail (GetLang1 (100{Reason:},GetLang1 (1021,ListMainRec.ListName)));
          Exit;
     END;

     IF (ListUserAccess = laReadOnly) THEN
     BEGIN
          LogMessage ('ListServer: User "'+SendingUser+'" is not allowed to post to "'+ListMainRec.ListName+'"');
          UsenetBounceMail (GetLang1 (100{Reason:},GetLang1 (1022,ListMainRec.ListName)));
          Exit;
     END;

     { distribueren }
     Msg.ListServer:=TRUE; { voor de statistieken: afkomstig uit mailing list }

     MsgsAddLineTo (Header_U,'Reply-To: '+ListMainRec.ListName+'@'+Config.Domains[1]);

     SendAllUsenet{(User zender, daar niet heen sturen)};

     TranslateMail2Netmail (Config.NodeNrs[Config.GatewayAKA],ListMainRec.ListName);

     { nu distribueren via netmail. We geven een foo naam en adres op }
     { waar het mailtje in ieder geval niet naartoe moet, omdat dat   }
     { de afzender is.                                                }
     {FidoSplit ('0',Addr);}
     SendAllFidonet{('',Addr,'')};

     { bestaat er een koppeling? }
     IF (ListMainRec.ListEcho) AND (ListMainRec.AreaName <> '') THEN
     BEGIN
          AreaRecNr:=GetAreaBaseRecordNrByAreaName_F (UpCaseString (ListMainRec.AreaName));

          IF (AreaRecNr = NILRecordNr) THEN
          BEGIN
               LogMessage ('ListServer: Unknown area "'+ListMainRec.AreaName+
                           '" assigned to mailing-list "'+ListMainRec.ListName+'"');
               LogExtraMessage ('The message will be distributed, but not sent to the area');
          END ELSE
          BEGIN
               TranslateNetmail2Echomail (AreaRecNr);
               SendEchomail (AreaRecNr);
          END;
     END;

     Msg.ListServer:=FALSE; { weer normaal tellen in de statistieken }
END;


{--------------------------------------------------------------------------}
{ ListServerDistributeNetmailToAll                                         }
{                                                                          }
{ Deze routine distribueert een netmail bericht dat aan een mailing list   }
{ is gestuurd naar alle aangesloten users in mail en netmail formaat en    }
{ naar de area die hieraan gekoppeld is. Voordat dat gebeurd wordt eerst   }
{ gecontroleerd of de zender van het bericht wel een member van deze lijst }
{ is.                                                                      }
{ Distributie wijze voor Netmail: Netmail, Echo, News, Mail.               }
{                                                                          }
{ Deze routine wordt aangeroepen door FidoRouteNetmail.                    }
{                                                                          }
PROCEDURE ListServerDistributeNetmailToAll;

VAR FromAddr  : FidoAddrType;
    FromUser  : STRING[MaxLenFromUser_F];
    FromEMail : STRING[MaxLenDomain];
    AreaRecNr : AreaBaseRecordNrType;
    MailAlso  : BOOLEAN;

BEGIN
     Msg.ListServer:=TRUE; { ivm de statistiekjes }

     { hier niet naar terug sturen }
     IF (Msg.ReplyEMail <> '') AND (Msg.ReplyUser <> '') THEN
     BEGIN
          { het echte email adres in dit bericht is slechts de }
          { transporteur vanaf de gateway.                     }
          FromAddr:=Msg.ReplyAKA;
          FromUser:=Msg.ReplyUser;
          FromEMail:=Msg.ReplyEMail;

          { check for bounced mail }
          IF (Pos ('MAILER-DAEMON',UpCaseString (FromEMail)) > 0) THEN
          BEGIN
               LogMessage ('ListServer: Suspected bounced mail (2) from '+FromEMail);
               IF TranslateMail2Netmail (Config.NodeNrs[1],'Mailing list') THEN
                  FidoWriteMessageToBad;
               MsgsEmpty; { just to be sure }
               Exit;
          END;

          { controleer eerst of de zender wel op de lijst is aangesloten }
          IF (NOT ListServerIsKnownGatewayUser (FromAddr,FromUser,FromEMail)) THEN
          BEGIN
               {'You are not connected to the list "'+ListMainRec.ListName+'"');}
               FidoBounceNetmail ('ListServer',FALSE,GetLang1 (1021,ListMainRec.ListName));
               Exit;
          END;

          IF (ListUserAccess = laReadOnly) THEN
          BEGIN
               FidoBounceNetmail ('ListServer',FALSE,GetLang1 (1022,ListMainRec.ListName));
               Exit;
          END;

          LogMessage ('Found netmail for mailing list "'+ListMainRec.ListName+
                      '" from '+FromEmail+' via "'+FromUser+'"%'+Fido2Str (FromAddr));
     END ELSE
     BEGIN
          FromAddr:=Msg.FromAddr_F;
          FromUser:=UpCaseString (Msg.FromUser_F);
          FromEMail:='';

          { controleer eerst of de zender wel op de lijst is aangesloten }
          IF (NOT ListServerIsKnownFidoUser (FromAddr,FromUser)) THEN
          BEGIN
               {'You are not connected to the list "'+ListMainRec.ListName+'"');}
               FidoBounceNetmail ('ListServer',FALSE,GetLang1 (1021,ListMainRec.ListName));
               Exit;
          END;

          IF (ListUserAccess = laReadOnly) THEN
          BEGIN
               FidoBounceNetmail ('ListServer',FALSE,GetLang1 (1022,ListMainRec.ListName));
               Exit;
          END;

          LogMessage ('Found netmail for mailing list "'+ListMainRec.ListName+
                      '" from "'+Msg.FromUser_F+'"%'+Fido2Str (FromAddr));
     END;

     MailAlso:=SendAllFidonet{(FromUser,FromAddr,FromEMail)}; { niet naar die user }

     { bestaat er een koppeling? }
     IF (ListMainRec.ListEcho) AND (ListMainRec.AreaName <> '') THEN
     BEGIN
          AreaRecNr:=GetAreaBaseRecordNrByAreaName_F (UpCaseString (ListMainRec.AreaName));

          IF (AreaRecNr = NILRecordNr) THEN
          BEGIN
               LogMessage ('[ListServer] Unknown area "'+ListMainRec.AreaName+
                           '" assigned to mailing-list "'+ListMainRec.ListName+'"');
               LogExtraMessage ('The message will be distributed, but not sent to the area');
          END ELSE
          BEGIN
               TranslateNetmail2Echomail (AreaRecNr);
               SendEchomail (AreaRecNr);

               { als ie nog niet vertaald is naar news, doe het dan alsnog }
               IF (Msg.Ready_F = Echomail) AND (Msg.Ready_U <> News) THEN
                  TranslateEchomail2News;

               TranslateNews2Mail;
          END;
     END;

     { RWI 960929: added MailAlso check }
     IF MailAlso THEN
     BEGIN
          { RWI 960929: added Local_Netmail check }
          IF (Msg.Ready_F IN [Netmail,Local_Netmail]) THEN
             { vertaling naar de area is niet uitgevoerd }
             TranslateNetmail2Mail (ListMainRec.ListName+'@'+Config.Domains[1]);

          SendAllUsenet{('')};
     END;

     Msg.ListServer:=FALSE; { bericht komt niet meer van de list server }
END;


{--------------------------------------------------------------------------}
{ SendReconfirmMessage                                                     }
{                                                                          }
{ Tijd om een re-confirm message te sturen.                                }
{                                                                          }
PROCEDURE SendReconfirmMessage;

VAR Desc : STRING;
    Days : BYTE;

BEGIN
     { omschrijving opbouwen }
     CASE ListUserRec.ListSystem OF
          lstFido :
              Desc:=ListUserRec.Name+' at '+Fido2Str (ListUserRec.Address);

          lstUUCP :
              Desc:=ListUserRec.Email;

          lstRemoteGateway :
              Desc:=ListUserRec.GWEmail+
                    ' via '+ListUserRec.GWUser+
                    ' at '+Fido2Str (ListUserRec.GWAddress);

          ELSE Exit;
     END; { case }

     { als de state nu op Try3 staat, dan mogen we 'deze user verwijderen }
     IF (ListUserRec.ConfirmState = lcReq3) THEN
     BEGIN
          LogMessage ('  Removing '+Desc);
          DeleteListUserRecord (ListUserRecNo);
          Exit;
     END;

     { als we nu ok Ok staan, bereken dan een nieuwe code }
     { om de kans op dubbele codes te voorkomen berekenen we een CRC32 }
     { over het hele user record, waar dus ook de adres informatie in  }
     { zit. Omdat de ConfirmedDate steeds veranderd krijgt de user     }
     { niet dezelfde code. Een record nummer erin stoppen heeft geen   }
     { zin omdat een WtrUtil Database alle records kan opschuiven na   }
     { een delete.                                                     }
     IF (ListUserRec.ConfirmState = lcOk) THEN
        ListUserRec.ConfirmCode:=UpdateCRC32 (0,ListUserRec,SizeOf (ListUserRec));

     { current date is the last request sent date }
     ListUserRec.ConfirmReqDate:=GetCurrentUnixTime;

     { increase the current state from OK to Try1 to Try2 to Try3 }
     Inc (ListUserRec.ConfirmState);
     LogMessage ('  Request '+Byte2String (Byte (ListUserRec.ConfirmState)-Byte (lcOk))+' to '+Desc);

     WriteListBaseRecord (ListUserRecNo,ListUserRec);

     { schrijf het bericht }
     CASE ListUserRec.ListSystem OF
          lstFido:
              BEGIN
                   { netmail schrijven }
                   InitTokens (_F);
                   FidoBuildNetmail (TRUE,
                                     Config.NodeNrs[ListMainRec.ListAKA],
                                     ListUserRec.Address,
                                     'ListServer',
                                     ListUserRec.Name,
                                     GetLang0 (1035));
                   MsgsAddLineTo (Body,'');
              END;

          lstUUCP:
              BEGIN
                   { e-mail schrijven }
                   InitTokens (_U);
                   UsenetBuildMail (ListUserRec.Email,
                                    'listserver',
                                    GetLang0 (1031),
                                    GetLang0 (1035));
              END;

          lstRemoteGateway:
              BEGIN
                   { netmail schrijven }
                   InitTokens (_F);
                   FidoBuildNetmail (TRUE,
                                     Config.NodeNrs[ListMainRec.ListAKA],
                                     ListUserRec.GWAddress,
                                     'ListServer',
                                     ListUserRec.GWUser,
                                     GetLang0 (1035));
                   MsgsAddLineTo (Body,'To: '+ListUserRec.GWEmail);
                   MsgsAddLineTo (Body,'');
              END;
     END; { case }

     MsgsAddLineTo (Body,'CONFIRM '+Long2HexString (ListUserRec.ConfirmCode));
     MsgsAddLineTo (Body,'');

     Days:=2+2*(Byte (lcReq3)-Byte (ListUserRec.ConfirmState));
     SetToken (DaysLeft,Byte2String (Days));

     IF (NOT AddFileToMsg (Msg.BodyTop,'LSTRECNF.TXT')) THEN
     BEGIN
          MsgsAddLineTo (Body,'To remain subscribed to the mailing list above you must send');
          MsgsAddLineTo (Body,'a reply at once. Put a single line in the body with the command');
          MsgsAddLineTo (Body,'CONFIRM and the code indicated above. You can quote-reply to');
          MsgsAddLineTo (Body,'this message for your convenience. You will be removed from the');
          MsgsAddLineTo (Body,'list if you don''t reply within '+Byte2String (Days)+' days.');
     END;

     IF (Msg.Ready_F = Netmail) THEN
        FidoRouteNetmail
     ELSE
         UsenetRouteMail;

     MsgsEmpty;
END;


{--------------------------------------------------------------------------}
{ ListReconfirmCheck                                                       }
{                                                                          }
{ Deze routine loopt alle mailing lists en users af en kijkt of een        }
{ re-confirm voor die user noodzakelijk is.                                }
{                                                                          }
PROCEDURE ListReconfirmCheck;

VAR Tmp       : LSTypePtr;
    CurrentUT : LONGINT;
    First     : BOOLEAN;
    NextRecNr : ListServerRecordNrType;

BEGIN
     CurrentUT:=GetCurrentUnixTime;
     First:=TRUE;

     { doorloop de tabel met mailing list definitions }
     Tmp:=LSNameTable.GetFirstItem;
     WHILE (Tmp <> NIL) DO
     BEGIN
          { lees het list server record in }
          ListMainRecNo:=Tmp^.RecNr;
          IF ReadListBaseRecord (ListMainRecNo,ListMainRec) THEN
             IF (ListMainRec.ConfirmInterval <> 0) THEN
             BEGIN
                  { confirmation mechanism is enabled }
                  IF First THEN
                  BEGIN
                       LogMessage ('Checking mailing list re-confirmations');
                       First:=FALSE;
                  END;

                  { doorloop alle subscribers van deze lijst }

                  { construction with NextRecNr is required because }
                  { DeleteListUser set Rec.NextUser to NILRecordNr, }
                  { otherwise aborting this loop.                   }
                  NextRecNr:=ListMainRec.NextUser;
                  WHILE (NextRecNr <> NILRecordNr) DO
                  BEGIN
                       ListUserRecNo:=NextRecNr;
                       ReadListBaseRecord (ListUserRecNo,ListUserRec);
                       NextRecNr:=ListUserRec.NextUser;

                       { following check has to trigger                  }
                       { 1) only if ConfirmState <> Never                }
                       { 2) when confirm has never been issued           }
                       {    (confirmeddate = 0)                          }
                       { 3) ConfirmInterval days after the ConfirmedDate }
                       { 4) Every two days after the first confirm req.  }

                       { note: deleting is done in SendReconfirmMessage  }
                       CASE ListUserRec.ConfirmState OF
                            lcNever:;

                            lcOk:
                                IF (ListUserRec.ConfirmedDate = 0) OR
                                   (CurrentUT > ListUserRec.ConfirmedDate+SEC_Dag*Longint (ListMainRec.ConfirmInterval))
                                THEN
                                    SendReconfirmMessage;

                            ELSE
                                IF (CurrentUT > ListUserRec.ConfirmReqDate+Longint (2)*SEC_Dag) THEN
                                   SendReconfirmMessage;
                       END; { case }
                  END; { while }
             END;

          Tmp:=LSNameTable.GetNextItem;
     END; { while }
END;


{--------------------------------------------------------------------------}
{ JunkListServerTable                                                      }
{                                                                          }
{ Cleans up memory usage afterwards.                                       }
{                                                                          }
PROCEDURE JunkListServerTable;
BEGIN
     LSNameTable.Clear;
END;


{--------------------------------------------------------------------------}
{ Unit Initialization                                                      }
{                                                                          }
BEGIN
     LSNameTable.Init (SizeOf (LSType),NIL);
END.
