/**********************************************************************
  Copyright (c) 2000-2003,2009 Michael Dillon
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

       Redistributions of source code must retain the above copyright 
       notice, this list of conditions and the following disclaimer. 

       Redistributions in binary form must reproduce the above 
       copyright notice, this list of conditions and the following 
       disclaimer in the documentation and/or other materials provided 
       with the distribution. 

       Neither the name of Crystalline Realms, Midnight's Hour BBS
       nor the names of their contributors may be used to endorse or
	   promote products derived from this software without specific
	   prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/
/*********************************************************************
 parse.cpp - Functions for reading the configuration file.
 *********************************************************************/
#include "tinytic.h"
#include "parse.h"
#include "ticlog.h"
#include "tprocess.h"

string szConfigFile = "tinytic.cfg";

// Define the strings
string Inbound;
string DataFile;
string LogFile;

bool ReadConfigFile(void)
{
        string Log;
        string szTmp;
        char szTmpBuffer[ BUFFER_MAXLEN ] = "\x0";
        ifstream fConfig;

        fConfig.open(szConfigFile.c_str(), ios::in);

        if (!fConfig)
        {
                cerr << "Unable to open " << szConfigFile.c_str() << "!" << endl;
                cerr << "Make sure this file is in the same directory as this program." << endl;
               
                return (false);
        }


        while (!fConfig.eof())
        {
                fConfig >> ws >> szTmpBuffer;
                if (*szTmpBuffer == '#' || *szTmpBuffer == ';')
                {
                        // This is commments, ignore
                        fConfig.getline(szTmpBuffer, BUFFER_MAXLEN);
                }
                else
                {
                        if (stricmp(szTmpBuffer, "Inbound") == 0)
                        {
                                // Inbound directory specified
                                fConfig >> ws >> szTmpBuffer;
                                Inbound = szTmpBuffer;

                                if ((Inbound == "") || (VerifyDirectory(Inbound.c_str()) == false))
                                {
#if defined(__TINYTIC_WINDOWS) || defined(__TINYTIC_OS2)
                                        Inbound = ".\\";
#elif defined(__TINYTIC_POSIX)
                                        Inbound = "./";
#endif
                                }
                                        
                                Log  = "Checking for .TIC files in \'";
                                Log += szTmpBuffer;
                                Log += "\'.";
                                PutLog(Log.c_str(), INFO);
                        }
                        else if (stricmp(szTmpBuffer, "DataFile") == 0)
                        {
                                // DataFile directory/file specified
                                fConfig >> ws >> szTmpBuffer;
								
                                // do not continue if the DataFile has already been defined
								// This block of code will ignore any other "DataFile" entries in the config file
								// regardless of failure or not
								if (DataFile == "")
								{
										if (VerifyFileUsable(szTmpBuffer) == false)
										{
										     Log = "Unable to use the defined 'DataFile': ";
											 Log += szTmpBuffer;
											 PutLog( Log.c_str(), INFO );
											 
#if defined(__TINYTIC_WINDOWS) || defined(__TINYTIC_OS2)
                                             DataFile = ".\\tinytic.dat";
#elif defined(__TINYTIC_POSIX)
                                             DataFile = "./tinytic.dat";
#endif
                                        }
										else
										{
										     DataFile = szTmpBuffer;
											 
                                             Log = "Saving new entries to \'";
                                             Log += szTmpBuffer;
                                             Log += "\'.";
                                             PutLog( Log.c_str(), INFO );
									    }
                                }
                        }
                        else if (stricmp(szTmpBuffer, "LogFile") == 0)
                        {
                                // DataFile directory/file specified
                                fConfig >> ws >> szTmpBuffer;

                                if (szLogFile == "")
								{
								        if (VerifyFileUsable(szTmpBuffer) == false)
										{
										        cout << "Unable to use the log file `"
												     << szTmpBuffer << "'."
													 << endl;
#if defined(__TINYTIC_WINDOWS) || defined(__TINYTIC_OS2)
                                                szLogFile = ".\\tinytic.log";
#elif defined(__TINYTIC_POSIX)
                                                szLogFile = "./tinytic.log";
#endif
                                        }
										else
										{
										        szLogFile = szTmpBuffer;
												
                                                cout << "Using LogFile \'"
                                                     << szLogFile.c_str()
                                                     << "\'."
                                                     << endl;
										}
								}
                        }
                        else
                        {
                                fConfig.getline(szTmpBuffer, BUFFER_MAXLEN);
                        }
                }
        }

        fConfig.close();

        return (true);
}

