{$O+,F+,I-}
UNIT RWUP;

(* 

    RWUP - ReneWave .NEW (Blue Wave reply) processing

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


VAR  PdqFile   : FILE;
     ReplyFile : FILE;


PROCEDURE RWU_InitFiles;
PROCEDURE RWU_DeInitFiles;
FUNCTION  RWU_CheckDupes:Boolean;
PROCEDURE RWU_AddTear(VAR TSize:Word; AkaNum:Byte);
FUNCTION  RWU_TearStr:String;
PROCEDURE RWU_UpdateStats;
PROCEDURE RWU_ProcPacket;
PROCEDURE RWU_ProcReplies;


IMPLEMENTATION


USES {$I FOSSTYPE.INC }

     DOS,      CRT,      MISC1,    MYSHARE,  CRC32,    MSTRINGS,
     UNIXDATE, RWBT,     RWACS,    RWMAIN,   RWLOGS,
     RWINIT,   MSRGGEN,  RWAREAS,  RWVARS,   SPIN,     BWSTRUCT,
     RWSTRUCT, RECORDS,  MSBWGEN,  RWUP2;


VAR  ProcPdq,
     ProcFReq,
     ProcOlc,
     ProcUPL       : Boolean;


PROCEDURE RWU_InitFiles;
VAR BaseFile:String;
BEGIN
   BaseFile := RwWorkDir+RwConfig.BBSID;
   Assign(ReplyFile,BaseFile+'.UPL');
   Reset(ReplyFile,1);
   ProcOlc  := FExists(BaseFile+'.OLC');
   ProcPdq  := FExists(BaseFile+'.PDQ') AND NOT ProcPdq;
   ProcFreq := FExists(BaseFile+'.REQ');
   FillChar(ServerReq,SizeOf(ServerReq),0);
   ServerReqNum := 0;
END;


PROCEDURE RWU_DeInitFiles;
BEGIN
   IF FileRec(ReplyFile).Mode  <> fmClosed THEN Close(ReplyFile);  IF IOResult <> 0 THEN ;
   IF FileRec(PdqFile).Mode    <> fmClosed THEN Close(PdqFile);    IF IOResult <> 0 THEN ;
   IF FileRec(bwFreqFile).Mode <> fmClosed THEN Close(bwFreqFile); IF IOResult <> 0 THEN ;
END;


PROCEDURE RWU_DupesDeInit(VAR DupesFile:FILE);
BEGIN
   IF FileRec(DupesFile).Mode <> fmClosed THEN Close(DupesFile); IF IOResult <> 0 THEN ;
END;


PROCEDURE RWU_DupesInit(VAR DupesFile:FILE);
BEGIN
   Assign(DupesFile,RwConfig.RwMainDir+'DUPES.RW');
   IF FExists(RwConfig.RwMainDir+'DUPES.RW')
      THEN Reset(DupesFile,SizeOf(DupeRec))
      ELSE Rewrite(DupesFile,SizeOf(DupeRec));
END;


PROCEDURE RWU_DupeBuffRead(VAR DupesFile:File);
BEGIN
   Seek(DupesFile,DupesFilePos);
   BlockRead(DupesFile,DupeRecBuff^,DupesMax,DupeBuffLen);
   DupesFilePos := DupesFilePos + DupeBuffLen;
END;


FUNCTION RWU_CheckDupes:Boolean;
VAR Dupe:DupeRec; Counter:Word; DupesFile:FILE;
BEGIN
   Dupe.Crc := $FFFFFFFF;
   Dupe.Crc := StringUpdateCrc(MsgHdr.From.As,Dupe.Crc);
   Dupe.Crc := StringUpdateCrc(MsgHdr.mTo.As,Dupe.Crc);
   Dupe.Crc := StringUpdateCrc(MsgHdr.Subject,Dupe.Crc);
   Dupe.Crc := StringUpdateCrc(Nul2Str(Reply.EchoTag,21),Dupe.Crc);
   Dupe.Crc := StringUpdateCrc(Nul2Str(Reply.FileName,12),Dupe.Crc);

   Dupe.Crc := LongIntUpdateCrc(MsgHdr.mTo.Zone,Dupe.Crc);
   Dupe.Crc := LongIntUpdateCrc(MsgHdr.mTo.Net,Dupe.Crc);
   Dupe.Crc := LongIntUpdateCrc(MsgHdr.mTo.Node,Dupe.Crc);
   Dupe.Crc := LongIntUpdateCrc(MsgHdr.mTo.Point,Dupe.Crc);

   FOR Counter := 1 TO MsgTxtBuffSize DO Dupe.Crc:= UpdC32(Ord(MsgTxtBuff^[Counter]),Dupe.Crc);

   RWU_DupesInit(DupesFile);
   IF FileSize(DupesFile) > 0 THEN
      BEGIN
         DupesFilePos := 0;
         WHILE DupesFilePos <= (FileSize(DupesFile)-1) DO
            BEGIN
               RWU_DupeBuffRead(DupesFile);
               FOR DupeBuffPos := 1 TO DupeBuffLen DO
                  IF (DupeRecBuff^[DupeBuffPos].CRC = Dupe.CRC) THEN
                     BEGIN
                        RWU_CheckDupes := TRUE;
                        RWU_DupesDeInit(DupesFile);
                        Exit;
                     END;
            END;
      END;
   Seek(DupesFile,FileSize(DupesFile));
   BlockWrite(DupesFile,Dupe,1,BytesWritten);

   RWU_DupesDeInit(DupesFile);
   RWU_CheckDupes := FALSE;
END;


FUNCTION RWU_TearStr:String;
VAR s:String;
BEGIN
   s := 'ReneWave v'+RwVer;
   IF Regd THEN s := s+'+' ELSE s := s+' [NR]';
   RWU_TearStr := s;
END;


PROCEDURE RWU_AddTear(VAR TSize:Word; AkaNum:Byte);
VAR OneLine:String;
BEGIN
   IF (Regd=FALSE) OR RwConfig.BragLine OR (MsRg_MArea.mbType = 0) OR (MsRg_MArea.mbType = 10) THEN
      BEGIN
         OneLine := '~~~ '+RWU_TearStr;
         TSize := TSize+1+Length(OneLine);
         BlockWrite(Dat,OneLine,Length(OneLine)+1,BytesWritten);
      END;

   IF (MsRg_MArea.mbType <> 0) AND (MsRg_MArea.mbType <> 10) THEN
      IF (mbAddTear IN MsRg_MArea.mbStat) THEN
         WITH MsRg_MArea,MsRg_General.Aka[AkaNum] DO
            BEGIN
               OneLine := '--- '+RwConfig.TearLine;
               TSize := TSize+1+Length(OneLine);
               BlockWrite(Dat,OneLine,Length(OneLine)+1,BytesWritten);
               OneLine := ' * Origin: '+Origin+' (' +StrFunc(Zone)+':' +StrFunc(Net)+'/' +StrFunc(Node);
               IF (Point > 0) THEN OneLine := OneLine + '.'+StrFunc(Point);
               OneLine := OneLine + ')' + #13;
               TSize := TSize+1+Length(OneLine);
               BlockWrite(Dat,OneLine,Length(OneLine)+1,BytesWritten);
            END;
END;


PROCEDURE RWU_UpdateStats;
BEGIN
   MsRg_UserFileOpen;
   MsRg_UserFileRead(RgUserNum);

   MsRg_User.EmailSent  := MsRg_User.EmailSent  + RePinfo^.RepEmail;
   MsRg_User.MsgPost    := MsRg_User.MsgPost    + RepInfo^.RepPublic;
   MsRg_User.Downloads  := MsRg_User.Downloads  + RepInfo^.RepDownloads;
   MsRg_User.dlToday    := MsRg_User.DlToday    + RepInfo^.RepDownloads;
   MsRg_User.DK         := MsRg_User.DK         + RepInfo^.RepDownloadK;
   MsRg_User.dlkToday   := MsRg_User.dlkToday   + RepInfo^.RepDownloadK;
   MsRg_User.Debit      := MsRg_User.Debit      + RepInfo^.RepFilePts;

   IF RwConfig.CreditsEmail  >= 0
      THEN MsRg_User.Credit := MsRg_User.Credit + (RwConfig.CreditsEmail * RepInfo^.RepEmail)
      ELSE MsRg_User.Debit  := MsRg_User.Debit  - (RwConfig.CreditsEmail * RepInfo^.RepEmail);

   IF RwConfig.CreditsPublic >= 0
      THEN MsRg_User.Credit := MsRg_User.Credit + (RwConfig.CreditsPublic * RepInfo^.RepPublic)
      ELSE MsRg_User.Debit  := MsRg_User.Debit  - (RwConfig.CreditsPublic * RepInfo^.RepPublic);

   MsRg_UserFileWrite(RgUserNum);
   MsRg_UserFileClose;

   MsRg_HistFileOpen;
   MsRg_HistFileRead(FileSize(MsRg_HistFile)-1);

   MsRg_History.Posts     := MsRg_History.Posts     + RepInfo^.RepPublic;
   MsRg_History.Email     := MsRg_History.Email     + RepInfo^.RepEmail;
   MsRg_History.Downloads := MsRg_History.Downloads + RepInfo^.RepDownloads;
   MsRg_History.dk        := MsRg_History.dk        + RepInfo^.RepDownloadK;

   MsRg_HistFileWrite(FileSize(MsRg_HistFile)-1);
   MsRg_HistFileClose;

   MsRg_GeneralRead;
   MsRg_General.TotalPosts := MsRg_General.TotalPosts + RepInfo^.RepPublic;
   MsRg_GeneralWrite;

   FillChar(RepInfo^,SizeOf(RepInfo^),0);
END;


PROCEDURE RWU_ProcPacket;
BEGIN
   RWM_KeyPressOff;
   RWU_InitFiles;
   IF (FileSize(ReplyFile) > SizeOf(UplHeader)) THEN RWU_ProcReplies;

   IF ProcPdq  THEN RWU_ProcNewConfig;
   IF ProcOlc  THEN RWU_ProcOlc;
   IF ProcFReq THEN RWU_ProcFREQ;

   IF (ServerReqNum > 0) THEN RWU_ProcServerReq;

   RWM_KeyPressOn;
END;


PROCEDURE RWU_ProcReplies;
VAR NumRecs,
    ThisReply   : Word;
    EchoTag     : String[21];
    BaseFile    : String[80];
    UseAkaNum   : Byte;
    IsInet      : Boolean;
    InetTo      : String[80];

    PROCEDURE ConvText;
    BEGIN
       Assign(Dat,BaseFile+'.DAT');
       IF FExists(BaseFile+'.DAT') THEN Reset(Dat,1) ELSE Rewrite(Dat,1);
       Seek(Dat,FileSize(Dat));
       MsgHdr.Pointer := FilePos(Dat)+1;
       MsgHdr.TextSize := MsgTxtBuffSize;
       BlockWrite(Dat,MsgTxtBuff^,MsgTxtBuffSize,BytesWritten);
       RWU_AddTear(MsgHdr.TextSize,MsRg_MArea.Aka);
       MsgHdr.OriginDate := 'Local';
       Close(Dat);
    END;

    PROCEDURE LoadText;
    VAR f:File; MsgText:Text; OneLine:String; BuffPos:Word;
    BEGIN
       { Add a CR/LF to the end of the file }
       Assign(f,RwWorkDir+MsgTextName);
       Reset(f,1);
       OneLine := #13#10;
       Seek(f,FileSize(f));
       BlockWrite(f,OneLine[1],2,BytesWritten);
       Close(f);

       { Process the file }
       Assign(MsgText,RwWorkDir+MsgTextName);
       Reset(MsgText);
       MsgTxtBuffSize := 0;
       WHILE NOT Eof(MsgText) DO
          BEGIN
             ReadLn(MsgText,OneLine);
             MsgTxtBuffSize := MsgTxtBuffSize+Length(OneLine)+1;
          END;
       Reset(MsgText);
       BuffPos := 1;
       WHILE NOT Eof(MsgText) DO
          BEGIN
             ReadLn(MsgText,OneLine);
             Move(OneLine[0],MsgTxtBuff^[BuffPos],Length(OneLine)+1);
             BuffPos := BuffPos+Length(OneLine)+1;
          END;
       Close(MsgText);
       MsgHdr.TextSize := MsgTxtBuffSize;
    END;

    PROCEDURE LoadTextInet;
    BEGIN
       LoadText;
       IF (Length(InetTo) > 35) OR NOT RwConfig.InetUseTo THEN
          BEGIN
             MsgHdr.mTo.As := 'UUCP';
             MsgHdr.mTo.Real := 'UUCP';
             MsgHdr.mTo.Name := 'UUCP';
             InetTo := 'To: '+InetTo;
             InetTo[Length(InetTo)+1] := #0;
             IF LongInt(MsgTxtBuffSize)+Length(INetTo)+2 >= MaxMsgBuffSize
                THEN MsgTxtBuffSize := MaxMsgBuffSize-Length(InetTo)-2;
             MsgTxtBuffSize := MsgTxtBuffSize+Length(InetTo)+2;
             Move(MsgTxtBuff^[1],MsgTxtBuff^[Length(InetTo)+2+1],MsgTxtBuffSize-Length(InetTo)-2);
             Move(InetTo[0],MsgTxtBuff^[1],Length(InetTo)+2);
          END;
    END;

    PROCEDURE DoNetmail;
    BEGIN
       WITH Reply,MsgHdr DO
          BEGIN
             UseAkaNum := RWM_AKAMatch(DestZone,DestNet,DestNode,DestPoint);
             {...}
             IF NOT EvalAcs(RwConfig.AnyNameNetmail) THEN
                CASE RwConfig.NTypeNetmail OF
                   NameAlias  : MsgHdr.From.As := MsRg_User.Name;
                   NameReal   : MsgHdr.From.As := MsRg_User.RealName;
                   NameEither : IF UpcaseStr(MsgHdr.From.As) <> UpcaseStr(MsRg_User.RealName)
                                   THEN MsgHdr.From.As := MsRg_User.Name;
                END;
             CreateSem    := TRUE;
             Status       := Status+[Netmail];
             NetAttribute := [];

             IF (Crash    IN RwConfig.DefaultNetAttr) THEN NetAttribute := NetAttribute + [Crash];
             IF (Hold     IN RwConfig.DefaultNetAttr) THEN NetAttribute := NetAttribute + [Hold];
             IF (KillSent IN RwConfig.DefaultNetAttr) THEN NetAttribute := NetAttribute + [KillSent];
             IF (Local    IN RwConfig.DefaultNetAttr) THEN NetAttribute := NetAttribute + [Local];
             IF (Private  IN RwConfig.DefaultNetAttr) THEN NetAttribute := NetAttribute + [Private];

             IF (UplCrash     IN NetAttr) AND EvalAcs(RwConfig.ACS_Crash) THEN NetAttribute:=NetAttribute+[Crash];
             IF (UplFile      IN NetAttr) AND EvalAcs(RwConfig.ACS_FAttach) THEN NetAttribute:=NetAttribute+[FileAttach];
             IF (UplKillSent  IN NetAttr) AND EvalAcs(RwConfig.ACS_KillSent) THEN NetAttribute:=NetAttribute+[KillSent];
             IF (UplHold      IN NetAttr) AND EvalAcs(RwConfig.ACS_Hold) THEN NetAttribute:=NetAttribute+[Hold];
             IF (UplImmediate IN NetAttr) AND EvalAcs(RwConfig.ACS_Imm) THEN NetAttribute:=NetAttribute+[Crash];
             IF (UplFREQ      IN NetAttr) AND EvalAcs(RwConfig.ACS_FREQ) THEN NetAttribute:=NetAttribute+[FileRequest];
             IF (UplUpdREQ    IN NetAttr) AND EvalAcs(RwConfig.ACS_UpdREQ) THEN NetAttribute:=NetAttribute+[FileUpdateRequest];

             mTo.Zone     := Reply.DestZone;
             mTo.Net      := Reply.DestNet;
             mTo.Node     := Reply.DestNode;
             mTo.Point    := Reply.DestPoint;
             From.Zone    := MsRg_General.AKA[UseAkaNum].Zone;
             From.Net     := MsRg_General.AKA[UseAkaNum].Net;
             From.Node    := MsRg_General.AKA[UseAkaNum].Node;
             From.Point   := MsRg_General.AKA[UseAkaNum].Point;
          END;
    END;

    PROCEDURE DoEmail;
    BEGIN
       WITH MsgHdr DO
          BEGIN
             IF NOT EvalAcs(RwConfig.AnyNameEmail) THEN
                CASE RwConfig.NTypeEmail OF
                   NameAlias  : From.As := MsRg_User.Name;
                   NameReal   : From.As := MsRg_User.RealName;
                   NameEither : IF UpcaseStr(From.As) <> UpcaseStr(MsRg_User.RealName)
                                   THEN From.As := MsRg_User.Name;
                END;
             MsRg_UserIdxOpen;
             mTo.UserNum := MsRg_UserIdxSearch(mTo.As);
             MsRg_UserIdxClose;
             IF mTo.UserNum = -1 THEN
                BEGIN
                   RWM_WriteColor(RWM_GetString(159));
                   RWL_WriteLog('+',RWL_LogTime+' Unable to find user "'+mTo.As+'"!');
                   Close(MsgHdrFile);
                   RealDelay(1000);
                   Exit;
                END;
          END;
    END;

    PROCEDURE ConvHeaderInet;
    BEGIN
       WITH MsgHdr DO
          BEGIN
             From.As := Nul2Str(Reply.mFrom,36);
             From.Real := MsRg_User.Realname;
             From.Name := MsRg_User.Name;

             IF (mbRealName IN MsRg_MArea.mbStat)
                THEN From.AS := MsRg_User.RealName
                ELSE From.AS := FormatName(MsRg_User.Name);

             Reply.DestZone := RwConfig.InetGateZone;
             Reply.DestNet := RwConfig.InetGateNet;
             Reply.DestNode := RwConfig.InetGateNode;
             Reply.DestPoint := RwConfig.InetGatePoint;
             InetTo := DowncaseStr(Nul2Str(Reply.NetDest,99));
             mTo.As := 'UUCP';
             IF (Length(InetTo) < 36) AND RwConfig.InetUseTo THEN mTo.As := InetTo;

             mTo.Real := mTo.As;
             mTo.Name := mTo.As;
             Subject := Nul2Str(Reply.Subject,40);
             CurrentSecs(Date,DayOfWeek);
          END;

       RwVariables^[1] := MsgHdr.From.As;
       RwVariables^[2] := InetTo;
       RwVariables^[3] := MsgHdr.Subject;
       RwVariables^[4] := Unix2DateStr(0,MsgHdr.Date);
       RwVariables^[8] := RwConfig.InetAreaNum;

       DoNetmail;

       MsgHdr.From.As := FormatName(MsgHdr.From.As);
    END;

    PROCEDURE ConvHeader;
    VAR s:String;
    BEGIN
       WITH MsgHdr DO
          BEGIN
             From.As := Nul2Str(Reply.mFrom,36);
             From.Real := MsRg_User.Realname;
             From.Name := MsRg_User.Name;

             IF (mbRealName IN MsRg_MArea.mbStat)
                THEN From.AS := MsRg_User.RealName
                ELSE From.AS := FormatName(MsRg_User.Name);

             IF NOT (MsRg_MArea.Anonymous IN [atno,atyes]) THEN
                BEGIN
                   IF (MsRg_MArea.Anonymous = atforced)
                      THEN From.Anon := 1
                      ELSE IF (MsRg_MArea.anonymous = atanyname)
                         THEN BEGIN
                               From.AS := Nul2Str(Reply.mFrom,36);
                               From.Anon := 5;
                            END
                         ELSE From.Anon := 4;
                END;

             mTo.As := Nul2Str(Reply.mTo,36);
             IF (mbInternet IN MsRg_MArea.mbStat) THEN mTo.As := 'All';
             mTo.Real := mTo.AS;
             mTo.Name := mTo.AS;
             Subject := Nul2Str(Reply.Subject,40);
             CurrentSecs(Date,DayOfWeek);
          END;

       RwVariables^[1] := MsgHdr.From.As;
       RwVariables^[2] := MsgHdr.mTo.As;
       RwVariables^[3] := MsgHdr.Subject;
       RwVariables^[4] := Unix2DateStr(0,MsgHdr.Date);
       RwVariables^[8] := MsRg_MArea.FileName;

       IF MsRg_MArea.FileName='EMAIL'   THEN DoEmail;
       IF MsRg_MArea.FileName='NETMAIL' THEN DoNetmail;

       MsgHdr.From.As := FormatName(MsgHdr.From.As);
    END;

    PROCEDURE PostMessage;
    BEGIN
       CASE MsRg_MArea.mbType OF
          10, 11 : BaseFile := MsRg_General.MsgPath+'EMAIL';
          ELSE     BaseFile := MsRg_General.MsgPath+MsRg_MArea.FileName;
       END;

       Assign(MsgHdrFile,BaseFile+'.HDR');
       IF FExists(BaseFile+'.HDR') THEN Reset(MsgHdrFile) ELSE Rewrite(MsgHdrFile);
       Seek(MsgHdrFile,FileSize(MsgHdrFile));
       FillChar(MsgHdr,SizeOf(MsgHdr),0);

       CASE IsInet OF
          TRUE  : BEGIN
                     ConvHeaderInet;
                     LoadTextInet;
                  END;
          FALSE : BEGIN
                     ConvHeader;
                     LoadText;
                  END;
       END;

       IF RWU_CheckDupes THEN
          BEGIN
             RWM_WriteColor(RWM_GetString(158));
             RWL_WriteLog('+',RWL_LogTime+' Skipped duplicate message');
             Close(MsgHdrFile);
             Exit;
          END;

       ConvText;

       Write(MsgHdrFile,MsgHdr);
       Close(MsgHdrFile);
       RWL_WriteLog('+',RWL_LogTime+' Message to "'+MsgHdr.mto.As+'" in base "'+MsRg_MArea.Filename+'"');
       RWM_WriteColor(RWM_GetString(155));

       CASE MsRg_MArea.QwkIndex OF
          1 : BEGIN
                 MsRg_UserFileOpen;
                 MsRg_UserFileRead(MsgHdr.mTo.UserNum);
                 Inc(MsRg_User.Waiting);
                 MsRg_UserFileWrite(MsgHdr.mTo.UserNum);
                 MsRg_USerFileRead(RgUserNum);
                 MsRg_UserFileClose;
                 Inc(RepInfo^.RepEmail);
              END;
          2 : BEGIN
                 Inc(RepInfo^.RepNetmail);
                 CreateSem := TRUE;
              END;
          ELSE BEGIN
                 Inc(RepInfo^.RepPublic);
                 MsRg_MArea.mbStat := MsRg_MArea.mbStat+[mbScanOut];
                 MsRg_MAreaWrite(ThisBase);
                 CreateSem := TRUE;
              END;
       END;
    END;

    PROCEDURE ProcOneMsg;
    VAR MsgOfs:LongInt;
    BEGIN
       MsgOfs := bwReplyHdr.UplHdrLen+(LongInt(ThisReply)*bwReplyHdr.UplRecLen);
       Seek(ReplyFile,MsgOfs);
       BlockRead(ReplyFile,Reply,bwReplyHdr.UplRecLen,BytesRead);

       IF (UpcaseStr(Nul2Str(Reply.mTo,36)) = 'RENEWAVE') THEN
          BEGIN
             Inc(ServerReqNum);
             ServerReq[ServerReqNum] := MsgOfs;
             Exit;
          END;

       MsgTextName := Nul2Str(Reply.FileName,12);
       IF NOT FExists(RwWorkDir+MsgTextName) THEN
          BEGIN
             RwVariables^[2] := MsgTextName;
             RWM_WriteColor(RWM_GetString(163));
             Exit;
          END;

      IsInet := FALSE;
      EchoTag := UpcaseStr(Nul2Str(Reply.EchoTag,21));
      IF RwConfig.InetActive AND EvalAcs(RwConfig.InetAcs) AND (EchoTag=RwConfig.InetAreaTag)
         THEN BEGIN
               ThisBase := 1;
               IsInet := TRUE;
            END
         ELSE BEGIN
               ThisBase := RWM_FindBase(EchoTag);
               IF (ThisBase = $FFFF) OR NOT (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
                  BEGIN
                     RWM_WriteColor(RWM_GetString(160));
                     Exit;
                  END;
            END;
       MsRg_MAreaRead(ThisBase);
       PostMessage;
    END;

BEGIN
   RWM_KeyPressOff;

   RepInfo^.RepEmail   := 0;
   RepInfo^.RepPublic  := 0;

   Seek(ReplyFile,0);
   BlockRead(ReplyFile,bwReplyHdr,SizeOf(bwReplyHdr),BytesRead);
   NumRecs := (FileSize(ReplyFile)-bwReplyHdr.UplHdrLen) DIV bwReplyHdr.UplRecLen;

   RWM_WriteColor(RWM_GetString(150));
   RWM_WriteColor(RWM_GetString(151));
   RWM_WriteColor(RWM_GetString(152));
   RWM_WriteColor(RWM_GetString(153));
   RWM_WriteColor(RWM_GetString(154));

   IF NumRecs > 0
      THEN FOR ThisReply := 0 TO (NumRecs-1) DO ProcOneMsg
      ELSE RWM_WriteColor(RWM_GetString(161));
   fk_Writeln('',1);
   RWU_UpdateStats;
   RWM_KeyPressOn;
   IF NOT WarpUL THEN RWM_Pause;
END;


END.



