{$O+,I-}
UNIT RWPS;

(* 

    RWPS - ReneWave quick pre-scanning routines 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


CONST UseLocalPath     : Boolean = FALSE;


FUNCTION  RWP_CheckForWaiting:Boolean;
PROCEDURE RWP_ProcAllBases(QWK:Boolean);
FUNCTION  RWP_CompressPacket(ArchiveName,IncludeFiles:String):Boolean;
PROCEDURE RWP_UpdatePointers;
PROCEDURE RWP_PreScan;


IMPLEMENTATION


USES  MSFOSDOS, DOS,      CRT,      MSTRINGS,  MISC1,     CRC32,
      MYSHARE,  UNIXDATE, FASTW,    MSBWGEN,   MSBWOVR,   RWSTRUCT,
      BWSTRUCT, RECORDS,  MSRGGEN,  RWACS,     RWBB,      RWBD,
      RWBT,     RWERROR,  RWLOGS,   RWMAIN,    RWINIT,    RWMENUS,
      RWVARS;


FUNCTION RWP_CheckSendFile(s:SearchRec):Boolean;
VAR ch,ch2:Char; TransferSecs:LongInt; TempS,TransferStr:String; Res:Boolean;

    PROCEDURE SendPacketInfoInit;
    BEGIN
       IF fk_Fossil.Baud = 0
          THEN CopyFile(RwConfig.RwScanDir+s.Name,RwConfig.LocalDLDir+RwConfig.BBSID+ExtractFExt(s.Name),TRUE)
          ELSE CopyFile(RwConfig.RwScanDir+s.Name,RwConfig.RwScanDir+RwConfig.BBSID+ExtractFExt(s.Name),TRUE);
       TransferStr := MSBW_TransferTime(s.Size);
       RwVariables^[3] := TransferStr;
       RWL_WriteLog('-',RWL_LogTime+' Packet: '+RwVariables^[1]);
       RWL_WriteLog('-',RWL_LogTime+'         '+RwVariables^[2]+' bytes');
       RWL_WriteLog('-',RWL_LogTime+'         '+TransferStr+' minute(s)');
    END;

    PROCEDURE SendPacketInfoDisp;
    BEGIN
       fk_ClrScr;
       RWM_WriteColor(RWM_GetString(91));
       RWM_WriteColor(RWM_GetString(92));
       RWM_WriteColor(RWM_GetString(93));
       RWM_WriteColor(RWM_GetString(94));
       RWM_WriteColor(RWM_GetString(95));
       IF RwConfig.AllowGoodbye THEN
          BEGIN
             RWM_WriteColor(RWM_GetString(96));
             RWM_WriteColor(RWM_GetString(97));
          END;
       RWM_WriteColor(RWM_GetString(98));
       RWM_WriteColor(RWM_GetString(99));
       RWM_WriteColor(RWM_GetString(100));
       RWM_WriteColor(RWM_GetString(101));
    END;

    PROCEDURE SendPacketInfoGetCmd(VAR ch:Char);
    BEGIN
       RWM_KeyPressOn;
       fk_PurgeInputBuffer;
       FlushKeyboard;
       IF WarpDL
          THEN ch := #13
          ELSE BEGIN
                ch := ' ';
                REPEAT
                   ch := Upcase(fk_Read);
                UNTIL Pos(ch,#13+RWM_GetStringR(106,5)) > 0;
             fk_WriteLn('',2);
          END;
       RWM_KeyPressOff;
    END;

    PROCEDURE SendPacketInfoProcCmd(ch:Char);
    BEGIN
       IF Ch = RWM_GetCh(106,1) THEN
             BEGIN
                RWM_WriteColor(RWM_GetString(28));
                RWL_WriteLog('-',RWL_LogTime+' Download session aborted!');
             END
       ELSE IF Ch = RWM_GetCh(106,2) THEN CountdownSecs := 10
       ELSE IF Ch = RWM_GetCh(106,3) THEN CountdownSecs := 255
       ELSE IF Ch = RWM_GetCh(106,4) THEN RWM_ChooseProtocol;
    END;

    PROCEDURE SendPacketInfo;
    VAR ch:Char;
    BEGIN
       SendPacketInfoInit;
       IF fk_Fossil.Baud > 0
          THEN BEGIN
                REPEAT
                   SendPacketInfoDisp;
                   SendPacketInfoGetCmd(ch);
                   SendPacketInfoProcCmd(ch);
                UNTIL (Ch <> RWM_GetCh(106,4));
                {...}
                IF (ch <> RWM_GetCh(106,1)) THEN
                   IF RWB_SendFile(RwConfig.RwScanDir+RwConfig.BBSID+ExtractFExt(s.Name)) THEN
                      NukeFiles(RwConfig.RwScanDir+s.Name);
                {...}
                NukeFiles(RwConfig.RwScanDir+RwConfig.BBSID+ExtractFExt(s.Name));
             END
          ELSE NukeFiles(RwConfig.RwScanDir+s.Name);
    END;

    PROCEDURE DispPacketInfo;
    BEGIN
       RwVariables^[1] := RwConfig.BBSID+ExtractFExt(s.Name);
       RwVariables^[2] := StrFunc(s.Size);
       RwVariables^[3] := DosDateFormat(s.Time,2);

       RWM_WriteColor(RWM_GetString(230));
       RWM_WriteColor(RWM_GetString(231));
       RWM_WriteColor(RWM_GetString(232));
       RWM_WriteColor(RWM_GetString(233));
       RWM_WriteColor(RWM_GetString(234));
       RWM_WriteColor(RWM_GetString(235));
       RWM_WriteColor(RWM_GetString(236));
       RWM_WriteColor(RWM_GetString(237));
    END;

    PROCEDURE GetPacketInfoInput;
    BEGIN
       RWM_KeyPressOn;
       TempS := RWM_GetCh(238,1)+RWM_GetCh(3,1)+RWM_GetCh(4,1);
       IF WarpDL
          THEN ch := #13
          ELSE BEGIN
                ch := ' ';
                REPEAT
                   ch := Upcase(fk_Read);
                UNTIL Pos(ch,#13+TempS) > 0;
                fk_WriteLn('',2);
             END;
       RWM_KeyPressOff;
    END;

    PROCEDURE ProcPacketInfoInput;
    BEGIN
       IF (ch = RWM_GetCh(238,1)) THEN
          BEGIN
             NukeFiles(RwConfig.RwScanDir+s.Name);
             Res := FALSE;
          END
       ELSE IF (ch = RWM_GetCh(4,1)) THEN Res := FALSE
       ELSE BEGIN
             SendPacketInfo;
             Res := TRUE;
          END;
    END;

BEGIN
   Res := FALSE;
   DispPacketInfo;
   GetPacketInfoInput;
   ProcPacketInfoInput;
   RWP_CheckSendFile := Res;
END;


FUNCTION RWP_CheckForWaiting:Boolean;
VAR f:File; s:SearchRec; Res:Boolean;
BEGIN
   Res := FALSE;
   FindFirst(RwConfig.RwScanDir+LongInt2Hex(StringCrc(UpcaseStr(MsRg_User.Name)))+'.*',Archive,s);
   WHILE DosError = 0 DO
      BEGIN
         IF RWP_CheckSendFile(s) THEN Res := TRUE;
         FindNext(s);
      END;
   RWP_CheckForWaiting := Res;
END;


FUNCTION RWP_CompressPacket(ArchiveName,IncludeFiles:String):Boolean;
VAR CmdLine:String; ExecRes,ExitCode:Word; ArcInfo:FileArcInfoRec;
BEGIN
   ArcInfo := MsRg_General.FileArcInfo[MsRg_User.DefArcType];

   MciF_FileName := ArchiveName;
   MciF_ArcFileIncl := IncludeFiles;
   MciF_ArcFilePath := RwWorkDir;

   CmdLine := RWB_DoorMciConv(MsRg_General.ArcsPath+ArcInfo.ArcLine);

   RWL_WriteLog('-',RWL_LogTime+' Executing "'+CmdLine+'"');
   ExecRes := DoorProc(CmdLine,FALSE);
   ExitCode := DosExitCode;
   RWL_WriteLog('-',RWL_LogTime+' Exit code = '+StrFunc(ExitCode));

   RWP_CompressPacket := (ExecRes = 0) AND (ExitCode = ArcInfo.SuccLevel) AND FExists(ArchiveName);
END;


PROCEDURE RWP_UpdatePointers;
BEGIN
   IF FileSize(UPointerFile) = 0 THEN Exit;

   WritePipe('|09 |11Updating last read pointers');
   RWL_WriteLog('=',RWL_LogTime+' Updating lastread pointers');

   FOR ThisBase := 0 TO (FileSize(UPointerFile)-1) DO
      BEGIN
         Seek(UPointerFile,ThisBase);
         Read(UPointerFile,UPointerData);
         IF UPointerData.Update AND (UPointerData.BaseNum > 1) THEN
            BEGIN
               MsRg_MAreaRead(UPointerData.BaseNum);
               MsRg_ScnOpen;
               MsRg_ScnRead(RgUserNum-1);
               MsRg_Scn.LastRead := UPointerData.LastDate;
               MsRg_ScnWrite(RgUserNum-1);
               MsRg_ScnClose;
            END;
      END; { FOR }

   WritePipe(#13);
   ClrEol;
END; { RWP_UpdatePointers }


PROCEDURE RWP_ProcAllBases(Qwk:Boolean);
VAR ThisSelected  : Word;
    StatusStr,
    s             : String;
    ch            : Char;
    Aborted       : Boolean;
    BwMix         : MixRec;
    BwMixFile     : FILE OF MixRec;
    BaseFile      : String[80];

    MsgsTotal,
    MsgsNew,
    MsgsAll,
    MsgsKeywords,
    MsgsFilters,
    MsgsPersonal,
    BaseTotalSize,
    MsgsDownload  : LongInt;
    i             : Word;

   PROCEDURE WriteBaseInfo;
   BEGIN
      WritePipe('|15'+PadLeft(StrFunc(MsgsTotal),' ',5)+' '+
                '|07'+PadLeft(StrFunc(MsgsKeywords),' ',5)+' '+
                '|07'+PadLeft(StrFunc(MsgsFilters),' ',5)+' '+
                '|07'+PadLeft(StrFunc(MsgsPersonal),' ',5)+' '+
                '|07'+PadLeft(StrFunc(BaseTotalSize DIV 1024),' ',5)+'k '+
                '|15'+PadLeft(StrFunc(MsgsDownload),' ',5)+' ');
   END;

   PROCEDURE RWP_OneBase;
   VAR TempRes:Boolean;
   BEGIN
      Seek(MsgHdrFile,ThisMsg);
      BlockRead(File(MsgHdrFile),MsgHdr,1);
      IF (MsgHdr.Date <= MsRg_Scn.LastRead) THEN Exit;

      MsgTo := UpcaseStr(MsgHdr.mTo.As);
      MsgFrom := UpcaseStr(MsgHdr.From.As);
      MsgSubj := UpcaseStr(MsgHdr.Subject);

      TempRes := TRUE;
      TempRes := TempRes AND NOT (mDeleted IN MsgHdr.Status);
      TempRes := TempRes AND NOT (Unvalidated IN MsgHdr.Status);
      TempRes := TempRes AND NOT (MSBW_CheckOwn AND (RwNotMyMail IN RwUser.BWaveFlags));

      IF (prvt IN MsgHdr.Status) OR (MsRg_MArea.QwkIndex < 3) THEN
         TempRes := TempRes AND (MSBW_CheckPersonal OR MSBW_CheckOwn OR EvalAcs(RwConfig.ACS_AllEmail));

      CASE MsRg_MArea.mbType OF
          10 : TempRes := TempRes AND ((netmail IN MsgHdr.Status)=FALSE);
          11 : TempRes := TempRes AND (netmail IN MsgHdr.Status);
      END;

      IF TempRes THEN
         BEGIN
            Inc(MsgsNew);
            IF MSBW_CheckPersonal THEN Inc(MsgsPersonal);
            IF MSBW_CheckAll      THEN Inc(MsgsAll);
            IF MSBW_CheckKeyword  THEN Inc(MsgsKeywords);
            IF MSBW_CheckFilter   THEN Inc(MsgsFilters);

            IF ((RwConfig.MaxBaseMsgs  = 0) OR (MsgsDownload < RwConfig.MaxBaseMsgs)) AND
               ((RwConfig.MaxTotalMsgs = 0) OR (WorkTotal    < RwConfig.MaxTotalMsgs)) AND
               ((RwUser.MsgsLimit = 0)      OR (WorkTotal    < RwUser.MsgsLimit))
               THEN BEGIN
                     WritePipe(RepChar(#8,5)+'|07'+PadLeft(StrFunc(ThisMsg+1),' ',5));

                     Inc(MsgsDownload);
                     Inc(WorkTotal);
                     BaseTotalSize := BaseTotalSize+SizeOf(MsgHdr)+MsgHdr.TextSize;

                     IF (MsRg_MArea.QwkIndex < 3) THEN
                        IF MSBW_CheckPersonal AND (MsgHdr.FileAttached = 0) THEN
                           BEGIN
                              NukeEmail := ThisMsg;
                              BlockWrite(NukeEmailFile,NukeEmail,1);
                           END;

                     RWD_WriteFTI;
                  END
               ELSE BEGIN
                     IF (RwConfig.MaxBaseMsgs > 0) AND (MsgsDownload >= RwConfig.MaxBaseMsgs) THEN MaxMBase := TRUE;
                     IF (RwConfig.MaxTotalMsgs > 0) AND (WorkTotal >= RwConfig.MaxTotalMsgs)   THEN MaxMTotal := TRUE;
                     IF (RwUser.MsgsLimit > 0)      AND (WorkTotal >= RwUser.MsgsLimit)        THEN MaxUTotal := TRUE;
                  END;
         END;
   END;

   PROCEDURE OneBaseInit;
   BEGIN
      CASE MsRg_MArea.mbType OF
          10, 11 : BEGIN
                      BaseFile := MsRg_General.MsgPath+'EMAIL';
                      MsRg_Scn.LastRead := 0;
                   END;
              ELSE BEGIN
                      WriteLn('Here - 2 - ',RgUserNum);
                      BaseFile := MsRg_General.MsgPath+MsRg_MArea.FileName;
                      MsRg_ScnOpen;
                      MsRg_ScnRead(RgUserNum-1);
                      MsRg_ScnClose;
                      WriteLn('Here - 3');
                   END;
      END;

      IF NOT FExists(BaseFile+'.HDR') OR NOT FExists(BaseFile+'.DAT') THEN Exit;

      Assign(MsgHdrFile,BaseFile+'.HDR');
      Reset(MsgHdrFile);
      Assign(Dat,BaseFile+'.DAT');
      Reset(Dat,1);

      MsgsTotal      := FileSize(MsgHdrFile);
      MsgsNew        := 0;
      MsgsAll        := 0;
      MsgsKeywords   := 0;
      MsgsFilters    := 0;
      MsgsPersonal   := 0;
      BaseTotalSize  := 0;
      MsgsDownload   := 0;

      FillChar(bwMix,SizeOf(bwMix),0);
      Str2Nul(StrFunc(ThisBase),bwMix.AreaNum,6,#0);
      bwMix.HdrPtr := FilePos(bwFtiFile)*SizeOf(FtiRec);

      UPointerData.BaseNum  := ThisBase;
      UPointerData.Update   := TRUE;
      UPointerData.LastMsg  := 0;
      UPointerData.LastDate := 0;

      IF (mbForceRead IN MsRg_MArea.mbStat) AND NOT EvalAcs(RwConfig.ForceOvrAcs)
         THEN StatusStr := 'Forced'
         ELSE StatusStr := '------';

      WritePipe('|10'+PadRight(StrFunc(ThisBase+1),' ',4)+
                '|07'+PadRight(StripColor(MsRg_MArea.Name),' ',31)+' '+
                '|07'+StatusStr+'     0');
   END;

   PROCEDURE OneBaseDeinit;
   BEGIN
      WritePipe(RepChar(#8,5));
      WriteBaseInfo;

      RWD_FlushFtiBuff;
      RWD_FlushMsgBuff;
      Close(MsgHdrFile);
      Close(Dat);

      Write(UPointerFile,UPointerData);

      Assign(bwMixFile,RwWorkDir+RwConfig.BBSID+'.MIX');
      IF FExists(RwWorkDir+RwConfig.BBSID+'.MIX') THEN Reset(bwMixFile) ELSE Rewrite(bwMixFile);
      Seek(bwMixFile,FileSize(bwMixFile));
      bwMix.NumPersonal := MsgsPersonal;
      bwMix.NumMsgs := MsgsDownload;
      Write(bwMixFile,bwMix);
      Close(bwMixFile);
   END;

   PROCEDURE OneBase;
   BEGIN
      OneBaseInit;
      RealDelay(1000);
{      IF (FileSize(MsgHdrFile) > 0) THEN
         FOR ThisMsg := 0 TO (FileSize(MsgHdrFile)-1) DO
            RWP_OneBase;}
      OneBaseDeinit;
   END;

   PROCEDURE InitDownload;
   VAR i:Byte;
   BEGIN
      Aborted := FALSE;
      MaxMBase := FALSE;
      MaxMTotal := FALSE;
      WorkTotal := 0;
      RWD_InitPointerData;
      FtiBuffLen := 0;
      ClrScr;
      RWE_CopyrightScreen;
      WRitePipe(#13#10);
      WritePipe('|15### Area description                Status Total  KeyW  Filt  Pers   Size  # DL'+#13#10);
      WritePipe('|09=== =============================== ====== ===== ===== ===== ===== ====== ====='+#13#10);
      Window(1,9,80,25);
      RWM_KeyPressOff;
   END;

BEGIN
   InitDownload;
   FOR ThisBase := 0 TO (MsRg_MAreaNum-1) DO
      IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) AND
         (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            MsRg_MAreaRead(ThisBase);
            OneBase;
         END;
   RWD_FlushMsgBuff;
END;


PROCEDURE RWP_DeInit;
BEGIN
   Dispose(FtiBuff);
   Dispose(HdrBuff);
   Dispose(MsgTxtBuff);
END;


PROCEDURE RWP_InitConfig;
VAR CfgFile:FILE OF ConfigRec; CfgPath:String;
BEGIN
   MsRg_GeneralRead;
   MsRg_MAreaOpen;

   RwWorkDir := RwConfig.RwWorkDir+'PRESCAN\';
   DirMake(RwWorkDir);

   New(FtiBuff);    FillChar(FtiBuff^,SizeOf(FtiBuff^),0);
   New(HdrBuff);    FillChar(HdrBuff^,SizeOf(HdrBuff^),0);
   New(MsgTxtBuff); FillChar(MsgTxtBuff^,SizeOf(MsgTxtBuff^),0);

   FtiBuffLen     := 0;
   HdrBuffLen     := 0;
   HdrBuffPos     := 0;
   MsgTxtBuffSize := 0;

   RwNodeStr := 'PRE';
   RWI_InitLog;

   ClrScr;
   RWE_CopyrightScreen;
   WritePipe(#13#10);
END;


PROCEDURE RWP_ProcOneUser;
VAR b:Boolean; PktFileDir,PktFileName:String; TempScr:^ScreenType;
BEGIN
   MsRg_UserFileRead(RgUserNum);
   MsRg_UserFileClose;

   RWL_WriteLog('=',RWL_LogTime+' Creating mail packet for: '+MsRg_User.RealName+' ('+MsRg_User.Name+')');

   WritePipe('|07Processing user: |15'+MsRg_User.Name+' ('+MsRg_User.RealName+')'+#13#10);

   IF NOT RWI_CheckNewUser THEN
      BEGIN
         RWI_InitUsers;
         RWI_InitBases;
         RWM_EraseTemp;
         RWM_InitBundle;
         RWD_WriteInf;

         New(TempScr);
         ReadScreen(TempScr^);
         TempScr^.CursX := WhereX;
         TempScr^.CursY := WhereY;

         RWP_ProcAllBases(FALSE);
         RWD_DeInitBundleFiles;

         Window(1,1,80,25);
         WriteScreen(TempScr^);
         GotoXY(TempScr^.CursX,TempScr^.CursY);
         Dispose(TempScr);

         IF WorkTotal > 0 THEN
            BEGIN
               RWM_GetExt;
               IF UseLocalPath
                  THEN BEGIN
                        PktFileDir  := RwConfig.LocalDLDir;
                        PktFileName := RwConfig.BBSID+Ext;
                     END
                  ELSE BEGIN
                        PktFileDir  := RwConfig.RwScanDir;
                        PktFileName := LongInt2Hex(StringCrc(UpcaseStr(MsRg_User.RealName)))+Ext;
                     END;

               WHILE FExists(PktFileDir+PktFileName) DO Inc(PktFileName[Length(PktFileName)]);

               b := RWP_CompressPacket(PktFileDir+PktFileName,RwWorkDir+'*.*');

               NukeFiles(RwWorkDir+RwConfig.BBSID+'.MIX');
               NukeFiles(RwWorkDir+RwConfig.BBSID+'.DAT');
               NukeFiles(RwWorkDir+RwConfig.BBSID+'.INF');
               NukeFiles(RwWorkDir+RwConfig.BBSID+'.FTI');

               IF b THEN
                  BEGIN
                     RWP_UpdatePointers;
                     RWD_NukeEmail;
                  END;
            END;
         RWD_DeInitPointerData;
         Close(RwUserFile);
      END;
END;


PROCEDURE RWP_ProcUserNum(UserNumStr:String);
BEGIN
   RgUserNum := ValFunc(UserNumStr);
   MsRg_UserFileOpen;
   IF (RgUserNum > 0) AND (RgUserNum < FileSize(MsRg_UserFile))
      THEN RWP_ProcOneUser
      ELSE MsRg_UserFileClose;
END;


PROCEDURE RWP_ProcPrescanFile(FileName:String);
VAR UserName:String; PrescanFile:Text;
BEGIN
   IF FExists(FileName) THEN
      BEGIN
         Assign(PrescanFile,FileName);
         Reset(PrescanFile);
         WHILE NOT Eof(PrescanFile) DO
            BEGIN
               UseLocalPath := FALSE;
               ReadLn(PrescanFile,UserName);
               MsRg_UserIdxOpen;
               RgUserNum := MsRg_UserIdxSearch(UserName);
               MsRg_UserIdxClose;
               MsRg_UserFileOpen;
               IF (RgUserNum > 0) AND (RgUserNum < FileSize(MsRg_UserFile))
                  THEN RWP_ProcOneUser
                  ELSE MsRg_UserFileClose;
            END;
         Close(PreScanFile);
      END;
END;


PROCEDURE RWP_RunMain;
VAR s:String; ParamS,UserNum,PsFile:String; ParamNum:Byte;
BEGIN
   UserNum := '';
   PsFile := '';
   FOR ParamNum := 1 TO ParamCount DO
      BEGIN
         ParamS := UpcaseStr(ParamStr(ParamNum));
         IF (ParamS[1] = '/') OR (ParamS[1] = '-') THEN
            BEGIN
               IF ParamS[2] = 'P' THEN
                  BEGIN
                     IF      Copy(ParamS,3,1) = 'L'  THEN UseLocalPath := TRUE
                     ELSE IF Copy(ParamS,3,2) = 'U:' THEN
                        BEGIN
                           IF Length(ParamS) > 4 THEN PsFile := Copy(ParamS,5,Length(ParamS)-4);
                        END
                     ELSE IF Copy(ParamS,3,2) = 'N:' THEN
                        BEGIN
                           IF Length(ParamS) > 4 THEN UserNum := Copy(ParamS,5,Length(ParamS)-4);
                        END;
                  END;
            END;
      END;
   IF PsFile <> ''  THEN RWP_ProcPrescanFile(PsFile);
   IF UserNum <> '' THEN RWP_ProcUserNum(UserNum);
END;


PROCEDURE RWP_PreScan;
BEGIN
   RWP_InitConfig;
   RWP_RunMain;
   RWP_DeInit;
END;


END.
