{$O+,F+,I-}
UNIT RWMAIN;

(* 

    RWMAIN - ReneWave main/global/common routines (not overlayable) 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)



INTERFACE


USES  RECORDS, RWSTRUCT, MSBWGEN, BWSTRUCT;


CONST RwVerLen        = 12;
      RwVer           = '2.01 Beta-01';
      RwTear          = 'ReneWave v';

      { TODO: What are these supposed to say? (undecrypted) }

      RwSupp          = '{)P\wQl[Vps!wa&2&YW ypK_Npv';
      RwTitle         = 'p+\q2)N*[I$9^EHM=X:P_@ "}!Q2y\).Yx+%D;\';

      MaxServerReq    = 20;
      MaxServerVar    = 10;
      RwMaxVars       = 20;

VAR   RwVariables     : MciVarsPtr;

      RwTpl_Areas,                   { Name/path of template files }
      RwTpl_Start     : String[64];
      RwTpl_AreasN    : Word;

      RwHlp_Areas,
      RwHlp_Bundle,
      RwHlp_BundleS,
      RwHlp_NewUser   : String[64];

      MsgTextName      : String[72];
      ThisReply,
      NumRecs          : Word;
      Reply            : UplRec;
      BwReplyHdr       : UplHeader;

      RwConfig         : ConfigRec;
      RwUser           : RwUserRec;
      RwUserNum        : Word;
      RwUserFile       : FILE OF RwUserRec;
      RgUserNum        : Word;

      RwAcs_ForceOvr,
      RwAcs_AreaSysop,
      RwAcs_AllEmail   : Boolean;

      Regd,
      LogOpened,                   { Has the log file been opened? }
      CreateSem        : Boolean;
      NumSelected      : Word;
      TimeStatus       : (TimeOn,TimeOff);

      {$IFDEF VIRTUALPASCAL}
      BytesRead,
      BytesWritten     : LongInt;
      {$ELSE}
      BytesRead,
      BytesWritten     : Word;
      {$ENDIF}

VAR   MsgHdrFile       : FILE OF MHeaderRec;
      MsgHdr           : MHeaderRec;
      Dat              : FILE;
      ReplyText        : Text;

      MsRg_Node        : LineRec;

      Scheme           : SchemeRec;


{ Miscellaneous }
PROCEDURE RWM_SetMciStrings;
FUNCTION  RWM_LocalInput(Ch:Char):Char;
PROCEDURE RWM_KeyPressOff;
PROCEDURE RWM_KeyPressOn;
FUNCTION  RWM_GetYesOrNo(DefYes:Boolean):Char;
PROCEDURE RWM_EraseTemp;

PROCEDURE RWM_WriteScanInfo;
FUNCTION  RWM_BaseIdxFind(QwkIdx:Integer):Word;
FUNCTION  RWM_BaseAlias(AreaNum:Word):Word;
FUNCTION  RWM_FindAlias(Alias:Word):LongInt;
FUNCTION  RWM_FindBase(EchoTag:STring):Word;
FUNCTION  RWM_FindProt(Hotkey:Char):Byte;
FUNCTION  RWM_AkaMatch(z,n,f,p:Word):Byte;

PROCEDURE RWM_ReadSTF;
PROCEDURE RWM_DeInitSTF;
PROCEDURE RWM_STableOpen;
PROCEDURE RWM_STableClose;
PROCEDURE RWM_STableRead(AreaNum:Word);
PROCEDURE RWM_STableWrite(AreaNum:Word);

{ Display/colour/mci related routines }
FUNCTION  RWM_RwMciStr(b:Boolean):String;
FUNCTION  RWM_GetCh(n:Word; pos:Byte):Char;
FUNCTION  RWM_GetString(n:Word):String;
FUNCTION  RWM_GetStringR(n:Word; num:Byte):String;
PROCEDURE RWM_Pause;
PROCEDURE RWM_WriteColor(InStr:String);
PROCEDURE RWM_DispFile(FName:String; AddExt:Boolean; LineLength:Byte);


IMPLEMENTATION


USES {$I FOSSTYPE.INC }

     DOS,      CRT,      MISC1,    MYSHARE,  FASTW,    MSTRINGS,
     UNIXDATE, RWBT,     RWQWK,    RWLOGS,   RWAREAS,
     RWUP,     RWERROR,  MSRGGEN,  RWVARS,   RWINIT;


VAR  Line            : String;
     TempLen         : Word;

     LightColor      : Boolean;
     fgColor,
     bgColor,
     CursorX,
     CursorY         : Byte;


FUNCTION RWM_RwMciStr(b:Boolean):String;
BEGIN
   IF b
      THEN RWM_RwMciStr := RWM_GetString(42)
      ELSE RWM_RwMciStr := RWM_GetString(43);
END;


PROCEDURE RWM_SetMciStrings;
BEGIN
   MciF_MsgBaseNum    := StrFunc(ThisBase+1);
   MciF_MinsLeft      := StrFunc(fk_Client.TimeLeft DIV 60);
   MciF_TempPath      := StripTrailingCh(RwWorkDir,'\');
   MciF_ActualBaud    := StrFunc(fk_Fossil.Locked);
   MciF_Baud          := StrFunc(fk_Fossil.Baud);
   MciF_LockedBaud    := StrFunc(fk_Fossil.Locked);
   MciF_Node          := RwNodeStr;
   MciF_ComPort       := StrFunc(fk_Fossil.Port);
END;


FUNCTION RWM_LocalInput(Ch:Char):Char;
VAR b:Boolean;
BEGIN
   IF (Ch = #0) AND KeyPressed THEN
      BEGIN
         b := TRUE;
         CASE ReadKey OF
{ ALT-C }   #46 : RWB_ChatMode;
{ ALT-J }   #36 : RWB_DosShell;
{ LEFT  }   #75 : IF fk_Host.StatusLineMod > 1 THEN Dec(fk_Host.StatusLineMod);
{ RIGHT }   #77 : IF fk_Host.StatusLineMod < 3 THEN Inc(fk_Host.StatusLineMod);
{ ALT-- }  #130 : RWB_AddTime(-5);
{ ALT-+ }  #131 : RWB_AddTime(5);
           ELSE b := FALSE;
         END;
         IF b THEN Ms_DrawStatus;
      END;
   RWM_LocalInput := Ch;
END;


FUNCTION RWM_BaseIdxFind(QwkIdx:Integer):Word;
BEGIN
   FOR RwBaseIdxPos := 0 TO RwBaseIdxLen-1 DO
      IF Abs(RwBaseIdx^[RwBaseIdxPos]) = QwkIdx THEN
         BEGIN
            RWM_BaseIdxFind := RwBaseIdxPos;
            Exit;
         END;
   RWM_BaseIdxFind := $FFFF;
END;


FUNCTION RWM_BaseAlias(AreaNum:Word):Word;
VAR i,j:Word;
BEGIN
   i := 0;
   FOR j := 0 TO AreaNum DO
      IF (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[j])]) THEN
         Inc(i);
   RWM_BaseAlias := i;
END;


FUNCTION RWM_FindAlias(Alias:Word):LongInt;
VAR i,j:LongInt;
BEGIN
   i := 0;
   j := 0;
   WHILE (i < RwBaseIdxLen) AND (j < Alias) DO
      BEGIN
         IF (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[i])]) THEN Inc(j);
         Inc(i);
      END;
   RWM_FindAlias := i;
END;


PROCEDURE RWM_WriteScanInfo;
VAR ScanInfoPos:Word;
BEGIN
   Assign(ScanInfoFile,RwConfig.RwMainDir+'SCANINFO.RW');
   IF NOT FExists(RwConfig.RwMainDir+'SCANINFO.RW')
      THEN Rewrite(ScanInfoFile,4096)
      ELSE Reset(ScanInfoFile,4096);

   IF RwUserNum >= FileSize(ScanInfoFile) THEN RWI_InitScanInfo;

   Seek(ScanInfoFile,RwUserNum);
   BlockWrite(ScanInfoFile,ScanInfo^,1);
   Close(ScanInfoFile);
END;


FUNCTION RWM_FindBase(EchoTag:STring):Word;
VAR TheBase,TempRes:Word;
BEGIN
   FOR TheBase := 0 TO (MsRg_MAreaNum-1) DO
      BEGIN
         MsRg_MAreaRead(TheBase);
         IF MsRg_MArea.FileName = EchoTag THEN
            BEGIN
               RWM_FindBase := TheBase;
               Exit;
            END;
      END;
   RWM_FindBase := $FFFF;
END;


PROCEDURE RWM_DeInitSTF;
{ Write the scan table information for BASENUM back to the scan table file }
BEGIN
   FreeMem(ScanTableMsgArr,ScanTableMsgMax);
   ScanTableMsgArr := NIL;
   ScanTableMsgMax := 1;
END;


PROCEDURE RWM_ReadSTF;
BEGIN
   Seek(ScanTableMsgFile,ScanTable.STablePtr);
   ScanTableMsgMax := ScanTable.STableNum;
   GetMem(ScanTableMsgArr,ScanTableMsgMax);
   BlockRead(File(ScanTableMsgFile),ScanTableMsgArr^[1],ScanTableMsgMax);
END;


PROCEDURE RWM_STableOpen;
BEGIN
   Assign(ScanTableFile,RwConfig.RwWorkDir+'SCANT.'+RwNodeStr);
   IF FExists(RwConfig.RwWorkDir+'SCANT.'+RwNodeStr)
      THEN Reset(ScanTableFile)
      ELSE Rewrite(ScanTableFile);
END;


PROCEDURE RWM_STableClose;
BEGIN
   Close(ScanTableFile); IF IOResult <> 0 THEN ;
END;


PROCEDURE RWM_STableRead(AreaNum:Word);
BEGIN
   RWM_STableOpen;
   IF AreaNum < FileSize(ScanTableFile) THEN
      BEGIN
         Seek(ScanTableFile,AreaNum);
         BlockRead(File(ScanTableFile),ScanTable,1);
      END;
   RWM_STableClose;
END;


PROCEDURE RWM_STableWrite(AreaNum:Word);
BEGIN
   RWM_STableOpen;
   IF AreaNum <= FileSize(ScanTableFile) THEN
      BEGIN
         Seek(ScanTableFile,AreaNum);
         BlockWrite(File(ScanTableFile),ScanTable,1);
      END;
   RWM_STableClose;
END;


FUNCTION  RWM_FindProt(Hotkey:Char):Byte;
VAR i:Byte; Found:Boolean;
BEGIN
   i := 1; Found := FALSE;
   WHILE (i <= 10) AND NOT Found DO
      BEGIN
         Found := RwConfig.RwProtocols[i].Letter = Hotkey;
         IF NOT Found THEN Inc(i);
      END;
   IF i > 10 THEN i := 1;
   RWM_FindProt := i;
END;


FUNCTION RWM_AKAMatch(z,n,f,p:Word):Byte;
VAR TempRes, ThisAKA:Byte;
BEGIN
   TempRes := 0;
   FOR ThisAKA := 19 DOWNTO 0 DO
      IF z = MsRg_General.AKA[ThisAKA].Zone THEN
         TempRes := ThisAKA;
   RWM_AKAMatch := TempRes;
END;


procedure RWM_EraseTemp;
var
  DirInfo : SearchRec;
  f       : File;
begin
  if LogOpened and FExists(RwWorkDir+'*.*')
    then
      RWL_WriteLog('=',RWL_LogTime+' Clearing temp directory "'+RwWorkDir+'*.*"');

  RWU_DeInitFiles;
  RWQ_DeInitQWK;
  FindFirst(RwWorkDir+'*.*',Archive,DirInfo);
  while DosError = 0 do
    begin
      Assign(f,RwWorkDir+DirInfo.Name);
      Erase(f);
      if IOResult <> 0 then ;
      FindNext(DirInfo);
    end;
  {$IFNDEF DOS} FindClose(DirInfo); {$ENDIF}
end;


PROCEDURE RWM_KeyPressOff;
BEGIN
   IF TimeStatus = TimeOff THEN Exit;
   fk_Host.Inactivity := 0;
   TimeStatus := TimeOff;
END;


PROCEDURE RWM_KeyPressOn;
VAR ch:Char;
BEGIN
   IF TimeStatus = TimeOn THEN Exit;
   ch := fk_NoWaitRead;
   fk_Host.Inactivity := RwConfig.TimeOutMinutes*60;
   TimeStatus := TimeOn;
END;


PROCEDURE RWM_WriteColor(InStr:String);
VAR   s,                               { Working string }
      EscapeStr         : String;      { ANSI codes }
      i,StrPos,StrLen   : Word;


   PROCEDURE DoFile;
   VAR FileStr,d,n,e:String; TempPos:Byte;
   BEGIN
      IF Pos('%',Copy(s,StrPos+1,Length(s)-StrPos)) = 0 THEN Exit;
      FileStr := '';
      Inc(StrPos);
      WHILE (StrPos < Length(s)) AND (s[StrPos] <> '%') DO
         BEGIN
            Inc(FileStr[0]);
            FileStr[Length(FileStr)] := s[StrPos];
            Inc(StrPos);
         END;
      Inc(StrPos);

      FileStr := ExtractFName(FileStr);

      RWM_DispFile(RwConfig.RwMenuDir+FileStr,TRUE,0);
      RWM_DispFile(MsRg_General.MiscPath+FileStr,TRUE,0);
   END;

   PROCEDURE DoMci;
   VAR Mci:String;  PadTo:Byte;
   BEGIN
      Mci := Copy(s,StrPos,3);
      Inc(StrPos,3);

      IF      Mci = '%PA' THEN RWM_Pause
      ELSE IF Mci = '%DE' THEN RealDelay(1000)
      ELSE IF Mci = '%DF' THEN DoFile;
   END;

   PROCEDURE Wrt(c:char);
   BEGIN
      CASE c OF
         #12 : fk_ClrScr;
         ELSE fk_Write(c);
      END;
   END;

   PROCEDURE DoPipe;
   VAR Col:Byte; Err:Word;
   BEGIN
      Val(Copy(s,StrPos+1,2),Col,Err);
      IF (Err = 0) AND (Col IN [0..23]) THEN
         IF (Col IN [0..15])
            THEN fk_TextForeground(Col)
            ELSE fk_TextBackground(Col-16);
      Inc(StrPos,3);
   END;

   PROCEDURE DoCaret;
   VAR Col:Byte; Err:Word;
   BEGIN
      Val(Copy(s,StrPos+1,1),Col,Err);
      IF (Err = 0) AND (Col IN [0..9]) THEN fk_TextColor(Scheme.Color[Col+1]);
      Inc(StrPos,2);
   END;

   PROCEDURE Ansi_AddrCursor;
   VAR XPos,YPos,SemiPos:Byte; Err:Integer;
   BEGIN
      SemiPos := Pos(';',EscapeStr);
      IF EscapeStr = '' THEN fk_GotoXY(1,1)
      ELSE IF SemiPos > 0 THEN
         BEGIN
            Val(Copy(EscapeStr,1,SemiPos-1),YPos,Err);                          IF Err <> 0 THEN YPos := 1;
            Val(Copy(EscapeStr,SemiPos+1,Length(EscapeStr)-SemiPos),XPos,Err);  IF Err <> 0 THEN XPos := 1;
            fk_GotoXY(XPos,YPos);
         END
      ELSE BEGIN
            Val(EscapeStr,YPos,Err);
            IF Err <> 0 THEN YPos := 1;
            XPos := 1;
            fk_GotoXY(XPos,YPos);
         END;
   END;

   PROCEDURE Ansi_SetColor;
   VAR i:Byte; SemiPos:Byte; Err:Integer;
   BEGIN
      IF EscapeStr = '' THEN Exit;
      IF EscapeStr[Length(EscapeStr)] <> ';' THEN EscapeStr := EscapeStr+';';
      REPEAT
            SemiPos := Pos(';',EscapeStr);
            CASE ValFunc(Copy(EscapeStr,1,SemiPos-1)) OF
               0  : BEGIN
                       fgColor    := 7;
                       bgColor    := 0;
                       LightColor := FALSE;
                    END;
               1  : LightColor := TRUE;
               5  : fgColor := fgColor + 128; { Blink }
               7  : BEGIN
{                      i  := FG;
                       FG := BG;
                       BG := i; }
                    END;
               30 : fgColor := 0;  31 : fgColor := 4;
               32 : fgColor := 2;  33 : fgColor := 6;
               34 : fgColor := 1;  35 : fgColor := 5;
               36 : fgColor := 3;  37 : fgColor := 7;
               40 : bgColor := 0;  41 : bgColor := 4;
               42 : bgColor := 2;  43 : bgColor := 6;
               44 : bgColor := 1;  45 : bgColor := 5;
               46 : bgColor := 3;  47 : bgColor := 7;
            END;
            Delete(EscapeStr,1,SemiPos);
      UNTIL Length(EscapeStr) = 0;
      IF LightColor
         THEN fgColor := (fgColor OR $08)
         ELSE fgColor := (fgColor OR $08) XOR $08;
      fk_TextColor(fgColor+(bgColor*16));
   END;

   PROCEDURE EscapeMode;
   VAR Done:Boolean;
   BEGIN
      Inc(StrPos,2);
      EscapeStr := '';
      Done := FALSE;
      WHILE (StrPos <= Length(s)) AND NOT Done DO
         BEGIN
            IF (Upcase(s[StrPos]) IN ['M','F','H','J','K','S','U','A'..'D']) THEN
               BEGIN
                  Done := TRUE;
                  CASE Upcase(s[StrPos]) OF
                     'F',
                     'H' : Ansi_AddrCursor;
                     'M' : Ansi_SetColor;
                     'J' : IF EscapeStr = '2' THEN fk_ClrScr;
                     'K' : IF EscapeStr = '0' THEN fk_ClrEol;
                     'S' : BEGIN
                              CursorX := WhereX;
                              CursorY := WhereY;
                           END;
                     'U' : fk_GotoXY(CursorX,CursorY);
                     'A' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'U')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'U');
                     'B' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'D')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'D');
                     'C' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'R')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'R');
                     'D' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'L')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'L');
                  END;
               END
            ELSE EscapeStr := EscapeStr + s[StrPos];
            Inc(StrPos);
         END;
   END;

   PROCEDURE ProcAvatar;
   BEGIN
      CASE s[StrPos+1] OF
         ^B : BEGIN
                 fgColor := fgColor OR $80;
                 fk_TextColor(fgColor+(bgColor*16));
              END;
         ^C : fk_MoveCursor(1,'U');
         ^D : fk_MoveCursor(1,'D');
         ^E : fk_MoveCursor(1,'L');
         ^F : fk_MoveCursor(1,'R');
         ^G : fk_ClrEol;
         ^A : IF (StrLen >= 3) THEN
                 BEGIN
                    fgColor := Ord(s[StrPos+2]) MOD 16;
                    bgColor := Ord(s[StrPos+2]) DIV 16;
                    LightColor := Ord(s[StrPos+2]) AND $08 = $08;
                    fk_TextColor(Ord(s[StrPos+2]));
                    Inc(StrPos);
                 END;
         ^H : IF (StrLen >= 4) THEN
                 BEGIN
                    fk_GotoXY(Ord(s[StrPos+3]),Ord(s[StrPos+2]));
                    Inc(StrPos,2);
                 END;
      END;
      Inc(StrPos,2);
   END;

BEGIN
   IF Length(InStr) = 0 THEN Exit;
   s := InStr;
   s := MsRg_MciString(s);
   StrPos := 1;
   REPEAT
      StrLen := (Length(s)-StrPos)+1;
      IF (StrLen >= 3) AND (s[StrPos] = '|') AND
                           (s[StrPos+1] IN ['0'..'2']) AND
                           (s[StrPos+2] IN ['0'..'9']) THEN DoPipe
      ELSE IF (StrLen >= 3) AND (s[StrPos] = '`') AND
              (s[StrPos+1] IN ['0'..'9','A'..'F']) AND
              (s[StrPos+2] IN ['0'..'9','A'..'F']) THEN
         BEGIN
            fk_TextColor(Hex2Int(s[StrPos+1]+s[StrPos+2]));
            Inc(StrPos,3);
         END
      ELSE IF (s[StrPos] = '^') AND (s[StrPos+1] IN ['0'..'9']) AND (StrLen >= 2) THEN DoCaret
      ELSE IF (s[StrPos] = '%') AND (StrLen >= 3) THEN DoMci
      ELSE IF (s[StrPos] = #3)  THEN Inc(StrPos,2)
      ELSE IF (s[StrPos] = #22) AND (StrLen >= 2) THEN ProcAvatar
      ELSE IF (s[StrPos] = #25) AND (StrLen >= 3) THEN
         BEGIN
            IF Ord(s[StrPos+2]) >= 1 THEN
               FOR i := 1 TO Ord(s[StrPos+2]) DO
                  Wrt(s[StrPos+1]);
            Inc(StrPos,3);
         END
      ELSE IF (s[StrPos] = #27) AND (s[StrPos+1] = '[') AND (StrLen >= 3) THEN EscapeMode
      ELSE BEGIN
            Wrt(s[StrPos]);
            Inc(StrPos);
         END;
   UNTIL StrPos > Length(s);
END;


FUNCTION RWM_GetCh(n:Word; Pos:Byte):Char;
VAR s:String;
BEGIN
   s := RWM_GetString(n);
   RWM_GetCh := Upcase(s[Pos]);
END;


FUNCTION RWM_GetStringR(n:Word; num:Byte):String;
VAR s:String;
BEGIN
   s := RWM_GetString(n);
   RWM_GetStringR := Copy(UpcaseStr(s),1,Num);
END;


FUNCTION RWM_GetString(n:Word):String;
VAR s:String;

    PROCEDURE HandleFile;
    VAR fn:String; b:Byte;
    BEGIN
       b := Pos(' ',s);
       IF b = 0
          THEN fn := s
          ELSE fn := Copy(s,1,b-1);

       IF FExists(fn)
          THEN RWM_DispFile(fn,FALSE,0)
          ELSE BEGIN
                fn := ExtractFName(fn);
                IF FExists(RwConfig.RwTextDir+fn)
                   THEN RWM_DispFile(RwConfig.RwTextDir+fn,FALSE,0)
                   ELSE IF FExists(MsRg_General.MiscPath+fn)
                      THEN RWM_DispFile(MsRg_General.MiscPath+fn,FALSE,0)
                      ELSE BEGIN
                            fn := ExtractFileName(fn);
                            IF FExists(RwConfig.RwTextDir+fn+'.*')
                               THEN RWM_DispFile(RwConfig.RwTextDir+fn,TRUE,0)
                               ELSE RWM_DispFile(MsRg_General.MiscPath+fn,TRUE,0);
                         END;
             END;
       s := '';
    END;

BEGIN
   s := '';
   Move(RwStrBuff^[RwStrTable[n].Ofs],s[1],RwStrTable[n].Len);
   s[0] := Chr(RwStrTable[n].Len);
   IF s[1] = '$' THEN HandleFile; { Display File }
   RWM_GetString := s;
END;


PROCEDURE RWM_Pause;
VAR ch:Char; lpos:byte; fg2,bg2:Byte; LightColor2:Boolean;
BEGIN
   fg2 := fk_Host.LastFG;
   bg2 := fk_Host.LastBG;
   LightColor2 := fk_Host.High;
   fk_PurgeInputBuffer;
   RWM_WriteColor(RWM_GetString(13));
   ch := fk_Read;
   fk_Write(#13);
   fk_ClrEol;
   fk_Write(#13);
   fk_TextColor(fg2 MOD 128+(bg2 *16));
   fgColor := fg2;
   bgColor := bg2;
   LightColor := LightColor2;
END;


PROCEDURE RWM_DispFile(FName:String; AddExt:Boolean; LineLength:Byte);
VAR TheFile   : Text;
    RandNum   : Byte;
    RandExt   : Char;
    ProcFile  : Boolean;
    MciStr,
    EscapeStr : String;
    TxtBuff   : Array[1..1024] OF Char;

    FUNCTION GetValidFile(FName:String):String;
    VAR s:String;
    BEGIN
       s := Copy(FName,1,Length(FName)-1);
       REPEAT
          RandNum := Random(11);
          IF RandNum < 10
             THEN RandExt := Chr(RandNum+48)
             ELSE RandExt := FName[Length(FName)];
       UNTIL FExists(s+RandExt);
       GetValidFile := s+RandExt;
    END;

    PROCEDURE DispFile;
    VAR i:Byte; ch:Char;
    BEGIN
       Line := '';
       fk_Host.OutputLines := 0;
       WHILE NOT Eof(TheFile) DO
          BEGIN
             Read(TheFile,ch);
             Inc(Line[0]);
             TempLen := Length(Line);
             Line[TempLen] := Ch;

             IF (TempLen=255) OR ((TempLen>1) AND ((Copy(Line,TempLen-1,2) = #13#10) OR (Copy(Line,TempLen-1,2) = #10#13)))
               THEN BEGIN
                      RWM_WriteColor(Line);
                      Line := '';
                      Inc(fk_Host.OutputLines);
                      IF fk_KeyPressed THEN
                         BEGIN
                            ch := UpCase(fk_Read);
                            IF (Ch = ' ') THEN
                               BEGIN
                                  RWM_WriteColor(#13#10+'|12Aborted.|07'+#13#10);
                                  Exit;
                               END;
                         END;
                      IF (LineLength > 0)
                         THEN IF fk_Host.OutputLines = (LineLength-1) THEN
                            BEGIN
                               RWM_Pause;
                               fk_Host.OutputLines := 0;
                            END;
                   END;
          END;
       IF Line <> '' THEN RWM_WriteColor(Line);
    END;

BEGIN
   LightColor := FALSE;
   bgColor    := 0;
   fgColor    := 7;
   fk_TextColor(7);
   ProcFile := TRUE;
   fk_Host.StatusLinePos := 0;
   fk_Host.StatusLineBuf := 0;
{   IF NOT (pause IN MsRg_User.Flags) THEN LineLength := 0;}

   IF FExists(FName)
      THEN Assign(TheFile,FName)
      ELSE IF AddExt
         THEN CASE fk_Client.ScreenType OF
               2 : BEGIN
                      IF FExists(FName+'.AVT') THEN Assign(TheFile,GetValidFile(FName+'.AVT'))
                      ELSE IF FExists(FName+'.ASC') THEN Assign(TheFile,GetValidFile(FName+'.ASC'))
                      ELSE ProcFile := FALSE;
                   END;
               1 : BEGIN
                      IF FExists(FName+'.ANS') THEN Assign(TheFile,GetValidFile(FName+'.ANS'))
                      ELSE IF FExists(FName+'.ASC') THEN Assign(TheFile,GetVAlidFile(FName+'.ASC'))
                      ELSE ProcFile := FALSE;
                   END;
               ELSE IF NOT FExists(FName+'.ASC')
                  THEN ProcFile := FALSE
                  ELSE Assign(TheFile,GetValidFile(FName+'.ASC'));
            END
         ELSE ProcFile := FALSE;

   IF ProcFile THEN
      BEGIN
         SetTextBuf(TheFile,TxtBuff);
         Reset(TheFile);
         DispFile;
         Close(TheFile);
      END;

   fk_Host.StatusLineBuf := 1;
   fk_Host.StatusLinePos := 25;
END;


FUNCTION RWM_GetYesOrNo(DefYes:Boolean):Char;
VAR ch,Default:Char;
BEGIN
   fk_PurgeInputBuffer;
   IF DefYes
      THEN BEGIN
            RWM_WriteColor(RWM_GetString(1));
            Default := RWM_GetCh(3,1);
         END
      ELSE BEGIN
            RWM_WriteColor(RWM_GetString(2));
            Default := RWM_GetCh(4,1);
         END;
   REPEAT
      ch := Upcase(fk_Read);
   UNTIL (ch IN [#13,RWM_GetCh(3,1),RWM_GetCh(4,1)]);
   IF (ch = #13) OR (ch = Default)
      THEN RWM_GetYesOrNo := Default
      ELSE BEGIN
            IF DefYes
               THEN fk_Write(RepChar(#8,Length(StripColor(RWM_GetString(1)))))
               ELSE fk_Write(RepChar(#8,Length(StripColor(RWM_GetString(2)))));

            IF (ch = RWM_GetCh(4,1)) THEN RWM_WriteColor(RWM_GetString(2));
            IF (ch = RWM_GetCh(3,1)) THEN RWM_WriteColor(RWM_GetString(1));

            RWM_GetYesOrNo := Ch;
         END;
END;


BEGIN
   fgColor := 7;
   bgColor := 0;
   LightColor := FALSE;
END. { RWMain }
