{$O+,F+,I-}
UNIT RWINIT;

(* 

    RWINIT - ReneWave initialization code

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


FUNCTION  RWI_CheckNewUser:Boolean;
PROCEDURE RWI_InitNewUser;
PROCEDURE RWI_DisplayLogo;
PROCEDURE RWI_ProductInfo;
PROCEDURE RWI_InitScanInfo;
PROCEDURE RWI_InitBases;
PROCEDURE RWI_ReadLangConfig(Lang:String);
PROCEDURE RWI_ReadPrompts;
PROCEDURE RWI_InitLog;
PROCEDURE RWI_CombineLog;
PROCEDURE RWI_UserToFK;
PROCEDURE RWI_InitUsers;
PROCEDURE RWI_InitScheme(SchemeNum:Byte);
PROCEDURE RWI_MakeDir(s:String);
PROCEDURE RWI_InitPaths;
PROCEDURE RWI_InitNode;
PROCEDURE RWI_InitCfg;
PROCEDURE RWI_InitGeneral;
PROCEDURE RWI_InitFossil;

PROCEDURE RWI_InitVars;
PROCEDURE RWI_InitVars1;
PROCEDURE RWI_InitVars2;
PROCEDURE RWI_DeInitVars;
PROCEDURE RWI_InitParams;


IMPLEMENTATION


USES  {$I FOSSTYPE.INC }

      DOS,      CRT,      MSTRINGS, UNIXDATE, MISC1,
      RWBB,     RWBD,     RWBT,     RWACS,    RWMAIN,   RWERROR,
      RWLOGS,   RECORDS,  RWSTRUCT, SPIN,     RWREG,    BWSTRUCT,
      RWVARS,   MSBWGEN,  CRC32,    OVERLAY,  FASTW,    MSRGGEN,
      MYSHARE;


{$I RWLOGO.PAS }


PROCEDURE RWI_InitScanInfo;
VAR ScanInfoPos:LongInt;
BEGIN
   FillChar(ScanInfo^,SizeOf(ScanInfo^),0);
   FOR ScanInfoPos := 0 TO MsRg_MAreaNum-1 DO
      BEGIN
         MsRg_MAreaRead(ScanInfoPos);
         IF EvalAcs(MsRg_MArea.Acs) THEN
            ScanInfo^[MsRg_MArea.QwkIndex] := [scn_HasAccess];
      END;
   FOR ScanInfoPos := FileSize(ScanInfoFile) TO RwUserNum DO
      BEGIN
         Seek(ScanInfoFile,ScanInfoPos);
         BlockWrite(ScanInfoFile,ScanInfo^,1,BytesWritten);
      END;
   IF RwConfig.ImportPointers THEN
      BEGIN
         RWM_WriteColor(RWM_GetString(19));
         FOR ScanInfoPos := 0 TO MsRg_MAreaNum-1 DO
            BEGIN
               MsRg_MAreaRead(ScanInfoPos);
               MsRg_ScnOpen;
               MsRg_ScnRead(RgUserNum-1);
               MsRg_ScnClose;
               IF MsRg_Scn.NewScan
                  THEN ScanInfo^[MsRg_MArea.QwkIndex] := [scn_Selected,scn_HasAccess]
                  ELSE ScanInfo^[MsRg_MArea.QwkIndex] := [scn_HasAccess];
            END;
         Seek(ScanInfoFile,RwUserNum);
         BlockWrite(ScanInfoFile,ScanInfo^,1,BytesWritten);
      END;
END;


PROCEDURE RWI_InitBases;
TYPE InfBuffType   = Array[1..128] OF Inf_AreaInfo;
VAR  ScanInfoPos  : LongInt;
     Counter      : Word;

     InfBuff      : ^InfBuffType;
     InfBuffPos   : Word;

     PROCEDURE FlushInfBuff;
     BEGIN
        IF InfBuffPos > 0 THEN BlockWrite(bwInfFile,InfBuff^[1],InfBuffPos,BytesWritten);
        InfBuffPos := 0;
     END;

    PROCEDURE CheckScan;
    BEGIN
       IF EvalAcs(MsRg_MArea.Acs)
          THEN BEGIN
                IF (mbForceRead IN MsRg_MArea.mbStat) AND NOT EvalAcs(RwConfig.ForceOvrAcs)
                   THEN BEGIN
                         ScanInfo^[MsRg_MArea.QwkIndex] := [scn_Selected,scn_HasAccess];
                         RwBaseIdx^[ThisBase] := -MsRg_MArea.QwkIndex;
                      END
                   ELSE BEGIN
                         ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_HasAccess];
                         IF (scn_Selected IN ScanInfo^[MsRg_MArea.QwkIndex])
                           THEN RwBaseIdx^[ThisBase] := -MsRg_MArea.QwkIndex
                           ELSE RwBaseIdx^[ThisBase] := MsRg_MArea.QwkIndex;
                     END;
                Inc(InfBuffPos);
                RWD_WriteInfConf(InfBuff^[InfBuffPos]);
                IF InfBuffPos=128 THEN FlushInfBuff;
                Inc(AcsTableLen);
             END
          ELSE BEGIN
                ScanInfo^[MsRg_MArea.QwkIndex] := [];
                RwBaseIdx^[ThisBase] := MsRg_MArea.QwkIndex;
            END;
    END;

    PROCEDURE InitScanInfo;
    BEGIN
       ScanInfoLen := 0;
       GetMem(ScanInfo,4096);
       AcsTableLen := 0;
       RwBaseIdxPos := 0;
       RwBaseIdxLen := MsRg_MAreaNum;
       GetMem(RwBaseIdx,RwBaseIdxLen*2);

       Assign(ScanInfoFile,RwConfig.RwMainDir+'SCANINFO.RW');
       IF NOT FExists(RwConfig.RwMainDir+'SCANINFO.RW')
          THEN Rewrite(ScanInfoFile,4096)
          ELSE Reset(ScanInfoFile,4096);

       IF RwUserNum >= FileSize(ScanInfoFile) THEN RWI_InitScanInfo;

       Seek(ScanInfoFile,RwUserNum);
       BlockRead(ScanInfoFile,ScanInfo^,1,BytesRead);
       Close(ScanInfoFile);
    END;

BEGIN
   InitScanInfo;
   Seek(MsRg_MAreaFile,0);

   InfBuff := @MsgTxtBuff^[1];
   InfBuffPos := 0;
   ThisBase := 0;

   Assign(bwInfFile,RwConfig.RwWorkDir+'BWINFTMP.'+RwNodeStr);
   Rewrite(bwInfFile,SizeOf(Inf_AreaInfo));
   RWM_STableOpen;

   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      BEGIN
         MsRg_MAreaRead(ThisBase);
         IF MsRg_MArea.QwkIndex > ScanInfoLen THEN ScanInfoLen := MsRg_MArea.QwkIndex;
         CheckScan;
         FillChar(ScanTable,SizeOf(ScanTable),0);
         ScanTable.AreaNum := ThisBase;
         BlockWrite(File(ScanTableFile),ScanTable,1);
      END;

   RWM_STableClose;
   FlushInfBuff;
   RWM_WriteScanInfo;
   Close(bwInfFile);
   Assign(bwInfFile,RwWorkDir+RwConfig.BBSID+'.INF');
END;


PROCEDURE RWI_InitNewUser;
BEGIN
   IF fk_Task.Share THEN FileMode := 66;
   RwUserNum := FileSize(RwUserFile);

   FillChar(RwUser,SizeOf(RwUser),0);

   RwUser.UserRecNum   := RgUserNum;
   RwUser.Alias        := MsRg_User.Name;
   RwUser.RealName     := MsRg_User.RealName;

   RwUser.BWaveFlags   := [];
   RwUser.RwFlags      := [];
   RwUser.MsgsLimit    := RwConfig.DefaultMsgsLimit;
   RwUser.RwProtocol   := RwConfig.DefaultProt;
   RwUser.AttachMethod := 0;

   IF RwConfig.DefaultHotkeys THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwHotkeys];
   IF RwConfig.DefaultExpert THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwXpert];
   IF RwConfig.DefaultNotMyMail THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwNotMyMail];
   IF RwConfig.DefaultNumeric THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwNumericPkt];
   IF RwConfig.DefaultFileList THEN RwUser.BWaveFlags := RwUser.BWaveFlags+[RwFileList];
   IF RwConfig.DefaultQwk THEN RwUser.RwFlags := RwUser.RwFlags+[RwPacketQwk];
   IF RwConfig.DefaultNukeEmail THEN RwUser.RwFlags := RwUser.RwFlags+[RwNukeEmail];

   Seek(RwUserFile,FileSize(RwUserFile));
   Write(RwUserFile,RwUser);
END;


FUNCTION RWI_CheckNewUser:Boolean;
VAR FPos:Word;
BEGIN
   IF fk_Task.Share THEN FileMode := 66;
   Assign(RwUserFile,RwConfig.RwMainDir+'USERS.RW');
   IF FExists(RwConfig.RwMainDir+'USERS.RW')
      THEN Reset(RwUserFile)
      ELSE Rewrite(RwUserFile);
   IF FileSize(RwUserFile) > 0 THEN FOR FPos := 0 TO (FileSize(RwUserFile)-1) DO
      BEGIN
         Seek(RwUserFile,FPos);
         Read(RwUserFile,RwUser);
         IF FormatName(RwUser.RealName) = FormatName(MsRg_User.RealName) THEN
            BEGIN
               RwUser.Alias := MsRg_User.Name;
               RwUserNum := FPos;
               RWI_CheckNewUser := FALSE;
               Exit;
            END;
      END;
   RWI_CheckNewUser := TRUE;
END;


PROCEDURE RWI_DisplayLogo;
VAR LogoPos:Word;
BEGIN
   LogoPos := 1;
   REPEAT
      CASE RwLogo[LogoPos] OF
          #0..#15 : fk_TextForeground(Ord(RwLogo[LogoPos]));
         #16..#23 : fk_TextBackground(Ord(RwLogo[LogoPos]));
              #24 : fk_WriteLn('',1);
              #25 : BEGIN
                       fk_Write(RepChar(' ',Ord(RwLogo[LogoPos+1])+1));
                       Inc(LogoPos)
                    END;
              #26 : BEGIN
                       fk_Write(RepChar(RwLogo[LogoPos+2],Ord(RwLogo[LogoPos+1])+1));
                       Inc(LogoPos,2);
                    END;
              #27 : fk_Host.Blink := fk_Host.Blink XOR TRUE;
         ELSE fk_Write(RwLogo[LogoPos]);
      END;
      Inc(LogoPos);
   UNTIL (LogoPos > RwLogo_Length);
END;


PROCEDURE RWI_ProductInfo;
VAR RwLogoPos:Byte; RegStr:String;
BEGIN
   fk_ClrScr;
   RWI_DisplayLogo;

   IF Regd AND QuickMode THEN
      BEGIN
         FOR RwLogoPos := 1 TO (61-Length(RwKey.RegBBS)) DIV 2 DO fk_write(' ');
         RWM_WriteColor('|09 |03Registered to |11'+RwKey.RegBBS+' |09'+#13#10#13#10);
         Exit;
      END;

   IF Regd
       THEN BEGIN
             FOR RWLogoPos := 1 TO (80-30-Length(RwKey.RegName)-Length(RwKey.RegBBS)) DIV 2 DO fk_write(' ');
             RWM_WriteColor('|09 |03Registered to '+
                           ' |11'+RwKey.RegName);
             RWM_WriteColor('|03 for use on |11'+RwKey.RegBBS+' |09');
             fk_WriteLn('',2);
          END
       ELSE BEGIN
             RWM_WriteColor('      |09 |12Unregistered evaluation copy |09'+#13#10#13#10);

             RWL_WriteLog(' ','! '+RWL_LogTime+' This copy of ReneWave is UNREGISTERED!  After your 30 day trial');
             RWL_WriteLog(' ','! '+RWL_LogTime+' period, you MUST register, or discontinue use of this product.');
             RWL_WriteLog(' ','! '+RWL_LogTime+' Please support the shareware concept, and fill out RENEWAVE.REG!');
          END;
END;


PROCEDURE RWI_InitCfg;
VAR CfgFile:FILE OF ConfigRec; CfgPath:String;
BEGIN
   FillChar(RwConfig,SizeOf(RwConfig),0);

   IF      GetEnv('RENEWAVE') <> '' THEN CfgPath := AddSlash(GetEnv('RENEWAVE'))
   ELSE    CfgPath := AddSlash(ExtractFDir(ParamStr(0)));

   IF NOT Fexists(CfgPath+'SETUP.RW') THEN RWE_ReportErr1(1,'Couldn''t find '+CfgPath+'SETUP.RW');

   Assign(CfgFile,CfgPath+'SETUP.RW');
   Reset(CfgFile);
   Read(CfgFile,RwConfig);
   Close(CfgFile);
   RwAcs_ForceOvr := EvalAcs(RwConfig.ForceOvrAcs);
   MsRg_CfgPath := AddSlash(RwConfig.RgMainDir);
   CommType := RwConfig.RwCommType;
   RWK_ReadKey(RwConfig.RwMainDir);

   CASE RwConfig.RgVer OF
      0 : BEGIN
             MsRg_ExtSize := NewExtSize;
             MsRg_UserVer := 0511;
             MsRg_USerRecSize := SizeOf(UserRec);
          END;
      1 : BEGIN
             MsRg_ExtSize := OldExtSize;
             MsRg_UserVer := 1005;
             MsRg_UserRecSize := SizeOf(OldUserRec);
          END;
      2 : BEGIN
             MsRg_ExtSize := NewExtSize;
             MsRg_UserVer := 1031;
             MsRg_UserRecSize := SizeOf(OldUserRec);
          END;
   END;

   Regd := RWK_CheckReg;
END;


PROCEDURE Replace_NoCarrier;
BEGIN
   RWL_WriteLog('?',RWL_LogTime+' Carrier lost!');
   fkp_CarrierLoss;
END;


PROCEDURE DummyProc;
BEGIN
END;


PROCEDURE Replace_NoCarrier2;
BEGIN
END;


PROCEDURE Replace_TimeOut;
BEGIN
   IF NOT RwConfig.HangUpOnTimeOut
      THEN RWL_WriteLog('?',RWL_LogTime+' User timeout!')
      ELSE BEGIN
         RWL_WriteLog('?',RWL_LogTime+' User timeout - dropping carrier.');
         fk_CarrierLoss := Replace_NoCarrier2;
         fk_ToggleDTR(FALSE); Delay(1000);
         fk_ToggleDTR(TRUE);  Delay(1000);
         fk_CarrierLoss := fkp_CarrierLoss;
      END;
   fk_DeInitFossil;
END;


PROCEDURE RWI_InitFossil;
VAR Port,Speed,Locked:LongInt; code:Word; Emm:Byte; s:string;
BEGIN
   s := AddSlash(ParamStr(1));

   IF FExists(s+'DOOR.SYS')
      THEN fk_ReadDoorSys(AddSlash(s))
      ELSE IF (ForceUserNum < 1) OR (ForcePort < 0) OR
              (ForceBaud    < 0) OR (ForceLocked < 0)
              THEN RWE_ReportErr1(250,'Unable to read DOOR.SYS and/or not enough parameters');

   IF ForcePort > 0    THEN fk_Fossil.Port := ForcePort;
   IF ForceBaud > 0    THEN fk_Fossil.Baud := ForceBaud;
   IF ForceLocked > 0  THEN fk_Fossil.Locked := ForceLocked;
   IF ForceNode <> $FF THEN fk_Host.Node := ForceNode;

   RWI_InitUsers;
   RWI_InitNode;

   IF ForceAddr > 0 THEN BaseAddress := ForceAddr;
   IF ForceIRQ > 0  THEN Irq := ForceIRQ;

   fk_Host.Colour.Handle := $1F;
   fk_Host.Colour.Name   := $17;
   fk_Host.Multinode     := TRUE;

   fk_InitFossil_DF(25);

   IF CommType > 0 THEN
      BEGIN
         MsRg_Node.Irq := StrFunc(Irq);
         MsRg_Node.Address := StripLeadingCh(Int2Hex(BaseAddress),'0');
      END;

   IF fk_Host.Error = 2  THEN RWE_ReportErr1(250,'Unable to initialize FOSSIL driver');
   IF fk_Fossil.Baud = 0 THEN fk_Client.ScreenType := 1;

   fk_CarrierLoss        := Replace_NoCarrier;
   fk_LocalInput         := RWM_LocalInput;
   fk_TimeOut            := Replace_TimeOut;

   IF ForceEmul = $FF
      THEN BEGIN
            IF      (AVATAR IN MsRg_User.Flags) THEN Emm := 2
            ELSE IF (ANSI   IN MsRg_User.Flags) THEN Emm := 1
            ELSE Emm := 0;
         END
      ELSE Emm := ForceEmul;

   fk_Client.ScreenType  := Emm;
   fk_Client.Handle      := MsRg_User.Name;
   fk_Client.Name        := MsRg_User.RealName;
   fk_Host.Inactivity    := Word(RwConfig.TimeOutMinutes)*60;

   IF ForceNode <> $FF THEN fk_Host.Node := ForceNode;
END;


PROCEDURE RWI_InitGeneral;
BEGIN
   IF FExists(RwConfig.RgMainDir+'RENEGADE.DAT') THEN MsRg_CfgPath := AddSlash(RwConfig.RgMainDir);
   MsRg_GeneralRead;
   MsRg_MAreaOpen;
END;


PROCEDURE RWI_InitParams;
VAR ParamS:String; ParamNum:Byte;

    PROCEDURE GetPortInfo;
    VAR s:String; b:Byte;
    BEGIN
       s := ParamS;  Delete(s,1,3);  IF Pos(',',s) = 0 THEN Exit;

       b := Pos(',',s); IF (b > 0) THEN ForcePort := ValFunc(Copy(s,1,b-1)); Delete(s,1,b);
       b := Pos(',',s); IF (b > 0) THEN ForceBaud := ValFunc(Copy(s,1,b-1)); Delete(s,1,b);
       b := Length(s);  IF (b > 0) THEN ForceLocked := ValFunc(Copy(s,1,b));
    END;

BEGIN
   IF (ParamCount = 0) THEN  RWE_ReportErr1(0,'');
   IF ParamStr(1) = '?' THEN RWE_HelpScreenExtra;

   FOR ParamNum := 1 TO ParamCount DO
      BEGIN
         ParamS := ParamStr(ParamNum);
         ParamS := UpcaseStr(ParamS);
         IF (ParamS[1] IN ['-','/']) THEN
            BEGIN
               IF Length(ParamS) = 2 THEN
                  CASE ParamS[2] OF
                     'D' : WarpDL := TRUE;
                     'U' : WarpUL := TRUE;
                     'Q' : QuickMode := TRUE;
                  END
               ELSE IF (Length(ParamS) > 3) AND (Copy(ParamS,2,2) = 'N:') THEN
                  BEGIN
                     IF ValFunc(Copy(ParamS,4,Length(ParamS)-3)) >= 0
                        THEN ForceNode := ValFunc(Copy(ParamS,4,Length(ParamS)-3));
                  END
               ELSE IF (Length(ParamS) = 4) AND (Copy(ParamS,2,2) = 'E:') THEN
                  BEGIN
                     IF (ValFunc(Copy(ParamS,4,1)) IN [0..2])
                        THEN ForceEmul := ValFunc(Copy(ParamS,4,1));
                  END
               ELSE IF (Length(ParamS) > 3) AND (Copy(ParamS,2,2) = 'U:') THEN
                  BEGIN
                     IF ValFunc(Copy(ParamS,4,Length(ParamS)-3)) >= 0
                        THEN ForceUserNum := ValFunc(Copy(ParamS,4,Length(ParamS)-3));
                  END
               ELSE IF (Length(ParamS) > 7) AND (Copy(ParamS,2,2) = 'C:') THEN
                  BEGIN
                     GetPortInfo;
                  END
               ELSE IF (Length(ParamS) > 5) AND (Copy(ParamS,2,2) = 'P:') THEN
                  BEGIN
                     Delete(ParamS,1,3);
                     ForceAddr := Hex2Int(Copy(ParamS,1,Pos(',',ParamS)-1));
                     ForceIRQ := ValFunc(Copy(ParamS,Pos(',',ParamS)+1,Length(ParamS)-Pos(',',ParamS)));
                  END
               ELSE IF (Length(ParamS) > 4) AND (Copy(ParamS,2,2) = 'F:') THEN
                  BEGIN
                     ParamS := UpcaseStr(Copy(ParamS,4,Length(ParamS)-3));
                     IF ParamS='ON'  THEN CommType := 0 ELSE
                     IF ParamS='OFF' THEN CommType := 1;
                  END
               ELSE IF (Copy(ParamS,2,2) = 'PN') THEN PreScanMode := TRUE
               ELSE IF (Copy(ParamS,2,2) = 'PL') THEN PreScanMode := TRUE
               ELSE IF (Copy(ParamS,2,2) = 'PU') THEN PreScanMode := TRUE;
            END;
      END;
END;


PROCEDURE RWI_InitVars;
BEGIN
   HighIntensity(TRUE);
   SetCBreak(FALSE);
   BreakOff;

   CloseClrScr := TRUE;
   RandSeed    := 4968192;
   LogOpened   := FALSE;
   CreateSem   := FALSE;

   { Initialize commandline parameter defaults }

   WarpDL        := FALSE;
   WarpUL        := FALSE;
   QuickMode     := FALSE;
   PrescanMode   := FALSE;

   ForceAddr     := 0;
   ForceIRQ      := 0;
   ForceNode     := $FF;
   ForceEmul     := $FF;
   ForceUserNum  := -1;
   ForcePort     := -1;
   ForceBaud     := -1;
   ForceLocked   := -1;

   New(MsgTxtBuff);
   New(FtiBuff);
   New(HdrBuff);

   FillChar(MsgTxtBuff^,SizeOf(MsgTxtBuff^),0);
   FillChar(FtiBuff^,SizeOf(FtiBuff^),0);
   FillChar(HdrBuff^,SizeOf(HdrBuff^),0);

   FtiBuffLen     := 0;
   HdrBuffLen     := 0;
   HdrBuffPos     := 0;
   MsgTxtBuffSize := 0;

   SetMciStrings := RWM_SetMciStrings;

   IF MyShare.ShareInstalled THEN FileMode := 66;
END;


PROCEDURE RWI_InitVars1;
BEGIN
   RwNodeStr := StrFunc(fk_Host.Node);
   RwWorkDir := RwConfig.RwWorkDir+RwNodeStr+'\';
   DirMake(RwWorkDir);
   IF (MsRg_General.Multinode=FALSE)
      THEN MsRg_TempPath := AddSlash(MsRg_General.TempPath)
      ELSE MsRg_TempPath := StripSlash(MsRg_General.TempPath)+RwNodeStr+'\';

   MSBW_GetString  := RWM_GetString;
   MSBW_WriteColor := RWM_WriteColor;
END;


PROCEDURE RWI_InitVars2;
BEGIN
   New(RepInfo);
   New(DupeRecBuff);
   New(RwVariables);

   MciVars := RwVariables;

   FillChar(RwVariables^,SizeOf(RwVariables^),0);
   FillChar(RepInfo^,SizeOf(RepInfo^),0);
   DupeBuffLen := 0;
END;


PROCEDURE RWI_DeInitVars;
BEGIN
   HighIntensity(FALSE);
   FreeMem(RwBaseIdx,RwBaseIdxLen*2);
   Dispose(RepInfo);
   Dispose(RwVariables);
   Dispose(DupeRecBuff);
   Dispose(MsgTxtBuff);
   Dispose(FtiBuff);
   Dispose(HdrBuff);
   CloseClrScr := TRUE;
END;


PROCEDURE RWI_ReadLangConfig(Lang:String);
VAR LangConfig:Text; s:String;
BEGIN
   IF NOT FExists(Lang+'.RWC') THEN RWE_ReportErr1(0,'Unable to locate "'+Lang+'.RWC"');

   Assign(LangConfig,Lang+'.RWC');
   Reset(LangConfig);

   WHILE NOT Eof(LangConfig) DO
      BEGIN
         ReadLn(LangConfig,s);
         s := StripLeadingCh(s,' ');
         s := StripTrailingCh(s,' ');
         s := UpcaseStr(s);
         WHILE Pos('  ',s) > 0 DO Delete(s,Pos('  ',s),1);

         IF      Copy(s,1,14) = 'AREASTEMPLATE '   THEN RwTpl_Areas := Copy(s,15,Length(s)-14)
         ELSE IF Copy(s,1,13) = 'AREASPERPAGE '    THEN RwTpl_AreasN := ValFunc(Copy(s,14,Length(s)-13))
         ELSE IF Copy(s,1,10) = 'STARTMENU '       THEN RwTpl_Start := Copy(s,11,Length(s)-10)
         ELSE IF Copy(s,1,10) = 'AREASHELP '       THEN RwHlp_Areas := Copy(s,11,Length(s)-10)
         ELSE IF Copy(s,1,11) = 'BUNDLEHELP '      THEN RwHlp_Bundle := Copy(s,12,Length(s)-11)
         ELSE IF Copy(s,1,16) = 'BUNDLESHORTHELP ' THEN RwHlp_BundleS := Copy(s,17,Length(s)-16)
         ELSE IF Copy(s,1,12) = 'NEWUSERHELP '     THEN RwHlp_NewUser := Copy(s,13,Length(s)-12);
      END;

   RwTpl_Areas   := MsRg_MciString(RwTpl_Areas);
   RwTpl_Start   := MsRg_MciString(RwTpl_Start);
   RwHlp_Areas   := MsRg_MciString(RwHlp_Areas);
   RwHlp_Bundle  := MsRg_MciString(RwHlp_Bundle);
   RwHlp_BundleS := MsRg_MciString(RwHlp_BundleS);
   RwHlp_NewUser := MsRg_MciString(RwHlp_NewUser);

   Close(LangConfig);
END;


PROCEDURE RWI_ReadPrompts;
VAR LangFile:FILE; s:String; VarNum:Word; DirInfo:SearchRec;
BEGIN
   s := RwConfig.RwLangDir+'ENGLISH';
   IF NOT FExists(s+'.RWL') THEN
      BEGIN
         FindFirst(RwConfig.RwLangDir+'*.RWL',Archive,DirInfo);
         IF DosError = 0
            THEN RWE_ReportErr1(255,'Unable to locate "'+s+'.RWL"')
            ELSE s := RwConfig.RwLangDir+RemoveExtension(DirInfo.Name);
      END;

   RWI_ReadLangConfig(s);

   Assign(LangFile,s+'.RWL');
   Reset(LangFile,1);

   RwStrBuffSize := FileSize(LangFile)-SizeOf(MsStrTableType);
   GetMem(RwStrBuff,RwStrBuffSize);
   FillChar(RwStrBuff^,RwStrBuffSize,0);
   FillChar(RwStrTable,SizeOf(RwStrTable),0);
   BlockRead(LangFile,RwStrTable,SizeOf(MsStrTableType),BytesRead);
   BlockRead(LangFile,RwStrBuff^,RwStrBuffSize,BytesRead);
   Close(LangFile);
END;


PROCEDURE RWI_UserToFK;
BEGIN
   RgUserNum := ForceUserNum;

   MsRg_UserFileOpen;
   MsRg_UserFileRead(RgUserNum);
   MsRg_UserFileClose;

   fk_Client.BBSName    := '';
   fk_Client.Calls      := MsRg_User.LoggedOn;
   fk_Client.Citystate  := MsRg_User.CityState;
   fk_Client.Downloads  := MsRg_User.Downloads;
   fk_Client.Firstdate  := Unix2DateStr(1,MsRg_User.FirstOn);
   fk_Client.Handle     := FormatName(MsRg_User.Name);
   fk_Client.HomePhone  := MsRg_User.Ph;
   fk_Client.Lastdate   := Unix2DateStr(1,MsRg_User.LastOn);
   fk_Client.Lasttime   := '';
   fk_Client.Name       := MsRg_User.RealName;
   fk_Client.Pagelength := MsRg_User.PageLen;
   fk_Client.Password   := '';
   fk_Client.RecordPos  := RgUserNum;
   fk_Client.Security   := MsRg_User.SL;
   fk_Client.SysOpName  := '';
   fk_Client.Timeleft   := LongInt(MsRg_User.TLToday)*60;
   fk_Client.Uploads    := MsRg_User.Uploads;
   fk_Client.WorkPhone  := MsRg_User.Ph;
END;


PROCEDURE RWI_InitUsers;
VAR i:Word; UNum:String;
BEGIN
   IF ForceUserNum >= 0 THEN RWI_UserToFK;

   MsRg_UserFileOpen;
   RgUserNum := fk_Client.RecordPos;
   MsRg_UserFileRead(RgUserNum);

   WITH MsRg_User,MsRg_General DO
      IF (DefArcType = 0) OR (DefArcType > MaxArcs) OR NOT (FileArcInfo[DefArcType].Active) THEN
         FOR i := MaxArcs DOWNTO 1 DO
            IF MsRg_General.FileArcInfo[i].Active THEN
               MsRg_User.DefArcType := i;

   MsRg_UserFileWrite(RgUserNum);
   MsRg_UserFileClose;

   UserAliasUpper := UpcaseStr(MsRg_User.Name);
   UserNameUpper  := UpcaseStr(MsRg_User.RealName);

   RWI_InitScheme(MsRg_User.ColorScheme-1);
END;


FUNCTION RWI_LogDate:String;
VAR TempRes:String; Year, Month, Day, DayOfWeek : Word;
BEGIN
   GetDate(Year,Month,Day,DayOfWeek);
   CASE DayOfWeek OF
      0 : TempRes := 'Sun ';
      1 : TempRes := 'Mon ';
      2 : TempRes := 'Tue ';
      3 : TempRes := 'Wed ';
      4 : TempRes := 'Thu ';
      5 : TempRes := 'Fri ';
      6 : TempRes := 'Sat ';
   END;
   TempRes := TempRes + StrFunc(Day);
   CASE Month OF
      1  : TempRes := TempRes + ' Jan ';
      2  : TempRes := TempRes + ' Feb ';
      3  : TempRes := TempRes + ' Mar ';
      4  : TempRes := TempRes + ' Apr ';
      5  : TempRes := TempRes + ' May ';
      6  : TempRes := TempRes + ' Jun ';
      7  : TempRes := TempRes + ' Jul ';
      8  : TempRes := TempRes + ' Aug ';
      9  : TempRes := TempRes + ' Sep ';
      10 : TempRes := TempRes + ' Oct ';
      11 : TempRes := TempRes + ' Nov ';
      12 : TempRes := TempRes + ' Dec ';
   END;
   TempRes := TempRes + StrFunc(Year);
   RWI_LogDate := TempRes;
END;


PROCEDURE RWI_InitLog;
BEGIN
   Assign(TempLog,RwConfig.RwWorkDir+'\TEMPLOG.'+RwNodeStr);
   Rewrite(TempLog);
   LogOpened := TRUE;
   RWL_WriteLog(' ','---------- ReneWave '+RwVer+' (Node '+RwNodeStr+') - '+RWI_LogDate);
   IF fk_Task.Share
      THEN RWL_WriteLog('~',RWL_LogTime+' Running with SHARE under '+fk_Task.System)
      ELSE RWL_WriteLog('~',RWL_LogTime+' Running without SHARE under '+fk_Task.System);

   RWL_WriteLog('~',RWL_LogTime+' Overlay buffer size: '+StrFunc(OvrGetBuf DIV 1024)+'k /'+
                                ' Free heap memory: '+StrFunc(MemAvail DIV 1024)+'k');
   RWL_WriteLog('~',RWL_LogTime+' User: '+MsRg_User.RealName+' ('+MsRg_User.Name+')');

   IF (WarpDL) OR (WarpUL) THEN
      BEGIN
         RWL_WriteLog('~',RWL_LogTime+' Run-time parameters information:');
         IF WarpUL THEN RWL_WriteLog('~',RWL_LogTime+'  -> [/U] Warp auto-upload mode eanbled');
         IF WarpDL THEN RWL_WriteLog('~',RWL_LogTime+'  -> [/D] Warp auto-download mode enabled');
         IF PrescanMode THEN RWL_WriteLog('~',RWL_LogTime+'  -> [/Px] Packet prescan mode enabled');
      END;
   CASE RwConfig.RgVer OF
      0 : RWL_WriteLog('~',RWL_LogTime+' Running in Renegade v5-11 compatibility mode');
      1 : RWL_WriteLog('~',RWL_LogTime+' Running in Renegade v10-05 compatibility mode');
   END;
END;


PROCEDURE RWI_CombineLog;
BEGIN
   WriteLn(TempLog,'');
   Close(TempLog);
   CopyFile(RwConfig.RwWorkDir+'TEMPLOG.'+RwNodeStr,RwConfig.LogFile,FALSE);
   Erase(TempLog); IF IOResult <> 0 THEN ;
END;


PROCEDURE RWI_MakeDir(s:String);
BEGIN
   WriteLn('Created directory: ',s);
   RWL_WriteLog('=',RWL_LogTime+' Created directory: '+s);
   DirMake(s);
END;


PROCEDURE RWI_InitPaths;
BEGIN
   IF NOT DirExists(RwConfig.RwMainDir)  THEN RWI_MakeDir(RwConfig.RwMainDir);
   IF NOT DirExists(RwConfig.RwWorkDir)  THEN RWI_MakeDir(RwConfig.RwWorkDir);
   IF NOT DirExists(RwConfig.RwMenuDir)  THEN RWI_MakeDir(RwConfig.RwMenuDir);
   IF NOT DirExists(RwConfig.RwHelpDir)  THEN RWI_MakeDir(RwConfig.RwHelpDir);
   IF NOT DirExists(RwConfig.RwTextDir)  THEN RWI_MakeDir(RwConfig.RwTextDir);
   IF NOT DirExists(RwConfig.RwLangDir)  THEN RWI_MakeDir(RwConfig.RwLangDir);
   IF NOT DirExists(RwConfig.LocalULDir) THEN RWI_MakeDir(RwConfig.LocalUlDir);
   IF NOT DirExists(RwConfig.LocalDlDir) THEN RWI_MakeDir(RwConfig.LocalDlDir);

   IF NOT DirExists(ExtractFDir(RwConfig.LogFile)) THEN RWI_MakeDir(ExtractFDir(RwConfig.LogFile));
END;


PROCEDURE RWI_InitNode;
VAR NodeFile : FILE OF LineRec;
BEGIN
   FillChar(MsRg_Node,SizeOf(MsRg_Node),0);
   IF NOT FExists(MsRg_General.DataPath+'NODE'+StrFunc(fk_Host.Node)+'.DAT') THEN Exit;
   Assign(NodeFile,MsRg_General.DataPath+'NODE'+StrFunc(fk_Host.Node)+'.DAT');
   Reset(NodeFile);
   Seek(NodeFile,0);
   Read(NodeFile,MsRg_Node);
   Close(NodeFile);
END;


PROCEDURE RWI_InitScheme(SchemeNum:Byte);
VAR SchemeFile : FILE OF SchemeRec;
BEGIN
   Assign(SchemeFile,MsRg_General.DataPath+'SCHEME.DAT');
   Reset(SchemeFile);
   Seek(SchemeFile,SchemeNum);
   Read(SchemeFile,Scheme);
   Close(SchemeFile);
END;


END.
