{$O+,F+,I-}
UNIT RWERROR;

(* 

    RWERROR - ReneWave error handling/reporting routines

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


VAR CloseClrScr : Boolean;


PROCEDURE RWE_BetaSecurityViolation;
PROCEDURE RWE_CopyrightScreen;
FUNCTION  RWE_RtErrorMessage(ErrNum:Word):String;
PROCEDURE RWE_HelpScreenExtra;
PROCEDURE RWE_HelpScreen;
PROCEDURE RWE_ReportErr1(ErrLev:Word; Msg:String);


IMPLEMENTATION


USES DOS,
     CRT,
     MISC1,
     FASTW,
     MSTRINGS,
     RWMAIN,
     RWLOGS,
     RWINIT;


PROCEDURE RWE_BetaSecurityViolation;
BEGIN
   ClrScr;
   RWE_CopyrightScreen;

   WritePipe('|12WARNING - THIS VERSION OF RENEWAVE WILL NOT RUN UNREGISTERED|07'+#13#10#13#10);

   WritePipe('This version of ReneWave is a beta or gamma copy, available only to registered'+#13#10);
   WritePipe('users or MatrixSoft beta sites.  This copy is unregistered.  If you are a'+#13#10);
   WritePipe('registered sysop or beta site, please enter your registration code before you'+#13#10);
   WritePipe('attempt to run beta/gamma copies.'+#13#10#13#10);

   WritePipe('If you are NOT a sysop or beta site, we kindly request that you remove this'+#13#10);
   WritePipe('copy of ReneWave from your system entirely, and use the latest public release.'+#13#10);
   WritePipe('This is a private version not available to the general public - you are not'+#13#10);
   WritePipe('supposed to have a copy of this.'+#13#10#13#10);

   WritePipe('We appreciate your anticipated co-operation.  This program is in place to'+#13#10);
   WritePipe('ensure the integrity and security of private beta copies of ReneWave.'+#13#10#13#10);

   CloseClrScr := FALSE;
   Halt(255);
END;


PROCEDURE RWE_CopyrightScreen;
BEGIN
   ClrScr;
   WritePipe('|16|09|01');
   WritePipe('|17|09|15 RENEWAVE v'+RwVer+
             ' - Renegade Blue Wave/QWK Compatible Offline Mail Door |08|16');
   WritePipe('|17|09|09 Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft, All Rights Reserved |08|16');
   WritePipe('|17|09|07 Support: no longer supported :(                                              |08|16');
   WritePipe('|16|01|08');
END;


FUNCTION RWE_RtErrorMessage(ErrNum:Word):String;
VAR TempRes:String;
BEGIN
   CASE ErrNum OF
      2   : TempRes := 'File not found, verify all data files exist.';
      3   : TempRes := 'Path not found, verify all paths defined exist.';
      4   : TempRes := 'Too many open files, try raising FILES=XX entry.';
      5   : TempRes := 'File access denied.';
      6   : TempRes := 'Invalid file handle.';
      12  : TempRes := 'Invalid file access code.';
      15  : TempRes := 'Invalid drive number.';
      16  : TempRes := 'Cannot remove current directory.';
      17  : TempRes := 'Cannot rename across drives.';
      100 : TempRes := 'Disk read error.';
      101 : TempRes := 'Disk write error.  (Out of disk space?).';
      102 : TempRes := 'File not assigned.';
      103 : TempRes := 'File not open.';
      104 : TempRes := 'File not open for input.';
      105 : TempRes := 'File not open for output.';
      106 : TempRes := 'Invalid numeric format.';
      150 : TempRes := 'Disk is write-protected.';
      151 : TempRes := 'Unknown unit.';
      152 : TempRes := 'Drive not ready.';
      153 : TempRes := 'Unknown command.';
      154 : TempRes := 'CRC error in data.';
      155 : TempRes := 'Bad drive request structure length.';
      156 : TempRes := 'Disk seek error.';
      157 : TempRes := 'Unknown media type.';
      158 : TempRes := 'Sector not found.';
      159 : TempRes := 'Printer out of paper.';
      160 : TempRes := 'Device write fault.';
      161 : TempRes := 'Device read fault.';
      162 : TempRes := 'Hardware failure.';
      200 : TempRes := 'Division by zero.';
      201 : TempRes := 'Range check error.';
      202 : TempRes := 'Stack overflow error.';
      203 : TempRes := 'Heap overflow error.';
      204 : TempRes := 'Invalid pointer operation.';
      205 : TempRes := 'Floating point overflow.';
      206 : TempRes := 'Floating point underflow.';
      207 : TempRes := 'Invalid floating point operation.';
      208 : TempRes := 'Overlay manager not installed.';
      209 : TempRes := 'Error reading overlay file.';
   END;
   RWE_RTErrorMessage := TempRes;
END;


PROCEDURE RWE_HelpScreenExtra;
BEGIN
    ClrScr;
    RWE_CopyrightScreen;

    WritePipe('|09 |11ReneWave Advanced Options - |03Mode Toggles'+#13#10);
    WritePipe(#13#10);
    WritePipe('|15   /S |07{+} Don''t display sysop''s name, only BBS name'+#13#10);
    WritePipe('|15   /D |07Quick download mode - download packet, don''t prompt for input'+#13#10);
    WritePipe('|15   /U |07Quick upload mode - upload packet, don''t prompt for input'+#13#10);
    WritePipe(#13#10);
{    WritePipe('|09 |11ReneWave Advanced Options - |03Packet Pre-Scanning Parameters'+#13#10);
    WritePipe(#13#10);
    WritePipe('|15   /PL          |07Use local DL path instead of PRESCAN path'+#13#10);
    WritePipe('|15   /PN:<user#>  |07Prescan a mail packet for user number <user#>'+#13#10);
    WritePipe('|15   /PU:<file>   |07Prescan mail packets for user names listed in <file>'+#13#10);
    WritePipe(#13#10);
    WritePipe('|07   Note: When using any of the pre-scan options, any other options you specify'+#13#10);
    WritePipe('|07   on the command line are ignored, and ReneWave will run in pre-scan mode.'+#13#10);
    WritePipe(#13#10);}
    WritePipe('|07Type "|15RENEWAVE|07" for a list of regular options'+#13#10);
    WritePipe(#13#10);
    CloseClrScr := FALSE;
    Halt(0);
END;


PROCEDURE RWE_HelpScreen;
BEGIN
    ClrScr;
    RWE_CopyrightScreen;

    WritePipe('|09 |11Syntax  - |03RENEWAVE.EXE [path to DOOR.SYS] [option(s)]'+#13#10);
    WritePipe('|09 |11Options - |03DOOR.SYS overrides (DOOR.SYS not needed if /C: and /U: are used)'+#13#10#13#10);
    WritePipe('  |15/C:p,b,l    |07Specify COMM parameters (p,b,l=<PORT>,<BAUD>,<LOCKEDBAUD>)'+#13#10);
    WritePipe('  |15/E:#        |07Override user emulation (0=TTY/1=ANSI/2=AVATAR)'+#13#10);
    WritePipe('  |15/F:on/off   |07Override FOSSIL driver setting (ON=Use, OFF=Don''t)'+#13#10);
    WritePipe('  |15/N:node     |07Override node number with <node>'+#13#10);
    WritePipe('  |15/P:addr,irq |07Specify modem IRQ and base address (eg. "3f8,5")'+#13#10);
    WritePipe('  |15/U:user#    |07Specify <user#> of user account to use'+#13#10);
    WritePipe(#13#10);
    WritePipe('|07Type "|15RENEWAVE ?|07" for a list of advanced options that are available'+#13#10);
    WritePipe(#13#10);
END;


PROCEDURE RWE_ReportErr1(ErrLev:Word; Msg:String);
BEGIN
   RWE_HelpScreen;
   IF ErrLev > 0 THEN WritePipe('|16|09 |11ERROR (#'+StrFunc(ErrLev)+') - |03'+Msg+#13#10#13#10);
   CloseClrScr := FALSE;
   Halt(ErrLev);
END;


END.
