{$O+,F+,I-}
UNIT RWBB;

(* 

    RWBB - ReneWave bundling commands and scan table routines

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE

USES  RECORDS;

CONST HdrBuffMax   = 64;
TYPE  HdrBuffType  = Array[1..HdrBuffMax] OF MHeaderRec;

VAR   HdrBuff      : ^HdrBuffType;
      HdrBuffLen   : Word;
      HdrBuffPos   : Word;


{ File attach stuff }
PROCEDURE RWB_EditQueue;

{ Checking routines to check messages for certain things }
FUNCTION  RWB_CheckPassLimits:Boolean;
FUNCTION  RWB_ShouldDownload:Boolean;

{ Message processing }
PROCEDURE RWB_HdrBuffRead;
PROCEDURE RWB_HdrBuffGet(VAR Hdr:MHeaderRec);
PROCEDURE RWB_ProcOneMsg(FirstTime:Boolean);
PROCEDURE RWB_ProcOneBaseMsgs(FirstMsg,LastMsg:Word; FirstTime:Boolean);
FUNCTION  RWB_ProcAllBases(Qwk:Boolean):Boolean;

{ Bundling command parsing }
PROCEDURE RWB_OneBundlingCommand(InCmd:String; AllowMacros:Boolean);
PROCEDURE RWB_ParseBundlingCommands(TempCmdLine:String; AllowMacros:Boolean);
FUNCTION  RWB_ProcessBundlingCommands:Boolean;
PROCEDURE RWB_STReCalc(BaseNum:Word);

{ Bundling command processing }
PROCEDURE RWB_EraseCommands(AreaNum:Word);
PROCEDURE RWB_SubtractArea(AreaNum:Word);
PROCEDURE RWB_AddArea(AreaNum:Word);
PROCEDURE RWB_PersonalOnly(AreaNum:Word);
PROCEDURE RWB_PersonalAll(AreaNum:Word);
PROCEDURE RWB_BundleNew(AreaNum:Word);
PROCEDURE RWB_BundleOld(AreaNum:Word);
PROCEDURE RWB_KeywordsOnly(AreaNum:Word);
PROCEDURE RWB_FiltersOnly(AreaNum:Word);
PROCEDURE RWB_NoUpdatePointers(AreaNum:Word);
PROCEDURE RWB_UpdatePointers(AreaNum:Word);
PROCEDURE RWB_UseMacro(MacroNum:Word);
PROCEDURE RWB_NMessages(Cmd:String);
PROCEDURE RWB_FirstNNew(Cmd:String);

{ Display }

PROCEDURE RWB_CalcTotals;
PROCEDURE RWB_WriteHeader;
PROCEDURE RWB_WriteFooter;
PROCEDURE RWB_RelistScanTable;


IMPLEMENTATION


USES {$I FOSSTYPE.INC }

     DOS,      CRT,      MSTRINGS, MISC1,    RWBD,     RWLOGS,
     RWQWK,    RWMAIN,   RWACS,    RWSTRUCT, MSRGGEN,  MSBWGEN,
     MSBWOVR,  TIMER,    RWVARS,   RWAREAS,  BWSTRUCT;

VAR  GSize         : LongInt;
     QuitBundling,                 { User used the "!" bundling command }
     WriteNew      : Boolean;      { Tell the user "New total of ###"? }

     Aborted       : Boolean;
     SpinStr       : String[30];
     SpinPos       : Byte;


PROCEDURE RWB_EditQueue;
BEGIN
   IF NOT EvalAcs(RwConfig.AttachAcs)
      THEN MSBW_WriteColor(MSBW_GetString(293))
      ELSE MSBW_EditQueue;
END;


PROCEDURE RWB_WriteHeader;
BEGIN
   RWM_WriteColor(RWM_GetString(130));
   RWM_WriteColor(RWM_GetString(131));
   RWM_WriteColor(RWM_GetString(132));
   RWM_WriteColor(RWM_GetString(133));
   RWM_WriteColor(RWM_GetString(134));
   RWM_WriteColor(RWM_GetString(135));
END;


PROCEDURE RWB_CalcTotals;
BEGIN
   GTotal := 0; GNew := 0; GKeyword := 0; GFilter := 0; GPersonal := 0; GSize := 0;  GDL := 0;

   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            RWM_STableRead(ThisBase);
            GTotal    := GTotal    + ScanTable.MsgsTotal;
            GNew      := GNew      + ScanTable.MsgsNew;
            GKeyword  := GKeyword  + ScanTable.MsgsKeywords;
            GFilter   := GFilter   + ScanTable.MsgsFilters;
            GPersonal := GPersonal + ScanTable.MsgsPersonal;
            GSize     := GSize     + ScanTable.AreaTotalSize;
            IF NOT (stb_SkipBase IN ScanTable.BaseStat) THEN
            GDL       := GDL       + ScanTable.MsgsDownload;
         END;
END;


PROCEDURE RWB_WriteFooter;
VAR s:String;
BEGIN
   RWB_CalcTotals;

   RwVariables^[1]  := StrFunc(FAttachNum); RwVariables^[2]  := StrFunc(FAttachSize);
   RwVariables^[10] := StrFunc(GTotal);     RwVariables^[11] := StrFunc(GNew);
   RwVariables^[12] := StrFunc(GKeyword);   RwVariables^[13] := StrFunc(GFilter);
   RwVariables^[14] := StrFunc(GPersonal);  RwVariables^[15] := StrFunc(GSize DIV 1024);
   RwVariables^[16] := StrFunc(GDL);

   RWM_WriteColor(RWM_GetString(138));
   RWM_WriteColor(RWM_GetString(139));
   RWM_WriteColor(RWM_GetString(140));
   RWM_WriteColor(RWM_GetString(141));

   IF MaxMBase         THEN RWM_WriteColor(RWM_GetString(80));
   IF MaxMTotal        THEN RWM_WriteColor(RWM_GetString(81));
   IF MaxUTotal        THEN RWM_WriteColor(RWM_GetString(82));
   IF (FAttachNum > 0) THEN RWM_WriteColor(RWM_GetString(280));

   IF MaxUTotal OR MaxMBase OR MaxMTotal OR (FAttachNum > 0) THEN RWM_WriteColor(#13#10);

   RWL_WriteLog(':',RWL_LogTime+' Scanning totals:  '+StrFunc(GTotal)+' total, '+
                    StrFunc(GNew)+' new, '+StrFunc(GPersonal)+' personal.');
END;


FUNCTION RWB_CheckPassLimits:Boolean;
BEGIN
   WITH RwConfig,RwUser,ScanTable DO
      RWB_CheckPassLimits := ((MaxBaseMsgs  = 0) OR (MsgsDownload < MaxBaseMsgs)) AND
                             ((MaxTotalMsgs = 0) OR (WorkTotal    < MaxTotalMsgs)) AND
                             ((MsgsLimit    = 0) OR (WorkTotal    < MsgsLimit))
END;


FUNCTION RWB_ShouldDownload:Boolean;
VAR TempRes:Boolean;
BEGIN
   IF (scn_PersonalOnly IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN TempRes := (stm_IsPersonal IN ScanTableMsg) ELSE
   IF (scn_PersonalAll IN ScanInfo^[MsRg_MArea.QwkIndex])  THEN TempRes := (stm_IsAll IN ScanTableMsg) ELSE
   IF (scn_Keywords IN ScanInfo^[MsRg_MArea.QwkIndex])     THEN TempRes := (stm_IsKeyword  IN ScanTableMsg)
   ELSE TempRes := TRUE;

   IF (scn_Filters IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN
      IF (stm_IsFilter IN ScanTableMsg) THEN
         TempRes := FALSE;

   RWB_ShouldDownload := TempRes;
END;


PROCEDURE RWB_UpdateSpin;
BEGIN
   IF HdrBuffPos = HdrBuffLen THEN
      BEGIN
         Inc(SpinPos);
         IF SpinPos > Length(SpinStr) THEN SpinPos := 1;
         fk_BS(1);
         RWM_WriteColor(SpinStr[SpinPos]);
      END;
END;


PROCEDURE RWB_HdrBuffRead;
BEGIN
   BlockRead(File(MsgHdrFile),HdrBuff^[1],HdrBuffMax,HdrBuffLen);
   HdrBuffPos := 1;
END;


PROCEDURE RWB_HdrBuffGet(VAR Hdr:MHeaderRec);
BEGIN
   IF HdrBuffPos > HdrBuffLen THEN RWB_HdrBuffRead;
   Move(HdrBuff^[HdrBuffPos],Hdr,SizeOf(Hdr));
   Inc(HdrBuffPos);
END;


PROCEDURE RWB_ProcOneMsg(FirstTime:Boolean);
VAR TempRes:Boolean;

    PROCEDURE AddMsgInfo;
    VAR i:Byte;
    BEGIN
       IF MsRg_MArea.QwkIndex < 3 THEN MsgHdr.Date := 1;
       MSBW_GetStatus(MsgHdr.Date,MsRg_Scn.LastRead);
       IF (MsgHdr.FileAttached > 0) AND (MsgHdr.Subject <> '') THEN
          FOR i := 1 TO GetWordCount(MsgHdr.Subject) DO
             MSBW_AddAttach(GetWord(MsgHdr.Subject,i),RwUser.AttachMethod);

       WITH RwConfig,RwUser,RwUser,ScanTable DO
          IF RWB_CheckPassLimits
             THEN BEGIN
                   Inc(WorkTotal);
                   IF FirstTime AND (stm_IsNew IN ScanTableMsg) THEN
                      BEGIN
                         Inc(MsgsNew);
                         AreaTotalSize := AreaTotalSize+SizeOf(FtiRec)+MsgHdr.TextSize;
                      END;
                   IF RWB_ShouldDownload THEN
                      BEGIN
                         ScanTableMsg := ScanTableMsg+[stm_ShouldDL];
                         Inc(MsgsDownload);
                         {...}
                         IF (stm_IsPersonal IN ScanTableMsg) THEN Inc(MsgsPersonal);
                         IF (stm_IsAll      IN ScanTableMsg) THEN Inc(MsgsAll);
                         IF (stm_IsKeyword  IN ScanTableMsg) THEN Inc(MsgsKeywords);
                         IF (stm_IsFilter   IN ScanTableMsg) THEN Inc(MsgsFilters);
                      END;
                END
             ELSE BEGIN
                   ScanTableMsg := ScanTableMsg+[stm_NoBundle];
                   IF (MaxBaseMsgs > 0)  AND (MsgsDownload >= MaxBaseMsgs) THEN
                      BEGIN
                         MaxMBase := TRUE;
                         MaxReached := TRUE;
                      END;
                   IF (MaxTotalMsgs > 0) AND (WorkTotal >= MaxTotalMsgs) THEN
                      BEGIN
                         IF (MaxMTotal=FALSE) THEN MaxReached := TRUE;
                         MaxMTotal := TRUE;
                      END;
                   IF (MsgsLimit > 0) AND (WorkTotal >= MsgsLimit) THEN
                      BEGIN
                         IF (MaxUTotal=FALSE) THEN MaxReached := TRUE;
                         MaxUTotal := TRUE;
                      END;
                END;
          ScanTableMsgArr^[ThisMsg] := ScanTableMsg;
       END;

BEGIN
   RWB_UpdateSpin;
   RWB_HdrBuffGet(MsgHdr);

   MsgTo := UpcaseStr(MsgHdr.mTo.As);
   MsgFrom := UpcaseStr(MsgHdr.From.As);
   MsgSubj := UpcaseStr(MsgHdr.Subject);

   TempRes := TRUE;
   TempRes := TempRes AND NOT (mDeleted IN MsgHdr.Status);
   TempRes := TempRes AND NOT (Unvalidated IN MsgHdr.Status);
   TempRes := TempRes AND NOT (MSBW_CheckOwn AND (RwNotMyMail IN RwUser.BWaveFlags));

   IF (prvt IN MsgHdr.Status) OR (MsRg_MArea.QwkIndex < 3) THEN
      TempRes := TempRes AND (MSBW_CheckPersonal OR MSBW_CheckOwn OR EvalAcs(RwConfig.ACS_AllEmail));

   CASE MsRg_MArea.mbType OF
       10 : TempRes := TempRes AND ((netmail IN MsgHdr.Status)=FALSE);
       11 : TempRes := TempRes AND (netmail IN MsgHdr.Status);
   END;

   IF TempRes
      THEN AddMsgInfo
      ELSE ScanTableMsgArr^[ThisMsg] := [stm_NoBundle];
END;


PROCEDURE RWB_ProcOneBaseMsgs(FirstMsg,LastMsg:Word; FirstTime:Boolean);
BEGIN
   FillChar(ScanTableMsgArr^[1],ScanTableMsgMax,$80);
   IF (FirstMsg = $FFFF)
      THEN BEGIN
            FirstMsg := 0;
            Seek(MsgHdrFile,0);
            RWB_HdrBuffRead;
            REPEAT
                RWB_HdrBuffGet(MsgHdr);
                RWB_UpdateSpin;
                Inc(FirstMsg);
            UNTIL (FirstMsg >= FileSize(MsgHdrFile)) OR (MsgHdr.Date > MsRg_Scn.LastRead);
            IF MsgHdr.Date > MsRg_Scn.LastRead
               THEN ScanTable.PtrMsg := FirstMsg
               ELSE Exit;
         END
      ELSE IF (FirstMsg <= 0) OR (LastMsg > FileSize(MsgHdrFile)) THEN Exit;

   Seek(MsgHdrFile,FirstMsg-1);
   RWB_HdrBuffRead;
   IF FirstMsg <= LastMsg THEN
      FOR ThisMsg := FirstMsg TO LastMsg DO
         RWB_ProcOneMsg(FirstTime);
END;


PROCEDURE RWB_ProcOneBase(FirstMsg,LastMsg:Word; FirstTime:Boolean);
VAR BaseFile:String[80];
BEGIN
   MsRg_MAreaRead(ThisBase);
   CASE MsRg_MArea.mbType OF
       10, 11 : BEGIN
                   BaseFile := MsRg_General.MsgPath+'EMAIL';
                   MsRg_Scn.LastRead := 0;
                END;
           ELSE BEGIN
                   BaseFile := MsRg_General.MsgPath+MsRg_MArea.FileName;
                   MsRg_ScnOpen;
                   MsRg_ScnRead(RgUserNum-1);
                   MsRg_ScnClose;
                END;
   END;

   IF NOT FExists(BaseFile+'.HDR') THEN
      BEGIN
         IF FirstTime THEN RWM_STableWrite(ThisBase);
         Exit;
      END;

   Assign(MsgHdrFile,BaseFile+'.HDR');
   Reset(MsgHdrFile);
   ScanTableMsgMax := FileSize(MsgHdrFile);

   IF FirstTime
      THEN BEGIN
            ScanTable.STablePtr := FileSize(ScanTableMsgFile);
            ScanTable.STableNum := ScanTableMsgMax;
            Seek(ScanTableMsgFile,ScanTable.STablePtr);
            GetMem(ScanTableMsgArr,ScanTableMsgMax);
            ScanTable.PtrMsg := 1;
            ScanTable.MsgsNew := 0;
            ScanTable.AreaTotalSize := 0;
            IF FExists(BaseFile+'.DAT') THEN
               BEGIN
                  Assign(Dat,BaseFile+'.DAT');
                  Reset(Dat,1);
                  Close(Dat);
               END;
         END
      ELSE RWM_ReadSTF;

   WorkTotal := WorkTotal-ScanTable.MsgsDownload;
   ScanTable.MsgsTotal := ScanTable.STableNum;

   ScanTable.MsgsPersonal  := 0;
   ScanTable.MsgsAll       := 0;
   ScanTable.MsgsKeywords  := 0;
   ScanTable.MsgsFilters   := 0;
   ScanTable.MsgsDownload  := 0;

   { If there are messages to process, continue ... }
   IF ScanTableMsgMax > 0 THEN
      BEGIN
         SpinPos := 1;
         SpinStr := RWM_GetString(142);
         RWM_WriteColor(RWM_GetString(143)+SpinStr[1]);
         IF FirstTime
            THEN RWB_ProcOneBaseMsgs($FFFF,ScanTableMsgMax,TRUE)
            ELSE RWB_ProcOneBaseMsgs(FirstMsg,LastMsg,FALSE);
         fk_BS(1);
         Seek(ScanTableMsgFile,ScanTable.STablePtr);
         BlockWrite(ScanTableMsgFile,ScanTableMsgArr^[1],ScanTableMsgMax,BytesWritten);
      END;

   FreeMem(ScanTableMsgArr,ScanTableMsgMax);
   ScanTableMsgArr := NIL;
   ScanTableMsgMax := 0;
   Close(MsgHdrFile);
   RWM_STableWrite(ThisBase);
END;


FUNCTION RWB_ProcAllBases(Qwk:Boolean):Boolean;
VAR  StatusStr,
     s             : String;
     ch            : Char;
     Aborted       : Boolean;

     {$IFDEF OS2}
     i,Counter:LongInt;
     {$ELSE}
     i,Counter:Word;
     {$ENDIF}

     FUNCTION CheckAborted:Boolean;
     BEGIN
        IF fk_KeyPressed THEN
           BEGIN
              ch := Upcase(fk_Read);
              IF (Ch = ' ') OR (Ch = ^K) OR (Ch = ^X) THEN
                 BEGIN
                    Aborted := TRUE;
                    fk_PurgeInputBuffer;
                 END
           END;
        CheckAborted := Aborted;
     END;

     PROCEDURE WriteBaseInfo;
     BEGIN
        WITH ScanTable DO
           BEGIN
              RwVariables^[1] := StatusStr;                       RwVariables^[2] := StrFunc(MsgsTotal);
              RwVariables^[3] := StrFunc(MsgsNew);                RwVariables^[4] := StrFunc(MsgsKeywords);
              RwVariables^[5] := StrFunc(MsgsFilters);            RwVariables^[6] := StrFunc(MsgsPersonal);
              RwVariables^[7] := StrFunc(AreaTotalSize DIV 1024); RwVariables^[8] := StrFunc(MsgsDownload);
              RwVariables^[9] := StrFunc(ThisBase);

              IF (stb_SkipBase IN BaseStat)
                 THEN RWM_WriteColor(RWM_GetString(137))
                 ELSE RWM_WriteColor(RWM_GetString(136));
           END;
    END;

    PROCEDURE OneBase;
    BEGIN
       IF (mbForceRead IN MsRg_MArea.mbStat) AND NOT EvalAcs(RwConfig.ForceOvrAcs)
          THEN StatusStr := 'Forced'
          ELSE StatusStr := MSBW_GetStatusStr(ScanInfo^[MsRg_MArea.QwkIndex],ScanTable);

       RWB_ProcOneBase(0,0,TRUE);

       IF Aborted THEN Exit;
       WriteBaseInfo;
    END;

    PROCEDURE Init;
    VAR i:Byte;
    BEGIN
       RWM_KeyPressOff;

       Aborted := FALSE;
       MaxMBase := FALSE;
       MaxMTotal := FALSE;
       WorkTotal := 0;

       FAttachRoot := NIL;
       FAttach := FAttachRoot;
       FAttachNum := 0;
       FAttachSize := 0;
       FAttachNumI := 0;
       FAttachSizeI := 0;

       StartClock;
       RWB_WriteHeader;

       Assign(ScanTableMsgFile,RwConfig.RwWorkDir+'SCANTABL.'+RwNodeStr);
       Rewrite(ScanTableMsgFile,1);

       Move(RwUser.Keywords,UserKeywords,SizeOf(RwUser.Keywords));
       Move(RwUser.Filters,UserFilters,SizeOf(RwUser.Filters));
    END;

BEGIN
   Init;
   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) AND
         (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            MsRg_MAreaRead(ThisBase);
            FillChar(ScanTable,SizeOf(ScanTableRec),0);
            ScanTable.BaseStat := [stb_UpdatePointers,stb_BundleNew];
            IF MsRg_MArea.QwkIndex < 3 THEN ScanTable.BaseStat := ScanTable.BaseStat+[stb_NukeMessages];
            OneBase;
            IF fk_KeyPressed THEN IF CheckAborted THEN
               BEGIN
                  Close(ScanTableMsgFile);
                  Erase(ScanTableMsgFile);
                  RWM_WriteColor(RWM_GetString(28));
                  RWL_WriteLog('-',RWL_LogTime+' Scanning session aborted!');
                  RWB_ProcAllBases := FALSE;
                  Exit;
               END;
         END;

   StopClock;
   RWL_WriteLog('#',RWL_LogTime+' Scan time: '+TimeStr+' seconds');

   RWB_WriteFooter;  { Write footer & process bundling commands }
   IF NOT WarpDL THEN IF NOT RWB_ProcessBundlingCommands THEN
      BEGIN
         RWM_WriteColor(RWM_GetString(28));
         RWL_WriteLog('-',RWL_LogTime+' Download session aborted!');
         Close(ScanTableMsgFile);
         Erase(ScanTableMsgFile);
         RWL_WriteLog('=',RWL_LogTime+' Lastread pointers NOT updated');
         RWB_ProcAllBases := FALSE;
         Exit;
      END;

   StartClock;

   RWL_WriteLog('#',RWL_LogTime+' BUNDLING MAIL PACKET');
   IF NOT QWK
      THEN Aborted := RWD_ProcAllBases
      ELSE Aborted := RWQ_ProcAllBases;

   RWM_KeyPressOff;
   StopClock;
   RWL_WriteLog('#',RWL_LogTime+' Bundling time: '+TimeStr+' seconds');
   Close(ScanTableMsgFile);
   Erase(ScanTableMsgFile);
   RWB_ProcAllBases := Aborted;
END;


PROCEDURE RWB_STReCalc(BaseNum:Word);
VAR BaseIdx:Word;

   FUNCTION ShouldDownload:Boolean;
   VAR TempRes:Boolean;
   BEGIN
      IF (scn_PersonalOnly IN ScanInfo^[BaseIdx])
         THEN TempRes := (stm_IsPersonal IN ScanTableMsg)
      ELSE IF (scn_PersonalAll IN ScanInfo^[BaseIdx])
         THEN TempRes := (stm_IsAll IN ScanTableMsg)
      ELSE IF (scn_Keywords IN ScanInfo^[BaseIdx])
         THEN TempRes := (stm_IsKeyword IN ScanTableMsg) OR (stm_IsPersonal IN ScanTableMsg)
      ELSE TempRes := TRUE;

      IF (scn_Filters IN ScanInfo^[BaseIdx]) THEN
         IF (stm_IsFilter IN ScanTableMsg) THEN
            TempRes := FALSE;

      ShouldDownload := TempRes;
   END;

   PROCEDURE AddMsg;
   BEGIN
      WITH ScanTable DO
         BEGIN
            IF ((RwConfig.MaxBaseMsgs  = 0) OR (MsgsDownload <= RwConfig.MaxBaseMsgs)) AND
               ((RwConfig.MaxTotalMsgs = 0) OR (WorkTotal    <= RwConfig.MaxTotalMsgs)) AND
               ((RwUser.MsgsLimit      = 0) OR (WorkTotal    <= RwUser.MsgsLimit))
               THEN BEGIN
                     ScanTableMsg := ScanTableMsg+[stm_ShouldDL];
                     Inc(WorkTotal);
                     Inc(MsgsDownload);
                     {...}
                     IF (stm_IsPersonal IN ScanTableMsg) THEN Inc(MsgsPersonal);
                     IF (stm_IsAll      IN ScanTableMsg) THEN Inc(MsgsAll);
                     IF (stm_IsKeyword  IN ScanTableMsg) THEN Inc(MsgsKeywords);
                     IF (stm_IsFilter   IN ScanTableMsg) THEN Inc(MsgsFilters);
                  END
               ELSE WITH RwConfig,RwUser DO BEGIN
                      IF (MaxBaseMsgs > 0)  AND (MsgsDownload >= MaxBaseMsgs) THEN
                         BEGIN
                            MaxMBase := TRUE;
                            MaxReached := TRUE;
                         END;
                      IF (MaxTotalMsgs > 0) AND (WorkTotal >= MaxTotalMsgs) THEN
                         BEGIN
                            IF (MaxMTotal=FALSE) THEN MaxReached := TRUE;
                            MaxMTotal := TRUE;
                         END;
                      IF (RwUser.MsgsLimit > 0) AND (WorkTotal >= RwUser.MsgsLimit) THEN
                         BEGIN
                            IF (MaxUTotal=FALSE) THEN MaxReached := TRUE;
                            MaxUTotal := TRUE;
                         END;
                  END;
         END;
   END;

   PROCEDURE STReCalc_CheckFields(CheckNew:Boolean);
   BEGIN
      IF (stm_NoBundle IN ScanTableMsgArr^[ThisMsg]) THEN Exit;
      WITH ScanTable DO
         BEGIN
            ScanTableMsg := ScanTableMsgArr^[ThisMsg]-[stm_ShouldDL];
            IF (stm_IsNew IN ScanTableMsg) OR (CheckNew=FALSE) OR NOT (stb_BundleNew IN ScanTable.BaseStat)
               THEN IF ShouldDownload
                  THEN AddMsg;
            ScanTableMsgArr^[ThisMsg] := ScanTableMsg;
         END;
   END;

BEGIN
   BaseIdx := Abs(RwBaseIdx^[BaseNum]);

   RWM_STableRead(BaseNum);
   IF (stb_SkipBase IN ScanTable.BaseStat) THEN
      BEGIN
         ScanTable.MsgsDownload := 0;
         Exit;
      END;
   RWM_ReadSTF;

   WorkTotal := WorkTotal-ScanTable.MsgsDownload;

   ScanTable.MsgsDownload := 0;
   ScanTable.MsgsPersonal := 0;
   ScanTable.MsgsAll := 0;
   ScanTable.MsgsKeywords := 0;
   ScanTable.MsgsFilters := 0;

   IF (stb_BundleLast IN ScanTable.BaseStat) THEN WITH ScanTable DO
      BEGIN
         IF (ScanTableMsgMax > 0) THEN FOR ThisMsg := ScanTableMsgMax DOWNTO 1 DO
            IF (MsgsDownload < MsgsLast)
               THEN STReCalc_CheckFields(FALSE)
               ELSE ScanTableMsgArr^[ThisMsg] := ScanTableMsgArr^[ThisMsg]-[stm_ShouldDL];
      END

   ELSE IF (stb_BundleFirst IN ScanTable.BaseStat) THEN WITH ScanTable DO
      BEGIN
         ThisMsg := 1;
         IF ScanTableMsgMax > 0 THEN FOR ThisMsg := 1 TO ScanTableMsgMax DO
            IF MsgsDownload < MsgsFirst
               THEN STReCalc_CheckFields(TRUE)
               ELSE ScanTableMsgArr^[ThisMsg] := ScanTableMsgArr^[ThisMsg] - [stm_ShouldDL];
      END

   ELSE IF ScanTableMsgMax > 0 THEN
      FOR ThisMsg := 1 TO ScanTableMsgMax DO STReCalc_CheckFields(stb_BundleNew IN ScanTable.BaseStat);

   Seek(ScanTableMsgFile,ScanTable.STablePtr);
   BlockWrite(ScanTableMsgFile,ScanTableMsgArr^[1],ScanTableMsgMax);
   RWM_STableWrite(BaseNum);
   RWM_DeInitSTF;
END;


PROCEDURE RWB_RelistScanTable;
VAR s:String; ch:char; NumListed,BaseIdx:Word; StatusStr:String;

    PROCEDURE OneBase;
    VAR i:integer;
    BEGIN
       IF (mbForceRead IN MsRg_MArea.mbStat) AND NOT EvalAcs(RwConfig.ForceOvrAcs)
          THEN StatusStr := 'Forced'
          ELSE StatusStr := MSBW_GetStatusStr(ScanInfo^[BaseIdx],ScanTable);
       WITH ScanTable DO
          BEGIN
             RwVariables^[1] := StatusStr;                       RwVariables^[2] := StrFunc(MsgsTotal);
             RwVariables^[3] := StrFunc(MsgsNew);                RwVariables^[4] := StrFunc(MsgsKeywords);
             RwVariables^[5] := StrFunc(MsgsFilters);            RwVariables^[6] := StrFunc(MsgsPersonal);
             RwVariables^[7] := StrFunc(AreaTotalSize DIV 1024); RwVariables^[8] := StrFunc(MsgsDownload);

             IF (stb_SkipBase IN BaseStat)
                THEN RWM_WriteColor(RWM_GetString(137))
                ELSE RWM_WriteColor(RWM_GetString(136));
          END;
    END;

BEGIN
   RWB_WriteHeader;
   NumListed := 7;

   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) AND
         (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            IF KeyPressed THEN
               BEGIN
                  ch := UpCase(Readkey);
                  IF Ch = ' ' THEN
                     BEGIN
                        RWM_WriteColor(RWM_GetString(28));
                        Exit;
                     END;
               END;

            BaseIdx := Abs(RwBaseIdx^[ThisBase]);

            MsRg_MAreaRead(ThisBase);
            RWM_STableRead(ThisBase);
            OneBase;
            IF (NumListed >= MsRg_User.PageLen-1) THEN
               BEGIN
                  NumListed := 0;
                  RWM_WriteColor(RWM_GetString(13));
                  ch := fk_Read;
                  fk_Write(#13);
                  fk_ClrEol;
                  fk_Write(#13);
               END;
            Inc(NumListed);
         END;
   RWB_WriteFooter;
END;


PROCEDURE RWB_EraseCommands(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[AreaNum])]) THEN
               BEGIN
                  ThisBase := AreaNum;
                  RWM_STableRead(ThisBase);

                  IF (stb_BundleLast IN ScanTable.BaseStat) OR NOT (stb_BundleNew IN ScanTable.BaseStat) THEN
                     RWB_ProcOneBase($FFFF,ScanTable.STableNum,FALSE);

                  ScanTable.BaseStat := ScanTable.BaseStat-
                                        [stb_BundleFirst,stb_BundleLast,stb_SkipBase]+
                                        [stb_BundleNew,stb_UpdatePointers];

                  RWM_STableWrite(AreaNum);
                  RWA_ToggleBase(AreaNum,'+');
                  RWM_WriteScanInfo;
                  RWB_STReCalc(AreaNum);
               END;
         END
      ELSE
         FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  RWM_STableRead(ThisBase);

                  IF (stb_BundleLast IN ScanTable.BaseStat) OR NOT (stb_BundleNew IN ScanTable.BaseStat) THEN
                     RWB_ProcOneBase($FFFF,ScanTable.STableNum,FALSE);

                  ScanTable.BaseStat := ScanTable.BaseStat-
                                        [stb_BundleFirst,stb_BundleLast,stb_SkipBase]+
                                        [stb_BundleNew,stb_UpdatePointers];

                  RWM_STableWrite(ThisBase);
                  RWA_ToggleBase(ThisBase,'+');
                  RWM_WriteScanInfo;
                  RWB_STReCalc(ThisBase);
               END;
END;


PROCEDURE RWB_SubtractArea(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            MsRg_MAreaRead(AreaNum);
            IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
               BEGIN
                  RWM_STableRead(AreaNum);
                  ScanTable.BaseStat := ScanTable.BaseStat+[stb_SkipBase]-[stb_UpdatePointers];
                  RWM_STableWrite(AreaNum);
               END;
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               MsRg_MAreaRead(ThisBase);
               IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                  BEGIN
                     RWM_STableRead(ThisBase);
                     ScanTable.BaseStat := ScanTable.BaseStat+[stb_SkipBase]-[stb_UpdatePointers];
                     RWM_STableWrite(ThisBase);
                  END;
            END;
END;


PROCEDURE RWB_AddArea(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            RWM_STableRead(AreaNum);
            ScanTable.BaseStat := ScanTable.BaseStat-[stb_SkipBase]+[stb_UpdatePointers];
            RWM_STableWrite(AreaNum);
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               RWM_STableRead(ThisBase);
               ScanTable.BaseStat := ScanTable.BaseStat+[stb_SkipBase]-[stb_UpdatePointers];
               RWM_STableWrite(ThisBase);
            END;
END;


PROCEDURE RWB_PersonalOnly(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            MsRg_MAreaRead(AreaNum);
            IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
               BEGIN
                  ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_PersonalOnly]-[scn_PersonalAll];
                  RWB_STReCalc(AreaNum);
               END;
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               MsRg_MAreaRead(ThisBase);
               IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                  BEGIN
                     ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_PersonalOnly]-[scn_PersonalAll];
                     RWB_STReCalc(ThisBase);
                  END;
            END;
   RWM_WriteScanInfo;
END;


PROCEDURE RWB_PersonalAll(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            MsRg_MAreaRead(AreaNum);
            IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
               BEGIN
                  ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_PersonalAll]-[scn_PersonalOnly];
                  RWB_STReCalc(AreaNum);
               END;
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               MsRg_MAreaRead(ThisBase);
               IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                  BEGIN
                     ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_PersonalAll]-[scn_PersonalOnly];
                     RWB_STReCalc(ThisBase);
                  END;
            END;
   RWM_WriteScanInfo;
END;


PROCEDURE RWB_BundleNew(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[AreaNum])]) THEN
               BEGIN
                  ThisBase := AreaNum;
                  RWM_STableRead(ThisBase);
                  IF NOT (stb_BundleLast IN ScanTable.BaseStat) AND NOT (stb_BundleNew IN ScanTable.BaseStat)
                     THEN RWB_ProcOneBase($FFFF,ScanTable.STableNum,FALSE);
                  ScanTable.BaseStat := ScanTable.BaseStat+[stb_BundleNew];
                  RWM_STableWrite(ThisBase);
                  RWB_STReCalc(ThisBase);
               END;
         END
      ELSE
         FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  RWM_STableRead(ThisBase);
                  IF NOT (stb_BundleLast IN ScanTable.BaseStat) AND NOT (stb_BundleNew IN ScanTable.BaseStat)
                     THEN RWB_ProcOneBase($FFFF,ScanTable.STableNum,FALSE);
                  ScanTable.BaseStat := ScanTable.BaseStat+[stb_BundleNew];
                  RWM_STableWrite(ThisBase);
                  RWB_STReCalc(ThisBase);
               END;
END;


PROCEDURE RWB_BundleOld(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            ThisBase := AreaNum;
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  RWM_STableRead(ThisBase);
                  IF NOT (stb_BundleLast IN ScanTable.BaseStat) AND (stb_BundleNew IN ScanTable.BaseStat)
                     THEN RWB_ProcOneBase(1,ScanTable.STableNum,FALSE);
                  ScanTable.BaseStat := ScanTable.BaseStat-[stb_BundleNew];
                  RWM_STableWrite(ThisBase);
                  RWB_STReCalc(ThisBase);
               END;
         END
      ELSE
         FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  RWM_STableRead(ThisBase);
                  IF NOT (stb_BundleLast IN ScanTable.BaseStat) AND (stb_BundleNew IN ScanTable.BaseStat)
                     THEN RWB_ProcOneBase(1,ScanTable.STableNum,FALSE);
                  ScanTable.BaseStat := ScanTable.BaseStat-[stb_BundleNew];
                  RWM_STableWrite(ThisBase);
                  RWB_STReCalc(ThisBase);
               END;
END;


PROCEDURE RWB_KeywordsOnly(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            MsRg_MAreaRead(AreaNum);
            IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
               BEGIN
                  ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Keywords];
                  RWB_STReCalc(AreaNum);
               END;
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               MsRg_MAreaRead(ThisBase);
               IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                  BEGIN
                     ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Keywords];
                     RWB_STReCalc(ThisBase);
                  END;
            END;
   RWM_WriteScanInfo;
END;


PROCEDURE RWB_FiltersOnly(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            MsRg_MAreaRead(AreaNum);
            IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
               BEGIN
                  ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Filters];
                  RWB_STReCalc(AreaNum);
               END;
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               MsRg_MAreaRead(ThisBase);
               IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                  BEGIN
                     ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Filters];
                     RWB_STReCalc(ThisBase);
                  END;
            END;
   RWM_WriteScanInfo;
END;


PROCEDURE RWB_NoUpdatePointers(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            RWM_STableRead(AreaNum);
            ScanTable.BaseStat := ScanTable.BaseStat-[stb_UpdatePointers];
            RWM_STableWrite(AreaNum);
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            RWM_STableRead(ThisBase);
            ScanTable.BaseStat := ScanTable.BaseStat-[stb_UpdatePointers];
            RWM_STableWrite(ThisBase);
         END;
END;


PROCEDURE RWB_UpdatePointers(AreaNum:Word);
BEGIN
   IF AreaNum < $FFFF
      THEN BEGIN
            RWM_STableRead(AreaNum);
            ScanTable.BaseStat := ScanTable.BaseStat+[stb_UpdatePointers];
            RWM_STableWrite(AreaNum);
         END
      ELSE FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            RWM_STableRead(ThisBase);
            ScanTable.BaseStat := ScanTable.BaseStat+[stb_UpdatePointers];
            RWM_STableWrite(ThisBase);
         END;
END;


PROCEDURE RWB_UseMacro(MacroNum:Word);
BEGIN
   IF MacroNum > 3 THEN Exit;
   RWB_ParseBundlingCommands(RwUser.BundlMacros[MacroNum],FALSE);
END;


PROCEDURE RWB_NMessages(Cmd:String);
{
  [area #]L[n]  ...............  Bundle 'n' number of messages in the
}
VAR LPos:Byte; AreaS,NumS:String; Area,Num:Word;
    {$IFDEF OS2}
    Err:LongInt;
    {$ELSE}
    Err:Integer;
    {$ENDIF}
BEGIN
   LPos  := Pos('L',Cmd);
   AreaS := Copy(Cmd,1,LPos-1);
   NumS  := Copy(Cmd,LPos+1,Length(Cmd)-LPos);

   Err := 0;
   IF (AreaS = '*') OR (AreaS = 'ALL')
      THEN Area := $FFFF
      ELSE Area := ValFunc(AreaS)-1;

   IF (Area <> $FFFF) AND (Area >= MsRg_MAreaNum) THEN Exit;
   Val(NumS,Num,Err);
   IF (Err <> 0) THEN Exit;

   WITH ScanTable DO IF (Area < $FFFF)
      THEN BEGIN
            ThisBase := Area;
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  MsRg_MAreaRead(ThisBase);
                  IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                     BEGIN
                        RWM_STableRead(ThisBase);
                        WITH ScanTable DO IF (Num > MsgsTotal) THEN MsgsLast := MsgsTotal ELSE MsgsLast := Num;
                        ScanTable.BaseStat := ScanTable.BaseStat+[stb_BundleLast]-[stb_BundleFirst];
                        RWB_ProcOneBase(ScanTable.MsgsTotal-ScanTable.MsgsLast+1,ScanTable.MsgsTotal,FALSE);
                        RWM_STableWrite(ThisBase);
                        RWB_STReCalc(ThisBase);
                     END;
               END;
         END
      ELSE
         FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  MsRg_MAreaRead(ThisBase);
                  IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                     BEGIN
                        RWM_STableRead(ThisBase);
                        WITH ScanTable DO IF (Num > MsgsTotal) THEN MsgsLast := MsgsTotal ELSE MsgsLast := Num;
                        ScanTable.BaseStat := ScanTable.BaseStat+[stb_BundleLast]-[stb_BundleFirst];
                        RWB_ProcOneBase(ScanTable.MsgsTotal-ScanTable.MsgsLast+1,ScanTable.MsgsTotal,FALSE);
                        RWM_STableWrite(ThisBase);
                        RWB_STReCalc(ThisBase);
                     END;
               END;
   WriteNew := TRUE;
END;


PROCEDURE RWB_FirstNNew(Cmd:String);
VAR BPos:Byte; AreaS,NumS:String; Area,Num:Word;
    {$IFDEF OS2}
    Err:LongInt;
    {$ELSE}
    Err:Integer;
    {$ENDIF}
BEGIN
   BPos  := Pos('B',Cmd);
   AreaS := Copy(Cmd,1,BPos-1);
   NumS  := Copy(Cmd,BPos+1,Length(Cmd)-BPos);

   Err := 0;
   IF (AreaS = '*') OR (AreaS = 'ALL')
      THEN Area := $FFFF
      ELSE Area := ValFunc(AreaS)-1;

   IF (Area <> $FFFF) AND (Area >= MsRg_MAreaNum) THEN Exit;
   Val(NumS,Num,Err);
   IF (Err <> 0) THEN Exit;

   IF (Area < $FFFF)
      THEN BEGIN
            ThisBase := Area;
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  MsRg_MAreaRead(ThisBase);
                  IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                     BEGIN
                        RWM_STableRead(ThisBase);
                        IF (stb_BundleLast IN ScanTable.BaseStat) THEN RWB_ProcOneBase($FFFF,ScanTable.MsgsTotal,FALSE);
                        WITH ScanTable DO IF (Num > MsgsTotal) THEN MsgsFirst := MsgsTotal ELSE MsgsFirst := Num;
                        ScanTable.BaseStat := ScanTable.BaseStat+[stb_BundleFirst]-[stb_BundleLast];
                        RWM_STableWrite(ThisBase);
                        RWB_STReCalc(ThisBase);
                     END;
               END;
         END
      ELSE
         FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
            IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
               BEGIN
                  MsRg_MAreaRead(ThisBase);
                  IF NOT (mbForceRead IN MsRg_MArea.mbStat) OR EvalAcs(RwConfig.ForceOvrAcs) THEN
                     BEGIN
                        RWM_STableRead(ThisBase);
                        IF (stb_BundleLast IN ScanTable.BaseStat) THEN RWB_ProcOneBase($FFFF,ScanTable.MsgsTotal,FALSE);
                        WITH ScanTable DO IF (Num > MsgsTotal) THEN MsgsFirst := MsgsTotal ELSE MsgsFirst := Num;
                        RWM_STableWrite(ThisBase);
                        RWB_STReCalc(ThisBase);
                     END;
               END;
   WriteNew := TRUE;
END;


PROCEDURE RWB_OneBundlingCommand(InCmd:String; AllowMacros:Boolean);
VAR {$IFDEF OS2}
    AreaNum,OtherNum:LongInt;
    {$ELSE}
    AreaNum,OtherNum:Word;
    {$ENDIF}
    Cmd:String;

    FUNCTION GetValueStr(s:String):Word;
    BEGIN
       s := UpcaseStr(Copy(s,2,Length(s)-1));
       IF (s = '*') OR (s = 'ALL')
          THEN AreaNum := $FFFF
          ELSE BEGIN
                Val(s,AreaNum,OtherNum);
                IF (OtherNum <> 0) OR (AreaNum > MsRg_MAreaNum) OR (AreaNum < 1) THEN AreaNum := 0;
             END;
       GetValueStr := AreaNum;
    END;

BEGIN
    Cmd := InCmd;

    IF (Cmd[1] IN ['E','-','+','A','B','P','K','F']) THEN WriteNew := TRUE;

    IF      Cmd = '!' THEN QuitBundling := TRUE
    ELSE IF Cmd = '*' THEN RWB_EditQueue
    ELSE IF Cmd = 'R' THEN RWB_RelistScanTable
    ELSE IF Cmd = '?' THEN RWM_DispFile(RwHlp_BundleS,TRUE,MsRg_User.PageLen)
    ELSE IF Cmd = 'D' THEN RWM_DispFile(RwHlp_Bundle,TRUE,MsRg_User.PageLen)
    ELSE IF (Pos('L',Cmd) > 1) AND (Length(Cmd) > 2) THEN RWB_NMessages(Cmd)
    ELSE IF (Pos('B',Cmd) > 1) AND (Length(Cmd) > 2) THEN RWB_FirstNNew(Cmd)
    ELSE CASE Cmd[1] OF
          'E' : RWB_EraseCommands(GetValueStr(Cmd)-1);
          '-' : RWB_SubtractArea(GetValueStr(Cmd)-1);
          '+' : RWB_AddArea(GetValueStr(Cmd)-1);
          'P' : RWB_PersonalOnly(GetValueStr(Cmd)-1);
          'A' : RWB_PersonalAll(GetValueStr(Cmd)-1);
          'K' : RWB_KeywordsOnly(GetValueStr(Cmd)-1);
          'F' : RWB_FiltersOnly(GetValueStr(Cmd)-1);
          'N' : RWB_NoUpdatePointers(GetValueStr(Cmd)-1);
          'U' : RWB_UpdatePointers(GetValueStr(Cmd)-1);
          'M' : IF AllowMacros THEN RWB_UseMacro(GetValueStr(Cmd)-1);
          'B' : BEGIN
                   Delete(Cmd,1,1);
                   CASE Cmd[1] OF
                      'N' : RWB_BundleNew(GetValueStr(Cmd)-1);
                      'O' : RWB_BundleOld(GetValueStr(Cmd)-1);
                   END;
                END;
          ELSE BEGIN
                RwVariables^[1] := Cmd;
                RWM_WriteColor(RWM_GetString(30));
             END;
       END;
END;


PROCEDURE RWB_ParseBundlingCommands(TempCmdLine:String; AllowMacros:Boolean);
VAR SpcPos:Byte; BCmdLine,OneCommand:String;

    PROCEDURE WriteNewTotals;
    VAR TempTotal : LongInt;
    BEGIN
       MaxMBase := FALSE;
       fk_WriteLn('',1);
       TempTotal := 0;
       FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
         IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
            BEGIN
               RWM_STableRead(ThisBase);
               IF NOT (stb_SkipBase IN ScanTable.BaseStat) THEN
                  BEGIN
                     TempTotal := TempTotal + ScanTable.MsgsDownload;
                     IF (RwConfig.MaxBaseMsgs > 0) AND (ScanTable.MsgsDownload >= RwConfig.MaxBaseMsgs)
                        THEN MaxMBase := TRUE;
                  END;
            END;
       MaxMTotal := (RwConfig.MaxTotalMsgs > 0) AND (TempTotal >= RwConfig.MaxTotalMsgs);
       MaxUTotal := (RwUser.MsgsLimit > 0)      AND (TempTotal >= RwUser.MsgsLimit);

       IF MaxMBase  THEN RWM_WriteColor(RWM_GetString(80));
       IF MaxMTotal THEN RWM_WriteColor(RWM_GetString(81));
       IF MaxUTotal THEN RWM_WriteColor(RWM_GetString(82));

       RwVariables^[1] := StrFunc(TempTotal);
       RWM_WriteColor(RWM_GetString(83));
       RWL_WriteLog(':',RWL_LogTime+' New total of '+StrFunc(TempTotal)+' messages');
    END;


BEGIN
   WriteNew := FALSE;
   BCmdLine := StripTrailingCh(StripLeadingCh(TempCmdLine,' '),' ')+' ';
   RWL_WriteLog(':',RWL_LogTime+' Processing bundling command(s) "'+BCmdLine+'"');
   REPEAT
      SpcPos := Pos(' ',BCmdLine);
      OneCommand := Copy(BCmdLine,1,SpcPos-1);
      Delete(BCmdLine,1,SpcPos);
      RWB_OneBundlingCommand(OneCommand,AllowMacros);
      BCmdLine := StripLeadingCh(BCmdLine, ' ');
   UNTIL (Length(BCmdLine) = 0) OR QuitBundling;
   IF WriteNew AND AllowMacros THEN WriteNewTotals;
END;


FUNCTION RWB_ProcessBundlingCommands:Boolean;
VAR s:String;
BEGIN
   QuitBundling := FALSE;
   REPEAT
      RWM_WriteColor(RWM_GetString(84));
      RWM_WriteColor(RWM_GetString(85));
      RWM_WriteColor(RWM_GetString(86));

      fk_Host.ValidInput := '!0123456789-+*?ABDEFKLMNOPQRUabdefklmnpqru ';
      RWM_KeyPressOn;
      s := fk_ReadLn(200,TRUE);
      RWM_KeyPressOff;

      fk_TextColor(9);
      fk_WriteLn('',1);
      IF (s <> '') AND (s <> 'Q') THEN RWB_ParseBundlingCommands(s,TRUE);
   UNTIL (s = '') OR (s = 'Q') OR QuitBundling;
   RWB_ProcessBundlingCommands := (s <> 'Q');
END;


END.
