{$D-,F+,R-,S-,I-,Q-,V-,B-,X+,T-,P-}

{$M 20000,0,500000 }

PROGRAM RENEWAVE;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

{$DEFINE RENEWAVE}

USES  RWREG,     { RENEWAVE registration processing }
      DOS,
      CRT,
      MSTRINGS,
      MISC1,
      CRC32,
      UNIXDATE,
      MYSHARE,
      FASTW,

      RWMAIN,    { ReneWave main miscellaneous routines                     }
      RWLOGS,    { ReneWave logging routines                                }
      RWBB,      { ReneWave scan table/bundling command routines.           }
      RWBD,      { ReneWave bundling routines.                              }
      RWBT,      { ReneWave protocols/archivers/spawning routines.          }
      RWUP,      { ReneWave upload processing - messages                    }
      RWUP2,     { ReneWave upload processing - extra features              }
      RWFL,      { ReneWave file list generating routines                   }
      RWQWK,     { Renewave QWK bundling/tossing routines                   }
      RWMENUS,   { ReneWave menu processing routines                        }
      RWINIT,    { ReneWave initialization routines                         }
      RWACS,     { ReneWave ACS processing routines                         }
      RWERROR,   { ReneWave error reporting routines                        }
      RWVARS,    { ReneWave variable definitions                            }
      RWPS,      { ReneWave prescanning code                                }

      MSZ_MAIN,
      MSZ_MISC,
      MSZ_VID,
      MSZ_XMOD,
      MSZ_ZMOD,

      {$IFDEF OS2}
      MSFOSOS2,
      {$ELSE}
      MSFOSDOS,
      {$ENDIF}

      MSBWGEN,
      MSBWOVR,
      RECORDS,
      RWSTRUCT,
      BWSTRUCT,
      OVERLAY,
      EXECSWAP;


{$O RWQWK    }  {$O RWBB     }  {$O RWBD     }  {$O RWBT     }
{$O RWMENUS  }  {$O RWINIT   }  {$O RWUP     }  {$O RWFL     }
{$O RWERROR  }  {$O RWAREAS  }  {$O RWUP2    }
{$O RWPS     }  {$O MSBWOVR  }  {$O MSZ_MAIN }  {$O MSZ_MISC }
{$O MSZ_VID  }  {$O MSZ_XMOD }  {$O MSZ_ZMOD }


VAR OldExitProc : Pointer;


PROCEDURE RWE_Exit; FAR;
VAR ErrSeg,ErrOfs:String; p:pointer; tempf:File;
BEGIN
   ExitProc := OldExitProc;
   p := ErrorAddr;
   ErrorAddr := NIL;
   IF CloseClrScr THEN
      BEGIN
         Window(1,1,80,25);
         ClrScr;
         RWE_CopyrightScreen;
      END;

   IF p = NIL
      THEN BEGIN
            IF LogOpened THEN RWL_WriteLog('~',RWL_LogTime+' Exiting with errorlevel '+StrFunc(exitCode));
         END
      ELSE BEGIN
            ErrSeg := Int2Hex(seg(p^));
            ErrOfs := Int2Hex(ofs(p^));
            WritePipe('|11ERROR (#'+StrFunc(ExitCode)+' at '+ErrSeg+':'+ErrOfs+
                      '): |03'+RWE_RtErrorMessage(ExitCode)+#13#10);
            IF LogOpened THEN
               BEGIN
                  RWL_WriteLog('!',RWL_LogTime+' CRITICAL ERROR at '+ErrSeg+':'+ErrOfs+' - '+RWE_RtErrorMessage(ExitCode));
                  RWL_WriteLog('!',RWL_LogTime+' Program execution halted.');
                  RWL_WriteLog('~',RWL_LogTime+' Exiting with errorlevel '+StrFunc(exitCode));
               END;
         END;
   IF LogOpened THEN RWI_CombineLog;
   Assign(TempF,RwConfig.RwMainDir+'SCANMSGS.'+StrFunc(fk_Host.Node));
   IF CreateSem
      THEN BEGIN
            CreateSem := FALSE;
            Rewrite(TempF);
            Close(TempF);
         END
      ELSE BEGIN
            Erase(TempF);
            IF IOResult <> 0 THEN ;
         END;

   IF CommType > 0 THEN fk_DeInitFossil;
END;


FUNCTION RWB_RunDoor(CmdLine:String; RunCommand:Boolean):Byte; FAR;
VAR Result  : Word;
    FPath   : PathStr;
    Params  : String;
    vScreen : ScreenType;

    PROCEDURE RestoreInitialSettings;
    BEGIN
       TextAttr := 11;
       ClrScr;
       WriteScreen(vScreen);
       GotoXY(vScreen.CursX,vScreen.CursY);

       {$IFDEF OS2}
       IF fk_Fossil.Baud > 0 THEN Ms_InitPort;
       {$ELSE}
       CASE CommType OF
          msAsync  : Ms_AsyncOpenPort(fk_Fossil.Port,fk_Fossil.Locked);
          msFossil : Ms_FossilActivatePort;
       END;
       {$ENDIF}
       fk_PurgeInputBuffer;
       fk_Host.StatuslinePos := 25;
       Ms_DrawStatus;
    END;

    PROCEDURE PrepareForSwap;
    BEGIN
       {$IFDEF OS2}
       IF fk_Fossil.Baud > 0 THEN DosClose(fPort);
       {$ELSE}
       CASE CommType OF
          msAsync  : Ms_AsyncClose;
          msFossil : Ms_FossilClose;
       END;
       {$ENDIF}
       fk_Host.StatuslinePos := 0;      { Kill status line }
       fk_PurgeInputBuffer;             { Flush buffer }
       fk_PurgeOutputBuffer;
       {...}
       ReadScreen(vScreen);
       vScreen.CursX := WhereX;
       vScreen.CursY := WhereY;
       Window(1,1,80,25);               { Expand window }
       ClrScr;
       TextAttr := 11+(1*16);
       Write(PadRight('Executing '+CmdLine,' ',80));
    END;

    PROCEDURE ParseCmdLine;
    VAR i:Byte; FName:NameStr; FExt:ExtStr; FDir:DirStr;
    BEGIN
       i := Position(' ',CmdLine);
       IF i > 0 THEN Params := Copy(CmdLine,i+1,Length(CmdLine)-i) ELSE Params := '';
       IF i > 0 THEN FPath := Copy(CmdLine,1,i-1) ELSE FPath := CmdLine;
       FSplit(FPath,FDir,FName,FExt);
       IF (FExt = '') OR NOT FExists(FPath) THEN
          BEGIN
             FPath := FSearch(FName+'.EXE',FDir+';'+GetEnv('PATH'));
             IF FPath = '' THEN FPath := FSearch(FName+'.COM',FDir+';'+GetEnv('PATH'));
             IF FPath = '' THEN FPath := FSearch(FName+'.BAT',FDir+';'+GetEnv('PATH'));
             {$IFDEF OS2}
             IF FPath = '' THEN FPath := FSearch(FName+'.CMD',FDir+';'+GetEnv('PATH'));
             {$ENDIF}
          END;
    END;

    {$IFDEF OS2}
    PROCEDURE DoSwap;
    BEGIN
       Exec(GetEnv('COMSPEC'),'/C '+FPath+' '+Params);
       Result := Dos.DosError;
    END;
    {$ELSE}
    PROCEDURE DoSwap;
    BEGIN
       UseEmsIfAvailable := (RwConfig.SwapType = EMS);
       IF (RwConfig.SwapType = None) OR NOT InitExecSwap(HeapPtr,RWB_RandomFileName)
          THEN BEGIN
             IF (RwConfig.SwapType = None)
                THEN WritePipe('|16|03Not swapping out of memory - swapping is disabled ... |07')
                ELSE WritePipe('|16|03Error: could not swap out of memory, attempting to execute anyway ... |07');

             { Run if swapping is set to NONE or if the swapping could not be }
             { configured properly. }

             SwapVectors;
             IF RunCommand { then execute command interpreter }
                 THEN Exec(GetEnv('COMSPEC'),'/E:512 /C '+FPath+Params)
                 ELSE Exec(FPath,Params);
              SwapVectors;
              Result := DosError;
           END
        ELSE BEGIN
              WritePipe('|16|03Swapping '+StrFunc(BytesSwapped)+' bytes out of memory ... |07');
              SwapVectors;
              IF RunCommand
                 THEN Result := ExecWithSwap(GetEnv('COMSPEC'),'/E:512 /C '+FPath+Params)
                 ELSE Result := ExecWithSwap(FPath,Params);
              ShutDownExecSwap;
              SwapVectors;
           END;
    END;
    {$ENDIF}

BEGIN
   PrepareForSwap;
   ParseCmdLine;
   DoSwap;
   RestoreInitialSettings;
   RWB_RunDoor := Result;
END;


PROCEDURE RWM_InitOvr;
{ open overlay file - initially }
BEGIN
   IF MyShare.ShareInstalled THEN OvrFileMode := 66;

   RwOvrPath := FSearch('RENEWAVE.OVR',GetEnv('PATH')+';'+GetEnv('RENEWAVE')+';'+ExtractFDir(ParamStr(0)));
   OvrInit(RwOvrPath);

   IF (OvrResult <> OvrOk) THEN
      BEGIN
         WriteLn;
         WriteLn('+ ERROR: Unable to initialize RENEWAVE.OVR overlay file!');
         Halt(255);
      END;

   OvrSetBuf(50000);
   OvrSetRetry(20000);

   OldExitProc := ExitProc;
   ExitProc := @RWE_Exit;
   DoorProc := RWB_RunDoor;
END;


BEGIN
   RWM_InitOvr;
   RWI_InitVars;
   RWI_InitCfg;

   {$IFDEF BETA}
   IF NOT Regd THEN RWE_BetaSecurityViolation;
   {$ENDIF}

   RWI_InitGeneral;
   RWI_InitParams;
{
   IF PreScanMode
      THEN BEGIN
            RWP_PreScan;
            Halt(0);
         END;
}
   RWI_InitFossil;
   RWI_InitVars1;
   RWI_InitLog;
   RWI_InitVars2;

   RWM_RunMain;

   RWI_DeInitVars;
   RWM_EraseTemp;
   fk_DeInitFossil;
END.
