{$I-,O+}
UNIT MSZ_VID;

(* 

    MSZ_VID - X/Y/Zmodem code (video routines)

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


CONST BarWrittenF  : Byte = 0;
      BarWrittenB  : Byte = 0;
      AttrData     : Byte = $03;
      AttrHigh     : Byte = $0B;
      AttrText     : Byte = $07;

CONST BatchTotal   : LongInt = 0;   { Total number of bytes in queue }
      BatchTx      : LongInt = 0;   { Total number of bytes transferred }
      BatchStart   : LongInt = 0;   { Time transfer was started }
      BatchNum     : LongInt = 0;   { Number of files in queue }
      BatchCurrent : LongInt = 1;   { Current file number }
      FileTotal    : LongInt = -1;
      FileTx       : LongInt = -1;
      FileTxStart  : LongInt = -1;

VAR   StartTime    : LongInt;
      FileAddition : (NewFile,RecoverFile,ReplaceFile);


FUNCTION  Zmodem_GetBytesTX:LongInt;
FUNCTION  Zmodem_GetCps(Size,TimeElapsed:LongInt):LongInt;
PROCEDURE Zmodem_InitWindow(Send:Boolean);
PROCEDURE Zmodem_OpenWindow;
PROCEDURE Zmodem_CloseWindow;
PROCEDURE Zmodem_ShowName(FileName:String);
PROCEDURE Zmodem_ShowSize;
PROCEDURE Zmodem_ShowBlockSize(n:LongInt);
PROCEDURE Zmodem_ShowCheck(Prot:String);
PROCEDURE Zmodem_Message(s:String);
PROCEDURE Zmodem_Frame(n:Integer);
PROCEDURE Xmodem_Frame(n:Integer);
PROCEDURE Zmodem_ShowBatchLoc;
PROCEDURE Zmodem_ShowLoc;
PROCEDURE Zmodem_Errors(w:Word);


IMPLEMENTATION


USES  {$I c:\oldstuff\source\MSZ\FOSSTYPE.INC }

      MSZ_ZMOD, MSZ_XMOD, CRT,      FASTW,    MISC1,   MSTRINGS,
      UNIXDATE, MSZ_MISC, MSZ_MAIN, DOS;

CONST WindowOn     : Boolean = FALSE; { Has window been displayed? }

VAR   oldattr    : Byte;
      oldmin,
      oldmax     : Word;
      Screen1,
      Screen2    : ^ScreenType;


FUNCTION Zmodem_GetBytesTX:LongInt;
{ Returns the number of bytes of a file transferred in this session.     }
{ Used so that resumed transfers report the correct CPS rate, instead of }
{ thinking the entire file was sent in the current session.              }
BEGIN
   IF FileTxStart >= 0
      THEN Zmodem_GetBytesTX := FileTx-FileTxStart
      ELSE Zmodem_GetBytesTX := FileTx;
END;


FUNCTION Zmodem_GetCps(Size,TimeElapsed:LongInt):LongInt;
VAR i:LongInt;
BEGIN
   IF TimeElapsed = 0
      THEN i := 0
      ELSE i := (Size DIV TimeElapsed);
   Zmodem_GetCps := i+Round(i*(CpsAdj/100));
END;


{$I PROGIND.PAS }


PROCEDURE Zmodem_InitWindow(Send:Boolean);
VAR s:String;
BEGIN
   BarWrittenF := 0;
   FileTx := -1;
   FileTotal := -1;
   IF Send
      THEN WriteFast(68,StartLine+1,'  [Sending]',9)
      ELSE WRiteFast(68,StartLine+1,'[Receiving]',9);
   IF WindowOn = FALSE
      THEN BEGIN
            BarWrittenB := 0;
            IF DispName <> '' THEN ClrScr;
            ReadScreen(Screen2^);
            Move(ProgInd,Screen2^.Pos[StartLine,1],ProgInd_Length);
            WriteScreen(Screen2^);
            IF DispName <> '' THEN
               BEGIN
                  FastClr(' ',1,25,80,25,$10);
                  IF DispName <> ' ' THEN
                     BEGIN
                        WriteFast(2,25,DispName,$1B);
                        WriteFast(3+Length(DispName),25,'is online . . .',$17);
                     END;
               END;
            s := 'COM'+StrFunc(fk_Fossil.Port)+','+
                       StrFunc(fk_Fossil.Baud)+','+
                       StrFunc(fk_Fossil.Locked);

            {$IFNDEF DOS}
            IF fk_Fossil.Port > 0
               THEN s := 'COM'+StrFunc(fk_Fossil.Port)+','
               ELSE s := 'H'+StrFunc(hPort)+',';
            s := s+StrFunc(fk_Fossil.Baud)+','+StrFunc(fk_Fossil.Locked);
            {$ENDIF}

            {$IFDEF DOS}
            s := 'COM'+StrFunc(fk_Fossil.Port)+','+
                       StrFunc(fk_Fossil.Baud)+','+
                       StrFunc(fk_Fossil.Locked);
            CASE CommType OF
               msFossil : s := s+',F';
               msAsync  : s := s+',A';
            END;
            {$ENDIF}
            WriteFast(43,StartLine+1,PadRight(s,' ',24),AttrData);
         END
      ELSE BEGIN
            WriteFast(14,StartLine+4,PadRight('',' ',26),AttrData);
            WriteFast(14,StartLine+5,PadRight('',' ',26),AttrData);
            WriteFast(14,StartLine+6,PadRight('',' ',26),AttrData);
            WriteFast(36,StartLine+8,'0%  ',AttrData);
            WriteFast(3,StartLine+8,RepChar('',32),AttrData);
         END;
   WindowOn := TRUE;
END;


PROCEDURE Zmodem_OpenWindow;
VAR n,pads,bytes:Word;
BEGIN
   New(Screen1);
   New(Screen2);
   ReadScreen(Screen1^);
   Screen1^.CursX := WhereX;
   Screen1^.CursY := WhereY;
   OldAttr := TextAttr;
   OldMin := WindMin;
   OldMax := WindMax;
   WindowOn := FALSE;

   Zmodem_InitWindow(TRUE);
END;


PROCEDURE Zmodem_CloseWindow;
BEGIN
   WriteScreen(Screen1^);
   GotoXY(Screen1^.CursX,Screen1^.CursY);
   Dispose(Screen1);
   Dispose(Screen2);
   TextAttr := OldAttr;
   WindMax := OldMax;
   WindMin := OldMin;
END;


PROCEDURE Zmodem_ShowName(FileName:String);
BEGIN
   FileName := UpcaseStr(FileName);
   IF Length(FileName) > 37 THEN FileName := Copy(FileName,Length(FileName)-36,37);
   WriteFast(3,StartLine+2,PadRight(FileName,' ',37),AttrData);
END;


PROCEDURE Zmodem_ShowSize;
VAR secs:LongInt; s:String;
BEGIN
   { Show file size }
   IF FileTotal < 0 THEN
      BEGIN
         WriteFast(14,StartLine+4,'Unknown',AttrData);
         Exit;
      END;

   IF (fk_Fossil.Baud > 0) AND (FileTotal > 0)
      THEN BEGIN
            Secs := (FileTotal*10) DIV fk_Fossil.Baud;
            s := LeadingZero(Secs DIV 3600,2)+':'+LeadingZero((Secs MOD 3600) DIV 60,2)+':'+LeadingZero(Secs MOD 60,2);
         END
      ELSE s := '00:00:00';

   WriteFast(14,StartLine+4,PadRight(StrFunc(FileTotal)+' bytes',' ',16),AttrData);
   WriteFast(30,StartLine+4,s,AttrData);

   { Show batch size }
   IF BatchTotal <= 0 THEN
      BEGIN
         WriteFast(54,StartLine+4,'Unknown',AttrData);
         Exit;
      END;

   IF (fk_Fossil.Baud > 0)
      THEN BEGIN
            Secs := (BatchTotal*10) DIV fk_Fossil.Baud;
            s := LeadingZero(Secs DIV 3600,2)+':'+LeadingZero((Secs MOD 3600) DIV 60,2)+':'+LeadingZero(Secs MOD 60,2);
         END
      ELSE s := '00:00:00';

   WriteFast(54,StartLine+4,PadRight(StrFunc(BatchTotal)+' bytes',' ',16),AttrData);
   WriteFast(70,StartLine+4,s,AttrData);
END;


PROCEDURE Zmodem_ShowBlockSize(n:LongInt);
BEGIN
   IF (n <= 0) OR (n > 8192)
      THEN WriteFast(54,StartLine+12,PadRight('Unknown',' ',15),AttrData)
      ELSE WriteFast(54,StartLine+12,PadRight(StrFunc(n)+' bytes',' ',15),AttrData);
END;


PROCEDURE Zmodem_ShowCheck(Prot:String);
BEGIN
   WriteFast(54,StartLine+10,PadRight(Prot,' ',19),9);
END;


PROCEDURE Zmodem_Message(s:String);
BEGIN
   {$IFNDEF DOS}
   ReadScreen(Screen2^);
   Scroll(Screen2^,Up,3,StartLine+11,39,StartLine+14,' ',AttrData,1);
   WriteScreen(Screen2^);
   {$ELSE}
   Scroll(Screen^,Up,3,StartLine+11,39,StartLine+14,' ',AttrData,1);
   {$ENDIF}
   WriteFast(3,StartLine+14,PadRight(s,' ',37),AttrData);
END;


PROCEDURE Zmodem_Frame(n:Integer);
BEGIN
   IF n < 0
      THEN CASE Abs(Lo(n)) OF
             3 : WriteFast(54,StartLine+13,'ZNOCARRIER',AttrData);
             2 : WriteFast(54,StartLine+13,'ZTIMEOUT  ',AttrData);
             1 : WriteFast(54,StartLine+13,'ZERROR    ',AttrData);
         END
      ELSE CASE Lo(n) OF
            0  : WriteFast(54,StartLine+13,'ZRQINIT   ',AttrData);
            1  : WriteFast(54,StartLine+13,'ZRINIT    ',AttrData);
            2  : WriteFast(54,StartLine+13,'ZSINIT    ',AttrData);
            3  : WriteFast(54,StartLine+13,'ZACK      ',AttrData);
            4  : WriteFast(54,StartLine+13,'ZFILE     ',AttrData);
            5  : WriteFast(54,StartLine+13,'ZSKIP     ',AttrData);
            6  : WriteFast(54,StartLine+13,'ZNAK      ',AttrData);
            7  : WriteFast(54,StartLine+13,'ZABORT    ',AttrData);
            8  : WriteFast(54,StartLine+13,'ZFIN      ',AttrData);
            9  : WriteFast(54,StartLine+13,'ZRPOS     ',AttrData);
            10 : WriteFast(54,StartLine+13,'ZDATA     ',AttrData);
            11 : WriteFast(54,StartLine+13,'ZEOF      ',AttrData);
            12 : WriteFast(54,StartLine+13,'ZFERR     ',AttrData);
            13 : WriteFast(54,StartLine+13,'ZCRC      ',AttrData);
            14 : WriteFast(54,StartLine+13,'ZCHALLENGE',AttrData);
            15 : WriteFast(54,StartLine+13,'ZCOMPL    ',AttrData);
            16 : WriteFast(54,StartLine+13,'ZCAN      ',AttrData);
            17 : WriteFast(54,StartLine+13,'ZFREECNT  ',AttrData);
            18 : WriteFast(54,StartLine+13,'ZCOMMAND  ',AttrData);
            19 : WriteFast(54,StartLine+13,'ZSTDERR   ',AttrData);
            20 : WriteFast(54,StartLine+13,PadRight(StrFunc(n),' ',10),AttrData)
         END;
END;


PROCEDURE Xmodem_Frame(n:Integer);
BEGIN
   IF Lo(n) < 0
      THEN CASE Abs(Lo(n)) OF
             3 : WriteFast(54,StartLine+13,'NOCARRIER ',AttrData);
             2 : WriteFast(54,StartLine+13,'TIMEOUT   ',AttrData);
             1 : WriteFast(54,StartLine+13,'ERROR     ',AttrData);
         END
      ELSE CASE Lo(n) OF
           CAN  : WriteFast(54,StartLine+13,'CAN       ',AttrData);
           NAK  : WriteFast(54,StartLine+13,'NAK       ',AttrData);
        END;
END;


PROCEDURE Zmodem_ShowBatchLoc;
VAR l,Secs,i,tBytes:LongInt; s:String; Pct:Real;
BEGIN
   IF BatchNum = 1 THEN Exit;

   tBytes := BatchTx+FileTx;
   { Display batch current position }
   i := CurrentSecsFunc;
   Secs := i-BatchStart;
   IF (fk_Fossil.Baud > 0) AND (i > BatchStart)
      THEN s := LeadingZero(Secs DIV 3600,2)+':'+LeadingZero((Secs MOD 3600) DIV 60,2)+':'+LeadingZero(Secs MOD 60,2)
      ELSE s := '00:00:00';

   WriteFast(54,StartLine+5,PadRight(StrFunc(tBytes)+' bytes',' ',16),AttrData);
   WriteFast(70,StartLine+5,s,AttrData);

   { Display batch remaining }

   IF BatchTotal <= 0 THEN Exit; { Don't have the batch size, etc. data }

   Pct := tBytes/BatchTotal;
   WriteFast(75,StartLine+8,PadRight(StrFunc(Round(Pct*100))+'%',' ',4),AttrHigh);
   WHILE (BarWrittenB > 0) AND (Round(Pct*32) <= BarWrittenB-1) DO
      BEGIN
         Dec(BarWrittenB);
         WriteFast(43+BarWrittenB,StartLine+8,'',AttrData);
      END;
   WHILE (BarWrittenB < 31) AND (Round(Pct*31) > BarWrittenB) DO
      BEGIN
         WriteFast(43+BarWrittenB,StartLine+8,'',AttrHigh);
         Inc(BarWrittenB);
      END;

   l := BatchTotal-tBytes; { Convert to bytes left }
   IF (fk_Fossil.Baud > 0)
      THEN BEGIN
            Secs := Zmodem_GetCps(Zmodem_GetBytesTx,CurrentSecsFunc-StartTime);
            IF Secs <= 0 THEN Secs := 1;
            Secs := l DIV Secs;
            IF Secs > 359999 THEN Secs := 359999; { 99:59:59 }
            s := LeadingZero(Secs DIV 3600,2)+':'+
                 LeadingZero((Secs MOD 3600) DIV 60,2)+':'+
                 LeadingZero(Secs MOD 60,2);
         END
      ELSE s := '00:00:00';

   WriteFast(54,StartLine+6,PadRight(StrFunc(l)+' bytes',' ',16),AttrData);
   WriteFast(70,StartLine+6,PadRight(s,' ',8),AttrData);

   IF BatchNum = 0
      THEN s := 'File #'+StrFunc(BatchCurrent)+', total unknown'
      ELSE s := 'File #'+StrFunc(BatchCurrent)+' of '+StrFunc(BatchNum);

   WriteFast(54,StartLine+3,PadRight(s,' ',25),AttrData);
END;


PROCEDURE Zmodem_ShowLoc;
VAR l,Secs,i:LongInt; s:String; Pct:Real;
BEGIN
   IF DispName <> '' THEN WriteFast(69,25,PadLeft('Mem: '+StrFunc(MemAvail),' ',11),$17);

   { Display file current position }
   i := CurrentSecsFunc;
   Secs := (i-StartTime);
   IF (fk_Fossil.Baud > 0) AND (i > StartTime)
      THEN BEGIN
            s := LeadingZero(Secs DIV 3600,2)+':'+LeadingZero((Secs MOD 3600) DIV 60,2)+':'+LeadingZero(Secs MOD 60,2);
            WriteFast(54,StartLine+11,PadRight(StrFunc(Zmodem_GetCps(Zmodem_GetBytesTx,Secs)),' ',7),AttrData);
         END
      ELSE BEGIN
            s := '00:00:00';
            WriteFast(54,StartLine+11,'0      ',AttrData);
         END;

   WriteFast(14,StartLine+5,PadRight(StrFunc(FileTx)+' bytes',' ',16),AttrData);
   WriteFast(30,StartLine+5,s,AttrData);

   { Display file remaining }

   IF FileTotal <= 0 THEN Exit; { Don't have the file size, etc. data }

   Pct := FileTx/FileTotal;
   WriteFast(36,StartLine+8,PadRight(StrFunc(Round(Pct*100))+'%',' ',4),AttrHigh);

   WHILE (BarWrittenF > 0) AND (Round(Pct*32) <= BarWrittenF-1) DO
      BEGIN
         Dec(BarWrittenF);
         WriteFast(3+BarWrittenF,StartLine+8,'',AttrData);
      END;
   WHILE (BarWrittenF < 32) AND (Round(Pct*32) > BarWrittenF) DO
      BEGIN
         WriteFast(3+BarWrittenF,StartLine+8,'',AttrHigh);
         Inc(BarWrittenF);
      END;

   l := FileTotal-FileTx; { Convert to bytes left }
   IF (fk_Fossil.Baud > 0)
      THEN BEGIN
            Secs := Zmodem_GetCps(Zmodem_GetBytesTx,Secs);
            IF Secs <= 0 THEN Secs := 1;
            Secs := l DIV Secs;
            IF Secs > 359999 THEN Secs := 359999; { 99:59:59 }
            s := LeadingZero(Secs DIV 3600,2)+':'+
                 LeadingZero((Secs MOD 3600) DIV 60,2)+':'+
                 LeadingZero(Secs MOD 60,2);
         END
      ELSE s := '00:00:00';

   WriteFast(14,StartLine+6,PadRight(StrFunc(l)+' bytes',' ',16),AttrData);
   WriteFast(30,StartLine+6,s,AttrData);
END;


PROCEDURE Zmodem_Errors(w:Word);
BEGIN
   WriteFast(54,StartLine+14,PadRight(StrFunc(w),' ',7),AttrData);
END;


END.
