PROGRAM WB2toWB3;

(* 

    ReneWave v1.00 Widbeta 2 -> Widebeta 3 conversion program 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES DOS, STRINGS, MISC1, CRT, RWSTRUCT;

VAR ConfigFile    : FILE;
    Config        : ConfigRec;

    UserFile      : FILE OF Rw_UserRec;
    User          : Rw_UserRec;

    ScanInfoFile  : FILE OF RwScanInfoRec;
    ScanInfo      : RwScanInfoRec;
    ScanInfoPos   : Word;


PROCEDURE IntroScr;
BEGIN
   ClrScr;
   WritePipe('|16|09|09|01|16');
   WritePipe('|17|09|15 100TO110 - ReneWave v1.00.wb2 -> v1.10 conversion utility                    |08|16');
   WritePipe('|17|09|09 Copyright (C) 1995 by Lars Hellsten, All Rights Reserved                     |08|16');
   WritePipe('|17|09|07 Support - APC MatrixSoft Support BBS (416)494-9237 - 1:250/320 / 50:660/300  |08|16');
   WritePipe('|16|01|08|08|16');
   WritePipe(#13#10);
END;


PROCEDURE ReportErr(Lvl:Word; s:String);
BEGIN
   WritePipe('|16|03Error: |07'+s+#13#10#13#10);
   Halt(Lvl);
END;


PROCEDURE InitFiles;
VAR ch:Char;
BEGIN
   Assign(ConfigFile,'SETUP.RW');
   Reset(ConfigFile,1);
END;


PROCEDURE DeInitFiles;
BEGIN
   Close(ConfigFile);
   WriteLn;
   WriteLn;
   WritePipe('|16|10Conversion from v1.00.wb2 to v1.10 completed successfully.'+#13#10#13#10);
   WritePipe('|16|07You may now delete the *.SCN files in your ReneWave pointers directory, and'+#13#10);
   WritePipe('|16|07remove that directory -- it is no longer needed, the information is now'+#13#10);
   WritePipe('|16|07stored in SCANINFO.RW in your RENEWAVE\ directory.'+#13#10#13#10);
END;


PROCEDURE ConvScan;
VAR UserNum   : LongInt;
    ScnFile   : FILE;
    ScnPos,
    Scn       : Word;
    b         : Boolean;
BEGIN
   IF NOT FExists(Config.RwMainDir+'USERS.RW') THEN ReportErr(1,'USERS.RW not found.');

   Assign(UserFile,Config.RwMainDir+'USERS.RW');
   Reset(UserFile);
   Assign(ScanInfoFile,Config.RwMainDir+'SCANINFO.RW');
   Rewrite(ScanInfoFile);

   WritePipe('|07Converting user base select information: '+#13#10#13#10);
   WritePipe('|07User number: ');
   FOR UserNum := 0 TO (FileSize(UserFile)-1) DO
      BEGIN
         WritePipeXY(14,9,'|15'+StrFunc(UserNum+1)+'|07/|15'+StRFunc(FileSize(UserFile))+'              ');
         Seek(UserFile,UserNum);
         Read(UserFile,User);
         FillChar(ScanInfo,SizeOf(ScanInfo),0);

         IF FExists(Config.RwPtrDir+StrFunc(UserNum)+'.SCN') THEN
            BEGIN
               Assign(ScnFile,Config.RwPtrDir+StrFunc(UserNum)+'.SCN');
               Reset(ScnFile,1);
               Seek(ScnFile,0);
               FOR ScnPos := 0 TO ((FileSize(ScnFile) DIV 3)-1) DO
                  BEGIN
                     BlockRead(ScnFile,Scn,2);
                     BlockRead(ScnFile,b,1);
                     IF b THEN ScanInfo.Bases[(Scn DIV 8)+1] := ScanInfo.Bases[(Scn DIV 8)+1] OR Raise(2,Scn MOD 8);
                  END;
               Close(SCnFile);
            END;

         Seek(ScanInfoFile,UserNum);
         Write(ScanInfoFile,ScanInfo);
      END;

   Close(UserFile);
   Close(ScanInfoFile);
END;


PROCEDURE DoConversion;
VAR Num:Byte; br:Word;
BEGIN
   FillChar(Config,SizeOf(Config),0);
   Seek(ConfigFile,0);
   BlockRead(ConfigFile,Config,SizeOf(Config),br);

   IF Config.RwVer = 110 THEN ReportErr(0,'SETUP.RW already converted!');

   Config.pScnRW       := '|03Current setting: |11Using ReneWave''s own configuration';
   Config.pScnRG       := '|03Current setting: |11Using Renegade''s configuration';
   Config.pQwkRestrict := '|12Your access level does not allow you to use ReneWave''s QWK system!';
   Config.pQwkOn       := '|09ReneWave will now create QWK packets for you';
   Config.pQwkOff      := '|09ReneWave will now create BLUE WAVE packets for you';
   Config.RwVer        := 110;

   ConvScan;

   Seek(ConfigFile,0);
   BlockWrite(ConfigFile,Config,SizeOf(Config));
END;


BEGIN
   IntroScr;
   InitFiles;
   DoConversion;
   DeInitFiles;
END.
