UNIT Timer;

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES DOS,MSTRINGS;


PROCEDURE StartClock;
PROCEDURE StopClock;
FUNCTION  TimeCounter:LongInt;
FUNCTION  TimeStr:String;


IMPLEMENTATION


VAR StartTime,
    StopTime   : LongInt;

    {$IFDEF OS2}
    hh,mm,ss,t : LongInt;
    {$ELSE}
    hh,mm,ss,t : Word;
    {$ENDIF}


PROCEDURE StartClock;
BEGIN
   GetTime(hh,mm,ss,t);
   StartTime := (hh * 3600) + (mm * 60) + ss;
   StartTime := (StartTime * 100) + t;
   StopTime := 0;
END;


PROCEDURE StopClock;
BEGIN
   GetTime(hh,mm,ss,t);
   StopTime := (hh * 3600) + (mm * 60) + ss;
   StopTime := (StopTime * 100) + t;
END;


FUNCTION  TimeCounter:LongInt;
BEGIN
   GetTime(hh,mm,ss,t);
   TimeCounter:= ((hh*3600)+(mm*60)+ss)*100 + t;
END;


FUNCTION TimeStr:String;
BEGIN
   TimeStr := (StrFunc((StopTime-StartTime) DIV 100))+'.'+
              LeadingZero(((StopTime-StartTime) MOD 100),2);
END;


END.
