{$R-,F+,I-,O-}
UNIT MSRGGEN;

(* 

    MSRGGEN - General Renegade file handling/manipulation routines 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES  DOS,MSTRINGS,MISC1,RECORDS;

CONST { Constant sizes/limits/maximums }

      OldExtSize       = 4;
      NewExtSize       = 9;

(*- Data File Variables --------------------------------------------------*)

VAR   MsRg_General     : GeneralRec;                   { RENEGADE.DAT }
      MsRg_GeneralFile : FILE OF GeneralRec;

VAR   MsRg_User        : UserRec;
      MsRg_UserFile    : FILE OF UserRec;              { USERS.DAT }
      MsRg_UserNum     : LongInt;

VAR   MsRg_UserIdxFile : FILE OF UserIdxRec;           { USERS.IDX }
      MsRg_UserIdx     : UserIdxRec;
      MsRg_UserIdxPos  : LongInt;

VAR   MsRg_ConfFile    : FILE OF ConfRec;              { CONFRENC.DAT }
      MsRg_ConfData    : ConfRec;

VAR   MsRg_StringFile  : FILE OF FStringRec;           { STRINGS.DAT }
      MsRg_Strings     : FStringRec;

VAR   MsRg_FAreaFile   : FILE OF UlRec;                { FBASES.DAT }
      MsRg_FArea       : UlRec;
      MsRg_FileBase    : LongInt;

VAR   MsRg_DirFile     : FILE OF UlfRec;               { <basename>.DIR }
      MsRg_Dir         : UlfRec;
      MsRg_FileNum     : LongInt;

VAR   MsRg_ExtFile     : FILE;                          { EXTENDED.DAT }
      MsRg_Ext         : VerbRec;
      MsRg_ExtPos      : LongInt;

VAR   MsRg_HistFile    : FILE OF HistoryRec;           { HISTORY.DAT }
      MsRg_History     : HistoryRec;
      MsRg_HistoryPos  : LongInt;

VAR   MsRg_ScnFile     : FILE OF ScanRec;
      MsRg_Scn         : ScanRec;
      MsRg_ScnPos      : LongInt;

VAR   MsRg_MAreaFile   : FILE OF BoardRec;             { MAREAS.DAT }
      MsRg_MArea       : BoardRec;
      MsRg_MsgArea     : LongInt;

(*- Other Variables ------------------------------------------------------*)

VAR   MsRg_CfgPath     : String;              { Path to CONFIG.TG }
      MsRg_TempPath    : String;

      MsRg_ExtSize     : Byte;                { Length of extended descs. }

      MsRg_Error       : Byte;


{ RENEGADE.DAT - Main system configuration }
PROCEDURE MsRg_GeneralRead;
PROCEDURE MsRg_GeneralWrite;
FUNCTION  MsRg_ArcSearch(ArcExt:String):LongInt;

{ CONFRENC.DAT - Conferences configuration (single record) }
PROCEDURE MsRg_ConfRead;
PROCEDURE MsRg_ConfWrite;

{ FBASES.DAT - File area records }
PROCEDURE MsRg_FAreaOpen;
PROCEDURE MsRg_FAreaClose;
PROCEDURE MsRg_FAreaRead(RecNum:LongInt);
PROCEDURE MsRg_FAreaWrite(RecNum:LongInt);
FUNCTION  MsRg_FAreaGetDir:String;

{ <basename>.DIR - Individual files }
PROCEDURE MsRg_DirFileOpen;
PROCEDURE MsRg_DirFileClose;
PROCEDURE MsRg_DirFileRead(RecNum:LongInt);
PROCEDURE MsRg_DirFileWrite(RecNum:LongInt);

{ EXTENDED.DAT - Extended descriptions }
PROCEDURE MsRg_ExtOpen;
PROCEDURE MsRg_ExtClose;
PROCEDURE MsRg_ExtRead(RecNum:LongInt);
PROCEDURE MsRg_ExtWrite(RecNum:LongInt);

{ STRINGS.DAT - language strings }
PROCEDURE MsRg_StringsRead;
PROCEDURE MsRg_StringsWrite;

{ HISTORY.DAT - System history/usage information from day 1 }
PROCEDURE MsRg_HistFileOpen;
PROCEDURE MsRg_HistFileClose;
PROCEDURE MsRg_HistFileRead(RecNum:LongInt);
PROCEDURE MsRg_HistFileWrite(RecNum:LongInt);

{ <basename>.SCN - Lastread/base selected information for each msg area }
PROCEDURE MsRg_ScnOpen;
PROCEDURE MsRg_ScnClose;
PROCEDURE MsRg_ScnRead(RecNum:LongInt);
PROCEDURE MsRg_ScnWrite(RecNum:LongInt);

{ MAREAS.DAT - Message area information }
PROCEDURE MsRg_MAreaOpen;
PROCEDURE MsRg_MAreaClose;
PROCEDURE MsRg_MAreaRead(RecNum:LongInt);
PROCEDURE MsRg_MAreaWrite(RecNum:LongInt);

{ USERS.IDX - Index of user names }
PROCEDURE MsRg_UserIdxOpen;
PROCEDURE MsRg_UserIdxClose;
PROCEDURE MsRg_UserIdxRead(RecNum:LongInt);
PROCEDURE MsRg_UserIdxWrite(RecNum:LongInt);
FUNCTION  MsRg_UserIdxSearch(Name:String):LongInt;

{ USERS.DAT - Information on each user }
PROCEDURE MsRg_UserFileOpen;
PROCEDURE MsRg_UserFileClose;
PROCEDURE MsRg_UserFileRead(RecNum:LongInt);
PROCEDURE MsRg_UserFileWrite(RecNum:LongInt);


IMPLEMENTATION


{ RENEGADE.DAT - Main system configuration }
PROCEDURE MsRg_GeneralRead;
BEGIN
   Assign(MsRg_GeneralFile,MsRg_CfgPath+'RENEGADE.DAT');
   Reset(MsRg_GeneralFile);
   Seek(MsRg_GeneralFile,0);
   Read(MsRg_GeneralFile,MsRg_General);
   Close(MsRg_GeneralFile);
END;

PROCEDURE MsRg_GeneralWrite;
BEGIN
   Assign(MsRg_GeneralFile,MsRg_CfgPath+'RENEGADE.DAT');
   Reset(MsRg_GeneralFile);
   Seek(MsRg_GeneralFile,0);
   Write(MsRg_GeneralFile,MsRg_General);
   Close(MsRg_GeneralFile);
END;

FUNCTION  MsRg_ArcSearch(ArcExt:String):LongInt;
VAR Found:Boolean; ThisArc:Word;
BEGIN
   Found := FALSE;
   FOR ThisArc := 1 TO MaxArcs DO
      IF MsRg_General.FileArcInfo[ThisArc].Active THEN
         IF (MsRg_General.FileArcInfo[ThisArc].Ext = ArcExt) THEN
            BEGIN
               MsRg_ArcSearch := ThisArc;
               Exit;
            END;
   MsRg_ArcSearch := 0;
END;


{ CONFRENC.DAT - Conferences configuration (single record) }
PROCEDURE MsRg_ConfRead;
BEGIN
   Assign(MsRg_ConfFile,MsRg_General.DataPath+'CONFRENC.DAT');
   Reset(MsRg_ConfFile);
   Seek(MsRg_ConfFile,0);
   Read(MsRg_ConfFile,MsRg_ConfData);
   Close(MsRg_ConfFile);
END;

PROCEDURE MsRg_ConfWrite;
BEGIN
   Assign(MsRg_ConfFile,MsRg_General.DataPath+'CONFRENC.DAT');
   Reset(MsRg_ConfFile);
   Seek(MsRg_ConfFile,0);
   Write(MsRg_ConfFile,MsRg_ConfData);
   Close(MsRg_ConfFile);
END;


{ FBASES.DAT - File area records }
PROCEDURE MsRg_FAreaOpen;
BEGIN
   Assign(MsRg_FAreaFile,MsRg_General.DataPath+'FAREAS.DAT');
   Reset(MsRg_FAreaFile);
   MsRg_FileBase := 0;
END;

PROCEDURE MsRg_FAreaClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_FAreaFile).Mode <> fmClosed THEN Close(MsRg_FAreaFile);
    IF IOResult <> 0 THEN ;
    MsRg_FileBase := -1;
   {$I+}
END;

PROCEDURE MsRg_FAreaRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_FAreaFile) THEN Exit;
   MsRg_FileBase := RecNum;
   IF MsRg_FileBase < 0 THEN MsRg_FileBase := 0;
   Seek(MsRg_FAreaFile,MsRg_FileBase);
   Read(MsRg_FAreaFile,MsRg_FArea)
END;

PROCEDURE MsRg_FAreaWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_FAreaFile) THEN Exit;
   MsRg_FileBase := RecNum;
   IF MsRg_FileBase < 0 THEN MsRg_FileBase := 0;
   Seek(MsRg_FAreaFile,MsRg_FileBase);
   Write(MsRg_FAreaFile,MsRg_FArea)
END;

FUNCTION  MsRg_FAreaGetDir:String;
BEGIN
   IF (fbDirDlPath IN MsRg_FArea.FbStat)
      THEN MsRg_FAreaGetDir := MsRg_FArea.DLPath+MsRg_FArea.FileName
      ELSE MsRg_FAreaGetDir := MsRg_General.DataPath+MsRg_FArea.FileName;
END;


{ <basename>.DIR - Individual files }
PROCEDURE MsRg_DirFileOpen;
BEGIN
   Assign(MsRg_DirFile,MsRg_FAreaGetDir+'.DIR');
   Reset(MsRg_DirFile);
   MsRg_FileNum := 0;
END;

PROCEDURE MsRg_DirFileClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_DirFile).Mode <> fmClosed THEN Close(MsRg_DirFile);
    IF IOResult <> 0 THEN ;
    MsRg_FileNum := -1;
   {$I+}
END;

PROCEDURE MsRg_DirFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_DirFile) THEN Exit;
   MsRg_FileNum := RecNum;
   IF MsRg_FileNum < 0 THEN MsRg_FileNum := 0;
   Seek(MsRg_DirFile,MsRg_FileNum);
   Read(MsRg_DirFile,MsRg_Dir)
END;

PROCEDURE MsRg_DirFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_DirFile) THEN Exit;
   MsRg_FileNum := RecNum;
   IF MsRg_FileNum < 0 THEN MsRg_FileNum := 0;
   Seek(MsRg_DirFile,MsRg_FileNum);
   Write(MsRg_DirFile,MsRg_Dir)
END;


{ EXTENDED.DAT - Extended descriptions }
PROCEDURE MsRg_ExtOpen;
BEGIN
   Assign(MsRg_ExtFile,MsRg_General.DataPath+'EXTENDED.DAT');
   Reset(MsRg_ExtFile);
   MsRg_ExtPos := 0;
END;

PROCEDURE MsRg_ExtClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_ExtFile).Mode <> fmClosed THEN Close(MsRg_ExtFile);
    IF IOResult <> 0 THEN ;
    MsRg_ExtPos := -1;
   {$I+}
END;

PROCEDURE MsRg_ExtRead(RecNum:LongInt);
BEGIN
   IF (RecNum*MsRg_ExtSize*51) >= FileSize(MsRg_ExtFile) THEN Exit;
   MsRg_ExtPos := RecNum*MsRg_ExtSize*51;
   IF MsRg_ExtPos < 0 THEN MsRg_ExtPos := 0;
   Seek(MsRg_ExtFile,MsRg_ExtPos);
   BlockRead(MsRg_ExtFile,MsRg_Ext,MsRg_ExtSize*51);
END;

PROCEDURE MsRg_ExtWrite(RecNum:LongInt);
BEGIN
   IF (RecNum*MsRg_ExtSize*51) > FileSize(MsRg_ExtFile) THEN Exit;
   MsRg_ExtPos := RecNum*MsRg_ExtSize*51;
   IF MsRg_ExtPos < 0 THEN MsRg_ExtPos := 0;
   Seek(MsRg_ExtFile,MsRg_ExtPos);
   BlockWrite(MsRg_ExtFile,MsRg_Ext,MsRg_ExtSize*51);
END;


{ STRINGS.DAT - language strings }
PROCEDURE MsRg_StringsRead;
BEGIN
   Assign(MsRg_StringFile,MsRg_General.DataPath+'STRINGS.DAT');
   Reset(MsRg_StringFile);
   Seek(MsRg_StringFile,0);
   Read(MsRg_StringFile,MsRg_Strings);
   Close(MsRg_StringFile);
END;

PROCEDURE MsRg_StringsWrite;
BEGIN
   Assign(MsRg_StringFile,MsRg_General.DataPath+'STRINGS.DAT');
   Reset(MsRg_StringFile);
   Seek(MsRg_StringFile,0);
   Write(MsRg_StringFile,MsRg_Strings);
   Close(MsRg_StringFile);
END;


{ HISTORY.DAT - System history/usage information from day 1 }
PROCEDURE MsRg_HistFileOpen;
BEGIN
   MsRg_HistoryPos := 0;
   Assign(MsRg_HistFile,AddSlash(MsRg_General.DataPath)+'HISTORY.DAT');
   {$I-} Reset(MsRg_HistFile); {$I+}
   MsRg_Error := IOResult;
END;

PROCEDURE MsRg_HistFileClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_HistFile).Mode <> fmClosed THEN Close(MsRg_HistFile); IF IOResult <> 0 THEN ;
    MsRg_HistoryPos := -1;
   {$I+}
END;

PROCEDURE MsRg_HistFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_HistFile) THEN Exit;
   MsRg_HistoryPos := RecNum;
   IF MsRg_HistoryPos < 0 THEN MsRg_HistoryPos := 0;
   Seek(MsRg_HistFile,MsRg_HistoryPos);
   Read(MsRg_HistFile,MsRg_History)
END;

PROCEDURE MsRg_HistFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_HistFile) THEN Exit;
   MsRg_HistoryPos := RecNum;
   IF MsRg_HistoryPos < 0 THEN MsRg_HistoryPos := 0;
   Seek(MsRg_HistFile,MsRg_HistoryPos);
   Write(MsRg_HistFile,MsRg_History);
END;


{ <basename>.SCN - Lastread/base selected information for each msg area }
PROCEDURE MsRg_ScnOpen;
BEGIN
   Assign(MsRg_ScnFile,MsRg_General.MsgPath+MsRg_MArea.FileName+'.SCN');
   IF FExists(MsRg_General.MsgPath+MsRg_MArea.FileName+'.SCN')
      THEN Reset(MsRg_ScnFile)
      ELSE Rewrite(MsRg_ScnFile);
   MsRg_ScnPos := 0;
END;

PROCEDURE MsRg_ScnClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_ScnFile).Mode <> fmClosed THEN Close(MsRg_ScnFile);
    IF IOResult <> 0 THEN ;
    MsRg_ScnPos := -1;
   {$I+}
END;

PROCEDURE MsRg_ScnRead(RecNum:LongInt);
VAR i:Word;
BEGIN
   IF RecNum >= FileSize(MsRg_ScnFile) THEN
      BEGIN
         MsRg_Scn.NewScan := TRUE;
         MsRg_Scn.Lastread := 0;
         FOR i := FileSize(MsRg_ScnFile) TO RecNum DO
            BEGIN
               Seek(MsRg_ScnFile,i);
               Write(MsRg_ScnFile,MsRg_Scn);
            END;
      END;
   MsRg_ScnPos := RecNum;
   IF MsRg_ScnPos < 0 THEN MsRg_ScnPos := 0;
   Seek(MsRg_ScnFile,MsRg_ScnPos);
   Read(MsRg_ScnFile,MsRg_Scn);
END;

PROCEDURE MsRg_ScnWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_ScnFile) THEN Exit;
   MsRg_ScnPos := RecNum;
   IF MsRg_ScnPos < 0 THEN MsRg_ScnPos := 0;
   Seek(MsRg_ScnFile,MsRg_ScnPos);
   Write(MsRg_ScnFile,MsRg_Scn)
END;


{ MAREAS.DAT - Message area information }
PROCEDURE MsRg_MAreaOpen;
BEGIN
   Assign(MsRg_MAreaFile,MsRg_General.DataPath+'MBASES.DAT');
   Reset(MsRg_MAreaFile);
   MsRg_MsgArea := 0;
END;

PROCEDURE MsRg_MAreaClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_MAreaFile).Mode <> fmClosed THEN Close(MsRg_MAreaFile);
    IF IOResult <> 0 THEN ;
    MsRg_MsgArea := -1;
   {$I+}
END;

PROCEDURE MsRg_MAreaRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_MAreaFile) THEN Exit;
   MsRg_MsgArea := RecNum;
   IF MsRg_MsgArea < 0 THEN MsRg_MsgArea := 0;
   Seek(MsRg_MAreaFile,MsRg_MsgArea);
   Read(MsRg_MAreaFile,MsRg_MArea)
END;

PROCEDURE MsRg_MAreaWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_MAreaFile) THEN Exit;
   MsRg_MsgArea := RecNum;
   IF MsRg_MsgArea < 0 THEN MsRg_MsgArea := 0;
   Seek(MsRg_MAreaFile,MsRg_MsgArea);
   Write(MsRg_MAreaFile,MsRg_MArea)
END;


{ USERS.IDX - Index of user names }
PROCEDURE MsRg_UserIdxOpen;
BEGIN
   Assign(MsRg_UserIdxFile,MsRg_General.DataPath+'USERS.IDX');
   Reset(MsRg_UserIdxFile);
   MsRg_UserIdxPos := 0;
END;

PROCEDURE MsRg_UserIdxClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_UserIdxFile).Mode <> fmClosed THEN Close(MsRg_UserIdxFile);
    IF IOResult <> 0 THEN ;
    MsRg_UserIdxPos := -1;
   {$I+}
END;

PROCEDURE MsRg_UserIdxRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_UserIdxFile) THEN Exit;
   MsRg_UserIdxPos := RecNum;
   IF MsRg_UserIdxPos < 0 THEN MsRg_UserIdxPos := 0;
   Seek(MsRg_UserIdxFile,MsRg_UserIdxPos);
   Read(MsRg_UserIdxFile,MsRg_UserIdx)
END;

PROCEDURE MsRg_UserIdxWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_UserIdxFile) THEN Exit;
   MsRg_UserIdxPos := RecNum;
   IF MsRg_UserIdxPos < 0 THEN MsRg_UserIdxPos := 0;
   Seek(MsRg_UserIdxFile,MsRg_UserIdxPos);
   Write(MsRg_UserIdxFile,MsRg_UserIdx);
END;

FUNCTION  MsRg_UserIdxSearch(Name:String):LongInt;
VAR UserFound:Boolean; TempUNum:LongInt;
BEGIN
   IF FileRec(MsRg_UserIdxFile).Mode = fmClosed THEN
      BEGIN
         MsRg_UserIdxSearch := -1;
         Exit;
      END;

   Name := UpcaseStr(Name);
   TempUNum := 0;
   UserFound := FALSE;
   Reset(MsRg_UserIdxFile);

   WHILE (TempUNum <= (FileSize(MsRg_UserIdxFile)-1)) AND (NOT UserFound) DO
      BEGIN
         MsRg_UserIdxRead(TempUNum);
         UserFound := (NOT MsRg_UserIdx.Deleted) AND (UpcaseStr(MsRg_UserIdx.Name) = Name);
         Inc(TempUNum);
      END;

   IF UserFound
      THEN MsRg_UserIdxSearch := MsRg_UserIdx.Number
      ELSE MsRg_UserIdxSearch := -1;
END;


{ USERS.DAT - Information on each user }
PROCEDURE MsRg_UserFileOpen;
BEGIN
   Assign(MsRg_UserFile,MsRg_General.DataPath+'USERS.DAT');
   Reset(MsRg_UserFile);
   MsRg_UserNum := 0;
END;

PROCEDURE MsRg_UserFileClose;
BEGIN
   {$I-}
    IF FileRec(MsRg_UserFile).Mode <> fmClosed THEN Close(MsRg_UserFile);
    IF IOResult <> 0 THEN ;
    MsRg_UserNum := -1;
   {$I+}
END;

PROCEDURE MsRg_UserFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_UserFile) THEN Exit;
   MsRg_UserNum := RecNum;
   IF MsRg_UserNum < 0 THEN MsRg_UserNum := 0;
   Seek(MsRg_UserFile,MsRg_UserNum);
   Read(MsRg_UserFile,MsRg_User)
END;

PROCEDURE MsRg_UserFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_UserFile) THEN Exit;
   MsRg_UserNum := RecNum;
   IF MsRg_UserNum < 0 THEN MsRg_UserNum := 0;
   Seek(MsRg_UserFile,MsRg_UserNum);
   Write(MsRg_UserFile,MsRg_User);
END;


BEGIN
   MsRg_ExtSize := OldExtSize;
END.





