{$O+,R-,I-}
UNIT MSOBJ;

(* 

    MatrixSoft's Fast Object Menuing Routines v1.00

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


USES FASTW;


TYPE
   TMenuItemType = RECORD
      Char      : Char;         { Item's hotkey character }
      Extended  : Boolean;      { Is the hotkey an extended character? }
      ID        : Word;         { Item's ID number }
      HelpID    : LongInt;      { Item's Help ID number }
      Desc,                     { Item's description on screen }
      Status    : String[80];   { Item's status line description }
      XPos,                     { Item's starting X co-ordinate }
      YPos      : Byte;         { Item's starting Y co-ordinate }
      CharPos   : Byte;         { Item's pos of hotkey char in string }
      AttrNorm,                 { Item's normal attribute }
      AttrHigh,                 { Item's highlighted attribute }
      CharNorm,                 { Item's hotkey normal attribute }
      CharHigh  : Byte;         { Item's hotkey highlighted attribute }
      LinkUp,                   { ID number above this one }
      LinkDown,                 { ID number below this one }
      LinkLeft,                 { ID number left of this one }
      LinkRight : Word;         { ID number right of this one }
   END;

   TMenuItem = Array[1..100] OF TMenuItemType;
   PMenuItem = ^TMenuItem;

   TMenuType = RECORD
      ItemData    : PMenuItem;   { Dynamic array of menu item information }
      ItemNum,                   { Number of total items (starting at 1) }
      ItemAlloc,                 { Number of items allocated memory }
      ItemCurrent : Word;        { Current highlighted item }
      StartX,                    { Co-ordinates of upper left corner }
      StartY,
      EndX,                      { Co-ordinates of lower right corner }
      EndY,
      StatusX,
      StatusY     : Byte;
      Shadow      : Boolean;     { Should shadowing be used? }
      ShadowAttr  : Byte;        { Attribute of shadow }
      Scrollable  : Boolean;
      Title       : String[50];  { Title of menu }
      SavedScreen : ^ScreenType;
   END;
   PMenuType = ^TMenuType;
{
   PListObj = ^TListObj;
   TListObj = OBJECT
      CONSTRUCTOR Init;
      DESTRUCTOR  DeInit;
      PROCEDURE   HandleEvent(VAR Event:TEvent); VIRTUAL;
      PROCEDURE   Draw; VIRTUAL;

   END;


   Board: TBoard;
   Moves: Word;
   Solved: Boolean;
   constructor Load(var S: TStream);
   procedure HandleEvent(var Event: TEvent); Virtual;
   procedure Draw; Virtual;
   function  GetPalette: PPalette; virtual;
   procedure MoveKey(Key: Word);
   procedure MoveTile(Point: TPoint);
   procedure Scramble;
   procedure Store(var S: TStream);
   procedure WinCheck;
}

CONST HelpChar     = #59;

TYPE  HelpProcType     = PROCEDURE(HelpID:Word);
      DosShellProcType = PROCEDURE;

VAR   HelpProc      : HelpProcType;
      DosShellProc  : DosShellProcType;
      MenuError     : Integer;
      CurrentStatus : String;


PROCEDURE Menu_Init(VAR Menu       : PMenuType;
                        StartX,
                        StartY,
                        EndX,
                        EndY,
                        StatusX,
                        StatusY    : Byte;
                        NumItems   : Word;
                        Shadow     : Boolean;
                        MenuTitle  : String);
PROCEDURE Menu_AddItem(VAR Menu          : PMenuType;
                           ItemID        : Word;
                           ItemHelpID    : Integer;
                           ItemChar      : Char;
                           ItemExtended  : Boolean;
                           ItemLinkUp,
                           ItemLinkDown,
                           ItemLinkLeft,
                           ItemLinkRight : Word;
                           ItemXPos,
                           ItemYPos      : Byte;
                           ItemCPos      : Integer;
                           ItemColorSet  : Byte;
                           ItemDesc      : String;
                           ItemStatus    : String);
PROCEDURE Menu_DeInit(Menu:PMenuType);
PROCEDURE Menu_DrawMenu(Menu:PMenuType);
PROCEDURE Menu_DrawItems(Menu:PMenuType);
PROCEDURE Menu_ClearItems(Menu:PMenuType);
PROCEDURE Menu_ClearMenu(Menu:PMenuType);
PROCEDURE Menu_GetChoice(Menu:PMenuType; VAR Choice:Integer);
PROCEDURE Menu_DispText(TheText   : Pointer;
                        x1,y1,
                        x2,y2,
                        MaxLines,
                        NumLines  : Byte;
                        QuitChars : String);
PROCEDURE Menu_EraseStatus(Menu:PMenuType);
PROCEDURE Menu_SetStatus(Menu:PMenuType; s:String);


IMPLEMENTATION


USES  CRT,
      DOS,
      MISC1,
      MSTRINGS,
      CURSOR;


PROCEDURE Menu_Init(VAR Menu       : PMenuType;
                        StartX,
                        StartY,
                        EndX,
                        EndY,
                        StatusX,
                        StatusY    : Byte;
                        NumItems   : Word;
                        Shadow     : Boolean;
                        MenuTitle  : String);

{ Initializes the menu, sets all values accordingly, and allocates memory }
{ to the menu items/choices dynamic array (sorry, I don't like linked     }
{ lists too much, I prefer dynamic arrays, so I didn't use one).          }
{                                                                         }
{ *DO NOT* allocate memory to MENU before you call this, since it does it }
{ for you.                                                                }

BEGIN
   New(Menu);
   New(Menu^.SavedScreen);
   ReadScreen(Menu^.SavedScreen^);

   Menu^.ItemNum     := 0;
   Menu^.StartX      := StartX;
   Menu^.StartY      := StartY;
   Menu^.EndX        := EndX;
   Menu^.EndY        := EndY;
   Menu^.StatusX     := StatusX;
   Menu^.StatusY     := StatusY;
   Menu^.ItemCurrent := 1;
   Menu^.Shadow      := Shadow;
   Menu^.ShadowAttr  := ShadowAttr;
   Menu^.Scrollable  := FALSE;
   Menu^.ItemAlloc   := NumItems;
   Menu^.Title       := MenuTitle;

   Menu_EraseStatus(Menu);

   GetMem(Menu^.ItemData,Menu^.ItemAlloc*SizeOf(TMenuItemType));
END;


PROCEDURE Menu_AddItem(VAR Menu          : PMenuType;
                           ItemID        : Word;
                           ItemHelpID    : Integer;
                           ItemChar      : Char;
                           ItemExtended  : Boolean;
                           ItemLinkUp,
                           ItemLinkDown,
                           ItemLinkLeft,
                           ItemLinkRight : Word;
                           ItemXPos,
                           ItemYPos      : Byte;
                           ItemCPos      : Integer;
                           ItemColorSet  : Byte;
                           ItemDesc      : String;
                           ItemStatus    : String);

{ Adds an individual item to the list - in order for individual items to   }
{ actually be displayed, you must call ClearMenu, and then DrawItems.  If  }
{ all the items on your menu are static (ie. they don't have options that  }
{ could change every time the menu is displayed), then you only need to    }
{ call ClearMenu and DrawItems once, otherwise you need to call them every }
{ time the menu is displayed.                                              }

BEGIN
   IF Menu^.ItemNum >= Menu^.ItemAlloc THEN
      BEGIN
         MenuError := 1;
         Exit;
      END;
   MenuError := 0;

   Inc(Menu^.ItemNum);

   WITH Menu^.ItemData^[Menu^.ItemNum] DO
      BEGIN
         Char     := ItemChar;
         Extended := ItemExtended;
         ID       := ItemID;
         HelpID   := ItemHelpID;
         XPos     := ItemXPos;
         YPos     := ItemYPos;
         CharPos  := ItemCPos;

         CASE ItemColorSet OF
            1 : BEGIN
                   AttrNorm := BoxInfo.AttrOption;
                   AttrHigh := BoxInfo.AttrOptionH;
                   CharNorm := BoxInfo.AttrOptCh;
                   CharHigh := BoxInfo.ATtrOptChH;
                END;
            2 : BEGIN
                   AttrNorm := BoxInfo.AttrOption2;
                   AttrHigh := BoxInfo.AttrOptionH2;
                   CharNorm := BoxInfo.AttrOptCh2;
                   CharHigh := BoxInfo.ATtrOptChH2;
                END;
         END;

         Desc     := ItemDesc;
         Status   := ItemStatus;
         LinkUp   := ItemLinkUp;
         LinkDown := ItemLinkDown;
         LinkLeft := ItemLinkLeft;
         LinkRight:= ItemLinkRight;
      END;
END;


PROCEDURE Menu_ClearMenu(Menu:PMenuType);

{ Clears the centre of the menu - in other words, removes any text that    }
{ was on the menu, and replaces it with spaces, using the attribute        }
{ specified in BoxInfo.AttrMiddle.                                         }

VAR YPosCounter,XPosCounter,StartX,EndX,StartY,EndY:Byte;
BEGIN
   IF Menu^.ItemNum <= 0 THEN
      BEGIN
         MenuError := 1;
         Exit;
      END;
   MenuError := 0;

   StartX := Menu^.StartX; Inc(StartX);
   StartY := Menu^.StartY; Inc(StartY);
   EndX   := Menu^.EndX;   Dec(EndX);
   EndY   := Menu^.EndY;   Dec(EndY);

   ReadScreen(LogicalScreen^);
   FOR YPosCounter := StartY TO EndY DO
      FOR XPosCounter := StartX TO EndX DO
         BEGIN
            LogicalScreen^.Pos[YPosCounter,XPosCounter].Ch   := ' ';
            LogicalScreen^.Pos[YPosCounter,XPosCounter].Attr := BoxInfo.AttrMiddle;
         END;
   WriteScreen(LogicalScreen^);
END;


PROCEDURE Menu_ClearItems(Menu:PMenuType);

{ Clears the area in the centre of the menu where menu items were, in      }
{ other words, removes any menu items from the screen.                     }

VAR CurrItem,
    XPosCounter   : Byte;
BEGIN
   IF Menu^.ItemNum <= 0 THEN
      BEGIN
         MenuError := 1;
         Exit;
      END;
   MenuError := 0;

   ReadScreen(LogicalScreen^);
   FOR CurrItem := 1 TO Menu^.ItemNum DO
      FOR XPosCounter := 1 TO Length(Menu^.ItemData^[CurrItem].Desc) DO
         WITH Menu^.ItemData^[CurrItem],LogicalScreen^ DO
            BEGIN
               Pos[YPos,XPosCounter+XPos-1].Ch   := ' ';
               Pos[YPos,XPosCounter+XPos-1].Attr := BoxInfo.AttrMiddle;
            END;
   WriteScreen(LogicalScreen^);
END;


PROCEDURE Menu_DrawMenu(Menu:PMenuType);

{ Draws the actual box for the menu, including the title, etc.  You must   }
{ have called Menu_Init prior to calling this - it relies on some of the   }
{ data that is initialized there, such as the title, etc.                  }

VAR TXPos,TYPos:Byte;
BEGIN
   WITH Menu^ DO MakeBox(Title,StartX,StartY,EndX,EndY,Shadow);
(*
   ReadScreen(LogicalScreen^);

   WITH LogicalScreen^,BoxInfo,Menu^ DO
     BEGIN
       Pos[StartY,StartX] := TopLeft;
       Pos[EndY  ,StartX] := BotLeft;
       Pos[StartY,EndX  ] := TopRight;
       Pos[EndY  ,EndX  ] := BotRight;

       FOR TXPos := (StartX+1) TO (EndX-1) DO Pos[StartY,TXPos  ] := Top;
       FOR TXPos := (StartX+1) TO (EndX-1) DO Pos[EndY  ,TXPos  ] := Bot;
       FOR TXPos := (StartY+1) TO (EndY-1) DO Pos[TXPos  ,StartX] := Left;
       FOR TXPos := (StartY+1) TO (EndY-1) DO Pos[TXPos  ,EndX  ] := Right;

       IF Title <> '' THEN
          BEGIN
             Pos[StartY,StartX+2]                    := LeftTitle;
             Pos[StartY,StartX+3].Ch                 := ' ';
             Pos[StartY,StartX+3].Attr               := AttrTitle;
             Pos[StartY,StartX+5+Length(Title)]      := RightTitle;
             Pos[StartY,StartX+4+Length(Title)].Ch   := ' ';
             Pos[StartY,StartX+4+Length(Title)].Attr := AttrTitle;
             FOR TXPos := 1 TO Length(Title) DO
               BEGIN
                 Pos[StartY,StartX+3+TXPos].Ch   := Title[TXPos];
                 Pos[StartY,StartX+3+TXPos].Attr := AttrTitle;
               END;
          END;

       FOR TXPos    := (StartX+1) TO (EndX-1) DO
         FOR TYPos := (StartY+1) TO (EndY-1) DO
           BEGIN
             Pos[TYPos,TXPos].Ch   := ' ';
             Pos[TYPos,TXPos].Attr := AttrMiddle;
           END;

       IF Shadow THEN { Draw shadowing }
          BEGIN
             FOR TXPos := (StartX+2) TO (EndX+1) DO
                BEGIN
                   Pos[EndY+1,TXPos].Attr := ShadowAttr;
                   IF StripShading AND (Pos[EndY+1,TXPos].Ch IN [''..'']) THEN Pos[EndY+1,TXPos].Ch := ' ';
                END;
             FOR TYPos := (StartY+1) TO (EndY+1) DO
                BEGIN
                   Pos[TYPos,EndX+1].Attr := ShadowAttr;
                   Pos[TYPos,EndX+2].Attr := ShadowAttr;
                   IF StripShading AND (Pos[TYPos,EndX+1].Ch IN [''..'']) THEN Pos[TYPos,EndX+1].Ch := ' ';
                   IF StripShading AND (Pos[TYPos,EndX+2].Ch IN [''..'']) THEN Pos[TYPos,EndX+2].Ch := ' ';
                END;
          END;
     END;

   WriteScreen(LogicalScreen^);*)
END;


PROCEDURE Menu_DrawItems(Menu:PMenuType);

{ Draws the actual items on the menu - you must have called Menu_Init, as  }
{ well as added some menu items (Menu_AddItem) in order for this to do     }
{ anything.  If your menu has items on it that change often (ie. editing a }
{ configuration for something), you should use ClearMenu and DrawItems     }
{ EVERY time the menu is displayed - at the beginning of your loop would   }
{ be a good place.  See the examples for further details.                  }

VAR ItemCounter   : Word;
    TXPos         : Byte;
BEGIN
   ReadScreen(LogicalScreen^);

   WITH Menu^,LogicalScreen^ DO
      FOR ItemCounter := 1 TO ItemNum DO
         WITH Menu^.ItemData^[ItemCounter] DO
            FOR TXPos := 1 TO Length(Desc) DO
               BEGIN
                  Pos[YPos,XPos+TXPos-1].Ch := Desc[TXPos];
                  IF (TXPos <> CharPos)
                     THEN Pos[YPos,XPos+TXPos-1].Attr := AttrNorm
                     ELSE Pos[YPos,XPos+TXPos-1].Attr := CharNorm;
               END;

   WriteScreen(LogicalScreen^);
END;


PROCEDURE Menu_DeInit(Menu:PMenuType);

{ De-initializes a menu ... do NOT attempt to dispose of MENU before you   }
{ call this, as it takes care of that for you!                             }

BEGIN
   WriteScreen(Menu^.SavedScreen^);
   FreeMem(Menu^.ItemData,Menu^.ItemAlloc*SizeOf(TMenuItemType));
   Dispose(Menu^.SavedScreen);
   Dispose(Menu);
END;


PROCEDURE Menu_GetChoice(Menu:PMenuType; VAR Choice:Integer);

{ Allows the user to select a choice from the menu, using the highlight    }
{ bar, and/or hotkeys (if any are defined).  It then returns the ID number }
{ (which you define when you initialize the menu items) of the selected    }
{ menu item in CHOICE.                                                     }


VAR NewItemNum    : Word;


   FUNCTION GetKey(VAR IsFunction:Boolean):Char;
   VAR Ch:Char;
   BEGIN
      Ch := ReadKey;
      IF (Ch = #0)
         THEN
            BEGIN
               Ch := ReadKey;
               IsFunction := TRUE;
            END
         ELSE
            IsFunction := FALSE;
      GetKey := Upcase(Ch);
   END;


   PROCEDURE DrawHighlight(Num:Word);
   BEGIN
      WITH Menu^.ItemData^[Num] DO
         BEGIN
            WriteFast(XPos,YPos,Desc,AttrHigh);
            IF (CharPos > 0) AND (CharPos <= Length(Desc)) THEN WriteFast(XPos+CharPos-1,YPos,Desc[CharPos],CharHigh);
         END;
      Menu_EraseStatus(Menu);
      Menu_SetStatus(Menu,Menu^.ItemData^[Num].Status);
   END;


   PROCEDURE EraseHighlight(Num:Word);
   BEGIN
      WITH Menu^.ItemData^[Num] DO
         BEGIN
            WriteFast(XPos,YPos,Desc,AttrNorm);
            IF (CharPos > 0) AND (CharPos <= Length(Desc)) THEN WriteFast(XPos+CharPos-1,YPos,Desc[CharPos],CharNorm);
         END;
      Menu_EraseStatus(Menu);
   END;


   FUNCTION FindPrevItemData:Word;
   VAR ThisItem:Word; TempResult:Integer;
   BEGIN
      TempResult := 0;
      IF Menu^.ItemCurrent > 1 THEN WITH Menu^ DO
        BEGIN
           ThisItem := ItemCurrent-1;
           WHILE (ThisItem >= 1) AND
                 (ItemData^[ThisItem].Desc = '') DO
                 Dec(ThisItem);
           IF ItemData^[ThisItem].Desc <> '' THEN TempResult := ThisItem;
        END;
      FindPrevItemData := TempResult;
   END;


   FUNCTION FindNextItemData:Word;
   VAR ThisItem:Word; TempResult:Integer;
   BEGIN
      TempResult := 0;
      IF Menu^.ItemCurrent < Menu^.ItemNum THEN WITH Menu^ DO
        BEGIN
           ThisItem := ItemCurrent+1;
           WHILE (ItemData^[ThisItem].Desc = '') AND
                 (ThisItem <= ItemNum) DO
                 Inc(ThisItem);
           IF ItemData^[ThisItem].Desc <> '' THEN TempResult := ThisItem;
        END;
      FindNextItemData := TempResult;
   END;


   FUNCTION FindItemID(ID:Word):Word;
   VAR ThisItem:Word; TempResult:Word;
   BEGIN
      ThisItem := 1;
      TempResult := 0;
      WHILE (ThisItem <= Menu^.ItemNum) AND (TempResult = 0) DO
         BEGIN
            IF Menu^.ItemData^[ThisItem].ID = ID
               THEN
                  TempResult := ThisItem;
            Inc(ThisItem);
         END;
      FindItemID := TempResult;
   END;


VAR IsValid,
    IsFunction  : Boolean;
    Ch          : Char;
    TempCounter : Word;

BEGIN
   IF Menu^.ItemNum <= 0 THEN
      BEGIN
         MenuError := 1;
         Exit;
      END;

   Choice  := -1;
   IsValid := FALSE;

   IF (Menu^.ItemData^[Menu^.ItemCurrent].Desc = '') THEN
      BEGIN
         IF      (FindNextItemData > 0) THEN Menu^.ItemCurrent := FindNextItemData
         ELSE IF (FindPrevItemData > 0) THEN Menu^.ItemCurrent := FindPrevItemData
         ELSE Exit;
      END;

   DrawHighlight(Menu^.ItemCurrent);

   REPEAT
      FlushKeyboard;
      Ch := GetKey(IsFunction);
      IF IsFunction THEN
         CASE Ch OF
{F1}        #59 : IF Menu^.ItemData^[Menu^.ItemCurrent].HelpId >= 0
                     THEN HelpProc(Menu^.ItemData^[Menu^.ItemCurrent].HelpID);
{ALT-J}     #36 : DosShellProc;
{HOME}      #71 : IF Menu^.ItemCurrent > 1 THEN BEGIN
                     EraseHighlight(Menu^.ItemCurrent);
                     Menu^.ItemCurrent := 1;
                     IF (Menu^.ItemData^[Menu^.ItemCurrent].Desc = '') THEN
                        BEGIN
                           NewItemNum := FindNextItemData;
                           IF NewItemNum > 0 THEN
                              Menu^.ItemCurrent := NewItemNum;
                        END;
                  END;
{END}       #79 : IF Menu^.ItemCurrent < Menu^.ItemNum THEN BEGIN
                     EraseHighlight(Menu^.ItemCurrent);
                     Menu^.ItemCurrent := Menu^.ItemNum;
                     IF (Menu^.ItemData^[Menu^.ItemCurrent].Desc = '') THEN
                        BEGIN
                           NewItemNum := FindPrevItemData;
                           IF NewItemNum > 0 THEN
                              Menu^.ItemCurrent := NewItemNum;
                        END;
                  END;
            ELSE WITH Menu^.ItemData^[Menu^.ItemCurrent] DO BEGIN
{UP}              IF      (Ch = #72) AND (LinkUp IN [1..Menu^.ItemNum]) THEN
                     BEGIN
                        EraseHighlight(Menu^.ItemCurrent);
                        Menu^.ItemCurrent := FindItemID(LinkUp);
                     END
{DOWN}            ELSE IF (Ch = #80) AND (LinkDown IN [1..Menu^.ItemNum]) THEN
                     BEGIN
                        EraseHighlight(Menu^.ItemCurrent);
                        Menu^.ItemCurrent := FindItemID(LinkDown);
                     END
{LEFT}            ELSE IF (Ch = #75) AND (LinkLeft IN [1..Menu^.ItemNum]) THEN
                     BEGIN
                        EraseHighlight(Menu^.ItemCurrent);
                        Menu^.ItemCurrent := FindItemID(LinkLeft);
                     END
{RIGHT}           ELSE IF (Ch = #77) AND (LinkRight IN [1..Menu^.ItemNum]) THEN
                     BEGIN
                        EraseHighlight(Menu^.ItemCurrent);
                        Menu^.ItemCurrent := FindItemID(LinkRight);
                     END
                  ELSE FOR TempCounter := 1 TO Menu^.ItemNum DO
                     IF (Menu^.ItemData^[TempCounter].Extended) AND
                        (Menu^.ItemData^[TempCounter].CharPos > -1) AND
                        (Menu^.ITemData^[TempCounter].Char = Ch) THEN
                        BEGIN
                           EraseHighlight(Menu^.ItemCurrent);
                           IsValid := TRUE;
   {                        Menu^.ItemCurrent := TempCounter;}
                           Choice := Menu^.ItemData^[TempCounter].ID;
                        END;
               END;
         END
      ELSE CASE Ch OF
{ESC}    #27 : BEGIN
                  IsValid := TRUE;
                  Choice := -1;
               END;
{ENTER}  #13 : BEGIN
                  IsValid := TRUE;
                  Choice := Menu^.ItemData^[Menu^.ItemCurrent].ID;
               END;
         ELSE
            FOR TempCounter := 1 TO Menu^.ItemNum DO
               IF (NOT Menu^.ItemData^[TempCounter].Extended) AND
                  (Menu^.ItemData^[TempCounter].CharPos > -1) AND
                  (Menu^.ItemData^[TempCounter].Char = Ch) THEN
                  BEGIN
                     EraseHighlight(Menu^.ItemCurrent);
                     IsValid           := TRUE;
                     Menu^.ItemCurrent := TempCounter;
                     Choice            := Menu^.ItemData^[TempCounter].ID;
                  END;
      END;
      DrawHighlight(Menu^.ItemCurrent);
   UNTIL (IsValid);
END;


PROCEDURE Menu_DispText(TheText   : Pointer;
                        x1,y1,
                        x2,y2,
                        MaxLines,
                        NumLines  : Byte;
                        QuitChars : String);

{ Disiplays a bunch of text at the given co-ordinates.  If the text is     }
{ longer than maxlines, it allows the user to scroll up and down using     }
{ the arrowkeys, pagedown, or home or end to go the beginning or end.      }

TYPE TextArrayType = Array[1..1] OF String[90];
VAR  TextArray  : ^TextArrayType;
     StartLine,
     StopLine,
     ThisLine   : Byte;
     ch         : Char;
BEGIN
   TextArray := TheText;
   StartLine := 1;
   StopLine  := MaxLines;
   IF StopLine > NumLines THEN StopLine := NumLines;
   FOR ThisLine := StartLine TO StopLine DO
      WritePipeXY(x1,y1+ThisLine-1,TextArray^[ThisLine]);
   REPEAT
      ch := ReadKey;
      IF (ch = #0) THEN
         BEGIN
            ch := ReadKey;
            CASE ch OF
               #80,#77 : IF StopLine < NumLines THEN BEGIN { Down }
                        ReadScreen(LogicalScreen^);
                        Scroll(LogicalScreen^,Up,x1,y1+1,x2,y2,' ',16,1);
                        WriteScreen(LogicalScreen^);
                        Inc(StartLine);
                        Inc(StopLine);
                        WritePipeXY(x1,y2,TextArray^[StopLine]);
                     END;
               #72,#75 : IF StartLine > 1 THEN BEGIN { Up }
                        ReadScreen(LogicalScreen^);
                        Scroll(LogicalScreen^,Down,x1,y1,x2,y2-1,' ',16,1);
                        WriteScreen(LogicalScreen^);
                        Dec(StartLine);
                        Dec(StopLine);
                        WritePipeXY(x1,y1,TextArray^[StartLine]);
                     END;
{ HOME }       #71     : IF StartLine > 1 THEN BEGIN
                        FastClr(' ',x1,y1,x2,y2,16);
                        StartLine := 1;
                        StopLine := MaxLines;
                        FOR ThisLine := StartLine TO StopLine DO
                           WritePipeXY(x1,y1+ThisLine-1,TextArray^[ThisLine]);
                     END;
{ END  }       #79     : IF StopLine < NumLines THEN BEGIN
                        FastClr(' ',x1,y1,x2,y2,16);
                        StopLine := NumLines;
                        StartLine := StopLine - MaxLines + 1;
                        FOR ThisLine := StartLine TO StopLine DO
                           WritePipeXY(x1,Y1+(ThisLine-StartLine),TextArray^[ThisLine]);
                     END;
{ PGUP }       #73     : IF StartLine > 1 THEN BEGIN
                        FastClr(' ',x1,y1,x2,y2,16);
                        IF StartLine <= MaxLines
                           THEN StartLine := 1
                           ELSE StartLine := StartLine - MaxLines;
                        StopLine := StartLine + MaxLines - 1;
                        FOR ThisLine := StartLine TO StopLine DO
                           WritePipeXY(x1,Y1+(ThisLine-StartLine),TextArray^[ThisLine]);
                     END;
{ PGDN }       #81     : IF StopLine < NumLines THEN BEGIN
                        FastClr(' ',x1,y1,x2,y2,16);
                        IF StopLine > (NumLines - MaxLines)
                           THEN StopLine := NumLines
                           ELSE StopLine := StopLine + MaxLines;
                        StartLine := StopLine - MaxLines + 1;
                        FOR ThisLine := StartLine TO StopLine DO
                           WritePipeXY(x1,Y1+(ThisLine-StartLine),TextArray^[ThisLine]);
                     END;
            END;
            ch := #0;
         END;
   UNTIL Pos(ch,QuitChars+#13#27) > 0;
END;


PROCEDURE Menu_EraseStatus(Menu:PMenuType);
VAR TempCounter:Byte;
BEGIN
   WriteFast(1,Menu^.StatusY,RepChar(' ',80),StatusAttr);
   CurrentStatus := '';
END;


PROCEDURE Menu_SetStatus(Menu:PMenuType; s:String);
BEGIN
   IF s = '' THEN Exit;
   WriteFast(Menu^.StatusX,Menu^.StatusY,s,StatusAttr);
   CurrentStatus := s;
END;


PROCEDURE DefHelpProc(HelpID:Word); FAR;
BEGIN
END;


PROCEDURE DefDosShellProc; FAR;
BEGIN
END;


{ Called when your program first runs - initializes the BOXINFO variable   }
{ to use the default settings.  This is called before ANY of your code     }
{ is executed, so any changes you make later will still be reflected.      }

BEGIN
   BoxInfo := BoxInfoDefault;
   MenuError := 0;
   HelpProc := DefHelpProc;
   DosShellProc := DefDosShellProc;
END.
