{$F+,O+,I-}
UNIT MSJAM;

(* 

    JAM message base API  
    JAM(mbp) is Copyright 1993 by Joaquim Homrighausen, Andrew Milner, 
    Mats Birch, Mats Wallin. All Rights Reserved.                   

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE

USES  DOS,CRC32,MISC1,MSTRINGS,TGRECORD,UNIXDATE,MYSHARE;

CONST Jam_MaxTxtBuff      = $FFFE;
      Jam_MaxLastReadBuff = 500;

TYPE  Jam_MsInfoType =        { Info for JAM subfields when creating msg }
      RECORD
         OriginAddr,
         DestAddr,
         Sender,
         Receiver,
         Subject       : String[127];
         MSGID,
         REPLYID,
         PID           : String[63];
         NumAttached   : Byte;
         Attach        : Array[1..10] OF String[127];
{         EnclosedFileAlias,
         EnclosedFileRequest,
         EnclosedFileWildcard,
         EnclosedFileList,}
         Flags,
         SenderAlias,                 { These two fields used by }
         ReceiverAlias : String[127]; { Telegard only            }
      END;


VAR   {***  Files and records used for the JAM message bases  ***}

      Jam_IdxFile      : FILE OF JamIndexRec;        { *.JDX file }
      Jam_Idx          : JamIndexRec;
      Jam_PtrFile      : FILE OF JamReadRec;         { *.JLR file }
      Jam_Ptr          : JamReadRec;
      Jam_HdrFile      : FILE;                       { *.JHR file }
      Jam_InfoHdr      : JamInfoRec;
      Jam_MsgHdr       : JamHdrRec;
      Jam_SubField     : JamSubFieldRec;
      Jam_TxtFile      : FILE;                       { *.JDT file }

      {***  Other variables used, not specifically for data files ***}

TYPE  Jam_TxtBuffType  = Array[1..Jam_MaxTxtBuff] OF Char;
VAR   Jam_TxtBuff      : ^Jam_TxtBuffType;
      Jam_TxtBuffSize  : ^Word;

VAR   Jam_SubFieldData : String;  { Subfields could be longer than just a  }
                                  { string, but for our purposes, we won't }
                                  { be using any longer anyway }


      Jam_JdxPos,
      Jam_JlrPos,
      Jam_JhrPos,
      Jam_JdtPos       : LongInt;

      Jam_CreateInfo   : Jam_MsInfoType;

CONST Jam_HeaderLocked : BOOLEAN = FALSE;  { Don't change this!!! }


{ JAM general generic functions }
PROCEDURE MsJam_InitFiles(BaseFile:String);
PROCEDURE MsJam_DeInitFiles;
PROCEDURE MsJam_CreateMessage;
FUNCTION  MsJam_NumMessages:LongInt;

{ JAM message base and individual message header *.JHR manipulation }
PROCEDURE MsJam_ReadInfoHdr;
PROCEDURE MsJam_WriteInfoHdr;
PROCEDURE MsJam_CreateInfoHdr;
PROCEDURE MsJam_ReadHdr(RecNum:LongInt);
PROCEDURE MsJam_WriteHdr(RecNum:LongInt);
PROCEDURE MsJam_ReadSubfields;
PROCEDURE MsJam_ReadSubField(FieldID:LongInt);
PROCEDURE MsJam_WriteSubField;                   { creates it }
FUNCTION  MsJam_LockHdr:Boolean;
FUNCTION  MsJam_UnLockHdr:Boolean;

{ JAM message text file *.JDT manipulation }
PROCEDURE MsJam_ReadText;
PROCEDURE MsJam_WriteText;
PROCEDURE MsJam_WriteTextLine(Line:String);

{ JAM index file *.JDX manipulation }
PROCEDURE MsJam_ReadIdx(RecNum:LongInt);
PROCEDURE MsJam_WriteIdx(RecNum:LongInt);

{ JAM lastread pointer file *.JLR manipulation }
PROCEDURE MsJam_OpenPtr;
PROCEDURE MsJam_ClosePtr;
PROCEDURE MsJam_ReadPtr(RecNum:LongInt);
PROCEDURE MsJam_WritePtr(RecNum:LongInt);
FUNCTION  MsJam_SearchPtr(UserID:LongInt):LongInt;


IMPLEMENTATION

VAR Jam_BaseFile:String[127];

PROCEDURE MsJam_InitFiles(BaseFile:String);
{ Initialize (open) all the *.J?? files }
BEGIN
   Jam_BaseFile := BaseFile;

   Assign(Jam_IdxFile,BaseFile+'.JDX');
   Assign(Jam_HdrFile,BaseFile+'.JHR');
   Assign(Jam_TxtFile,BaseFile+'.JDT');

   FMode(66);

   IF FExists(BaseFile+'.JDX') THEN Reset(Jam_IdxFile)   ELSE Rewrite(Jam_IdxFile);
   IF FExists(BaseFile+'.JHR') THEN Reset(Jam_HdrFile,1) ELSE Rewrite(Jam_HdrFile,1);
   IF FExists(BaseFile+'.JDT') THEN Reset(Jam_TxtFile,1) ELSE Rewrite(Jam_TxtFile,1);

   Jam_JdxPos := 0; Jam_JhrPos := 0; Jam_JdtPos := 0;
END;


PROCEDURE MsJam_DeInitFiles;
{ Deinitialize (close) all the *.J?? files }
BEGIN
   Close(Jam_IdxFile); IF IOResult <> 0 THEN ;
   Close(Jam_HdrFile); IF IOResult <> 0 THEN ;
   Close(Jam_TxtFile); IF IOResult <> 0 THEN ;
   MsJam_ClosePtr;

   Jam_JdxPos := 0; Jam_JhrPos := 0; Jam_JdtPos := 0;
END;


PROCEDURE MsJam_CreateMessage;
{ Adds a new message, assuming you have the text and message header fields }
{ defined already - it'll create the index field, and handle writing the }
{ header and message text }

   PROCEDURE DoSubField(ID:LongInt; Data:String);
   BEGIN
      Jam_SubField.FieldID   := ID;
      Jam_SubField.Reserved1 := 0;
      Jam_SubField.DataLen   := Length(Data);

      Jam_SubFieldData := Data;

      MsJam_WriteSubField;
   END;

BEGIN
   Jam_Idx.UserCRC   := StringCrc(DownCaseStr(Jam_CreateInfo.Sender));
   Jam_Idx.HdrOffset := FileSize(Jam_HdrFile);
   MsJam_WriteIdx(FileSize(Jam_IdxFile));
   MsJam_ReadInfoHdr;

   Jam_MsgHdr.Signature   := 'JAM'+#0;
   Jam_MsgHdr.Revision    := 1;
   Jam_MsgHdr.SubFieldLen := 0;
   Jam_MsgHdr.TimesRead   := 0;
   Jam_MsgHdr.TextOffset  := FileSize(Jam_TxtFile);
   Jam_MsgHdr.TextLen     := 0;
   Jam_MsgHdr.MsgIdCRC    := $FFFFFFFF;
   Jam_MsgHdr.ReplyCRC    := $FFFFFFFF;
   Jam_MsgHdr.MsgNum      := Jam_InfoHdr.BaseMsgNum+FileSize(Jam_IdxFile)-1;

   Jam_InfoHdr.ModifyCount := Jam_InfoHdr.ModifyCount+1;
   Jam_InfoHdr.ActiveMsgs  := Jam_InfoHdr.ActiveMsgs+1;

   MsJam_WriteInfoHdr;
   MsJam_WriteHdr(Jam_JdxPos);

   IF Jam_CreateInfo.OriginAddr           <> '' THEN DoSubField(0000,Jam_CreateInfo.OriginAddr);
   IF Jam_CreateInfo.DestAddr             <> '' THEN DoSubField(0001,Jam_CreateInfo.DestAddr);
   IF Jam_CreateInfo.Sender               <> '' THEN DoSubField(0002,Jam_CreateInfo.Sender);
   IF Jam_CreateInfo.Receiver             <> '' THEN DoSubField(0003,Jam_CreateInfo.Receiver);
   IF Jam_CreateInfo.MSGID                <> '' THEN DoSubField(0004,Jam_CreateInfo.MSGID);
   IF Jam_CreateInfo.REPLYID              <> '' THEN DoSubField(0005,Jam_CreateInfo.REPLYID);
   IF Jam_CreateInfo.Subject              <> '' THEN DoSubField(0006,Jam_CreateInfo.Subject);
   IF Jam_CreateInfo.PID                  <> '' THEN DoSubField(0007,Jam_CreateInfo.PID);
{   IF Jam_CreateInfo.EnclosedFile         <> '' THEN DoSubField(0009,Jam_CreateInfo.EnclosedFile);
   IF Jam_CreateInfo.EnclosedFileAlias    <> '' THEN DoSubField(0010,Jam_CreateInfo.EnclosedFileAlias);
   IF Jam_CreateInfo.EnclosedFileRequest  <> '' THEN DoSubField(0011,Jam_CreateInfo.EnclosedFileRequest);
   IF Jam_CreateInfo.EnclosedFileWildcard <> '' THEN DoSubField(0012,Jam_CreateInfo.EnclosedFileWildcard);
   IF Jam_CreateInfo.EnclosedFileList     <> '' THEN DoSubField(0013,Jam_CreateInfo.EnclosedFileList);  }
   IF Jam_CreateInfo.Flags                <> '' THEN DoSubField(2003,Jam_CreateInfo.Flags);
   IF Jam_CreateInfo.SenderAlias          <> '' THEN DoSubField(5000,Jam_CreateInfo.SenderAlias);
   IF Jam_CreateInfo.ReceiverAlias        <> '' THEN DoSubField(5001,Jam_CreateInfo.ReceiverAlias);

   MsJam_WriteText;
END;


FUNCTION  MsJam_NumMessages:LongInt;
BEGIN
   MsJam_NumMessages := FileSize(Jam_IdxFile);
END;


PROCEDURE MsJam_ReadInfoHdr;
{ Read the INFO record - the header at the very beginning of *.JHR }
VAR br:Word;
BEGIN
   IF FileSize(Jam_HdrFile) < SizeOf(Jam_InfoHdr) THEN
      BEGIN
         MsJam_CreateInfoHdr;
         MsJam_WriteInfoHdr;
         Exit;
      END;
   Seek(Jam_HdrFile,0);
   BlockRead(Jam_HdrFile,Jam_InfoHdr,SizeOf(Jam_InfoHdr));
   Jam_JhrPos := SizeOf(Jam_InfoHdr);
END;


PROCEDURE MsJam_WriteInfoHdr;
{ Write the INFO header record to the beginning of the *.JHR file }
BEGIN
   IF FileSize(Jam_HdrFile) > 0 THEN IF NOT MsJam_LockHdr THEN Exit;
   Seek(Jam_HdrFile,0);
   BlockWrite(Jam_HdrFile,Jam_InfoHdr,SizeOf(Jam_InfoHdr));
   Seek(Jam_HdrFile,0);
   MsJam_UnLockHdr;
   Jam_JhrPos := 0;
END;


PROCEDURE MsJam_CreateInfoHdr;
BEGIN
   FillChar(Jam_InfoHdr,SizeOf(Jam_InfoHdr),#0);
   Jam_InfoHdr.Signature[1] := 'J';
   Jam_InfoHdr.Signature[2] := 'A';
   Jam_InfoHdr.Signature[3] := 'M';
   Jam_InfoHdr.DateCreated := CurrentSecsFunc;
   Jam_InfoHdr.PasswordCRC := -1;
END;


PROCEDURE MsJam_ReadHdr(RecNum:LongInt);
{ Read message header #RecNum (starting at 0) - this routine first reads }
{ from the index file at the specified record to find the proper offset  }
{ to start reading the header at }
VAR BytesRead:Word;
BEGIN
   MsJam_ReadIdx(RecNum);
   IF (Jam_Idx.HdrOffset+SizeOf(Jam_MsgHdr) < FileSize(Jam_HdrFile)+1) AND
      (Jam_Idx.HdrOffset >= 1024) THEN
      BEGIN
         Jam_JhrPos := Jam_Idx.HdrOffset;
         Seek(Jam_HdrFile,Jam_JhrPos);
         BlockRead(Jam_HdrFile,Jam_MsgHdr,SizeOf(Jam_MsgHdr),BytesRead);
      END;
END;


PROCEDURE MsJam_WriteHdr(RecNum:LongInt);
{ Writes the current message header variable to the *.JHR file at message }
{ RECNUM - first checking the index file for the proper offset }
BEGIN
   MsJam_ReadIdx(RecNum);
   IF NOT MsJam_LockHdr THEN Exit;
   Jam_JhrPos := Jam_Idx.HdrOffset;
   Seek(Jam_HdrFile,Jam_JhrPos);
   BlockWrite(Jam_HdrFile,Jam_MsgHdr,SizeOf(Jam_MsgHdr));
   MsJam_UnLockHdr;
END;


FUNCTION MsJam_LockHdr:Boolean;
{ Attempt to lock the message header file for adding/modifying a message }
VAR Counter:Word;
BEGIN
   IF Jam_HeaderLocked OR NOT ShareInstalled THEN
      BEGIN
         MsJam_LockHdr := TRUE;
         Exit; { Already locked }
      END;
   Counter := 500;
   WHILE NOT LockRec(Jam_HdrFile,0,1) AND (Counter > 0) DO
      BEGIN
         RealDelay(10);
         Dec(Counter);
      END;
   Jam_HeaderLocked := Counter > 0;
   MsJam_LockHdr := Jam_HeaderLocked;
END;


FUNCTION MsJam_UnLockHdr:Boolean;
{ Attempt to unlock the message header file }
VAR Counter:Word;
BEGIN
   IF NOT Jam_HeaderLocked OR NOT ShareInstalled THEN
      BEGIN
         MsJam_UnLockHdr := TRUE;
         Exit; { Already unlocked }
      END;
   Counter := 200;
   WHILE NOT UnLockRec(Jam_HdrFile,0,1) AND (Counter > 0) DO
      BEGIN
         RealDelay(10);
         Dec(Counter);
      END;
   Jam_HeaderLocked := Counter = 0;
   MsJAm_UnLockHdr := Jam_HeaderLocked;
END;


PROCEDURE MsJam_ReadSubFields;
VAR BytesRead  : Word;
    FieldLen   : Word;
    DataLen    : Word;
    p          : Pointer;
    SubField   : JamSubFieldRec;
    TempS      : String;
BEGIN
   FillChar(Jam_CreateInfo,SizeOf(Jam_CreateInfo),0);

   WITH Jam_MsgHdr DO
      IF (SubFieldLen < SizeOf(JamSubFieldRec)) OR
         (SubFieldLen+Jam_JhrPos+SizeOf(Jam_MsgHdr) > FileSize(Jam_HdrFile)) OR
         (SubFieldLen = 0)
         THEN Exit;

   IF Jam_MsgHdr.SubFieldLen > $4000 THEN FieldLen := $4000 ELSE FieldLen := Jam_MsgHdr.SubFieldLen;
   GetMem(p,FieldLen);
   Seek(Jam_HdrFile,Jam_JhrPos+SizeOf(Jam_MsgHdr));
   BlockRead(Jam_HdrFile,p^,FieldLen,BytesRead);
   BytesRead := 0;
   REPEAT
      Move(Ptr(Seg(p^),Ofs(p^)+BytesRead)^,SubField,SizeOf(SubField));
      IF SubField.DataLen > 255 THEN DataLen := 255 ELSE DataLen := SubField.DataLen;
      Move(Ptr(Seg(p^),Ofs(p^)+BytesRead+SizeOf(SubField))^,TempS[1],DataLen);
      TempS[0] := Chr(DataLen);
      BytesRead := BytesRead+SizeOf(SubField)+SubField.DataLen;
      CASE SubField.FieldID OF
            0 : Jam_CreateInfo.OriginAddr           := TempS;
            1 : Jam_CreateInfo.DestAddr             := TempS;
            2 : Jam_CreateInfo.Sender               := TempS;
            3 : Jam_CreateInfo.Receiver             := TempS;
            4 : Jam_CreateInfo.MsgID                := TempS;
            5 : Jam_CreateInfo.ReplyID              := TempS;
            6 : Jam_CreateInfo.Subject              := TempS;
            9 : IF FExists(TempS) THEN BEGIN
                   Inc(Jam_CreateInfo.NumAttached);
                   Jam_CreateInfo.Attach[Jam_CreateInfo.NumAttached] := TempS;
                END;
         2003 : Jam_CreateInfo.Flags                := TempS;
      END;
   UNTIL (BytesRead >= FieldLen);
   FreeMem(p,FieldLen);
END;


PROCEDURE MsJam_ReadSubField(FieldID:LongInt);
{ Searches the current message header subfield information for the }
{ specified subfield ID.  If it doesn't find it, it'll return $FFFF }
{ in the subfield ID field, and 0 in the length field. }
VAR BytesRead:LongInt;  TempSField:JamSubFieldRec;  TempS:String;  TempBR:Word;
BEGIN
   FillChar(Jam_SubField,SizeOf(Jam_SubField),0);
   Jam_SubField.FieldID := $FFFF;
   Jam_SubFieldData := '';
   IF (Jam_MsgHdr.SubFieldLen < SizeOf(JamSubFieldRec)) OR
      (Jam_MsgHdr.SubFieldLen+Jam_JhrPos+SizeOf(Jam_MsgHdr) > FileSize(Jam_HdrFile))
      THEN Exit;

   BytesRead := 0;
   Seek(Jam_HdrFile,Jam_JhrPos+SizeOf(Jam_MsgHdr));
   REPEAT
      BlockRead(Jam_HdrFile,TempSField,SizeOf(TempSField),TempBR);  BytesRead := BytesRead + TempBR;
      BlockRead(Jam_HdrFile,TempS[1],TempSField.DataLen,TempBR);    BytesRead := BytesRead + TempBR;
      TempS[0] := Chr(TempBR);
      IF TempSField.FieldID = FieldID THEN
         BEGIN
            Jam_SubField     := TempSField;
            Jam_SubFieldData := TempS;
         END;
   UNTIL (Jam_SubField.FieldID = FieldID) OR (BytesRead >= Jam_MsgHdr.SubFieldLen);
   Seek(Jam_HdrFile,Jam_JhrPos);
END;


PROCEDURE MsJam_WriteSubField;
{ Adds a new subfield, but ONLY if the current message is the last in the }
{ file - these routines were not intended to support additions of subfields }
{ to already existing messages (which AFAIK, would require that the entire }
{ header file be rebuilt, or that the message be deleted and added again at }
{ the end of the header file }
BEGIN
   Jam_MsgHdr.SubFieldLen := Jam_MsgHdr.SubFieldLen+SizeOf(Jam_SubField)+Jam_SubField.DataLen;
   MsJam_WriteHdr(Jam_JdxPos);
   IF NOT MsJam_LockHdr THEN Exit;
   Seek(Jam_HdrFile,FileSize(Jam_HdrFile));
   BlockWrite(Jam_HdrFile,Jam_SubField,SizeOf(Jam_SubField));
   BlockWrite(Jam_HdrFile,Jam_SubFieldData[1],Jam_SubField.DataLen);
   MsJam_UnLockHdr;
END;


PROCEDURE MsJam_ReadText;
VAR TempSize:Word;
BEGIN
   IF ((Jam_MsgHdr.TextOffset+Jam_MsgHdr.TextLen) > FileSize(Jam_TxtFile)) OR
      (Jam_MsgHdr.TextOffset < 0) OR
      (Jam_MsgHdr.TextLen < 0)
      THEN BEGIN
            Jam_TxtBuffSize^ := 0;
            Exit;
         END;
   IF Jam_MsgHdr.TextLen < $FFFE
      THEN Jam_TxtBuffSize^ := Jam_MsgHdr.TextLen
      ELSE Jam_TxtBuffSize^ := $FFFE;
   Seek(Jam_TxtFile,Jam_MsgHdr.TextOffset);
   BlockRead(Jam_TxtFile,Jam_TxtBuff^[1],Jam_TxtBuffSize^);
END;


PROCEDURE MsJam_WriteText;
BEGIN
   IF NOT MsJam_LockHdr THEN Exit;
   Seek(Jam_TxtFile,Jam_MsgHdr.TextOffset+Jam_MsgHdr.TextLen);
   BlockWrite(Jam_TxtFile,Jam_TxtBuff^,Jam_TxtBuffSize^);
   Jam_MsgHdr.TextLen := Jam_MsgHdr.TextLen + Jam_TxtBuffSize^;
   MsJam_WriteHdr(Jam_JdxPos);
   MsJam_UnLockHdr;
END;


PROCEDURE MsJam_WriteTextLine(Line:String);
{ Write one line/string to the file }
BEGIN
   IF NOT MsJam_LockHdr THEN Exit;
   Seek(Jam_TxtFile,Jam_MsgHdr.TextOffset+Jam_MsgHdr.TextLen);
   BlockWrite(Jam_TxtFile,Line[1],Length(Line));
   Jam_MsgHdr.TextLen := Jam_MsgHdr.TextLen + Length(Line);
   MsJam_WriteHdr(Jam_JdxPos);
   MsJam_UnLockHdr;
END;


PROCEDURE MsJam_ReadIdx(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(Jam_IdxFile) THEN Exit;
   Jam_JdxPos := RecNum;
   Seek(Jam_IdxFile,Jam_JdxPos);
   BlockRead(File(Jam_IdxFile),Jam_Idx,1);
END;


PROCEDURE MsJam_WriteIdx(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(Jam_IdxFile) THEN Exit;
   IF NOT MsJam_LockHdr THEN Exit;
   Jam_JdxPos := RecNum;
   Seek(Jam_IdxFile,Jam_JdxPos);
   Write(Jam_IdxFile,Jam_Idx);
   MsJam_UnLockHdr;
END;


PROCEDURE MsJam_OpenPtr;
BEGIN
   Assign(Jam_PtrFile,Jam_BaseFile+'.JLR');
   IF FExists(Jam_BaseFile+'.JLR') THEN Reset(Jam_PtrFile) ELSE Rewrite(Jam_PtrFile);
END;


PROCEDURE MsJam_ClosePtr;
BEGIN
   Close(Jam_PtrFile); IF IOResult <> 0 THEN ;
END;


PROCEDURE MsJam_ReadPtr(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(Jam_PtrFile) THEN EXit;
   Jam_JlrPos := RecNum;
   Seek(Jam_PtrFile,Jam_JlrPos);
   BlockRead(File(Jam_PtrFile),Jam_Ptr,1);
END;


PROCEDURE MsJam_WritePtr(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(JAm_PtrFile) THEN Exit;
   Jam_JlrPos := RecNum;
   Seek(Jam_PtrFile,Jam_JlrPos);
   Write(Jam_PTrFile,Jam_Ptr);
   MsJam_UnLockHdr;
END;


FUNCTION MsJam_SearchPtr(UserID:LongInt):LongInt;
TYPE SearchBuffType = Array[1..Jam_MaxLastReadBuff] OF JamReadRec;
VAR  SearchBuff     : ^SearchBuffType;
     SearchPos,
     SearchMax,
     i,
     BlocksRead     : Word;
     TempRec        : LongInt;
BEGIN
   IF FileSize(Jam_PtrFile) = 0 THEN
      BEGIN
         MsJam_SearchPtr := -1;
         Exit;
      END;

   IF FileSize(Jam_PtrFile) > Jam_MaxLastReadBuff
      THEN SearchMax := Jam_MaxLastReadBuff
      ELSE SearchMax := FileSize(Jam_PtrFile);
   New(SearchBuff);
   TempRec := 0;
   Seek(Jam_PtrFile,0);
   REPEAT
      BlockRead(File(Jam_PtrFile),SearchBuff^,SearchMax,BlocksRead);
      SearchPos := 0;
      REPEAT
         Inc(SearchPos);
         IF SearchBuff^[SearchPos].UserID = UserID THEN
            BEGIN { Found a match }
               Dispose(SearchBuff);
               SearchBuff := NIL;
               MsJam_SearchPtr := TempRec;
               Exit;
            END;
         Inc(TempRec);
      UNTIL (SearchPos = BlocksRead);
   UNTIL Eof(Jam_PtrFile);
   Dispose(SearchBuff);
   SearchBuff := NIL;
   MsJam_SearchPtr := -1;
END;

END.
