{$O+,I-}
UNIT MSBWOVR;

(* 

    MSBWOVR - MatrixSoft Blue Wave Door Generic Code (overlayable)

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


USES MSBWGEN;


FUNCTION  MSBW_GetStatusStr(SInfo:ScanInfoType; STable:ScanTableRec):String;
PROCEDURE MSBW_DeInitAttachList;
PROCEDURE MSBW_QueueGotoEnd;
PROCEDURE MSBW_QueueGetTotals;
PROCEDURE MSBW_EditQueue;
PROCEDURE MSBW_AddAttach(FileName:String; AttachMethod:Byte);

FUNCTION  MSBW_TransferTime(Size:LongInt):String;
PROCEDURE MSBW_GetStatus(MsgNum,LastRead:LongInt);

FUNCTION  MSBW_CheckKeyword:Boolean;
FUNCTION  MSBW_CheckFilter:Boolean;
FUNCTION  MSBW_CheckOwn:Boolean;
FUNCTION  MSBW_CheckPersonal:Boolean;
FUNCTION  MSBW_CheckAll:Boolean;


IMPLEMENTATION


{$IFDEF OS2}
USES MSFOSOS2,MSTRINGS,MISC1;
{$ENDIF}

{$IFDEF WIN32}
USES MSCOMWIN,MSTRINGS,MISC1;
{$ENDIF}

{$IFDEF DOS}
USES MSFOSDOS,MSTRINGS,MISC1;
{$ENDIF}


FUNCTION  MSBW_GetStatusStr(SInfo:ScanInfoType; STable:ScanTableRec):String;
VAR s:String;
BEGIN
   s := '------';
   IF     (scn_PersonalOnly   IN SInfo)           THEN s[1] := 'P';
   IF     (scn_PersonalAll    IN SInfo)           THEN s[1] := 'A';
   IF     (scn_Keywords       IN SInfo)           THEN s[2] := 'K';
   IF     (scn_Filters        IN SInfo)           THEN s[3] := 'F';
   IF     (stb_BundleFirst    IN STable.BaseStat) THEN s[4] := 'B';
   IF     (stb_BundleLast     IN STable.BaseStat) THEN s[4] := 'L';
   IF NOT (stb_UpdatePointers IN STable.BaseStat) THEN s[5] := 'N';
   IF NOT (stb_BundleNew      IN STable.BaseStat) THEN s[6] := 'O';
   MSBW_GetStatusStr := s;
END;


PROCEDURE MSBW_DeInitAttachList;

   PROCEDURE DisposeList(p:PAttachList);
   BEGIN
      IF p^.Next^.Next <> NIL THEN DisposeList(p^.Next);
      Dispose(p^.Next);
      p^.Next := NIL;
   END;

BEGIN
   FAttach := FAttachRoot;
   IF (FAttach <> NIL) THEN
      BEGIN
         IF (FAttach^.Next <> NIL) THEN DisposeList(FAttach);
         Dispose(FAttach);
      END;
   FAttachRoot := NIL;
   FAttach     := NIL;
END;


PROCEDURE MSBW_QueueGotoEnd;
BEGIN
   FAttach := FAttachRoot;
   IF FAttach <> NIL THEN
      WHILE FAttach^.Next <> NIL DO FAttach := FAttach^.Next;
END;


PROCEDURE MSBW_QueueGetTotals;
BEGIN
   FAttachNumI := 0;
   FAttachSizeI := 0;
   FAttach := FAttachRoot;
   WHILE (FAttach <> NIL) DO
      BEGIN
         IF FAttach^.Include THEN
            BEGIN
               FAttachNumI := FAttachNumI+1;
               FAttachSizeI := FATtachSizeI+FAttach^.FileSize;
            END;
         FAttach := FAttach^.Next;
      END;
END;


PROCEDURE MSBW_EditQueue;
VAR i:Word; s,InputStr:String;

    PROCEDURE DispTotals;
    BEGIN
       MSBW_QueueGetTotals;
       MciVars^[6] := StrFunc(FAttachNumI);
       MciVars^[7] := StrFunc(FAttachSizeI);
       MciVars^[8] := MSBW_TransferTime(FAttachSizeI);
       MSBW_WriteColor(MSBW_GetString(288));
       MSBW_WriteColor(MSBW_GetString(289));
    END;

    PROCEDURE Init;
    BEGIN
       MSBW_QueueGetTotals;
       MciVars^[6] := StrFunc(FAttachNumI);
       MciVars^[7] := StrFunc(FAttachSizeI);
       MciVars^[8] := MSBW_TransferTime(FAttachSizeI);
       FAttach := FAttachRoot;
       i := 1;
       MSBW_WriteColor(MSBW_GetString(285));
       MSBW_WriteColor(MSBW_GetString(286));
    END;

    PROCEDURE ToggleStatusStr(ToggleStr:String);
    BEGIN
       ToggleStr := RemoveExtension(UpcaseStr(ToggleStr));
       FAttach := FAttachRoot;
       WHILE (FAttach <> NIL) AND (RemoveExtension(FAttach^.FileName) <> ToggleStr) DO FAttach := FAttach^.Next;
       IF FAttach <> NIL THEN FAttach^.Include := FAttach^.Include XOR TRUE;
    END;

    PROCEDURE ToggleStatusNum(ToggleNum:Word);
    BEGIN
       FAttach := FAttachRoot;
       i := 1;
       WHILE (FAttach <> NIL) AND (i < ToggleNum) DO
          BEGIN
             FAttach := FAttach^.Next;
             Inc(i);
          END;
       IF FAttach <> NIL THEN FAttach^.Include := FAttach^.Include XOR TRUE;
    END;

    PROCEDURE DispQueue;
    BEGIN
       Init;
       WHILE (FAttach <> NIL) DO
          BEGIN
             MciVars^[1] := FAttach^.FileName;
             MciVars^[2] := StrFunc(FAttach^.FileSize);
             MciVars^[3] := MSBW_TransferTime(FAttach^.FileSize);
             MciVars^[4] := '('+StrFunc(i)+')';
             IF FAttach^.Include
                THEN MciVars^[5] := MSBW_GetString(283)
                ELSE MciVars^[5] := MSBW_GetString(284);
             MSBW_WriteColor(MSBW_GetString(287));
             FAttach := FAttach^.Next;
             Inc(i);
          END;
    END;

BEGIN
   IF (FAttachNum = 0) OR (FAttachRoot = NIL) THEN
      BEGIN
         MSBW_WriteColor(MSBW_GetString(292));
         Exit;
      END;
   InputStr := MSBW_GetString(290);
   InputStr := 'LC';
   DispQueue;
   REPEAT
      DispTotals;
      fk_Host.ValidInput := fk_HighBitInput+#13;
      s := fk_ReadLn(50,FALSE);
      s := UpcaseStr(s);
      fk_WriteLn('',1);
      IF s[1] = InputStr[1]
         THEN DispQueue
         ELSE IF ValFunc(s) > 0
            THEN ToggleStatusNum(ValFunc(s))
            ELSE ToggleStatusStr(s);
   UNTIL (s[1] = InputStr[2]) OR (s[1] = #13) OR (s = '');
   MSBW_QueueGotoEnd;
   MSBW_WriteColor(MSBW_GetString(291));
END;


PROCEDURE MSBW_AddAttach(FileName:String; AttachMethod:Byte);
VAR f:FILE;

    FUNCTION CheckDupe:Boolean;
    BEGIN
       IF (FAttachNum > 0) AND (FAttachRoot <> NIL) THEN
          BEGIN
             FAttach := FAttachRoot;
             WHILE FAttach^.Next <> NIL DO
                BEGIN
                   IF (FAttach^.RealFile=FileName) THEN
                      BEGIN
                         CheckDupe := TRUE;
                         Exit;
                      END;
                   FAttach := FAttach^.Next;
                END;
          END;
       CheckDupe := FALSE;
    END;

BEGIN
   FileName := UpcaseStr(FileName);
   IF NOT FExists(FileName) THEN
      BEGIN
         FileName := ExtractFName(FileName);
         IF NOT FExists(FileName) THEN Exit;
      END;
   IF CheckDupe THEN Exit;

   IF (FAttachNum = 0)
      THEN BEGIN
            New(FAttachRoot);
            FAttach := FAttachRoot;
         END
      ELSE BEGIN
            New(FAttach^.Next);
            FAttach := FAttach^.Next;
         END;

   Assign(f,FileName);
   Reset(f,1);
   Inc(FAttachNum);
   FAttachSize := FAttachSize + FileSize(f);
   FillChar(FAttach^,SizeOf(FAttach^),0);
   FAttach^.Next := NIL;
   FAttach^.RealFile := FileName;
   FAttach^.FileName := ExtractFName(FileName);
   FAttach^.FileSize := FileSize(f);
   FAttach^.Include  := FALSE;
   Close(f);
   IF ((stm_IsPersonal IN ScanTableMsg) AND (stm_IsNew IN ScanTableMsg)) OR
      ((AttachMethod=1) AND (stm_IsNew IN ScanTableMsg)) OR (AttachMethod=2) THEN
      BEGIN
         FAttach^.Include := TRUE;
         FAttachNumI := FAttachNumI+1;
         FAttachSizeI := FAttachSizeI+FAttach^.FileSize;
      END;
END;


PROCEDURE MSBW_GetStatus(MsgNum,LastRead:LongInt);
BEGIN
   IF (MsgNum > Lastread)
      THEN ScanTableMsg := [stm_IsNew]
      ELSE ScanTableMsg := [];
   {...}
   IF MSBW_CheckPersonal THEN ScanTableMsg := ScanTableMsg+[stm_IsPersonal];
   IF MSBW_CheckAll      THEN ScanTableMsg := ScanTableMsg+[stm_IsAll];
   IF MSBW_CheckKeyword  THEN ScanTableMsg := ScanTableMsg+[stm_IsKeyword];
   IF MSBW_CheckFilter   THEN ScanTableMsg := ScanTableMsg+[stm_IsFilter];
END;


FUNCTION MSBW_TransferTime(Size:LongInt):String;
VAR TransferSecs:LongInt;
BEGIN
   IF (Size <> 0) AND (fk_Fossil.Baud <> 0)
      THEN TransferSecs := Trunc((Size * 8 / fk_Fossil.Baud) / 0.8)
      ELSE TransferSecs := 0;
   MSBW_TransferTime := StrFunc(TransferSecs DIV 60)+':'+LeadingZero(TransferSecs MOD 60,2);
END;


FUNCTION MSBW_CheckKeyword:Boolean;
VAR i:Byte; TempRes:Boolean;
BEGIN
   TempRes := FALSE;
   FOR i := 1 TO 10 DO
      BEGIN
         IF (TempRes=FALSE) AND (UserKeywords[i] <> '') THEN
            TempRes := (Position(UserKeywords[i],MsgTo) > 0) OR
                       (Position(UserKeywords[i],MsgFrom) > 0) OR
                       (Position(UserKeywords[i],MsgSubj) > 0);
      END;
   MSBW_CheckKeyword := TempRes;
END;


FUNCTION MSBW_CheckFilter:Boolean;
VAR i:Byte;
BEGIN
   FOR i := 1 TO 10 DO
      IF UserFilters[i] <> '' THEN
         IF (Position(UserFilters[i],MsgTo) > 0) OR
            (Position(UserFilters[i],MsgFrom) > 0) OR
            (Position(UserFilters[i],MsgSubj) > 0) THEN
            BEGIN
               MSBW_CheckFilter := TRUE;
               Exit;
            END;
   MSBW_CheckFilter := FALSE;
END;


FUNCTION MSBW_CheckAll:Boolean;
BEGIN
   MSBW_CheckAll := (MsgTo = 'ALL');
END;


FUNCTION MSBW_CheckPersonal:Boolean;
BEGIN
   MSBW_CheckPersonal := (MsgTo = UserNameUpper) OR (MsgTo = UserAliasUpper);
END;


FUNCTION MSBW_CheckOwn:Boolean;
BEGIN
   MSBW_CheckOwn := (MsgFrom = UserNameUpper) OR (MsgFrom = UserAliasUpper);
END;


END.
