UNIT FASTW;

(* 

    FASTW - DOS/OS2/WIN32 screen manipulation routines

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


TYPE  ChAttrRec = RECORD
         Ch   : Char;
         Attr : Byte;
      END;

TYPE  ScreenType = RECORD
         Pos    : Array[1..25,1..80] OF ChAttrRec;
         CursX,
         CursY  : Byte;
      END;

      ScrollType = (Up,Down,Left,Right);

TYPE  BoxInfoType = RECORD
         TopLeft,    TopRight,   BotLeft,  BotRight,
         Top,        Bot,        Left,     Right,

         LeftTitle, RightTitle : ChAttrRec;

         AttrTitle,  AttrMiddle, AttrOption,  AttrOptionH,
         AttrOptCh,  AttrOptChH, AttrOption2, AttrOptionH2,
         AttrOptCh2, AttrOptChH2,

         AttrSetting : Byte;
      END;

CONST BoxInfoDefault : BoxInfoType =
        (TopLeft     : (Ch:''; Attr:$19);  TopRight     : (Ch:''; Attr:$19);
         BotLeft     : (Ch:''; Attr:$19);  BotRight     : (Ch:''; Attr:$19);
         Top         : (Ch:''; Attr:$19);  Bot          : (Ch:''; Attr:$19);
         Left        : (Ch:''; Attr:$19);  Right        : (Ch:''; Attr:$19);
         LeftTitle   : (Ch:''; Attr:$19);  RightTitle   : (Ch:''; Attr:$19);
         AttrTitle   : $B1;                 AttrMiddle   : $17;
         AttrOption  : $17;                 AttrOptionH  : $9F;
         AttrOptCh   : $17;                 AttrOptChH   : $9F;
         AttrOption2 : $1B;                 AttrOptionH2 : $9F;
         AttrOptCh2  : $1B;                 AttrOptChH2  : $9F;
         AttrSetting : $1B);

      BoxInfoMs      : BoxInfoType =
        (TopLeft     : (Ch:''; Attr:$19);  TopRight     : (Ch:''; Attr:$10);
         BotLeft     : (Ch:''; Attr:$19);  BotRight     : (Ch:''; Attr:$10);
         Top         : (Ch:''; Attr:$19);  Bot          : (Ch:''; Attr:$10);
         Left        : (Ch:''; Attr:$19);  Right        : (Ch:''; Attr:$10);
         LeftTitle   : (Ch:''; Attr:$19);  RightTitle   : (Ch:''; Attr:$19);
         AttrTitle   : $B1;                 AttrMiddle   : $10;
         AttrOption  : $17;                 AttrOptionH  : $9F;
         AttrOptCh   : $17;                 AttrOptChH   : $9F;
         AttrOption2 : $1B;                 AttrOptionH2 : $9F;
         AttrOptCh2  : $1B;                 AttrOptChH2  : $9F;
         AttrSetting : $1B);

      BoxInfoJoHo : BoxInfoType =
        (TopLeft     : (Ch:''; Attr:$0B);  TopRight     : (Ch:''; Attr:$0B);
         BotLeft     : (Ch:''; Attr:$0B);  BotRight     : (Ch:''; Attr:$0B);
         Top         : (Ch:''; Attr:$0B);  Bot          : (Ch:''; Attr:$0B);
         Left        : (Ch:''; Attr:$0B);  Right        : (Ch:''; Attr:$0B);
         LeftTitle   : (Ch:''; Attr:$0B);  RightTitle   : (Ch:''; Attr:$0B);
         AttrTitle   : $1E;                 AttrMiddle   : $07;
         AttrOption  : $07;                 AttrOptionH  : $71;
         AttrOptCh   : $07;                 AttrOptChH   : $71;
         AttrOption2 : $03;                 AttrOptionH2 : $71;
         AttrOptCh2  : $03;                 AttrOptChH2  : $71;
         AttrSetting : $03);

      StatusAttr   : Byte = (8*16)+15;
      ShadowAttr   = 8;
      StripShading : Boolean = TRUE;


VAR   BoxInfo       : BoxInfoType;
VAR   LogicalScreen : ^ScreenType;
      Screen        : ^ScreenType;
      VideoSeg      : Word;
      SnowProne     : Boolean;


PROCEDURE Scroll(VAR TScreen : ScreenType; { Screen variable }
                 Direction   : ScrollType; { Direction to scroll in }
                 x1,y1,x2,y2 : Byte;       { Region of screen to scroll }
                 ReplaceCh   : Char;
                 ReplaceAttr,
                 ScrollNum   : Byte);

PROCEDURE WriteFast(x,y:Byte; s:String; Attr:Byte);
PROCEDURE WriteScreen(VAR s:ScreenType); { Read/write from/to a variable,     }
PROCEDURE ReadScreen(VAR s:ScreenType); { taking CGA into consideration      }
PROCEDURE FastClr(ch:Char;               { Character to use (normally space)  }
                  x1,y1,                 { Starting and ending co-ordinates   }
                  x2,y2,                 { of the area of the screen to clear }
                  Attr:Byte);            { Foreground & background attributes }
PROCEDURE HighIntensity(State:Boolean);
PROCEDURE MakeBox(Title:String; StartX,StartY,EndX,EndY:Byte; Shadow:Boolean);
PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr:Byte);


IMPLEMENTATION



{$IFDEF OS2}
   {$I ..\COMMON\FASTWOS2.PAS }
{$ENDIF}

{$IFDEF WIN32}
   {$I ..\COMMON\FASTWWIN.PAS }
{$ENDIF}

{$IFDEF DOS}
   {$I ..\COMMON\FASTWDOS.PAS }
{$ENDIF}


PROCEDURE Scroll(VAR TScreen : ScreenType; { Screen variable }
                 Direction   : ScrollType; { Direction to scroll in }
                 x1,y1,x2,y2 : Byte;       { Region of screen to scroll }
                 ReplaceCh   : Char;
                 ReplaceAttr,
                 ScrollNum   : Byte);

VAR TXPos,TYPos,ThisNum:Byte;
BEGIN
   CASE Direction OF
      Up    : FOR ThisNum := 1 TO ScrollNum DO BEGIN
                 FOR TYPos := y1 TO y2 DO
                    Move(TScreen.Pos[TYPos,x1],
                         TScreen.Pos[TYPos-1,x1],
                         (x2-x1+1)*2);
                 FOR TXPos := x1 TO x2 DO
                    BEGIN
                       TScreen.Pos[y2,TXPos].Ch   := ReplaceCh;
                       TScreen.Pos[y2,TXPos].Attr := ReplaceAttr;
                    END;
              END;
      Down  : FOR ThisNum := 1 TO ScrollNum DO BEGIN
                 FOR TYPos := y2 DOWNTO y1 DO
                    Move(TScreen.Pos[TYPos,x1],
                         TScreen.Pos[TYPos+1,x1],
                         (x2-x1+1)*2);
                 FOR TXPos := x1 TO x2 DO
                    BEGIN
                       TScreen.Pos[y1,TXPos].Ch   := ReplaceCh;
                       TScreen.Pos[y1,TXPos].Attr := ReplaceAttr;
                    END;
              END;
      Left  : FOR ThisNum := 1 TO ScrollNum DO BEGIN
                 FOR TYPos := y1 TO y2 DO
                    FOR TXPos := x1 TO x2 DO
                       Move(TScreen.Pos[TYPos,TXPos],TScreen.Pos[TYPos,TXPos-1],2);
                 FOR TYPos := y1 TO y2 DO
                    BEGIN
                       TScreen.Pos[TYPos,x2].Ch   := ReplaceCh;
                       TScreen.Pos[TYPos,x2].Attr := ReplaceAttr;
                    END;
              END;
      Right : FOR ThisNum := 1 TO ScrollNum DO BEGIN
                 FOR TYPos := y1 TO y2 DO
                    FOR TXPos := x2 DOWNTO x1 DO
                       Move(TScreen.Pos[TYPos,TXPos],TScreen.Pos[TYPos,TXPos+1],2);
                 FOR TYPos := y1 TO y2 DO
                    BEGIN
                       TScreen.Pos[TYPos,x1].Ch   := ReplaceCh;
                       TScreen.Pos[TYPos,x1].Attr := ReplaceAttr;
                    END;
              END;
   END;
END;


PROCEDURE MakeBox(Title:String; StartX,StartY,EndX,EndY:Byte; Shadow:Boolean);
VAR TXPos,TYPos:Byte;
BEGIN
   ReadScreen(LogicalScreen^);

   WITH LogicalScreen^,BoxInfo DO
     BEGIN
       Pos[StartY,StartX] := TopLeft;  { Corners }
       Pos[EndY  ,StartX] := BotLeft;
       Pos[StartY,EndX  ] := TopRight;
       Pos[EndY  ,EndX  ] := BotRight;

       FOR TXPos := (StartX+1) TO (EndX-1) DO Pos[StartY,TXPos  ] := Top;
       FOR TXPos := (StartX+1) TO (EndX-1) DO Pos[EndY  ,TXPos  ] := Bot;
       FOR TYPos := (StartY+1) TO (EndY-1) DO Pos[TYPos ,StartX ] := Left;
       FOR TYPos := (StartY+1) TO (EndY-1) DO Pos[TYPos ,EndX   ] := Right;

       IF Title <> '' THEN
          BEGIN
             Pos[StartY,StartX+2]                    := LeftTitle;
             Pos[StartY,StartX+3].Ch                 := ' ';
             Pos[StartY,StartX+3].Attr               := AttrTitle;
             Pos[StartY,StartX+5+Length(Title)]      := RightTitle;
             Pos[StartY,StartX+4+Length(Title)].Ch   := ' ';
             Pos[StartY,StartX+4+Length(Title)].Attr := AttrTitle;
             FOR TXPos := 1 TO Length(Title) DO
               BEGIN
                 Pos[StartY,StartX+3+TXPos].Ch   := Title[TXPos];
                 Pos[StartY,StartX+3+TXPos].Attr := AttrTitle;
               END;
          END;

       IF Shadow THEN { Draw shadowing }
          BEGIN
             FOR TXPos := (StartX+2) TO EndX DO
                BEGIN
                   Pos[EndY+1,TXPos].Attr := ShadowAttr;
                   IF StripShading AND (Pos[EndY+1,TXPos].Ch IN [''..'']) THEN Pos[EndY+1,TXPos].Ch := ' ';
                END;
             FOR TYPos := (StartY+1) TO (EndY+1) DO
                BEGIN
                   Pos[TYPos,EndX+1].Attr := ShadowAttr;
                   Pos[TYPos,EndX+2].Attr := ShadowAttr;
                   IF StripShading AND (Pos[TYPos,EndX+1].Ch IN [''..'']) THEN Pos[TYPos,EndX+1].Ch := ' ';
                   IF StripShading AND (Pos[TYPos,EndX+2].Ch IN [''..'']) THEN Pos[TYPos,EndX+2].Ch := ' ';
                END;
          END;

       Inc(StartY); Dec(EndY);
       Inc(StartX); Dec(EndX);

       FOR TYPos := StartY TO EndY DO
          FOR TXPos := StartX TO EndX DO
             BEGIN
                Pos[TYPos,TXPos].Ch   := ' ';
                Pos[TYPos,TXPos].Attr := AttrMiddle;
             END;
     END;

   WriteScreen(LogicalScreen^);
END;


BEGIN
{$IFDEF DOS}
   GetVideoSeg;
   Screen := Ptr(VideoSeg,0);
{$ENDIF}
END.




























