program diskfree;
Uses CRT,DOS;
var
  DiskFreeStr : String;

TYPE
{format of extended free space structure}
  ExtendedDisk     = RECORD
                       E_ReturnedSize,              {ret: size of returned structure}
                       E_StructureVersion :WORD;    {call: structure version (0h), ret: actual structure version}
                      {with adjustment for compression:}
                       E_SectorPerCluster,          {number of sectors per cluster}
                       E_BytesPerSector,            {number of bytes per sector}
                       E_Avaible,                   {number of available clusters}
                       E_Total,                     {total number of clusters}
                      {without adjustment for compression:}
                       E_PhysicalAvaible,           {number of physical sectors available}
                       E_PhysicalTotal,             {total number of physical sectors}
                       E_UnitsAvailble,             {number of available allocation units}
                       E_UnitsTotal       :LONGINT; {total allocation units}
                       E_Reserved : ARRAY [0..127] OF BYTE;
                     END;


FUNCTION Call7303(Drive:BYTE;VAR ED:ExtendedDisk):BOOLEAN;
CONST DriveName   : STRING[4] = 'C:\'#0;
VAR Regs          : REGISTERS;
BEGIN
  IF Drive > 0 THEN DriveName[1] := Char(Drive+64);
  WITH ED, Regs DO
  BEGIN
    E_ReturnedSize     := 0;
    E_StructureVersion := 0;
    AX                 := $7303;
    DS                 := Seg(DriveName);
    DX                 := Ofs(DriveName[1]);
    ES                 := Seg(ED);
    DI                 := Ofs(ED);
    CX                 := SizeOf(ED);
    Flags              := 0;
    Intr($21,Regs);
    Call7303 := (Flags AND 1 = 0) AND
                (ED.E_ReturnedSize >= SizeOf(ED)-SizeOf(E_Reserved));
  END;
END; {Call7303}


FUNCTION WinDiskFree(Drive:BYTE):COMP; {zurck.}
VAR ED  :ExtendedDisk;
    Size:COMP;
BEGIN
  IF NOT Call7303(Drive, ED) THEN WinDiskFree := DiskFree(Drive)
  ELSE
  WITH ED DO
  BEGIN
    Size        := 1;
    Size        := Size*E_Avaible*E_SectorPerCluster*E_BytesPerSector;
    WinDiskFree := Size;
  END;
END; {WinDiskFree}


FUNCTION WinDiskSize(Drive:BYTE):COMP;
VAR ED  :ExtendedDisk;
    Size:COMP;
BEGIN
  IF NOT Call7303(Drive, ED) THEN WinDiskSize := DiskSize(Drive)
  ELSE
  WITH ED DO
  BEGIN
    Size        := 1;
    Size        := Size*E_Total*E_SectorPerCluster*E_BytesPerSector;
    WinDiskSize := Size;
  END;
END; {WinDiskSize}

Begin
  ClrScr;

End;