/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.SocketListener;
import de.mud.jta.event.SocketRequest;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Hashtable;

public class MudConnector
extends Plugin
implements VisualPlugin,
Runnable,
ActionListener {
    private static final int debug = 0;
    protected URL listURL = null;
    protected int step;
    protected Hashtable mudList = null;
    protected List mudListSelector = new List();
    protected TextField mudName;
    protected TextField mudAddr;
    protected TextField mudPort;
    protected Button connect;
    protected Panel mudListPanel;
    protected CardLayout layouter;
    protected ProgressBar progress;
    protected Label errorLabel;
    protected Menu MCMenu;

    public MudConnector(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                String url = config.getProperty("MudConnector", id, "listURL");
                if (url != null) {
                    try {
                        MudConnector.this.listURL = new URL(url);
                    }
                    catch (Exception e) {
                        MudConnector.this.error("" + e);
                        MudConnector.this.errorLabel.setText("Error: " + e);
                    }
                } else {
                    MudConnector.this.error("no listURL specified");
                    MudConnector.this.errorLabel.setText("Missing list URL");
                    MudConnector.this.layouter.show(MudConnector.this.mudListPanel, "ERROR");
                }
                String sstep = config.getProperty("MudConnector", id, "step");
                try {
                    MudConnector.this.step = Integer.parseInt(sstep);
                }
                catch (Exception e) {
                    if (sstep != null) {
                        MudConnector.this.error("warning: " + sstep + " is not a number");
                    }
                    MudConnector.this.step = 10;
                }
            }
        });
        bus.registerPluginListener(new SocketListener(){

            public void connect(String host, int port) {
                MudConnector.this.setup();
            }

            public void disconnect() {
                MudConnector.this.setup();
            }
        });
        this.layouter = new CardLayout();
        this.mudListPanel = new Panel(this.layouter){

            public void update(Graphics g) {
                this.paint(g);
            }
        };
        this.errorLabel = new Label("Loading ...");
        this.mudListPanel.add("ERROR", this.errorLabel);
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Loading mud list ... please wait"));
        this.progress = new ProgressBar();
        panel.add("Center", this.progress);
        this.mudListPanel.add("PROGRESS", panel);
        panel = new Panel(new BorderLayout());
        panel.add("Center", this.mudListSelector);
        this.mudListPanel.add("MUDLIST", panel);
        Panel panel2 = panel;
        panel = new Panel(new GridLayout(3, 1));
        panel2.add("East", panel);
        this.mudName = new TextField(20);
        panel.add(this.mudName);
        this.mudName.setEditable(false);
        Panel apanel = new Panel(new BorderLayout());
        this.mudAddr = new TextField(20);
        apanel.add("Center", this.mudAddr);
        this.mudAddr.setEditable(false);
        this.mudPort = new TextField(6);
        apanel.add("East", this.mudPort);
        this.mudPort.setEditable(false);
        panel.add(apanel);
        this.connect = new Button("Connect");
        panel.add(this.connect);
        this.connect.addActionListener(this);
        this.mudListSelector.addActionListener(this);
        this.mudListSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                switch (evt.getStateChange()) {
                    case 1: {
                        String item = MudConnector.this.mudListSelector.getSelectedItem();
                        MudConnector.this.mudName.setText(item);
                        Object[] mud = (Object[])MudConnector.this.mudList.get(item);
                        MudConnector.this.mudAddr.setText((String)mud[0]);
                        MudConnector.this.mudPort.setText(((Integer)mud[1]).toString());
                        break;
                    }
                    case 2: {
                        MudConnector.this.mudName.setText("");
                        MudConnector.this.mudAddr.setText("");
                        MudConnector.this.mudPort.setText("");
                    }
                }
            }
        });
        this.layouter.show(this.mudListPanel, "PROGRESS");
        this.MCMenu = new Menu("MudConnector");
    }

    private void setup() {
        if (this.mudList == null && this.listURL != null) {
            new Thread(this).start();
        }
    }

    public void run() {
        try {
            int token;
            Hashtable<String, Menu> menuList = new Hashtable<String, Menu>();
            this.mudList = new Hashtable();
            BufferedReader r = new BufferedReader(new InputStreamReader(this.listURL.openStream()));
            String line = r.readLine();
            int mudCount = 0;
            try {
                mudCount = Integer.parseInt(line);
            }
            catch (NumberFormatException nfe) {
                this.error("number of muds: " + nfe);
            }
            System.out.println("MudConnector: expecting " + mudCount + " mud entries");
            this.progress.setMax(mudCount);
            StreamTokenizer ts = new StreamTokenizer(r);
            ts.resetSyntax();
            ts.whitespaceChars(0, 9);
            ts.ordinaryChars(32, 255);
            ts.wordChars(32, 255);
            int counter = 0;
            int idx = 0;
            while ((token = ts.nextToken()) != -1) {
                String name = ts.sval;
                token = ts.nextToken();
                if (token != -1) {
                    if (token == 10) {
                        this.error(name + ": unexpected end of line" + ", missing host and port");
                    }
                    String host = ts.sval;
                    Integer port = new Integer(23);
                    token = ts.nextToken();
                    if (token != -1) {
                        try {
                            if (token == 10) {
                                this.error(name + ": default port 23");
                            }
                            port = new Integer(ts.sval);
                        }
                        catch (NumberFormatException nfe) {
                            this.error("port for " + name + ": " + nfe);
                        }
                    }
                    this.mudList.put(name, new Object[]{host, port, new Integer(idx++)});
                    this.mudListSelector.add(name);
                    this.progress.adjust(++counter, name);
                    this.mudListPanel.repaint();
                    Menu subMenu = (Menu)menuList.get(name.charAt(0) + "");
                    if (subMenu == null) {
                        subMenu = new Menu(name.charAt(0) + "");
                        this.MCMenu.add(subMenu);
                        menuList.put(name.charAt(0) + "", subMenu);
                    }
                    MenuItem item = new MenuItem(name);
                    item.addActionListener(this);
                    subMenu.add(item);
                }
                while (token != -1 && token != 10) {
                    token = ts.nextToken();
                }
            }
            System.out.println("MudConnector: found " + this.mudList.size() + " entries");
        }
        catch (Exception e) {
            this.error("error: " + e);
            this.errorLabel.setText("Error: " + e);
            this.layouter.show(this.mudListPanel, "ERROR");
        }
        this.layouter.show(this.mudListPanel, "MUDLIST");
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof MenuItem) {
            String item = evt.getActionCommand();
            int idx = (Integer)((Object[])this.mudList.get(item))[2];
            this.mudListSelector.select(idx);
            this.mudListSelector.makeVisible(idx);
            this.mudName.setText(item);
            Object[] mud = (Object[])this.mudList.get(item);
            this.mudAddr.setText((String)mud[0]);
            this.mudPort.setText(((Integer)mud[1]).toString());
        }
        String addr = this.mudAddr.getText();
        String port = this.mudPort.getText();
        if (addr != null) {
            this.bus.broadcast(new SocketRequest());
            if (port == null || port.length() <= 0) {
                port = "23";
            }
            this.bus.broadcast(new SocketRequest(addr, Integer.parseInt(port)));
        }
    }

    public Component getPluginVisual() {
        return this.mudListPanel;
    }

    public Menu getPluginMenu() {
        return this.MCMenu;
    }

    class ProgressBar
    extends Component {
        int max;
        int current;
        String text;
        Dimension size = new Dimension(250, 20);
        Image backingStore;

        ProgressBar() {
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.backingStore == null) {
                this.backingStore = this.createImage(this.getSize().width, this.getSize().height);
                this.redraw();
            }
            g.drawImage(this.backingStore, 0, 0, this);
        }

        private void redraw() {
            if (this.backingStore == null || this.text == null) {
                return;
            }
            Graphics g = this.backingStore.getGraphics();
            int width = (int)((float)this.current / (float)this.max * (float)this.getSize().width);
            g.fill3DRect(0, 0, this.getSize().width, this.getSize().height, false);
            g.setColor(this.getBackground());
            g.fill3DRect(0, 0, width, this.getSize().height, true);
            g.setColor(this.getForeground());
            g.setXORMode(this.getBackground());
            g.drawString("" + this.current * 100 / (this.max > 0 ? this.max : 1) + "%", this.getSize().width / 2 - 15, this.getSize().height / 2);
            g.drawString(this.text, this.getSize().width / 2 - this.getFontMetrics(this.getFont()).stringWidth(this.text) / 2, this.getSize().height / 2 + 12);
            this.paint(this.getGraphics());
        }

        public void adjust(int value, String name) {
            this.current = value;
            if (this.current > this.max) {
                this.current = this.max;
            }
            this.text = name;
            if ((float)this.current / (float)MudConnector.this.step == (float)(this.current / MudConnector.this.step)) {
                this.redraw();
            }
        }

        public void setSize(int width, int height) {
            this.size = new Dimension(width, height);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public Dimension getMinimumSize() {
            return this.size;
        }
    }
}

